!++
!     Define symbols according to macro values
!--

.IFDEF DEBUG
DBG = /DEBUG
DBGOPT = /NOOPTIMIZE/DEBUG=ALL
.ELSE
DBG = /NODEBUG/NOTRACE
DBGOPT = /OPTIMIZE/DEBUG=(NOSYMBOLS,TRACEBACK)
.ENDIF

.IFDEF LIST
LST = /LIST=[OBJ]
MAP = /MAP=[EXE]/CROSS/FULL
.ELSE
LST = /NOLIST
MAP = /NOMAP
.ENDIF

.IFDEF DIAG
DIA = /DIAGNOSTICS
.ELSE
DIA = /NODIAGNOSTICS
.ENDIF

.IFDEF PCA
PCAOPT = /DEBUG
.ENDIF

!++
!      List of tools used and required symbols
!
!      !PASCAL used
!      !PASCAL environment files used
!      !Executables used
!      !Command Definition utility used - NOTE dependencies have not been resolved
!--

PFLAGS = /FLOAT=D_FLOAT

!++
!     Missing sources catch-all
!--

.DEFAULT
   ! No source found for $(MMS$TARGET)
   ! - Attempting to continue



!++
!   Complete application - default build item
!--

COMPLETE_APPLICATION depends_on -
     [EXE]PQM.EXE
        CONTINUE


!++
!   Miscellaneous
!--

[SRC]VERSION.OPT depends_on -
      PQM_VERSION.TXT -
     !
       perl -w -e "open(V,""PQM_VERSION.TXT""); $_ = <V>; chomp; /'(.*)';/; print ""IDENT=\""$1\""""; close(V)" > version.opt


!++
!   PASCAL with environment file
!--

[OBJ]PQM.OLB(GLOBALDEF=GLOBALDEF.OBJ) PQM_OBJ:GLOBALDEF.PEN depends_on -
      [SRC]GLOBALDEF.PAS -
     ,[SRC]PQM_VERSION.TXT -
     !
       IF "''GLOBALDEF$COMPILED'" .EQS. "" THEN $(PASCAL) /ENVIRONMENT=PQM_OBJ:GLOBALDEF.PEN $(PFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=[OBJ]GLOBALDEF.OBJ [SRC]GLOBALDEF.PAS
       IF "''GLOBALDEF$COMPILED'" .EQS. "" THEN PURGE PQM_OBJ:GLOBALDEF.PEN
       IF "''GLOBALDEF$COMPILED'" .EQS. "" THEN LIBRARY/REPLACE [OBJ]PQM.OLB [OBJ]GLOBALDEF.OBJ
       IF "''GLOBALDEF$COMPILED'" .EQS. "" THEN PURGE [OBJ]GLOBALDEF.OBJ
       GLOBALDEF$COMPILED="DONE"


!++
!   PASCAL
!--

[OBJ]PQM.OLB(BROWSER=BROWSER.OBJ) depends_on -
      [SRC]BROWSER.PAS -
     ,PQM_OBJ:GLOBALDEF.PEN -
     !
       $(PASCAL) $(PFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=[OBJ]BROWSER.OBJ [SRC]BROWSER.PAS
       LIBRARY/REPLACE [OBJ]PQM.OLB [OBJ]BROWSER.OBJ
       PURGE [OBJ]BROWSER.OBJ

[OBJ]PQM.OLB(JOBS=JOBS.OBJ) depends_on -
      PQM_OBJ:GLOBALDEF.PEN -
     ,[SRC]JOBS.PAS -
     !
       $(PASCAL) $(PFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=[OBJ]JOBS.OBJ [SRC]JOBS.PAS
       LIBRARY/REPLACE [OBJ]PQM.OLB [OBJ]JOBS.OBJ
       PURGE [OBJ]JOBS.OBJ

[OBJ]PQM.OLB(PRINT_QUEUE_MANAGER=PQM.OBJ) depends_on -
      PQM_OBJ:GLOBALDEF.PEN -
     ,[SRC]PQM.PAS -
     !
       $(PASCAL) $(PFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=[OBJ]PQM.OBJ [SRC]PQM.PAS
       LIBRARY/REPLACE [OBJ]PQM.OLB [OBJ]PQM.OBJ
       PURGE [OBJ]PQM.OBJ

[OBJ]PQM.OLB(QUEUES=QUEUES.OBJ) depends_on -
      PQM_OBJ:GLOBALDEF.PEN -
     ,[SRC]QUEUES.PAS -
     !
       $(PASCAL) $(PFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=[OBJ]QUEUES.OBJ [SRC]QUEUES.PAS
       LIBRARY/REPLACE [OBJ]PQM.OLB [OBJ]QUEUES.OBJ
       PURGE [OBJ]QUEUES.OBJ


!++
!   Links
!--

[EXE]PQM.EXE depends_on -
      [SRC]PQM.OPT -
     ,[SRC]VERSION.OPT -
     ,[OBJ]PQM.OLB(BROWSER=BROWSER.OBJ) -
     ,[OBJ]PQM.OLB(GLOBALDEF=GLOBALDEF.OBJ) -
     ,[OBJ]PQM.OLB(JOBS=JOBS.OBJ) -
     ,[OBJ]PQM.OLB(PRINT_QUEUE_MANAGER=PQM.OBJ) -
     ,[OBJ]PQM.OLB(PQM_FOREIGN=PQM_FOREIGN.OBJ) -
     ,[OBJ]PQM.OLB(QUEUES=QUEUES.OBJ) -
     !
       LINK $(DBG) $(PCAOPT) /EXE=[EXE]PQM.EXE $(MAP) [SRC]PQM.OPT/OPT,[SRC]VERSION.OPT/OPT


!++
!   Command Definition utility
!--

[OBJ]PQM.OLB(PQM_FOREIGN=PQM_FOREIGN.OBJ) depends_on -
      [SRC]PQM_FOREIGN.CLD -
     !
       SET COMMAND $(CLDFLAGS) $(LST) /OBJ=[OBJ]PQM_FOREIGN.OBJ [SRC]PQM_FOREIGN.CLD
       LIBRARY/REPLACE [OBJ]PQM.OLB [OBJ]PQM_FOREIGN.OBJ
       PURGE [OBJ]PQM_FOREIGN.OBJ




!++
!  Create object library if it doesn't already exist
!--

.FIRST
	! MMS $(mmsqualifiers) $(mmstargets)
       IF F$SEARCH( "[OBJ]PQM.OLB" ) .EQS. "" -
		THEN $(LIBR)/CREATE [OBJ]PQM.OLB

!++
!  End of build cleanup work
!--

.LAST
       CONTINUE

