J $! FTP_NEW.COM - check an ftp directory for new, changed, or removed files $!4 $!  Author: Graham Burley <burley@encompasserve.org> $!" $!	V0.10	22-Nov-2003	Graham Burley $!" $!	V0.11	28-Nov-2003	Graham Burley0 $!		Added MATCH_WILD routine, very minor cleanup $!" $!	V0.12	08-Dec-2003	Graham Burley4 $!		Quote mail recipient so that SMTP addresses work $!" $!	V0.13	30-Jan-2004	Graham Burley $!		Rationalised COPY routines6 $!		Added support for DCL_ASCII and DCL_BINARY actions $!" $!	V0.14	07-Feb-2004	Graham Burley- $!		Disallow config files of .DAT or .HISTORY < $!		Ensure valid mail personals and limit length of subjects$ $!		 and personals to 255 characters= $!		Ensure that temporary files are removed after MAIL or DCL  $!		 actions error; $!		Changed config file parsing to accept any whitespace as 7 $!		 separator, for original strict parsing using tabs: & $!		  $ define FTP_NEW_STRICT_CONFIG 11 $!		Changed defaults for RECURSE & DATES to FALSE  $!" $!	V0.15	10-Feb-2004	Graham Burley- $!		Fixed control_y handling & missing return 8 $!		Added support for remote VMS ftp servers, TYPE param5 $!		Allow null DIR, added FILE, CASE and LIMIT params " $!		Added listing parse validation $!" $	version_string = "FTP_NEW V0.15" $! $!  Known issues: F $!	Combined length of remote node and directory is limited to 254 char7 $!	List parsers do not cope with filenames with spaces!  $!	 $!  Note:  $!	VMS behaviour
 $!	 recursion < $!	  device (or rooted logical) + directory - recursion okay( $!	  relative directory - recursion okay= $!	  logical only (e.g. SYS$LOGIN:) - recursion is disallowed  $!	 filters  $!	  case insensitive default ; $!	  default file spec is *.*; (i.e. not multiple versions) 0 $!	  filters compared with filename excl version $!P $!------------------------------------------------------------------------------ $!$ $	on warning then goto ERROR_HANDLER& $	on control_y then goto ABORT_HANDLER $! $	gosub GET_PARAMS
 $	gosub SETUP  $	gosub GET_LIST $	gosub PROCESS  $	gosub CLEANUP  $! $	exitP $!------------------------------------------------------------------------------ $! Error handler $! $ABORT_HANDLER:  $	$status = "%X0000002C" $ERROR_HANDLER:  $	error_status = $status5 $	set noon		! never get trapped in your error handler 8 $	write sys$error "ERROR in ",f$environment("PROCEDURE")  $	if "''error_message'" .eqs. ""0 $	  then	error_message = f$message(error_status) $	endif 7 $	write sys$error " depth:    ", f$environment("DEPTH") 0 $	write sys$error " location: ''error_location'"- $	write sys$error " status:   ", error_status . $	write sys$error " message:  ", error_message $	if f$trnlnm("FTP_NEW_DUMP")  $	  then	show symbol/local/all $		show logical/process *chan* $	endif  $	gosub CLEANUP  $exit 'error_status'P $!------------------------------------------------------------------------------ $! Procedure cleanup $!	 $CLEANUP:  $	close/nolog cfg_chan $	close/nolog 'tmp_chan' $	close/nolog 'dat_chan' $	close/nolog 'his_chan' $return P $!------------------------------------------------------------------------------ $! Get parameters G $!  Parameters can be passed by symbol, this is required when recursing I $!  directory trees when the procedure calls itself. Otherwise parameters + $!  are loaded from the configuration file.  $! $GET_PARAMS: $	log = "write sys$output"6 $	if "''log_prefix'" .eqs. "" then $log version_string $	if P1 .eqs. """ $	  then	if "''prm_node'" .eqs. ""> $		  then	write sys$error "ERROR: P1 = configuration filename" $			exit %x2 $		  else	gosub INHERIT_PARAMS $		endif $	endif  $ ! % $	set symbol/scope=(nolocal,noglobal)  $ !  $	if P1 .nes. ""% $	  then	cfg_fn = f$parse(P1, ".CFG")  $		if f$search(cfg_fn) .eqs. "" 2 $		  then	write sys$error "ERROR: can't find ", P1 $			exit %x2 $		endif& $		cfg_type = f$parse(cfg_fn,,,"TYPE")> $		if (cfg_type .eqs. ".DAT") .or. (cfg_type .eqs. ".HISTORY")@ $		  then	write sys$error "ERROR: bad configuration filename " -. 				, P1, " - type ", cfg_type, " is reserved" $			exit %x2 $		endif $		gosub LOAD_CONFIG% $		prm_data = f$parse(".DAT", cfg_fn) , $		prm_history = f$parse(".HISTORY", cfg_fn) $	endif  $ !  $	gosub DEFAULT_PARAMS4 $	if "''log_prefix'" .eqs. "" then $gosub LOG_PARAMS $return P $!------------------------------------------------------------------------------ $! $DEFAULT_PARAMS: $	missing_prm = ""H $	if "''prm_data'"    .eqs. "" then $missing_prm = missing_prm + "DATA "K $	if "''prm_history'" .eqs. "" then $prm_history = missing_prm + "HISTORY " H $	if "''prm_node'"    .eqs. "" then $missing_prm = missing_prm + "NODE "5 $	if "''prm_type'"    .eqs. "" then $prm_type    = "" 5 $	if "''prm_dir'"     .eqs. "" then $prm_dir     = "" 5 $	if "''prm_file'"    .eqs. "" then $prm_file    = "" 5 $	if "''prm_user'"    .eqs. "" then $prm_user    = "" 5 $	if "''prm_pass'"    .eqs. "" then $prm_pass    = "" : $	if "''prm_recurse'" .eqs. "" then $prm_recurse = "FALSE": $	if "''prm_dates'"   .eqs. "" then $prm_dates   = "FALSE"5 $	if "''prm_case'"    .eqs. "" then $prm_case    = "" = $	if "''prm_limit'"   .eqs. "" then $prm_limit   = %x7fffffff  $	if missing_prm .nes. "" F $	  then	write sys$error "ERROR: missing parameter(s) - ", missing_prm $		exit %x2  $	endif  $ ! ; $ ! Server type not specified, see if directory implies ...  $ !  $	if prm_type .eqs. ""@ $	  then	if (prm_dir - "[") .nes. prm_dir then $prm_type = "VMS": $		if (prm_dir - ":") .nes. prm_dir then $prm_type = "VMS"; $		if (prm_dir - "/") .nes. prm_dir then $prm_type = "UNIX"  $		if prm_type .eqs. ""  $		  then	prm_type = "UNIX"   $			inf_type = "(using default)"- $		  else	inf_type = "(implied by directory)"  $		endif $	endif  $ !  $ ! UNIX+ $ !  a trailing / on unix dirs is desirable  $ !  $	if (prm_type .eqs. "UNIX") $	  then	if prm_dir .nes. ""A $		  then	if f$extract(f$length(prm_dir)-1, 1, prm_dir) .nes. "/" " $			  then	prm_dir = prm_dir + "/" $				inf_dir = "(modified)" 	 $			endif  $		endif $		if prm_case .eqs. ""  $		  then	prm_case = "TRUE"  $			inf_case = "(UNIX default)"  $		endif $	endif  $ !  $ ! VMS 2 $ !  convert null to [] to aid directory recursion6 $ !  if no []s then disallow recursion as it will fail $ !  $	if (prm_type .eqs. "VMS")  $	  then	if prm_dir .eqs. "" $		  then	prm_dir = "[]" $			inf_dir = "(default)"  $		endif7 $		if prm_recurse .and. ((prm_dir - "[") .eqs. prm_dir)  $		  then	prm_recurse = "FALSE" , $			inf_recurse = "(incompatible directory)" $		endif $		if prm_file .eqs. ""  $		  then	prm_file = "*.*;"  $			inf_file = "(default)" $		endif $		if prm_case .eqs. ""  $		  then	prm_case = "FALSE" $			inf_case = "(VMS default)" $		endif $	endif  $ !  $return P $!------------------------------------------------------------------------------ $! Inherit parameters ; $!  Get local symbol values for parameters passed by symbol  $! $INHERIT_PARAMS: $	prm_data    = prm_data $	prm_history = prm_history  $	prm_node    = prm_node $	prm_type    = prm_type $	prm_dir     = prm_dir  $	prm_file    = prm_file $	prm_user    = prm_user $	prm_pass    = prm_pass $	prm_recurse = prm_recurse  $	prm_dates   = prm_dates  $	prm_case    = prm_case $	prm_limit   = prm_limit  $	prm_actions = prm_actions  $	c = 1  $ INHERIT_PARAMS_LOOP: $	if c .le. prm_actions 7 $	  then	prm_action_'c'_filter  = prm_action_'c'_filter 2 $		prm_action_'c'_routine = prm_action_'c'_routine0 $		prm_action_'c'_param   = prm_action_'c'_param $		c = c + 1 $		goto INHERIT_PARAMS_LOOP  $	endif  $	log_prefix  = "''log_prefix'"  $return P $!------------------------------------------------------------------------------ $LOG_PARAMS:" $	log "Node:           ", prm_node3 $	log "Type:           ", prm_type	, "	''inf_type'" 2 $	log "Directory:      ", prm_dir		, "	''inf_dir'"3 $	log "File:           ", prm_file	, "	''inf_file'" " $	log "User:           ", prm_user= $	log "Password:       ", f$fao("!#(8*#)", prm_pass .nes. "") 9 $	log "Recurse:        ", prm_recurse	, "	''inf_recurse'" # $	log "Compare dates:  ", prm_dates 3 $	log "Case sensitive: ", prm_case	, "	''inf_case'" - $	log "Action limit:   ", f$string(prm_limit) / $	log "Actions:        ", f$string(prm_actions)  $	c = 1  $ LOG_PARAMS_LOOP: $	if c .le. prm_actions E $	  then	log f$fao(" !SL: filter = !AS, routine = !AS, param = !AS" - 7 			, c, prm_action_'c'_filter, prm_action_'c'_routine -  			, prm_action_'c'_param )  $		c = c + 1 $		goto LOG_PARAMS_LOOP  $	endif " $	log "Data file:      ", prm_data% $	log "History file:   ", prm_history  $return P $!------------------------------------------------------------------------------ $! Load configuration from file G $!  The configuration file consists of keys and values seprated by tabs  $! $! TODO: validate bools  $!
 $LOAD_CONFIG:   $	log "Configuration:  ", cfg_fn $	prm_actions = 0 & $	if f$trnlnm("FTP_NEW_STRICT_CONFIG") $	  then	cfg_strict = 1  $		cfg_sep = f$fao("!_") $	  else	cfg_strict = 0  $		cfg_sep = " " $	endif 4 $	cfg_keys = "<NODE><TYPE><DIR><FILE><USER><PASS>" -, 			+ "<RECURSE><DATES><CASE><LIMIT><ACTION>" $	cfg_types = "<UNIX><VMS>" ( $	cfg_actions = "<NULL><MAIL><NOTIFY>" -( 			+ "<COPY><COPY_ASCII><COPY_BINARY>" -# 			+ "<DCL><DCL_ASCII><DCL_BINARY>"  $	cfg_errors = 0 $	close/nolog cfg_chan $	open/read cfg_chan 'cfg_fn'  $ LOAD_CONFIG_LOOP: + $	read/end=LOAD_CONFIG_END cfg_chan cfg_rec  $	if cfg_strict 4 $	  then	cfg_rec = f$edit(cfg_rec, "TRIM,UNCOMMENT")= $	  else	cfg_rec = f$edit(cfg_rec, "TRIM,COMPRESS,UNCOMMENT")  $	endif 1 $	if cfg_rec .eqs. "" then $goto LOAD_CONFIG_LOOP < $	cfg_key = f$edit(f$element(0, cfg_sep, cfg_rec), "UPCASE")8 $	if ( cfg_keys - ("<" + cfg_key + ">") ) .eqs. cfg_keys8 $	  then	write sys$error "ERROR: invald key - ", cfg_key $		cfg_errors = cfg_errors + 1 $		goto LOAD_CONFIG_LOOP $	endif  $	c = 1 	 $	tok = 0  $  VAL_LOOP: $	cfg_val = ""& $	tmp = f$element(c, cfg_sep, cfg_rec) $	if tmp .nes. cfg_sep $	  then	if tmp .nes. "" $		  then	tok_'tok' = tmp  $			tok = tok + 1  $		endif $		c = c + 1 $		goto VAL_LOOP $	endif  $  ! $	if tok .eq. 0 8 $	  then	write sys$error "ERROR: no value for ", cfg_key $		cfg_errors = cfg_errors + 1 $		goto LOAD_CONFIG_LOOP $	endif  $  ! $	if cfg_key .eqs. "ACTION" 	 $	  then	  $		if tok .lt. 2? $		  then	write sys$error "ERROR: insufficient args for action" & $			write sys$error " \", cfg_rec, "\" $			cfg_errors = cfg_errors + 1  $			goto LOAD_CONFIG_LOOP  $		endif' $		tok_1 = f$edit(tok_1, "TRIM,UPCASE") = $		if ( cfg_actions - ("<" + tok_1 + ">") ) .eqs. cfg_actions A $		  then	write sys$error "ERROR: unknown action routine ", tok_1  $			cfg_errors = cfg_errors + 1  $			goto LOAD_CONFIG_LOOP  $		endif  $		prm_actions = prm_actions + 1+ $		prm_action_'prm_actions'_filter  = tok_0 + $		prm_action_'prm_actions'_routine = tok_1  $		if tok .gt. 21 $		  then	prm_action_'prm_actions'_param  = tok_2 . $		  else	prm_action_'prm_actions'_param  = "" $		endif $	  else	prm_'cfg_key' = tok_0 $	endif  $	if cfg_key .eqs. "TYPE" . $	  then	prm_type = f$edit(prm_type, "UPCASE")< $		if ( cfg_types - ("<" + prm_type + ">") ) .eqs. cfg_types; $		  then	write sys$error "ERROR: invald type - ", prm_type  $			cfg_errors = cfg_errors + 1  $		endif $	endif  $	if cfg_key .eqs. "LIMIT") $	  then	if f$type(tok_0) .nes. "INTEGER" = $		  then	write sys$error "ERROR: not an integer ", cfg_key -  				, " - ", tok_0 $			cfg_errors = cfg_errors + 1 & $		  else	prm_limit = f$integer(tok_0) $		endif $	endif  $	goto LOAD_CONFIG_LOOP  $ LOAD_CONFIG_END: $	close/nolog cfg_chan% $	if cfg_errors .gt. 0 then $exit %x2  $return P $!------------------------------------------------------------------------------ $! Procedure setup $! $SETUP: % $	sep = f$fao("!_")	! field separator  $ ! % $	dcl_fn = f$environment("PROCEDURE") % $	dcl_name = f$parse(dcl_fn,,,"NAME") $ $	dcl_depth = f$environment("DEPTH") $ ! 6 $	log_level = f$integer(f$trnlnm("''dcl_name'_DEBUG")) $	log_prefix = "''log_prefix'" $	if log_level .eq. 0 4 $	  then	log = "write sys$output ""''log_prefix'"","$ $	  else	log = "write sys$output " -4 			+ """''dcl_name'(''dcl_depth'): ''log_prefix'""," $	endif  $ !  $	log1 = "!" $	log2 = "!"& $	if log_level .ge. 1 then $log1 = log& $	if log_level .ge. 2 then $log2 = log% $	log1 f$fao("!AS at !%D", dcl_fn, 0)  $ ! I $	tmp_fn = f$fao("!AS_!AS_!SL", dcl_name, f$getjpi("", "PID"), dcl_depth) / $	tmp_fn = f$parse("sys$scratch:.tmp;", tmp_fn) ; $	tmp_chan = f$fao("!AS_tmp_chan_!SL", dcl_name, dcl_depth)  $ ! = $	if f$search(prm_data) .eqs. "" then $gosub CREATE_DATA_FILE ; $	dat_chan = f$fao("!AS_dat_chan_!SL", dcl_name, dcl_depth) 3 $	open/read/write/share=write 'dat_chan' 'prm_data'  $ ! ; $	his_chan = f$fao("!AS_his_chan_!SL", dcl_name, dcl_depth) # $	if f$search(prm_history) .eqs. "" : $	  then	append/new/alloc=180/extend=180 nl: 'prm_history' $	endif 2 $	open/append/share=write 'his_chan' 'prm_history' $ !  $return P $!------------------------------------------------------------------------------ $CREATE_DATA_FILE:! $	create/fdl=sys$input 'prm_data'  $DECK 0 IDENT	"30-OCT-2003 22:48:16  OpenVMS FDL Editor"   SYSTEM 	SOURCE			"OpenVMS"    FILE 	ORGANIZATION		indexed   RECORD! 	CARRIAGE_CONTROL	carriage_return  	FORMAT			variable 	SIZE			1024   AREA 0 	ALLOCATION		228 	BEST_TRY_CONTIGUOUS	yes 	BUCKET_SIZE		15 	EXTENSION		60   AREA 1 	ALLOCATION		30  	BEST_TRY_CONTIGUOUS	yes 	BUCKET_SIZE		15 	EXTENSION		15   KEY 0 
 	CHANGES			no 
 	DATA_AREA		0  	DATA_FILL		100  	DATA_KEY_COMPRESSION	yes  	DATA_RECORD_COMPRESSION	yes 	DUPLICATES		no  	INDEX_AREA		1 	INDEX_COMPRESSION	no  	INDEX_FILL		100 	LEVEL1_INDEX_AREA	1 	PROLOG			3  	SEG0_LENGTH		255  	SEG0_POSITION		0  	TYPE			string $EOD $return P $!------------------------------------------------------------------------------5 $! Get an ftp full listing from somewhere into tmp_fn  $!
 $GET_LIST:' $	log prm_node, "::", prm_dir, prm_file  $	gosub ADD_CONTROL  $	ls_stamp = f$cvtime()  $	if prm_user .eqs. "" $	  then	ls_node = prm_node ; $	  else	ls_node = "''prm_node'""''prm_user' ''prm_pass'"""  $	endif 1 $	if (prm_dir .eqs. "") .and. (prm_file .eqs. "")  $	  then	ls_spec = "" . $	  else	ls_spec = """''prm_dir'''prm_file'""" $	endif ! $	define/user sys$output 'tmp_fn' 
 $ set noon# $	dir/ftp/full 'ls_node'::'ls_spec'  $	ftp_status = $status $ set on1 $	if f$message(ftp_status, "SEVERITY") .eqs. "%S" ) $	  then	log1 "ftp_status = ", ftp_status  $		c_last = ls_stamp- $		if c_first .eqs. "" then $c_first = c_last  $		gosub PARSE $		gosub UPDATE_CONTROL 5 $	  else	log "ftp status = ", ftp_status, " (FAILED)"  $	endif  $return P $!------------------------------------------------------------------------------' $! Parse the ftp full listing in tmp_fn  $! $PARSE:  $!3 $	parse_months = "<Jan><Feb><Mar><Apr><May><Jun>" - % 			+ "<Jul><Aug><Sep><Oct><Nov><Dec>"  $	log1 "PARSE: ", tmp_fn $	close/nolog 'tmp_chan' $	open/read 'tmp_chan' 'tmp_fn' 
 $ PARSE_LOOP: , $	read/end=PARSE_LOOP_END 'tmp_chan' tmp_rec+ $	if tmp_rec .eqs. "" then $goto PARSE_LOOP  $	log1 "rec: ", tmp_rec , $	tmp_rec = f$edit(tmp_rec, "TRIM,COMPRESS")# $	tmp0 = f$element(0, " ", tmp_rec) # $	tmp1 = f$element(1, " ", tmp_rec)  $  !" $	tmp0_up = f$edit(tmp0, "UPCASE")0 $	if tmp0_up .eqs. "TOTAL" then $goto PARSE_LOOP4 $	if tmp0_up .eqs. "DIRECTORY" then $goto PARSE_LOOP $  ! $	parse_status = 0 $	gosub PARSE_'prm_type' $  !> $	if parse_status .eq. -1 then $log "ERROR parsing: ", tmp_rec $	if parse_status .eq. 1 $	  then	log1 " file: ", f_name g $		log1 f$fao("  now: !AS bytes = !AS, date = !AS !AS !AS", ls_stamp, f_bytes, f_month, f_day, f_dmore)  $		gosub STORE $	endif  $	goto PARSE_LOOP  $ PARSE_LOOP_END:  $	close 'tmp_chan' $	delete/nolog 'tmp_fn'* $return P $!------------------------------------------------------------------------------ $PARSE_UNIX: $	if f$length(tmp0) .ne. 10  $	  then	parse_status = -1 $		goto PARSE_UNIX_DONE  $	endif  $  ! $  ! Directory $  ! $	tmp01 = f$extract(0, 1, tmp0) - $	if (tmp01 .eqs. "d") .or. (tmp01 .eqs. "l") , $	  then	r_name = f$element(8, " ", tmp_rec)1 $		if (r_name .eqs. ".") .or. (r_name .eqs. "..")  $		  then	goto PARSE_UNIX_DONE $		endif $		if prm_recurse ( $		  then	log1 " sub-directory ", r_name $			saved_prm_dir = prm_dirc" $			log_prefix = log_prefix + "  "$ $			prm_dir = prm_dir + r_name + "/"
 $			@'dcl_fn'b $			prm_dir = saved_prm_dir " $			log_prefix = log_prefix - "  " $		endif $		goto PARSE_UNIX_DONEl $	endifd $  !& $	f_name  = f$element(8, " ", tmp_rec)& $	f_bytes = f$element(4, " ", tmp_rec)& $	f_month = f$element(5, " ", tmp_rec)& $	f_day   = f$element(6, " ", tmp_rec)& $	f_dmore = f$element(7, " ", tmp_rec) $  ! $	parse_status = 1< $	if f$type(f_bytes) .nes. "INTEGER" then $parse_status = -1: $	if f$type(f_day) .nes. "INTEGER" then $parse_status = -1D $	if ( parse_months - ( "<" + f_month + ">" ) ) .eqs. parse_months - 		then $parse_status = -1s* $	if ( f$type(f_dmore) .nes. "INTEGER" ) -- 	 .and. ( ( f_dmore - ":" ) .eqs. f_dmore ) -h 		then $parse_status = -1o $  ! $  PARSE_UNIX_DONE:  $returnrP $!------------------------------------------------------------------------------ $PARSE_VMS:n& $	f_name  = f$element(0, " ", tmp_rec) $ PARSE_VMS_WRAP:-& $	f_bytes = f$element(1, " ", tmp_rec) $	if f_bytes .eqs. " "! $	  then	read 'tmp_chan' tmp_wrape/ $		tmp_wrap = f$edit(tmp_wrap, "TRIM,COMPRESS")  $		log1 "_rec: ", tmp_wrap1 $		if tmp_wrap .eqs. "" then $goto PARSE_VMS_DONEe% $		tmp_rec = tmp_rec + " " + tmp_wrap  $		goto PARSE_VMS_WRAP $	endifh& $	f_bytes = f$element(0, "/", f_bytes)& $	f_month = f$element(2, " ", tmp_rec)& $	f_day   = f$element(3, " ", tmp_rec) $	f_dmore = ""- $	if f_day .eqs. "" then $goto PARSE_VMS_DONEd $  ! $  ! Directory $  !* $	if f$parse(f_name,,,"TYPE") .eqs. ".DIR"* $	  then	r_name = f$parse(f_name,,,"NAME") $		if prm_recurses( $		  then	log1 " sub-directory ", r_name $			saved_prm_dir = prm_dirl" $			log_prefix = log_prefix + "  "0 $			prm_dir = prm_dir - "]" + "." + r_name + "]"
 $			@'dcl_fn'! $			prm_dir = saved_prm_dir-" $			log_prefix = log_prefix - "  " $		endif $		goto PARSE_VMS_DONE $	endifR $  ! $	parse_status = 1< $	if f$type(f_bytes) .nes. "INTEGER" then $parse_status = -1& $	call MATCH_WILD "''f_month'" "*-*-*"0 $	if $severity .nes. "1" then $parse_status = -1" $	call MATCH_WILD "''f_day'" "*:*"0 $	if $severity .nes. "1" then $parse_status = -1 $ PARSE_VMS_DONE:s $return%P $!------------------------------------------------------------------------------: $! Store record in data file, the format of the record is:% $!	  0 255 directory sep name (key 0)o" $!	255 ...	fields separated by sep $! $ STORE:4 $	dat_key = f$fao("!AS!AS!AS", prm_dir, sep, f_name) $	if f$len(dat_key) .gt. 255! $	  then	error_location = "STORE" 3 $		error_message = "exceeds key length, game over!"e $		goto ABORT_HANDLERy $	endif $ $	dat_key = f$fao("!255AS", dat_key) $	wr_mode = ""8 $	read/error=STORE_ERROR/key=&dat_key 'dat_chan' dat_rec $	wr_mode = "/update"	 $ STORE_ERROR: $	rms_s = $status', $	if f$message(rms_s, "SEVERITY") .eqs. "%S"  $	  then	gosub SPLIT_DATA_RECORDj $		log1 f$fao("  was: !AS bytes = !AS, date = !AS !AS !AS", d_last_seen, d_bytes, d_month, d_day, d_dmore) $  ! $		changes = 07 $		if f_bytes .nes. d_bytes then $changes = changes + 1- $		if prm_dates-	 $		  then-8 $			if f_month .nes. d_month then $changes = changes + 18 $			if f_day   .nes. d_day   then $changes = changes + 1( $			if ((f_dmore - ":") .nes. f_dmore) -+ 			 .and. ((d_dmore - ":") .nes. d_dmore) -f# 			 .and. (f_dmore .nes. d_dmore) -T 				then $changes = changes + 1u( $			if ((f_dmore - ":") .eqs. f_dmore) -+ 			 .and. ((d_dmore - ":") .eqs. d_dmore) -i# 			 .and. (f_dmore .nes. d_dmore) -r 				then $changes = changes + 1u $		endif $  ! $		if changes .gt. 08 $		  then	log1 f$fao("   !SL field!%S changed", changes) $			log "changed: ", f_namel# $			write/symbol 'his_chan' dat_recc $			d_last_changed = ls_stamp	 $		endif $  !2 $	  else	if f$message(rms_s, "IDENT") .eqs. "%RNF" $		  then	log1 "   first seen" $			log "new:     ", f_name( $			d_first_seen    = ls_stamp $			d_last_changed  = "" $			d_last_actioned = """ $		  else	error_location = "STORE" $			$status = rms_se $			goto ERROR_HANDLER $		endif $	endifr $  ! $	d_bytes = f_bytese $	d_month = f_monthO $	d_day   = f_day  $	d_dmore = f_dmoren $	d_last_seen = ls_stamp $	gosub MAKE_DATA_RECORD* $	write/symbol'wr_mode' 'dat_chan' dat_rec $returnfP $!------------------------------------------------------------------------------I $! Process the file list stored, identify additions, changes and removalss $! Perform optional actionsa $!	 $PROCESS:t $	log1 "PROCESS: ", prm_dirm $	dir_len = f$length(prm_dir)' $	gosub GET_CONTROL_RECORD# $	log1 " first list:     ", c_first'" $	log1 " last list:      ", c_last' $	log1 " last processed: ", c_processed_ $	if c_processed .ges. c_lastp& $	  then	log "processing not required"	 $		returnm' $	  else	log1 "processing run ", c_lasts $	endif  $	action_errors = 0	 $	t_files    = 0 $	t_removed  = 0 $	t_actioned = 0 $ PROCESS_LOOP:". $	read/end=PROCESS_LOOP_END 'dat_chan' dat_rec $	gosub SPLIT_DATA_RECORDp2 $	if d_dir .nes. c_dir then $goto PROCESS_LOOP_END $	t_files = t_files + 1S $  ! $	if t_actioned .ge. prm_limitI $	  then	log f$fao("action limit (!SL/!SL) reached, processing aborted" -7 			, t_actioned, prm_limit)e $		goto PROCESS_ENDe $	endifr $  ! $	state = ""C $	if (d_last_changed .gts. d_last_actioned) then $state = "CHANGED"t= $	if (d_first_seen .gts. d_last_actioned) then $state = "NEW"m7 $	if (d_last_seen .lts. c_last) then $state = "REMOVED"  $  ! $	action_ok = 1  $	if state .nes. ""  $	  then	log1 " file: ", d_nameM* $		log1 "   first seen:    ", d_first_seen) $		log1 "   last seen:     ", d_last_seen", $		log1 "   last changed:  ", d_last_changed- $		log1 "   last actioned: ", d_last_actionedp# $		log1 "   state:         ", statei $	   ! $		gosub FIND_ACTION_ROUTINE $		if action_index .gt. 0 ( $		  then	gosub TRANSLATE_ACTION_ROUTINE4 $			log f$fao("action:  !AS (!AS) !AS !AS", d_name -* 				, state, action_routine, action_param) $			set noon( $			call 'action_call' "''action_param'" $			a_status = $status
 $			set on1 $			if f$message(a_status, "SEVERITY") .eqs. "%S"n- $			  then	log1 " action status = ", a_status ! $				d_last_actioned = f$cvtime()o $				gosub MAKE_DATA_RECORDn+ $				write/symbol/update 'dat_chan' dat_rect  $				t_actioned = t_actioned + 19 $			  else	log " action status = ", a_status, " (FAILED)"i& $				action_errors = action_errors + 1 $				action_ok = 0	 $			endif  $		endif $	endifq $  !, $	if action_ok .and. (state .eqs. "REMOVED")4 $	  then	read/delete/key=&dat_key 'dat_chan' dat_rec" $		write/symbol 'his_chan' dat_rec $		t_removed = t_removed + 1 $		log "removed: ", d_name $	endifa $  ! $	goto PROCESS_LOOP_ $ PROCESS_LOOP_END:n $	if action_errors .eq. 0	! $	  then	c_processed = f$cvtime()! $		gosub UPDATE_CONTROL- $	endif-D $	log f$fao("!SL file!%S, !SL removed, !SL actioned, !SL error!%S" -2 		, t_files, t_removed, t_actioned, action_errors) $ PROCESS_END: $returnMP $!------------------------------------------------------------------------------D $! Evaluate action filters, return ACTION_INDEX to action, 0 if none $! $FIND_ACTION_ROUTINE:  $	action_index = 0 $	c = 1_ $	if prm_type .eqs. "VMS"e= $	  then	far_candidate = d_name - f$parse(d_name,,,"VERSION")	 $	  else	far_candidate = d_namec $	endifr $ FIND_ACTION_ROUTINE_LOOP:I $	if c .le. prm_actionse, $	  then	far_pattern = prm_action_'c'_filter8 $		call MATCH_WILD "''far_candidate'" "''far_pattern'" - 			"''prm_case'" $		if $severity .eqs. "1"  $		  then	action_index = c $		  else	c = c + 1N! $			goto FIND_ACTION_ROUTINE_LOOP_ $		endif $	endife2 $	log2 f$fao("  action_index = !SL", action_index) $return-P $!------------------------------------------------------------------------------9 $! Translate ACTION_INDEX to procedure call and parameter , $!  returned in ACTION_CALL and ACTION_PARAM $! $TRANSLATE_ACTION_ROUTINE:4 $ action_routine = prm_action_'action_index'_routine0 $ action_param = prm_action_'action_index'_param $ action_call = action_routineL $ if action_routine .eqs. "COPY_ASCII"  then $action_call = "COPY ""ASCII"""M $ if action_routine .eqs. "COPY_BINARY" then $action_call = "COPY ""BINARY""" F $ if action_routine .eqs. "DCL"         then $action_call = "DCL """""K $ if action_routine .eqs. "DCL_ASCII"   then $action_call = "DCL ""ASCII"""lL $ if action_routine .eqs. "DCL_BINARY"  then $action_call = "DCL ""BINARY""" $returnlP $!------------------------------------------------------------------------------ $! $SPLIT_DATA_RECORD:i& $	dat_key = f$extract(0, 255, dat_rec)& $	d_dir   = f$element(0, sep, dat_key)9 $	d_name  = f$element(0, " ", f$element(1, sep, dat_key))- $ !-0 $	dat_data = f$extract(255, 1024 - 255, dat_rec)/ $	d_bytes         = f$element(0, sep, dat_data)k/ $	d_month         = f$element(1, sep, dat_data)l/ $	d_day           = f$element(2, sep, dat_data)a/ $	d_dmore         = f$element(3, sep, dat_data)n/ $	d_first_seen    = f$element(4, sep, dat_data) / $	d_last_seen     = f$element(5, sep, dat_data) / $	d_last_changed  = f$element(6, sep, dat_data)N/ $	d_last_actioned = f$element(7, sep, dat_data)R $return>P $!------------------------------------------------------------------------------ $! $MAKE_DATA_RECORD: $	dat_rec = dat_key -A 		+ d_bytes + sep -C 		+ d_month + sep -  		+ d_day + sep -  		+ d_dmore + sep -n 		+ d_first_seen + sep - 		+ d_last_seen + sep -P 		+ d_last_changed + sep - 		+ d_last_actioned + sepc $return P $!------------------------------------------------------------------------------) $! Add control record if it doesn't existi $!  V0.15 added /NOLOCK  $!
 $ADD_CONTROL:F) $	ctl_key = f$fao("!AS!AS", prm_dir, sep)f$ $	ctl_key = f$fao("!255AS", ctl_key)E $	read/error=ADD_CONTROL_ERROR/key=&ctl_key/nolock 'dat_chan' ctl_recr $ ADD_CONTROL_ERROR: $	rms_s = $statuse, $	if f$message(rms_s, "SEVERITY") .nes. "%S"2 $	  then	if f$message(rms_s, "IDENT") .eqs. "%RNF"< $		  then	ctl_rec = ctl_key + "" + sep + "" + sep + "" + sep# $			write/symbol 'dat_chan' ctl_rec ( $		  else	error_location = "ADD_CONTROL" $			$status = rms_s	 $			goto ERROR_HANDLER $		endif $	endif! $	gosub SPLIT_CONTROL_RECORD $returneP $!------------------------------------------------------------------------------ $! Update control record $! $UPDATE_CONTROL:) $	ctl_key = f$fao("!AS!AS", prm_dir, sep)	$ $	ctl_key = f$fao("!255AS", ctl_key) $	ctl_rec = ctl_key -  		+ c_first + sep -  		+ c_last + sep - 		+ c_processedc* $	read/key=&ctl_key 'dat_chan' old_ctl_rec( $	write/symbol/update 'dat_chan' ctl_rec $return P $!------------------------------------------------------------------------------ $!  V0.15 added /NOLOCKc $! $GET_CONTROL_RECORD:) $	ctl_key = f$fao("!AS!AS", prm_dir, sep)A$ $	ctl_key = f$fao("!255AS", ctl_key)- $	read/key=&ctl_key/nolock 'dat_chan' ctl_recs $	gosub SPLIT_CONTROL_RECORD $returnaP $!------------------------------------------------------------------------------ $! $SPLIT_CONTROL_RECORD:$ $	c_dir = f$element(0, sep, ctl_rec)0 $	ctl_data = f$extract(255, 1024 - 255, ctl_rec)+ $	c_first     = f$element(0, sep, ctl_data) + $	c_last      = f$element(1, sep, ctl_data) + $	c_processed = f$element(2, sep, ctl_data)	 $returnrP $!------------------------------------------------------------------------------3 $! MATCH_WILD - like STR$MATCH_WILD but only does * F $!  P1 = candidate, P2 = pattern, [P3 = case sensitive (default TRUE)] $!  Check $SEVERITY for result  $!	"1" (success) indicates match) $!	"3" (informational) indicates NO match$ $!C $!  For each string element we find matches at all forward postionsIF $!  We save first start position of first element (lo_pos) to check A*A $!  We save last end postion of last element (hi_pos) to check *Z- $! $MATCH_WILD: subroutineo $	on warning then exit $status $	on control_y then exit %x2 $! $	candidate = P1 $	pattern = P2C $	if (candidate .eqs. "") .and. (pattern .eqs. "") then $goto MATCH$+ $	if (pattern .eqs. "") then $goto NO_MATCHn $! $	case = P3'( $	if (case .eqs. "") then $case = "TRUE" $	if .not. caseg0 $	  then	candidate = f$edit(candidate, "UPCASE")& $		pattern = f$edit(pattern, "UPCASE") $	endifp $! $	c_len = f$length(candidate)e $	next_pos = 0
 $	lo_pos = -1i
 $	hi_pos = -11 $	first_len = -1 $	last_len = -1l $	c = 0h	 $ LOCATE:l" $	pat = f$element(c, "*", pattern) $	if pat .nes. "*" $	  then	len = f$length(pat)- $		if first_len .eq. -1 then $first_len = len$ $		last_len = lend' $		if len .eq. 0 then $goto LOCATE_NEXTc $  ! $		c_pos = next_posh $		first_try = 1 $		match = 0 $  LOCATE_AGAIN: $		c_rem = c_len - c_pos< $		m_pos = f$locate(pat, f$extract(c_pos, c_rem, candidate))) $		if lo_pos .eq. -1 then $lo_pos = m_posh $		if m_pos .ne. c_rem $		  then	match = 1' $			c_pos = c_pos + m_pos + lenf' $			if first_try then $next_pos = c_posh $			hi_pos = c_pos $			first_try = 0  $			goto LOCATE_AGAINl $		endif% $		if .not. match then $goto NO_MATCH	 $  LOCATE_NEXT:= $		c = c + 1 $		goto LOCATE $	endifrA $	if (first_len .ne. 0) .and. (lo_pos .ne. 0) then $goto NO_MATCH-D $	if (last_len .ne. 0) .and. (hi_pos .ne. c_len) then $goto NO_MATCH $! $ MATCH:
 $	exit %x1 $ NO_MATCH:8
 $	exit %x3 $endsubroutineP $!------------------------------------------------------------------------------ $! NULL action routine $! $NULL: subroutineS
 $ exit %x1 $endsubroutineP $!------------------------------------------------------------------------------ $! MAIL action routine $!  P1 = recipient $! $MAIL: subroutineN $ on warning then exit $status $ on control_y then exit %x2 $ !  $	if P1 .eqs. "" then $exit %x2TB $	log1 "MAIL: file = ", d_name, ", to = ", P1, ", state = ", state $  !@ $  ! If file has been removed then turn this into a notification $  ! $	if state .eqs. "REMOVED" $	  then	call NOTIFY "''P1'" $		exit $status- $	endif- $  !( $	tmp_fn = f$parse(".TMP_MAIL;", tmp_fn)  $	log1 "MAIL: tmp_fn = ", tmp_fn $	if prm_user .eqs. "": $	  then	copy/ftp 'prm_node'::"''d_dir'''d_name'" 'tmp_fn'S $	  else	copy/ftp 'prm_node'"''prm_user' ''prm_pass'"::"''d_dir'''d_name'" 'tmp_fn'h $	endife, $	m_pers = "At " + prm_node + "::" + prm_dir8 $	m_subj = dcl_name + ": " + d_name + " (" + state + ")"$ $	m_pers = f$extract(0, 255, m_pers)$ $	m_subj = f$extract(0, 255, m_subj) $  set noon': $	mail 'tmp_fn' "''P1'" /pers="''m_pers'"/subj="''m_subj'" $	mail_status = $statusu	 $  set on' $	delete/nolog 'tmp_fn'* $ !t $ exit 'mail_status' $endsubroutineP $!------------------------------------------------------------------------------ $! NOTIFY action routine $!  P1 = recipient $! $NOTIFY: subroutineP $ on warning then exit $status $ on control_y then exit %x2 $ !t $	if P1 .eqs. "" then $exit %x2tC $	log1 "NOTIFY: file = ", d_name, ", to = ", P1,", state = ", state-* $	tmp_fn = f$parse(".TMP_NOTIFY;", tmp_fn)" $	log1 "NOTIFY: tmp_fn = ", tmp_fn! $	tmp_chan = tmp_chan + "_NOTIFY"> $  ! $	close/nolog 'tmp_chan'  $	open/write 'tmp_chan' 'tmp_fn'E $	write 'tmp_chan' dcl_name + " notification of a " + state + " file"n $	write 'tmp_chan' ""e. $	write 'tmp_chan' " Node:         ", prm_node+ $	write 'tmp_chan' " Directory:    ", d_dir1, $	write 'tmp_chan' " Name:         ", d_name- $	write 'tmp_chan' " Size:         ", d_bytestG $	write 'tmp_chan' " Date:         ", d_day, " ", d_month, " ", d_dmoret+ $	write 'tmp_chan' " State:        ", statee $	write 'tmp_chan' ""f $	close 'tmp_chan' $ !", $	m_pers = "At " + prm_node + "::" + prm_dir8 $	m_subj = dcl_name + ": " + d_name + " (" + state + ")"$ $	m_pers = f$extract(0, 255, m_pers)$ $	m_subj = f$extract(0, 255, m_subj) $  set noon : $	mail 'tmp_fn' "''P1'"/pers="''m_pers'" /subj="''m_subj'" $	mail_status = $statusy	 $  set onh $	delete/nolog 'tmp_fn'* $ !O $ exit 'mail_status' $endsubroutineP $!------------------------------------------------------------------------------ $! COPY action routine $!  P1 = mode (ascii or binary)- $!  P2 = destination directory $! $COPY: subroutine  $ on warning then exit $status $ on control_y then exit %x2 $ !  $	if P1 .eqs. "" $	  then	q_mod = ""x $	  else	q_mod = "/" + P1m $	endif  $	if P2 .eqs. "" then $exit %x2 = $	if f$parse(P2) .eqs. "" then $exit %x2		! invalid directory.B $	log1 "COPY: file = ", d_name, ", to = ", P2, ", state = ", state) $	if state .eqs. "REMOVED" then $exit %x1b $	if prm_user .eqs. ""= $	  then	copy/ftp'q_mod' 'prm_node'::"''d_dir'''d_name'" 'P2' V $	  else	copy/ftp'q_mod' 'prm_node'"''prm_user' ''prm_pass'"::"''d_dir'''d_name'" 'P2' $	endifx
 $ exit %x1 $ !  $endsubroutineP $!------------------------------------------------------------------------------K $! DCL action routine, call comand procedure with node, filename, and state " $!  P1 = ftp mode if file provided $!  P2 = command procedure $! $DCL: subroutine $ on warning then exit $status $ on control_y then exit %x2 $ !e $	if P1 .eqs. "" $	  then	q_mod = """ $	  else	q_mod = "/" + P1  $	endiff+ $	if f$search(f$parse(P2, ".COM")) .eqs. ""e? $	  then	write sys$error "ERROR: can't find DCL procedure ", P2m $		exit %x2N $	endif-C $	log1 "DCL: file = ", d_name, ", proc = ", P2, ", state = ", states $ !o $	param_1 = prm_node $	param_2 = d_dir! $	param_3 = d_name $	param_4 = state- $	param_5 = "" $ !-, $	if q_mod .eqs. "" then $goto DCL_SKIP_COPY3 $	if state .eqs. "REMOVED" then $goto DCL_SKIP_COPYe $ !$' $	tmp_fn = f$parse(".TMP_DCL;", tmp_fn)q $	log1 "DCL: tmp_fn = ", tmp_fnt $	if prm_user .eqs. ""A $	  then	copy/ftp'q_mod' 'prm_node'::"''d_dir'''d_name'" 'tmp_fn'iZ $	  else	copy/ftp'q_mod' 'prm_node'"''prm_user' ''prm_pass'"::"''d_dir'''d_name'" 'tmp_fn' $	endif_ $	param_5 = tmp_fn $ !y $ DCL_SKIP_COPY:# $	set symbol/scope=(global,nolocal)( $  set nooneE $	@'P2' "''param_1'" "''param_2'" "''param_3'" "''param_4'" 'param_5'. $	dcl_status = $status	 $  set on  $ !  $	if param_5 .nes. ""	D $	  then	if f$search(param_5) .nes. "" then $delete/nolog 'param_5'* $	endifA $ exit 'dcl_status's $ !	 $endsubroutineP $!------------------------------------------------------------------------------