$! GRAB_SUMMARY.COM
$! ----------------
$! Search file(s) P1 for string(s) P2 and display summary
$!
$! This procedure demonstrates how to use the GRAB_SUMMARY and GRAB_FILE_n
$! symbols which are created with the /SAVE=(SUMMARY,FILES).
$!
$! The symbols contain comma seperated values containing statistics (counts)
$! about the search operation. The first element of the GRAB_SUMMARY symbol
$! is a count of files processed, this is used to loop through each of the
$! GRAB_FILE_n symbols. Since the other elements of the symbols are common
$! a single display routine is used.
$!
$! ---------------------------------------------------------------------------
$!
$	on warning then exit $status
$	on control_y then exit %x2
$  !
$	wo = "write sys$output"
$  !
$	if (P2 .eqs. "") .or. ("''P3'''P4'''P5'''P6'''P7'''P8'" .nes. "")
$	  then	write sys$error "Usage: @GRAB_SUMMARY file(s) string(s)"
$		exit
$	endif
$  !
$	wo "         GRAB_SUMMARY"
$	wo ""
$	wo "              file(s): ", P1
$	wo "            string(s): ", P2
$	wo ""
$  !
$	grab/save=(files,summary)/noout 'P1' 'P2'
$  !
$  ! Show the summary
$  !
$	call DISPLAY grab_summary "''P2'"
$  !
$  ! If it was ore than 1 file then show them all
$  !
$	file_count = f$integer( f$element(0, ",", grab_summary) )
$	if file_count .le. 1
$	  then	goto END
$	endif
$  !
$	file_index = 1
$ LOOP:
$	if file_index .le. file_count
$	  then	call DISPLAY grab_file_'file_index' "''P2'"
$		file_index = file_index + 1
$		goto LOOP
$	endif
$!
$ END:
$	exit
$!
$!-----------------------------------------------------------------------------
$ DISPLAY: subroutine
$!
$	on warning then exit $status
$	on control_y then exit %x2
$  !
$	wo "               symbol: ", P1
$	wo "                value: ", 'P1'
$	if P1 .eqs. "GRAB_SUMMARY"
$	  then	wo "       files searched: ", f$element(0, ",", 'P1')
$	  else	wo "                 file: ", f$element(0, ",", 'P1')
$	endif
$	wo "     records searched: ", f$element(1, ",", 'P1')
$	wo "       bytes searched: ", f$element(2, ",", 'P1')
$	wo "        records found: ", f$element(3, ",", 'P1')
$	wo "       sections found: ", f$element(4, ",", 'P1')
$  !
$	str_count = f$element(5, ",", 'P1')
$	wo " strings searched for: ", f$string(str_count)
$	c = 1
$ LOOP:
$	if (c .le. str_count)
$	  then	wo f$fao("     string !SL matches: !AS !_(!AS)" -
				, c , f$element(5 + c, ",", 'P1') -
				, f$element( c - 1, ",", P2))
$		c = c + 1
$		goto LOOP
$	endif
$	wo ""
$!
$	exit
$ endsubroutine
$!-----------------------------------------------------------------------------
