J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CMPDIR              %%   \ ?  *                %% |           cmpdir.c  c2004         %%   \ @  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *E  *  CMPDIR compares the contents of two directories and displays the  D  *  result in a similar format as the DCL DIFFERENCES command. This E  *  format provides a quick visual depiction of version discrepencies C  *  between dirctories. Qualifiers are available to hilite date and G  *  size differences between the two directories. If CMPDIR detects the G  *  image if being executed on a DECterm, date and size differences are G  *  shown in colors, else they are shown in bold font. There is also an    *  /OUTPUT qualifier available.  *  *  Sample output:  *9  *    $ CMPDIR LOCALSRC:[CMPDIR] LOCALSRC:[CMPDIR.UPDATE]   *D  *                     LOCALSRC:[CMPDIR]    LOCALSRC:[CMPDIR.UPDATE]N  *    ----------------------------------    ----------------------------------7  *                           BUILD.COM;1    BUILD.COM;1 6  *                                          CMPDIR.C;46  *                                          CMPDIR.C;36  *                                          CMPDIR.C;26  *                            CMPDIR.C;1    CMPDIR.C;18  *                          CMPDIR.CLD;1    CMPDIR.CLD;18  *                                          CMPDIR.EXE;6(  *                          CMPDIR.EXE;18  *                                          CMPDIR.OBJ;4(  *                          CMPDIR.OBJ;18  *                          CMPDIR.OPT;1    CMPDIR.OPT;1<  *                      CMPDIR_CLD.OBJ;1    CMPDIR_CLD.OBJ;1=  *                                          CMPDIR_DIFF.LST;1 =  *                     CMPDIR_MKMF.LOG;1    CMPDIR_MKMF.LOG;1 (  *                     COMPARE_DIR.DIR;15  *                             DBG.DBG;1    DBG.DBG;1 6  *                            DBG2.DBG;1    DBG2.DBG;19  *                         DESCRIP.MMS;1    DESCRIP.MMS;1 :  *                        FIXDATES.COM;1    FIXDATES.COM;1(  *                          UPDATE.DIR;1A  *                 PROPOSED_OUTPUT.TXT;1    PROPOSED_OUTPUT.TXT;1 7  *                                          UTILITY.C;3 7  *                                          UTILITY.C;2 7  *                           UTILITY.C;1    UTILITY.C;1 9  *                                          UTILITY.OBJ;2 (  *                         UTILITY.OBJ;17  *                                          VERSION.H;2 7  *                           VERSION.H;1    VERSION.H;1 (  *                           XMPLS.DIR;1  *5  *                             Total: 19    Total: 23   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module cmpdir VERSION    #include <stdio.h> #include <ctype.h> #include <descrip.h> #include <lib$routines.h>  #include <prvdef.h>  #include <ssdef.h> #include <starlet.h> #include <string.h>  #include <stdlib.h>  #include <rms.h>   #define BACKUP 1 #define CREATE 2 #define EXPIRE 4 #define REVISE 8  B #define DATEERROR 1             /* selected date field mismatch */F #define SIZEERROR 2             /* one or both size fields mismatch */C #define BOTHERROR 3             /* both date and size mismatches */    typedef struct {     unsigned char FileName[80];  } FILE_LST;   (     /* target filepath rms structures */  : struct FAB Fab1;                /* FAB Structure for P1 */: struct FAB Fab2;                /* FAB Structure for P2 */: struct NAM Nam1;                /* NAM Structure for P1 */: struct NAM Nam2;                /* NAM Structure for P2 */  *     /* external routines rms structures */  7 struct FAB fab;                 /* File access block */ 0 struct NAM nam;                 /* Name block */9 struct XABDAT xabdat;           /* Date and time block */ H struct XABFHC xabfhc;           /* The file header characteristic XAB */  8 struct {short len, code; char *buf, *retlen;} DviItm[2];   FILE_LST *FileList1; FILE_LST *FileList2;@ FILE_LST *ListPtr1;             /* file pointer for FileList1 */@ FILE_LST *ListPtr2;             /* file pointer for FileList2 */  B int DateMode;                   /* type of date info to compare */D int MaxPtr1 = 0;                /* addr of last slot in FileList1 */D int MaxPtr2 = 0;                /* addr of last slot in FileList2 */A int numfiles1;                  /* number of files in DirPath1 */ A int numfiles2;                  /* number of files in DirPath2 */  int status;   ? int BinTime1[2];                /* multi purpose time buffer */ ? int BinTime2[2];                /* multi purpose time buffer */   B char BoldOff[16];               /* esc string to disable hilite */A char BoldOn[16];                /* esc string to enable hilite */ I char CmdVerb[32];               /* foreign command invoking this image */ A char DirPath1[64];              /* input file from cmd line P1 */ A char DirPath2[64];              /* input file from cmd line P2 */  char OutFile[80];   < short DateErr;                  /* total date diff errors */G short DateFlg;                  /* specifies the date value to check */ @ short DtFlg;                    /* specifies TT: is a DecTerm */B short ErrStat;                  /* target date or size mismatch */F short OutFlg;                   /* image output directed to a file */ < short SizeErr;                  /* total size diff errors */J short SizeFlg;                  /* specifies if file sizes are compared */  F extern int CheckDate();         /* verify both files same timestamp */F extern int FormatHilite();      /* if decterm, highlite is in color */; extern int CheckPrv();          /* requires READALL priv */ A extern int CheckSize();         /* verify both files same size */    FILE *outfp;  
 int main() {        int CmpStat = 0;     int Fmatch = 0; =     short CvLen;                 /* Length of command verb */      short UicLen = 0;        char CmdLine[80];      char CurPath[80];      char LineBuf[132];     char tmpspec1[64];     char tmpspec2[64];I     char esa1[NAM$C_MAXRSS];     /* extended filespec (from SYS$PARSE) */ I     char esa2[NAM$C_MAXRSS];     /* extended filespec (from SYS$PARSE) */ J     char rsa1[NAM$C_MAXRSS];     /* resultant filespec (from SYS$SEARCH */J     char rsa2[NAM$C_MAXRSS];     /* resultant filespec (from SYS$SEARCH */     char *path;      char *ptr = 0;  !     $DESCRIPTOR(DscCmd, CmdLine); "     $DESCRIPTOR(DscPath, CurPath);E     $DESCRIPTOR(DscVerb, CmdVerb); /* foreign invoking symbol name */        Fab1 = cc$rms_fab;     Fab2 = cc$rms_fab;     Nam1 = cc$rms_nam;     Nam2 = cc$rms_nam;  J         /* get the user's default dir for /OUTPUT (whether used or not) */       path = getenv("PATH");     strcpy(CurPath, path);+     DscPath.dsc$w_length = strlen(CurPath); ,     status = str$upcase(&DscPath, &DscPath);  <         /* get the command line used to invoke this image */  M     status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CvLen] = 0;   3         /* extract foreign cmd verb from CmdLine */   $     sscanf(CmdLine, "%s", &CmdVerb);     ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);  2         /* get the cli values from command line */       GetCliInfo();   6         /* load the rms wild filespec for each path */  +     sprintf(tmpspec1, "%s*.*;*", DirPath1); +     sprintf(tmpspec2, "%s*.*;*", DirPath2);    :         /* initialize parse/search Fab & Nam structures */  B     Fab1.fab$l_dna = tmpspec1;            /* Assign the address ofL                                                 filename to fab.fab$l_dna */B     Fab1.fab$b_dns = strlen(tmpspec1);    /* Assign the length. */H     Fab1.fab$l_nam = &Nam1;            /* Assign address of NAM block */  B     Nam1.nam$l_esa = esa1;                /* Address of the esa */A     Nam1.nam$b_ess = sizeof esa1;         /* length of the esa */ B     Nam1.nam$l_rsa = rsa1;                /* Address of the rsa */A     Nam1.nam$b_rss = sizeof rsa1;         /* Length of the rsa */   B     Fab2.fab$l_dna = tmpspec2;            /* Assign the address ofL                                                 filename to fab.fab$l_dna */B     Fab2.fab$b_dns = strlen(tmpspec2);    /* Assign the length. */H     Fab2.fab$l_nam = &Nam2;            /* Assign address of NAM block */  B     Nam2.nam$l_esa = esa2;                /* Address of the esa */A     Nam2.nam$b_ess = sizeof esa2;         /* length of the esa */ B     Nam2.nam$l_rsa = rsa2;                /* Address of the rsa */A     Nam2.nam$b_rss = sizeof rsa2;         /* Length of the rsa */     B         /*  Issue SYS$PARSE on Fab1 and get total files in the    <          *  directory specified by the cmdline P1 parameter.          */   ;     if ((status = sys$parse(&Fab1, 0, 0)) == RMS$_NORMAL) { $         esa1[Nam1.nam$b_esl] = '\0';         if(OutFlg) {J             printf("\nCreating output file %s%s ...\n", CurPath, OutFile);/             printf("   FilePath1: %s\n", esa1); 	         }   =         /* get number of files in DirPath1 and allocate space %            for resultant filenames */   C         while ((status = sys$search(&Fab1, 0, 0)) == RMS$_NORMAL) {              numfiles1++;	         } <         FileList1 = calloc(numfiles1 + 1, sizeof(FILE_LST));         ListPtr1 = FileList1;   =         /* now get list of filenames and save in FileList1 */   (         status = sys$parse(&Fab1, 0, 0);C         while ((status = sys$search(&Fab1, 0, 0)) == RMS$_NORMAL) { (             rsa1[Nam1.nam$b_rsl] = '\0';$             ptr = strchr(rsa1, ']');             ptr++;"             strcpy(ListPtr1, ptr);             ListPtr1++; 	         }      }   >         /*  Issue SYS$PARSE on Fab2 and get total files in the<          *  directory specified by the cmdline P2 parameter.          */   ;     if ((status = sys$parse(&Fab2, 0, 0)) == RMS$_NORMAL) { $         esa2[Nam2.nam$b_esl] = '\0';7        if(OutFlg) printf("   FilePath2: %s\n\n", esa2); =         /* get number of files in DirPath2 and allocate space %            for resultant filenames */   C         while ((status = sys$search(&Fab2, 0, 0)) == RMS$_NORMAL) {              numfiles2++;	         } <         FileList2 = calloc(numfiles2 + 1, sizeof(FILE_LST));         ListPtr2 = FileList2;   =         /* now get list of filenames and save in FileList2 */   (         status = sys$parse(&Fab2, 0, 0);C         while ((status = sys$search(&Fab2, 0, 0)) == RMS$_NORMAL) { (             rsa2[Nam2.nam$b_rsl] = '\0';$             ptr = strchr(rsa2, ']');             ptr++;"             strcpy(ListPtr2, ptr);             ListPtr2++; 	         }      }        MaxPtr1 = ListPtr1;      MaxPtr2 = ListPtr2;      ListPtr1 = FileList1;      ListPtr2 = FileList2;   1         /* print out header with each filepath */   9     fprintf(outfp, "\n%38s    %s\n", DirPath1, DirPath2); =     fprintf(outfp, "    ----------------------------------"); ?     fprintf(outfp, "    ----------------------------------\n"); 9     while((ListPtr1 < MaxPtr1) && (ListPtr2 < MaxPtr2)) { -         CmpStat = strcmp(ListPtr1, ListPtr2); :         if(!CmpStat) {       /* filenames are identical */8             if(DateFlg) CheckDate(&DirPath1, &DirPath2);8             if(SizeFlg) CheckSize(&DirPath1, &DirPath2);L             if(!ErrStat) fprintf(outfp, "%38s    %s\n", ListPtr1, ListPtr2);             else {(                 status = FormatHilite();D                 fprintf(outfp, "%38s    %s%s%s\n", ListPtr1, BoldOn,'                     ListPtr2, BoldOff); 
             } B             ErrStat = 0;    /* set/clear on each pass thru loop */             ListPtr1++;              ListPtr2++; I             Fmatch = TRUE;  /* further printing not need for this pair */ 	         }          if(!Fmatch) { (             status = CompareFilenames();M             if(!status) {   /* names are different, print lower of 2 names */ J                 if(CmpStat < 0) {   /* filename1 greater than filename2 */;                     fprintf(outfp, "%38s    \n", ListPtr1);                      ListPtr1++;                  } I                 if(CmpStat > 0) {   /* filename1 lesser than filename2 */ B                     fprintf(outfp, "%38s    %s\n", " ", ListPtr2);                     ListPtr2++;                  } 
             } K             else {          /* names are same, print higher of two names */ J                 if(CmpStat < 0) {   /* filename1 greater than filename2 */B                     fprintf(outfp, "%38s    %s\n", " ", ListPtr2);                     ListPtr2++;                  } I                 if(CmpStat > 0) {   /* filename1 lesser than filename2 */ ;                     fprintf(outfp, "%38s    \n", ListPtr1);                      ListPtr1++;                  } 
             } 	         }          Fmatch = FALSE;      }      if(ListPtr1 >= MaxPtr1) { #         while(ListPtr2 < MaxPtr2) { :             fprintf(outfp, "%38s    %s\n", " ", ListPtr2);             ListPtr2++; 	         } V         fprintf(outfp, "\n%29sTotal: %2d    Total: %2d\n", " ", numfiles1, numfiles2);5         if(DateFlg || SizeFlg) status = ShowErrors(); $         else fprintf(outfp, "\n\n");         exit(SS$_NORMAL);      }      if(ListPtr2 >= MaxPtr2) { #         while(ListPtr1 < MaxPtr1) { 3             fprintf(outfp, "%38s    \n", ListPtr1);              ListPtr1++; 	         } V         fprintf(outfp, "\n%29sTotal: %2d    Total: %2d\n", " ", numfiles1, numfiles2);5         if(DateFlg || SizeFlg) status = ShowErrors(); $         else fprintf(outfp, "\n\n");         exit(SS$_NORMAL);      } <     fprintf(outfp, "\n%29sTotal: %2d    Total: %2d\n", " ",          numfiles1, numfiles2);1     if(DateFlg || SizeFlg) status = ShowErrors();       else fprintf(outfp, "\n\n"); }   J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckDate H  * Description: User entered /DATE qualifier on command line. Using the J  *              GetCliInfo routine, the desired date type (BACKUP. CREATE,J  *              EXPIRE, REVISE) has been determined. Get the selected dateH  *              value or each matching file pair and compare. The result@  *              of the compare is saved in the variable ErrStat.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ / int CheckDate(char *filepath1, char *filepath2)  {      int     Fstat;     char    Path1[80];     char    Path2[80];  %     memset(&Path1, 0, sizeof(Path1)); %     memset(&Path2, 0, sizeof(Path2));        strcpy(Path1, filepath1);      strcat(Path1, ListPtr1);     strcpy(Path2, filepath2);      strcat(Path2, ListPtr2);  4         /* Set up the fab, nam, and xab for Path1 */  ?     fab = cc$rms_fab;            /* Initialize fab structure */ ?     nam = cc$rms_nam;            /* Initialize the NAM block */ F     xabdat = cc$rms_xabdat;      /* Initialize the XABDAT structure */  >     fab.fab$l_fna = Path1;              /* set Path1 in fab */H     fab.fab$b_fns = strlen(Path1);      /* Set length of Path1 in fab */I     fab.fab$l_nam = &nam;               /* point to name block address */*I     fab.fab$l_xab = (char *) &xabdat;   /* chain the date-and-time xab */            /* open Path1 file */%       Fstat = sys$open(&fab);\	          _5         /* get file date based on DateMode bit set */        switch((int)DateMode) {%         case BACKUP:C             memcpy(&BinTime1, &xabdat.xab$q_bdt, sizeof(BinTime1));%             break;         case CREATE:C             memcpy(&BinTime1, &xabdat.xab$q_cdt, sizeof(BinTime1));              break;         case EXPIRE:C             memcpy(&BinTime1, &xabdat.xab$q_edt, sizeof(BinTime1));%             break;         case REVISE:C             memcpy(&BinTime1, &xabdat.xab$q_rdt, sizeof(BinTime1));      }      Fstat = sys$close(&fab);  4         /* Set up the fab, nam, and xab for Path2 */  >     fab.fab$l_fna = Path2;              /* set Path2 in fab */H     fab.fab$b_fns = strlen(Path2);      /* Set length of Path2 in fab */I     fab.fab$l_nam = &nam;               /* point to name block address */ I     fab.fab$l_xab = (char *) &xabdat;   /* chain the date-and-time xab */n           /* open Path2 file */m       Fstat = sys$open(&fab); 	          r5         /* get file date based on DateMode bit set */,       switch((int)DateMode) {e         case BACKUP:C             memcpy(&BinTime2, &xabdat.xab$q_bdt, sizeof(BinTime2));e             break;         case CREATE:C             memcpy(&BinTime2, &xabdat.xab$q_cdt, sizeof(BinTime2));              break;         case EXPIRE:C             memcpy(&BinTime2, &xabdat.xab$q_edt, sizeof(BinTime2));c             break;         case REVISE:C             memcpy(&BinTime2, &xabdat.xab$q_rdt, sizeof(BinTime2));      }n     Fstat = sys$close(&fab);  =         /* compare the binary file info of file1 and file2 */   D     if((BinTime1[0] == BinTime2[0]) && (BinTime1[1] == BinTime2[1]))         return(SS$_NORMAL);P
     else {         ErrStat |= DATEERROR;:         DateErr++;         return(SS$_BADTIME);     }-     Fstat = sys$close(&fab);       fprintf(outfp, "\n");      return(Fstat); }   J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckSize E  * Description: User entered /SIZE qualifier on command line. Get the E  *              blocks used and allocated for each matching file pairCB  *              and compare. The result of the compare is saved in%  *              the variable ErrStat.M  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ / int CheckSize(char *filepath1, char *filepath2)  {      int usedblks1 = 0;     int usedblks2 = 0;     int allocblks1 = 0;1     int allocblks2 = 0;      int Fstat;     char Path1[80];      char Path2[80];   %     memset(&Path1, 0, sizeof(Path1)); %     memset(&Path2, 0, sizeof(Path2));1       strcpy(Path1, filepath1);      strcat(Path1, ListPtr1);     strcpy(Path2, filepath2);      strcat(Path2, ListPtr2);  4         /* Set up the fab, nam, and xab for Path1 */  ?     fab = cc$rms_fab;            /* Initialize fab structure */ ?     nam = cc$rms_nam;            /* Initialize the NAM block */ B     xabfhc = cc$rms_xabfhc;      /* Initialize XABFHC structure.*/F     xabdat = cc$rms_xabdat;      /* Initialize the XABDAT structure */  >     fab.fab$l_fna = Path1;              /* set Path1 in fab */H     fab.fab$b_fns = strlen(Path1);      /* Set length of Path1 in fab */I     fab.fab$l_nam = &nam;               /* point to name block address */IG     fab.fab$l_xab = (char *) &xabfhc;   /* chain the file header xab */            /* open Path1 file */H       Fstat = sys$open(&fab); 	           9         /* get get allocated and used blocks for Path1 */   !     usedblks1 = xabfhc.xab$l_ebk;*     allocblks1 = fab.fab$l_alq;*  5     Fstat = sys$close(&fab);    /* done with Path1 */m  4         /* Set up the fab, nam, and xab for Path2 */  >     fab.fab$l_fna = Path2;              /* set Path2 in fab */H     fab.fab$b_fns = strlen(Path2);      /* Set length of Path2 in fab */I     fab.fab$l_nam = &nam;               /* point to name block address */ G     fab.fab$l_xab = (char *) &xabfhc;   /* chain the file header xab */            /* open Path2 file */a       Fstat = sys$open(&fab);   9         /* get get allocated and used blocks for Path1 */R  !     usedblks2 = xabfhc.xab$l_ebk;z     allocblks2 = fab.fab$l_alq;t
                Fstat = sys$close(&fab);  =         /* compare the binary file info of file1 and file2 */B  >     if((usedblks1 == usedblks2) && (allocblks1 == allocblks2))         return(SS$_NORMAL);u
     else {         ErrStat |= SIZEERROR;          SizeErr++;          return(SS$_ALLOCFAILED);     }      Fstat = sys$close(&fab);     return(Fstat); }s    