P /*******************************************************************************P ********************************************************************************  $    Site:	Western Michigan University 		University Computing Services       System:	JOBLOG        Program:	JOBLOG  1    Version=01	Level=00	07/02/90	Leonard J. Peirce   H    Purpose:	JOBLOG will capture the output for a terminal session, place? 		it in a file, and, upon exit, give the option of printing it, > 		saving it, storing the log file in a secure area and sending5 		notification of it to another user, or deleting it.   @ 		There are essentially two types of JOBLOG log files:  VERIFIED> 		and UNVERIFIED.  VERIFIED log files are guaranteed to be un-> 		touched by the person who created them.  Since the log files; 		themselves are never accessible to the user while running = 		JOBLOG, the only opportunity for modification is if logging : 		is disabled while in JOBLOG.  While this is often a nice8 		feature, it immediately makes the log file UNVERIFIED.  > 		The difference between VERIFIED and UNVERIFIED log files be-> 		comes important for printed and mailed log files, especially" 		for class assignments and such.   1    Version=01	Level=01	12/03/90	Leonard J. Peirce   0    Purpose:	Fix /SKIM so that it actually works.  < 		Add a second exit handler that is called in quit() so that> 		if a user hangs up or disconnects their log file is deleted.  = 		Make sure to override the user's default protection for the % 		log file so that it can be deleted.   @ 		Make sure that the log file is deleted on any ungraceful exit.  ; 		Clean up some comments that were misleading or just plain  		wrong.  1    Version=01	Level=02	01/18/91	Leonard J. Peirce   D    Purpose:	Quit using mailboxes to detect input on the TTY and PTY.@ 		No more dropped reads on the TTY and a big win in performance.  : 		Fix warn() so that it will actually warn both the sender= 		and the recipient.  Add the delete date to the mail message # 		sent to the sender and recipient.   > 		Add PHOTO_MODE so that users don't have to go through all ofA 		the hassle of INSTALLing JOBLOG, creating logicals/directories, = 		etc., if all they want to do is log files.  The log file is = 		called JOBLOG.LOG and is created in the user's current dir- 	 		ectory.   ? 		Put in a fix for SMP.  This was borrowed from the SMP version  		of PHOTO.   > 		Remove the code for exact logging, leaving comments in place2 		in case some brave soul decides to implement it.  1    Version=01	Level=03	09/20/91	Leonard J. Peirce   B    Purpose:	Tighten down on use of privs to close a security hole.  1    Version=01	Level=04	06/04/92	Leonard J. Peirce   "    Purpose:	Port to use FT driver.  1    Version=01	Level=05	03/22/95	Leonard J. Peirce   (    Purpose:	Make /TIME_STAMP work right.  8 		Port to run on OpenVMS on an AXP using DECC.  Whew....  9 		Be smarter about handling a user's default privs.  Make > 		sure they are enabled whenever we SETMODE the TTY to prevent- 		any problems with setting/unsetting HANGUP.   8 		USE SYS$QIO() for SETMODEs with event flags instead of 		SYS$QIOW()'s.   ? 		Add a new extended characteristics longword for SENSEMODE and " 		SETMODE per FK's recommendation.  7 		Fix mailing of log files.  The filename to use in the 8 		staging directory was barfing with SYS$FAO() so I just 		used sprintf() instead.   9 		SYS$FIND_HELD() now requires SYSPRV so now isn't turned % 		off until the end of valid_recip().       Arguments:	See JOBLOG.HLP      External variables:  # 		joblog_cld		.CLD file for parsing  		JLG_*			for JOBLOGMSG.MSG ) 		LIB$M_CLI_CTRLY		for trapping control-Y       External functions:             Defined:	none   F           Called:	cat,strins,strlu,strmcpy,str_post_trim,str_pref_trim  8    Files accessed:	files in staging area and secure area  %    Logical names accessed:	JOBLOG$LOG  				JOBLOG$STAGE      Return codes:	none   *    Compiling instructions:	See DESCRIP.MMS  (    Linking instructions:	See DESCRIP.MMS  C    Other information:	Privileges needed when INSTALLed:  SYSPRV and 
 			CMKRNL.  / 			This version uses the new FT pseudo-terminal 2 			driver from DEC.  If you are using a version of2 			VMS that doesn't support the FT drivers and you, 			would like to use JOBLOG get version 1.3.  7 			This program borrows some code and ideas from PHOTO, 3 			written by Asbed Bedrossian at the University of  			Southern California.   1 			Thanks to FK for his immeasurable patience and 3 			knowledge.  Sorry it took so long to port to the  			FT driver......  P ********************************************************************************P *******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /*                        # I N C L U D E   F I L E S                         */P /*                                                                            */P /******************************************************************************/  
 #include file 
 #include stat  #include descrip #include rms #include rmsdef  #include limits  #include ssdef #include climsgdef #include jpidef  #include ttdef #include tt2def  #include prvdef  #include prcdef  #include dvidef  #include iodef #include uaidef  #include lnmdef  #include libdef  #include syidef  #include ctype
 #include time  #include sjcdef  #include stdlib  #include string  #include unixio   P /******************************************************************************/P /*                                                                            */P /*                             # D E F I N E S                                */P /*                                                                            */P /******************************************************************************/  ' #define DEFAULT_PRINT_QUEUE "SYS$PRINT"   D #define STATUS_STR_MAX 255		/* max. length of SNDJBC status mess. */A #define COMMAND_MAX 512			/* max. length of command line	      */ A #define ACCOUNT_MAX 12			/* max. length of account string      */ A #define FT_NAME_MAX 64			/* max. length of FT device name      */ ? #define PNAME_MAX 15			/* max. length of a process name      */ ? #define USERNAME_MAX 15			/* max. length of a username	      */  #define QUEUE_MAX 39 #define CARRIAGE_RETURN 13 #define LINE_FEED 10 #define CONTROL_Z 263 #define TOGGLE_LOG 28			/* toggle logging		      */ ; #define TOGGLE_STAMP 30			/* toggle time stamping		      */ 7 #define TIME_MAX 50			/* for full time string		      */ ? #define MAX_REC 1024			/* max. length of log file record     */ A #define TT_BUF_MAX 512			/* max. length of read from TTY	      */ B #define IN_BUF_MAX 4096			/* max. length of read/write to file  */= #define TEMPBUF_MAX 512			/* for formatting messages	      */ @ #define FT_DATA_MAX 508			/* one page - status longword	      */ #define TT_DATA_MAX FT_DATA_MAX  #define XOFF 0x13  #define XON 0x11 #define BELL 0x7 #define ON 1
 #define OFF 0  #define TRUE 1 #define FALSE 0  #define CANCEL 3 #define NO_INPUT 2 #define SUCCESS 1  #define FAILURE 0  #define SECONDS_IN_DAY 86400 #define INT_STR_MAX 15 #define NUM_IO_BUFFERS 3 #define PAGE_SIZE 0x200   B #define PTD$C_SEND_XON		0	/* Pseudo Terminal Driver event       */C #define PTD$C_SEND_BELL		1	/* types. When these are in           */ C #define PTD$C_SEND_XOFF 	2	/* SYS$LIBRARY:VAXCDEF.TLB they       */ D #define PTD$C_STOP_OUTPUT	3	/* should be removed from here.	      */ #define PTD$C_RESUME_OUTPUT 	4 #define PTD$C_CHAR_CHANGED 	5  #define PTD$C_ABORT_OUTPUT 	6  #define PTD$C_START_READ 	7  #define PTD$C_MIDDLE_READ 	8 #define PTD$C_END_READ 		9 #define PTD$C_ENABLE_READ 	10  #define PTD$C_DISABLE_READ 	11 #define PTD$C_MAX_EVENTS 	12  P /******************************************************************************/P /*                                                                            */P /*          S T R U C T U R E S ,   U N I O N S ,   T Y P E D E F S           */P /*                                                                            */P /******************************************************************************/   #pragma nomember_alignment  A typedef	 unsigned  int   UINT;		/* for unsigned integers	      */ G typedef	 unsigned  long  ULONG;		/* for unsigned long integers	      */ H typedef	 unsigned  short USHORT;	/* for unsigned short integers	      */D typedef	 unsigned  char  UCHAR;		/* for unsigned characters	      */H typedef	 unsigned  char  TINY;		/* more descriptive for using un-     */' 					/* characters as integers	      */    typedef	 struct	  ITM_TYPE { 	 USHORT	  buf_len, 
 		  itm_code;  	 char 	  *buf_addr; 	 USHORT	  *ret_len;
 } ITM_LST;  = typedef	 struct	  {			/* run-time and computed flags	      */ 2 	 UCHAR	  expert,		/* no welcome message		      */* 		  exact,		/* do exact logging?		      */. 		  delete,		/* deleting a log file?		      */9 		  time_stamp,		/* start with time-stamping enabled?  */ 7 		  retrieve,		/* someone retrieving a log file?     */ 1 		  skim,			/* set if /SKIMming old logs	      */ 2 		  mail,			/* set if /MAILing a log file	      */2 		  save,			/* set if /SAVEing a log file	      *// 		  print,		/* set if /PRINT specified	      */ 5 		  verified;		/* set if /VERIFIED specified	      */ 
 } ARG_DEF;  0 typedef	 struct	  {			/* program flags		      */1 	 UCHAR	  hangups,		/* hangups enabled?		      */ * 		  logging,		/* are we logging?		      */2 		  time_stamp,		/* are we time-stamping?	      *// 		  verify,		/* are we still verified?	      */ 6 		  command;		/* set if input from TTY is a command */G 	 char	  filename[NAM$C_MAXRSS+1]; /* logfile name without dev/dir.  */  } FLAG_DEF;   H typedef	 struct	  SENSE_TYPE {		/* SENSEMODE structure for terminals  */, 	 UCHAR	  class,		/* device class			      */% 		  type;			/* device type			      */ / 	 USHORT	  buf_size;		/* buffer size			      */ < 	 UINT	  characts : 24;	/* terminal characteristics	      */. 	 UCHAR	  page_len;		/* page length			      */9 	 ULONG	  ext_char,		/* extended characteristics	      */ 8 		  ext_char2;		/* even more extended characteristics */ } SENS_DEF;   D typedef	 struct	  IO2_TYPE {		/* SENSEMODE I/O status block	      */. 	 USHORT	  status;		/* status value			      */3 	 UCHAR	  t_speed,		/* transmit baud rate		      */ , 		  r_speed,		/* receive baud rate		      */( 		  cr_fill,		/* CR fill count		      */( 		  lf_fill,		/* LF fill count		      */' 		  parity,		/* parity flags			      */ . 		  dummy;		/* dummy padding variable	      */
 } IO2_DEF;  = typedef	 struct	  ITEM_TYPE {		/* message item type		      */ ) 	 short	  size,			/* item size			      */ # 		  code;			/* item code			      */ 4 	 char	  *ptr;			/* variable-length message	      */ } ITEM_DEF;   F typedef	 struct	  IOSB_TYPE {	      	/* I/O status block type	      */2 	 USHORT	  status,		/* completion status		      */% 	 	  count,		/* byte count			      */ 2 		  terminator,		/* terminator character		      */9 		  term_count;		/* number of characters in terminator */  } IOSB_DEF;   5 typedef	 struct	  {			/* exit handler block		      */ 2 	 ULONG	  forward_link;		/* used by VMS			      */@ 	 void	  (*routine)();		/* address of exit handler routine    */1 	 UCHAR	  arg_count,		/* argument count		      */ * 		  dummy[3];		/* must be zeros!		      */= 	 ULONG	  *condition;		/* address of condition value	      */ 
 } EXH_DEF;  > typedef	 struct	  {			/* holds ASCII/longword id pairs      */2 	 char	  *id_string;		/* ASCII identifer		      */4 	 ULONG	  id;			/* integer identifier value	      */	 } ID_DEF;   ; typedef	 struct	  {			/* terminator character mask	      */  	 USHORT	  size, 		  unused;  	 USHORT	  *ptr; } TERM_DEF;   0 typedef	 struct	  {			/* address_range		      */. 	 char	  *start,		/* start of a page		      */& 		  *end;			/* end of a page		      */ } ADDR_RAN;   7 typedef	 struct   {			/* FT device I/O buffer		      */ 5 	 USHORT	  status,		/* I/O completion status	      */ 4 		  count;		/* number of bytes read/written	      */6 	 UCHAR	  data[FT_DATA_MAX];	/* actual data			      */	 } FT_BUF;   P /******************************************************************************/P /*                                                                            */P /*   E X T E R N A L   D E F I N I T I O N S   &   D E C L A R A T I O N S    */P /*                                                                            */P /******************************************************************************/  
 #ifdef __DECC  extern	 ULONG	  joblog_cld;    #pragma extern_model save   #pragma extern_model globalvalue   extern		  CLI$M_NOWAIT,  		  JLG_NO_LOGICAL,  		  JLG_NO_LOGFILE,  		  JLG_NO_EXH,  		  JLG_CANT_QUEUE,  		  JLG_CANT_WRITE,  		  JLG_INUSE, 		  JLG_NO_SPAWN,  		  JLG_CANT_CANCEL_IO,  		  JLG_CANT_DELETE, 		  JLG_CANT_DASSGN, 		  JLG_CANT_RESET,  		  JLG_CANT_DELETE_LOG, 		  LIB$M_CLI_CTRLY;   #pragma extern_model restore   #else    globalref	  joblog_cld;    globalvalue	  CLI$M_NOWAIT,  		  JLG_NO_LOGICAL,  		  JLG_NO_LOGFILE,  		  JLG_NO_EXH,  		  JLG_CANT_QUEUE,  		  JLG_CANT_WRITE,  		  JLG_INUSE, 		  JLG_NO_SPAWN,  		  JLG_CANT_CANCEL_IO,  		  JLG_CANT_DELETE, 		  JLG_CANT_DASSGN, 		  JLG_CANT_RESET,  		  JLG_CANT_DELETE_LOG, 		  LIB$M_CLI_CTRLY;   #endif   extern	 char	  *mktemp(),  		  *cat(),  		  *strmcpy(),  		  *str_post_trim(),  		  *str_pref_trim();     extern	 ULONG	  CLI$DCL_PARSE(), 		  CLI$GET_VALUE(), 		  CLI$PRESENT(), 		  LIB$DISABLE_CTRL(),  		  LIB$ENABLE_CTRL(), 		  LIB$FIND_FILE(), 		  LIB$FIND_FILE_END(), 		  LIB$FREE_EF(), 		  LIB$GET_EF(),  		  LIB$GET_FOREIGN(), 		  LIB$GET_INPUT(), 		  LIB$GETJPI(),  		  LIB$SIGNAL(),  		  LIB$SPAWN(), 		  LIB$STOP(),  		  PTD$CANCEL(),  		  PTD$CREATE(),  		  PTD$DELETE(),  		  PTD$READ(), ! 		  PTD$SET_EVENT_NOTIFICATION(),  		  PTD$WRITE(), 		  SYS$ASCTIM(),  		  SYS$ASCTOID(), 		  SYS$ASSIGN(),  		  SYS$CANCEL(),  		  SYS$CANEXH(),  		  SYS$CLOSE(), 		  SYS$CONNECT(), 		  SYS$CREATE(),  		  SYS$DASSGN(),  		  SYS$DCLEXH(),  		  SYS$EXIT(),  		  SYS$EXPREG(),  		  SYS$FAO(), 		  SYS$FAOL(),  		  SYS$FINISH_RDB(),  		  SYS$FIND_HELD(), 		  SYS$GETDVI(),  		  SYS$GETJPI(),  		  SYS$GETUAI(),  		  SYS$QIO(), 		  SYS$QIOW(),  		  SYS$OPEN(),  		  SYS$PUT(), 		  SYS$READ(),  		  SYS$SETIMR(),  		  SYS$SETPRV(),  		  SYS$SNDJBCW(), 		  SYS$WAITFR(),  		  SYS$TRNLNM(),  		  SYS$WRITE();   extern	 long	  atol();   extern	 int	  delete(), 
 		  strins(), 
 		  strcmp(), 
 		  getpid();    extern	 void	  strlu(),  		  exit();   P /******************************************************************************/P /*                                                                            */P /*     S T A T I C   D E F I N I T I O N S   &   D E C L A R A T I O N S      */P /*                                                                            */P /******************************************************************************/  - static	 ULONG	  write_tt(short,char *,ULONG), 5 		  get_file(char *,char *,struct FAB *,struct RAB *, , 			   struct XABPRO *,ARG_DEF *,FLAG_DEF *),$ 		  copy_file(char *,char *,USHORT),# 		  print_log(char *,USHORT,UCHAR), , 		  retrieve_log(char *,ARG_DEF *,USHORT *),! 		  delete_mlog(char *,USHORT *), " 		  class_retrieve(char *,char *),! 		  user_retrieve(char *,char *),  		  ctrlc_trap(void),  		  ctrly_trap(USHORT),  		  write_ft(USHORT,FT_BUF *), 		  save_log(char *,USHORT),2 		  my_gets(USHORT,char *,char *,USHORT *,USHORT),) 		  mail_log(char *,char *,USHORT,UCHAR), 
 		  tt_r_efn,  		  ft_efn, 
 		  wait_efn;   . static	 long	  bintim[2] = {-5*10*100*100,-1};  < static	 USHORT	  ft_chan,		/* channel to FT device		      */) 		  tt_chan,		/* channel to TTY		      */ A 		  disp_failed = FALSE,	/* set if disposition of log fails    */ @ 		  clean_exit = FALSE,	/* set if good exit of subprocess     */% 		  term_mask[8] = {0,0,0,0,0,0,0,0},  		  valid_recip(char *), 		  delete_log(char *);   # static	 void	  get_args(ARG_DEF *), / 		  get_channels(USHORT *,USHORT *,ADDR_RAN *),* 		  ft_ast(void),* 		  log_session(USHORT,USHORT),*5 		  write_log(char *,USHORT,struct RAB *,FLAG_DEF *),*8 		  ask_disposition(char *,char *,FLAG_DEF *,ARG_DEF *), 		  welcome(ARG_DEF *),v 		  ctrlc_ast(void), 		  ctrly_ast(void), 		  skim(char *),m! 		  squeeze_str(register char *),0 		  quit(void),. 		  quit2(void), 		  subprocess_exit(void), 		  spawn(ULONG *),a2 		  parse_filename(char *,char *,char *,USHORT *)," 		  warn(char *,UINT,int,int,int), 		  dev_chg_ast(void),  		  get_logicals(char *,char *), 		  my_puts(char *), 		  joblog_check(void),t 		  xon_ast(void), 		  xoff_ast(void),y 		  bell_ast(void),e 		  kill_log(void);N                   C static	 char	  ftname[FT_NAME_MAX+1],/* name of FT device		      */eB 		  stamp_buf[TIME_MAX+3], /* for holding time stamp string     */5 		  logfile[NAM$C_MAXRSS], /* log file name		      */fB 		  log_dir[NAM$C_MAXRSS], /* where log files are created	      */B 		  stage_dir[NAM$C_MAXRSS], /* where mailed log files live     */ 		  *get_start_stamp(char *),e 		  *get_stamp(char *);E  H static	 IOSB_DEF tt_read_iosb,		/* read I/O status block for TTY      */; 		  tt_write_iosb;	/* write I/O status block for TTY     */	  < static	 FT_BUF	  *ft_buf,		/* FT device I/O buffer		      */) 		  *tt_buf,		/* TTY I/O buffer		      */e4 		  *cr_buf;		/* Carriage-return I/O buffer	      */  H static	 SENS_DEF tty_save_char;	/* for saving TTY characteristics     */  3 static	 TERM_DEF term_block = {32,0,&term_mask[0]};e   static	 struct	  FAB	  log_fab;a   static	 struct	  RAB	  log_rab;d  $ static	 struct	  XABPRO  log_xabpro;  3 static	 FLAG_DEF flags;		/* global flags			      */n  8 static	 ARG_DEF  args;			/* run-time arguments		      */   static	 ULONG	  privs[2],x 		  old_privs[2];o /*
 #ifdef __DECC  static	 union	  prvdef  privs;" static	 union	  prvdef  old_privs; #elsea/ static	 union	  prvdef  _align(longword) privs;r3 static	 union	  prvdef  _align(longword) old_privs;i #endif */   static $DESCRIPTOR(tt_d,"TT:");   static $DESCRIPTOR(ft_d,ftname); static $DESCRIPTOR(mess_d,""); 	P /******************************************************************************/P /*                                                                            */P /*                        M A I N   P R O C E S S I N G                       */P /*                                                                            */P /******************************************************************************/   main()  7 {	/*** main ***/                                       e- 					/********   LOCAL  VARIABLES   ********/.> static	 ULONG	  status,		/* return code status holder	      */7 		  subproc_pid;		/* PID of spawned subprocess	      *//1  	 EXH_DEF  exh_blk = {0L,&quit,0,0,0,0,&status};S static	 ADDR_RAN io_buffers;     #ifndef PHOTO_MODE  9    get_args(&args); 			/* get run-time arguments	      */s  9    /* get logicals for the log and staging directories */E  #    get_logicals(log_dir,stage_dir);s   #endif  ?    if(args.retrieve)			/* someone retrieving a logfile?      */l-       retrieve_log(stage_dir,&args,&tt_chan);     else if(args.delete)lM       delete_mlog(stage_dir,&tt_chan);	/* deleting a mailed logfile?	      */     else if(args.skim)n:       skim(stage_dir);			/* skim old JOBLOG files	      */    else     {@       joblog_check();			/* don't let user run JOBLOG twice    */  %       status = LIB$GET_EF(&tt_r_efn);           if(!(status & SS$_NORMAL)) 	 LIB$STOP(status);   %       status = LIB$GET_EF(&wait_efn);C          if(!(status & SS$_NORMAL)) 	 LIB$STOP(status);$  #       status = LIB$GET_EF(&ft_efn);           if(!(status & SS$_NORMAL)) 	 LIB$STOP(status);   6       /* someone is actually logging a session here */  D       flags.verify = TRUE;		/* assume we are verified to start    */)       flags.time_stamp = args.time_stamp;	         /* open the log file */n  L       status = get_file(logfile,log_dir,&log_fab,&log_rab,&log_xabpro,&args, 			&flags);S         if(status != RMS$_NORMAL)s< 	 LIB$STOP(JLG_NO_LOGFILE);	/* major problems here		      */  I       /* write a time stamp at the start of the log file if time stamping         * is enabledt	        */          if(flags.time_stamp)       {d2 	 flags.command = TRUE;		/* to fool write_log() */ 	 get_start_stamp(stamp_buf); 9 	 write_log(stamp_buf,strlen(stamp_buf),&log_rab,&flags);i< 	 stamp_buf[0] = '\0';		/* clear it out before blank line */= 	 write_log("\n",1,&log_rab,&flags);	/* write a blank line */t       }   6       /* set up channels to everything we will need */  2       get_channels(&tt_chan,&ft_chan,&io_buffers);  <       /* set the pointers to the buffers that we will use */  +       ft_buf = (FT_BUF *) io_buffers.start;*9       tt_buf = (FT_BUF *) (io_buffers.start + PAGE_SIZE); ?       cr_buf = (FT_BUF *) (io_buffers.start + (PAGE_SIZE * 2));   !       /* write welcome message */          welcome(&args);   #       /* declare an exit handler */   $       status = SYS$DCLEXH(&exh_blk);          if(!(status & SS$_NORMAL))       {*
 	 kill_log();* 	 LIB$STOP(JLG_NO_EXH);*       }*  .       /* spawn a subprocess that we can use */         spawn(&subproc_pid);  E       flags.logging = TRUE;  		/* start out by logging stuff	      */c       flags.command = FALSE;         /* log the session */e  #       log_session(ft_chan,tt_chan);     }   }	/*** main ***/ eP /*******************************************************************************P ********************************************************************************     Function:	get_args  9   Purpose:	Get run-time arguments and store in structure.      Formal Parameters:   	Name			Description  	----			----------- # 	args			command-line argument flags      Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------  	none      Return Codes:    	Code			Reason 	----			------ 	none*  P ********************************************************************************P *******************************************************************************/  # static void get_args(ARG_DEF *args)n   {	/*** get_args ***/2 	     				/********   LOCAL  VARIABLES   ********/8 	 ULONG	  status;		/* return code status holder	      */6 	 USHORT	  length;		/* length of command line	      */M static	 char	  command[COMMAND_MAX+1]; /* for building a command to parse  */rK static $DESCRIPTOR(cmdline_d,command);	/* for parsing command line	      */E& static $DESCRIPTOR(delete_d,"DELETE");& static $DESCRIPTOR(expert_d,"EXPERT");" static $DESCRIPTOR(mail_d,"MAIL");" static $DESCRIPTOR(save_d,"SAVE");$ static $DESCRIPTOR(print_d,"PRINT");* static $DESCRIPTOR(retrieve_d,"RETRIEVE");" static $DESCRIPTOR(skim_d,"SKIM");. static $DESCRIPTOR(time_stamp_d,"TIME_STAMP");* static $DESCRIPTOR(verified_d,"VERIFIED");    #    /* first get the command line */   4    status = LIB$GET_FOREIGN(&cmdline_d,0,&length,0);      if(!(status & SS$_NORMAL))0       LIB$STOP(status);l       /* insert the verb we need */      command[length] = '\0';    strins(command,"JOBLOG",0);5    cmdline_d.dsc$w_length = (USHORT) strlen(command);   4    /* now parse it so we can check for qualifiers */  A    status = CLI$DCL_PARSE(&cmdline_d,&joblog_cld,&LIB$GET_INPUT);       if(status != CLI$_NORMAL)       LIB$STOP(status);   1    if(CLI$PRESENT(&time_stamp_d) == CLI$_PRESENT)d       args->time_stamp = TRUE;    else        args->time_stamp = FALSE;   -    if(CLI$PRESENT(&expert_d) == CLI$_PRESENT)F       args->expert = TRUE;    else        args->expert = FALSE;O  ,    if(CLI$PRESENT(&print_d) == CLI$_PRESENT)       args->print = TRUE;U    elsef       args->print = FALSE;  /    if(CLI$PRESENT(&retrieve_d) == CLI$_PRESENT)_       args->retrieve = TRUE;    else        args->retrieve = FALSE;f   +    if(CLI$PRESENT(&save_d) == CLI$_PRESENT)_       args->save = TRUE;    else	       args->save = FALSE;*  *+    if(CLI$PRESENT(&mail_d) == CLI$_PRESENT)*       args->mail = TRUE;    else        args->mail = FALSE;    +    if(CLI$PRESENT(&skim_d) == CLI$_PRESENT)        args->skim = TRUE;    else        args->skim = FALSE;   -    if(CLI$PRESENT(&delete_d) == CLI$_PRESENT)     {       args->delete = TRUE;       args->time_stamp = TRUE;    }    else*       args->delete = FALSE;   /    if(CLI$PRESENT(&verified_d) == CLI$_PRESENT)t       args->verified = TRUE;    else        args->verified = FALSE;U  
    return;   }	/*** get_args ***/  P /*******************************************************************************P ********************************************************************************     Function:	quit  6   Purpose:	Exit handler used to clean up a few things.     Formal Parameters:   	Name			Description_ 	----			-----------f 	none      Global variables:	  % 	Name			Examine/Modify/Use/Read/Write_% 	----			-----------------------------m 	tt_chan					X 	ft_chan					X 	tty_save_char				X  	log_fab					X 	log_xabpro			  Xx 	logfile					X 	flags					X 	stage_dir				Xe 	args					Xg 	mess_d				  X	X 	clean_exit		   Xp 	privs				  X	Xt 	JLG_CANT_CANCEL_IO			X  	JLG_NO_EXH				X 	JLG_CANT_DASSGN				Xl 	JLG_CANT_RESET				X     Return Codes:S   	Code			Reason 	---- 			------l 	nones     Termination Codes:   	Code			Reason 	----			------ 	statusa  P ********************************************************************************P *******************************************************************************/   static void quit(void)   {	/*** quit ***/- 					/********   LOCAL  VARIABLES   ********/a> static	 ULONG	  status,		/* return code status holder	      */5 		  length;		/* length of device char. block	      */ 8 static	 EXH_DEF  exh2_blk = {0L,&quit2,0,0,0,0,&status}; static	 IOSB_DEF iosb;     #ifndef PHOTO_MODE  <    /* make sure SYSPRV is on so we can close the log file */      privs[0] = PRV$M_SYSPRV;r    privs[1] = 0L;s  -    status = SYS$SETPRV(ON,&privs,FALSE,NULL);/      if(!(status & SS$_NORMAL))     {       LIB$SIGNAL(status);b
       return;     }  I    /* set the protection to override any default the user might've set */e  H    log_xabpro.xab$w_pro = ((XAB$M_NOREAD | XAB$M_NOWRITE | XAB$M_NOEXE |4 			    XAB$M_NODEL) << XAB$V_GRP) | ((XAB$M_NOREAD |1 			    XAB$M_NOWRITE | XAB$M_NOEXE | XAB$M_NODEL)c 			    << XAB$V_WLD);E   #endif  @    status = SYS$CLOSE(&log_fab);	/* close the log file		      */      if(status != RMS$_NORMAL)    {       delete_log(logfile);       LIB$STOP(status);	    }   #ifndef PHOTO_MODE      /* turn SYSPRV off again */      privs[0] = PRV$M_SYSPRV; .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))     {       LIB$SIGNAL(status);r
       return;     }   #endif      if(clean_exit == FALSE)    {G       /* oops, we had problems here; someone must've killed the process G        * because we got here without detecting hangup on the FT device;rD        * this normally means that there is no TTY left to talk to so-        * we just kill the logfile and get outc	        */y         delete_log(logfile);
       return;m    }   #ifndef PHOTO_MODE  E    /* declare ANOTHER exit handler to delete the log file in case the H     * user decides to do something drastic like a disconnect between now*     * and when ask_disposition() is called     */  "    status = SYS$DCLEXH(&exh2_blk);      if(!(status & SS$_NORMAL))	    {       delete_log(logfile);       LIB$STOP(JLG_NO_EXH);	    }   #endif  F    /* clean up some things; start by cancelling I/O on all channels */       status = SYS$CANCEL(tt_chan);      if(!(status & SS$_NORMAL))     {#       mess_d.dsc$a_pointer = "TTY"; B       mess_d.dsc$w_length = (USHORT) strlen(mess_d.dsc$a_pointer);0       LIB$SIGNAL(JLG_CANT_CANCEL_IO,1L,&mess_d);    }       status = PTD$CANCEL(ft_chan);      if(!(status & SS$_NORMAL))     {"       mess_d.dsc$a_pointer = "FT";B       mess_d.dsc$w_length = (USHORT) strlen(mess_d.dsc$a_pointer);0       LIB$SIGNAL(JLG_CANT_CANCEL_IO,1L,&mess_d);    }  +    /* now delete and deassign some stuff */        status = PTD$DELETE(ft_chan);      if(!(status & SS$_NORMAL))*    {"       mess_d.dsc$a_pointer = "FT";B       mess_d.dsc$w_length = (USHORT) strlen(mess_d.dsc$a_pointer);-       LIB$SIGNAL(JLG_CANT_DASSGN,1L,&mess_d);*    }  G    /* reset the user's privs; this is done just in case they had LOG_IO C     * and PHY_IO on when they started and we need to twiddle HANGUPT     */  1    status = SYS$SETPRV(ON,&old_privs,FALSE,NULL);       if(!(status & SS$_NORMAL))        LIB$SIGNAL(status);   5    /* set the terminal mode back to the way it was */*     *    length = (ULONG) sizeof(tty_save_char);  M    status = SYS$QIOW(0,tt_chan,IO$_SETMODE,&iosb,0,0,&tty_save_char,length,0,a 		     0,0,0);  2    if(!(status & SS$_NORMAL) && (status != 10300))!       LIB$SIGNAL(JLG_CANT_RESET);_   #ifndef PHOTO_MODE  $    /* ask user what should happen */  3    ask_disposition(logfile,stage_dir,&flags,&args);,  H    /* kill the secondary exit handler so that it doesn't kick in when we
     * exit     */  "    status = SYS$CANEXH(&exh2_blk);      if(!(status & SS$_NORMAL))l       LIB$SIGNAL(JLG_NO_EXH);    #elseG  4    my_puts("\n\nLog file written to JOBLOG.LOG.\n");   #endif  M    my_puts("\nExiting JOBLOG.  Remember YOU ARE STILL LOGGED IN!!!\7\7\7\n");_    exit(0);_   }	/*** quit ***/ AP /*******************************************************************************P ********************************************************************************     Function:	get_channels  I   Purpose:	Assign channels to both the TTY and the FT device, SETMODE theR 		TTY.     Formal Parameters:   	Name			Description( 	----			-----------( 	tt_chan			channel to TTY, 	ft_chan			channel to FT device_* 	io_buffers		I/O buffers used by FT device     Global variables:I  % 	Name			Examine/Modify/Use/Read/Write,% 	----			-----------------------------  	tt_d				  X	X 	ft_d				  X 	tty_save_char			  X 	ftname				  X	X	V     Return Codes:    	Code			Reason 	----			------ 	none	     Termination Codes:   	Code			Reason 	----			------/ 	status			return code from various system callsN  P ********************************************************************************P *******************************************************************************/  N static void get_channels(USHORT *tt_chan,USHORT *ft_chan,ADDR_RAN *io_buffers)+                                            ) {	/*** get_channels ***/- 					/********   LOCAL  VARIABLES   ********/)8 	 ULONG	  status,		/* return code status holder	      */1 		  length,		/* length of tty_char block	      */ 3 		  tt_efn;		/* event flag for IO$_SETMODE	      */)6 static	 IOSB_DEF iosb;			/* I/O status block		      */B static	 SENS_DEF tty_char,		/* TTY characteristics to set	      */3 		  ft_char;		/* FT characteristics to set	      */ : static	 ULONG	  ft_num;		/* device # of FT device	      */C static	 USHORT	  ft_name_len;		/* length of FT device name	      *//F static	 ITM_LST  items[] = {		/* for getting FT characteristics     */1 {sizeof(ftname),DVI$_DEVNAM,ftname,&ft_name_len},*
 {0,0,0L,0L}};*    )    /* get a channel for the user's TTY */t  *    status = SYS$ASSIGN(&tt_d,tt_chan,0,0);      if(!(status & SS$_NORMAL))*    {       kill_log();,       LIB$STOP(status);	    }  J    /* get an event flag to use for setting the terminal characteristics */       status = LIB$GET_EF(&tt_efn);      if(!(status & SS$_NORMAL))     {       kill_log();        LIB$STOP(status);i    }  *    /* now set the mode for the terminal */  G    length = sizeof(tty_char);		/* get length of tty char. block      */O  M    status = SYS$QIO(tt_efn,*tt_chan,IO$_SENSEMODE,&iosb,0,0,&tty_char,length,r 		    0,0,0,0);             n    if(!(status & SS$_NORMAL))     {       kill_log();[       LIB$STOP(status);     }      status = SYS$WAITFR(tt_efn);o      if(!(status & SS$_NORMAL)),    {       kill_log();        LIB$STOP(status);A    }  >    /* copy the current TTY mode so it can be restored later */  L    memcpy((void *) &tty_save_char,(void *) &tty_char,sizeof(tty_save_char));      /* for the FT device	*/  @    memcpy((void *) &ft_char,(void *) &tty_char,sizeof(ft_char));  :    /* now set up the TTY characteristics we need to run */  $    tty_char.characts |= TT$M_NOECHO;  H    /* set the TTY to HOSTSYNC and TTSYNC; if we don't, vt220's will hang&     * because of flow control problems     */  $    tty_char.characts |= TT$M_TTSYNC;&    tty_char.characts |= TT$M_HOSTSYNC;&    tty_char.ext_char |= TT2$M_PASTHRU;  H    /* ignoring the IOSB status code from the following call to SYS$QIO()G     * is no accident -- we don't even want to know whether it complainsI#     * about HANGUP or not; Grrr....d     */  O    status = SYS$QIO(tt_efn,*tt_chan,IO$_SETMODE,&iosb,0,0,&tty_char,length,0,0,o 		    0,0);       if(!(status & SS$_NORMAL))t    {       kill_log();i       LIB$STOP(status);     }  -    /* wait for the IO$_SETMODE to complete */c      status = SYS$WAITFR(tt_efn);X      if(!(status & SS$_NORMAL))r    {       kill_log();A       LIB$STOP(status);n    }    *A    /* throw the event flag away since we don't need it anymore */   !    status = LIB$FREE_EF(&tt_efn);h      if(!(status & SS$_NORMAL))     {       kill_log();        LIB$STOP(status);     }  6    /* expand the P0 region to make some I/O buffers */  6    status = SYS$EXPREG(NUM_IO_BUFFERS,io_buffers,0,0);      if(!(status & SS$_NORMAL))T       LIB$STOP(status);v      /* create an FT device */  L    status = PTD$CREATE(ft_chan,0,&ft_char,sizeof(ft_char),0,0,0,io_buffers);      if(!(status & SS$_NORMAL))y    {       kill_log();        LIB$STOP(status);/    }  +    /* set up some AST's for good measure */}  M    status = PTD$SET_EVENT_NOTIFICATION(*ft_chan,&xon_ast,0,0,PTD$C_SEND_XON);t      if(!(status & SS$_NORMAL))     {       kill_log();	       LIB$STOP(status);*    }  O    status = PTD$SET_EVENT_NOTIFICATION(*ft_chan,&xoff_ast,0,0,PTD$C_SEND_XOFF);]      if(!(status & SS$_NORMAL))f    {       kill_log();        LIB$STOP(status);n    }  O    status = PTD$SET_EVENT_NOTIFICATION(*ft_chan,&bell_ast,0,0,PTD$C_SEND_BELL);c      if(!(status & SS$_NORMAL)))    {       kill_log();        LIB$STOP(status);,    }  A    status = PTD$SET_EVENT_NOTIFICATION(*ft_chan,&dev_chg_ast,0,0,  				       PTD$C_CHAR_CHANGED);*      if(!(status & SS$_NORMAL))*    {       kill_log();        LIB$STOP(status);     }  F    /* get the device number of the FT device so we know what SYS$INPUT8     * and SYS$OUTPUT are called when we call LIB$SPAWN()     */  8    status = SYS$GETDVI(0,*ft_chan,0,&items,&iosb,0,0,0);      if(!(status & SS$_NORMAL))*    {       kill_log();*       LIB$STOP(status);/    }  @    /* get rid of the leading underscore in the FT device name */      ftname[ft_name_len] = '\0';    strcpy(ftname,&ftname[1]);t'    ft_d.dsc$w_length = ft_name_len - 1;/  
    return;   }	/*** get_channels ***/ eP /*******************************************************************************P ********************************************************************************     Function:	spawn   7   Purpose:	Spawn a subprocess to talk to the FT device.      Formal Parameters:   	Name			Description  	----			-----------)  	pid			returns PID of subprocess     Global variables:e  % 	Name			Examine/Modify/Use/Read/Writes% 	----			-----------------------------t 	privs				  X	X; 	old_privs			  X	X 	ft_d					X      Return Codes:a   	Code			Reason 	----			------ 	nonek     Termination Codes:   	Code			Reason 	----			------/ 	status			return code from various system calls   P ********************************************************************************P *******************************************************************************/                  static void spawn(ULONG *pid)t   {	/*** spawn ***/f- 					/********   LOCAL  VARIABLES   ********/$8 	 ULONG	  status,		/* return code status holder	      */4 		  current_pid,		/* PID of current process	      */4 		  flags;		/* flags for SPAWNing subprocess      */5 	 short	  length;		/* length of process name	      */nK static	 char	  procname[PNAME_MAX+1],/* current process name array	      */gB 		  newname[PNAME_MAX+1];	/* process name for JOBLOG subprocess */M static $DESCRIPTOR(procname_d,procname); /* for getting process name	      */tK static $DESCRIPTOR(newname_d,newname);	/* for setting process name	      */ N static $DESCRIPTOR(prompt_d,"Joblog> "); /* DCL prompt when in JOBLOG	      */* static $DESCRIPTOR(format_d,"JOBLOG_!XL"); static	 ULONG	  tmp_privs[2];s /*
 #ifdef __DECC&# static	 union	  prvdef   tmp_privs;c #else 5 static	 union	  prvdef   _align(longword)  tmp_privs;f #endif */      C    current_pid = getpid();		/* get PID for current process	      */   7    /* make the process name that we are going to use */f  G    status = SYS$FAO(&format_d,&length,&newname_d,current_pid & 0xFFFF);       if(!(status & SS$_NORMAL))s    {       kill_log();(       LIB$STOP(status);r    }   #ifndef PHOTO_MODE  L    /* put the current process back to it's default privileges so that we can!     * give them to the subprocess)     * J     * NOTE:  changes in privs are temporary; when we exit we don't have to@     *        reset anything since they'll be reset automatically     */      privs[0] = ULONG_MAX;    privs[1] = ULONG_MAX;  .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))/    {       kill_log();u       LIB$STOP(status);.    }  =    /* turn on the privs the user had when we first started */t      tmp_privs[0] = old_privs[0];i    tmp_privs[1] = old_privs[1];*  1    status = SYS$SETPRV(ON,&tmp_privs,FALSE,NULL);*      if(!(status & SS$_NORMAL))*    {       kill_log();*       LIB$STOP(status);*    }   #endif  #    newname_d.dsc$w_length = length;u    newname[length] = '\0';     A    /* FINALLY!  we spawn a subprocess to talk to the FT device */       flags = CLI$M_NOWAIT;  >    status = LIB$SPAWN(0,&ft_d,&ft_d,&flags,&newname_d,pid,0,0,( 		      &subprocess_exit,0,&prompt_d,0);      if(!(status & SS$_NORMAL))     {       kill_log();	       LIB$STOP(status);*    }   #ifndef PHOTO_MODE      privs[0] = ULONG_MAX;    privs[1] = ULONG_MAX;  .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))c    {       kill_log();r       LIB$STOP(status);*    }  =    /* turn on the privs the user had when we first started */s      tmp_privs[0] = old_privs[0];     tmp_privs[1] = old_privs[1];t  1    status = SYS$SETPRV(ON,&tmp_privs,FALSE,NULL);M      if(!(status & SS$_NORMAL))m    {       kill_log();c       LIB$STOP(status);m    }   #endif  
    return;   }	/*** spawn ***/c EP /*******************************************************************************P ********************************************************************************     Function:	ft_ast  %   Purpose:	AST routine for FT device.t     Formal Parameters:   	Name			DescriptionT 	----			-----------_ 	none;     Global variables:r  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------$ 	tt_chan					X 	ft_chan					X
 	ft_efn					X( 	ft_buf			   X		X) 	log_rab					X 	flags					X 	mess_d				  X	X     Return Codes:    	Code			Reason 	----			------ 	nonem     Termination Codes:   	Code			Reason 	----			------, 	status			problems queuing read on FT device 	JLG_CANT_QUEUEi  P ********************************************************************************P *******************************************************************************/   static void ft_ast(void)   {	/*** ft_ast ***/- 					/********   LOCAL  VARIABLES   ********/ > static	 ULONG	  status;		/* return code status holder	      */    3    /* check that the read on the FT completed ok */   %    if(!(ft_buf->status & SS$_NORMAL))N    {       kill_log();R       LIB$STOP(ft_buf->status);     }  :    /* write what was read from the FT device to the TTY */  A    write_tt(tt_chan,(char *) ft_buf->data,(ULONG) ft_buf->count);       if(flags.logging)E       write_log((char *) ft_buf->data,ft_buf->count,&log_rab,&flags);a  H    status = PTD$READ(0,ft_chan,&ft_ast,0,&(ft_buf->status),FT_DATA_MAX);      if(!(status & SS$_NORMAL))s    {       kill_log();i       LIB$STOP(status); :       mess_d.dsc$a_pointer = "read on FT device (in ast)";B       mess_d.dsc$w_length = (USHORT) strlen(mess_d.dsc$a_pointer);*       LIB$STOP(JLG_CANT_QUEUE,1L,&mess_d);    }  
    return;   }	/*** ft_ast ***/  P /*******************************************************************************P ********************************************************************************     Function:	dev_chg_ast*  G   Purpose:	Called when the FT device characteristics are changed.  Here*. 		the TT characteristics are changed to match.     Formal Parameters:   	Name			Descriptioni 	----			-----------: 	nonea     Global variables:a  % 	Name			Examine/Modify/Use/Read/WriteN% 	----			-----------------------------f 	ft_chan					X 	tt_chan					X     Return Codes:/   	Code	 		Reasont 	----			------ 	none-     Termination Codes:   	Code			Reason 	----			------" 	status			return code from SYS$QIO  P ********************************************************************************P *******************************************************************************/   static void dev_chg_ast(void)l   {	/*** dev_chg_ast ***/ - 					/********   LOCAL  VARIABLES   ********/-> static	 ULONG	  status;		/* return code status holder	      */5 static	 USHORT	  speed,		/* speed of device		      */*$ 		  fill;			/* fill count			      */D static	 SENS_DEF dev_char;		/* for getting FT dev characteristics */ static	 IO2_DEF  sense_iosb,
 		  set_iosb;     ,    /* get the FT device's characteristics */  F    status = SYS$QIO(0,ft_chan,IO$_SENSEMODE,&sense_iosb,0,0,&dev_char,  		    sizeof(dev_char),0,0,0,0);      if(!(status & SS$_NORMAL))c       LIB$STOP(status);,  M    dev_char.characts |= TT$M_NOECHO;	/* make sure we're still NOECHO....   */ G    dev_char.ext_char |= TT2$M_PASTHRU;	/* ....and PASTHRU....		      */R:    speed = sense_iosb.t_speed | (sense_iosb.r_speed << 8);9    fill = sense_iosb.cr_fill | (sense_iosb.lf_fill << 8);   B    status = SYS$QIO(0,tt_chan,IO$_SETMODE,&set_iosb,0,0,&dev_char,7 		    sizeof(dev_char),speed,fill,sense_iosb.parity,0);*  2    if(!(status & SS$_NORMAL) && (status != 10300))       LIB$STOP(status);   
    return;   }	/*** dev_chg_ast ***/$ OP /*******************************************************************************P ********************************************************************************     Function:	bell_ast  C   Purpose:	Called when the FT device wants to tell the user to stop > 		sending input.  Just send a bell to the TTY.  If it fails it8 		isn't resent since this really isn't all that crucial.     Formal Parameters:   	Name			Description  	----			-----------L 	none)     Global variables:}  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------r 	tt_chan					X     Return Codes:s   	Code	 		Reasone 	----			------ 	nonet  P ********************************************************************************P *******************************************************************************/   static void bell_ast(void)   {	/*** bell_ast ***/- 					/********   LOCAL  VARIABLES   ********/hG static	 USHORT	  bell_char = BELL;	/* char to write to the TTY	      */t        bell_char = BELL;?    SYS$QIO(0,tt_chan,IO$_WRITEVBLK,0,0,0,&bell_char,1,0,0,0,0); 
    return;   }	/*** bell_ast ***/ ;P /*******************************************************************************P ********************************************************************************     Function:	xon_ast/  A   Purpose:	Called when XON is detected on the FT device.  Send an 9 		XON to the TTY.  If it fails it isn't resent since thisd  		really isn't all that crucial.     Formal Parameters:   	Name			DescriptionA 	----			-----------  	none      Global variables:f  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------T 	tt_chan					X     Return Codes:H   	Code	 		Reasond 	----			------ 	noneI  P ********************************************************************************P *******************************************************************************/   static void xon_ast(void)t   {	/*** xon_ast ***/d- 					/********   LOCAL  VARIABLES   ********/iE static	 USHORT	  xon_char = XON;	/* char to write to the TTY	      */e        xon_char = XON;>    SYS$QIO(0,tt_chan,IO$_WRITEVBLK,0,0,0,&xon_char,1,0,0,0,0);
    return;   }	/*** xon_ast ***/d HP /*******************************************************************************P ********************************************************************************     Function:	xoff_ast  B   Purpose:	Called when XOFF is detected on the FT device.  Send an: 		XOFF to the TTY.  If it fails it isn't resent since this  		really isn't all that crucial.     Formal Parameters:   	Name			DescriptionI 	----			-----------E 	none      Global variables:   % 	Name			Examine/Modify/Use/Read/Writea% 	----			-----------------------------, 	tt_chan					X     Return Codes:y   	Code	 		Reasona 	----			------ 	nonee  P ********************************************************************************P *******************************************************************************/   static void xoff_ast(void)   {	/*** xoff_ast ***/- 					/********   LOCAL  VARIABLES   ********/DG static	 USHORT	  xoff_char = XOFF;	/* char to write to the TTY	      */*        xoff_char = XOFF;?    SYS$QIO(0,tt_chan,IO$_WRITEVBLK,0,0,0,&xoff_char,1,0,0,0,0);*
    return;   }	/*** xoff_ast ***/ *P /*******************************************************************************P ********************************************************************************     Function:	write_ft  0   Purpose:	Write data from TTY to the FT device.     Formal Parameters:   	Name			Descriptionu 	----			-----------  	ft_chan			channel to write to 	ft_buf			buffer to write,     Global variables:-  % 	Name			Examine/Modify/Use/Read/Write	% 	----			-----------------------------  	none      Return Codes:    	Code	 		Reason- 	----			------/ 	iosb->status		error return in I/O status block- 	SS$_NORMAL   P ********************************************************************************P *******************************************************************************/  4 static ULONG write_ft(USHORT ft_chan,FT_BUF *ft_buf)   {	/*** write_ft ***/- 					/********   LOCAL  VARIABLES   ********/r? register ULONG	  status;		/* return code status holder	      */n    <    status = PTD$WRITE(ft_chan,0,0,ft_buf,ft_buf->count,0,0);  7    if(status != SS$_NORMAL && status != SS$_DATAOVERUN)h    {       LIB$SIGNAL(status);        return(status);     }  G    if(ft_buf->status != SS$_NORMAL && ft_buf->status != SS$_DATAOVERUN)k    {!       LIB$SIGNAL(ft_buf->status);*       return(ft_buf->status);     }      return(SS$_NORMAL);   }	/*** write_ft ***/  P /*******************************************************************************P ********************************************************************************     Function:	write_tt     Purpose:	Write to the TTYV     Formal Parameters:   	Name			Description* 	----			-----------n 	channel			channel to write to 	buffer			buffer to writet$ 	length			length of buffer to write	     Global variables:i  % 	Name			Examine/Modify/Use/Read/Write}% 	----			-----------------------------s 	nonet     Return Codes:e   	Code	 		Reasona 	----			------. 	status			from SYS$QIO or IOSB of write to TTY     Termination Codes:   	Code			Reason 	----			------ 	noneo  P ********************************************************************************P *******************************************************************************/  > static ULONG write_tt(short channel,char *buffer,ULONG length)   {	/*** write_tt ***/- 					/********   LOCAL  VARIABLES   ********/u> static	 ULONG	  status;		/* return code status holder	      */6 static	 IOSB_DEF iosb;			/* I/O status block		      */    N    status = SYS$QIOW(0,channel,IO$_WRITEVBLK,&iosb,0,0,buffer,length,0,0,0,0);      if(!(status & SS$_NORMAL))c       return(status);s       if(iosb.status != SS$_NORMAL)       return(iosb.status);  >    /* make sure the right number of characters were written */  #    if((ULONG) iosb.count != length)wB       return(SS$_NOWRT);		/* didn't write the right amount      */      return(SS$_NORMAL);   }	/*** write_tt ***/ *P /*******************************************************************************P ********************************************************************************     Function:	get_stampc  (   Purpose:	Create the time stamp string.     Formal Parameters:   	Name			Descriptionr 	----			-----------r* 	stamp_buf		where to put time stamp string     Global variables:c  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------/ 	noneU     Return Codes:-   	Code	 		Reason- 	----			------* 	stamp_buf		pointer to where time stamp is     Termination Codes:   	Code			Reason 	----			------1 	status			return code from SYS$ASCTIM if it fails   P ********************************************************************************P *******************************************************************************/  ' static char *get_stamp(char *stamp_buf)c   {	/*** get_stamp ***/ - 					/********   LOCAL  VARIABLES   ********/C> static	 ULONG	  status;		/* return code status holder	      */M static	 char	  time_buf[TIME_MAX+1];	/* array for holding time string      */*G static $DESCRIPTOR(time_d,time_buf);	/* for getting time value	      */f    &    status = SYS$ASCTIM(0,&time_d,0,0);      if(!(status & SS$_NORMAL))o       LIB$STOP(status);T  (    time_buf[time_d.dsc$w_length] = '\0';#    cat(stamp_buf,"[",time_buf,"]");e  @    return(stamp_buf);			/* return pointer to time stamp str.  */   }	/*** get_stamp ***/  IP /*******************************************************************************P ********************************************************************************     Function:	get_start_stamp.  B   Purpose:	Create the greeting time stamp string for the log file.     Formal Parameters:   	Name			DescriptionI 	----			-----------D* 	stamp_buf		where to put time stamp string     Global variables:_  % 	Name			Examine/Modify/Use/Read/WriteN% 	----			-----------------------------$ 	nonea     Return Codes:;   	Code	 		Reasona 	----			------* 	stamp_buf		pointer to where time stamp is     Termination Codes:   	Code			Reason 	----			------1 	status			return code from SYS$ASCTIM if it fails*  P ********************************************************************************P *******************************************************************************/  - static char *get_start_stamp(char *stamp_buf)    {	/*** get_start_stamp ***/:- 					/********   LOCAL  VARIABLES   ********/ 8 	 ULONG	  status;		/* return code status holder	      */M static	 char	  time_buf[TIME_MAX+1];	/* array for holding time string      */uH static	 $DESCRIPTOR(time_d,time_buf);	/* for getting time value	      */    &    status = SYS$ASCTIM(0,&time_d,0,0);      if(!(status & SS$_NORMAL))*       LIB$STOP(status);*  (    time_buf[time_d.dsc$w_length] = '\0';8    sprintf(stamp_buf,"[JOBLOG started at %s]",time_buf);  @    return(stamp_buf);			/* return pointer to time stamp str.  */   }	/*** get_start_stamp ***/t TP /*******************************************************************************P ********************************************************************************     Function:	write_log*  4   Purpose:	Write the specified line to the log file.     Formal Parameters:   	Name			Description* 	----			-----------u 	line			buffer to be written( 	length			length of buffer to be written 	log_rab			RAB of log file 	flags			current flag structuret     Global variables:i  % 	Name			Examine/Modify/Use/Read/Writet% 	----			------------------------------ 	stamp_buf				X	  X      Return Codes:f   	Code	 		Reason/ 	----			------ 	none      Termination Codes:   	Code			Reason 	----			------" 	status			write to log file failed  P ********************************************************************************P *******************************************************************************/  C static void write_log(char *line,USHORT length,struct RAB *log_rab,t 		      FLAG_DEF *flags)   {	/*** write_log ***/*- 					/********   LOCAL  VARIABLES   ********/ ? register ULONG	  status;		/* return code status holder	      */t8 register USHORT	  i;			/* loop and array index		      */G static	 USHORT	  buf_cnt = 0;		/* number of characters in buffer     */*K static	 char	  rec_buf[MAX_REC+1],	/* for constructing record to write   */*2 		  ch,			/* for saving current character	      */- 		  lastch = -1;		/* last character		      */s        for (i = 0; i < length; i++)     {G       ch = line[i];                          /* get the current char */t  D       if((ch == LINE_FEED && lastch >= 0) || buf_cnt >= MAX_REC - 1)       {E8 	 /* either starting a new line or the buffer is full */  D 	 log_rab->rab$l_rbf= &rec_buf[0];	/* set up to write line		      */%          log_rab->rab$w_rsz= buf_cnt;a  '          status = SYS$PUT(log_rab,0,0);*   	 if(status != RMS$_NORMAL)* 	 {* 	    kill_log(); 	    LIB$STOP(status); 	 }*  0          if(flags->command && flags->time_stamp) 	 {*+ 	    /* write the time stamp to the file */f  ' 	    log_rab->rab$l_rbf= &stamp_buf[0];E2             log_rab->rab$w_rsz= strlen(stamp_buf);  *             status = SYS$PUT(log_rab,0,0);   	    if(status != RMS$_NORMAL) 	       LIB$STOP(status);o   	    flags->command = FALSE; 	 }	  0 	 buf_cnt = 0;			/* start the new line		      */3 	 rec_buf[0] = '\0';		/* make it a string		      */        }*  *       /* CR starting line? */*  F       if((lastch == LINE_FEED || lastch < 0) && ch == CARRIAGE_RETURN)0          continue;			/* yes, ignore it		      */  F       /* don't want these in file (is this the way it should be???) */  =       if(ch != LINE_FEED && ch != CARRIAGE_RETURN && ch != 0)-       {	 	 rec_buf[buf_cnt++] = ch; 	 rec_buf[buf_cnt] = '\0';       }-  <       lastch = ch;			/* remember the last character	      */    }  
    return;   }	/*** write_log ***/a  P /*******************************************************************************P ********************************************************************************     Function:	log_sessiont  A   Purpose:	This is actually the heart of the program.   Reads are > 		done on the FT device asynchronously and the data is written4 		to the TTY and the log file if logging is enabled.     Formal Parameters:   	Name			Descriptionf 	----			-----------  	ft_chan			channel to FT devicet  	tt_chan			channel to TTY device     Global variables:   % 	Name			Examine/Modify/Use/Read/Writeb% 	----			-----------------------------t 	mess_d				  X	X 	tt_read_iosb				X 	stamp_buf				Xs
 	ft_efn					X  	flags			   X	  Xu 	tt_r_efn				X 	wait_efn				X
 	bintim					Xw 	ft_buf			   X		X* 	tt_buf			   X		X* 	cr_buf				  X	X 	term_block				X     Return Codes:*   	Code	 		Reason* 	----			------ 	none*     Termination Codes:   	Code			Reason 	----			------' 	JLG_CANT_QUEUE		can't queue read to TT " 	JLG_CANT_WRITE		can't write to FT 	status   P ********************************************************************************P *******************************************************************************/  6 static void log_session(USHORT ft_chan,USHORT tt_chan)   {	/*** log_session ***/e- 					/********   LOCAL  VARIABLES   ********/	8 	 ULONG	  status;		/* return code status holder	      */ 	 USHORT   length;? static	 char	  log_enable[] = {"Logging has been ENABLED\r\n"},*6 		  log_disable[] = {"Logging has been DISABLED\r\n"},< 		  stamp_enable[] = {"Time stamping has been ENABLED\r\n"},> 		  stamp_disable[] = {"Time stamping has been DISABLED\r\n"};        cr_buf->status = 0;    cr_buf->count = 1;L    cr_buf->data[0] = 015;u  )    /* start reading from the FT device */t  M    status = PTD$READ(ft_efn,ft_chan,&ft_ast,0,&(ft_buf->status),FT_DATA_MAX);  		        if(!(status & SS$_NORMAL))B    {       kill_log();hD       mess_d.dsc$a_pointer = "read on FT device (in log_session())";B       mess_d.dsc$w_length = (USHORT) strlen(mess_d.dsc$a_pointer);,       LIB$SIGNAL(JLG_CANT_QUEUE,1L,&mess_d);       LIB$STOP(status);U    }  B    flags.hangups = TRUE;		/* enable hangups on the FT device    */  #    /* go for it -- start logging */n  
    for(;;)    {       /* read from the TTY */a  H       status = SYS$QIOW(tt_r_efn,tt_chan,IO$_READVBLK,&tt_read_iosb,0,0,% 			tt_buf->data,1,0,&term_block,0,0);;  G       if(!(status & SS$_NORMAL) || !(tt_read_iosb.status & SS$_NORMAL))c       {t
 	 kill_log();l- 	 mess_d.dsc$a_pointer = "read on TT device";t> 	 mess_d.dsc$w_length = (USHORT) strlen(mess_d.dsc$a_pointer);& 	 LIB$STOP(JLG_CANT_QUEUE,1L,&mess_d);       }e  <       /* Stall for 50 milli-seconds waiting for more data */  0       status = SYS$SETIMR(wait_efn,&bintim,0,0);          if(!(status & SS$_NORMAL))       {}
 	 kill_log();f 	 LIB$STOP(status);        }*  $       status = SYS$WAITFR(wait_efn);          if(!(status & SS$_NORMAL))       { 
 	 kill_log();  	 LIB$STOP(status);n       }          /* get the rest of it */  O       status = SYS$QIOW(tt_r_efn,tt_chan,IO$_READVBLK|IO$M_TIMED,&tt_read_iosb,(8 			0,0,&(tt_buf->data[1]),TT_DATA_MAX - 1,0,&term_block, 			0,0);          if(!(status & SS$_NORMAL)) 	 LIB$STOP(status);   @       if(tt_buf->data[0] == CARRIAGE_RETURN && flags.time_stamp)       { 8 	 flags.command = TRUE;		/* this was a command		      */A 	 get_stamp(stamp_buf);		/* create the time stamp for later    */t       }e
       else       {b# 	 /* check for toggle characters */A  # 	 if(tt_buf->data[0] == TOGGLE_LOG)I 	 {P) 	    /* toggle the logging to the file */    	    if(flags.logging)F 	       write_tt(tt_chan,log_disable,(ULONG) sizeof(log_disable) - 1);	 	    elseiD 	       write_tt(tt_chan,log_enable,(ULONG) sizeof(log_enable) - 1);1                                                  A 	    write_ft(ft_chan,cr_buf);$ 	    flags.logging = !flags.logging; 	    flags.verify = FALSE; 	 })* 	 else if(tt_buf->data[0] == TOGGLE_STAMP) 	 {  	    /* toggle time-stamping */a   	    if(flags.time_stamp)L' 	       write_tt(tt_chan,stamp_disable, & 			(ULONG) sizeof(stamp_disable) - 1);	 	    else G 	      write_tt(tt_chan,stamp_enable,(ULONG) sizeof(stamp_enable) - 1);    	    write_ft(ft_chan,cr_buf);* 	    flags.time_stamp = !flags.time_stamp; 	 }l       }   %       /* write it to the FT device */e  -       tt_buf->count = tt_read_iosb.count + 1;h  (       status = write_ft(ft_chan,tt_buf);          if(!(status & SS$_NORMAL))       {u          kill_log();4          LIB$STOP(JLG_CANT_WRITE,1L,"to FT device");       }     }  /    return;				/* should never get here	      */    }	/*** log_session ***/g dP /*******************************************************************************P ********************************************************************************     Function:	ask_disposition*  D   Purpose:	Ask the user what should be done with the log file and do 		it.*     Formal Parameters:   	Name			Description* 	----			-----------* 	filename		name of log file + 	stage_dir		staging directory for log filesF 	flags			computed flagsr 	args			run-time arguments     Global variables:-  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------o 	disp_failed			  X 	tt_chan					X 	LIB$M_CLI_CTRLY				Xt     Return Codes:    	Code 	 		Reason 	----			------ 	nonen     Termination Codes:   	Code			Reason 	----			------ 	status   P ********************************************************************************P *******************************************************************************/  J static void ask_disposition(char *logfile,char *stage_dir,FLAG_DEF *flags, 			    ARG_DEF *args)    {	/*** ask_disposition ***/ - 					/********   LOCAL  VARIABLES   ********/L8 	 ULONG	  status,		/* return code status holder	      */; 		  disable_mask;		/* for disabling control-Y at DCL     */r4 	 char	  *save_ptr;		/* saved logfile name		      */4 	 USHORT	  done,			/* loop control variable	      */4 		  length;		/* length of read from my_gets	      */0 	 char	  ch[10];		/* character read in		      */J static $DESCRIPTOR(in_d,"SYS$INPUT");	/* input channel descriptor	      */    K    disable_mask = LIB$M_CLI_CTRLY;	/* tell DCL to ignore control-Y	      */C  ,    status = LIB$DISABLE_CTRL(&disable_mask);      if(!(status & SS$_NORMAL))T    {       delete_log(logfile);       LIB$SIGNAL(status);/    }      if(flags->verify)0       my_puts("\n\nYour log file is VERIFIED.");    else_2       my_puts("\n\nYour log file is UNVERIFIED.");      done = FALSE;3    status = SUCCESS;			/* just to be sure		      */       doe    {       if(args->print)D2 	 ch[0] = 'P';			/* user specified /PRINT	      */       else if(args->mail)  	 ch[0] = 'M';       else if(args->save), 	 ch[0] = 'S';
       else       {F! 	 my_puts("\n\nDo you want to:");)= 	 my_puts("  Print your log file?                  Enter p"); = 	 my_puts("  Save log to your area?                Enter s");s= 	 my_puts("  Mail notification of log to someone?  Enter m");r? 	 my_puts("  Delete your log file?                 Enter d\n"); G 	 status = my_gets(tt_chan,&ch[0],"     Your choice [default is d] ? ",s 			  &length,sizeof(ch) - 1);p 	 squeeze_str(ch);   	 if(status == CANCEL)) 	    ch[0] = 'D';		/* ^C or ^Y			      */,4 	 else if(ch[0] == CARRIAGE_RETURN || ch[0] == '\0')2 	    ch[0] = 'D'; 		/* default is delete		      */D 	 else if((status == SUCCESS && ch[1] != '\0') || status == FAILURE)9 	    ch[0] = '\0';		/* more than one char; error	      */  	 else 	    ch[0] = _toupper(ch[0]);F       })         switch(ch[0])S       {) 	 case('P'):    	    /* user wants it printed */  7 	    status = print_log(logfile,tt_chan,flags->verify);u   	    if(status == FAILURE) 	    {5 	       my_puts("\n\7*ERROR* Cannot print log file");e5 	       args->print = FALSE;	/* start over			      */$D 	       disp_failed = TRUE;	/* ensure user is prompted next time  */ 	    } 	    else if(status == CANCEL) 	    {D 	       /* user entered ^C or ^Y; delete the log file and get out */   	       delete_log(logfile);) 	       my_puts("\nLog file deleted.\n");s 	       done = TRUE; 	    }             else 	    {> 	       done = TRUE;		/* no need to delete log file here    */ 	    }   	    break;    	 case('S'):  ( 	    status = save_log(logfile,tt_chan);   	    if(status == FAILURE) 	    {4 	       my_puts("\n\7*ERROR* Cannot save log file");4 	       args->save = FALSE;	/* start over			      */D 	       disp_failed = TRUE;	/* ensure user is prompted next time  */ 	    } 	    else if(status == CANCEL) 	    {D 	       /* user entered ^C or ^Y; delete the log file and get out */   	       delete_log(logfile);) 	       my_puts("\nLog file deleted.\n");* 	       done = TRUE; 	    }	 	    else  	    { 	       done = TRUE; 	       delete_log(logfile); 	    }   	    break;o   	 case('D'):  = 	    /* we really don't care too much if delete() fails sinceyC 	     * the batch job will kill it anyway; besides, it should never	 	     * fail 	     */   	    delete_log(logfile);)& 	    my_puts("\nLog file deleted.\n"); 	    done = TRUE;n   	    break;d   	 case('M'):  @ 	    status = mail_log(logfile,stage_dir,tt_chan,flags->verify);  0 	    if(status == FAILURE || status == NO_INPUT) 	    { 	       args->mail = FALSE;*D 	       disp_failed = TRUE;	/* ensure user is prompted next time  */ 	    } 	    else if(status == CANCEL) 	    {D 	       /* user entered ^C or ^Y; delete the log file and get out */   	       delete_log(logfile);) 	       my_puts("\nLog file deleted.\n");  	       done = TRUE; 	    } 	    else if(status == SUCCESS)  	    { 	       done = TRUE; 	       delete_log(logfile); 	    }   	    break;   
 	 default:  * 	    /* bad option specified; try again */  0 	    my_puts("\n\7Invalid option.  Try again."); 	    break;/       }i    }    while(!done);  +    status = LIB$ENABLE_CTRL(&disable_mask);l      if(!(status & SS$_NORMAL))a       LIB$STOP(status);>  
    return;   }	/*** ask_disposition ***/E 0P /*******************************************************************************P ********************************************************************************     Function:	get_file  3   Purpose:	Create a filename and open the log file.n     Formal Parameters:   	Name			Descriptiont 	----			-----------r 	filename		name of log filem) 	log_dir			directory where log files liver 	log_fab			FAB for log file_ 	log_rab			RAB for log filet  	log_xabpro		XABPRO for log file 	args			command-line arguments 	flags			program flags     Global variables:   % 	Name			Examine/Modify/Use/Read/Writee% 	----			-----------------------------t 	privs				  X	Xe 	old_privs			  X	X     Return Codes:G   	Code	 		Reasons 	----			------ 	none      Termination Codes:   	Code			Reason 	----			------' 	status			return code from system callsm  P ********************************************************************************P *******************************************************************************/  G static ULONG get_file(char *filename,char *log_dir,struct FAB *log_fab, 6 		      struct RAB *log_rab,struct XABPRO *log_xabpro,& 		      ARG_DEF *args,FLAG_DEF *flags)   {	/*** get_file ***/- 					/********   LOCAL  VARIABLES   ********/,8 	 ULONG	  status;		/* return code status holder	      */     #ifdef PHOTO_MODEt  !    strcpy(filename,"JOBLOG.LOG");f   #else_  5    /* turn on SYSPRV so we can create the log file */c      privs[0] = PRV$M_SYSPRV;t  3    status = SYS$SETPRV(ON,&privs,FALSE,&old_privs);       if(!(status & SS$_NORMAL))*       return(status);c  G    strcpy(filename,"JOBXXXXXX");	/* make our own log file name	      */l      if(mktemp(filename) == NULL)l    {9       my_puts("JOBLOG -- cannot create log file name\n");(       SYS$EXIT();     }      strcat(filename,".LOG");lH    strcpy(flags->filename,filename);	/* save filename for later	      */E    strins(filename,log_dir,0);		/* add secure directory name	      */g   #endif      *log_fab = cc$rms_fab;     *log_rab = cc$rms_rab;b    *log_xabpro = cc$rms_xabpro;   J    /* if we were doing exact logging, we would have a test here for it andK     * we would open the log file appropriately; since exact logging is suchsK     * a pain in the a*s, we'll just assume everything is "unexact" (is that      * even a word?)a     */  ?    log_fab->fab$l_fna = filename;	/* name of log file		      */ 1    log_fab->fab$b_fns = (UCHAR) strlen(filename);fK    log_fab->fab$l_fop = FAB$M_SUP;	/* supersede old version of log file  */;K    log_fab->fab$l_fop = FAB$M_MXV;	/* supersede old version of log file  */ A    log_fab->fab$b_org = FAB$C_SEQ;	/* sequential access		      */rG    log_fab->fab$b_rat = FAB$M_CR;	/* CR attributes for records	      */ F    log_fab->fab$b_rfm = FAB$C_VAR;	/* variable-length records	      */C    log_fab->fab$b_shr = FAB$M_NIL;	/* don't allow sharing		      */*Q    log_fab->fab$l_xab = (void *) log_xabpro;  /* for setting prot on close     */   >    log_rab->rab$l_fab = log_fab;	/* FAB for log file		      */A    log_rab->rab$b_rac = RAB$C_SEQ;	/* sequential access		      */	"    log_rab->rab$l_rop = RAB$M_WBH;  I    /* set the protection to override any default the user might've set */m  I    log_xabpro->xab$w_pro = ((XAB$M_NOREAD | XAB$M_NOWRITE | XAB$M_NOEXE |	4 			    XAB$M_NODEL) << XAB$V_GRP) | ((XAB$M_NOREAD |1 			    XAB$M_NOWRITE | XAB$M_NOEXE | XAB$M_NODEL)C 			    << XAB$V_WLD);s       status = SYS$CREATE(log_fab);      if(!(status & RMS$_NORMAL))       return(status);   !    status = SYS$CONNECT(log_rab);*      if(!(status & RMS$_NORMAL))    {       kill_log();*       return(status);*    }   #ifndef PHOTO_MODE  D    /* now that the file is open, turn SYSPRV off again to be safe */      privs[0] = PRV$M_SYSPRV;A  .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))        return(status);t   #endif      return(RMS$_NORMAL);    }	/*** get_file ***/ /P /*******************************************************************************P ********************************************************************************     Function:	welcomey  0   Purpose:	Write the welcome message to the tty.     Formal Parameters:   	Name			DescriptionT 	----			-----------d 	args			run-time arguments     Global variables:_  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------& 	none_     Return Codes:t   	Code	 		ReasonT 	----			------ 	noneg     Termination Codes:   	Code			Reason 	----			------' 	status			return code from system callsi  P ********************************************************************************P *******************************************************************************/  " static void welcome(ARG_DEF *args)   {	/*** welcome ***/i- 					/********   LOCAL  VARIABLES   ********/ , 	 USHORT	  i = 0;		/* array index			      */D static	 char	  *text[] = {		/* stuff to say upon entry to JOBLOG  */ {" "},K {"Welcome to JOBLOG!  Please try not to use full-screen editors or other"},oF {"screen-oriented programs as they tend not to be logged correctly."}, {" "},J {"Also, please don't use SET HOST as it causes problems with JOBLOG log"}, {"files."},) {" "}," {"To exit JOBLOG, enter LOGOUT."}, {" "},
 {""}};             #ifndef PHOTO_MODE      if(!args->expert)       while(*text[i] != '\0')C 	 my_puts(text[i++]);'   #endif  I    my_puts("\nJOBLOG started.\n");		/* mandatory startup message	      */c
    return;   }	/*** welcome ***/	  P /*******************************************************************************P ********************************************************************************     Function:	copy_file   !   Purpose:	Make a copy of a file.'     Formal Parameters:   	Name			Description  	----			-----------o 	source			file to be copiedu 	dest			where copy is to go)+ 	priv_flag		TRUE if copying to staging area      Global variables:   % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------* 	privs				  X	Xr     Return Codes:/   	Code	 		Reason  	----			------ 	SUCCESS 	FAILURE  P ********************************************************************************P *******************************************************************************/  @ static ULONG copy_file(char *source,char *dest,USHORT priv_flag)   {	/*** copy_file ***/ - 					/********   LOCAL  VARIABLES   ********/s8 	 ULONG	  status,		/* return code status holder	      */5 		  status2,		/* some secondary return codes	      */e 		  status3, 		  status4;G 	 char  	  in_buf[IN_BUF_MAX+1];	/* buffer for reading/writing	      */s? struct	 FAB	  in_fab,		/* FAB's for input and output files   */= 		  out_fab;? struct	 RAB	  in_rab,		/* RAB's for input and output files   */  		  out_rab;    C    in_fab = cc$rms_fab;  		/* initialize all of the RMS blocks   */     in_rab = cc$rms_rab;     out_rab = cc$rms_rab;  F    in_fab.fab$b_fac = FAB$M_BIO |	/* block I/O for input file	      */ 		      FAB$M_GET;
              '    in_fab.fab$l_fna = source;l-    in_fab.fab$b_fns = (UCHAR) strlen(source);y,    in_fab.fab$b_fac = FAB$M_BIO | FAB$M_GET;  A    in_rab.rab$l_fab = &in_fab;		/* pointer to input FAB		      */tG    in_rab.rab$b_rac = RAB$C_SEQ;	/* sequential access for copy	      */uD    in_rab.rab$w_usz = IN_BUF_MAX;	/* length of input buffer	      */=    in_rab.rab$l_ubf = in_buf;		/* pointer to buffer		      */l  B    out_rab.rab$l_fab = &out_fab;	/* pointer to input FAB		      */H    out_rab.rab$b_rac = RAB$C_SEQ;	/* sequential access for copy	      */G    out_rab.rab$w_usz = IN_BUF_MAX; 	/* length of output buffer	      */l?    out_rab.rab$l_rbf = in_buf; 		/* pointer to buffer		      */       privs[0] = PRV$M_SYSPRV;     privs[1] = 0L;S  -    status = SYS$SETPRV(ON,&privs,FALSE,NULL);l      if(!(status & SS$_NORMAL))k       return(FAILURE);      /* open the input file */      status = SYS$OPEN(&in_fab);      if(!(status & RMS$_NORMAL))    {       SYS$CLOSE(&in_fab);o       return(FAILURE);    }  ,    /* connect the input file's RMS blocks */  !    status = SYS$CONNECT(&in_rab);       if(!(status & RMS$_NORMAL))    {       SYS$CLOSE(&in_fab);*       return(FAILURE);    }  >    out_fab = in_fab;  			/* copy the input file's FAB	      */5    out_fab.fab$w_ifi = 0; 		/* reset this!			      */c-    out_fab.fab$b_fac = FAB$M_BIO | FAB$M_PUT;       out_fab.fab$l_fna = dest;,    out_fab.fab$b_fns = (UCHAR) strlen(dest);    ?    if(priv_flag == FALSE)		/* copying to staging area?	      */*    {E       /* copying to user's area; turn off SYSPRV *BEFORE* opening the*        * destination file*	        */*  1       status = SYS$SETPRV(OFF,&privs,FALSE,NULL);:          if(!(status & SS$_NORMAL)) 	 return(FAILURE);    }      /* open the output file */-  !    status = SYS$CREATE(&out_fab);t      if(!(status & RMS$_NORMAL))    {       SYS$CLOSE(&out_fab);       SYS$CLOSE(&in_fab);        return(FAILURE);    }  -    /* connect the output file's RMS blocks */-  "    status = SYS$CONNECT(&out_rab);      if(!(status & RMS$_NORMAL))    {       SYS$CLOSE(&out_fab);       SYS$CLOSE(&in_fab);m       return(FAILURE);    }  6    if(priv_flag == TRUE)		/* privs still on?		      */    {I       /* SYSPRV was left on so that the destination file (which is in the*4        * staging area) could be created; turn it off	        */   1       status = SYS$SETPRV(OFF,&privs,FALSE,NULL);I          if(!(status & SS$_NORMAL)) 	 return(FAILURE);    }  3    /* now copy the input file to the output file */1      status = SYS$READ(&in_rab);C    status2 = RMS$_NORMAL;		/* have to lie to fool the loop	      */v  =    while((status == RMS$_NORMAL) && (status2 == RMS$_NORMAL))i    {+       out_rab.rab$w_rsz = in_rab.rab$w_rsz;T$       status2 = SYS$WRITE(&out_rab);!       status = SYS$READ(&in_rab);u    }       /* close both of the files */       status3 = SYS$CLOSE(&in_fab);!    status4 = SYS$CLOSE(&out_fab);*  I    /* did the loop terminate properly? if not, delete the output file and*     * scream at the user     */  O    if(status != RMS$_EOF || status2 != RMS$_NORMAL || status3 != RMS$_NORMAL ||u       status4 != RMS$_NORMAL)        return(FAILURE);      return(SUCCESS);m   }	/*** copy_file ***/t IP /*******************************************************************************P ********************************************************************************     Function:	print_logu  C   Purpose:	Print the log file (verified or nonverified) to the linew< 		printer.  The /DELETE qualifier is passed to the print job1 		so that the log file is deleted after printing.I     Formal Parameters:   	Name			Description* 	----			-----------* 	logfile			name of log file  	channel			TTY channel& 	verify_flag		TRUE = verified LPT copy     Global variables:t  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------/ 	disp_failed		   X 	privs				  X	X*     Return Codes:s   	Code	 		Reasont 	----			------ 	SUCCESS 	FAILURE 	CANCEL[  P ********************************************************************************P *******************************************************************************/  F static ULONG print_log(char *logfile,USHORT channel,UCHAR verify_flag)   {	/*** print_log ***/t0    					/********   LOCAL  VARIABLES   ********/8 	 ULONG	  status,		/* return code status holder	      */4 		  status2;		/* another return code holder	      */6 	 long	  entry_num;		/* entry number in queue	      */7 	 USHORT	  length;		/* length of status string	      */*0 	 IOSB_DEF iosb;			/* I/O status block		      */& static	 char	  def_queue[QUEUE_MAX+1],9 		  queue[QUEUE_MAX+1],	/* queue to use for call	      */o 		  prompt[BUFSIZ],N! 		  status_str[STATUS_STR_MAX+1],- 		  *account = "VERIFY", 		  *account2 = "UNVERIFY", " 		  *job_name = "VERIFIED_JOBLOG",% 		  *job_name2 = "UNVERIFIED_JOBLOG",u* 		  *verified = "Verified JOBLOG listing",. 		  *unverified = "Unverified JOBLOG listing";$ static $DESCRIPTOR(print_d,"PRINT");* static $DESCRIPTOR(table_d,"LNM$PROCESS");* static $DESCRIPTOR(table2_d,"LNM$SYSTEM");" static $DESCRIPTOR(queue_d,queue);, static $DESCRIPTOR(sys_print_d,"SYS$PRINT");F static	 ITM_LST  items[] = {		/* item list for stuff we want to do  */ {0,SJC$_ACCOUNT_NAME,0L,0L}," {0,SJC$_FILE_SPECIFICATION,0L,0L}, {0,SJC$_DELETE_FILE,0L,0L},c# {0,SJC$_ENTRY_NUMBER_OUTPUT,0L,0L},g {0,SJC$_JOB_NAME,0L,0L},! {0,SJC$_JOB_STATUS_OUTPUT,0L,0L},w {0,SJC$_NOTE,0L,0L}, {0,SJC$_NOTIFY,0L,0L}, {0,SJC$_QUEUE,0L,0L},t
 {0,0,0L,0L}},u: 		  items2[] = {		/* items obtained during translation  */B {0,LNM$_STRING,NULL,NULL},		/* things are filled in below	      */ {0,0,NULL,NULL}};h      s5    status = CLI$GET_VALUE(&print_d,&queue_d,&length);/  +    if(status == SS$_NORMAL && !disp_failed)h1       queue[length] = '\0';		/* use it			      */a    else;    {>       /* get the current default print queue from SYS$PRINT */  %       items2[0].buf_addr = def_queue; "       items2[0].ret_len = &length;,       items2[0].buf_len = sizeof(def_queue);       length = 0;E  0       /* check the user's process table first */  >       status = SYS$TRNLNM(0L,&table_d,&sys_print_d,0,&items2);  -       if(status != SS$_NORMAL || length == 0)a       {b; 	 status = SYS$TRNLNM(0L,&table2_d,&sys_print_d,0,&items2);s  ) 	 if(status != SS$_NORMAL || length == 0); 	 { 5 	    my_puts("\n\7*ERROR* SYS$PRINT not defined.\n");& 	    return(FAILURE);  	 }        }t         my_puts(" ");   >       def_queue[length] = '\0';		/* make it a string		      */L       cat(prompt,"Which printer did you want to use [default is ",def_queue,
 	  "]? ");  G       status = my_gets(channel,queue,prompt,&length,sizeof(queue) - 1);m         if(status == FAILURE)  	 return(FAILURE);       else if(status == CANCEL)= 	 return(CANCEL);a  &       /* input is ok if we get here */         queue[length] = '\0';        str_pref_trim(queue);s       str_post_trim(queue);T         if(queue[0] == '\0')7 	 strcpy(queue,def_queue);	/* use the default		      */f    }  -    /* set up the item list so we can print */   &    items[1].buf_len = strlen(logfile);    items[1].buf_addr = logfile;_#    items[3].buf_len = sizeof(long);0+    items[3].buf_addr = (char *) &entry_num;b%    items[5].buf_len = STATUS_STR_MAX; "    items[5].buf_addr = status_str;    items[5].ret_len = &length;$    items[8].buf_len = strlen(queue);    items[8].buf_addr = queue;*      if(verify_flag)    {)       items[0].buf_len = strlen(account); "       items[0].buf_addr = account;*       items[4].buf_len = strlen(job_name);#       items[4].buf_addr = job_name; *       items[6].buf_len = strlen(verified);#       items[6].buf_addr = verified;i    }    else     {*       items[0].buf_len = strlen(account2);#       items[0].buf_addr = account2; +       items[4].buf_len = strlen(job_name2); $       items[4].buf_addr = job_name2;,       items[6].buf_len = strlen(unverified);%       items[6].buf_addr = unverified;     }      privs[0] = PRV$M_CMKRNL;     privs[0] |= PRV$M_SYSPRV;  .    status2 = SYS$SETPRV(ON,&privs,FALSE,NULL);      if(!(status2 & SS$_NORMAL))    {       LIB$SIGNAL(status2);
       return;     }5    /* now try to queue the log file to the printer */   A    status = SYS$SNDJBCW(0,SJC$_ENTER_FILE,0L,&items,&iosb,0L,0L);U  G    /* turn off CMKRNL and SYSPRV *NOW* before checking if SYS$SNDJBCW()      * worked     */  /    status2 = SYS$SETPRV(OFF,&privs,FALSE,NULL);*      if(!(status2 & SS$_NORMAL))    {       LIB$SIGNAL(status2);
       return;*    }  (    /* now see if SYS$SNDJBCW() worked */      if(!(status & SS$_NORMAL))n       return(FAILURE);       if(iosb.status != SS$_NORMAL)    {       LIB$SIGNAL(iosb.status);       return(FAILURE);    }  +    /* report the status line to the user */a  G    status_str[length] = '\0';		/* make status message a string	      */"    my_puts(" ");    my_puts(status_str);s      return(SUCCESS);	   }	/*** print_log ***/e aP /*******************************************************************************P ********************************************************************************     Function:	mail_log  G   Purpose:	Mail notification of a verified JOBLOG to the specified user&/ 		and copy the log file to JOBLOG staging area.e     Formal Parameters:   	Name			Description_ 	----			-----------e 	logfile			name of log files+ 	stage_dir		staging directory for log filesL 	channel			TTY channel' 	verify			TRUE if JOBLOG still verifieds     Global variables:d  % 	Name			Examine/Modify/Use/Read/Writer% 	----			------------------------------ 	disp_failed			   Xn 	privs				   X    Xg 	JLG_NO_SPAWN				X     Return Codes:    	Code	 		Reasonl 	----			------ 	SUCCESS 	FAILURE	 	NO_INPUTb  P ********************************************************************************P *******************************************************************************/  P static ULONG mail_log(char *logfile,char *stage_dir,USHORT channel,UCHAR verify)   {	/*** mail_log ***/- 					/********   LOCAL  VARIABLES   ********/	= 	 char	  *username,		/* name of user mailing the notice    */l: 		  *verify_ptr,		/* used for making mail message	      */5 		  *verify_ch;		/* used for making filename	      */*8 	 ULONG	  status,		/* return code status holder	      */6 		  status2;		/* secondary return code holder	      */8 	 long	  item_code;		/* for LIB$GETJPI()'s sake	      */< 	 USHORT	  length;		/* length of string from LIB$GETJPI() */4 	 time_t	  time_val;		/* value from time()		      */* 	 IOSB_DEF iosb;			/* for QIO's			      */A struct	 tm	  *time_ptr;		/* pointer to localtime() structure   */e@ struct	 FAB	  out_fab;		/* for creating mail message file     */ struct	 RAB	  out_rab;( static	 char	  tempfile[NAM$C_MAXRSS+1], 		  filename[NAM$C_MAXRSS+1],_: 		  out_buf[BUFSIZ],	/* formatting and I/O buffer	      */ 		  account[ACCOUNT_MAX+1]," 		  recipient[USERNAME_MAX+1], 		  command[COMMAND_MAX+1],( 		  prompt[] =? 		  {"Who do you want to mail the log file notification to? "}; ! static $DESCRIPTOR(null_d,"NL:");}& static $DESCRIPTOR(account_d,account);& static $DESCRIPTOR(command_d,command);( static $DESCRIPTOR(filename_d,filename);* static $DESCRIPTOR(recipient_d,recipient);" static $DESCRIPTOR(mail_d,"MAIL"); static $DESCRIPTOR(ctrstr_d,I 	 "!AD!AD_!AD_!AD.!AD_JOBLOG_!ZL!ZL_!ZL!ZL_!ZL!ZL_!ZL!ZL_!ZL!ZL_!ZL!ZL");e    8    status = CLI$GET_VALUE(&mail_d,&recipient_d,&length);  +    if(status == SS$_NORMAL && !disp_failed)c    {$       /* save the /MAIL recipient */  >       recipient[length] = '\0';		/* make it a string		      */    }    else/    {:       /* /USER wasn't specified; prompt the user for it */         my_puts(" ");nO       status = my_gets(channel,recipient,prompt,&length,sizeof(recipient) - 1);l         if(status == FAILURE)l 	 return(FAILURE);       else if(status == CANCEL)o 	 return(CANCEL);   &       /* input is ok if we get here */         str_pref_trim(recipient);b       str_post_trim(recipient);r         if(recipient[0] == '\0')       {a/ 	 my_puts("\n\07You must specify a username.");  	 return(NO_INPUT);a       }   =       strlu(recipient);			/* conver to all uppercase	      */a    }  )    /* see if we have a valid recipient */o  &    if(valid_recip(recipient) == FALSE)    {M       cat(out_buf,"\n\07You cannot send JOBLOG log files to ",recipient,".");a       my_puts(out_buf);r       return(FAILURE);    }    else     {        username = getenv("USER");  )       if(strcmp(recipient,username) == 0)b       {(@ 	 my_puts("\n\07You cannot send JOBLOG log files to yourself!"); 	 return(FAILURE);       }E    }  6    /* good recipient; get the account of the sender */      item_code = JPI$_ACCOUNT;;    status = LIB$GETJPI(&item_code,0L,NULL,0L,&account_d,0);       if(!(status & SS$_NORMAL))Y       return(FAILURE);  5    /* strip off the trailing blanks in the account */       length = 0;  8    while(length < ACCOUNT_MAX && account[length] != ' ')       ++length;P  9    account[length] = '\0';		/* make it a string		      */ B    squeeze_str(account);		/* squeeze out any internal blanks    */  .    /* make a mail message for the recipient */       strcpy(tempfile,"JOBXXXXXX");    mktemp(tempfile);    strcat(tempfile,".TMP");*      out_rab = cc$rms_rab;B    out_rab.rab$l_fab = &out_fab;	/* pointer to input FAB		      */H    out_rab.rab$b_rac = RAB$C_SEQ;	/* sequential access for copy	      */K    out_rab.rab$w_usz = sizeof(out_buf);	/* length of output buffer	      */t?    out_rab.rab$l_rbf = out_buf;		/* pointer to buffer		      */l      out_fab = cc$rms_fab;5    out_fab.fab$w_ifi = 0; 		/* reset this!			      */-!    out_fab.fab$b_fac = FAB$M_PUT;s       out_fab.fab$l_fna = tempfile;0    out_fab.fab$b_fns = (UCHAR) strlen(tempfile);      /* open the output file */u  !    status = SYS$CREATE(&out_fab);*      if(status != RMS$_NORMAL)    {       SYS$CLOSE(&out_fab);       return(FAILURE);    }  -    /* connect the output file's RMS blocks */*  "    status = SYS$CONNECT(&out_rab);      if(status != RMS$_NORMAL)    {       SYS$CLOSE(&out_fab);       return(FAILURE);    }  
    if(verify)e       verify_ptr = "";    elset"       verify_ptr = "n UNVERIFIED";  '    cat(out_buf,"There is a",verify_ptr, F        " JOBLOG log file from ",username," waiting to be retrieved.");0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);    status = SYS$PUT(&out_rab);  9    strcpy(out_buf,"To retrieve it, enter the command\n");i0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);    status = SYS$PUT(&out_rab);  2    cat(out_buf,"	JOBLOG/RETRIEVE/USER=",username);0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);    status = SYS$PUT(&out_rab);       status = SYS$CLOSE(&out_fab);      my_puts(" ");8    cat(out_buf,"....sending mail to ",recipient,"....");    my_puts(out_buf);  )    /* create the command to be SPAWNed */*  
    if(verify)*H       cat(command,"$MAIL/SUBJECT=\"JOBLOG pending from ",username,"\" ", 	  tempfile," ",recipient);o    elsei       cat(command,D 	  "$MAIL/SUBJECT=\"UNVERIFIED JOBLOG pending from ",username,"\" ", 	  tempfile," ",recipient);   5    command_d.dsc$w_length = (USHORT) strlen(command);e  "    /* SYSPRV is needed to spawn */      privs[0] = PRV$M_SYSPRV;   -    status = SYS$SETPRV(ON,&privs,FALSE,NULL);	      if(!(status & SS$_NORMAL))d    {       LIB$SIGNAL(status);C
       return;     }  8    /* now try to spawn the command to mail the notice */  M    status = LIB$SPAWN(&command_d,&null_d,&null_d,NULL,NULL,0L,&status2,0L,0L,* 		      0L,0L,NULL,NULL);U  (    /* kill SYSPRV now just to be safe */  /    status2 = SYS$SETPRV(OFF,&privs,FALSE,NULL);*      if(!(status2 & SS$_NORMAL))       LIB$SIGNAL(status2);  >    delete_log(tempfile);		/* kill it before we forget	      */  )    /* now check to see if spawn worked */s      if(!(status & SS$_NORMAL))1    {       LIB$SIGNAL(JLG_NO_SPAWN);*       return(FAILURE);    }  F    /* create the filename that will be used when the log file is moved     * to the staging areau     */      time_val = time(NULL); #    time_ptr = localtime(&time_val);eC    time_ptr->tm_mon += 1;		/* because it is 0-11, not 1-12	:-(   */c  G    /* create the filename that will be used when the log file is copied	     * to the staging area;     */  
    if(verify)a       verify_ch = "V";    else.       verify_ch = "U";      sprintf(filename,W            "%s%s_%s_%s.%s_JOBLOG_%01d%01d_%01d%01d_%01d%01d_%01d%01d_%01d%1d_%01d%01d", G 	   stage_dir,username,recipient,account,verify_ch,time_ptr->tm_mon/10, B 	   time_ptr->tm_mon%10,time_ptr->tm_mday/10,time_ptr->tm_mday%10,C 	   time_ptr->tm_year/10,time_ptr->tm_year%10,time_ptr->tm_hour/10,	A 	   time_ptr->tm_hour%10,time_ptr->tm_min/10,time_ptr->tm_min%10,F- 	   time_ptr->tm_sec/10,time_ptr->tm_sec%10);	 	   3    /* copy the log file to the staging directory */z  -    status = copy_file(logfile,filename,TRUE);*      if(status == SUCCESS)    {       if(verify)B 	 cat(out_buf,"\n\nNotification of VERIFIED JOBLOG sent to user ", 	     recipient,"\n\n");
       elseD 	 cat(out_buf,"\n\nNotification of UNVERIFIED JOBLOG sent to user ", 	     recipient,"\n\n");         my_puts(out_buf);P    }      return(status);   }	/*** mail_log ***/  P /*******************************************************************************P ********************************************************************************     Function:	valid_recip$  H   Purpose:	Determine if the user specified is allowed to received mailed 		JOBLOG log files.'     Formal Parameters:   	Name			Descriptionr 	----			-----------c/ 	recipient		who is supposed to get the log file      Global variables:=  % 	Name			Examine/Modify/Use/Read/Writer% 	----			-----------------------------E 	privs				  X	Xs     Return Codes:*   	Code	 		Reasonc 	----			------ 	SUCCESS			valid recipient 	FAILURE			invalid recipient  P ********************************************************************************P *******************************************************************************/  * static USHORT valid_recip(char *recipient)   {	/*** valid_recip ***/_- 					/********   LOCAL  VARIABLES   ********/ 8 	 ULONG	  id,			/* current id held by recipient	      */6 		  context,		/* for getting individual identifiers */2 		  status;		/* return code status holder	      */1 	 USHORT	  i,			/* loop and array index		      */Y" 		  j,			/* ditto......			      */- 		  done,			/* loop control boolean		      */i) 		  retval;		/* our return code		      */R> static	 ULONG	  uic[2];		/* so we can get identifiers	      */6 static	 USHORT	  length;		/* from SYS$GETUAI		      */  static	 ID_DEF   valid_ids[] = { {"FACULTY",0L},E
 {"STAFF",0L},  {"JOBLOG_RECIPIENT",0L},	 {0L,0L}};n static	 ITM_LST  items[] = {0 {sizeof(uic),UAI$_UIC,(void *) &uic[0],&length}, {0,0,NULL,NULL}};n static $DESCRIPTOR(recip_d,"");	 static $DESCRIPTOR(id_d,"");    K    /* translate all of the ASCII identifiers to integer to make them easier      * to compare later     */  	    i = 0;z  (    while(valid_ids[i].id_string != NULL)    {2       id_d.dsc$a_pointer = valid_ids[i].id_string;>       id_d.dsc$w_length = (USHORT) strlen(id_d.dsc$a_pointer);  :       status = SYS$ASCTOID(&id_d,&(valid_ids[i].id),NULL);
       i++;    }      privs[0] = PRV$M_SYSPRV;c  -    status = SYS$SETPRV(ON,&privs,FALSE,NULL);E      if(!(status & SS$_NORMAL))t    {       LIB$SIGNAL(status);t       return(FAILURE);    }  )    /* get the recipient's UIC from UAF */	  %    recip_d.dsc$a_pointer = recipient;*5    recip_d.dsc$w_length = (USHORT) strlen(recipient);*  7    status = SYS$GETUAI(0L,0L,&recip_d,&items,0L,0L,0L);*      if(!(status & SS$_NORMAL))        return(FAILURE);  J    /* now get each identifer the recipient holds and see if it is valid */      context = 0L;2    status = SYS$FIND_HELD(&uic,&id,NULL,&context);      done = FALSE;    retval = FAILURE;  '    while(status == SS$_NORMAL && !done)-    {<       /* got an identifier; now check if it is a good one */         for(j = 0; j < i; j++)       {o 	 if(id == valid_ids[j].id)  	 {	' 	    status = SYS$FINISH_RDB(&context);	 	    done = TRUE;- 	    retval = SUCCESS; 	 }X       }	  5       status = SYS$FIND_HELD(&uic,&id,NULL,&context);	    }      if(status != SS$_NOSUCHID) (       status = SYS$FINISH_RDB(&context);      /* turn off SYSPRV */  .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))*    {       LIB$SIGNAL(status);g       return(FAILURE);    }      return(retval);   }	/*** valid_recip ***/	 	P /*******************************************************************************P ********************************************************************************     Function:	save_log  E   Purpose:	Save a log file for a user.  Use the filename specified by 7 		the user if one exists, otherwise use a default name.t     Formal Parameters:   	Name			Description[ 	----			-----------e 	log_file		name of log file	   	channel			TTY channel     Global variables:+  % 	Name			Examine/Modify/Use/Read/Writeu% 	----			-----------------------------R 	disp_failed		   X     Return Codes:I   	Code	 		Reason  	----			------ 	SUCCESS 	FAILURE 	CANCELu% 	status			return code from save_log();  P ********************************************************************************P *******************************************************************************/  3 static ULONG save_log(char *logfile,USHORT channel)_   {	/*** save_log ***/- 					/********   LOCAL  VARIABLES   ********/O8 	 ULONG	  status;		/* return code status holder	      */< 	 USHORT	  length;		/* length of command line value	      */7 	 IOSB_DEF iosb;			/* for reading from the TTY	      */0M static	 char	  savefile[NAM$C_MAXRSS+1], /* filename to use for /SAVEing   */0: 		  deffile[NAM$C_MAXRSS+1], /* default filename		      */> 		  buffer[NAM$C_MAXRSS*2], /* for formatting message	      */> 		  prompt[TEMPBUF_MAX+1]; /* for asking for filename	      */A static $DESCRIPTOR(save_d,"SAVE");	/* for parsing /SAVE		      */ L static $DESCRIPTOR(savefile_d,savefile); /* for getting /SAVE value	      */    7    status = CLI$GET_VALUE(&save_d,&savefile_d,&length);R  +    if(status == SS$_NORMAL && !disp_failed)     {=       savefile[length] = '\0';		/* make it a string		      */f    }    else     {=       /* filename wasn't specified; prompt the user for it */   G       strcpy(deffile,"JOBXXXXXX");	/* make a filename for them	      */f       mktemp(deffile);       strcat(deffile,".LOG");t       my_puts(" ");a@       my_puts("What filename should be used for the log file?");.       cat(prompt,"[default is ",deffile,"] ");M       status = my_gets(channel,savefile,prompt,&length,sizeof(savefile) - 1);p         if(status == FAILURE)e 	 return(FAILURE);       else if(status == CANCEL)a 	 return(CANCEL);n         str_pref_trim(savefile);       str_post_trim(savefile);         if(savefile[0] == '\0')e 	 strcpy(savefile,deffile); 
       else8 	 strlu(savefile);		/* convert to all uppercase	      */    }      /* now copy the file */  .    status = copy_file(logfile,savefile,FALSE);      if(status == SUCCESS)    {5       cat(buffer,"\n\nLog file closed to ",savefile);T       my_puts(buffer);    }      return(status);   }	/*** save_log ***/  P /*******************************************************************************P ********************************************************************************     Function:	retrieve_log  3   Purpose:	Allow a user to retrieve JOBLOG file(s).      Formal Parameters:   	Name			Description_ 	----			-----------_+ 	stage_dir		staging directory for log filesq   	args			run-time arguments 	tt_chan			TTY channel     Global variables:m  % 	Name			Examine/Modify/Use/Read/Writet% 	----			-----------------------------[ 	tt_d					Xs     Return Codes:    	Code	 		Reasond 	----			------+ 	status			return code from user_retrieve or  				class_retrieve   Termination Codes:   	Code	 		Reason  	----			------( 	status			couldn't assign channel to TTY  P ********************************************************************************P *******************************************************************************/  H static ULONG retrieve_log(char *stage_dir,ARG_DEF *args,USHORT *tt_chan)   {	/*** retrieve_log ***/- 					/********   LOCAL  VARIABLES   ********/(8 	 ULONG	  status;		/* return code status holder	      */. 	 USHORT	  length,		/* length of buf		      */' 		  channel;		/* TTY channel			      */ E static	 char	  buf[BUFSIZ];		/* for storing the retrieve key	      */oH static $DESCRIPTOR(buf_d,buf);		/* for getting retrieve key string    */E static $DESCRIPTOR(class_d,"CLASS");	/* to check for /CLASS		      */(B static $DESCRIPTOR(user_d,"USER");	/* to check for /USER		      */    9    /* get a channel for the TTY so my_puts() will work */(  *    status = SYS$ASSIGN(&tt_d,tt_chan,0,0);      if(!(status & SS$_NORMAL))R       LIB$STOP(status);N  ,    if(CLI$PRESENT(&class_d) == CLI$_PRESENT)    {        /* get the class string */  6       status = CLI$GET_VALUE(&class_d,&buf_d,&length);         if(status == SS$_NORMAL)       { 4 	 buf[length] = '\0';		/* make it a string		      */) 	 status = class_retrieve(stage_dir,buf);*       }*
       else 	 status = FAILURE;*    }0    else if(CLI$PRESENT(&user_d) == CLI$_PRESENT)    {       /* get the user string */*  5       status = CLI$GET_VALUE(&user_d,&buf_d,&length);i         if(status == SS$_NORMAL)       {e4 	 buf[length] = '\0';		/* make it a string		      */( 	 status = user_retrieve(stage_dir,buf);       }-
       else 	 status = FAILURE;     }      return(status);   }	/*** retrieve_log ***/  P /*******************************************************************************P ********************************************************************************     Function:	user_retrieveE  C   Purpose:	Allow a user to retrieve a JOBLOG file that s/he "owns".-     Formal Parameters:   	Name			Descriptionl 	----			-----------*+ 	stage_dir		staging directory for log files*" 	from			user who sent the log file     Global variables:*  % 	Name			Examine/Modify/Use/Read/Write*% 	----			-----------------------------h 	nonei     Return Codes:l   	Code	 		Reason	 	----			------ 	SUCCESS 	FAILURE  P ********************************************************************************P *******************************************************************************/  6 static ULONG user_retrieve(char *stage_dir,char *from)   {	/*** user_retrieve ***/ - 					/********   LOCAL  VARIABLES   ********/ = 	 ULONG	  fcontext,		/* file context for getting file      */N2 		  status;		/* return code status holder	      */8 	 char	  *tptr;		/* temporary character pointer	      */8 	 USHORT	  verified;		/* set if log is VERIFIED	      */E 	 char	  newfile[NAM$C_MAXRSS+1], /* what to copy logfile to	      */=? 		  username[USERNAME_MAX+1], /* who sent the log file	      */UB 		  recipient[USERNAME_MAX+1], /* who the log file was sent to  */ 		  tempbuf[TEMPBUF_MAX+1];fK static	 char	  filename[NAM$C_MAXRSS+1], /* for wildcard searching	      */r6 		  logfile[NAM$C_MAXRSS+1]; /* logfile name		      */$ static $DESCRIPTOR(file_d,filename);$ static $DESCRIPTOR(file2_d,logfile);    .    /* make the wildcard filename to be used */  :    cat(filename,stage_dir,from,"_",getenv("USER"),"_*.*");     3    file_d.dsc$w_length = (USHORT) strlen(filename);     fcontext = 0L;V      /* see if the file exists */(  6    status = LIB$FIND_FILE(&file_d,&file2_d,&fcontext);      if(status != RMS$_NORMAL)    {I       cat(tempbuf,"\n\7No log file for you from user ",from,"\n\n",from);t       my_puts(tempbuf);t       return(FAILURE);    }  H    tptr = strchr(logfile,' ');		/* find the end of the filename	      */9    *tptr = '\0';			/* make the filename a string	      */e  .    /* find out if the log file was verified */  /    parse_filename(logfile,NULL,NULL,&verified);I      if(verified)L"       cat(newfile,from,".JOBLOG");    else -       cat(newfile,from,".UNVERIFIED_JOBLOG");o  +    /* copy the log file to user's area   */c  -    status = copy_file(logfile,newfile,FALSE);i      if(status == SUCCESS)    {       delete_log(logfile);M       cat(tempbuf,"\n\nJOBLOG from user ",from," successfully retrieved.\n");        my_puts(tempbuf);t2       cat(tempbuf,"The file is ",newfile,".\n\n");       my_puts(tempbuf);U    }    elset    {I       cat(tempbuf,"\n\7*ERROR* retrieving JOBLOG from user ",from,".\n");E       my_puts(tempbuf);L    }      return(status);   }	/*** user_retrieve ***/N sP /*******************************************************************************P ********************************************************************************     Function:	class_retrieve  G   Purpose:	Allow a user to retrieve JOBLOG file(s) for an entire class.n     Formal Parameters:   	Name			Descriptionu 	----			-----------e+ 	stage_dir		staging directory for log filese 	class			class to be retrieved     Global variables:N  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------l 	nonec     Return Codes:v   	Code	 		Reason	 	----			------ 	SUCCESS 	FAILURE     Termination Codes:   	Code	 		Reason_ 	----			------ 	statusC  P ********************************************************************************P *******************************************************************************/  8 static ULONG class_retrieve(char *stage_dir,char *class)   {	/*** class_retrieve ***/- 					/********   LOCAL  VARIABLES   ********/(= 	 ULONG	  fcontext,		/* file context for getting file      */*2 		  status;		/* return code status holder	      */= 	 char	  *name_ptr,		/* pointer to filename of logfile     */;3 		  *tptr;		/* temporary character pointer	      */F< 	 USHORT	  count = 0,		/* number of files retrieved	      */3 		  length,		/* length of formatted string	      */V6 		  verified;		/* set if log file is VERIFIED	      */E 	 char	  newfile[NAM$C_MAXRSS+1], /* what to copy logfile to	      */ ? 		  username[USERNAME_MAX+1]; /* who sent the log file	      */ K static	 char	  filename[NAM$C_MAXRSS+1], /* for wildcard searching	      */t6 		  logfile[NAM$C_MAXRSS+1], /* logfile name		      */ 		  tempbuf[TEMPBUF_MAX+1];u$ static $DESCRIPTOR(file_d,filename);$ static $DESCRIPTOR(file2_d,logfile);J static $DESCRIPTOR(format_d,"\n\n!ZW files retrieved for class !AD.\n\n");% static $DESCRIPTOR(buffer_d,tempbuf);     6    /* create the wildcard name for retrieving files */  A    squeeze_str(class);			/* make sure class is free of spaces  */ G    cat(filename,stage_dir,"*_",getenv("USER"),"_",class,".*JOBLOG*;*");p3    file_d.dsc$w_length = (USHORT) strlen(filename);e    fcontext = 0L;"  6    status = LIB$FIND_FILE(&file_d,&file2_d,&fcontext);      while(status == RMS$_NORMAL)r    {(       count++;				/* count it			      */!       tptr = strchr(logfile,' ');U=       *tptr = '\0';			/* make filename a real string	      */   O       name_ptr = strchr(logfile,']') + 1L; /* skip past directory spec	      */]  D       /* create the filename that the log file is to be copied to */  7       parse_filename(name_ptr,username,NULL,&verified);o         if(verified)" 	 cat(newfile,username,".JOBLOG");
       else- 	 cat(newfile,username,".UNVERIFIED_JOBLOG");"  5       if(copy_file(logfile,newfile,FALSE) == SUCCESS)r 	 delete_log(logfile);
       else       {_8 	 cat(tempbuf,"\n\n\7*ERROR* copying log file ",logfile, 	     " to your area\n");*       }   9       status = LIB$FIND_FILE(&file_d,&file2_d,&fcontext);*    }      if(status == RMS$_FNF)e    {L       cat(tempbuf,"\7\n\nNo JOBLOG files for you from class ",class,"\n\n");       my_puts(tempbuf);t
       return;-    }  C    if(status != RMS$_NMF)		/* did we stop for the right reason?  */a1       LIB$STOP(status);			/* nope.....			      */l  )    /* terminate the "finding" of files */t  )    status = LIB$FIND_FILE_END(&fcontext);_  8    if((status != SS$_NORMAL) && (status != RMS$_NORMAL))       LIB$STOP(status);d  L    status = SYS$FAO(&format_d,&length,&buffer_d,count,(ULONG) strlen(class),
 		    class);	      if(!(status & SS$_NORMAL))        LIB$SIGNAL(status);*      tempbuf[length] = '\0';    my_puts(tempbuf);  
    return;   }	/*** class_retrieve ***/ *P /*******************************************************************************P ********************************************************************************     Function:	delete_mlog   G   Purpose:	Allow a user to delete JOBLOG file(s) from the staging area.S     Formal Parameters:   	Name			Description  	----			-----------n+ 	stage_dir		staging directory for log files/+ 	tt_chan			for getting a channel to the TTYt     Global variables:f  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------; 	tt_d					Xf 	JLG_CANT_DELETE_LOG			X     Return Codes:_   	Code	 		Reasone 	----			------ 	SUCCESS 	FAILURE     Termination Codes:   	Code	 		Reasono 	----			------ 	status$  P ********************************************************************************P *******************************************************************************/  9 static ULONG delete_mlog(char *stage_dir,USHORT *tt_chan)g   {	/*** delete_mlog ***/S- 					/********   LOCAL  VARIABLES   ********/ ; 	 ULONG	  status,		/* return code status holder #1	      */i6 		  status2,		/*   "     "     "      "    #2	      */4 		  fcontext;		/* context for FINDing files	      */1 	 USHORT	  length;		/* length of buffer		      */t= 	 char	  *username,		/* name of user doing the deleting    */ 3 		  *tptr,		/* temporary character pointer	      */a7 		  filename[NAM$C_MAXRSS+1], /* logfile name		      */d@ 		  logfile[NAM$C_MAXRSS+1]; /* output of LIB$FIND_FILE	      */F static	 char	  command[COMMAND_MAX+1], /* MAIL command buffer	      */= 		  buffer[BUFSIZ+1];	/* buffer for reading from TTY	      */ & static $DESCRIPTOR(command_d,command);& static $DESCRIPTOR(delete_d,"DELETE");! static $DESCRIPTOR(buf_d,buffer);  static $DESCRIPTOR(null_d,""); static $DESCRIPTOR(file_d,""); static $DESCRIPTOR(file2_d,"");F  static $DESCRIPTOR(prompt_d,"");    A    /* get the name of the user to whom the log file was mailed */*  4    status = CLI$GET_VALUE(&delete_d,&buf_d,&length);      if(status == SS$_NORMAL)c;       buffer[length] = '\0';		/* make it a string		      */U    elsef    {*       /* need a channel to the TTY here */  -       status = SYS$ASSIGN(&tt_d,tt_chan,0,0);           if(!(status & SS$_NORMAL)) 	 LIB$STOP(status);	  '       status = my_gets(*tt_chan,buffer,	; 		       "\n\nWho was the log file originally mailed to: ",	* 		       &length,(USHORT) sizeof(buffer));         if(status == CANCEL) 	 return(SUCCESS);  L       *(buffer + strlen(buffer) - 1) = '\0'; /* get rid of newline 	      */:       strlu(buffer);			/* conver to all uppercase	      */    }      username = getenv("USER");   K    /* create the wildcard filespec that we'll use to check for log files */o  >    cat(filename,stage_dir,username,"_",buffer,"_*.*JOBLOG_*");  #    file_d.dsc$a_pointer = filename;t3    file_d.dsc$w_length = (USHORT) strlen(filename);A#    file2_d.dsc$a_pointer = logfile;]2    file2_d.dsc$w_length = (USHORT) NAM$C_MAXRSS+1;    fcontext = 0L;o    status2 = SUCCESS;	  6    status = LIB$FIND_FILE(&file_d,&file2_d,&fcontext);  5    while(status == RMS$_NORMAL && status2 == SUCCESS)i    {!       tptr = strchr(logfile,' ');T=       *tptr = '\0';			/* make filename a real string	      */t  K       if(delete_log(logfile) == FAILURE) /* try to delete the file	      */t- 	 LIB$SIGNAL(JLG_CANT_DELETE_LOG,1L,logfile);c
       else       {M6 	 cat(command,"$MAIL/SUBJECT=\"JOBLOG from ",username,) 	     " has been deleted\" NL: ",buffer);Z  4 	 command_d.dsc$w_length = (USHORT) strlen(command);  7 	 /* now try to spawn the command to mail the notice */a  F 	 status = LIB$SPAWN(&command_d,&null_d,&null_d,NULL,NULL,0L,&status2, 			    0L,0L,0L,0L,NULL,NULL);   	 if(!(status & SS$_NORMAL)) 	    LIB$SIGNAL(JLG_NO_SPAWN);  : 	 cat(command,"\nLogfile for user ",buffer," deleted.\n"); 	 my_puts(command);l       }t  9       status = LIB$FIND_FILE(&file_d,&file2_d,&fcontext);=    }      if(status == RMS$_FNF)     {F       cat(command,"\7\n\nYou don't have any JOBLOG files for ",buffer, 	  " pending.\n\n");       my_puts(command);b       return(FAILURE);    }H    else	if(status != RMS$_NMF)		/* did we stop for the right reason?  */2       LIB$SIGNAL(status);		/* nope.....			      */  B    /* don't care if these fail because we'll be exiting shortly */  )    status = LIB$FIND_FILE_END(&fcontext);e.    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      return(SUCCESS);u   }  	/*** delete_mlog ***/G gP /*******************************************************************************P ********************************************************************************     Function:	get_logicals  A   Purpose:	Translate the logicals for JOBLOG$STAGE and JOBLOG$LOGe 		and save them for later.     Formal Parameters:   	Name			Descriptiont 	----			-----------e3 	log_dir			where to store translation of JOBLOG$LOGc6 	stage_dir		where to store translation of JOBLOG$STAGE     Global variables:F  % 	Name			Examine/Modify/Use/Read/Writeb% 	----			-----------------------------  	none      Return Codes:O   	Code	 		Reasonl 	----			------ 	none+     Termination Codes:   	Code	 		Reasonm 	----			------0 	JLG_NO_LOGICAL		system logicals are not defined  P ********************************************************************************P *******************************************************************************/  7 static void get_logicals(char *log_dir,char *stage_dir)a   {	/*** get_logicals ***/- 					/********   LOCAL  VARIABLES   ********/s?        	 ULONG	  status;		/* return code status holder	      */(: 	 USHORT	  length;		/* length of resulting string	      */@ 	 ITM_LST  items[] = {		/* items obtained during translation  */B {0,LNM$_STRING,NULL,NULL},		/* things are filled in below	      */ {0,0,NULL,NULL}};b" $DESCRIPTOR(table_d,"LNM$SYSTEM");# $DESCRIPTOR(logdir_d,"JOBLOG$LOG");f' $DESCRIPTOR(stagedir_d,"JOBLOG$STAGE");p    #    items[0].buf_len = NAM$C_MAXRSS;$    items[0].buf_addr = log_dir;sH    items[0].ret_len = &length;		/* store it right back in length      */  5    status = SYS$TRNLNM(0,&table_d,&logdir_d,0,items);       if(!(status & SS$_NORMAL))b9       LIB$STOP(JLG_NO_LOGICAL,1L,logdir_d.dsc$a_pointer);o  :    *(log_dir + length) = '\0';		/* terminate it			      */  !    items[0].buf_addr = stage_dir;e  7    status = SYS$TRNLNM(0,&table_d,&stagedir_d,0,items);e      if(!(status & SS$_NORMAL))i;       LIB$STOP(JLG_NO_LOGICAL,1L,stagedir_d.dsc$a_pointer);r  ;    *(stage_dir + length) = '\0';	/* terminate it			      */r
    return;   }	/*** get_logicals ***/ eP /*******************************************************************************P ********************************************************************************     Function:	ctrly_trap  1   Purpose:	Set up the AST for trapping control-Y.      Formal Parameters:   	Name			Description" 	----			-----------" 	channel			TTY channel     Global variables:_  % 	Name			Examine/Modify/Use/Read/Writed% 	----			-----------------------------  	none(     Return Codes:E   	Code			Reason 	----			------  	SUCCESS			successful completion& 	FAILURE			unable to set control-Y AST  P ********************************************************************************P *******************************************************************************/  ' static ULONG ctrly_trap(USHORT channel)R   {	/*** ctrly_trap ***/  G    if(SYS$QIOW(0,channel,IO$_SETMODE | IO$M_CTRLYAST,0,0,0,ctrly_ast,0,{ 	       0,0,0,0) != SS$_NORMAL)        return(FAILURE);      return(SUCCESS);c   }	/*** ctrly_trap ***/  P /*******************************************************************************P ********************************************************************************     Function:	ctrly_asts  8   Purpose:	AST routine alled when control-Y is detected.     Formal Parameters:   	Name			Description* 	----			-----------r 	none      Global variables:   % 	Name			Examine/Modify/Use/Read/Writet% 	----			-----------------------------N 	noneN     Return Codes:e   	Code			Reason 	----			------ 	nonef  P ********************************************************************************P *******************************************************************************/   static void ctrly_ast(void)t   {	/*** ctrly_ast ***/*      ctrly_trap(tt_chan);      h
    return;   }	/*** ctrly_ast ***/c eP /*******************************************************************************P ********************************************************************************     Function:	ctrlc_trap  1   Purpose:	Set up the AST for trapping control-C.,     Formal Parameters:   	Name			Descriptiont 	----			-----------p 	nonem     Global variables:/  % 	Name			Examine/Modify/Use/Read/Writem% 	----			-----------------------------> 	tt_chan					X     Return Codes:%   	Code			Reason 	----			------  	SUCCESS			successful completion& 	FAILURE			unable to set control-C AST  P ********************************************************************************P *******************************************************************************/   static ULONG ctrlc_trap(void)s   {	/*** ctrlc_trap ***/  G    if(SYS$QIOW(0,tt_chan,IO$_SETMODE | IO$M_CTRLCAST,0,0,0,ctrlc_ast,0,O 	       0,0,0,0) != SS$_NORMAL)i       return(FAILURE);      return(SUCCESS);    }	/*** ctrlc_trap ***/ *P /*******************************************************************************P ********************************************************************************     Function:	ctrlc_astu  8   Purpose:	AST routine alled when control-C is detected.     Formal Parameters:   	Name			Descriptionl 	----			-----------l 	nonet     Global variables:t  % 	Name			Examine/Modify/Use/Read/Writeh% 	----			-----------------------------t 	noneE     Return Codes:c   	Code			Reason 	----			------ 	noneL  P ********************************************************************************P *******************************************************************************/   static void ctrlc_ast(void)e   {	/*** ctrlc_ast ***/l  6    ctrlc_trap();			/* reset the control-C AST	      */
    return;   }	/*** ctrlc_ast ***/= SP /*******************************************************************************P ********************************************************************************     Function:	joblog_check  @   Purpose:	Make sure that the user isn't already running JOBLOG.     Formal Parameters:   	Name			Description  	----			-----------l 	noned     Global variables:g  % 	Name			Examine/Modify/Use/Read/Writes% 	----			-----------------------------  	JLG_INUSE				Xs     Return Codes:=   	Code			Reason 	----			------ 	none      Termination Codes:   	Code	 		Reasonc 	----			------ 	statusu  P ********************************************************************************P *******************************************************************************/   static void joblog_check(void)   {	/*** joblog_check ***/- 					/********   LOCAL  VARIABLES   ********/28 	 ULONG	  status,		/* return code status holder	      */+ 		  owner;		/* parent process PID		      */ 8 	 long	  item_code;		/* for LIB$GETJPI()'s sake	      */5 	 short	  length;		/* length of process name	      */&K static	 char	  procname[PNAME_MAX+1],/* current process name array	      */ B 		  newpname[PNAME_MAX+1];/* process name for JOBLOG subprocess */M static $DESCRIPTOR(procname_d,procname); /* for getting process name	      */GP static $DESCRIPTOR(newpname_d,newpname); /* for creating new process name     */* static $DESCRIPTOR(format_d,"JOBLOG_!XL");    J    /* make sure that the user doesn't run JOBLOG while they are already in     * JOBLOG     */      item_code = JPI$_PRCNAM;o=    status = LIB$GETJPI(&item_code,0,0,0,&procname_d,&length);L      if(!(status & SS$_NORMAL))0       LIB$STOP(status);!      procname[length] = '\0';B      item_code = JPI$_OWNER;2    status = LIB$GETJPI(&item_code,0,0,&owner,0,0);      if(!(status & SS$_NORMAL))t       LIB$STOP(status);N  H    /* create what would the process name be if the user ran JOBLOG while     * in JOBLOGm     */  B    status = SYS$FAO(&format_d,&length,&newpname_d,owner & 0xFFFF);      if(!(status & SS$_NORMAL))        LIB$STOP(status);       newpname[length] = '\0';*  !    if(!strcmp(newpname,procname))/       LIB$STOP(JLG_INUSE);  
    return;   }	/*** joblog_check ***/ iP /*******************************************************************************P ********************************************************************************     Function:	skim  F   Purpose:	Skim the JOBLOG staging directory for old JOBLOG files, de-@ 		leting them if they are older than the /WAIT value and warning1 		senders if they are older then the /WARN value.i     Formal Parameters:   	Name			Descriptiong 	----			-----------E2 	stage_dir		staging directory for mailed log files     Global variables:m  % 	Name			Examine/Modify/Use/Read/Writel% 	----			-----------------------------J 	noneO     Return Codes:r   	Code			Reason 	----			------ 	none      Termination Codes:   	Code	 		Reasoni 	----			------ 	status	  P ********************************************************************************P *******************************************************************************/  ! static void skim(char *stage_dir)n   {	/*** skim ***/- 					/********   LOCAL  VARIABLES   ********/*9 	 char	  *ptr;			/* for skipping dev/directory spec    */*= 	 ULONG	  fcontext,		/* file context for getting file      */ 2 		  status,		/* return code status holder	      */6 		  wait_days,		/* # days before deleting log	      */8 		  warn_days,		/* # days before warning people	      */: 		  delete_time;		/* time in secs when file is deleted  */5 	 time_t	  cur_time,		/* current time value		      */o; 		  elapsed_time;		/* current time - file creation time  */*< 	 USHORT	  length;		/* for trimming trailing blanks	      */; struct	 stat	  statbuf;		/* for getting file's age	      */L: struct	 tm	  *del_tm;		/* for getting delete date	      */( static	 char	  wildname[NAM$C_MAXRSS+1], 		  filename[NAM$C_MAXRSS+1],s; 		  buf[INT_STR_MAX+1];	/* for getting int strings	      */ $ static $DESCRIPTOR(wild_d,wildname);$ static $DESCRIPTOR(file_d,filename);" static $DESCRIPTOR(wait_d,"WAIT");" static $DESCRIPTOR(warn_d,"WARN"); static $DESCRIPTOR(buf_d,buf);    +    if(CLI$PRESENT(&wait_d) == CLI$_PRESENT)0    {        /* get the class string */  5       status = CLI$GET_VALUE(&wait_d,&buf_d,&length);t         if(status == SS$_NORMAL)4 	 buf[length] = '\0';		/* make it a string		      */
       else 	 LIB$STOP(status);   $       wait_days = (ULONG) atol(buf);    }  +    if(CLI$PRESENT(&warn_d) == CLI$_PRESENT)*    {        /* get the class string */  5       status = CLI$GET_VALUE(&warn_d,&buf_d,&length);*         if(status == SS$_NORMAL)4 	 buf[length] = '\0';		/* make it a string		      */
       else 	 LIB$STOP(status);   $       warn_days = (ULONG) atol(buf);    }      fcontext = 0L;"    time(&cur_time);n    strcpy(wildname,stage_dir);<    strcat(wildname,"*.*;*");		/* look at all files		      */3    wild_d.dsc$w_length = (USHORT) strlen(wildname);	  5    status = LIB$FIND_FILE(&wild_d,&file_d,&fcontext);       while(status == RMS$_NORMAL)A    {       length = 0;*  =       while(length < NAM$C_MAXRSS && filename[length] != ' ')*          ++length;  =       filename[length] = '\0';		/* make it a string		      */cE       stat(filename,&statbuf);		/* to find out how old it is	      */Y  >       /* should we delete or warn the sender and recipient? */  1       elapsed_time = cur_time - statbuf.st_atime;E  5       if(elapsed_time > (wait_days * SECONDS_IN_DAY))  	 delete_log(filename);*<       else if(elapsed_time > (warn_days * SECONDS_IN_DAY) &&8 	      elapsed_time <= (warn_days + 1) * SECONDS_IN_DAY)       {*H 	 delete_time = (ULONG) statbuf.st_ctime + (wait_days * SECONDS_IN_DAY);# 	 del_tm = localtime(&delete_time);t- 	 ptr = (char *) (strchr(filename,']') + 1L);-; 	 warn(ptr,statbuf.st_ctime,del_tm->tm_mon,del_tm->tm_mday,U 	      del_tm->tm_year);       }-  8       status = LIB$FIND_FILE(&wild_d,&file_d,&fcontext);    }  
    return;   }	/*** skim ***/ *P /*******************************************************************************P ********************************************************************************     Function:	warn  6   Purpose:	Warn the sender and recipient of a logfile.     Formal Parameters:   	Name			Description* 	----			-----------* 	filename		log file name' 	create_time		when log file was created*3 	month,day,year		date when log file will be deleted*     Global variables:c  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------l 	nonet     Return Codes:c   	Code			Reason 	----			------ 	none   P ********************************************************************************P *******************************************************************************/  L static void warn(char *filename,UINT create_time,int month,int day,int year)   {	/*** warn ***/- 					/********   LOCAL  VARIABLES   ********/*8 	 ULONG	  status,		/* return code status holder	      */ 		  status2;= 	 USHORT	  verified,		/* set if log file is verified	      */ 3 		  length;		/* length of formatted string	      */$" 	 char	  username[USERNAME_MAX+1], 		  recipient[USERNAME_MAX+1], 		  tempfile[NAM$C_MAXRSS+1],E 		  command[COMMAND_MAX+1]; E static	 char	  out_buf[BUFSIZ],	/* formatting and I/O buffer	      */* 		  deadline_buf[BUFSIZ];*G static	 char	  *months[] = {"January","February","March","April","May",*7 			       "June","July","August","September","October",A" 			       "November", "December"};@ struct	 FAB	  out_fab;		/* for creating mail message file     */ struct	 RAB	  out_rab;! static $DESCRIPTOR(null_d,"NL:");m! static $DESCRIPTOR(command_d,"");*& static $DESCRIPTOR(out_buf_d,out_buf);, static $DESCRIPTOR(deadline_d,deadline_buf); static $DESCRIPTOR(format_d,D 	    "If it is not retrieved, it will be deleted on !AS !ZL, !ZL."); static $DESCRIPTOR(month_d,"");m    9    parse_filename(filename,username,recipient,&verified);r  .    /* make a mail message for the recipient */       strcpy(tempfile,"JOBXXXXXX");    mktemp(tempfile);    strcat(tempfile,".TMP");       out_rab = cc$rms_rab;B    out_rab.rab$l_fab = &out_fab;	/* pointer to input FAB		      */H    out_rab.rab$b_rac = RAB$C_SEQ;	/* sequential access for copy	      */K    out_rab.rab$w_usz = sizeof(out_buf);	/* length of output buffer	      */*?    out_rab.rab$l_rbf = out_buf;		/* pointer to buffer		      */r      out_fab = cc$rms_fab;5    out_fab.fab$w_ifi = 0; 		/* reset this!			      */C!    out_fab.fab$b_fac = FAB$M_PUT;	       out_fab.fab$l_fna = tempfile;0    out_fab.fab$b_fns = (UCHAR) strlen(tempfile);      /* open the output file */p  !    status = SYS$CREATE(&out_fab);       if(status != RMS$_NORMAL)    {       SYS$CLOSE(&out_fab);       LIB$SIGNAL(status);S
       return;o    }  -    /* connect the output file's RMS blocks */]  "    status = SYS$CONNECT(&out_rab);      if(status != RMS$_NORMAL)    {       SYS$CLOSE(&out_fab);       LIB$SIGNAL(status);]
       return;r    }      /* warn the recipient */i      if(verified) G       cat(out_buf,"There is a VERIFIED JOBLOG log file from ",username,E 		  " waiting to");a    elsetJ       cat(out_buf,"There is an UNVERIFIED JOBLOG log file from ",username, 		  " waiting to");l  0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);    status = SYS$PUT(&out_rab);  :    strcpy(out_buf,"be retrieved.  To retrieve it, enter");0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);    status = SYS$PUT(&out_rab);      out_buf[0] = '\0';)    out_rab.rab$w_rsz = 0;\    status = SYS$PUT(&out_rab);  2    cat(out_buf,"	JOBLOG/RETRIEVE/USER=",username);0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);    status = SYS$PUT(&out_rab);      out_buf[0] = '\0';p    out_rab.rab$w_rsz = 0;l    status = SYS$PUT(&out_rab);  )    month_d.dsc$a_pointer = months[month]; 9    month_d.dsc$w_length = (USHORT) strlen(months[month]);e  L    status = SYS$FAO(&format_d,&length,&deadline_d,&month_d,day,year + 1900);      if(!(status & SS$_NORMAL))o
       return;   (    strmcpy(out_buf,deadline_buf,length);0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);      status = SYS$PUT(&out_rab);       status = SYS$CLOSE(&out_fab);      if(status != RMS$_NORMAL)    {       LIB$SIGNAL(status);e
       return;     }      if(verified)"C       cat(command,"$MAIL/SUBJECT=\"VERIFIED JOBLOG from ",username, 2 	  " is still pending\" ",tempfile," ",recipient);    elseoC       cat(command,"$MAIL/SUBJECT=\"VERIFIED JOBLOG from ",username,	2 	  " is still pending\" ",tempfile," ",recipient);  %    command_d.dsc$a_pointer = command;*5    command_d.dsc$w_length = (USHORT) strlen(command);*  8    /* now try to spawn the command to mail the notice */  M    status = LIB$SPAWN(&command_d,&null_d,&null_d,NULL,NULL,0L,&status2,0L,0L,c 		      0L,0L,NULL,NULL);r  ;    delete(tempfile);			/* kill it before we forget	      */t      if(!(status & SS$_NORMAL))c    {       LIB$SIGNAL(JLG_NO_SPAWN);l
       return;     }      /* now warn the sender */  5    out_fab.fab$w_ifi = 0; 		/* reset this!			      */u  !    status = SYS$CREATE(&out_fab);	      if(status != RMS$_NORMAL)    {       LIB$SIGNAL(status);R
       return;	    }  /    /* reconnect the output file's RMS blocks */*  "    status = SYS$CONNECT(&out_rab);      if(status != RMS$_NORMAL)    {       SYS$CLOSE(&out_fab);       LIB$SIGNAL(status);t
       return;r    }      /* warn the recipient */   <    cat(out_buf,"The JOBLOG log file you sent to ",recipient,#        " has not been retrieved."); 0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);      status = SYS$PUT(&out_rab);       strcpy(out_buf,deadline_buf);0    out_rab.rab$w_rsz = (USHORT) strlen(out_buf);      status = SYS$PUT(&out_rab);       status = SYS$CLOSE(&out_fab);      if(status != RMS$_NORMAL)    {       LIB$SIGNAL(status);e
       return;*    }  ?    cat(command,"$MAIL/SUBJECT=\"JOBLOG logfile for ",recipient,i2        " not retrieved\" ",tempfile," ",username);  5    command_d.dsc$w_length = (USHORT) strlen(command);i  8    /* now try to spawn the command to mail the notice */  M    status = LIB$SPAWN(&command_d,&null_d,&null_d,NULL,NULL,0L,&status2,0L,0L,  		      0L,0L,NULL,NULL);A  ;    delete(tempfile);			/* kill it before we forget	      */R      if(!(status & SS$_NORMAL))I       LIB$SIGNAL(JLG_NO_SPAWN);i  
    return;   }	/*** warn ***/ EP /*******************************************************************************P ********************************************************************************     Function:	parse_filename  D   Purpose:	Parse a filename and extract the username, recipient, and3 		the verified status.  The form of the filename is   , 		from_to_account.flag_joblog_dd_mm_yy_hh_mm  = 		where flag is V for VERIFIED log files and U for UNVERIFIEDt 		log files.     Formal Parameters:   	Name			Descriptiont 	----			-----------i  	filename		filename to be parsed" 	username		username to be returned$ 	recipient		recipient to be returned& 	verified		set if log file is verified     Global variables:b  % 	Name			Examine/Modify/Use/Read/Writem% 	----			-----------------------------  	noner     Return Codes:l   	Code			Reason 	----			------ 	none(  P ********************************************************************************P *******************************************************************************/  I static void parse_filename(char *filename,char *username,char *recipient,  			   USHORT *verified)I   {	/*** parse_filename ***/- 					/********   LOCAL  VARIABLES   ********/ 9 	 char	  *ptr,			/* to parse parts of the filename     */,# 		  *ptr2;		/* ditto....			      */)1 	 int	  length;		/* length to be copied		      */F        /* get the sender name */      ptr = strchr(filename,'_');    length = ptr - filename;       if(username != NULL)i0       strmcpy(username,filename,ptr - filename);  ,    ptr++;				/* start at recipient		      */      /* get the recipient name */$      ptr2 = strchr(ptr,'_');    length = ptr2 - ptr;,      if(recipient != NULL)$       strmcpy(recipient,ptr,length);      ptr = strchr(ptr2,'.');      if(verified != NULL)t    {       if(*(ptr + 1) ==  'V') 	 *verified = TRUE;;
       else 	 *verified = FALSE;    }  
    return;   }	/*** parse_filename ***/ *P /*******************************************************************************P ********************************************************************************     Function:	squeeze_strf  <   Purpose:	Squeeze the whitespace characters out of a string     Formal Parameters:   	Name			Descriptionn 	----			-----------i 	str			string to be squeezed     Global variables:   % 	Name			Examine/Modify/Use/Read/Writeo% 	----			------------------------------ 	none-     Return Codes:	   	Code			Reason 	----			------ 	noneu  P ********************************************************************************P *******************************************************************************/  + static void squeeze_str(register char *str)*   {	/*** squeeze_str ***/*- 					/********   LOCAL  VARIABLES   ********/*6 register char	  *ptr;			/* temporary pointer		      */    
    ptr = str;       while(*ptr)    {       if(!isspace(*ptr)) 	 *str++ = *ptr++;
       else 	 ptr++;    }  6    *str = '\0';				/* make sure it's a string	      */
    return;   }	/*** squeeze_str ***/	 cP /*******************************************************************************P ********************************************************************************     Function:	my_putsy  (   Purpose:	Output a string to the screen     Formal Parameters:   	Name			Description  	----			-----------1  	buffer			string to be displayed     Global variables:m  % 	Name			Examine/Modify/Use/Read/Writee% 	----			-----------------------------f 	tt_chan					X     Return Codes:-   	Code			Reason 	----			------ 	none	     Termination Codes:   	Code	 		Reason* 	----			------ 	status			write to TTY failed* 	iosb.status  P ********************************************************************************P *******************************************************************************/  ! static void my_puts(char *buffer)    {	/*** my_puts ***/*- 					/********   LOCAL  VARIABLES   ********/*? register ULONG	  status,		/* return code status holder	      */*5 		  length;		/* length of string to be written     */*? static	 IOSB_DEF iosb;			/* I/O status block for write	      */e    #    length = (ULONG) strlen(buffer);OO    status = SYS$QIOW(0,tt_chan,IO$_WRITEVBLK,&iosb,0,0,buffer,length,0,32,0,0);       if(!(status & SS$_NORMAL))	       LIB$STOP(status);r       if(iosb.status != SS$_NORMAL)       LIB$STOP(iosb.status);  
    return;   }	/*** my_puts ***/- 	P /*******************************************************************************P ********************************************************************************     Function:	my_gets*  <   Purpose:	Get a string from the screen without using C I/O.     Formal Parameters:   	Name			Descriptionb 	----			-----------/ 	channel			TTY channel& 	buffer			where input string is stored 	prompt			prompt string	  	length			length of input string 	buflen			size of buffer     Global variables:   % 	Name			Examine/Modify/Use/Read/Writee% 	----			-----------------------------* 	nonet     Return Codes:[   	Code			Reason 	----			------ 	SUCCESS 	FAILURE 	CANCELa  P ********************************************************************************P *******************************************************************************/  M static ULONG my_gets(USHORT channel,char *buffer,char *prompt,USHORT *length,, 		     USHORT buflen)/   {	/*** my_gets ***/e- 					/********   LOCAL  VARIABLES   ********/ 8 	 ULONG	  status,		/* return code status holder	      */' 		  retval;		/* return value			      */n0 	 IOSB_DEF iosb;			/* I/O status block		      */C static $DESCRIPTOR(prompt_d,"");	/* used for prompt string	      */_> static $DESCRIPTOR(buffer_d,"");	/* for input buffer		      */    L    status = SYS$QIOW(0,channel,IO$_READVBLK|IO$_READPROMPT,&iosb,0,0,buffer,- 			(ULONG) buflen,0,0,prompt,strlen(prompt));       if(!(status & SS$_NORMAL))        return(FAILURE);      if(iosb.terminator == 0)_    {!       /* user pressed ^C or ^Y */$         buffer[0] = '\0';s       return(CANCEL);[    };    else if(iosb.terminator == CONTROL_Z && iosb.count == 0)T    {"       buffer[0] = CARRIAGE_RETURN;       buffer[1] = '\0';*       return(SUCCESS);    }  <    buffer[iosb.count] = '\0';		/* make it a string		      */    *length = iosb.count;    return(SUCCESS);*   }	/*** my_gets ***/c nP /*******************************************************************************P ********************************************************************************     Function:	kill_log  7   Purpose:	Kill the log file during an ungraceful exit.      Formal Parameters:   	Name			Descriptiont 	----			-----------l 	none      Global variables:N  % 	Name			Examine/Modify/Use/Read/Write-% 	----			-----------------------------n 	log_fab					X 	logfile					X 	privs				  X	X	     Return Codes:    	Code			Reason 	----			------ 	none-  P ********************************************************************************P *******************************************************************************/   static void kill_log(void)   {	/*** kill_log ***/- 					/********   LOCAL  VARIABLES   ********/C8 	 ULONG	  status;		/* return code status holder	      */    E    privs[0] = PRV$M_SYSPRV;		/* so we can get to the log directory */i  -    status = SYS$SETPRV(ON,&privs,FALSE,NULL);t      if(!(status & SS$_NORMAL)),       LIB$STOP(status);n      SYS$CLOSE(&log_fab);y    delete(logfile);w  .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))        LIB$STOP(status);c  
    return;   }	/*** kill_log ***/ _P /*******************************************************************************P ********************************************************************************     Function:	quit2   D   Purpose:	Secondary exit handler called from the primary handler to4 		help ensure that no old log files are left around.     Formal Parameters:   	Name			Description  	----			-----------C 	nonew     Global variables:c  % 	Name			Examine/Modify/Use/Read/WriteE% 	----			-----------------------------I 	logfile					X     Return Codes:I   	Code			Reason 	---- 			------S 	nonei  P ********************************************************************************P *******************************************************************************/   static void quit2(void)t   {	/*** quit2 ***/       delete_log(logfile);     exit(0);d   }	/*** quit2 ***/f  P /*******************************************************************************P ********************************************************************************     Function:	subprocess_exitg  B   Purpose:	Called when the subprocess is terminated.  Just set the< 		hangup flag and exit and let the exit handler do the rest.     Formal Parameters:   	Name			Descriptioni 	----			-----------  	none(     Global variables:l  % 	Name			Examine/Modify/Use/Read/Write$% 	----			-----------------------------  	flags.hangup		   XD 	clean_exit			  X_     Return Codes:    	Code			Reason 	---- 			------{ 	SUCCESS 	FAILURE  P ********************************************************************************P *******************************************************************************/  ! static void subprocess_exit(void)w   {	/*** subprocess_exit ***/*      if(flags.hangups)    {B       clean_exit = TRUE;		/* "normal" exit if we get here	      */       exit(1);    }  
    return;   }	/*** subprocess_exit ***/   P /*******************************************************************************P ********************************************************************************     Function:	delete_log  D   Purpose:	Delete a log file from the log area.  SYSPRV is needed to= 		do this so we turn it on, delete the file, and turn it off.s     Formal Parameters:   	Name			DescriptionU 	----			-----------e) 	logfile			name of log file to be deletedI     Global variables:n  % 	Name			Examine/Modify/Use/Read/Write % 	----			-----------------------------* 	privs				  X	X*     Return Codes:*   	Code			Reason 	---- 			------* 	SUCCESS 	FAILURE  P ********************************************************************************P *******************************************************************************/  ' static USHORT delete_log(char *logfile)a   {	/*** delete_log ***/- 					/********   LOCAL  VARIABLES   ********/l8 	 ULONG	  status;		/* return code status holder	      */    E    privs[0] = PRV$M_SYSPRV;		/* need SYSPRV to delete the log file */n  -    status = SYS$SETPRV(ON,&privs,FALSE,NULL);	      if(!(status & SS$_NORMAL))*       return(FAILURE);      delete(logfile);*  .    status = SYS$SETPRV(OFF,&privs,FALSE,NULL);      if(!(status & SS$_NORMAL))*       return(FAILURE);      return(SUCCESS);n   }	/*** delete_log ***/