/*  ++

 Title:
	SET_ERRORS - Set error count to 1 for all device, memory and cpu error fields

 Version:
	1.0

 Facility:
	System Management

 Abstract:
	This program stores a value of one in all ucb error fields, and the cpu and
	memory fields. SET_ERRORS is intended as a debugging aid for the CLEAR_ERRORS
	program.

 Environment:
	CMKRNL required, I/O database is locked for write access

 Author:
	Mark Oakley	Verizon Wireless	20-Dec-2002

 Modified:
	

--  */

#include  <ddbdef.h>
#include  <eihddef.h>
#include  <eihidef.h>
#include  <fabdef.h>
#include  <iodef.h>
#include  <iosbdef.h>
#include  <ipldef.h>
#include  <jpidef.h>
#include  <lib$routines.h>
#include  <psldef.h>
#include  <rmsdef.h>
#include  <sbdef.h>
#include  <sch_routines.h>
#include  <ssdef.h>
#include  <starlet.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <vms_macros.h>
#include  <ucbdef.h>

#define   NL         0

typedef   struct item_list_struct
{ short          buff;
  short          code;
  char           *addr;
  char           *retl; } item_list_typedef;

globalref unsigned  SCS$GQ_CONFIG;         /* Start of SCS system blocks                      */
globalref unsigned  CTL$GL_PCB;            /* Needed for locking & unlocking I/O database     */
globalref unsigned  EXE$GL_MEMERRS;        /* Pointer to memory error count                   */
globalref unsigned  EXE$GL_MCHKERRS;       /* Pointer to cpu error count                      */
extern    void      EXE$REI_INIT_STACK (); /* Use this routine to reach user mode from kernel */

struct _sb     *sb;                   /* SCS System block pointer   */
struct _ddb    *ddb;                  /* Device data block pointer  */
struct _ucb    *ucb;                  /* Unit control block pointer */

char           iodb_locked = 0;       /* Flag for our error handler */

/*
  Can't do much in the main program except check our VMS version and get to a 
  kernel-mode routine where we can do work.
*/
main (int argc, char *argv[])
{
  unsigned int   check_vms_version ();
  unsigned int   zero_errors ();
  unsigned int   status;

  if ((status = check_vms_version () ) != SS$_NORMAL)
    sys$exit (status);

  sys$exit (sys$cmkrnl (zero_errors, 0));
}

/*
  We would like to know what VMS version this program linked so that we can
  confirm that's the VMS version we're running on. Unforunately the VMS version
  is not stored anywhere in this executable file. 

  When this program was linked, the linker image id was stored in our image 
  header. So we will retreive this linker id and compare it to the image id 
  in the linker (SYS$SYSTEM:LINK.EXE). 

  If they're not the same, then abort.
*/
unsigned int check_vms_version ()
{
  unsigned int  status;

  struct  item_list_struct   jpi_item_list[2];
  struct  _iosb              jpi_iosb, qio_iosb;
  char                       image_name_buf[255];
  unsigned int               image_name_len;
  EIHD                       image_isd_buf, linker_isd_buf;
  EIHI                       *image_id_buf, *linker_id_buf;
  unsigned int               qio_chan;
  struct FAB                 image_fab, linker_fab;
  char                       *linker_file_spec = "SYS$SYSTEM:LINK.EXE";

/*
  Get the name of the executable program we are currently running.
*/
  jpi_item_list[0].buff = sizeof (image_name_buf);
  jpi_item_list[0].code = JPI$_IMAGNAME;
  jpi_item_list[0].addr = (char *) &image_name_buf;
  jpi_item_list[0].retl = (char *) &image_name_len;
  jpi_item_list[1].buff = NL;
  jpi_item_list[1].code = NL;

  if ((status = sys$getjpiw (0, 0, 0, &jpi_item_list, &jpi_iosb, 0, 0)) != SS$_NORMAL)
    return (status);
  if (jpi_iosb.iosb$w_status != SS$_NORMAL)
    return (status);

/*
  Read in the first block of this .exe file which has image information and should
  include the linker id.
*/
  image_fab = cc$rms_fab;
  image_fab.fab$l_fna = (char *) &image_name_buf;
  image_fab.fab$b_fns = image_name_len;
  image_fab.fab$v_ufo = 1;
  if ((status = sys$open (&image_fab, 0, 0)) != RMS$_NORMAL)
    return (status);

  qio_chan = image_fab.fab$l_stv;
  if ((status = sys$qiow (0, qio_chan, IO$_READVBLK, &qio_iosb, 0, 0, &image_isd_buf, 512, 1, 0, 0, 0)) != SS$_NORMAL)
    return (status);
  if (qio_iosb.iosb$w_status != SS$_NORMAL)
    return (status);
  if ((status = sys$dassgn (qio_chan)) != SS$_NORMAL)
    return (status);

/*
  Move to that part of the image header that has identity information.
*/
  image_id_buf = (EIHI *) ((char *) &image_isd_buf + image_isd_buf.eihd$l_imgidoff);
  
/*
  Read in the first block of the linker exe (SYS$SYSTEM:LINK.EXE) which has image information
  and should include the image id.
*/
  linker_fab = cc$rms_fab;
  linker_fab.fab$l_fna = linker_file_spec;
  linker_fab.fab$b_fns = strlen (linker_file_spec);
  linker_fab.fab$v_ufo = 1;
  if ((status = sys$open (&linker_fab, 0, 0)) != RMS$_NORMAL)
    return (status);

  qio_chan = linker_fab.fab$l_stv;
  if ((status = sys$qiow (0, qio_chan, IO$_READVBLK, &qio_iosb, 0, 0, &linker_isd_buf, 512, 1, 0, 0, 0)) != SS$_NORMAL)
    return (status);
  if (qio_iosb.iosb$w_status != SS$_NORMAL)
    return (status);
  if ((status = sys$dassgn (qio_chan)) != SS$_NORMAL)
    return (status);

/*
  Move to that part of the linker image header that has identity information.
*/
  linker_id_buf = (EIHI *) ((char *) &linker_isd_buf + linker_isd_buf.eihd$l_imgidoff);

/*
  Does the linker id in this program's image header match the image id in the linker program?
*/
  if (strcmp (image_id_buf->eihi$t_linkid, linker_id_buf->eihi$t_imgid) == 0)
    return (SS$_NORMAL);

/*
  Nope, abort.
*/
  printf ("VMS version mismatch?, image linker id = %*s\n", 
          image_id_buf->eihi$t_linkid, image_id_buf->eihi$t_linkid+1);
  printf ("                       linker image id = %*s\n", 
          linker_id_buf->eihi$t_imgid, linker_id_buf->eihi$t_imgid+1);
  sys$exit (SS$_ABORT);
  
}

/*
  The actual work happens here. We will loop through each ucb chain that is
  pointed to by a ddb that itself is in a chain, that is pointed to by a sb
  that itself is in a chain.
*/
unsigned int zero_errors ()
{
  void  nocrash ();

  lib$establish (nocrash);                       /* Try to mitigate unforeseen problems    */

  sch_std$iolockw ((struct _pcb *) CTL$GL_PCB);  /* Lock the I/O database for write access */
  iodb_locked = 1;                               /* and remember we locked it.             */

  sb = (struct _sb *) SCS$GQ_CONFIG;             /* Get the address of the first SB    */
  while (sb != (struct _sb *) &SCS$GQ_CONFIG)    /* End of sb chain?                   */
  { ddb = sb->sb$l_ddb;                          /* Nope, Get address of the first DDB */
    while (ddb != NL)                            /* End of ddb chain?                  */
    { ucb = ddb->ddb$ps_ucb;                     /* Nope, get address of first UCB     */
      while (ucb != NL)                          /* End of ucb chain?                  */
      { ucb->ucb$l_errcnt = 1;                   /* Nope, set the error count,         */
        ucb = ucb->ucb$l_link; }                 /* and get the next ucb address.      */
      ddb = ddb->ddb$ps_link; }                  /* Move to the next ddb.              */
    sb = sb->sb$l_flink; }                       /* Move to the next sb.               */

  sch_std$iounlock ((struct _pcb *) CTL$GL_PCB); /* All done, unlock the I/O database  */
  iodb_locked = 0;                               /* and remember we unlocked it.       */

  EXE$GL_MEMERRS  = 1;                           /* Set the memory error count.        */
  EXE$GL_MCHKERRS = 1;                           /* Set the cpu error count.           */

 return (SS$_NORMAL);
}

/*
  This routine will attempt to recover from any unforeseen bugs and maybe
  avoid a system crash.
*/
void nocrash ()
{
  void  graceful_exit ();
  unsigned int  status;

  if (iodb_locked) sch_std$iounlock ((struct _pcb *) CTL$GL_PCB); 
  setipl (0);
  EXE$REI_INIT_STACK (PSL$C_USER, graceful_exit);
  sys$exit (SS$_NORMAL);                         /* Should never get here.             */
}

/*
  This routine performs an exit from USER mode.
*/
void graceful_exit ()
{
  printf ("\n\n    *** Recovering from catastrophic error ***\n");
  printf (  "\n    *** System nearly crashed !!!          ***\n\n");
  sys$exit (SS$_NORMAL);
}
