 #ifdef VAXC   #module CHKPWD "BOL-V1.0/OCT-95" #else ' #pragma module CHKPWD "BOL-V1.0/OCT-95"  #endif  ? /* This routine validates a given password against the password 9    stored the UAF and against its expiration information.   ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   6 #include descrip    	/* Definitions for descriptors */0 #include lib$routines	/* LIB$xxx RTL routines */- #include libdef		/* LIB$_xxxx status codes */ 1 #include ssdef		/* SS$_xxx system status codes */ ; #include starlet	/* SYS$xxx() system service definitions */ ) #include string		/* strxxx() functions */ 4 #include uaidef		/* UAI$_xxx item codes and flags */  4 #include "chklgidef.h"	/* CHKLGI$_xxx definitions */@ #include "lgibufdef.h"  /* LGIBUF structure field definitions */9 #include "lgimsgdef.h"  /* LGI$_xxx login status codes */ 8 #include "compdepnd.h"	/* Compiler/platform depencies */  $ typedef struct dsc$descriptor_s dsc;   /* External routines */   ! int conlgi(struct LGIBUF*,char*);    /*  */    /*** CHKPWD() ***/ /*** ======== ***/   /* Input arguments:    <  pwd:  1-32 character, user-supplied password. By reference.  D  cnt:  Password selector (0=primary, 1=secondary password). By value  ;  tim:  Binary time used for expiration checks. By reference   C  lgi:  Login buffer containing additional information. By reference       Return codes:  & 	SS$_NORMAL:    password validation ok  * 	SS$_BADPARAM:  given password is too long  , 	LGI$_INVPWD:   given password doesn't match  ; 	LGI$_PWDEXPIR: password in UAF is marked as (pre-) expired   " 	Any other error code returned by:  & 	o - System Service: SYS$HASH_PASSWORD 	o - RTL Routine: LIB$ADD_TIMES  			   */  5 int chkpwd(char* paswd,		/* User-supplied password */ < 	   int  cnt,		/* 0 = primary password, 1 = sec. password */3 	   int* tim,		/* Time used for expiration check */ ? 	   struct LGIBUF* lgi)	/* Buffer containing UAF information */  {   int  status,			/* Return status */#  retpwd[2],			/* Hashed password */ "  restim[2];			/* Resultant time */     $DESCRIPTOR(usr,lgi->T_USRNAM);    $DESCRIPTOR(pwd,paswd);  :  /* Update descriptor length for username and password. */  *  usr.dsc$w_length = strlen(lgi->T_USRNAM);  "  pwd.dsc$w_length = strlen(paswd);  )  /* If a password was given, check it. */     if (paswd[0])  {6   /* Ensure that the given password isn't too long. */  C   if (pwd.dsc$w_length > UAI$C_MAX_PWD_LENGTH) return SS$_BADPARAM;   L   /* Validate user's password. Skip if the password isn't set in the UAF. */  /   if (lgi->Q_PWD[cnt][0] && lgi->Q_PWD[cnt][1])    {         /* Encrypt the password. */  R    status = sys$hash_password(&pwd,lgi->B_PWDENC[cnt],lgi->W_PWDSALT,&usr,retpwd);  +    if (status != SS$_NORMAL) return status;   K    /* Now compare hashed password from UAF with password given by the user. $       If they don't match, abort. */  J    if (lgi->Q_PWD[cnt][0] != retpwd[0] && lgi->Q_PWD[cnt][1] != retpwd[1])    {9     /* Copy the incorrect password for later auditing. */         strcpy(lgi->T_PASSWD,paswd);       /* and return. */        return LGI$_INVPWD;     }   }   }G  /* Ensure that the password isn't expired. If this is a system-console H     login, a detached login or the user has disabled password expiration:     checks, bypass these checks and return immediately. */  >  if (conlgi(lgi,lgi->T_USRNAM) || 		/* System-console login */>      lgi->L_LGISRC == CHKLGI$_DETACHED ||	/* Detached login */D      lgi->L_IFLAGS & CHKLGI$M_SKP_EXPPWD_CHK)	/* Disabled by user */  return SS$_NORMAL;   =  /* Now check the primary or secondary password, depending on       the given password selector.  ?     If the user attempted to login with its password expired or A     the password was marked as expired by the system manager with @     the AUTHORIZE utility, the UAI$M_PWDx_EXPIRED flags are set.?     If the password was marked as pre-expired, the flags aren't D     set, but the 'last modification time' in the UAF contains -1. */  /  if (!cnt)					/* Check for primary password */   {G   if (lgi->L_FLAGS & UAI$M_PWD_EXPIRED ||	/* If primary password exp */ 7      (lgi->Q_PWDDAT[0][0] == -1 &&		/* or was marked */ 7       lgi->Q_PWDDAT[0][1] == -1))		/* as pre-expired */   '   return LGI$_PWDEXPIR;				/* Abort. */   }&  else						/* Or secondary password */  {E   if (lgi->L_FLAGS & UAI$M_PWD2_EXPIRED ||	/* If sec. password exp */ 7      (lgi->Q_PWDDAT[1][0] == -1 &&		/* or was marked */ 7       lgi->Q_PWDDAT[1][1] == -1))		/* as pre-expired */   '   return LGI$_PWDEXPIR;				/* Abort. */   }<  /* Otherwise, we must perform the expiration check ourself:  B     o - add the expiration time to the time of the last pwd changeD     o - the resultant value must be greather than the given time. */  :  if (lgi->Q_PWDTIM[1])				/* Only if an expiration time */&  {						/* was specified in the UAF */B   status = lib$add_times(lgi->Q_PWDDAT[cnt],lgi->Q_PWDTIM,restim);  +   if (status != LIB$_NORMAL) return status;   0   /* Compare this time with the current time. */     if (restim[1] < tim[1] || 1      (restim[1] == tim[1] && restim[0] < tim[0]))      return LGI$_PWDEXPIR;   }  /* Everything OK. */     return SS$_NORMAL;  } 