 /* **++ **  FACILITY:	NETLIB **' **  ABSTRACT:	Routines specific to UCX.  ** **  MODULE DESCRIPTION:  ** **  	tbs ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  26-OCT-1994  ** **  MODIFICATION HISTORY:  **1 **  	26-OCT-1994 V1.0    Madison 	Initial coding. E **  	09-JAN-1995 V1.0-1  Madison 	Fix some missing args on some QIOs. C **  	19-JAN-1995 V1.0-2  Madison 	Handle 0-length writes specially. B **  	28-FEB-1995 V1.0-3  Madison 	Fix missing arg on $DCLAST call.A **  	24-JUL-1995 V1.0-4  Madison 	Fix netlib___get_nameservers(). < **  	13-OCT-1995 V1.0-5  Madison 	Free IORs on $QIO failure.D **  	11-FEB-1996 V1.0-6  Madison 	Fix argc check in netlib_shutdown.L **  	01-JUN-1997 V1.0-7  Madison 	Use a flag to indicate a timeout happened.C **  	10-JUN-1997 V1.0-8  Goatley 	Fix dumb netlib___cvt_status bug. J **  	12-MAR-1998 V1.0-9  Madison 	Work around TCPware address-to-name bug.? **  	12-DEC-1998 V1.0-10 Madison 	Missed one change for V1.0-9. ; **  	22-DEC-1998 V1.1    Madison 	Add support for UCX V5.0. M **  	29-DEC-1998 V1.1-1  Madison 	accept() did not use V5 name; make ordering ? **  	    	    	    	    	of V5/V4 checks consistent throughout.  **-- */ #ifdef TCPWARE
 #ifdef __DECC  #pragma module NETLIB_TCPWARE  #else  #module NETLIB_TCPWARE #endif #endif /* TCPWARE */ #include "netlib_ucx.h"  #include "netlib.h"  #include <lnmdef.h>  /*3 **  We don't actually do any cond_value conversions % **  because we're using the UCX ones.  */; #define netlib___cvt_status(_iosb) ((_iosb)->iosb_w_status) ( #define netlib___cvt_iosb(_dst, _src) {\8     	    (_dst)->iosb_w_status = (_src)->iosb_w_status;\7     	    (_dst)->iosb_w_count =  (_src)->iosb_w_count;\ $     	    (_dst)->iosb_l_unused = 0;} /*@ **  This is so we don't need UCX$IPC.OLB when we link with VAX C */
 #ifdef __DECC $ #define gethostname decc$gethostname #else $ #define gethostname vaxc$gethostname #endif   /* **  Forward declarations */E     unsigned int netlib_socket(struct CTX **xctx, unsigned int *type, *     	    	    	    	unsigned int *family);J     unsigned int netlib_server_setup(struct CTX **xctx, struct SINDEF *sa,)     	    	    	    	unsigned int *salen); B     unsigned int netlib_bind(struct CTX **xctx, struct SINDEF *sa,C     	    	    	    unsigned int *salen, struct NETLIBIOSBDEF *iosb, 3     	    	    	    void (*astadr)(), void *astprm); 7     static unsigned int io_completion(struct IOR *ior); H     unsigned int netlib_getsockname(struct CTX **ctx, struct SINDEF *sa,?     	    	    	    	 unsigned int *sasize, unsigned int *salen, 0     	    	    	    	 struct NETLIBIOSBDEF *iosb,5     	    	    	    	 void (*astadr)(), void *astprm); H     unsigned int netlib_getpeername(struct CTX **ctx, struct SINDEF *sa,?     	    	    	    	 unsigned int *sasize, unsigned int *salen, 0     	    	    	    	 struct NETLIBIOSBDEF *iosb,5     	    	    	    	 void (*astadr)(), void *astprm); D     unsigned int netlib_connect(struct CTX **ctx, struct SINDEF *sa,)     	    	    	    	 unsigned int *salen, 0     	    	    	    	 struct NETLIBIOSBDEF *iosb,5     	    	    	    	 void (*astadr)(), void *astprm); K     unsigned int netlib_write(struct CTX **ctx, struct dsc$descriptor *dsc, :     	    	    	    struct SINDEF *sa, unsigned int *salen,.     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); J     unsigned int netlib_read(struct CTX **ctx, struct dsc$descriptor *dsc,;     	    	    	    struct SINDEF *sa, unsigned int *sasize, 2     	    	    	    unsigned int *salen, TIME *tmo,.     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); 4     static unsigned int io_timeout(struct IOR *ior);K     unsigned int netlib_shutdown(struct CTX **xctx, unsigned int *shuttype, .     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); 1     unsigned int netlib_close(struct CTX **xctx); H     unsigned int netlib_listen(struct CTX **xctx, unsigned int *backlog,.     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); F     unsigned int netlib_accept(struct CTX **ctx, struct CTX **xnewctx,;     	    	    	    struct SINDEF *sa, unsigned int *sasize, C     	    	    	    unsigned int *salen, struct NETLIBIOSBDEF *iosb, 3     	    	    	    void (*astadr)(), void *astprm); 5     unsigned int netlib_setsockopt(struct CTX **xctx, =     	    	    	    unsigned int *level, unsigned int *option, 5     	    	    	    void *value, unsigned int *vallen, .     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); 5     unsigned int netlib_getsockopt(struct CTX **xctx, =     	    	    	    unsigned int *level, unsigned int *option, 6     	    	    	    void *value, unsigned int *valsize,(     	    	    	    unsigned int *vallen,.     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); P     unsigned int netlib_name_to_address(struct CTX **xctx, unsigned int *whichp,1     	    	    	    struct dsc$descriptor *namdsc, .     	    	    	    struct INADDRDEF *addrlist,?     	    	    	    unsigned int *listsize, unsigned int *count, .     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); P     unsigned int netlib_address_to_name(struct CTX **xctx, unsigned int *whichp,*     	    	    	    struct INADDRDEF *addr,*     	    	    	    unsigned int *addrsize,1     	    	    	    struct dsc$descriptor *namdsc, *     	    	    	    unsigned short *retlen,.     	    	    	    struct NETLIBIOSBDEF *iosb,3     	    	    	    void (*astadr)(), void *astprm); L     unsigned int netlib_get_hostname(void *bufdsc, unsigned short *retlenp);-     int netlib___get_nameservers(QUEUE *nsq); W     int netlib___get_domain(char *buf, unsigned short bufsize, unsigned short *retlen); 8     unsigned int netlib_dns_mx_lookup(struct CTX **xctx,B     	    	    struct dsc$descriptor *namdsc, struct MXRRDEF *mxrr,>     	    	    unsigned int *mxrrsize, unsigned int *mxrrcount,J     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm); #ifdef TCPWAREa     unsigned int netlib_addrtostr(struct INADDRDEF *, struct dsc$descriptor *, unsigned short *);  #endif /* TCPWARE */ /* **  OWN storage  */1     static $DESCRIPTOR(inetdevice, "UCX$DEVICE"); 6     static $DESCRIPTOR(inetdevice_v5, "TCPIP$DEVICE");:     static $DESCRIPTOR(nameserver_tabnam, "LNM$FILE_DEV");>     static unsigned int hostent_size = sizeof(struct HOSTENT); /* **  External references  */O     unsigned int netlib_strtoaddr(struct dsc$descriptor *, struct INADDRDEF *); !     int gethostname(void *, int); :     unsigned int netlib___dns_mx_lookup(struct CTX **xctx,B     	    	    struct dsc$descriptor *namdsc, struct MXRRDEF *mxrr,>     	    	    unsigned int *mxrrsize, unsigned int *mxrrcount,J     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm);   /* **++ **  ROUTINE:	netlib_socket ** **  FUNCTIONAL DESCRIPTION:  ** **  	Create a "socket".  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */B unsigned int netlib_socket (struct CTX **xctx, unsigned int *type,+     	    	    	    	unsigned int *family) {        struct CTX *ctx;      struct NETLIBIOSBDEF myiosb;     struct {     	unsigned short protocol;      	unsigned char  type;      	unsigned char  domain;      } sockdef;      unsigned int status, af, ty;
     int argc;        SETARGCOUNT(argc);  %     if (argc < 1) return SS$_INSFARG;   4     status = netlib___alloc_ctx(&ctx, SPECCTX_SIZE);#     if (!OK(status)) return status;   :     status = sys$assign(&inetdevice_v5, &ctx->chan, 0, 0);     if (!OK(status)) {8     	status = sys$assign(&inetdevice, &ctx->chan, 0, 0);     }      if (!OK(status)) {     	netlib___free_ctx(ctx);     	return status;      }   K     sockdef.type = (argc >= 2 && type != 0) ? *type : NETLIB_K_TYPE_STREAM; M     sockdef.domain = (argc >= 3 && family != 0) ? *family : NETLIB_K_AF_INET; H     sockdef.protocol = (sockdef.type == NETLIB_K_TYPE_DGRAM) ? UCX$C_UDP4     	    	    	    	    	    	    	     : UCX$C_TCP;  ?     status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SETMODE,      	    	    	&myiosb, 0, 0, (     	    	    	&sockdef, 0, 0, 0, 0, 0);:     if (OK(status)) status = netlib___cvt_status(&myiosb);       if (!OK(status)) {     	sys$dassgn(ctx->chan);h     	netlib___free_ctx(ctx);     	return status;*     }*       *xctx = ctx;     return SS$_NORMAL;   } /* netlib_socket */  * /* **++  **  ROUTINE:	netlib_server_setup ** **  FUNCTIONAL DESCRIPTION:a ** **  	Create a "server_setup".r **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.i ** **  COMPLETION CODES:e ** ** **  SIDE EFFECTS:   	None. ** **-- */G unsigned int netlib_server_setup (struct CTX **xctx, struct SINDEF *sa,i/     	    	    	    	    	unsigned int *salen) {t       struct CTX *ctx;      struct NETLIBIOSBDEF myiosb;     struct {     	unsigned short protocol;      	unsigned char  type;e     	unsigned char  domain;r     } sockdef;     unsigned int status;  *     static $DESCRIPTOR(device, "SYS$NET");  4     status = netlib___alloc_ctx(&ctx, SPECCTX_SIZE);#     if (!OK(status)) return status;S  3     status = sys$assign(&device, &ctx->chan, 0, 0);N     if (!OK(status)) {     	netlib___free_ctx(ctx);     	return status;Y     }T  !     sockdef.protocol = UCX$C_TCP;R(     sockdef.type = INET_PROTYP$C_STREAM;      sockdef.domain = UCX$C_AUXS;  ?     status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SETMODE,L     	    	    	&myiosb, 0, 0,I(     	    	    	&sockdef, 0, 0, 0, 0, 0);:     if (OK(status)) status = netlib___cvt_status(&myiosb);     if (!OK(status)) {     	sys$dassgn(ctx->chan);U     	netlib___free_ctx(ctx);     	return status;N     }C       *xctx = ctx;     return SS$_NORMAL;   } /* netlib_server_setup */I I /* **++ **  ROUTINE:	netlib_bind ** **  FUNCTIONAL DESCRIPTION:H ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.d ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */? unsigned int netlib_bind (struct CTX **xctx, struct SINDEF *sa,sC     	    	    	    unsigned int *salen, struct NETLIBIOSBDEF *iosb,n4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;     unsigned int status;     ITMLST2 sockdsc;
     int argc;c      static unsigned int one = 1;       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 3) return SS$_INSFARG;G3     if (sa == 0 || salen == 0) return SS$_BADPARAM;A<     if (*salen < sizeof(struct SINDEF)) return SS$_BADPARAM;  3     if (!(ctx->flags & CTX_M_USER_SET_REUSEADDR)) {      	ITMLST2 rulst, sockopt;C     	ITMLST2_INIT(rulst, UCX$C_SOCKOPT, sizeof(sockopt), &sockopt); I     	ITMLST2_INIT(sockopt, NETLIB_K_OPTION_REUSEADDR, sizeof(one), &one);	@     	sys$qiow(netlib_synch_efn, ctx->chan, IO$_SETMODE, 0, 0, 0,%     	    	    0, 0, 0, 0, &rulst, 0);T     }W  )     ITMLST2_INIT(sockdsc, 0, *salen, sa);   "     if (argc > 4 && astadr != 0) {     	struct IOR *ior;l>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 5) ? astprm : 0);L     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_SETMODE, &ior->iosb,@     	    	    	    io_completion, ior, 0, 0, &sockdsc, 0, 0, 0);$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb; I     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SETMODE, &myiosb,s2     	    	    	    0, 0, 0, 0, &sockdsc, 0, 0, 0);;     	if (OK(status)) status = netlib___cvt_status(&myiosb);nA     	if (argc > 3 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);t     }e       return status;   } /* netlib_bind */    /* **++ **  ROUTINE:	io_completion ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.i ** **  COMPLETION CODES:t ** ** **  SIDE EFFECTS:   	None. ** **-- */5 static unsigned int io_completion (struct IOR *ior) {i       struct CTX *ctx = ior->ctx;   (     ior->iorflags |= IOR_M_IO_COMPLETED;  ;     if (ior->iorflags & IOR_M_IO_TIMED) sys$cantim(ior, 0);   T     if (ior->iosb.iosb_w_status == SS$_CANCEL && (ior->iorflags & IOR_M_IO_TIMEOUT))+     	ior->iosb.iosb_w_status = SS$_TIMEOUT;,  C     if (ior->iosbp != 0) netlib___cvt_iosb(ior->iosbp, &ior->iosb);i    ,     if (ior->iorflags & IOR_M_COPY_LENGTH) {>     	if (OK(ior->iosb.iosb_w_status) && ior->spec_retlen != 0)@     	    	*(unsigned int *) ior->spec_retlen = ior->spec_length;)     	ior->iorflags &= ~IOR_M_COPY_LENGTH;t     }   *     if (ior->iorflags & IOR_M_COPY_FROM) {B     	if (OK(ior->iosb.iosb_w_status) && ior->spec_userfrom != 0) {     	    unsigned int len;$     	    len = ior->specior.fromlen;<     	    if (len > ior->spec_length) len = ior->spec_length;=     	    memcpy(ior->spec_userfrom, &ior->specior.from, len); L     	    if (ior->spec_retlen != 0) *(unsigned int *)ior->spec_retlen = len;     	 }B(     	 ior->iorflags &= ~IOR_M_COPY_FROM;     }v  +     if (ior->iorflags & IOR_M_COPY_ADDRS) {r     	struct HOSTENT *h;$       	h = ior->spec_hostent; '     	if (OK(ior->iosb.iosb_w_status)) {i     	    char *base;     	    unsigned int *offlst;     	    int i;      	    base = (char *) h;s     	    i = 0; '     	    if (h->addrlist_offset != 0) { 8     	    	struct INADDRDEF *alist = ior->spec_useralist;>     	    	offlst = (unsigned int *) (base+h->addrlist_offset);:     	    	while (i < ior->spec_length && offlst[i] != 0) {B     	    	    alist[i] = *(struct INADDRDEF *) (base + offlst[i]);     	    	    i++;     	    	} 
     	    }J     	    if (ior->spec_retlen != 0) *(unsigned int *)ior->spec_retlen = i;     	}$     	lib$free_vm(&hostent_size, &h);(     	ior->iorflags &= ~IOR_M_COPY_ADDRS;     }i  .     if (ior->iorflags & IOR_M_COPY_HOSTNAME) {     	struct HOSTENT *h;      	h = ior->spec_hostent;i'     	if (OK(ior->iosb.iosb_w_status)) {s<     	    str$copy_r(ior->spec_usrdsc, &ior->specior.fromlen,$     	    	    	    	    	h->buffer);#     	    if (ior->spec_retlen != 0)s/     	    	*(unsigned short *)ior->spec_retlen =n3     	    	    	    	    	    	ior->specior.fromlen;v     	}$     	lib$free_vm(&hostent_size, &h);+     	ior->iorflags &= ~IOR_M_COPY_HOSTNAME;      }   ,     if (ior->iorflags & IOR_M_NEW_CONTEXT) {'     	if (OK(ior->iosb.iosb_w_status)) {x?     	    *(struct CTX **) ior->spec_xnewctx = ior->spec_newctx; 
     	} else { <     	    sys$dassgn(((struct CTX *)ior->spec_newctx)->chan);<     	    netlib___free_ctx((struct CTX *) ior->spec_newctx);     	},     	   ior->iorflags &= ~IOR_M_NEW_CONTEXT;     }   8     if (ior->astadr != 0) (*(ior->astadr))(ior->astprm);       FREE_IOR(ior);       return SS$_NORMAL;   } /* io_completion */    /* **++ **  ROUTINE:	netlib_getsockname  ** **  FUNCTIONAL DESCRIPTION:l ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.* ** **  COMPLETION CODES:, ** ** **  SIDE EFFECTS:   	None. ** **-- */F unsigned int netlib_getsockname (struct CTX **xctx, struct SINDEF *sa,?     	    	    	    	 unsigned int *sasize, unsigned int *salen, 0     	    	    	    	 struct NETLIBIOSBDEF *iosb,6     	    	    	    	 void (*astadr)(), void *astprm) {     struct CTX *ctx;     unsigned int status;     ITMLST slst;
     int argc;e       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  4     if (sa == 0 || sasize == 0) return SS$_BADPARAM;  "     if (argc > 5 && astadr != 0) {     	struct IOR *ior;t>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 6) ? astprm : 0);:     	ITMLST_INIT(slst, 0, *sasize, sa, &ior->spec_length);     	ior->spec_retlen = salen;'     	ior->iorflags = IOR_M_COPY_LENGTH;tN     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_SENSEMODE, &ior->iosb,=     	    	    	    io_completion, ior, 0, 0, &slst, 0, 0, 0);d$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb;I     	unsigned short length;R0     	ITMLST_INIT(slst, 0, *sasize, sa, &length);B     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SENSEMODE,     	    	    	    &myiosb,H/     	    	    	    0, 0, 0, 0, &slst, 0, 0, 0);n1     	if (argc > 3 && salen != 0) *salen = length;,;     	if (OK(status)) status = netlib___cvt_status(&myiosb); A     	if (argc > 4 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);	     }u       return status;   } /* netlib_getsockname */   /* **++ **  ROUTINE:	netlib_getpeernamet ** **  FUNCTIONAL DESCRIPTION:t ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.a ** **  COMPLETION CODES:r ** ** **  SIDE EFFECTS:   	None. ** **-- */F unsigned int netlib_getpeername (struct CTX **xctx, struct SINDEF *sa,?     	    	    	    	 unsigned int *sasize, unsigned int *salen, 0     	    	    	    	 struct NETLIBIOSBDEF *iosb,6     	    	    	    	 void (*astadr)(), void *astprm) {     struct CTX *ctx;     ITMLST slst;     unsigned int status;
     int argc;t       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 3) return SS$_INSFARG; 4     if (sa == 0 || sasize == 0) return SS$_BADPARAM;  "     if (argc > 5 && astadr != 0) {     	struct IOR *ior;e>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 6) ? astprm : 0);:     	ITMLST_INIT(slst, 0, *sasize, sa, &ior->spec_length);      	ior->spec_length = *sasize;     	ior->spec_retlen = salen;'     	ior->iorflags = IOR_M_COPY_LENGTH;eN     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_SENSEMODE, &ior->iosb,=     	    	    	    io_completion, ior, 0, 0, 0, &slst, 0, 0);c$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb;&     	unsigned short length;L0     	ITMLST_INIT(slst, 0, *sasize, sa, &length);B     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SENSEMODE,8     	    	    	    &myiosb, 0, 0, 0, 0, 0, &slst, 0, 0);1     	if (argc > 3 && salen != 0) *salen = length;&;     	if (OK(status)) status = netlib___cvt_status(&myiosb); A     	if (argc > 4 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);O     }s       return status;   } /* netlib_getpeername */ c /* **++ **  ROUTINE:	netlib_connect  ** **  FUNCTIONAL DESCRIPTION:$ ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.n ** **  COMPLETION CODES:y ** ** **  SIDE EFFECTS:   	None. ** **-- */B unsigned int netlib_connect (struct CTX **xctx, struct SINDEF *sa,)     	    	    	    	 unsigned int *salen,C0     	    	    	    	 struct NETLIBIOSBDEF *iosb,6     	    	    	    	 void (*astadr)(), void *astprm) {     struct CTX *ctx;     unsigned int status;     ITMLST2 sname;
     int argc;T       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  3     if (sa == 0 || salen == 0) return SS$_BADPARAM;h<     if (*salen < sizeof(struct SINDEF)) return SS$_BADPARAM;  '     ITMLST2_INIT(sname, 0, *salen, sa);   $     if (argc > 4 && astadr != 0) {       	struct IOR *ior;(>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 5) ? astprm : 0);K     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_ACCESS, &ior->iosb,r>     	    	    	    io_completion, ior, 0, 0, &sname, 0, 0, 0);$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb;=H     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_ACCESS, &myiosb,0     	    	    	    0, 0, 0, 0, &sname, 0, 0, 0);;     	if (OK(status)) status = netlib___cvt_status(&myiosb);;A     	if (argc > 3 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);_     }c       return status;   } /* netlib_connect */   /* **++ **  ROUTINE:	netlib_write* ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:n ** ** **  SIDE EFFECTS:   	None. ** **-- */I unsigned int netlib_write (struct CTX **xctx, struct dsc$descriptor *dsc,i:     	    	    	    struct SINDEF *sa, unsigned int *salen,.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {     struct CTX *ctx;     void *bufptr;      unsigned int status;     unsigned short buflen;     ITMLST2 sname, *snaddr; 
     int argc;        VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  6     status = lib$analyze_sdesc(dsc, &buflen, &bufptr);#     if (!OK(status)) return status;   !     if (argc > 3 && salen != 0) { (     	ITMLST2_INIT(sname, 0, *salen, sa);     	snaddr = &sname;S     } else snaddr = 0;  "     if (argc > 5 && astadr != 0) {     	struct IOR *ior;e>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 6) ? astprm : 0);     	if (buflen == 0) {e.     	    ior->iosb.iosb_w_status = SS$_NORMAL;$     	    ior->iosb.iosb_w_count = 0;%     	    ior->iosb.iosb_l_unused = 0; 4     	    status = sys$dclast(io_completion, ior, 0);
     	} else {sF     	    status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_WRITEVBLK,     	    	    	    &ior->iosb,>     	    	    	    io_completion, ior, bufptr, buflen, snaddr,     	    	    	    0, 0, 0);(     	    if (!OK(status)) FREE_IOR(ior);     	}     } else {!     	struct NETLIBIOSBDEF myiosb;      	if (buflen == 0) { 4     	    status = myiosb.iosb_w_status = SS$_NORMAL;!     	    myiosb.iosb_w_count = 0; "     	    myiosb.iosb_l_unused = 0;
     	} else { F     	    status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_WRITEVBLK,9     	    	    	    &myiosb, 0, 0, bufptr, buflen, snaddr,e     	    	    	    0, 0, 0);?     	    if (OK(status)) status = netlib___cvt_status(&myiosb);*     	}A     	if (argc > 4 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);w     }s       return status;   } /* netlib_write */   /* **++ **  ROUTINE:	netlib_read ** **  FUNCTIONAL DESCRIPTION:S ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:O ** ** **  SIDE EFFECTS:   	None. ** **-- */H unsigned int netlib_read (struct CTX **xctx, struct dsc$descriptor *dsc,;     	    	    	    struct SINDEF *sa, unsigned int *sasize,t6     	    	    	    unsigned int *salen, TIME *timeout,.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {     struct CTX *ctx;     struct IOR *ior;     unsigned int status;     ITMLST sname;e     int argc, do_from;       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  E     if (dsc->dsc$b_dtype != DSC$K_DTYPE_T && dsc->dsc$b_dtype != 0) {w     	return SS$_BADPARAM;r     })  E     if (dsc->dsc$b_class != DSC$K_CLASS_S && dsc->dsc$b_class != 0) {      	return SS$_BADPARAM;n     }n  C     do_from = (argc > 3 && sa != 0 && sasize != 0 && *sasize != 0);."     if (argc > 7 && astadr != 0) {     	struct IOR *ior;d>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 8) ? astprm : 0);>     	if (do_from) ITMLST_INIT(sname, 0, sizeof(struct SINDEF),9     	    	    &ior->specior.from, &ior->specior.fromlen);h     	if (do_from) {(!     	    ior->spec_userfrom = sa; $     	    ior->spec_length = *sasize;"     	    ior->spec_retlen = salen;)     	    ior->iorflags = IOR_M_COPY_FROM;      	} else ior->iorflags = 0;     	if (timeout != 0) {)     	    ior->iorflags |= IOR_M_IO_TIMED; J     	    status = sys$setimr(netlib_asynch_efn, timeout, io_timeout, ior);     	    if (!OK(status)) {[     	    	FREE_IOR(ior);     	    	return status;
     	    }     	}  M     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_READVBLK, &ior->iosb,e:     	    	    	    io_completion, ior, dsc->dsc$a_pointer,E     	    	    	    dsc->dsc$w_length, do_from ? &sname : 0, 0, 0, 0);R     	if (!OK(status)) {-.     	    if (timeout != 0) sys$cantim(ior, 0);     	    FREE_IOR(ior);r     	}     } else {!     	struct NETLIBIOSBDEF myiosb;s     	struct SINDEF from;     	unsigned short fromlen;     	int timed_out;   >     	if (do_from) ITMLST_INIT(sname, 0, sizeof(struct SINDEF),     	    	    &from, &fromlen);c       	timed_out = 0; $     	if (argc > 5 && timeout != 0) {$     	    GET_IOR(ior, ctx, 0, 0, 0);(     	    ior->iorflags = IOR_M_IO_TIMED;J     	    status = sys$setimr(netlib_asynch_efn, timeout, io_timeout, ior);     	    if (!OK(status)) {u     	    	FREE_IOR(ior);     	    	return status;
     	    }     	}A     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_READVBLK,t!     	    	    	    &myiosb, 0, 0,c9     	    	    	    dsc->dsc$a_pointer, dsc->dsc$w_length,i2     	    	    	    do_from ? &sname : 0, 0, 0, 0);$     	if (argc > 5 && timeout != 0) {     	    sys$cantim(ior, 0);6     	    timed_out = ior->iorflags & IOR_M_IO_TIMEOUT;     	    FREE_IOR(ior);n     	}     	if (OK(status)) {=     	    if (timed_out && myiosb.iosb_w_status == SS$_CANCEL),-     	    	myiosb.iosb_w_status = SS$_TIMEOUT; /     	    status = netlib___cvt_status(&myiosb);P     	}A     	if (argc > 6 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);*!     	if (OK(status) && do_from) {*     	    unsigned int len;     	    len = fromlen;T*     	    if (len > *sasize) len = *sasize;      	    memcpy(sa, &from, len);2     	    if (argc > 4 && salen != 0) *salen = len;     	}     }        return status;   } /* netlib_read */a r /* **++ **  ROUTINE:	io_timeouti ** **  FUNCTIONAL DESCRIPTION:; ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:i ** ** **  SIDE EFFECTS:   	None. ** **-- */2 static unsigned int io_timeout (struct IOR *ior) {  >     if (ior->iorflags & IOR_M_IO_COMPLETED) return SS$_NORMAL;&     ior->iorflags |= IOR_M_IO_TIMEOUT;&     return sys$cancel(ior->ctx->chan);   } /* io_timeout */ i /* **++ **  ROUTINE:	netlib_shutdown ** **  FUNCTIONAL DESCRIPTION:R ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.h ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */H unsigned int netlib_shutdown (struct CTX **xctx, unsigned int *shuttype,.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;     unsigned int status;
     int argc;n       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  "     if (argc > 3 && astadr != 0) {     	struct IOR *ior;s>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 4) ? astprm : 0);O     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_DEACCESS|IO$M_SHUTDOWN,*<     	    	    	    &ior->iosb, io_completion, ior, 0, 0, 0, :     	    	    	    (shuttype == 0) ? 0 : *shuttype, 0, 0);$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb;n3     	status = sys$qiow(netlib_synch_efn, ctx->chan,	7     	    	    	    IO$_DEACCESS|IO$M_SHUTDOWN, &myiosb,*!     	    	    	    0, 0, 0, 0, 0,uF     	    	    	    (argc > 1 && shuttype != 0) ? *shuttype : 0, 0, 0);;     	if (OK(status)) status = netlib___cvt_status(&myiosb); A     	if (argc > 2 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);      }S       return status;   } /* netlib_shutdown */{   /* **++ **  ROUTINE:	netlib_closer ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:y ** ** **  SIDE EFFECTS:   	None. ** **-- *// unsigned int netlib_close (struct CTX **xctx) {s       struct CTX *ctx;     unsigned int status;       VERIFY_CTX(xctx, ctx);  #     status = sys$dassgn(ctx->chan); #     if (!OK(status)) return status;s       netlib___free_ctx(ctx);u       *xctx = 0;       return SS$_NORMAL;   } /* netlib_close */   /* **++ **  ROUTINE:	netlib_listen ** **  FUNCTIONAL DESCRIPTION:! ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */E unsigned int netlib_listen (struct CTX **xctx, unsigned int *backlog,l.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;     unsigned int status;
     int argc;y       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  "     if (argc > 3 && astadr != 0) {     	struct IOR *ior;s>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 5) ? astprm : 0);L     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_SETMODE, &ior->iosb,0     	    	    	    io_completion, ior, 0, 0, 0, 8     	    	    	    (backlog == 0) ? 4 : *backlog, 0, 0);$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb;AI     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SETMODE, &myiosb, !     	    	    	    0, 0, 0, 0, 0,)D     	    	    	    (argc > 1 && backlog != 0) ? *backlog : 4, 0, 0);;     	if (OK(status)) status = netlib___cvt_status(&myiosb); A     	if (argc > 2 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);r     }r       return status;   } /* netlib_listen */& m /* **++ **  ROUTINE:	netlib_accept ** **  FUNCTIONAL DESCRIPTION:s ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.e ** **  COMPLETION CODES:; ** ** **  SIDE EFFECTS:   	None. ** **-- */D unsigned int netlib_accept (struct CTX **xctx, struct CTX **xnewctx,;     	    	    	    struct SINDEF *sa, unsigned int *sasize,IC     	    	    	    unsigned int *salen, struct NETLIBIOSBDEF *iosb,r4     	    	    	    void (*astadr)(), void *astprm) {     struct CTX *ctx, *newctx;T     ITMLST sname;      unsigned int status;
     int argc;P       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 2) return SS$_INSFARG;r*     if (xnewctx == 0) return SS$_BADPARAM;7     status = netlib___alloc_ctx(&newctx, SPECCTX_SIZE);e#     if (!OK(status)) return status;O  =     status = sys$assign(&inetdevice_v5, &newctx->chan, 0, 0);{     if (!OK(status)) {;     	status = sys$assign(&inetdevice, &newctx->chan, 0, 0);o     }e     if (!OK(status)) {     	netlib___free_ctx(newctx);E     	return status;      }A  "     if (argc > 6 && astadr != 0) {     	struct IOR *ior;,>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 7) ? astprm : 0);1     	ior->spec_userfrom = (sasize == 0) ? 0 : sa; 4     	ior->spec_length = (sasize == 0) ? 0 : *sasize;     	ior->spec_retlen = salen;!     	ior->spec_xnewctx = xnewctx;e     	ior->spec_newctx = newctx;t1     	ITMLST_INIT(sname, 0, sizeof(struct SINDEF),05     	    	&ior->specior.from, &ior->specior.fromlen); 7     	ior->iorflags = IOR_M_COPY_FROM|IOR_M_NEW_CONTEXT;sK     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_ACCESS|IO$M_ACCEPT,}2     	    	    	    &ior->iosb, io_completion, ior,6     	    	    	    0, 0, &sname, &newctx->chan, 0, 0);$     	if (!OK(status)) FREE_IOR(ior);     } else {     	struct SINDEF from;!     	struct NETLIBIOSBDEF myiosb;!     	unsigned short fromlen;  1     	ITMLST_INIT(sname, 0, sizeof(struct SINDEF),      	    	&from, &fromlen); K     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_ACCESS|IO$M_ACCEPT,u'     	    	    	    &myiosb, 0, 0, 0, 0, 0     	    	    	    &sname, &newctx->chan, 0, 0);;     	if (OK(status)) status = netlib___cvt_status(&myiosb);&A     	if (argc > 5 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);;     	if (OK(status)) {     	    *xnewctx = newctx;u2     	    if (argc > 3 && sa != 0 && sasize != 0) {     	    	unsigned int len;i     	    	len = fromlen;+     	    	if (len > *sasize) len = *sasize;*!     	    	memcpy(sa, &from, len);*3     	    	if (argc > 4 && salen != 0) *salen = len;U
     	    }     	}     }u       return status;   } /* netlib_accept */P   /* **++ **  ROUTINE:	netlib_setsockopt ** **  FUNCTIONAL DESCRIPTION:e ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.D ** **  COMPLETION CODES:e ** ** **  SIDE EFFECTS:   	None. ** **-- */2 unsigned int netlib_setsockopt (struct CTX **xctx,=     	    	    	    unsigned int *level, unsigned int *option, 5     	    	    	    void *value, unsigned int *vallen,t.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;     unsigned int status, lev;c     ITMLST2 optdsc;w
     int argc;S       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 5) return SS$_INSFARG; F     if (option == 0 || value == 0 || vallen == 0) return SS$_BADPARAM;0     if (level == 0) lev = NETLIB_K_LEVEL_SOCKET;     else lev = *level;  O     if (lev == NETLIB_K_LEVEL_SOCKET && *option == NETLIB_K_OPTION_REUSEADDR) {;,     	ctx->flags |= CTX_M_USER_SET_REUSEADDR;     }c  "     if (argc > 6 && astadr != 0) {     	struct IOR *ior;r>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 7) ? astprm : 0);A     	ITMLST2_INIT(ior->specior.sockopt, *option, *vallen, value);      	ITMLST2_INIT(optdsc,f>     	    (lev == NETLIB_K_LEVEL_SOCKET) ? UCX$C_SOCKOPT : lev,>     	    sizeof(ior->specior.sockopt), &ior->specior.sockopt);L     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_SETMODE, &ior->iosb,?     	    	    	    io_completion, ior, 0, 0, 0, 0, &optdsc, 0);e$     	if (!OK(status)) FREE_IOR(ior);     } else {!     	struct NETLIBIOSBDEF myiosb;      	ITMLST2 sockopt;b4     	ITMLST2_INIT(sockopt, *option, *vallen, value);     	ITMLST2_INIT(optdsc, >     	    (lev == NETLIB_K_LEVEL_SOCKET) ? UCX$C_SOCKOPT : lev,$     	    sizeof(sockopt), &sockopt);@     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SETMODE,:     	    	    	    &myiosb, 0, 0, 0, 0, 0, 0, &optdsc, 0);;     	if (OK(status)) status = netlib___cvt_status(&myiosb); A     	if (argc > 5 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);      }	       return status;   } /* netlib_setsockopt */    /* **++ **  ROUTINE:	netlib_getsockopt ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.a ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */2 unsigned int netlib_getsockopt (struct CTX **xctx,=     	    	    	    unsigned int *level, unsigned int *option, 6     	    	    	    void *value, unsigned int *valsize,(     	    	    	    unsigned int *vallen,.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;     unsigned int status, lev;      ITMLST2 optdsc;=
     int argc;        VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 5) return SS$_INSFARG;PG     if (option == 0 || value == 0 || valsize == 0) return SS$_BADPARAM;)0     if (level == 0) lev = NETLIB_K_LEVEL_SOCKET;     else lev = *level;    "     if (argc > 7 && astadr != 0) {     	struct IOR *ior; >     	GET_IOR(ior, ctx, iosb, astadr, (argc > 8) ? astprm : 0);=     	ITMLST_INIT(ior->specior.sockopt_get, *option, *valsize, )     	    	    	value, &ior->spec_length);N     	ITMLST2_INIT(optdsc,C>     	    (lev == NETLIB_K_LEVEL_SOCKET) ? UCX$C_SOCKOPT : lev,F     	    sizeof(ior->specior.sockopt_get), &ior->specior.sockopt_get);     	ior->spec_retlen = vallen;n'     	ior->iorflags = IOR_M_COPY_LENGTH; N     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_SENSEMODE, &ior->iosb,?     	    	    	    io_completion, ior, 0, 0, 0, 0, 0, &optdsc);l$     	if (!OK(status)) FREE_IOR(ior);     } else {     	ITMLST sockopt_get;!     	struct NETLIBIOSBDEF myiosb;c     	unsigned short length;   A     	ITMLST_INIT(sockopt_get, *option, *valsize, value, &length);S     	ITMLST2_INIT(optdsc,*>     	    (lev == NETLIB_K_LEVEL_SOCKET) ? UCX$C_SOCKOPT : lev,,     	    sizeof(sockopt_get), &sockopt_get);B     	status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_SENSEMODE,:     	    	    	    &myiosb, 0, 0, 0, 0, 0, 0, 0, &optdsc);;     	if (OK(status)) status = netlib___cvt_status(&myiosb);sA     	if (argc > 6 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);,A     	if (OK(status) && argc > 5 && vallen != 0) *vallen = length;t     }t       return status;   } /* netlib_getsockopt */  I /* **++# **  ROUTINE:	netlib_name_to_address  ** **  FUNCTIONAL DESCRIPTION:  **B **  	Uses the UCX IO$_ACPCONTROL $QIO function to translate a host' **  name into one or more IP addresses.l **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **h **  	NETLIB_NAME_TO_ADDRESS  ctx, which, namdsc, addrlist, listsize [,count] [,iosb] [,astadr] [,astprm] ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:_ ** ** **  SIDE EFFECTS:   	None. ** **-- */M unsigned int netlib_name_to_address (struct CTX **xctx, unsigned int *whichp, 1     	    	    	    struct dsc$descriptor *namdsc, .     	    	    	    struct INADDRDEF *addrlist,?     	    	    	    unsigned int *listsize, unsigned int *count,t.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;     struct INADDRDEF addr;      struct NETLIBIOSBDEF myiosb;     struct HOSTENT hostent;e%     unsigned int status, subfunction;T     ITMLST2 subfdsc;     ITMLST2 entdsc;:     unsigned short helen;T
     int argc;*       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 5) return SS$_INSFARG;_  K     if (namdsc == 0 || addrlist == 0 || listsize == 0) return SS$_BADPARAM;   .     if (OK(netlib_strtoaddr(namdsc, &addr))) {     	addrlist[0] = addr;,     	if (argc > 5 && count != 0) *count = 1;!     	if (argc > 6 && iosb != 0) { *     	    iosb->iosb_w_status = SS$_NORMAL;      	    iosb->iosb_w_count = 1;!     	    iosb->iosb_l_unused = 0;S     	}#     	if (argc > 7 && astadr != 0) {n?     	    return sys$dclast(astadr, (argc > 8) ? astprm : 0, 0);T
     	} else {t     	    return SS$_NORMAL;N     	}     }M  "     if (argc > 7 && astadr != 0) {     	struct IOR *ior;*>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 8) ? astprm : 0);<     	status = lib$get_vm(&hostent_size, &ior->spec_hostent);     	if (!OK(status)) {      	    FREE_IOR(ior);      	    return status;a     	}     	ior->specior.subfunction =iH     	    (INETACP$C_HOSTENT_OFFSET << 8) | INETACP_FUNC$C_GETHOSTBYNAME;  ?     	ITMLST2_INIT(subfdsc, 0, sizeof(ior->specior.subfunction), )     	    	    &ior->specior.subfunction);,>     	ITMLST2_INIT(entdsc, 0, hostent_size, ior->spec_hostent);     	x$     	ior->spec_useralist = addrlist;"     	ior->spec_length = *listsize;     	ior->spec_retlen = count;&     	ior->iorflags = IOR_M_COPY_ADDRS;O     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_ACPCONTROL, &ior->iosb,A8     	    	    	    io_completion, ior, &subfdsc, namdsc,9     	    	    	    &ior->specior.fromlen, &entdsc, 0, 0); $     	if (!OK(status)) FREE_IOR(ior);     	return status;,     }        subfunction =aH     	    (INETACP$C_HOSTENT_OFFSET << 8) | INETACP_FUNC$C_GETHOSTBYNAME;  @     ITMLST2_INIT(subfdsc, 0, sizeof(subfunction), &subfunction);4     ITMLST2_INIT(entdsc, 0, hostent_size, &hostent);K     status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_ACPCONTROL, &myiosb,_>     	    	    	0, 0, &subfdsc, namdsc, &helen, &entdsc, 0, 0);:     if (OK(status)) status = netlib___cvt_status(&myiosb);@     if (argc > 6 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);     if (OK(status)) {      	char *base;     	unsigned int *offlst;     	int i;,     	base = (char *) &hostent;     	i = 0;r(     	if (hostent.addrlist_offset != 0) {B     	    offlst = (unsigned int *) (base+hostent.addrlist_offset);2     	    while (i < *listsize && offlst[i] != 0) {A     	    	addrlist[i] = *(struct INADDRDEF *) (base + offlst[i]);i     	    	i++;
     	    }     	},     	if (argc > 5 && count != 0) *count = i;     }f       return status;      } /* netlib_name_to_address */ S /* **++# **  ROUTINE:	netlib_address_to_namen ** **  FUNCTIONAL DESCRIPTION:O **> **  	Uses the UCX IO$_ACPCONTROL $QIO function to translate an  **  IP address into a host name. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **e **  	NETLIB_ADDRESS_TO_NAME  ctx, which, addr, addrsize, namdsc [,retlen] [,iosb] [,astadr] [,astprm]a ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.a ** **  COMPLETION CODES:: ** ** **  SIDE EFFECTS:   	None. ** **-- */M unsigned int netlib_address_to_name (struct CTX **xctx, unsigned int *whichp,t*     	    	    	    struct INADDRDEF *addr,*     	    	    	    unsigned int *addrsize,1     	    	    	    struct dsc$descriptor *namdsc, *     	    	    	    unsigned short *retlen,.     	    	    	    struct NETLIBIOSBDEF *iosb,4     	    	    	    void (*astadr)(), void *astprm) {       struct CTX *ctx;      struct NETLIBIOSBDEF myiosb;$     ITMLST2 subfdsc, entdsc, adrdsc;%     unsigned int status, subfunction;>     char buf[1024];  #ifdef TCPWARE     char tmp[64]; !     struct dsc$descriptor tmpdsc;  #endif /* TCPWARE */     unsigned short length;
     int argc;        VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 5) return SS$_INSFARG;   G     if (addr == 0 || addrsize == 0 || namdsc == 0) return SS$_BADPARAM; C     if (*addrsize != sizeof(struct INADDRDEF)) return SS$_BADPARAM;n   #ifdef TCPWARE*     INIT_SDESC (tmpdsc, sizeof(tmp), tmp);C     status = netlib_addrtostr(addr, &tmpdsc, &tmpdsc.dsc$w_length);i#     if (!OK(status)) return status;  #elsew-     ITMLST2_INIT(adrdsc, 0, *addrsize, addr);0 #endif /* TCPWARE */"     if (argc > 7 && astadr != 0) {     	struct IOR *ior;      	struct HOSTENT *h;n>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 8) ? astprm : 0);,     	status = lib$get_vm(&hostent_size, &h);     	if (!OK(status)) {      	    FREE_IOR(ior);n     	    return status;      	}     	ior->spec_usrdsc = namdsc;      	ior->spec_retlen = retlen;      	ior->specior.subfunction =a #ifndef TCPWAREs!     	    (INETACP$C_TRANS << 8) |* #endif /* not TCPWARE */&     	    INETACP_FUNC$C_GETHOSTBYADDR;  ?     	ITMLST2_INIT(subfdsc, 0, sizeof(ior->specior.subfunction), .     	    	    	    &ior->specior.subfunction);;     	ITMLST2_INIT(entdsc, 0, sizeof(h->buffer), h->buffer);u     	ior->spec_hostent = h;i)     	ior->iorflags = IOR_M_COPY_HOSTNAME;eO     	status = sys$qio(netlib_asynch_efn, ctx->chan, IO$_ACPCONTROL, &ior->iosb, 0     	    	    	    io_completion, ior, &subfdsc, #ifdef TCPWARE     	    	    	    &tmpdsc,l #else      	    	    	    &adrdsc,r #endif /* TCPWARE */9     	    	    	    &ior->specior.fromlen, &entdsc, 0, 0);e$     	if (!OK(status)) FREE_IOR(ior);     	return status;l     }0       subfunction =; #ifndef TCPWARE=$     	    	  (INETACP$C_TRANS << 8) | #endif)     	    	  INETACP_FUNC$C_GETHOSTBYADDR;_  @     ITMLST2_INIT(subfdsc, 0, sizeof(subfunction), &subfunction);.     ITMLST2_INIT(entdsc, 0, sizeof(buf), buf);K     status = sys$qiow(netlib_synch_efn, ctx->chan, IO$_ACPCONTROL, &myiosb,s     	    	    	0, 0, &subfdsc, #ifdef TCPWARE     	    	    	&tmpdsc,o #elset     	    	    	&adrdsc,  #endif /* TCPWARE */'     	    	    	&length, &entdsc, 0, 0);T:     if (OK(status)) status = netlib___cvt_status(&myiosb);@     if (argc > 6 && iosb != 0) netlib___cvt_iosb(iosb, &myiosb);     if (OK(status)) {M&     	str$copy_r(namdsc, &length, buf);3     	if (argc > 5 && retlen != 0) *retlen = length;!     }u       return status;   } /* netlib_address_to_name */   /* **++  **  ROUTINE:	NETLIB_GET_HOSTNAME ** **  FUNCTIONAL DESCRIPTION:, **D **  	Obtains the local host name configured for this TCP/IP package. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */J unsigned int netlib_get_hostname (void *bufdsc, unsigned short *retlenp) {       char buf[256];     unsigned int status;     unsigned short retlen;
     int argc;e       SETARGCOUNT(argc);  <     if (gethostname(buf, sizeof(buf)) < 0) return SS$_ABORT;     retlen = strlen(buf);y  .     status = str$copy_r(bufdsc, &retlen, buf);#     if (!OK(status)) return status;M4     if (argc > 1 && retlenp != 0) *retlenp = retlen;       return SS$_NORMAL;   } /* netlib_get_hostname */i n /* **++% **  ROUTINE:	netlib___get_nameservers  ** **  FUNCTIONAL DESCRIPTION:n **H **  	Obtains the list of DNS servers configured for this TCP/IP package. ** **  RETURNS:	int ** **  PROTOTYPE: **! **  	NETLIB___GET_NAMESERVERS nsqs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.t ** **  COMPLETION CODES:d ** ** **  SIDE EFFECTS:   	None. ** **-- */+ int netlib___get_nameservers (QUEUE *nsq) {A       struct NAMESERVER *ns;     struct INADDRDEF a;P     struct CTX *tmpctx;v)     struct dsc$descriptor dsc, lognamdsc;R     ITMLST lnmlst[2];0.     char name[256], lognam[256], *cp, *anchor;&     unsigned int status, size, maxidx;     unsigned short namlen;     int index, i, remain;i     int v5, count;      static unsigned int one = 1;       tmpctx = 0;k     count = 0;  E     ITMLST_INIT(lnmlst[0], LNM$_STRING, sizeof(name), name, &namlen);I'     ITMLST_INIT(lnmlst[1], 0, 0, 0, 0);E  %     INIT_SDESC(lognamdsc, 0, lognam);   3     for (v5 = 1; (count == 0) && (v5 >= 0); v5--) {t,     	for (index = 0; index <= 16; index++) {v     	    lognamdsc.dsc$w_length = sprintf(lognam, (v5 == 0 ? "UCX$BIND_SERVER%03d" : "TCPIP$BIND_SERVER%03d"), index);K     	    status = sys$trnlnm(0, &nameserver_tabnam, &lognamdsc, 0, lnmlst);s2     	    if (!OK(status) || namlen == 0) continue;9     	    for (anchor = name, remain = namlen; remain > 0;e8     	    	    	    	    	remain -= i+1, anchor = cp+1) {+     	    	cp = memchr(anchor, ',', remain);I"     	    	if (cp == 0) i = remain;     	    	else i = cp - anchor; %     	    	INIT_SDESC(dsc, i, anchor);c0     	    	if (!OK(netlib_strtoaddr(&dsc, &a))) {      	    	    if (tmpctx == 0) {?     	    	    	if (!OK(netlib_socket(&tmpctx, 0, 0))) continue;O     	    	    } K     	    	    if (!OK(netlib_name_to_address(&tmpctx, 0, &dsc, &a, &one, 0,t(     	    	    	    	0, 0, 0))) continue;     	    	} +     	    	size = sizeof(struct NAMESERVER); *     	    	status = lib$get_vm(&size, &ns);!     	    	if (!OK(status)) break;t     	    	ns->addr = a; &     	    	queue_insert(ns, nsq->tail);     	    	count += 1;R
     	    }     	}     }t  +     if (tmpctx != 0) netlib_close(&tmpctx);s     return count;:    } /* netlib___get_nameservers */   /* **++  **  ROUTINE:	netlib___get_domain ** **  FUNCTIONAL DESCRIPTION:c **G **  	Returns the DNS domain name for this host, either derived from theMJ **  logical name provided by UCX, or by picking apart the local host name. ** **  RETURNS:	int ** **  PROTOTYPE: **. **  	NETLIB___GET_DOMAIN  buf, bufsize, retlen ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */U int netlib___get_domain (char *buf, unsigned short bufsize, unsigned short *retlen) {r       struct dsc$descriptor dsc;     ITMLST lnmlst[2];r     char name[256], *cp;     unsigned short namlen;  5     static $DESCRIPTOR(lognamdsc, "UCX$BIND_DOMAIN"); :     static $DESCRIPTOR(lognamdsc_v5, "TCPIP$BIND_DOMAIN");/     static $DESCRIPTOR(tabnam, "LNM$FILE_DEV");   E     ITMLST_INIT(lnmlst[0], LNM$_STRING, sizeof(name), name, &namlen); '     ITMLST_INIT(lnmlst[1], 0, 0, 0, 0);5  =     if (OK(sys$trnlnm(0, &tabnam, &lognamdsc_v5, 0, lnmlst)))      	cp = name;t?     else if (OK(sys$trnlnm(0, &tabnam, &lognamdsc, 0, lnmlst))))     	cp = name;[
     else {)     	INIT_SDESC(dsc, sizeof(name), name);;;     	if (!OK(netlib_get_hostname(&dsc, &namlen))) return 0;t$     	cp = memchr(name, '.', namlen);     	if (cp == 0) return 0;-
     	cp += 1;=     	namlen -= (cp - name);      }t  /     if (memchr(cp, '.', namlen) == 0) return 0;r/     if (namlen > bufsize-1) namlen = bufsize-1;      memcpy(buf, cp, namlen);     *retlen = namlen;c  
     return 1;    } /* netlib___get_domain */  G /* **++! **  ROUTINE:	netlib_dns_mx_lookups ** **  FUNCTIONAL DESCRIPTION:_ **@ **  	Public entry point for MX RR lookup routine.  Simply passesD **  the call through to the NETLIB generic routine that performs its **  own DNS queries. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **_ **  	NETLIB_DNS_MX_LOOKUP  ctx, namdsc, mxrr, mxrrsize [,mxrrcount] [,iosb] [,astadr] [,astprm]S ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:l ** ** **  SIDE EFFECTS:   	None. ** **-- */4 unsigned int netlib_dns_mx_lookup(struct CTX **xctx,B     	    	    struct dsc$descriptor *namdsc, struct MXRRDEF *mxrr,>     	    	    unsigned int *mxrrsize, unsigned int *mxrrcount,K     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm) {        struct CTX *ctx;
     int argc;        VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);%     if (argc < 4) return SS$_INSFARG;I  ?     return netlib___dns_mx_lookup(xctx, namdsc, mxrr, mxrrsize,(;     	    (argc > 4) ? mxrrcount : 0, (argc > 5) ? iosb : 0,t;     	    (argc > 6) ? astadr : 0, (argc > 7) ? astprm : 0);    } /* netlib_dns_mx_lookup */