 /* **++ **  FACILITY:	NETLIB **E **  ABSTRACT:	Formulates and sends DNS queries, preprocesses replies.  ** **  MODULE DESCRIPTION:  **6 **  	This module is the core of NETLIB's DNS resolver. ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  24-OCT-1994  ** **  MODIFICATION HISTORY:  **1 **  	24-OCT-1994 V1.0    Madison 	Initial coding. 8 **  	17-NOV-1994 V1.1    Madison 	Connect to nameserver.= **  	18-NOV-1994 V1.2    Madison 	Restructure asynch queries. E **  	18-JAN-2001 V1.2-1  Madison 	Only return EOF if NAMERR & AA set. D **      04-FEB-2002 V1.2-2  Madison     Fix handling of retry count. **-- */ #include "netlib.h"    /* **  Forward routines */S     unsigned int netlib_dns_query(struct CTX **xctx, struct dsc$descriptor *namdsc, 6     	    	    unsigned int *class, unsigned int *type,:     	    	    unsigned char *buf, unsigned short *bufsize,>     	    	    unsigned int *flags, struct NETLIBIOSBDEF *iosb,.     	    	    void (*astadr)(), void *astprm);8     static unsigned int do_query(struct DNSREQ *dnsreq);@     static unsigned int query_nameserver(struct DNSREQ *dnsreq);8     static void query_completion(struct DNSREQ *dnsreq);0     static void do_write(struct DNSREQ *dnsreq);/     static void do_read(struct DNSREQ *dnsreq);  /* **  External references  */4     unsigned int netlib___dns_init(struct CTX *ctx);3     unsigned int netlib_socket(struct CTX **, ...); K     unsigned int netlib_connect(struct CTX **, void *, unsigned int *,...); K     unsigned int netlib_write(struct CTX **, struct dsc$descriptor *, ...); J     unsigned int netlib_read(struct CTX **, struct dsc$descriptor *, ...);-     unsigned int netlib_close(struct CTX **);    /* **++ **  ROUTINE:	netlib_dns_query  ** **  FUNCTIONAL DESCRIPTION:  **B **  	Formulates a DNS query, sends it out, and obtains a reply (if **  possible). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **? **  	NETLIB_DNS_QUERY  ctx, namdsc, [class], type, buf, bufsize 8 **  	    	    	    	[,flags] [,iosb] [,astadr] [,astprm] **O **  ctx:    	NETLIB context address, longword_unsigned, read only, by reference D **  namdsc: 	char_string, character string, read only, by descriptorL **  class:  	longword_unsigned, longword (unsigned), read only, by referenceL **  type:   	longword_unsigned, longword (unsigned), read only, by referenceG **  buf:    	varying_arg, longword (unsigned), write only, by reference D **  bufsize:	word_unsigned, word (unsigned), read only, by referenceH **  flags:  	mask_longword, longword (unsigned), read only, by referenceK **  iosb:   	io_status_block, quadword (unsigned), write only, by reference ? **  astadr: 	ast_procedure, procedure value, call, by reference ? **  astprm: 	user_arg, longword (unsigned), read only, by value  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */O unsigned int netlib_dns_query(struct CTX **xctx, struct dsc$descriptor *namdsc, 7     	    	    unsigned int *xclass, unsigned int *type, :     	    	    unsigned char *buf, unsigned short *bufsize,?     	    	    unsigned int *xflags, struct NETLIBIOSBDEF *iosb, /     	    	    void (*astadr)(), void *astprm) {        struct CTX *ctx;     struct DNSREQ *dnsreq;     struct IOR *ior;!     struct NETLIB_DNS_HEADER *hp; &     unsigned int class, flags, status;     unsigned short namlen;     char *name; 
     int argc;    /*" **  Sanity-check the argument list */     VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 6) return SS$_INSFARG; R     if (namdsc == 0 || type == 0 || buf == 0 || bufsize == 0) return SS$_BADPARAM;   /*B **  Make sure we're doing DNS, and initialize the resolver context
 **  if needed  */:     if (ctx->flags & CTX_M_NO_DNS) return SS$_UNSUPPORTED;       if (ctx->dnsctx == 0) { %     	status = netlib___dns_init(ctx); -     	if (!OK(status)) return SS$_UNSUPPORTED;      }    /* **  Process the input arguments  */7     status = lib$analyze_sdesc(namdsc, &namlen, &name); #     if (!OK(status)) return status;   3     if (xclass == 0) class = NETLIB_K_DNS_CLASS_IN;      else class = *xclass;   @     if (argc < 7 || xflags == 0) flags = NETLIB_M_DOMAIN_SEARCH;     else flags = *xflags;    /*% **  Allocate DNS & I/O request blocks  */2     GET_DNSREQ(dnsreq, ctx, (argc > 7) ? iosb : 0,+     	    	    	    (argc > 8) ? astadr : 0, ,     	    	    	    (argc > 9) ? astprm : 0);   /*& **  Initialize the domain search stuff */M     if ((flags & NETLIB_M_DOMAIN_SEARCH) && memchr(name, '.', namlen) == 0) { -     	dnsreq->curdom = ctx->dnsctx->domq.head;      } else {     	dnsreq->curdom = 0;     }    /*B **  Fill in the DNS request block and call DO_QUERY to do the work */     dnsreq->query_name 	= name; #     dnsreq->query_namlen = namlen;	       dnsreq->query_flags	= flags;     dnsreq->query_rbuf 	= buf;&     dnsreq->query_rbufsize = *bufsize;      dnsreq->query_class	= class;      dnsreq->query_type 	= *type;     dnsreq->ctx         = ctx;3     dnsreq->retries     = ctx->dnsctx->retry_count;        return do_query(dnsreq);   } /* netlib_dns_query */   /* **++ **  ROUTINE:	do_query  ** **  FUNCTIONAL DESCRIPTION:  **K **  	Does the actual work of formatting a query.  Calls on QUERY_NAMESERVER , **  to send the query out and get the reply. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	DO_QUERY  dnsrequest  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */6 static unsigned int do_query (struct DNSREQ *dnsreq) {  "     struct IOR *ior = dnsreq->ior;"     struct CTX *ctx = dnsreq->ctx;$     struct DNSCTX *dc = ctx->dnsctx;!     struct NETLIB_DNS_HEADER *hp;      char *anchor, *cp;     unsigned char *bp;
     int i, j;      unsigned int status;   /*G **  This is set up as a loop for synchronous queries.  For asynchronous > **  queries, we return as soon as the query has been sent out. */     while (1) {    /* **  Format the query header  */3     	hp = (struct NETLIB_DNS_HEADER *) dnsreq->buf; 5     	memset(hp, 0, sizeof(struct NETLIB_DNS_HEADER)); '     	hp->dns_w_queryid = ++dc->queryid; .     	hp->dns_v_opcode  = NETLIB_K_DNS_OP_STDQ;Y     	hp->dns_v_recursion_desired = (dnsreq->query_flags & NETLIB_M_NO_RECURSION) ? 0 : 1; -     	hp->dns_w_qdcount = netlib_word_swap(1);    /*/ **  Fill in the question -- the name part first  */9     	bp = dnsreq->buf + sizeof(struct NETLIB_DNS_HEADER); !     	anchor = dnsreq->query_name;      	i = dnsreq->query_namlen;     	while (i > 0) {%     	    cp = memchr(anchor, '.', i);      	    if (cp == 0) {      	    	*bp++ = i;)     	    	memcpy(bp, anchor, i); bp += i;      	    	break;     	    } else {      	    	j = cp - anchor;     	    	*bp++ = j;      	    	memcpy(bp, anchor, j);     	    	bp += j;     	    	i -= j + 1; 
     	    }     	    anchor = cp + 1;      	}   /*9 **  And the search domain, if we're doing search domains.  */     	if (dnsreq->curdom == 0) { J     	    dnsreq->curdom = (dnsreq->query_flags & NETLIB_M_DOMAIN_SEARCH) ??     	    	    	    dc->domq.head : (struct DOMAIN *) &dc->domq; 
     	} else { '     	    anchor = dnsreq->curdom->name; $     	    i = dnsreq->curdom->length;(     	    if (i >= 1 && *anchor == '.') {     	    	anchor++;      	    	i--;
     	    }     	    while (i > 0) {&     	    	cp = memchr(anchor, '.', i);     	    	if (cp == 0) {     	    	    *bp++ = i;-     	    	    memcpy(bp, anchor, i); bp += i;      	    	    break;     	    	} else {     	    	    j = cp - anchor;     	    	    *bp++ = j;$     	    	    memcpy(bp, anchor, j);     	    	    bp += j;     	    	    i -= j + 1;      	    	}      	    	anchor = cp + 1;
     	    }0     	    dnsreq->curdom = dnsreq->curdom->flink;     	} /*1 **  Terminate the name, insert the type and class  */     	*bp++ = '\0';L     	*(unsigned short *) bp = netlib_word_swap(dnsreq->query_type); bp += 2;M     	*(unsigned short *) bp = netlib_word_swap(dnsreq->query_class); bp += 2; '     	dnsreq->buflen = bp - dnsreq->buf;    /*$ **  Start with the first name server */"     	dnsreq->curns = dc->nsq.head;   /*( **  If ASTADR is 0, this is synchronous. */     	if (ior->astadr == 0) {   /*G **  Loop through all the nameservers until we get a successful response*R **  back (either RC_SUCCESS or RC_NAMERR && AA set), or we run out of nameservers. */B     	    while (dnsreq->curns != (struct NAMESERVER *) &dc->nsq) {,     	    	status = query_nameserver(dnsreq);R     	    	if (OK(status) && dnsreq->replylen > sizeof(struct NETLIB_DNS_HEADER)) {C     	    	    hp = (struct NETLIB_DNS_HEADER *) dnsreq->query_rbuf;iB     	    	    if (hp->dns_v_reply_code == NETLIB_K_DNS_RC_SUCCESS)     	    	    	break;mC     	    	    if (hp->dns_v_reply_code == NETLIB_K_DNS_RC_NAMERR &&h+     	    	    	    hp->dns_v_authoritative)i     	    	    	break;e     	    	}*/     	    	dnsreq->curns = dnsreq->curns->flink;i
     	    } /*D **  Check status and verify the reply code from the server.  If it'sG **  not a successful reply, move on to the next search domain; if we'veoG **  run through all the search domains, return an error: SS$_ENDOFFFILE*6 **  if no such host or domain, or SS$_ABORT otherwise. */     	    if (!OK(status))b#     	    	status = SS$_UNREACHABLE;tH     	    else if (dnsreq->replylen > sizeof(struct NETLIB_DNS_HEADER)) {?     	    	hp = (struct NETLIB_DNS_HEADER *) dnsreq->query_rbuf;V?     	    	if (hp->dns_v_reply_code == NETLIB_K_DNS_RC_NAMERR &&A)     	    	    	hp->dns_v_authoritative &&,=     	    	    	dnsreq->curdom != (struct DOMAIN *) &dc->domq)I;     	    	    continue;  /* back to top of while(1) loop */D     	    } elseL      	    	status = SS$_PROTOCOL;   /*D **  Return the results to the caller (still in synch I/O processing) */     	    if (ior->iosbp != 0) {C-     	    	ior->iosbp->iosb_w_status = status;O6     	    	ior->iosbp->iosb_w_count = dnsreq->replylen;(     	    	ior->iosbp->iosb_l_unused = 0;
     	    }     	    FREE_DNSREQ(dnsreq);I     	    return status;,   /*D **  For asynchronous calls, just fire off a query and do the rest of1 **  the processing in the AST completion routine.E */
     	} else {H)     	    return query_nameserver(dnsreq);A     	}       } /* while (1) */   7     return SS$_DATACHECK; /* should never reach here */n   } /* do_query */   /* **++ **  ROUTINE:	query_nameservern ** **  FUNCTIONAL DESCRIPTION:  **$ **  	Sends a query to a name server. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **! **  	QUERY_NAMESERVER  dnsrequestr ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.n ** **  COMPLETION CODES:	See code.u ** **  SIDE EFFECTS:   	None. ** **-- */> static unsigned int query_nameserver (struct DNSREQ *dnsreq) {  "     struct IOR *ior = dnsreq->ior;"     struct CTX *ctx = dnsreq->ctx;,     struct DNSCTX *dc = dnsreq->ctx->dnsctx;(     struct NETLIB_DNS_HEADER *hp1, *hp2;     struct dsc$descriptor dsc;!     unsigned int status, sinsize;;4     static unsigned int dgram = NETLIB_K_TYPE_DGRAM;   /* **  Set up the socket addresso */1     memset(&dnsreq->sin, 0, sizeof(dnsreq->sin));i0     dnsreq->sin.sin_w_family = NETLIB_K_AF_INET;2     dnsreq->sin.sin_w_port = netlib_word_swap(53);1     dnsreq->sin.sin_x_addr = dnsreq->curns->addr;    /*A **  Create the socket and "connect" it to the server.  We do thisiH **  so we can find out right away whether or not the server is listeningE **  on that UDP port, rather than waiting for the reply timeout if we J **  were to use sendto/recvfrom.  It's also more efficient to do a connect( **  in BSD-based TCP/IP implementations. */K     dnsreq->retries = ctx->dnsctx->retry_count;  /* init per name server */IH     status = ior->iosb.iosb_w_status = netlib_socket(&ior->ctx, &dgram);     if (OK(status)) { #     	sinsize = sizeof(dnsreq->sin);s     	if (ior->astadr != 0) {C     	    status = netlib_connect(&ior->ctx, &dnsreq->sin, &sinsize,t6     	    	    	    	    &ior->iosb, do_write, dnsreq);'     	    if (OK(status)) return status;T*     	    ior->iosb.iosb_w_status = status;
     	} else {eD     	    status = netlib_connect(&ior->ctx, &dnsreq->sin, &sinsize);     	    if (OK(status)) {7     	    	INIT_SDESC(dsc, dnsreq->buflen, dnsreq->buf);*C     	    	status = netlib_write(&ior->ctx, &dsc, 0, 0, &ior->iosb);r;     	    	if (OK(status)) status = ior->iosb.iosb_w_status;l0     	    	else ior->iosb.iosb_w_status = status;
     	    }     	}  .     	if (!OK(status)) netlib_close(&ior->ctx);     }n       if (!OK(status)) {     	ior->ctx = 0;)     	if (ior->astadr == 0) return status;e     	query_completion(dnsreq);     	return SS$_NORMAL;r     },   /*G **  OK, we've got ourselves connected and sent off the query.  Now read L **  the reply.  This loop handles synchronous reads; asynch reply processing# **  is handled in QUERY_COMPLETION.  */     while (1) {NA     	INIT_SDESC(dsc, dnsreq->query_rbufsize, dnsreq->query_rbuf);,N     	status = netlib_read(&ior->ctx, &dsc, 0, 0, 0, &dc->timeout, &ior->iosb);   /*8 **  Make sure that the reply is to the query we sent out */     	if (OK(status)) {G     	    if (ior->iosb.iosb_w_count < sizeof(struct NETLIB_DNS_HEADER)))     	    	continue; 8     	    hp1 = (struct NETLIB_DNS_HEADER *) dnsreq->buf;?     	    hp2 = (struct NETLIB_DNS_HEADER *) dnsreq->query_rbuf;i8     	    if (hp1->dns_w_queryid == hp2->dns_w_queryid) {4     	    	dnsreq->replylen = ior->iosb.iosb_w_count;"     	    	netlib_close(&ior->ctx);     	    	ior->ctx = 0;O     	    	return SS$_NORMAL;
     	    }   /*? **  If the reply timed out, try again.  This is UDP, after all.0 */
     	} else {AB     	    if ((status == SS$_TIMEOUT) && (--dnsreq->retries > 0)) {7     	    	INIT_SDESC(dsc, dnsreq->buflen, dnsreq->buf);NC     	    	status = netlib_write(&ior->ctx, &dsc, 0, 0, &ior->iosb);s#     	    	if (OK(status)) continue; 
     	    }!     	    netlib_close(&ior->ctx);      	    ior->ctx = 0;     	    return status;      	}     }a  7     return SS$_DATACHECK; /* should never reach here */)   } /* query_nameserver */ a /* **++ **  ROUTINE:	query_completion  ** **  FUNCTIONAL DESCRIPTION:  **2 **  	Completion processing for a reply to a query. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **! **  	QUERY_COMPLETION  dnsrequest  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.* ** **  SIDE EFFECTS:   	None. ** **-- */6 static void query_completion (struct DNSREQ *dnsreq) {  "     struct IOR *ior = dnsreq->ior;"     struct CTX *ctx = dnsreq->ctx;$     struct DNSCTX *dc = ctx->dnsctx;(     struct NETLIB_DNS_HEADER *hp1, *hp2;     struct dsc$descriptor dsc;     unsigned int status;   /*I **  If completion status was OK, verify that the response is to the queryl5 **  we sent out.  If it wasn't queue up another read._ */%     status = ior->iosb.iosb_w_status;sS     if (OK(status) && ior->iosb.iosb_w_count >= sizeof(struct NETLIB_DNS_HEADER)) {r4     	hp1 = (struct NETLIB_DNS_HEADER *) dnsreq->buf;;     	hp2 = (struct NETLIB_DNS_HEADER *) dnsreq->query_rbuf;*4     	if (hp1->dns_w_queryid != hp2->dns_w_queryid) {E     	    INIT_SDESC(dsc, dnsreq->query_rbufsize, dnsreq->query_rbuf);QE     	    status = netlib_read(&ior->ctx, &dsc, 0, 0, 0, &dc->timeout, 9     	    	    	    &ior->iosb, query_completion, dnsreq);l     	    if (OK(status))     	    	return;sC     	} else if (hp2->dns_v_reply_code == NETLIB_K_DNS_RC_SUCCESS ||o^     	    	    (hp2->dns_v_reply_code == NETLIB_K_DNS_RC_NAMERR && hp2->dns_v_authoritative) ||G     	    	    dnsreq->curns->flink == (struct NAMESERVER *) &dc->nsq) {      	    if (ior->ctx != 0)*"     	    	netlib_close(&ior->ctx);     	    ior->ctx = 0;     	    if (ior->iosbp != 0) <     	    	memcpy(ior->iosbp, &ior->iosb, sizeof(ior->iosb));3     	    dnsreq->replylen = ior->iosb.iosb_w_count;p%     	    (*ior->astadr)(ior->astprm);r     	    FREE_DNSREQ(dnsreq);      	    return;     	}     }e   /*' **  If we timed out, re-send the query.o */=     if ((status == SS$_TIMEOUT) && (--dnsreq->retries > 0)) {d2     	INIT_SDESC(dsc, dnsreq->buflen, dnsreq->buf);1     	status = netlib_write(&ior->ctx, &dsc, 0, 0,e1     	    	    	    	&ior->iosb, do_read, dnsreq);D     	if (OK(status)) return;     }=   /*? **  Done with this connection.  Don't need the socket any more.w */     if (ior->ctx != 0) {     	netlib_close(&ior->ctx);i     	ior->ctx = 0;     }    /*@ **  Set things up for moving on to next server; if we've run outC **  of servers, move on to next search domain.  If we've run out ofe9 **  those, we report the last error we got to the caller.  */)     dnsreq->curns = dnsreq->curns->flink;   :     if (dnsreq->curns == (struct NAMESERVER *) &dc->nsq) {9     	if (dnsreq->curdom == (struct DOMAIN *) &dc->domq) {;     	    if (ior->iosbp != 0)j<     	    	memcpy(ior->iosbp, &ior->iosb, sizeof(ior->iosb));%     	    (*ior->astadr)(ior->astprm);      	    FREE_DNSREQ(dnsreq);e     	    return;     	} /* **  Next query */     	do_query(dnsreq);     	return;     }s   /* **  Next nameserver_ */     query_nameserver(dnsreq);    } /* query_completion */   /* **++ **  ROUTINE:	do_write  ** **  FUNCTIONAL DESCRIPTION:a **B **  	Queue a write to the nameserver (for asynch queries).  Called% **  as completion AST on the connect.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	DO_WRITE  dnsreq  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.i ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */. static void do_write (struct DNSREQ *dnsreq) {  "     struct IOR *ior = dnsreq->ior;     struct dsc$descriptor dsc;     unsigned int status;  %     status = ior->iosb.iosb_w_status;o     if (OK(status)) {n2     	INIT_SDESC(dsc, dnsreq->buflen, dnsreq->buf);O     	status = netlib_write(&ior->ctx, &dsc, 0, 0, &ior->iosb, do_read, dnsreq);_     }s       if (OK(status)) return;   %     ior->iosb.iosb_w_status = status;p     query_completion(dnsreq);    } /* do_write */   /* **++ **  ROUTINE:	do_read ** **  FUNCTIONAL DESCRIPTION:/ **B **  	Queues a read to the nameserver (for asynch queries).  Called" **  as completion AST to DO_WRITE. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	DO_READ  dnsrequest ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.S ** **  SIDE EFFECTS:   	None. ** **-- */- static void do_read (struct DNSREQ *dnsreq) {&  "     struct IOR *ior = dnsreq->ior;,     struct DNSCTX *dc = dnsreq->ctx->dnsctx;     struct dsc$descriptor dsc;     unsigned int status;  %     status = ior->iosb.iosb_w_status;R     if (OK(status)) { A     	INIT_SDESC(dsc, dnsreq->query_rbufsize, dnsreq->query_rbuf);RA     	status = netlib_read(&ior->ctx, &dsc, 0, 0, 0, &dc->timeout, :     	    	    	    	&ior->iosb, query_completion, dnsreq);     }n       if (OK(status)) return;   %     ior->iosb.iosb_w_status = status;o     query_completion(dnsreq);    } /* do_read */ 