 	PROGRAM ZMENU   * # *	17 Jul 91  1.000  Initial release  * ? *	18 Jul 91  1.001  Fix problems caused by using INTEGER*2 when  *			   INTEGER*4 is required.  * - *	22 Jan 92  1.002  Add /INITIAL=n qualifier.  * @ *	23 Apr 92  1.003  Let pointer be displayed correctly even when5 *			   there are Escape Sequences and/or SI/SO on the ( *			   same line in columns to the left.0 *			  Add /TEXT, /START0, and /BOUND qualifiers.0 *			  Remove second field of /POINTER qualifier. *  *----- Spring 92 VAX SIG TAPE  * D *	19 Oct 92  1.004  Add /SCROLLING qualifier, which invokes a separ-% *			   ate program, ZMENU_SCROLL.EXE.  * E *	 7 Jan 93  1.005  Abort ZMENU if item character is too close to the # *			   left margin for the pointer.  *  * . *	Alan L. Zirkle		Naval Surface Warfare Center
 *				Code K55  *				Dahlgren, Virginia  22448 *    * E *	ZMENU is a utility designed to display a menu from within a command F *	procedure, to select a menu item based on a user's instructions, andE *	to communicate the user's selection to the procedure so that it can > *	perform further processing based on which item was selected. *  *	ZMENU is called as:  * 3 *	    $ ZMENU [file] [/SYMBOLS] [/POINTER="text"] -  * > *		[/ITEM="char"] [/WIDE] [/NOINTERRUPT] [/DEBUG] [/VERSION] - *   *		[/INITIAL=n] [/TEXT="string"] * G *	If 'file' is omitted, SYS$INPUT is assumed.  If no file type is spec-  *	ified, .MENU is assumed. * E *	ZMENU clears the screen, and displays the contents of the specified D *	file (up to 24 lines).  If the /WIDE qualifier is used, the screen! *	is made 132 columns wide first.  * E *	Any lines in the file beginning with "!" are assumed to be comments  *	and are not displayed. * B *	Occurrences of the ITEM character (default "^") are displayed asE *	blanks.  A pointer (default "-->") is displayed at the first (upper E *	leftmost) item location.  The rightmost character of the pointer is D *	placed over the item character.  Items must not be so close to theE *	left margin that the pointer will not fit.  You can choose your own ' *	item character and/or pointer string.  * G *	If the user enters an ARROW key, the pointer is moved to the next key 4 *	location in the direction the arrow key specified. * 5 *	If the user enters CTRL/W, the screen is refreshed.  * B *	If the user enters RETURN, SELECT, DO, or ENTER, then DCL SymbolA *	CHOICE is set to the number of the item at which the pointer is @ *	currently displayed.  The items are numbered as follows:  itemA *	numbers are 1,2,3,... ; the upper-left-most item is numbered 1; @ *	the search for the next item goes down the screen column, then# *	down the next screen column, etc.  * ? *	If /SYMBOLS is specified, then occurences of DCL Symbol names @ *	(in apostrophes) in the file are replaced by the current valueB *	of the symbols.  This allows the displayed text to vary based on% *	the state of the command procedure.  * D *	If you use the /NOINTERRUPT qualifier, then if the user CONTROL-YsB *	out of MENU, CHOICE will be set to 0 and no other effects of the- *	interrupt will be visible to the procedure.  * = *	If /INITIAL=n is specified, then when the menu is initially ? *	displayed, the pointer is positioned at the Nth item, instead > *	of the first item, which is the default.  If there is no Nth" *	item, this qualifier is ignored. * B *	The /TEXT qualifier enables the entry of text in addition to theA *	arrow keys.  Somewhere in your menu display, you must designate > *	an area for the display of the entered text.  You do this by@ *	using a special character; the default is "\".  An example is: *  *		^ Item 1  *		^ Item 2  *  *		Text: \\\\\ * B *	This example allows up to five characters of text to be entered.@ *	The text display area must not extend past column 80.  Text is) *	always displayed in bold reverse video.  * ? *	By default, when no text has been entered, ZMENU will display @ *	blanks, not "\\\\\", in the text display area.  You can chooseC *	a different character (such as an underscore), or you can specify : *	a character plus a prefix and a postfix escape sequence. * B *	Three text entry options are available:  A, C, and K.  The /TEXTB *	qualifier must be specified with a character string value, as in= *	the example:  /TEXT="A|_".  The first character must be the B *	option.  The second character must be the special character usedB *	in the menu display to designate the text entry area.  The thirdA *	and subsequent character(s) must be the desired character [plus = *	optional escape sequence(s)] to display in blank text entry A *	columns.  For example, to display boldface minus signs in empty ? *	columns, specify:  /TEXT="A\[1m=[m"  and have a line in the  *	menu display: $ *			Enter text: [1m\\\\\\\\\\\\\[m * = *	* The A option allows the input of arbitrary text, up to 80 @ *	  characters.  The entered text is displayed in the text entry@ *	  area.  The text is cleared out whenever the pointer is movedB *	  to another menu item.  When ZMENU exits, DCL Symbol ZMENU_TEXT( *	  contains the text, or a null string. * ? *	* The C option allows the input of an item number, giving the A *	  user the option of using the arrow keys or entering a number. > *	  when a number is entered, the pointer immediately jumps to> *	  the specified item; no carriage return is required.  If an@ *	  illegal input is entered, the pointer moves back to where it *	  previously was.  * B *	* The K option allows the input of an item "keyword", giving theB *	  user the option of using the arrow keys or entering a keyword.C *	  The text the user enters is uppercased.  Keywords are the char- A *	  acter strings beginning two columns past the item characters.  *	  For example, in the menu:  * 
 *			^ PROCESS  *			^ Delete *			^ EXIT NOW * E *	  The keywords are "PROCESS", "DELETE" (uppercase), and "EXIT NOW". C *	  When a text entry matches a keyword or even the initial part of C *	  a keyword, the pointer immediately jumps to the first item with E *	  a match; no carriage return is required.  If non-matching text is @ *	  entered, the pointer  moves back to where it previously was. *  * : *	The user may include Escape Sequences, and the SI and SO> *	characters, within the file to control video attributes.  If< *	desired, the user can put an upside down question mark "": *	everywhere an ESCAPE character is needed.  Use of escape8 *	sequences makes screen layout design harder, since the? *	sequences take up columns in the file, but not on the screen. ; *	The numbering of items is done by screen column, not file : *	column (i.e. escape sequences are assumed to be absent).? *	On lines with an escape sequence, tabs must not be used after  *	the sequence.  * > *	The pointer may be up to 24 characters long.  It may include *	escape sequences.  * = *	When no screen I/O is being done, the cursor is left parked ? *	near the lower right-hand corner of the screen (line 22, col- 7 *	umn 80 or column 132) where it is less conspicuous.    * ? *	If the string "00:00:00" exists in the file, the current time B *	is displayed at that location every five seconds (if this stringB *	appears more than once in the file, only the first occurrence is *	used). * E *	If the first non-comment line in the file contains "/" in column 1, E *	it is not displayed.  Instead, it is assumed to contain some or all B *	of the qualifiers allowed on the command line (except /DEBUG andE *	/VERSION).  This line is always examined for DCL symbols regardless A *	of whether /SYMBOLS is used on the command line.  Values speci- < *	fied on this line override qualifiers on the command line.= *	In many cases it makes more sense to keep these values with  *	the file.  * ? *	If /DEBUG is specified, then the lines are displayed with the > *	item character visible (they will disappear when the pointer> *	covers them), and the item number being currently pointed to. *	is displayed in the lower right-hand corner. * > *	If the user enters "H" or "h" or "?" or PF2 or F15 (HELP), a> *	HELP display appears on the bottom five lines of the screen;, *	it goes away when the user enters a blank. * > *	If ZMENU is called from a non-interactive process, or if the= *	menu contains no selectable items, ZMENU exits with a diag- 	 *	nostic.  *    	IMPLICIT NONE   	INTEGER*4 CHOICE,START0 	LOGICAL*4 BOUND 	CHARACTER*9 PARK ' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARK    	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	LOGICAL*1 INPUT_READY" 	CHARACTER*1 INPUT_CHAR,INPUT_FLAG1 	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY    	INTEGER*4 TEXT,TLEN 	COMMON /TEXT/ TEXT,TLEN   	character*1024 buffer 	common /buffer/ buffer    	INTEGER*4 I,J,DIFF    	CALL INITIALIZE   100	call screen_start(buffer)   < 	DO I=1,MAXL		! Display the lines, minus the item characters   	    CALL DISPLAY_LINE(I,1)    	ENDDO  5 	CALL SCREEN('[J')	    	! Clear remainder of screen.   9 	IF (TLEN.GT.0) CALL TEXTIN(2)	! Refresh the text display   G 120	CALL DISPLAY_POINTER	    ! Display the pointer and park the cursor.    130	call screen_end   B 	CALL GET_TERMINAL_INPUT	    ! Wait for user to enter a character.   	call screen_start(buffer)   	IF (INPUT_FLAG.EQ.'*') THEN  4 	    IF (INPUT_CHAR.EQ.CHAR(23)) GO TO 100		! CTRL-W5 	    IF (INPUT_CHAR.EQ.CHAR(13)) CALL EXIT_		! RETURN 1 	    IF (INPUT_CHAR.EQ.CHAR(127)) THEN			! DELETE  		CALL TEXTIN(0) 		IF (TEXT.GT.1) GO TO 120
 	    ENDIF  ! 	ELSE IF (INPUT_FLAG.EQ.'~') THEN   4 	    IF (INPUT_CHAR.EQ.CHAR(4)) CALL EXIT_		! SELECT2 	    IF (INPUT_CHAR.EQ.CHAR(28)) CALL HELP		! HELP1 	    IF (INPUT_CHAR.EQ.CHAR(29)) CALL EXIT_		! DO   9 	ELSE IF (INPUT_FLAG.EQ.' ') THEN		! Printable characters    	    IF (TEXT.NE.0) THEN 		CALL TEXTIN(1) 		IF (TEXT.GT.1) GO TO 120	 	    ELSE . 		IF (INPUT_CHAR.EQ.'H' .OR. INPUT_CHAR.EQ.'h'- 	1			       .OR. INPUT_CHAR.EQ.'?') CALL HELP 
 	    ENDIF  ( 	ELSE IF (INPUT_CHAR.EQ.'A') THEN			! UP   	    IF (BOUND) THEN" 	       IF (CHOICE.EQ.1) GO TO 130A 	       IF (POINTERS(2,CHOICE-1).NE.POINTERS(2,CHOICE)) GO TO 130 
 	    ENDIF   	    CHOICE = CHOICE - 1# 	    IF (CHOICE.EQ.0) CHOICE = MAXP 2 140	    CALL TEXTIN(4)			! Delete any entered text 	    GO TO 120  * 	ELSE IF (INPUT_CHAR.EQ.'B') THEN			! DOWN   	    IF (BOUND) THEN% 	       IF (CHOICE.EQ.MAXP) GO TO 130	A 	       IF (POINTERS(2,CHOICE).NE.POINTERS(2,CHOICE+1)) GO TO 130	
 	    ENDIF   	    CHOICE = CHOICE + 1# 	    IF (CHOICE.GT.MAXP) CHOICE = 1n 	    GO TO 140  + 	ELSE IF (INPUT_CHAR.EQ.'C') THEN			! RIGHT.  " 	    IF (CHOICE.EQ.MAXP) GO TO 130  % 	    J = 0		! Best possibility so farG 	    DO I=CHOICE+1,MAXP1: 		IF (POINTERS(2,I).GT.POINTERS(2,CHOICE)) THEN      ! col: 		    IF (POINTERS(1,I).LT.POINTERS(1,CHOICE)) THEN  ! row 			J = I, 			DIFF = POINTERS(1,CHOICE) - POINTERS(1,I)8 		    ELSE IF (POINTERS(1,I).LT.POINTERS(1,CHOICE)) THEN 			J = I 			GO TO 150
 		    ELSE 			IF (J.NE.0) THENg! 			    IF (DIFF.GT.POINTERS(1,I)-M& 	1				       POINTERS(1,CHOICE)) J = I 			ELSEw 			    J = I 			ENDIF 			GO TO 150 		    ENDIFm 		ENDIF 
 	    ENDDO   	    IF (J.NE.0) THENu 150		CHOICE = J  		GO TO 140t
 	    ENDIF  * 	ELSE IF (INPUT_CHAR.EQ.'D') THEN			! LEFT   	    IF (CHOICE.EQ.1) GO TO 130   % 	    J = 0		! Best possibility so farM 	    DO I=CHOICE-1,1,-1O: 		IF (POINTERS(2,I).LT.POINTERS(2,CHOICE)) THEN      ! col: 		    IF (POINTERS(1,I).GT.POINTERS(1,CHOICE)) THEN  ! row 			J = I, 			DIFF = POINTERS(1,I) - POINTERS(1,CHOICE)
 		    ELSE 			IF (J.NE.0) THEN,& 			    IF (DIFF.GT.POINTERS(1,CHOICE)- 	1					    POINTERS(1,I)) J = In 			ELSE  			    J = I 			ENDIF 			GO TO 150 		    ENDIFq 		ENDIFi
 	    ENDDO   	    IF (J.NE.0) GO TO 150  + 	ELSE IF (INPUT_CHAR.EQ.'M') THEN			! ENTERn   	    CALL EXIT_s  0 	ELSE IF (INPUT_CHAR.EQ.'Q') THEN			! PF2 (help)   	    CALL HELP   	ENDIF  
 	GO TO 130  
 	END									a   	SUBROUTINE INITIALIZE   	IMPLICIT NONE   	CHARACTER*132 SLINES(24)e 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS  ) 	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPTr 	INTEGER*2 PLEN,PLEN2  	CHARACTER*32 POINTERm 	CHARACTER*1 ITEMoF 	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEM   	INTEGER*4 CHOICE,START0 / 0 / 	LOGICAL*4 BOUND / .FALSE. /! 	CHARACTER*9 PARK / '[22;080H' /s' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARK	   	INTEGER*4 TEXTR 	COMMON /TEXT/ TEXT   % 	INTEGER*4 I,LEN0,COL,COL2,MAXCOL /0/o 	EXTERNAL ABORTe   	DATA MAXL,MAXP / 0,0 /i   	CALL PROCESS_QUALIFIERS   	IF (WIDE) THENr& 	    CALL SMGL_SET_TERMINAL_WIDTH(132) 	    PARK = '[22;132H's 	ENDIF  7 	CALL CLI$GET_VALUE('P1',LINES(0),LEN0)	! Get file namee  @ 	OPEN (1,FILE=LINES(0)(1:LEN0),DEFAULTFILE='.MENU',STATUS='OLD', 	1						       READONLY)  G *	Read in the lines; remove comments; substitute DCL symbols if needed.a  ( 10	READ (1,1000,END=20) LLEN(0),LINES(0)  4 	IF (LLEN(0).GT.0.AND.LINES(0)(1:1).EQ.'!') GO TO 10   	IF (LLEN(0).GT.0) THENu  3 	    IF (MAXL.EQ.0 .AND. LINES(0)(1:1).EQ.'/') THEN  		CALL PROCESS_QUALIFIERSu
 		GO TO 10
 	    ENDIF   	    IF (SYMBOLS) THEN0 		IF (LLEN(0).LT.200) LINES(0)(LLEN(0)+1:) = ' '$ 		CALL SYMBOL_SUBSTITUTE(LINES(0),I)
 		LLEN(0) = Ie$ 		IF (LINES(0)(1:1).EQ.'!') GO TO 10
 	    ENDIF   	ENDIF   	MAXL = MAXL + 1. 	CALL DETAB(LINES(0)(1:LLEN(0)),LINES(MAXL),I)   	LLEN(MAXL) = I & 	IF (I.LT.200) LINES(MAXL)(I+1:) = ' '  4 	CALL REMOVE_ESCAPE(LINES(MAXL)(1:I),SLINES(MAXL),I)' 	IF (I.LT.132) SLINES(MAXL)(I+1:) = ' 'e  ? 	MAXCOL = MAX(MAXCOL,I)		! Record length of longest screen linep   	IF (MAXL.LT.24) GO TO 10    20	CLOSE (1)  6 	IF (MAXL.EQ.0) CALL ERROR(2)	! Menu contains no lines  B 	DO COL=1,MAXCOL		! Find all of the selectable items; record their 				!  line and column numbers 	    DO I=1,MAXL  & 		IF (SLINES(I)(COL:COL).EQ.ITEM) THEN' 		    IF (COL-PLEN2.LT.0) CALL ERROR(6)d 		    MAXP = MAXP + 1e 		    POINTERS(1,MAXP) = I 		    POINTERS(2,MAXP) = COL 		    IF (.NOT.DEBUG) THEN" 		        SLINES(I)(COL:COL) = ' ' 			COL2 = INDEX(LINES(I),ITEM) 			LINES(I)(COL2:COL2) = ' ' 		    ENDIF  		ENDIFp  
 	    ENDDO   	ENDDO  B 	IF (MAXP.LT.2) CALL ERROR(3)	! Menu contains 0-1 selectable items   	IF (CHOICE.GT.MAXP) CHOICE = 1T   	IF (TEXT) CALL PROCESS_TEXT  ' 	IF (NOINTERRUPT) CALL CONTROL_Y(ABORT)n  5 	CALL SET_CLOCK			! Search for "00:00:00" in the fileb   1000	FORMAT (Q,A)e  
 	END									  t 	SUBROUTINE PROCESS_QUALIFIERS   	IMPLICIT NONE   	CHARACTER*132 SLINES(24)r 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS  ) 	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPT, 	INTEGER*2 PLEN,PLEN2n 	CHARACTER*32 POINTERo 	CHARACTER*1 ITEMEF 	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEM   	INTEGER*4 CHOICE,START0 	LOGICAL*4 BOUND 	CHARACTER*9 PARKf' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARKs   	INTEGER*4 TEXT /0/d 	COMMON /TEXT/ TEXTe   	INTEGER*4 I? 	LOGICAL*4 FIRST_CALL,CLI$PRESENT,INTERACTIVE_MODE,OTS$CVT_TI_Lo 	EXTERNAL MENU_CLD  ? 	DATA SYMBOLS,WIDE,NOINTERRUPT,FIRST_CALL / .FALSE. , .FALSE. ,u 	1				     .FALSE. , .TRUE. /n   	IF (FIRST_CALL) THENt 	    FIRST_CALL = .FALSE. % 	    IF (CLI$PRESENT('VERSION')) THEN  		CALL LIB$PUT_OUTPUT(; 	1	       'NSWC ZMENU Rev 1.005 Created  7-JAN-1992 12:00')o 		CALL EXITc
 	    ENDIF/ 	    IF (.NOT.INTERACTIVE_MODE()) CALL ERROR(1)a! 	    DEBUG = CLI$PRESENT('DEBUG')e 	ELSEt 	    LINES(0)(LLEN(0)+1:) = ' ' - 	    CALL SYMBOL_SUBSTITUTE(LINES(0),LLEN(0))m> 	    CALL CLI$DCL_PARSE('MENU '//LINES(0)(1:LLEN(0)),MENU_CLD) 	ENDIF  1 	IF (CLI$PRESENT('SYMBOLS'))     SYMBOLS = .TRUE.p1 	IF (CLI$PRESENT('WIDE'))        WIDE    = .TRUE.g1 	IF (CLI$PRESENT('TEXT'))        TEXT    = .TRUE. 7 	IF (CLI$PRESENT('NOINTERRUPT')) NOINTERRUPT   = .TRUE. - 	IF (CLI$PRESENT('START0'))      START0  = -1e1 	IF (CLI$PRESENT('BOUND'))       BOUND   = .TRUE.   ! 	IF (CLI$PRESENT('INITIAL')) THENr3 	    CALL CLI$GET_VALUE('INITIAL',LINES(1),LLEN(1))i2 	    CALL OTS$CVT_TI_L(LINES(1)(1:LLEN(1)),CHOICE) 	ENDIF  ! 	IF (CLI$PRESENT('POINTER')) THENn/ 	    CALL CLI$GET_VALUE('POINTER',POINTER,PLEN)o3 	    CALL REMOVE_ESCAPE(POINTER(1:PLEN),LINES(1),I)s 	    PLEN2 = I 	ENDIF  9 	IF (CLI$PRESENT('ITEM')) CALL CLI$GET_VALUE('ITEM',ITEM)c  
 	END									i e 	SUBROUTINE PROCESS_TEXT   	IMPLICIT NONE  , 	INTEGER*4 TEXT /0/, TLEN, XROW /0/,XCOL /0/! 	CHARACTER*8 XADDR / '[24;01H' /e 	CHARACTER*80 TEXT_c. 	COMMON /TEXT/ TEXT,TLEN,XROW,XCOL,XADDR,TEXT_  * 	INTEGER*4 XFCOL,XLEN / 0 /, XDELLEN / 1 / 	CHARACTER*16 XDEL /' ' /f' 	COMMON /TEXT2/ XFCOL,XLEN,XDELLEN,XDEL    	CHARACTER*132 SLINES(24)n 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	CHARACTER*1 FROM / '\' /s  & 	CALL CLI$GET_VALUE('TEXT',TEXT_,TLEN) 	IF (TLEN.LT.1) CALL ERROR(4)   	 	TEXT = 0h  	IF (TEXT_(1:1).EQ.'A') TEXT = 1  	IF (TEXT_(1:1).EQ.'C') TEXT = 3  	IF (TEXT_(1:1).EQ.'K') TEXT = 5 	IF (TEXT.EQ.0) CALL ERROR(4)c  ! 	IF (TLEN.GE.2) FROM = TEXT_(2:2)0 	IF (FROM.EQ.' ') CALL ERROR(4)c   	IF (TLEN.GE.3) THEN< 	    XDEL = TEXT_(3:TLEN)	! Background character plus escape% 	    XDELLEN = TLEN - 2		!  sequencest 	ENDIF  F 	CALL REMOVE_ESCAPE(XDEL(1:XDELLEN),TEXT_,TLEN)	! Background character0 	IF (TLEN.NE.1) CALL ERROR(4)			!  in TEXT_(1:1)  ( 	DO WHILE (XCOL.EQ.0 .AND. XROW.LT.MAXL)9 	    XROW = XROW + 1		    ! Screen row of text entry areapG 	    XCOL = INDEX(SLINES(XROW),FROM) ! Screen column of text entry arear 	ENDDO   	IF (XCOL.EQ.0) CALL ERROR(5)   E 	XFCOL = INDEX(LINES(XROW),FROM)	    ! File column of text entry areai  C *	Insert the background character into the file columns, for use inh *	screen paints.  8 	DO WHILE (LINES(XROW)(XFCOL+XLEN:XFCOL+XLEN) .EQ. FROM)4 	    LINES(XROW)(XFCOL+XLEN:XFCOL+XLEN) = TEXT_(1:1)5 	    XLEN = XLEN + 1		    ! Length of text entry areah 	ENDDO  : 	CALL SYS$FAO('[!2UL;!2ULH',,XADDR,%VAL(XROW),%VAL(XCOL))% 	IF (XCOL+XLEN-1.GT.80) CALL ERROR(5)n   	TEXT_ = ' '	 	TLEN = 0F  
 	END									a 	5 	SUBROUTINE REMOVE_ESCAPE(OLDSTRING,NEWSTRING,NEWLEN)r   	IMPLICIT NONE  " 	CHARACTER*(*) OLDSTRING,NEWSTRING 	INTEGER*4 NEWLENd  E *	NOTE -- There is currently no test for incomplete escape sequences.    	INTEGER*4 COL8 	CHARACTER*1 TERM1,ESC /27/, CSI /155/, SO /14/, SI /15/   	NEWLEN = 0R 	COL = 1  $ 10	IF (COL.GT.LEN(OLDSTRING)) RETURN  A 	IF (OLDSTRING(COL:COL).EQ.ESC.OR.OLDSTRING(COL:COL).EQ.'') THENA  , 	    IF (OLDSTRING(COL+1:COL+1).EQ.'[') THEN 		TERM1 = '@'				! 4/0 		COL = COL + 1N	 	    ELSES 		TERM1 = '0'				! 3/0
 	    ENDIF  ) 	ELSE IF (OLDSTRING(COL:COL).EQ.CSI) THENG   	    TERM1 = '@'					! 4/0  ' 	ELSE IF (OLDSTRING(COL:COL).EQ.SO .OR.L& 	1				  OLDSTRING(COL:COL).EQ.SI) THEN 	    COL = COL + 1
 	    GO TO 10f   	ELSEI   	    NEWLEN = NEWLEN + 12 	    NEWSTRING(NEWLEN:NEWLEN) = OLDSTRING(COL:COL)   	    COL = COL + 1
 	    GO TO 10t   	ENDIF   20	COL = COL + 1  % 	IF (OLDSTRING(COL:COL).LT.TERM1 .OR.C, 	1			    OLDSTRING(COL:COL).GT.'~') GO TO 20   	COL = COL + 1  	 	GO TO 10(  
 	END									t  ( 	SUBROUTINE DISPLAY_LINE(LINE_NO,OPTION)   	IMPLICIT NONE   	INTEGER*4 LINE_NO,OPTION3   	CHARACTER*132 SLINES(24)E 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS  ) 	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPTW 	INTEGER*2 PLEN,PLEN2Q 	CHARACTER*32 POINTER! 	CHARACTER*1 ITEMIF 	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEM   	INTEGER*4 L   	L = LLEN(LINE_NO)   	IF (OPTION.NE.0) THEN  9 	    CALL SCREEN('[H[2K'//LINES(LINE_NO)(1:L),LINE_NO)    	ELSET  5 	    CALL SCREEN('[H'//LINES(LINE_NO)(1:L),LINE_NO).   	ENDIF  
 	END									D   	SUBROUTINE DISPLAY_POINTER)   	IMPLICIT NONE  ) 	LOGICAL*4 SYMBOLS,WIDE,DEBUG,NOINTERRUPTA 	INTEGER*2 PLEN,PLEN2T 	CHARACTER*32 POINTERE 	CHARACTER*1 ITEMHF 	COMMON /PARAM/ SYMBOLS,WIDE,DEBUG,NOINTERRUPT,PLEN,PLEN2,POINTER,ITEM   	CHARACTER*132 SLINES(24)  	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	INTEGER*4 CHOICE,START0 	LOGICAL*4 BOUND 	CHARACTER*9 PARKI' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARKX   	CHARACTER*8 PESC / ' ' /! 	CHARACTER*24 BLANKS / ' ' /   	INTEGER*4 LESC,PROW,PCOL,CLEN   	IF (PESC.NE.' ')NA 	1     CALL SCREEN(PESC(1:LESC)//SLINES(PROW)(PCOL:PCOL+PLEN2-1))    	PROW = POINTERS(1,CHOICE)& 	PCOL = POINTERS(2,CHOICE) - PLEN2 + 1  ; 	CALL SYS$FAO('[!UL;!ULH',LESC,PESC,%VAL(PROW),%VAL(PCOL))O  1 	CALL SCREEN(PESC(1:LESC)//POINTER(1:PLEN)//PARK)C  1 	IF (DEBUG) CALL SCREEN('[2D ',CHOICE + START0)1  
 	END										 e 	SUBROUTINE SET_CLOCK    	IMPLICIT NONE   	INTEGER*4   intervalI 	PARAMETER ( interval = 5 )    	CHARACTER*132 SLINES(24)S 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	INTEGER*4 TROW,TCOL 	COMMON /TIME/ TROW,TCOL   	INTEGER*4 SEC   	EXTERNAL CLOCK     	LOGICAL*4 FIRST_CALL / .TRUE. /   	IF (FIRST_CALL) THENE   	    FIRST_CALL = .FALSE.=   	    DO TROW=1,MAXL1  4 		TCOL = INDEX(LINES(TROW)(1:LLEN(TROW)),'00:00:00')   		IF (TCOL.NE.0) GO TO 10	  
 	    ENDDO   	    RETURNS  1 10	    SEC = MOD( IFIX( SECNDS(0.) ) , interval )O  ' 	    CALL TIMER_SET(interval-SEC,CLOCK)p  ( 	    CALL TIME(LINES(TROW)(TCOL:TCOL+7))   	ELSEO  # 	    CALL TIMER_SET(interval,CLOCK)    	ENDIF  
 	END									E 1 	SUBROUTINE CLOCKH   	IMPLICIT NONE   	CHARACTER*132 SLINES(24)S 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	INTEGER*4 CHOICE,START0 	LOGICAL*4 BOUND 	CHARACTER*9 PARKq' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARK)   	INTEGER*4 TROW,TCOL 	COMMON /TIME/ TROW,TCOL   	LOGICAL*4 HELPING 	COMMON /HELP/ HELPING   	CALL SET_CLOCK	  $ 	CALL TIME(LINES(TROW)(TCOL:TCOL+7))  % 	IF (HELPING .AND. TROW.GE.20) RETURNS   	CALL DISPLAY_LINE(TROW,0)   	CALL SCREEN(PARK)  
 	END									  A 	SUBROUTINE TEXTIN(CODE)   	IMPLICIT NONE   	INTEGER*4 CODES   	INTEGER*4 TEXT,TLEN,XROW,XCOL 	CHARACTER*8 XADDR 	CHARACTER*80 TEXT_S. 	COMMON /TEXT/ TEXT,TLEN,XROW,XCOL,XADDR,TEXT_   	INTEGER*4 XFCOL,XLEN,XDELLENC 	CHARACTER*16 XDEL' 	COMMON /TEXT2/ XFCOL,XLEN,XDELLEN,XDELU   	LOGICAL*1 INPUT_READY" 	CHARACTER*1 INPUT_CHAR,INPUT_FLAG1 	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY   	INTEGER*4 CHOICE,START0 	LOGICAL*4 BOUND 	CHARACTER*9 PARKR' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARKR   	CHARACTER*132 SLINES(24)o 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	CHARACTER*80 UP 	CHARACTER*6 ON / '[1;7m' / 	CHARACTER*3 OFF / '[m' / 	INTEGER*4 SAVED_CHOICE,I,COL1- 	INTEGER*4 STATUS,LIB$SET_SYMBOL,OTS$CVT_TI_LU  ' 	IF (CODE.EQ.0) THEN			! DELETE enteredd   	    IF (TLEN.EQ.0) RETURN 	    COL = TLEN + XCOL - 1= 	    CALL SCREEN(XADDR(1:5)//'H'//XDEL(1:XDELLEN)//PARK,COL)E 	    TLEN = TLEN - 1   	    IF (TEXT.EQ.3) GO TO 20 	    IF (TEXT.EQ.5) GO TO 40  . 	ELSE IF (CODE.EQ.1) THEN		! Character entered   	    IF (TLEN.EQ.XLEN) RETURN0 	    IF (TLEN.EQ.0) THEN 		SAVED_CHOICE = CHOICE0 		IF (START0) SAVED_CHOICE = 1
 	    ENDIF# 	    IF (TLEN.EQ.LEN(TEXT_)) RETURNN: 	    IF (TEXT.EQ.5) CALL STR$UPCASE(INPUT_CHAR,INPUT_CHAR) 	    TLEN = TLEN + 1" 	    TEXT_(TLEN:TLEN) = INPUT_CHAR  = 	    CALL SCREEN(XADDR(1:5)//'H'//ON//INPUT_CHAR//OFF//PARK,) 	1						    TLEN+XCOL-1)   	    IF (TEXT.EQ.3) GO TO 20 	    IF (TEXT.EQ.5) GO TO 40  + 	ELSE IF (CODE.EQ.2) THEN		! Screen refreshI  / 	    CALL SCREEN(XADDR//ON//TEXT_(1:TLEN)//OFF)M  ) 	ELSE IF (CODE.EQ.3) THEN		! Program exitM   	    IF (TEXT.NE.1) RETURN  8 	    STATUS = LIB$SET_SYMBOL('ZMENU_TEXT',TEXT_(1:TLEN))3 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))n  , 	ELSE IF (CODE.EQ.4) THEN		! Delete all text   	    IF (TLEN.EQ.0) RETURN  10	    CALL DISPLAY_LINE(XROW,0) 	    TEXT_ = ' '
 	    TLEN = 0E   	ENDIF   	RETURN   O *-----	Text is assumed to be a choice number ----------------------------------'   20	IF (TLEN.EQ.0) THEN 	    CHOICE = SAVED_CHOICE 	ELSE', 	    IF (OTS$CVT_TI_L(TEXT_(1:TLEN),I)) THEN 		I = I - START0" 		IF (I.GE.1 .AND. I.LE.MAXP) THEN 		    CHOICE = I 		ELSE 		    GO TO 30 		ENDIF 	 	    ELSE  30		CHOICE = SAVED_CHOICE 
 		GO TO 10
 	    ENDIF 	ENDIF 	RETURN   O *-----	Text is assumed to be a choice keyword ---------------------------------E   40	IF (TLEN.EQ.0) THEN 	    CHOICE = SAVED_CHOICE 	ELSE  	    DO I=1,MAXP 		COL = POINTERS(2,I) + 1R 		CALL STR$UPCASE(UP(1:TLEN),E- 	1			  SLINES(POINTERS(1,I))(COL+1:COL+TLEN))S' 		IF (TEXT_(1:TLEN).EQ.UP(1:TLEN)) THEN  		    CHOICE = I 		    RETURN 		ENDIF,
 	    ENDDO
 	    GO TO 30C 	ENDIF  
 	END									A T 	SUBROUTINE HELP   	IMPLICIT NONE   	CHARACTER*132 SLINES(24)L 	CHARACTER*200 LINES(0:24). 	INTEGER*2 LLEN(0:24),MAXL,MAXP,POINTERS(2,99)4 	COMMON /LINES/ LLEN,MAXL,SLINES,LINES,MAXP,POINTERS   	LOGICAL*1 INPUT_READY" 	CHARACTER*1 INPUT_CHAR,INPUT_FLAG1 	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READYC   	LOGICAL*4 HELPING / .FALSE. / 	COMMON /HELP/ HELPING 	VOLATILE HELPINGF   	character*1024 buffer 	common /buffer/ buffer    	INTEGER*2 I   	HELPING = .TRUE.C  A 	CALL SCREEN('[20H[J[20;24r[24H[K------------------------'//TA 	1      '------------------------------------------------------')'  ) 	CALL SCREEN('E [7m   H E L P   [m  ')N  7 	CALL SCREEN('Use arrow keys to move the pointer to '//' 	1					    'the desired item.')L  9 	CALL SCREEN('E		Type RETURN, ENTER, DO, or SELECT to'//) 	1					    ' select the item.')   9 	CALL SCREEN('E		Type CONTROL-W to refresh the screen.')'  5 	CALL SCREEN('E		[5;7m Type a blank to return to'//) 	1					       ' the menu. [m')C   	call screen_end   10	CALL GET_TERMINAL_INPUT  7 	IF (INPUT_FLAG.NE.' ' .OR. INPUT_CHAR.NE.' ') GO TO 10C   	call screen_start(buffer)   	DO I=20,24    	    IF (I.LE.MAXL) THEN 		CALL DISPLAY_LINE(I,1)	 	    ELSET 		CALL SCREEN('[H[2K',I) 
 	    ENDIF   	ENDDO   	CALL SCREEN('[1;24r')C   	CALL DISPLAY_POINTER(   	HELPING = .FALSE.  
 	END									P E 	SUBROUTINE ERROR(CODE)    	IMPLICIT NONE   	INTEGER*4 CODE,    	CHARACTER*9 PRE / '%ZMENU-F-' /   	IF (CODE.EQ.1) THEN= 	  CALL LIB$PUT_OUTPUT(PRE//'NONINT, ZMENU must be called '//G- 	1			      'only from INTERACTIVE processes')S 	ELSE IF (CODE.EQ.2) THENI= 	  CALL LIB$PUT_OUTPUT(PRE//'EMPTY, the menu file contains'//C 	1					 ' no lines to display')  	ELSE IF (CODE.EQ.3) THENO? 	  CALL LIB$PUT_OUTPUT(PRE//'INSUFF, the menu contains fewer'// & 	1				   ' than two selectable items') 	ELSE IF (CODE.EQ.4) THENF? 	  CALL LIB$PUT_OUTPUT(PRE//'BADQUAL, invalid /TEXT qualifier')2 	ELSE IF (CODE.EQ.5) THENLA 	  CALL LIB$PUT_OUTPUT(PRE//'TEXT, missing or invalid text area')S 	ELSE IF (CODE.EQ.6) THENA= 	  CALL LIB$PUT_OUTPUT(PRE//'ITEMCOL, the menu contains an'//)4 	1		    ' item marker too close to the left margin') 	ENDIF   	CALL EXIT('10000004'X)X  
 	END									E = 	SUBROUTINE EXIT_.   	IMPLICIT NONE   	INTEGER*4 CHOICE,START0 	LOGICAL*4 BOUND 	CHARACTER*9 PARK2' 	COMMON /UTIL/ CHOICE,START0,BOUND,PARKI  % 	IF (START0 .AND. CHOICE.EQ.1) RETURNL  0 10	CALL INT$SET_SYMBOL('CHOICE',CHOICE + START0)   	CALL TEXTIN(3)u  % 	CALL SCREEN('[?25h[1;24r[23H[m')L  
 	CALL EXIT       	ENTRY ABORT     	CHOICE = 0   0 	CALL SCREEN_FILE(' ')				! Prevent RMS problems  	 	GO TO 10Q  
 	END									M )