 /* **++ **  FACILITY:	MMK  **# **  ABSTRACT:	Object tree routines.  ** **  MODULE DESCRIPTION:  **; **  	This module contains routines that manipulate the tree > **  of objects.  The VMS RTL LIB$xxx_TREE routines are used to! **  create and traverse the tree.  ** **  AUTHOR: 	    M. Madison  **( **  Copyright (c) 2008, Matthew Madison. **   **  All rights reserved. **  F **  Redistribution and use in source and binary forms, with or withoutF **  modification, are permitted provided that the following conditions **  are met: **  > **      * Redistributions of source code must retain the aboveE **        copyright notice, this list of conditions and the following  **        disclaimer. A **      * Redistributions in binary form must reproduce the above E **        copyright notice, this list of conditions and the following I **        disclaimer in the documentation and/or other materials provided   **        with the distribution.F **      * Neither the name of the copyright owner nor the names of anyG **        other contributors may be used to endorse or promote products C **        derived from this software without specific prior written  **        permission.  **  G **  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS E **  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT I **  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR H **  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHTI **  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, D **  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOTI **  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, I **  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY G **  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT I **  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE H **  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ** **  CREATION DATE:  09-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	09-SEP-1992 V1.0    Madison 	Initial coding. ; **  	17-JUL-1995 V1.0-1  Madison 	Fix node_compare routine. 2 **  	27-DEC-1998 V1.1    Madison 	General cleanup. **-- */ #pragma module OBJECTS "V1.1"  #include "mmk.h" #include "globals.h"   /* ** Forward declarations  */5     struct OBJECT      *Find_Object(struct OBJECT *); 4     void            	Insert_Object(struct OBJECT *);I     static int      	node_compare(struct OBJECT *, struct OBJECT *, int); N     static unsigned int node_alloc(char *, struct OBJECT **, struct OBJECT *);  $     static unsigned int objtree = 0;   /* **++ **  ROUTINE:	Find_Object ** **  FUNCTIONAL DESCRIPTION:  **@ **  	Uses LIB$LOOKUP_TREE to locate a group in the tree by name. ** **  RETURNS:	struct OBJECT * ** **  PROTOTYPE: ** **  	Find_Object(char *str)  **= **  str:    character string, read only, by reference (ASCIZ)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  **  	non-0:	group was found  **  	    0:	no group was found ** **  SIDE EFFECTS:   	None. ** **-- */6 struct OBJECT *Find_Object (struct OBJECT *template) {       struct OBJECT *obj;   G     if (!OK(lib$lookup_tree(&objtree, template, node_compare, &obj))) {      	obj = NULL;     }        return obj;    } /* Find_Object */    /* **++ **  ROUTINE:	Insert_Object ** **  FUNCTIONAL DESCRIPTION:  **F **  	Uses LIB$INSERT_TREE to insert an OBJECT structure into the tree. ** **  RETURNS:	void  ** **  PROTOTYPE: **& **  	Insert_Object(struct OBJECT *obj) **2 **  obj:    OBJECT structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */) void Insert_Object (struct OBJECT *obj) {        static int one = 1;      struct OBJECT *tree_node;   6     lib$insert_tree(&objtree, obj, &one, node_compare,,     	    	    	node_alloc, &tree_node, obj);   } /* Insert_Object */    /* **++ **  ROUTINE:	node_compare  ** **  FUNCTIONAL DESCRIPTION:  **@ **  	Comparison routine used by LIB$INSERT_TREE.  Order is basedD **  on type and object name.  For library modules, the "object name"; **  incorporates both the library name and the module name.  ** **  RETURNS:	int ** **  PROTOTYPE: **B **  	node_compare(struct OBJECT *s, struct OBJECT *obj, int dummy) **4 **  s:	    OBJECT structure, read only, by reference5 **  obj:    OBJECT structure, read only, by reference  **  dummy:  not used ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: * **  	    >0:	s is greater than obj->objnam* **  	     0: s equals          obj->objnam* **  	    <0: s is less than    obj->objnam ** **  SIDE EFFECTS:   	None. ** **-- */G static int node_compare (struct OBJECT *s, struct OBJECT *obj, int d) {   ;     if (s->type != obj->type) return (s->type - obj->type);   &     if (s->type == MMK_K_OBJ_LIBMOD) {     	int i; 6     	i = strcmp(s->libfile->name, obj->libfile->name);0     	if (i == 0) i = strcmp(s->name, obj->name);     	return i;     }   &     return strcmp(s->name, obj->name);   } /* node_compare */   /* **++ **  ROUTINE:	node_alloc  ** **  FUNCTIONAL DESCRIPTION:  **A **  	Tree node allocation routine used by LIB$INSERT_TREE.  Since N **  the OBJECT structure we're adding was already allocated by Insert_Object'sH **  caller, we just copy the pointer over so LIB$INSERT_TREE can use it. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **E **  	node_alloc(char *str, struct OBJECT **onode, struct OBJECT *obj)  ** **  str:    	not used B **  onode:  	pointer to OBJECT structure, write only, by reference6 **  obj:    	OBJECT structure, read only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: " **  	SS$_NORMAL: 	Always returned. ** **  SIDE EFFECTS:   	None. ** **-- */W static unsigned int node_alloc (char *str, struct OBJECT **onode, struct OBJECT *obj) {        *onode = obj;      return SS$_NORMAL;   } /* node_alloc */