#include	<descrip.h>			/* VMS descriptors */
#include	<ssdef.h>			/* Define SS$_xxx */
#include	<stdio.h>			/* standard I/O definitions */

enum TLD_TYPES { MSGTYPE = 1,
	MRS , MRN , FSZ , BKS , GBC , FOP , AOP , FALQ,
	DXQ , XALQ, RFO , ATR , LRL , BKZ , HSZ , MRZ, MAX_TLD };

#ifdef __DECC
#pragma message save
#pragma message disable (readonlyext)
#endif
static readonly struct TLD_DEF {
	short	w_type;							/* Type of TLD entry			*/
	short	w_length;						/* Length of TLD entry			*/
	char	*t_name;						/* Descriptive text			*/
} ar_tld_def[] = {
	{ 0	 , 0, "" },
	{ MSGTYPE, 4, "  CNF_C_MSGTYPE: Message type. User flags:                 0x%08X\n"	},
	{ MRS	 , 2, "  CNF_C_MRS:  FAB$W_MRS - Maximum record size:             %d. bytes\n"	},
	{ MRN	 , 4, "  CNF_C_MRN:  FAB$L_MRN - Maximum record number:           %d.\n"	},
	{ FSZ	 , 1, "  CNF_C_FSZ:  FAB$B_FSZ - Fixed length control size:       %d. bytes\n"	},
	{ BKS	 , 1, "  CNF_C_BKS:  FAB$B_BKS - Bucket size:                     %d. blocks\n"	},
	{ GBC	 , 2, "  CNF_C_GBC:  FAB$W_GBC - Global buffer count:             %d.\n"	},
	{ FOP	 , 4, "  CNF_C_FOP:  FAB$L_FOP - File processing options:         0x%08X\n"	},
	{ AOP	 , 1, "  CNF_C_AOP:  XAB$B_AOP(ALL) - Allocation options:         0x%02X\n"	},
	{ FALQ	 , 4, "  CNF_C_FALQ: FAB$L_ALQ - Allocation quantity:             %d. blocks\n"	},
	{ DXQ	 , 2, "  CNF_C_DXQ:  XAB$W_DXQ(ALL) - Default extension:          %d. blocks\n"	},
	{ XALQ	 , 4, "  CNF_C_XALQ: XAB$L_ALQ(ALL) - Allocation quantity:        %d. blocks\n"	},
	{ RFO	 , 1, "  CNF_C_RFO:  XAB$B_RFO(FHC) - Record format/organisation: 0x%02X\n"	},
	{ ATR	 , 1, "  CNF_C_ATR:  XAB$B_ATR(FHC) - Record attributes:          0x%02X\n"	},
	{ LRL	 , 2, "  CNF_C_LRL:  XAB$W_LRL(FHC) - Longest record length:      %d. bytes\n"	},
	{ BKZ	 , 1, "  CNF_C_BKZ:  XAB$B_BKZ(FHC) - Bucket size:                %d. blocks\n"	},
	{ HSZ	 , 1, "  CNF_C_HSZ:  XAB$B_HSZ(FHC) - VFC header size:            %d. bytes\n"	},
	{ MRZ	 , 2, "  CNF_C_MRZ:  XAB$B_MRZ(FHC) - Maximum record length:      %d. bytes\n"	}
};
#ifdef __DECC
#pragma message restore
#endif
	
typedef struct TLD {
	unsigned	w_type	: 16;					/* Type of record			*/
	unsigned	w_length: 16;					/* Length of record			*/
/*	w_length bytes of data		*/
} TLD, *TLD_PTR;

/*****************************************************************************************************************

					D u m p _ T L D

 Dump the internal format of the passed TLD.

*****************************************************************************************************************/

Dump_TLD(
	struct	dsc$descriptor	*ax_tld		)			/* Attribute table			*/
{
	TLD_PTR	a_tld	= (TLD_PTR) ax_tld->dsc$a_pointer;		/* Address of first TLD			*/
	long	length	= ax_tld->dsc$w_length;				/* Length of TLD			*/
	char	*t_format;						/* => Format control string		*/

	if ( length < 4 ) {						/* If no space for any TLD records...	*/
		printf( "  * No attributes passed *\n" );
		return SS$_NORMAL;
	}
	printf( "  Attributes of attached file (analysis of TLD)...\n" );
	while ( length >= 4 ) {						/* While at least 1 TLD left...		*/
		if ( a_tld->w_type && (a_tld->w_type < MAX_TLD) ) {	/* If TLD value is known...		*/
			t_format = ar_tld_def[ a_tld->w_type ].t_name;	/* Save the format control string	*/
			switch ( a_tld->w_length) {
				case 1:
					printf( t_format, (unsigned char) * (unsigned char *) (((char *) a_tld) + 4) );
					break;
				case 2:
					printf( t_format, (unsigned short) * (unsigned short *) (((char *) a_tld) + 4) );
					break;
				case 4:
					printf( t_format, (unsigned long) * (unsigned long *) (((char *) a_tld) + 4) );
					break;
				default:
					printf( "* Unknown TLD length %d.\n", a_tld->w_length );
					printf( "* TLD: %s", t_format );
					break;
			}
		} else {
			printf( "* Unknown TLD Type: %d., Length: %d. *\n", a_tld->w_type, a_tld->w_length );
		}
		a_tld = (TLD_PTR) (((char *) a_tld) + a_tld->w_length + 4);
		length -= (a_tld->w_length + 4);
	}
	return SS$_NORMAL;						/* Return success to caller		*/

}
