= ;;   This is the GNU EMACS interface to GNU ISPELL version 4. < ;;   Copyright (C) 1990, 1993 Free Software Foundation, Inc. ;;% ;;   This file is part of GNU ISPELL.  ;;I ;;   This program is free software; you can redistribute it and/or modify I ;;   it under the terms of the GNU General Public License as published by H ;;   the Free Software Foundation; either version 2, or (at your option) ;;   any later version.  ;;D ;;   This program is distributed in the hope that it will be useful,C ;;   but WITHOUT ANY WARRANTY; without even the implied warranty of B ;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 ;;   GNU General Public License for more details.  ;;F ;;   You should have received a copy of the GNU General Public License@ ;;   along with this program; if not, write to the Free Software> ;;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   (defvar ispell-have-new-look t1   "T if default 'look' program has the -r flag.")   $ (defvar ispell-enable-tex-parser nilC   "T to enable experimental tex parser in ispell for tex buffers.")   8 (defvar ispell-process nil "The process running ISPELL")   (defvar ispell-next-message nil 8   "An integer telling where in the *ispell* buffer where7 to look for the next message from the ISPELL program.")   < ;Each marker in this list points to the start of a word that; ;ispell thought was bad last time it did the :file command. ; ;Notice that if the user accepts or inserts a word into his @ ;private dictionary, then some "good" words will be on the list.J ;We would like to deal with this by looking up the words again just before> ;presenting them to the user, but that is too slow on machines= ;without the select system call.  Therefore, see the variable  ;ispell-recently-accepted. (defvar ispell-bad-words nilO   "A list of markers corresponding to the output of the ISPELL :file command.")   ? ;list of words that the user has accepted, but that might still  ;be on the bad-words list % (defvar ispell-recently-accepted nil)    ;t when :dump command needed (defvar ispell-dump-needed nil)     (defun ispell-flush-bad-words ()   (while ispell-bad-words (     (if (markerp (car ispell-bad-words))0         (set-marker (car ispell-bad-words) nil))3     (setq ispell-bad-words (cdr ispell-bad-words))) &   (setq ispell-recently-accepted nil))   (defun kill-ispell () C   "Kill the ispell process.  Any changes the your private dictionay 0 that have not already been dumped will be lost."   (interactive)    (if ispell-process&       (delete-process ispell-process))   (setq ispell-process nil)    (ispell-flush-bad-words))   , (put 'ispell-startup-error 'error-conditions#      '(ispell-startup-error error)) ) (put 'ispell-startup-error 'error-message 5      "Problem starting ispell - see buffer *ispell*")    (defun start-ispell ()L   "Start an ispell subprocess; check the version; and display the greeting."!   (message "Starting ispell ...") &   (let ((buf (get-buffer "*ispell*")))     (if buf  	(kill-buffer buf)))   (condition-case err        (setq ispell-process0 	    (start-process "ispell" "*ispell*" "ispell"# 			   (if (eq system-type 'vax-vms)  			       "\"-S\"" "-S")))4     (file-error (signal 'ispell-startup-error nil)))-   (process-kill-without-query ispell-process) 5   (buffer-flush-undo (process-buffer ispell-process)) (   (accept-process-output ispell-process)   (let (last-char)     (save-excursion 2       (set-buffer (process-buffer ispell-process))$       (bury-buffer (current-buffer))(       (setq last-char (- (point-max) 1))1       (while (not (eq (char-after last-char) ?=)) 7 	(cond ((not (eq (process-status ispell-process) 'run))  	       (kill-ispell) , 	       (signal 'ispell-startup-error nil)))' 	(accept-process-output ispell-process) $ 	(setq last-char (- (point-max) 1)))       (goto-char (point-min)) /       (let ((greeting (read (current-buffer))))  	(if (not (= (car greeting) 1)) C 	    (error "Bad ispell version: wanted 1, got %d" (car greeting)))   	(message (car (cdr greeting)))).       (delete-region (point-min) last-char))))   , ;leaves buffer set to *ispell*, point at '=' (defun ispell-sync (intr) ,   "Make sure ispell is ready for a command."   (if (or (null ispell-process) 3 	  (not (eq (process-status ispell-process) 'run)))        (start-ispell)) 0   (if (and intr (not (eq system-type 'vax-vms))))       (interrupt-process ispell-process))    (let (last-char)0     (set-buffer (process-buffer ispell-process))"     (bury-buffer (current-buffer))&     (setq last-char (- (point-max) 1))/     (while (not (eq (char-after last-char) ?=)) ,       (accept-process-output ispell-process))       (setq last-char (- (point-max) 1)))      (goto-char last-char)))   ! (defun ispell-cmd (&rest strings) *   "Send a command to ispell.  Choices are:  2 word		any word is checked for spelling.  Result is   			nil			not found 			t			spelled ok  			list of strings		near misses   A :file filename	scan the named file, and print the file offsets of  		any misspelled words  * :insert word	put word in private dictonary  < :accept word	don't complain about word any more this session  > :dump		write out the current private dictionary, if necessary.   :reload		reread ~/ispell.words   :tex :troff< :generic	set type of parser to use when scanning whole files "    (save-excursion      (ispell-sync t) 0     (set-buffer (process-buffer ispell-process))"     (bury-buffer (current-buffer))     (erase-buffer)*     (setq ispell-next-message (point-min))     (while strings8       (process-send-string ispell-process (car strings))#       (setq strings (cdr strings))) -     (process-send-string ispell-process "\n") *     (accept-process-output ispell-process)     (ispell-sync nil)))    (defun ispell-dump ()    (cond (ispell-dump-needed  	 (setq ispell-dump-needed nil)  	 (ispell-cmd ":dump"))))    (defun ispell-insert (word)    (ispell-cmd ":insert " word)   (if ispell-bad-wordsK       (setq ispell-recently-accepted (cons word ispell-recently-accepted)))    (setq ispell-dump-needed t))   (defun ispell-accept (word)    (ispell-cmd ":accept " word)   (if ispell-bad-wordsL       (setq ispell-recently-accepted (cons word ispell-recently-accepted))))     (defun ispell-next-message () :   "Return the next message sent by the ispell subprocess."   (save-excursion 0     (set-buffer (process-buffer ispell-process))"     (bury-buffer (current-buffer))     (save-restriction %       (goto-char ispell-next-message)        (narrow-to-region (point) 9                         (progn (forward-sexp 1) (point))) (       (setq ispell-next-message (point))       (goto-char (point-min))         (read (current-buffer)))))   (defun ispell-tex-buffer-p () 1   (memq major-mode '(plain-TeX-mode LaTeX-mode)))   ' (defun ispell (&optional buf start end) @   "Run ispell over a buffer.  (Actually over the buffer's file.); First the file is scanned for misspelled words, then ispell D enters a loop with the following commands for every misspelled word:  ? DIGIT	Near miss selector.  If the misspelled word is 'close' to ? 	some words in the dictionary, they are offered as near misses. ? r	Replace.  Replace the word with a string you type.  Each word $ 	of your new string is also checked.> i	Insert.  Insert this word in your private dictonary (kept in 	$HOME/ispell.words)A a	Accept.  Accept this word for the rest of this editing session, -  	but don't put it in your private dictonary. ; l	Lookup.  Look for a word in the dictionary by fast binary = 	search, or search for a regular expression in the dictionary  	using grep.B SPACE	Accept the word this time, but complain if it is seen again.N q, C-G	Leave the command loop.  You can come back later with \\[ispell-next]."   (interactive)    (if (null start)       (setq start 0))    (if (null end)       (setq end 0))      (if (null buf)"       (setq buf (current-buffer)))   (setq buf (get-buffer buf))    (if (null buf)"       (error "Can't find buffer"))   (save-excursion      (set-buffer buf)%     (let ((filename buffer-file-name)            (delete-temp nil))       (unwind-protect 	 	  (progn  	    (cond ((null filename)e" 		   (if (eq system-type 'vax-vms)> 		       (setq filename (make-temp-name "sys$scratch:ispell")): 		     (setq filename (make-temp-name "/usr/tmp/ispell"))) 		   (setq delete-temp t)t5 		   (write-region (point-min) (point-max) filename))n! 		  ((and (buffer-modified-p buf)b1 			(y-or-n-p (format "Save file %s? " filename)))e 		   (save-buffer)))( 	    (message "Ispell scanning file...")& 	    (if (and ispell-enable-tex-parser 		     (ispell-tex-buffer-p))w 		(ispell-cmd ":tex")t 	      (ispell-cmd ":generic"))e? 	    (ispell-cmd (format ":file %s %d %d" filename start end)))          (if delete-tempt             (condition-case ()&                 (delete-file filename)"               (file-error nil))))))     (message "Parsing ispell output ...")s     (ispell-flush-bad-words)     (let (pos bad-words)7       (while (numberp (setq pos (ispell-next-message)))d; 	;;ispell may check the words on the line following the endh@ 	;;of the region - therefore, don't record anything out of range 	(if (or (= end 0) 		(< pos end))? 	    (setq bad-words (cons (set-marker (make-marker) (+ pos 1))c 				  bad-words)))) +       (setq bad-words (cons pos bad-words))e4       (setq ispell-bad-words (nreverse bad-words))))/   (cond ((not (markerp (car ispell-bad-words)))  	 (setq ispell-bad-words nil)o 	 (message "No misspellings."))  	(tl" 	 (message "Ispell parsing done.") 	 (ispell-next))))   (defun ispell-next ()a7   "Resume command loop for most recent ispell command."t   (interactive)o   (unwind-protectl       (catch 'quit 	(save-window-excursionk 	  (save-excursion 	    (let (next): 	      (while (markerp (setq next (car ispell-bad-words)))) 		(switch-to-buffer (marker-buffer next))r
 		(push-mark)a* 		(ispell-point next "at saved position.")0 		(setq ispell-bad-words (cdr ispell-bad-words)) 		(set-marker next nil))))))"     (cond ((null ispell-bad-words)+ 	   (error "Ispell has not yet been run.")) $ 	  ((markerp (car ispell-bad-words))% 	   (message (substitute-command-keys =                        "Type \\[ispell-next] to continue."))) # 	  ((eq (car ispell-bad-words) nil)  	   (setq ispell-bad-words nil) D 	   (message "No more misspellings (but checker was interrupted.)"))! 	  ((eq (car ispell-bad-words) t)w 	   (setq ispell-bad-words nil)  	   (message "Ispell done."))n 	  (t  	   (setq ispell-bad-words nil)h+ 	   (message "Bad ispell internal list"))))t   (ispell-dump))     (defun ispell-word ()eA   "Check the spelling of the word under the cursor.  See 'ispell'l for more documentation."   (interactive)l   (condition-case errl       (catch 'quit 	(save-window-excursione& 	  (ispell-point (point) "at point.")) 	(ispell-dump)))     (ispell-startup-errorrO      (cond ((y-or-n-p "Problem starting ispell, use old-style spell instead? ")f 	    (load-library "spell")a) 	    (define-key esc-map "$" 'spell-word)  	    (spell-word))))))  * (defun ispell-region (start &optional end):   "Check the spelling for all of the words in the region."   (interactive "r")s&   (ispell (current-buffer) start end))   (defun ispell-letterp (c)p   (and c$        (or (and (>= c ?A) (<= c ?Z)) 	   (and (>= c ?a) (<= c ?z))) 	   (>= c 128))))s  " (defun ispell-letter-or-quotep (c)   (and c$        (or (and (>= c ?A) (<= c ?Z)) 	   (and (>= c ?a) (<= c ?z))f 	   (= c ?') 	   (>= c 128))))r    (defun ispell-find-word-start ()   ;;backward to a letter1   (if (not (ispell-letterp (char-after (point))))p       (while (and (not (bobp))6 		  (not (ispell-letterp (char-after (- (point) 1))))) 	(backward-char)))!   ;;backward to beginning of word(=   (while (ispell-letter-or-quotep (char-after (- (point) 1)))      (backward-char))   (skip-chars-forward "'"))o   (defun ispell-find-word-end ()7   (while (ispell-letter-or-quotep (char-after (point)))      (forward-char))-   (skip-chars-backward "'"))   (defun ispell-next-word ()   (while (and (not (eobp))3 	      (not (ispell-letterp (char-after (point)))))"     (forward-char)))  ) ;if end is nil, then do one word at start-= ;otherwise, do all words from the beginning of the word wherep6 ;start points, to the end of the word where end points# (defun ispell-point (start message)    (let ((wend (make-marker)) 	rescano 	end)p     (save-excursionp       (goto-char start)s8       (ispell-find-word-start)		;find correct word start!       (setq start (point-marker))p3       (ispell-find-word-end)		;now find correct endp       (setq end (point-marker))        (if (>= start end)  	  (error "No word %s" message))       (while (< start end) 	(goto-char start)2 	(ispell-find-word-end)		;find end of current word 					;could be before 'end' if 					;user typed replacement  					;that is more than one word 	(set-marker wend (point)) 	(setq rescan nil)* 	(setq word (buffer-substring start wend))' 	(if (and ispell-precheck-word-function	 		 (save-excursion* 		   (apply ispell-precheck-word-function  			  (list word start end))))e 	    nil! 	  (cond ((ispell-still-bad word) < 		 (goto-char start)	;just to show user where we are working 		 (sit-for 0)/ 		 (message (format "Ispell checking %s" word))  		 (ispell-cmd word)) 		 (let ((message (ispell-next-message)))  		   (cond ((eq message t) 			  (message "%s: ok" word))s 			 ((or (null message)w 			      (consp message))  			  (setq rescan 3 				(ispell-command-loop word start wend message)))e 			 (t7 			  (error "unknown ispell response %s" message)))))))e 	(cond ((null rescan)e 	       (goto-char wend) 	       (ispell-next-word)% 	       (set-marker start (point)))))cJ       ;;clear the choices buffer; otherwise it's hard for the user to tell,       ;;when we get back to the command loop2       (let ((buf (get-buffer "*ispell choices*"))) 	(cond (bufu 	       (set-buffer buf) 	       (erase-buffer))))d       (set-marker start nil)       (set-marker end nil)       (set-marker wend nil))))  8 (defvar ispell-precheck-word-function 'ispell-word-isTeXK   "*Function to test validity of word before asking ispell for suggestions.dN For example, ispell-word-isTeX passes TeX commands and various other TeX forms& so they are not marked as incorrect.")  ) (defun ispell-word-isTeX (word start end)lD   "Function to call to test word validity before ispell looks at it.I This function passes all TeX commands as well as the following TeX forms:e6     \ref{anything}, \cite{anything}, \label{anything},$     \begin{anything}, \end{anything}) Math equations will most likely not pass. - Comment lines are also checked for spelling."    (if (ispell-tex-buffer-p)1+       (if (= (char-after (- start 1)) ?\\ ) * 	  (message "\\%s: ok (TeX command)" word)C 	;; These are invalid characters in a LaTeX \ref, \cite, and \labelm- 	(skip-chars-backward "^ \t\n\r\f(){}[]\\\\") , 	(if (or (= (char-after (- (point) 1)) ?\{ )& 		(= (char-after (- (point) 1)) ?\[ )) 	    (progn' 	      (forward-char -1)% 	      (skip-chars-backward "a-zA-Z")p3 	      (if (and (= (char-after (- (point) 1)) ?\\ )v 		       (or (looking-at "ref")r 			   (looking-at "cite")s 			   (looking-at "begin") 			   (looking-at "end") 			   (looking-at "label")))3 		  (message "%s: ok (TeX command arg)" word)))))))y    (defun ispell-still-bad (word)(   (let ((words ispell-recently-accepted) 	(ret t) 	(case-fold-search t))     (while words3       (cond ((eq (string-match (car words) word) 0)e 	     (setq ret nil) 	     (setq words nil)))       (setq words (cdr words)))o	     ret))   4 (defun ispell-show-choices (word message first-line)>   ;;if there is only one window on the screen, make the ispellA   ;;messages winow be small.  otherwise just use the other windowi#   (let* ((selwin (selected-window))o$ 	 (resize (eq selwin (next-window))). 	 (buf (get-buffer-create "*ispell choices*")) 	 w)!     (setq w (display-buffer buf))      (buffer-flush-undo buf)n     (if resize 	(unwind-protect 	    (progn  	      (select-window w)0 	      (enlarge-window (- 6 (window-height w)))) 	  (select-window selwin)))      (save-excursion        (set-buffer buf)       (bury-buffer buf)d&       (set-window-point w (point-min))&       (set-window-start w (point-min))       (erase-buffer)       (insert first-line "\n")
       (insert-@        "SPC skip; A accept; I insert; DIGIT select; R replace; \ L lookup; Q quit\n")!       (cond ((not (null message))	 	     (let ((i 0)) 	       (while (< i 3) 		 (let ((j 0))n 		   (while (< j 3)b 		     (let* ((n (+ (* j 3) i))f  			    (choice (nth n message))) 		       (cond (choice/ 			      (let ((str (format "%d %s" n choice)))l 				(insert str), 				(insert-char ?  (- 20 (length str))))))) 		     (setq j (+ j 1))))c 		 (insert "\n") 		 (setq i (+ i 1)))))))))  3 (defun ispell-command-loop (word start end message)e   (let ((flag t)
 	(rescan nil)s 	first-line)     (if (null message); 	(setq first-line (concat "No near misses for '" word "'"))s>       (setq first-line (concat "Near misses for '" word "'")))     (while flag 3       (ispell-show-choices word message first-line))"       (message "Ispell command: ")&       (let ((c (downcase (read-char))) 	    replacement)  	(cond ((and (>= c ?0) 		    (<= c ?9)(0 		    (setq replacement (nth (- c ?0) message))). 	       (ispell-replace start end replacement) 	       (setq flag nil)) 	      ((= c ?q) 	       (throw 'quit nil)) 	      ((= c ? ) 	       (setq flag nil)) 	      ((= c ?r)@ 	       (ispell-replace start end (read-string "Replacement: ")) 	       (setq rescan t)i 	       (setq flag nil)) 	      ((= c ?i) 	       (ispell-insert word) 	       (setq flag nil)) 	      ((= c ?a) 	       (ispell-accept word) 	       (setq flag nil)) 	      ((= c ?l)* 	       (let ((val (ispell-do-look word))) 		 (setq first-line (car val)) 		 (setq message (cdr val))))p 	      ((= c ??) 	       (message= 		"Type 'C-h d ispell' to the emacs main loop for more help")	 	       (sit-for 2))	 	      (tt& 	       (message "Bad ispell command") 	       (sit-for 2)))))m     rescan))    (defun ispell-do-look (bad-word)   (let (regex buf words)&     (cond ((null ispell-have-new-look)* 	   (setq regex (read-string "Lookup: "))) 	  (tc7 	   (setq regex (read-string "Lookup (regex): " "^"))))]2     (setq buf (get-buffer-create "*ispell look*"))     (save-excursionl       (set-buffer buf)-       (delete-region (point-min) (point-max))n       (if ispell-have-new-look/ 	  (call-process "look" nil buf nil "-r" regex)l) 	(call-process "look" nil buf nil regex)) I       ;; VMS call-process spits out an extra newline, which ispell thinks)<       ;; is another word.  So here we eat the extra newline.#       (if (eq system-type 'vax-vms)r1 	  (delete-region (- (point-max) 1) (point-max)))r       (goto-char (point-min))l       (forward-line 10)a)       (delete-region (point) (point-max))n       (goto-char (point-min))).       (while (not (= (point-min) (point-max))) 	(end-of-line)A 	(setq words (cons (buffer-substring (point-min) (point)) words))y 	(forward-line)(% 	(delete-region (point-min) (point)))        (kill-buffer buf)d(       (cons (format "Lookup '%s'" regex) 	    (reverse words)))))     % (defun ispell-replace (start end new)i   (goto-char start)c   (insert new)   (delete-region (point) end))   (defun reload-ispell ()(3   "Tell ispell to re-read your private dictionary."c   (interactive)    (ispell-cmd ":reload"))e  % (define-key esc-map "$" 'ispell-word)(' (define-key ctl-x-map "$" 'ispell-next)?   (defun batch-make-ispell () "   (byte-compile-file "ispell.el"))K   ;; Don't do this anymore, because it should be determined by the MakefileaJ   ;; whether it is necessary (by default it shouldn't be).  Also, makeinfo*   ;; is more robust.  --friedman 31-May-93   ;(find-file "ispell.texinfo")f$   ;(let ((old-dir default-directory)   ;	(default-directory "/tmp"))    ;  (texinfo-format-buffer))h   ;(Info-validate).   ;(if (get-buffer " *problems in info file*")   ;    (kill-emacs 1))8   ;(write-region (point-min) (point-max) "ispell.info"))