  #pragma module pppd$asnvci "X-6" /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     6   		This module contains a the VCI rotuines. They are:  # 		VCI$ASN_Create_Port	-	Create port ' 		VCI$ASN_Delete_Port	-	Delete the port : 		VCI$ASN_Transmit_Initiate - 	Set up and start a transmit: 		VCI$ASN_PortMgmt_Synch	-	Perform set and sense functions     	AUTHOR:   $ 		Forrest A. Kenney	23-February-1996    	REVISION HISTORY:  , 	X-6	FAK004		Forrest A. Kenney	07-March-1997< 		Remove the acquisition of the device lock before seeing if; 		we have an outstanding write.  Just check the write state A 		and if we have a write queued.  If not then start the write if  9 		so queue the request.  Also remove the check for state  = 		MULTI we can start a write as nothing will go out until we   		are clear of state multi.    0 	X-5	BWK001		Barry W. Kierstein	17-December-1996. 		Replaced the standard Digital copyright with( 		one compatible with the CMU copyright.  0 	X-4	FAK003		Forrest A. Kenney	28-September-1996@ 		In VCI$ASN_PortMgmt_Synch make sure we fill in the VCRP status 		on a get if it is success.  + 	X-3	FAK002		Forrest A. Kenney	27-June-1996 1 		Clean up module headers.  Beef up the logic in  > 		VCI$ASN_Delete_Port so that we know the device is truly idle5 		before we diassociate ourselves from the upper VCM.   -   	X-2	FAK001		Forrest A. Kenney	20-June-1996 A   		In VCI$ASN_PortMgmt_Synch set assume success when starting on @ 		first item in the item list.  Also clean up some status tests.   */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ : #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 6 #include	<descrip.h>	/* VMS descriptor definitions		*/7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ 9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ 1 #include	<iocdef.h>	/* I/O routines constants		*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 6 #include	<sbdef.h>	/* System data block definitions	*/3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 5 #include	<ttdef.h>	/* Terminal definitions TT$xxx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.    = /* Define ASN specific data structures types and constants */ 1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/> #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */        /* **++$ **	VCI$ASN_Create_Port - Create port ** ** Functional description: **? **	The upper VCM calls this routine to create a new port.  The  % ** code performs the following steps:  **- **	Fills in the routine addresses in the VCIB  ** ** Calling convention: **9 **	int             VCI$ASN_Create_Port (ASNVCIB *asnvcib)  ** ** Input parameters: **- **	VCIB			pointer to the VCIB to be completed  ** ** Output parameters:  **" **	VCIB			various fields filled in ** ** Return value: **' **	SS$_NORMAL	Everything went just fine F **	SS$_DEVINACT	Device is scheduled for deletion or is not bound to a  **			physical device ** ** Environment:  **, **	Kernel mode IPL 8 with the fork lock held ** **-- */) int	VCI$ASN_Create_Port(ASNVCIB *asnvcib)  {      int		saved_fipl; int		status = SS$_NORMAL;        ASNUCB		*asnucb; TTY_UCB		*phyucb;   - asnucb = (ASNUCB *) asnvcib->vcib$ps_asn_ucb;   " if ((void *) asnucb != (void *) 0) { '    if ((!asnucb->ucb$v_asn_delpend) &&  >        ((void *)asnucb->ASNLOG.ucb$l_tl_phyucb != (void *) 0))    {U       asnvcib->vcib$r_vcibdef.vcib$a_portmgmt_synch = (int *) VCI$ASN_PortMgmt_Synch; [       asnvcib->vcib$r_vcibdef.vcib$a_transmit_initiate = (int *) VCI$ASN_Transmit_Initiate; ;       asnvcib->vcib$r_vcibdef.vcib$a_portmgmt_initiate = 0; ;       asnvcib->vcib$r_vcibdef.vcib$a_portmgmt_complete = 0; 7       asnvcib->vcib$r_vcibdef.vcib$a_control_synch = 0; :       asnvcib->vcib$r_vcibdef.vcib$a_control_initiate = 0;:       asnvcib->vcib$r_vcibdef.vcib$a_control_complete = 0;0       asnucb->ucb$l_asn_vcib = (void *) asnvcib;    }    else     {       status = SS$_DEVINACT;    } }  else {     status = SS$_DEVINACT;  }    return status;   }        /* **++( **	VCI$ASN_Delete_Port - Delete the port ** ** Functional description: **J **	The delete port routine is called by an upper VCM to delete a port.  It! ** does the following operations:  **= **		1) Makes sure delete port has not already been called if  ( **		   alread called return SS$_DEVINACT, **		2) Zeros the entry points to this driver- **		3) Zeros the UCB field and the name field A **		4) Calls the rotuine that gets the ASN UCB ready for deletion  ** ** N.B. I **	The assumtion here is that once this routine has been called that the  J ** UCB will never be used again.  All that is waiting is to make sure the 2 ** device is truly unused and then it will vanish. ** ** Calling convention: **- **	int	VCI$ASN_Delete_Port (ASNVCIB *asnvcib)  ** ** Input parameters: ** **	asnvcib		Pointer to ASNVCIB ** ** Output parameters:  ** **	None  ** ** Return value: **' **	SS$_NORMAL	Everything went just fine ! **	SS$_DEVINACT	Already been here F **	SS$_OPINCOIMPL	Cannot set device up for deletion is I/O outstanding ** ** Environment:  **, **	Kernel mode IPL 8 with the fork lock held ** **-- */) int	VCI$ASN_Delete_Port(ASNVCIB *asnvcib)  {    int		saved_fipl; int		status = SS$_NORMAL;    ASNUCB		*asnucb; TTY_UCB		*phyucb;     - asnucb = (ASNUCB *) asnvcib->vcib$ps_asn_ucb; " if ((void *) asnucb != (void *) 0) { C    device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_fipl); 	       /*  F        *	We need to check the write flag under device IPL as it could M        * change while we are looking at it.  We also need to make sure there  N        * are no completion threads queued, or any I/O on the write queue.  If P        * we return an SS$_OPINCOMPL the upper VCM should call us again later to         * be deleted.  H        * Note:		 That if it is safe after this test dropping the device D        *	lock is OK.  The fork lock is sufficient to prevent any new'        *	activity from getting started.         *       */:       phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;(       if ((void *) phyucb != (void *) 0)       { $          if (phyucb->tty$v_st_write)          {               !             return SS$_OPINCOMPL; 
          }       }   F    device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_fipl, SMP_RESTORE);  +    if ((asnucb->ucb$l_asn_fork_cnt == 0) && E        (asnucb->ucb$l_asn_writeq_bl == &asnucb->ucb$l_asn_writeq_fl))     {!       asnucb->ucb$l_asn_vcib = 0; 8       asnvcib->vcib$r_vcibdef.vcib$a_portmgmt_synch = 0;;       asnvcib->vcib$r_vcibdef.vcib$a_transmit_initiate = 0; #       asnvcib->vcib$ps_asn_ucb = 0; %       asn$prepare_for_delete(asnucb);     }    else     {       status = SS$_OPINCOMPL;     } }  else {     status = SS$_DEVINACT;  }    return status;   }        /* **++: **	VCI$ASN_Transmit_Initiate - Set up and start a transmit ** ** Functional description: **G **	This routine is responsible for starting a packet transmission.  It    ** performs the following steps. **? **		1) If needed computes a FCS and addes it to the end of the  
 **		   buffer B **		2) If the device is still bound to a port it checks to see if ! **		   the packet can be sent now B **		3) If it cannot be sent now it queues the packet to the write  **		   queue ** ** Calling convention: **? **	int	VCI$ASN_Transmit_Initiate (VCRP *vcrp, ASNVCIB *asnvcib)  ** ** Input parameters: ** **	vcrp		pointer to the VCRP **	vcib		pointer to the VCIB ** ** Output parameters:* ** **	None* ** ** Return value: ** **	SS$_NORMAL	Packet queuedo/ **	SS$_BADPARAM	Buffer was to small or to larges0 **	SS$_BUFFEROVF	Buffer larger than transmit MTU1 **	SS$_DEVINACT	Device is not bound to a terminalc ** ** Environment:a **8 **	Kernel mode IPL 8 with the ASN devices fork lock held ** **-- */; int	VCI$ASN_Transmit_Initiate(VCRP *vcrp, ASNVCIB *asnvcib)r {t   char		*buffer;   unsigned int	fcs;r int		saved_fipl; int		status;   ASNUCB		*asnucb; TTY_UCB		*phyucb;       - asnucb = (ASNUCB *) asnvcib->vcib$ps_asn_ucb;e" if ((void *) asnucb != (void *) 0) {r7    phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;TI    if ((!(asnucb->ucb$v_asn_delpend)) && ((void *) phyucb != (void *) 0))E    {4       buffer = (char *) vcrp->vcrp$l_buffer_address;:       if ((vcrp->vcrp$l_bcnt <= asnucb->ucb$l_asn_mtu) && 1           (vcrp->vcrp$l_bcnt + 4 >= MINIMUM_MTU))*       {*N          vcrp->vcrp$l_bcnt = asn$fcs_compute(asnucb, (unsigned char *) buffer,@                                              vcrp->vcrp$l_bcnt);9          vcrp->vcrp$l_total_pdu_size = vcrp->vcrp$l_bcnt;e*          if ((!phyucb->tty$v_st_write) && \              ((void *) asnucb->ucb$l_asn_writeq_bl == (void *) asnucb->ucb$l_asn_writeq_fl))
          {C             status = asn$write_start(asnucb, phyucb, (IRP *) vcrp);X'             if (!(status & SS$_NORMAL))7
             {a4                vcrp->vcrp$q_request_status = status;8                VCI$XXX_Transmit_Complete(vcrp, asnvcib);
             }a
          }
          else 
          {O             __PAL_INSQUEL((void *) asnucb->ucb$l_asn_writeq_bl, (void *) vcrp);c
          }
       }       
       else       {           status = SS$_BADPARAM; .          vcrp->vcrp$q_request_status = status;2          VCI$XXX_Transmit_Complete(vcrp, asnvcib);       }p    }    else     {       status = SS$_DEVINACT;+       vcrp->vcrp$q_request_status = status;P/       VCI$XXX_Transmit_Complete(vcrp, asnvcib);s    } }g else {i    status = SS$_DEVINACT;F(    vcrp->vcrp$q_request_status = status;,    VCI$XXX_Transmit_Complete(vcrp, asnvcib); }S   return status;   }e         /* **++; **	VCI$ASN_PortMgmt_Synch - Perform set and sense functionsV ** ** Functional description: **D **	This routine is called by the upper VCM to perform set and sense L ** operations on the ASN device and it's associated physical terminal.  The N ** routine always completes syncronously is simply determines if the item listN ** length is a multiple of 12.  If the list length is incorrect it will returnN ** SS$_BADPARAM.  The it will loop through the list one item at a time callingL ** the correct routine.  If any item fails the first longword of the status N ** will be the failure reason, and the second longword of the status will haveD ** the failing item.  Once any item fails processing will terminate. ** ** Calling convention: **< **	int	VCI$ASN_PortMgmt_Synch (VCRP *vcrp, ASNVCIB *asnvcib) ** ** Input parameters: ** **	vcib		pointer to the vcib **	vcrp		pointer tot he vcrp ** ** Output parameters:h **I **	On a sense the various items of data will be returned to the user.  Oni3 ** set various fields in the UCB will be filled in.d **D **	VCRP$Q_REQUEST_STATIS	filled in with several possible completion / **				status values.  SS$_NORMAL, SS$_BADPARAM,i **				SS$_DEVINACT. etc. ** ** Return value: ** **	SS$_NORMAL always ** ** Environment:t **8 **	Kernel mode IPL 8 with the ASN devices fork lock held ** **-- */8 int	VCI$ASN_PortMgmt_Synch(VCRP *vcrp, ASNVCIB *asnvcib) {/   char		*buffer; char		*buffer_end;   int		saved_fipl; int		status= SS$_NORMAL;   ASNRD		*asnrd; ASNUCB		*asnucb; TTY_UCB		*phyucb;   - asnucb = (ASNUCB *) asnvcib->vcib$ps_asn_ucb;k" if ((void *) asnucb != (void *) 0) {o7    phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;uI    if ((!(asnucb->ucb$v_asn_delpend)) && ((void *) phyucb != (void *) 0))o    {       :       if (vcrp->vcrp$l_function == VCRP$K_FC_DISABLE_PORT)       {fI          device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_fipl);t#             asn$input_stop(asnucb);eL          device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_fipl, SMP_RESTORE);2          vcrp->vcrp$q_request_status = SS$_NORMAL;       } >       else if (vcrp->vcrp$l_function == VCRP$K_FC_ENABLE_PORT)       {dJ          vcrp->vcrp$q_request_status = asn$enable_receive(asnucb, phyucb);       } 6       else if (vcrp->vcrp$l_function == VCRP$K_FC_GET)       {d3          buffer = (char *) vcrp->vcrp$a_input_list;P[          buffer_end = (char *) vcrp->vcrp$a_input_list +  vcrp->vcrp$t_mgmt_information[0]; D          if ((vcrp->vcrp$t_mgmt_information[0]%sizeof(LSTITM)) == 0)
          {B             while ((buffer < buffer_end) && (status & SS$_NORMAL))
             {dO                status = asn$do_sense_item(asnucb, (LSTITM *) buffer, NO_PROBE);c'                if (status & SS$_NORMAL)o                {+                   buffer += sizeof(LSTITM);A7                   vcrp->vcrp$q_request_status = status;o                }                elset                {R                   vcrp->vcrp$q_request_status = (((uint64)buffer << 32) | status);                }
             }l
          }
          elset
          {7             vcrp->vcrp$q_request_status = SS$_BADPARAM;r
          }       }	6       else if (vcrp->vcrp$l_function == VCRP$K_FC_SET)       { 3          buffer = (char *) vcrp->vcrp$a_input_list;r[          buffer_end = (char *) vcrp->vcrp$a_input_list +  vcrp->vcrp$t_mgmt_information[0];oD          if ((vcrp->vcrp$t_mgmt_information[0]%sizeof(LSTITM)) == 0)
          {B             while ((buffer < buffer_end) && (status & SS$_NORMAL))
             {(C                status = asn$do_set_item(asnucb, (LSTITM *) buffer);L'                if (status & SS$_NORMAL)u                {+                   buffer += sizeof(LSTITM);v7                   vcrp->vcrp$q_request_status = status;a                }                elseb                {R                   vcrp->vcrp$q_request_status = (((uint64)buffer << 32) | status);                }
             } 
          }
          elsee
          {7             vcrp->vcrp$q_request_status = SS$_BADPARAM; 
          }       }b
       else       {n4          vcrp->vcrp$q_request_status = SS$_BADPARAM;       }p    }    else     {1       vcrp->vcrp$q_request_status = SS$_DEVINACT;     } }- else {c.    vcrp->vcrp$q_request_status = SS$_DEVINACT; }v   return	SS$_NORMAL;   }l