I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_buf.c  **
 **  ABSTRACT:  **F **      This module implements routines required to manipluate buffers ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      7-December-1995  ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  **+ **      7-December-1995   Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _PPP_BUF_H_  #include "ppp_buf.h" #endif   /* ** ** import definitions: **        SS$_xxx  ** */ #ifndef __SSDEF_LOADED #include "ssdef.h" #endif   /* ** ** import definitions: **        SS$_xxx  ** */ #ifndef __SSDEF_LOADED #include "ssdef.h" #endif   /* ** ** import definitions: **        DYN$C_VCRP ** */ #ifndef __DYNDEF_LOADED  #include "dyndef.h"  #endif   /* ** ** import definitions: **        exe_std$xxx rotuines ** */ #ifndef __EXE_ROUTINES_LOADED  #include "exe_routines.h"  #endif     /* **++ **  FUNCTION NAME: ** **      pppBufAlloc  ** **  FUNCTIONAL DESCRIPTION:  **, **      Allocate and initialise a PPP Buffer ** **  FORMAL PARAMETERS: **> **      size    Requested size of the data area of the  buffer ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **< **      Pointer to the buffer if one successfully allocated.3 **      NULL_BUF if a buffer couldn't be allocated.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */% PPPBuffer *pppBufAlloc( u_int bsize )  { @     PPPBuffer *buf;	        /* pointer to returned buffer     */D     struct vcrpstackdef *stckP;	/* pointer to vcrp stack          */6     int32  size;		/* size of allocated memory block */  b     if ( exe_std$alononpaged((bsize + VCRP$K_FIXED_LENGTH), &size, (void **)&buf ) == SS$_NORMAL )     {  	buf->vcrp$l_flink = 0;  	buf->vcrp$l_blink = 0;   	buf->vcrp$b_type  = DYN$C_VCRP; 	buf->vcrp$w_size  = size;Q 	BZERO( &buf->vcrp$l_pid, VCRP$K_FIXED_LENGTH - offsetof(PPPBuffer, vcrp$l_pid)); J 	buf->vcrp$l_buffer_address = (void *)((char *)buf + VCRP$K_FIXED_LENGTH);$ 	buf->vcrp$l_total_pdu_size = bsize;$ 	buf->vcrp$l_bcnt           = bsize;2 	buf->vcrp$l_boff           = VCRP$K_FIXED_LENGTH;   	/* init vcrp stack */; 	stckP = (struct vcrpstackdef *)buf->vcrp$t_internal_stack; * 	buf->vcrp$a_stack        = (void *)stckP;X 	stckP->stack$l_btm       = (void *)((char *)stckP->stack$t_stack + STACK$K_STACK_SIZE);/ 	stckP->stack$l_lastused  = stckP->stack$l_btm; C 	stckP->stack$l_top       = (void *)((char *)stckP->stack$t_stack);      }      else     {  	buf = NULL;     }      return (buf);  }      /* **++ **  FUNCTION NAME: ** **      pppBufDealloc  ** **  FUNCTIONAL DESCRIPTION:  ** **      Free a PPP buffer.     **+ **      NOTE:  This routine only expects to / **      get called for buffers allocated by PPP 1 **      and so doesn't check the dealloc field of  **      the buffer.  ** **  FORMAL PARAMETERS: **0 **      buf    Pointer to the buffer to be freed ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */$ void pppBufDealloc( PPPBuffer *buf ) {      exe_std$deanonpaged( buf );      return;  }   