/* Program Name            : FILERLAU.C                                 */
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 18-MAY-1991				*/
/*   Program Description   :                                            */
/*                         :                                            */
/* Revision History follows                                             */
 
#include "global.h"
#include "dx.h"
#include "filer.h"
#include "filerlau.h"
#include "inquire.h"
#include <signal.h>
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	filer_launch()
{
    if (DX_CURRENT_DIRECTORY.filemode == multiple)
	filer_multiple_launch();
    else
	filer_single_launch();
    return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_multiple_launch()
{
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error launching file");
    multi_get_userinput_and_exec(
	filer_launch$1,
	"Multiple Launch",
	"Specify optional argument(s): ",
	"",
	errmsg);
    if (cntrl_info_block.user_pref.auto_update)
    {
	filer_update();
    }
    return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_single_launch()
{
    char errmsg[MAXFILESPEC+1];
    char fn[MAXFILESPEC+1];
 
    if (!strcmp(DX_CURRENT_FILE->fn, "[-]"))
    {
        signal_err("Execute a parent directory file not allowed", bell);
    }
    else
    {
	find_full_path_name(DX_CURRENT_FILE->fn, fn, cntrl_info_block.cur_win);
	strcpy(errmsg, "Error launching file");
	get_userinput_and_execute(
	    filer_launch$1,
	    "Launch File",
	    "Specify optional argument(s): ",
	    "",
	    errmsg,
	    fn);
	if (cntrl_info_block.user_pref.auto_update)
	{
	    filer_update();
	}
    }
    return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_launch$1(arguments, from, errmsg)
char *arguments;
char *from;
char *errmsg;
{
    char command_string[256];
    $DESCRIPTOR (command_string_descrip, command_string);
    unsigned long status;
    char launch_sym[] = "DXM__LAUNCH_SYMBOL";
    $DESCRIPTOR (launch_symbol_descrip, launch_sym);
    char value_string[256];
    $DESCRIPTOR (value_string_descrip, value_string);
    unsigned long display_id;
    char dirbuf[MAXFILESPEC+1];
    unsigned short word_terminator_code;
    int subpid;	/**  Sub-process  **/
    char str[128];
    $DESCRIPTOR (str_descrip, str);
 
    /*
    **	Set the signal back to system default so that it won't
    **	interfere with I/O used by the subprocess.
    **/
 
    alarm(0);
    signal(SIGALRM, SIG_DFL);
 
    check_OK(smg$save_physical_screen (
		&cntrl_info_block.pasteboard_id,
		&display_id,
		0,
		0))
 
    check_OK(smg$set_physical_cursor (
	      &cntrl_info_block.pasteboard_id,
	      &cntrl_info_block.pasteboard_rows,
	      &1))
 
    /*
    **	    Format a command-line string.  Prefix a '@' if file type is
    **	    .COM; othererwise, define a temporary symbol to be execute by
    **	    SYS$SPAWN routine.
    **/
 
    if (strstr(from, ".COM;") != NULL)
    {
	sprintf(command_string, "%c%s %s", '@', from, arguments);
	printf("1$ %s\n", command_string);
    }
    else
    {
	sprintf(value_string, "%c%s", '$', from);
	LENGTH(value_string_descrip) = strlen(value_string);
	status = lib$set_symbol (
		    &launch_symbol_descrip,
		    &value_string_descrip,
		    0);
	if (!(status & 1))
	{
	    sprintf(errmsg, "Error setting local symbol to execute a DCL command");
	    return DX__DONTCARE;
	}
 
	sprintf(command_string, "%s %s", launch_sym, arguments);
	printf("1$ %s %s\n", strchr(from, ']')+1, arguments);
    }
 
    /*
    **	Change the definition of SYS$DISK and terminate the mailbox
    **/
 
    setddir(DX_CURRENT_DIRECTORY.cur_dir, errmsg);
 
    LENGTH(command_string_descrip) = strlen(command_string);
    status = lib$spawn (
		    &command_string_descrip,
		    0,
		    0,
		    0,
		    0,
		    &subpid,
		    0,
		    0,
		    0,
		    0,
		    0,
		    0);
 
    /*
    **	Restore to old states
    **/
 
    setddir(DX_CURRENT_DIRECTORY.cur_dir, errmsg);
 
    lib$delete_symbol (	    /**  DELETE SYMBOL  **/
        &launch_symbol_descrip,
        0);
 
    if ((status & 1))
    {
	/**  Executing a DCL command was successful  **/
	sleep(2);
        smg$read_keystroke (
            &cntrl_info_block.keyboard_id,
            &word_terminator_code,
            $DESCR ("\n\n\nPress any key to continue ... "),
            0,
            0,
            0,
            0);
    }
 
    check_OK(smg$restore_physical_screen (
	      &cntrl_info_block.pasteboard_id,
	      &display_id))
 
    return ((status & 1)? DX__NORMAL : DX__ERROR);
}
