  H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    *  @  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\    @  *                %% \___________________________________%% \   @  *                %% |                                   %%  \  @  *                %% |               LRNKEY              %%   \ @  *                %% |           lrnkey.c  2004          %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *    *  A  *    Copyright (C) 1992, 2004 Lyle W. West, All Rights Reserved. L  *    Permission is granted to copy and use this program so long as [1] thisJ  *    copyright notice is preserved, and [2] no financial gain is involvedJ  *    in copying the program.  This program may not be sold as "shareware"I  *    or "public domain" software without the express, written permission   *    of the author.  *
  *  LRNKEY  *:  *        Utility used to define shifted function keys (on>  *        most advanced Dec compatible terminals), F6 -> F20  @  *        to output a character string to the host. Adapted from>  *        the pd file SETUDK.C from Yaacov Fenster from ~1990.  *A  *        Intended usage is for dialout modems calling answerback ;  *        modems where numerous strings must be entered to    *        start each session.   *=  *        Searches process table for logical name, LRNKEY_LOC @  *        which points to an ascii file containing one formated -  *        record for each key to be defined.    *E  *        If the P1 value is specified, LrnKey will use this filespec B  *        rather than the filespec specified with LRNKEY_LOC. NoteA  *        that the P1 filespec will be the equivalence string for F  *        LRNKEY_LOC during the duration of the invoking process only.  *=  *        To create the process logical names LRNKEY_STAT and @  *        LRNKEY_SHOW, user is required to have SYSNAM privilegeD  *        as the above logicals will be removed when the LRNKEY.EXE E  *        image exits. LRNKEY can be installed with SYSNAM priv, then C  *        individual users will not need the priv assigned to them.   *=  *        User Defined Keys (UDK) must be unlocked (default).   *F  *        This application must be relinked if the current VMS version1  *        is upgraded to version 7.3-2 or higher.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #define VERSION "V2.2-6" #pragma module LRNKEY VERSION    #include <stdio.h> #include <stdlib.h>  #include <climsgdef.h> #include <descrip.h> #include <ssdef.h> #include <psldef.h>  #include <string.h>  #include <jpidef.h>  #include <iodef.h> #include <ttdef.h> #include <tt2def.h>  #include <ctype.h> #include <lnmdef.h>    #define PRV$M_SYSNAM 0x4   globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;    globalvalue LRNKEY_CLD;   0 /* This table translates key name to key code */   int FkeyCode[] = {     17, /* F6 */     18, /* F7 */     19, /* F8 */     20, /* F9 */     21, /* F10 */        23, /* F11 */      24, /* F12 */      25, /* F13 */      26, /* F14 */        28, /* F15 (Help) */     29, /* F16 (Do) */       31, /* F17 */      32, /* F18 */      33, /* F19 */      34  /* F20 */  };   int RetStat;   char Buffer[80]; char CmdVerb[32]; M char InputFile[80];         /* LRNKEY input file (from LRNKEY_LOC/cmdline) */ A char ShowFile[80];          /* file used by /SHOW cmdline qual */ 4 char LnmTable[80];          /* logical name table */5 char LnmDef[40];            /* logical name string */ A char LnmEqv[80];            /* logical name equivalence string */ A char PidStr[10];            /* ascii equivalent if current pid */       typedef struct {     unsigned char class, term;     unsigned short width;      unsigned bchar : 24;     unsigned char page;      unsigned int xchar; 
 } CHARBLK;   extern void CheckPrv();  extern int ChkUdkLock(); extern int CreateLnm();  extern int DeleteLnm();  extern int GetLnm(); extern void ShowHelp();  extern void ShowKeys();  extern void ShowVers();  extern int  lib$get_input();   globalvalue LRNKEY_CLD;   L FILE *cmdfp;                /* LrnKey input file, proc logical or cmdline */L FILE *showfp;               /* LrnKey showfile, disp current lrnkey stats */  < struct  {short len, code; int *bufadr, *retlen;} JpiItem[3];     
 int main() { 3     char CliStr[80];        /* cli string buffer */ B     char CmdLine[132];      /* buffer reflecting input cmd line */6     char CmdStr[40];        /* ascii command string */4     char DispStr[50];       /* fkey and cmdstring */4     char HexStr[80];        /* hex command string */     char LineBuf[132];F     char LrnBuf[80];        /* pre-buffer for device control string */:     char recinfo[40];       /* LRNKEY_STAT build buffer */     char *BufPtr; 9     char *CharPtr;          /* general purpose pointer */ 9     char *StrPtr;           /* general purpose pointer */   >     int CliStat;            /* return status from cli calls */G     int FkeyStat;               /* function key determined (boolean) */ 
     int fkey; 
     int done;      int indx1;     int indx2;4     int lrncnt = 0;         /* total keys defined */     int status;   B     short FkeyVal;          /* key value to send to Vt terminal */H     short CheckFlg = 0;     /* TRUE if /CHECK is specified on cmdline */     short CliStr_len; G     short LockFlg = 0;      /* TRUE if user entered /LOCK qualifier */  @     short NewLine = FALSE;  /* TRUE if '\n' terminates CmdStr */     short CmdLen;   K     $DESCRIPTOR(Dsc_Cli, CliStr);       /* cli param or qualifier string */ J     $DESCRIPTOR(Dsc_Cmd, CmdLine);      /* user supplied input cmd line */#     $DESCRIPTOR(Dsc_Lbuf, LineBuf); N     $DESCRIPTOR(Dsc_Ret, Buffer);       /* string returned by cli$get_value */G     $DESCRIPTOR(Dsc_Verb, CmdVerb);  /* foreign invoking symbol name */   <         /* get the command line used to invoke this image */  O     status = GetCmdLine(&Dsc_Cmd, &CmdLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = 0;  3         /* extract foreign cmd verb from CmdLine */   $     sscanf(CmdLine, "%s", &CmdVerb);#     CharPtr = strchr(CmdVerb, '/');       if(CharPtr) *CharPtr = '\0';,     Dsc_Verb.dsc$w_length = strlen(CmdVerb);.     status = str$upcase(&Dsc_Verb, &Dsc_Verb);  G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */  6     status = lib$get_foreign(&Dsc_Cmd, 0, &CmdLen, 0);*     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';      strcpy(LineBuf, "LRNKEY ");      strcat(LineBuf, CmdLine); ,     Dsc_Lbuf.dsc$w_length = strlen(LineBuf);H     CliStat = cli$dcl_parse(&Dsc_Lbuf, LRNKEY_CLD, lib$get_input, 0, 0);,     if(CliStat != CLI$_NORMAL) exit(status);  G         /* see if we need version, help or check info. These should not $            require elevated privs */       strcpy(CliStr, "VERSION");*     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowVers();        strcpy(CliStr,"HELP");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowHelp();        strcpy(CliStr,"CHECK"); 9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) {          CheckFlg = TRUE;J         ChkUdkLock(TRUE);   /* check if term locked (User Defined Keys) */         exit(1);     }   D         /* ok, if we get here, we will need SYSNAM priv to deal withG            various process permanent logical name operations. The prev  ?            three qualifiers should execute ok without SYSNAM */   *     strcpy(LnmTable, "LNM$PROCESS_TABLE");?     CheckPrv();             /* Need SYSNAM priv for this app */        strcpy(CliStr,"LOCK");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);/     if(CliStat == CLI$_PRESENT) LockFlg = TRUE;      else LockFlg = FALSE;        strcpy(CliStr,"CLEAR"); 9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) { %         strcpy(LnmDef,"LRNKEY_SHOW");          RetStat = GetLnm(); #         if(RetStat != SS$_NORMAL) { C             printf("%%LRNKEY-F-KEYUNDEF, No keys are defined\n\n");              exit(1);	         } #         status = ChkUdkLock(FALSE); #         if(status == SS$_WRITLCK) { )             printf("%%LRNKEY-E-CLEAR, "); C             printf("User Defined Keys ARE locked, cannot clear\n");              exit(1);	         }          B         printf("\033P0;1|");        /* clr all keys, unlock udk */K         printf("\033\\");           /* <esc>\ = signal end of udk string */ :         RetStat = delete(LnmEqv);   /* delete show file */<         RetStat = DeleteLnm();      /* retrived lnm above */%         strcpy(LnmDef,"LRNKEY_STAT");          RetStat = DeleteLnm();@         printf("%%LRNKEY-I-CLEAR, cleared UDK environment\n\n");         exit(1);     }          strcpy(CliStr,"SHOW");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) { %         strcpy(LnmDef,"LRNKEY_SHOW");          RetStat = GetLnm();           if((RetStat & 1) == 0) {I             printf("%%LRNKEY-F-NOKEYDEF, There are no keys defined\n\n");              exit(1);	         } !         strcpy(ShowFile, LnmEqv);          ShowKeys();          exit(1);     }   D         /* if the terminal's UDK Lock in enabled, no sense going anyF            further into this operation. If TRUE, we won't come back */       status = ChkUdkLock(FALSE);      if(status == SS$_WRITLCK) { F         printf("%%LRNKEY-I-CHECK,  User Defined Keys ARE locked\n\n");         exit(1);     }   <         /* see if learn file is specified on command line */       strcpy(CliStr,"INPFILE"); 9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) { A         CliStat = cli$get_value(&Dsc_Cli, &Dsc_Ret, &CliStr_len); #         if(CliStat == SS$_NORMAL) { &             Buffer[CliStr_len] = '\0';J             strcpy(InputFile, Buffer);    /* in case it's not a logical */#             strcpy(LnmDef, Buffer);              RetStat = GetLnm(); G             if((RetStat & 1) == SS$_NORMAL)  strcpy(InputFile, Buffer); 	         }      } @     else {      /* not on cmd line, see if logical is defined */$         strcpy(LnmDef,"LRNKEY_LOC");         RetStat = GetLnm();           if((RetStat & 1) == 0) {J             printf("\n%%LRNKEY-F-NOLOGNAM, logical name '%s' undefined\n",                 LnmDef);D             printf("%%LRNKEY-F-KEYUNDEF, No keys were defined\n\n");             exit(1);	         } C         strcpy(InputFile, LnmEqv);    /* save equivalence string */      }   D         /* whether input file was on cmdline or a logical, it is nowE            specified within 'InputFile' so it must be stripped of any ;            filepath info to create the showfile filespec */   %     strcpy(ShowFile, "SYS$SCRATCH:"); B     if( (strrchr(InputFile, ']')) || (strrchr(InputFile, ':')) ) {F         if(strrchr(InputFile, ']')) CharPtr = strrchr(InputFile, ']');/         else CharPtr = strrchr(InputFile, ':');          CharPtr++;"         strcat(ShowFile, CharPtr);     } %     else strcat(ShowFile, InputFile);   %     CharPtr = strrchr(ShowFile, '.');       if(CharPtr) *CharPtr = '\0';     StrPtr = &PidStr + 5;      strcat(ShowFile, "-");     strcat(ShowFile, StrPtr);      strcat(ShowFile, ".SHOW");  A         /* open the Lrnkey input file and the Lrnkey show file */   2     if ((cmdfp = fopen(InputFile, "r")) == NULL) {G         printf("\n%%LRNKEY-F-NOACCESS, cannot open '%s'\n", InputFile); @         printf("%%LRNKEY-F-KEYUNDEF, No keys were defined\n\n");         exit(1);     }   2     if ((showfp = fopen(ShowFile, "w")) == NULL) {B         printf("\n%%LRNKEY-E-OPEN, cannot open '%s'\n", ShowFile);@         printf("%%LRNKEY-E-KEYUNDEF, No keys were defined\n\n");         exit(1);     }   E         /* read the input file, one record at a time, if valid lrnkey H            syntax then learn specified key and record resultant key info            into the showfile */   $     RetStat = fprintf(showfp, "\n");     printf("\n"); H     sprintf(LrnBuf, "<0>");     /* this will show qty of defined keys */     done = FALSE;      while (!done) {          NewLine = FALSE;O         RetStat = fgets(Buffer, sizeof(Buffer)-1, cmdfp); /* read define cmd */ ,         if (RetStat != &Buffer) done = TRUE;         else {D             if (isalnum(Buffer[0]) != 0 || isspace(Buffer[0]) !=0) {                 indx1 = 0;                 indx2 = 0;!                 FkeyStat = FALSE; *                 while(FkeyStat == FALSE) {L                     switch(Buffer[indx1]) {     /* looking for Fx keyname */!                         case 'F': !                         case 'f': 5                             StrPtr = &Buffer + indx1; $                             indx1++;@                             while(isdigit(Buffer[indx1]) != 0) {?                                 recinfo[indx2] = Buffer[indx1]; (                                 indx1++;(                                 indx2++;                             } 2                             recinfo[indx2] = '\0';,                             FkeyStat = TRUE;"                             break;                          default:$                             indx1++;E                             if(indx1 >= strlen(Buffer)) FkeyStat = 5; "                             break;                     }                  }   C         /* we have the desired function key, perform conversions */   D                 fkey = atoi(recinfo);   /* cvt to decimal integer */;                 while(isspace(Buffer[indx1]) != 0) indx1++; )                 BufPtr = &Buffer + indx1; 1                 if((fkey >= 6) && (fkey <= 20)) { L                     FkeyVal = (FkeyCode[fkey - 6]); /* get needed keycode */M                     CharPtr = strchr(StrPtr, '!');  /* remove comment info */ 0                     if(CharPtr) *CharPtr = '\0';K                     CharPtr = strchr(StrPtr, '\\'); /* check for newline */ !                     if(CharPtr) { %                         CharPtr += 2; D                         *CharPtr = '\0'; /* get rid of all beyond */                     } L                     strcpy(DispStr, StrPtr);    /* str for crt & showfile */?                     RetStat = fprintf(showfp, "%s\n", DispStr); 4                     CharPtr = strstr(BufPtr, "\\n");!                     if(CharPtr) { '                         NewLine = TRUE; (                         *CharPtr = '\0';                     }                      else {7                         CharPtr = strrchr(BufPtr, " "); %                         if(CharPtr) { =                             while(*CharPtr == ' ') CharPtr--; '                             CharPtr++;  ,                             *CharPtr = '\0';                         }                      }   E         /* create hex result from CmdStr, add newline if requested */   +                     strcpy(CmdStr, BufPtr); &                     CharPtr = &CmdStr;                     indx1 = 0;A                     RetStat = memset(&HexStr, 0, sizeof(HexStr)); %                     while(*CharPtr) { D                         sprintf(HexStr + indx1, "%02x", *CharPtr++);#                         indx1 += 2;                      } 5                     if(NewLine) strcat(HexStr, "0D");   @         /* send the full UDK string to terminal via printf. NoteA            that if LockFlg is TRUE, indicating user wants to lock @            UDK functions when we are done, to enable the lock weI            send the terminal a zero; if FALSE, we send it a 1 (Hummmn) */   H                     if(LockFlg) sprintf(Buffer, "\033P1;0|%d/%s\033\\", )                         FkeyVal, HexStr); @                     else sprintf(Buffer, "\033P1;1|%d/%s\033\\",)                         FkeyVal, HexStr); )                     printf("%s", Buffer);   :             /* append latest info to LRNKEY_STAT buffer */                       lrncnt++; 3                     sprintf( recinfo, "_%X", fkey); ,                     strcat(LrnBuf, recinfo);4                     CharPtr = strchr(DispStr, '\n');0                     if(CharPtr) *CharPtr = '\0';A                     printf("%%LRNKEY-I-KEYDEF, '%s'\n", DispStr);                  } 
             } 	         }      }      fclose(showfp);      printf("\n"); $     sprintf( recinfo, "%X", lrncnt);     LrnBuf[1] = recinfo[0];      strcpy(LnmEqv, LrnBuf); !     strcpy(LnmDef,"LRNKEY_STAT");      RetStat = CreateLnm();,     if(RetStat != SS$_NORMAL) exit(RetStat);     strcpy(LnmEqv, ShowFile); !     strcpy(LnmDef,"LRNKEY_SHOW");      RetStat = CreateLnm();,     if(RetStat != SS$_NORMAL) exit(RetStat);
 #ifdef ARF     strcpy(LnmEqv, InputFile);      strcpy(LnmDef,"LRNKEY_LOC");     RetStat = CreateLnm();,     if(RetStat != SS$_NORMAL) exit(RetStat); #endif     status = ChkUdkLock(FALSE); N     if(status == SS$_WRITLCK) printf(" User Defined Keys are now LOCKED\n\n");     exit(SS$_NORMAL);  }   H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  ShowKeys - At entry, we have determined the shifted keys F6 --> F20 E  *             been defined. This was verified by the presence of the D  *             process logical LRNKEY_SHOW, and the defined keys are>  *             represented in the process logical LRNKEY_STAT.E  *             Unfortunately, this does not show the key definitions, H  *             so we must display the contents of of the file referenced2  *             in the process locigal LRNKEY_SHOW.  *  K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowKeys()  {      char *ptr = 0;
     int done;      int sk_stat;  2     if ((showfp = fopen(ShowFile, "r")) == NULL) {@         printf("\n%%LRNKEY-F-OPEN, cannot open '%s'\n", LnmEqv);G         printf("%%LRNKEY-F-NODEF, Cannot display key definitions\n\n");          exit(1);     } 1     printf("\n\tLearn Key File: %s\n", ShowFile);      done = FALSE;      while (!done) { :         sk_stat = fgets(Buffer, sizeof(Buffer)-1, showfp);,         if (sk_stat != &Buffer) done = TRUE;$         else printf("\t%s", Buffer);     }      printf("\t%%\n");       sk_stat = ChkUdkLock(FALSE);L     if(sk_stat == SS$_WRITLCK) printf("\tUser Defined Keys ARE locked\n\n");     exit(1); }   H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *F  *  GetLnm - Function to retrieve a logical name in a provided logicalE  *           name table. If successful, equivalence string is written L  *           to global string 'LnmEqv and the status of $TRNLNM is returned.  *  K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetLnm() {      int glnmstat = 0;      short equ_len = 0;     unsigned char acmode = 0; >     struct {short len, code; int *bufadr, *retlen;} itmlst[2];  &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);  /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);   #     itmlst[0].len = sizeof(LnmEqv); !     itmlst[0].code = LNM$_STRING;      itmlst[0].bufadr = &LnmEqv;       itmlst[0].retlen = &equ_len;     itmlst[1].len = 0;     itmlst[1].code = 0;        acmode = PSL$C_SUPER;      LnmEqv[0] = '\0'; I     glnmstat = sys$trnlnm(0, &dsc_tabnam, &dsc_lognam, &acmode, &itmlst); =     if((glnmstat && 1) == SS$_NORMAL) LnmEqv[equ_len] = '\0';      return(glnmstat);  }     H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *J  *  CreateLnm - Function to create a logical name in a given logical name E  *              table. If successful, equivalence string is read from I  *              global string 'LnmEqv' and the string length is returned. >  *              Procedure returns status from SYS$CRELNM call.  *  K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CreateLnm()  {      int clnmstat = 0;      short equ_len = 0;     unsigned char acmode = 0; >     struct {short len, code; int *bufadr, *retlen;} itmlst[2];  &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);  /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = strlen(LnmEqv);   #     itmlst[0].len = strlen(LnmEqv); !     itmlst[0].code = LNM$_STRING;      itmlst[0].bufadr = &LnmEqv;       itmlst[0].retlen = &equ_len;     itmlst[1].len = 0;     itmlst[1].code = 0;        acmode = PSL$C_SUPER;   I     clnmstat = sys$crelnm(0, &dsc_tabnam, &dsc_lognam, &acmode, &itmlst);      return(clnmstat);  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *H  *  DeleteLnm - Deletes specified logical name from specified lnm table.H  *              Logical name string is read from global string 'LnmDef' ;  *              and the status from SYS$DELLNM is returned.   *  K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int DeleteLnm()  {      int dlnmstat = 0;      short equ_len = 0;     unsigned char acmode = 0;   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);  /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef);        acmode = PSL$C_SUPER;   =     dlnmstat = sys$dellnm(&dsc_tabnam, &dsc_lognam, &acmode);      return(dlnmstat);  }     H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *H  *  ChkUdkLock - Check if current TT device has USER DEFINE KEYS locked.I  *               If the argument 'verbose' is TRUE then display resultant F  *               status and return. Else just return resultant status:  *0  *                  SS$_NORMAL - UDK is unlocked/  *                  SS$_WRITLCK - UDK is locked   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int ChkUdkLock(int verbose)  {      char    respbuf[32];     int     iochan;      int     iosb[2];     int     status;        $DESCRIPTOR(dsc_dev, "TT");      CHARBLK newmode, savmode;   )     memset(&respbuf, 0, sizeof(respbuf)); 1     status = sys$assign(&dsc_dev, &iochan, 0, 0); F     status = sys$qiow(0, iochan, IO$_SENSEMODE, &iosb, 0, 0, &savmode,3                       sizeof(savmode), 0, 0, 0, 0);      newmode = savmode;A     newmode.bchar |= TT$M_NOECHO;       /* term will be Noecho */ ;     newmode.bchar |= TT$M_ESCAPE;       /* enable escape */ F     newmode.bchar |= TT$M_NOBRDCST;     /* disable direct broadcast */:     newmode.bchar &= ~TT$M_HOSTSYNC;    /* no host sync */I     newmode.bchar &= ~TT$M_TTSYNC;      /* do sync at subprocess level */   D     status = sys$qiow(0, iochan, IO$_SETMODE, &iosb, 0, 0, &newmode,3                       sizeof(newmode), 0, 0, 0, 0);   ?     printf("\033[?25n");     /* check if the UDKs are locked */ ;     status = sys$qiow(0, iochan, IO$_READLBLK, &iosb, 0, 0, /                       &respbuf, 7, 0, 0, 0, 0);   A         /* if respbuf is "\033[?21n" UDK is locked. If the result 0            is "\033[?20n" then udk not locked */  (     if (!strcmp("\033[?21n", respbuf)) {         if(verbose) I             printf("%%LRNKEY-E-CHECK, User Defined Keys ARE locked\n\n"); H         status = sys$qiow(0, iochan, IO$_SETMODE, &iosb, 0, 0, &savmode,7                           sizeof(savmode), 0, 0, 0, 0); $         status = sys$dassgn(iochan);         return(SS$_WRITLCK);     } D     status = sys$qiow(0, iochan, IO$_SETMODE, &iosb, 0, 0, &savmode,3                       sizeof(savmode), 0, 0, 0, 0);       status = sys$dassgn(iochan);M     if(verbose) printf("%%LRNKEY-I-CHECK, User Defined Keys NOT locked\n\n");      return(SS$_NORMAL);  }   H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *E  *  CheckPrv - Verify required priv(s) are currently enabled. If not, F  *             display messase to that effect and exit. Due to certainH  *             terminal $QIO rountines, and other operations, this imageE  *             must have SYSNAM privilege. If not, display messase to $  *             that effect and exit.  *J  *             Since we are using $GETJPI, we also get current process id K  *             and place the ascii equivalent in the global buffer 'PidStr' E  *             This is used as a somewhat unique suffix for the show  G  *             file name, ie, WPC_KEYS-xxx.SHOW, where 'xxx' represents .  *             the last three digits of PidStr  *E  *             The requirement for SYSNAM priv is due to the fact the E  *             logical names defined in this tool will disappear when 8  *             the LRNKEY image exits without this priv.  *J  *             If the calling user does NOT have SYSNAM priv, this routineH  *             will enable that priv if the user's authorized privs haveE  *             the SETPRV bit enabled. Else image exit (with a nopriv )  *             message displayed) occurs.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CheckPrv()  {      int ProcPriv[2] = 0;     int Pid;     int enbflg = TRUE;     int status;   &     JpiItem[0].len = sizeof(ProcPriv);$     JpiItem[0].code = JPI$_PROCPRIV;"     JpiItem[0].bufadr = &ProcPriv;     JpiItem[0].retlen = 0;!     JpiItem[1].len = sizeof(Pid);      JpiItem[1].code = JPI$_PID;      JpiItem[1].bufadr = &Pid;      JpiItem[1].retlen = 0;     JpiItem[2].len = 0;      JpiItem[2].code = 0;  5     status = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0); *     if(status != SS$_NORMAL) exit(status);)     if( ! (ProcPriv[0] & PRV$M_SYSNAM)) { $         ProcPriv[0] |= PRV$M_SYSNAM;5         status = sys$setprv(enbflg, &ProcPriv, 0, 0); "         if(status != SS$_NORMAL) {P             printf("%%LRNKEY-E-NOPRV, operation requires SYSNAM privilege\n\n");             exit(1);	         }      }   !     sprintf(PidStr, "%08X", Pid);  }   H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  ShowHelp - Display a brief combination of LRNKEY.README and the cdu H  *             LRNKEY.CLD file. It provides a command line glance at the8  *             optional implementations of LRNKEY usage.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);B     printf("\tUtility used to define shifted function keys on\n");M     printf("\tDigital VTxxx terminals (and credible clones) to output a \n"); E     printf("\tcharacter string to the host. Adapted from various\n"); ?     printf("\tfreeware SETUDK sources from the internet.\n\n"); J     printf("\tIntended usage is for dialout modems calling answerback\n");D     printf("\tmodems where numerous strings must be entered to \n");'     printf("\tstart each session\n\n"); F     printf("\tSearches process table for logical name, LRNKEY_LOC\n");I     printf("\twhich points to an ascii file containing one formated \n"); 7     printf("\trecord for each key to be defined\n \n"); &     printf("      Record Format\n\n");7     printf("\tF6 ATDT4321234 \\n    ! modem number\n"); /     printf("\tF8 modemuser \\n  ! password\n"); 8     printf("\tF10 4848400 \\n   ! dialback number\n\n");R     printf("\tThe ! is treated as a comment char, remainder of line ignored\n\n");#     printf("      Parameters\n\n"); H     printf("\t%s accepts one parameter, a VMS filespec (or a process\n",         CmdVerb); M     printf("\tlogical name representing a filespec) which is a formatted\n"); K     printf("\tascii UDK definition file. This parameter will override \n"); 3     printf("\tthe process logical LRNKEY_LOC\n\n"); #     printf("      Qualifiers\n\n"); N     printf("\t/CHECK - %s will query the current terminal device\n", CmdVerb);H     printf("\t\tto check if User Defined Keys are currently locked.\n");I     printf("\t\t%s will display the result of the query, then exit.\n\n",          CmdVerb); E     printf("\t/CLEAR - Undefines learned keys which were defined\n"); I     printf("\t\tduring the last process invocation of %s. This option\n",          CmdVerb); P     printf("\t\twill remove all key definitions for shifted keys F6 -> F20.\n");I     printf("\t\tThe process logicals LRNKEY_STAT and LRNKEY_SHOW are\n"); H     printf("\t\tdeassigned. The terminal must have UDK unlocked for\n");7     printf("\t\t/CLEAR to complete successfully.\n\n"); /     printf("\t/HELP - Displays this text\n\n"); I     printf("\t/LOCK - if present, %s will lock all UDK's from change \n",          CmdVerb); D     printf("\t\tuntil unlocked by user from terminal keyboard\n\n");H     printf("\t/SHOW - Displays keys and associated strings defined \n");I     printf("\t\tfor the last invocation in the current process tree,\n"); H     printf("\t\tusing LRNKEY_SHOW to view currently defined keys.\n\n");G     printf("\t/VERSION - %s displays version, build date,\n", CmdVerb); B     printf("\t\tand required privs for VMS Install utility.\n\n");     exit(1); }     H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setN  *              length to -1 and return SS$_BUFFEROVF. Eelse return SS$_NORMAL  *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */       short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */       int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */   D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */  =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */  8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */  A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;  B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */       if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */*         else {             *length = -1;*"             return(SS$_BUFFEROVF);	         }      }%2     else *length = *Sptr;       /*  8 bit value */  C         /* get buffer length and copy cmd line to callers buffer */        Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }          H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *B  *  ShowVers - displays current installed version, build date, andC  *             required privs for interactive usage and/or the VMS |  *             install utility.%  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowVers()  { 1     printf("\n\t\t%s by Lyle W West\n", CmdVerb); )     printf("\t\tVersion: %s\n", VERSION); 0     printf("\t\tLast Modified: %s\n", __DATE__);-     printf("\t\tRequired Privs: SYSNAM\n\n");      exit(1); }     