 #include <string.h>  #include <stdio.h> #include "tm_include:quint.h"  #include "tm_include:macro.h"  #include "tm_include:tm.h"  ) /*  Read a quintuple list from disk file. @     The name of the list will be the filename without extension. */    ? void read_tm_file( char *fname, struct qlist *ql, int *status )        { H       struct quint *new_quint(/* struct qlist*, char *, char*, int* */);#       void message(/*char*, int*/);        FILE *fptr;          struct quint *qptr;        char ch;    !       char headerbuf[MAX_HEADER]; 3       char linebuf[90], getline(FILE*, char*, int); A       char cmmt[COMMENT_LENGTH], quint[6], namebuf[QNAME_LENGTH]; 4       int line;        /* current line in the file*/       int len, i; /       int counter=0;     /* quintuple counter*/   4 /* if no extension is entered, supply the default:*/&       if ( strchr(fname,'.') == NULL )           strcat(fname,".tm");+       if((fptr = fopen(fname,"r")) == NULL) 	         {          *status = NO_READ_OPEN;          return; 	         }   & /* give a name to the quintuple list*/%       for (i=0; i<QNAME_LENGTH ; i++)          if ( fname[i]!='.' )            namebuf[i] = fname[i];         else           {            namebuf[i] = '\0';           break;           } 2       strncpy(ql->list_name,namebuf,QNAME_LENGTH);  / /* start reading the file one line at a time */   &       ch = getline(fptr, linebuf, 90);       line = 1;        headerbuf[0] = '\0';  E       while (linebuf[0] != '(' )        /* file has comment header */ 	         { "         strcat(headerbuf,linebuf);0         if ( getline(fptr, linebuf, 90) == EOF )           {             *status = EMPTY_QFILE;           return;            }          line++; 	         }    /*  store the header  *//       strncpy(ql->header,headerbuf,MAX_HEADER);   ' /* get quintuples and their comments */          quint[5] = '\0';         while( ch != EOF )	         {           if ( linebuf[0] != '(' ):           printf("on line %d: no quintuple found\n",line);         else           { %           strncpy(quint,linebuf+1,5);             len = strlen(linebuf);           if ( len >= 7 ) 
             { G             linebuf[len-1] = '\0';            /* eliminate the '\n'  */ 3             strncpy(cmmt,linebuf+6,COMMENT_LENGTH); 
             }            else             cmmt[0] = '\0'; A           if ( (qptr = new_quint(ql,quint,cmmt,status)) == NULL ) 
             { (             printf("on line %d: ",line);#             message(quint,*status); 
             }            else             counter++;           } (         ch = getline(fptr, linebuf, 90);         line++; 	         }        fclose(fptr);        *status = OK; 
       return;        }          /* write a quintuple file. */@ void write_tm_file( char *fname, struct qlist *ql, int *status )       { %       void getcmd(/*char*, char* */); #       int iscmd(/*char*, char* */);        FILE *fptr;        struct quint *qptr;        char ch,lastchar;        int j;2       int counter = 0;     /* quintuple counter */       int cptr=0;          if (ql->root == NULL) 	         {          *status = NO_QLIST;          return; 	         }   8 /* if no extension is entered, supply the default:    */%       if ( strchr(fname,'.') == NULL)            strcat(fname,".tm");  +       if((fptr = fopen(fname,"w")) == NULL) 	         {           *status = NO_WRITE_OPEN;         return; 	         }   "       if ( ql->header[0] == '\0' )	         { K         getcmd("want to enter comments at the top of the file [n]?: ",ans); 1         if ( iscmd (ans,"y") || iscmd (ans,"Y") )            {            lastchar = 0; F           printf("Type text, terminate input with '.' on newline.\n");)           while ( (ch=getchar()) != EOF ) 
             { C             if ( ch == '.' && (lastchar == '\n' || lastchar == 0) )                { H               getchar();  /*  empty the <cr> from the keyboard buffer */               break;                 }              lastchar = ch;             putc(ch,fptr);
             }            putc('\n',fptr);             } 	         } 
       else	         { *         while ( ql->header[cptr] != '\0' )*           putc( ql->header[cptr++], fptr);	         } 
                  qptr = ql->root;9       qptr = qptr->nextptr;  /* first quint is a dummy */        while(1)         if (qptr == NULL)            break;         else           {            putc('(',fptr); )           putc(qptr->current_state,fptr); *           putc(qptr->current_symbol,fptr);'           putc(qptr->next_symbol,fptr); &           putc(qptr->next_state,fptr);            putc(qptr->move,fptr);           counter++;*           for (j=0; j<COMMENT_LENGTH; j++))             if (qptr->comment[j] == '\0')                break;             else*               putc(qptr->comment[j],fptr);           putc('\n',fptr);           qptr = qptr->nextptr;            }          fclose(fptr); A       printf("%d quintuples were written to %s\n",counter,fname);        *status = OK; 
       return;        }     ) /*  Read a macro stream from a disk file. A     The name of the macro will be the filename without extension.  */C void read_mac_file (char *macname, struct maclist *ml, int *status)        {        FILE *fptr; 3       void del_all_mac(/*struct maclist*, int* */); E       struct macword *new_macword(/*struct maclist*, char*, int* */); !       char namebuf[MNAME_LENGTH]; 3       char linebuf[90], getline(FILE*, char*, int); $       char wordbuf[MAC_WORD_LENGTH];       char ch, cha;        int i,j,gotone=0;   K /* append the default file type if it is not supplied, and open the file */ (       if ( strchr(macname,'.') == NULL )!           strcat(macname,".mac"); -       if((fptr = fopen(macname,"r")) == NULL) 	         {          *status = NO_READ_OPEN;          return; 	         }   ! /* clear out the macro buffer  */        del_all_mac(ml,status);   6 /* write the name of the macro in the macro buffer  */&       for ( i=0; i<MNAME_LENGTH ; i++)         if ( macname[i]!='.' )"           namebuf[i] = macname[i];         else           {            namebuf[i] = '\0';           break;           } 4       strncpy(ml->list_name, namebuf, MNAME_LENGTH);  ' /* read the file one line at a time  */ .       while(1)     /* read a line per loop  */	         { (         ch = getline(fptr, linebuf, 90);0         if ( ch == EOF && strlen(linebuf) == 0 )           break;P         if ( linebuf[0] != '#' && linebuf[0] != '!')   /* not a comment line  */           { <           i = 0;        /* linebuf character counter      */2           while(1)      /* read a word per loop */
             { <             j = 0;      /* wordbuf character counter      */<                         /* skip over white space          */;             while ( (cha=linebuf[i++])==' ' || cha=='\t' ); 9             if ( cha == 10 || cha == EOF || cha == '\0')                 break;             wordbuf[j++] = cha; M                         /* read a quoted string.  Don't let it span lines. */              if ( cha == '\"' )               while (1)                  { 2                 cha = wordbuf[j++] = linebuf[i++];@                 if (cha == '\"' )    /* end of quoted string. */F                   {                  /* get comma or semicolon, etc */?                   while ( (cha=linebuf[i++])!=' ' && cha!='\t'  ?                                         && cha!=10 && cha!=EOF) '                     wordbuf[j++] = cha;                    break;                   } =                 if ( cha == 10 || cha == EOF || cha == '\0')                     { K                   *status = NO_STR_END;      /* error-- no end of string */ O                   del_all_mac(ml,status);   /* clear out what has been stored*/ $                   wordbuf[j] = '\0';>                   return;                   /* ... and quit */                   }                  } B             else       /* read a word delimited by white-space  */               { ;               while ( (cha=linebuf[i++])!=' ' && cha!='\t'  ?                                         && cha!=10 && cha!=EOF) #                 wordbuf[j++] = cha;                }              wordbuf[j] = '\0';=                        /* store the word or quoted string  */ ,             new_macword(ml, wordbuf,status);             gotone = 1; *             if ( cha == 10 || cha == EOF )               break;
             }            } 	         }        fclose(fptr);        if ( gotone )          *status = OK; 
       else         *status = EMPTY_MFILE;
       return;        }      /* write a macro file. */B void write_mac_file (char *fname, struct maclist *ml, int *status)       {        FILE *fptr;        struct macword *mptr;        int linecount=0, i;        char ch;         if ( ml->root == NULL ) 	         {          *status = NO_MACRO;          return; 	         }   8 /* if no extension is entered, supply the default:    */%       if ( strchr(fname,'.') == NULL)            strcat(fname,".mac");   +       if((fptr = fopen(fname,"w")) == NULL) 	         {           *status = NO_WRITE_OPEN;         return; 	         }          mptr = ml->root;       while(1)	         { A         mptr = mptr->nextptr;        /* there is no first word */          if (mptr == NULL)            break;         i = 0;/         while( (ch = mptr->word[i++]) != '\0' )            {            linecount++;           putc(ch,fptr);           }          linecount++;         putc(' ',fptr); 9         if (linecount >= 60)  /* wrap to the next line */            {            putc('\n',fptr);           linecount = 0;           } 	         }        fclose(fptr);        *status = OK; 
       return;        }     ? /* read a line from standard input (from Kernigan and Ritchie)  @    function value is the last character read.                 */ /**/- char getline(FILE *fptr, char *buff, int lim)        { 
       char c;        int i;         i = 0;=       while (--lim > 0 && (c=getc(fptr)) != EOF && c != '\n')          buff[i++] = c;       if (c == '\n')         buff[i++] = c;       buff[i] = '\0';        return(c);       } 