! Descrip.MMS to build all of Mosaic 2.0
! Bjorn S. Nilsson, Aleph, CERN, 22-Nov-1993
! Support for Motif 1.2 added on 3-Jun-1994
! Mosaic 2.4 on 21-Aug-1994
!
! Usage:
!        $ MMS/MACRO=(macro_list)
!
! This DESCRIP.MMS may need several of the following macros:
!  MULTINET=1              Use MULTINET (default is UCX)
!  DEBUG=1                 Make a debug executable
!  DECC=1                  DEC C compilation.
!  PATHWAY=1               Use PathWay as TCP transport. (PathWay is
!                          Wollongong)
!  MOTIF1_2                Use Motif 1.2 libraries.
!  NOWAIS=1                Compile without direct WAIS support
!
!
! You should also check the DESCRIP.MMS files in the subdirectories. There
! are some hard-coded options.
!

.FIRST
	@ @MMS_Check "$(MMSQUALIFIERS)"

.IFDEF NOWAIS
default : libwww2 libXmx libhtmlw src
.ELSE
default : libWAIS libwww2 libXmx libhtmlw src
.ENDIF
	@ Write SYS$Output "The executable is in [.src]Mosaic.exe"

libWAIS :
	@ Write SYS$Output "--- Building libWAIS"
	@ Set Default [.freeWAIS-0_3.ir]
	@ $(MMS)$(MMSQUALIFIERS)
	@ Set Default [-.-]

libXmx :
	@ Write SYS$Output "--- Building libXmx"
	@ Set Default [.libxmx]
	@ $(MMS)$(MMSQUALIFIERS)
	@ Set Default [-]

libhtmlw :
	@ Write SYS$Output "--- Building libhtmlw"
	@ Set Default [.libhtmlw]
	@ $(MMS)$(MMSQUALIFIERS)
	@ Set Default [-]

libwww2 :
	@ Write SYS$Output "--- Building libwww2"
	@ Set Default [.libwww2]
	@ $(MMS)$(MMSQUALIFIERS)
	@ Set Default [-]

src :
	@ Write SYS$Output "--- Building src"
	@ Set Default [.src]
	@ $(MMS)$(MMSQUALIFIERS)
	@ Set Default [-]

clean :
	@ Write SYS$Output "--- Cleaning tree"
	@ Set Default [.freeWAIS-0_3.ir]
	@ Delete *.obj.*, *.olb.*
	@ Set Default [-.-]
!
	@ Set Default [.libxmx]
	@ Delete *.obj.*, *.olb.*
	@ Set Default [-]
!
	@ Set Default [.libhtmlw]
	@ Delete *.obj.*, *.olb.*
	@ Set Default [-]
!
	@ Set Default [.libwww2]
	@ Delete *.obj.*, *.olb.*
	@ Set Default [-]
!
	@ Set Default [.src]
	@ Delete *.obj.*
	@ Set Default [-]
