# 	LOGICAL FUNCTION INTERACTIVE_INPUT    **( *	LOGICAL FUNCTION INTERACTIVE_INPUT ( ) *  * D *	Returns a .TRUE. result if and only if  the  file  SYS$INPUT  is a *	a terminal device. *  *	.INDEX ENVIRONMENT>> *	.INDEX TERMINAL I/O>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53   *			   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)   % 	PARAMETER ( PCB$V_BATCH   =   'E'X ) % 	PARAMETER ( PCB$V_NETWRK  =  '15'X ) % 	PARAMETER ( DVI$_DEVCLASS =   '4'X ) % 	PARAMETER ( DC$_TERM      =  '42'X ) % 	PARAMETER ( SS$_IVDEVNAM  = '144'X )    	CHARACTER*12 DEVICE 	INTEGER ITMLST(4)
 	LOGICAL TERM   " 	COMMON /USER_DATA_/ PID,PROC_STAT     	DEVICE = 'SYS$INPUT:'   	ASSIGN 10 TO IT  	 	GO TO 30    10	INTERACTIVE_INPUT = TERM    	RETURN        	ENTRY INTERACTIVE_OUTPUT    **) *	LOGICAL FUNCTION INTERACTIVE_OUTPUT ( )  *  * D *	Returns a .TRUE. result if and only if  the file  SYS$OUTPUT  is a *	a terminal device. *  *	.INDEX ENVIRONMENT>> *	.INDEX TERMINAL I/O>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53   *			   Dahlgren, Virginia  22448 *    	DEVICE = 'SYS$OUTPUT:'    	ASSIGN 20 TO IT  	 	GO TO 30    20	INTERACTIVE_OUTPUT = TERM   	RETURN        	ENTRY INTERACTIVE_MODE    **' *	LOGICAL FUNCTION INTERACTIVE_MODE ( )  *  * D *	Returns a .TRUE. result if and only if the file  SYS$COMMAND  is a *	a terminal device. *  *	.INDEX ENVIRONMENT>> *	.INDEX TERMINAL I/O>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	25 Aug 1986	   Dahlgren, Virginia  22448 *    	DEVICE = 'SYS$COMMAND:'   	ASSIGN 25 TO IT  	 	GO TO 30    25	INTERACTIVE_MODE = TERM   	RETURN        	ENTRY BATCH_MODE    **! *	LOGICAL FUNCTION BATCH_MODE ( )  *  * D *	Returns a .TRUE. result if and only if called from a program  run- *	ning in a batch process. *  *	.INDEX ENVIRONMENT>> *	.INDEX BATCH JOBS>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53   *			   Dahlgren, Virginia  22448 *    	CALL USER_HAS_PRIV(' ')  9 	BATCH_MODE = IAND(PROC_STAT,ISHFT(1,PCB$V_BATCH)) .NE. 0    	RETURN        	ENTRY NETWORK_MODE    **# *	LOGICAL FUNCTION NETWORK_MODE ( )  *  * D *	Returns a .TRUE. result if and only if called from a program  run- *	ning in a network process. *  *	.INDEX ENVIRONMENT>> *	.INDEX NETWORK JOBS>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55   *			   Dahlgren, Virginia  22448 *    	CALL USER_HAS_PRIV(' ')  < 	NETWORK_MODE = IAND(PROC_STAT,ISHFT(1,PCB$V_NETWRK)) .NE. 0   	RETURN        30	TERM = .FALSE.   . 	CALL ITEM_LIST(ITMLST,DVI$_DEVCLASS,DEVCLASS)  4 	STATUS = SYS$GETDVIW( , , DEVICE , ITMLST , , , , )  = 	IF (STATUS.EQ.SS$_IVDEVNAM) GO TO IT ! Name ASSIGNed to file   - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	TERM = DEVCLASS .EQ. DC$_TERM  	 	GO TO IT    	END, 	LOGICAL FUNCTION USER_HAS_PRIV( PRIV_NAME )   **- *	LOGICAL FUNCTION USER_HAS_PRIV( priv_name )  *  * D *	This function returns a value of .TRUE. if this  process  has  theD *	named privilege (passed as a character string), or returns a valueD *	of  .FALSE.  if this process does not have the privilege or if the, *	name is not the name of a known privilege. * D *	In addition, other information about this process is  returned  in *	in common /USER_DATA_/:  * 5 *	    The PID, process status flags, UIC (longwords),  * D *	    The process name, terminal name (if any), user name (strings), * A *	    The lengths of the valid parts of the name strings (words).  * % *	The format of this common block is:  *  *		INTEGER*4 PID,PROC_STAT,UIC *		CHARACTER*16 PROCNAME *		CHARACTER*8 TERMNAME  *		CHARACTER*12 USERNAME *		INTEGER*2 PNLEN,TNLEN,UNLEN * ) *		COMMON /USER_DATA_/ PID,PROC_STAT,UIC, ' *		1		      PROCNAME,TERMNAME,USERNAME, $ *		2		       PNLEN,   TNLEN,   UNLEN *  * D *	If you desire to see information in addition to this, you can haveD *	additional data returned by placing your requests  in  the  ITMLSTC *	array in common /USER_PRIV_/.  The format of the common block is:  *  *		INTEGER*4 ITMLST(28)  *		COMMON /USER_PRIV_/ ITMLST  * D *	Your requests may start in ITMLST(22).  See the  writeup  for  theD *	$GETJPI  System  Service  in the VAX/VMS System Services ReferenceD *	Manual for the format of the request (each request uses 3 elementsD *	of ITMLST; the last request must be followed by a zero word).  YouD *	may define ITMLST to be longer than 28 elements if necessary; rou-2 *	tine ITEM_LIST can be used to add your requests. *  *	.INDEX ENVIRONMENT>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 + *	19 Aug 1983 	   Dahlgren, Virginia  22448  *    	IMPLICIT INTEGER (A-Z)    	CHARACTER*(*) PRIV_NAME 	CHARACTER*6 PRIV  	CHARACTER*186 PRIVS   	INTEGER*4 PID,PROC_STAT,UIC 	CHARACTER*16 PROCNAME 	CHARACTER*8 TERMNAME  	CHARACTER*12 USERNAME 	INTEGER*2 PNLEN,TNLEN,UNLEN  B 	COMMON /USER_DATA_/ PID,PROC_STAT,UIC,PROCNAME,TERMNAME,USERNAME,$ 	1				       PNLEN,   TNLEN,   UNLEN  % 	PARAMETER ( JPI$_PID      = '319'X ) % 	PARAMETER ( JPI$_PRCNAM   = '31C'X ) % 	PARAMETER ( JPI$_PROCPRIV = '204'X ) $ 	PARAMETER ( JPI$_STS      = '305'X)% 	PARAMETER ( JPI$_TERMINAL = '31D'X ) % 	PARAMETER ( JPI$_UIC      = '304'X ) % 	PARAMETER ( JPI$_USERNAME = '202'X )    	INTEGER*4 ITMLST(28) / 28*0 /   	COMMON /USER_PRIV_/ ITMLST   A *	ITMLST(22) through ITMLST(27) can be set by the calling program @ *	before the first call to USER_HAS_PRIV, to get additional data *	about the process.   	INTEGER*4 PRIVILEGES   	LOGICAL*1 FIRST_CALL / .TRUE. /  H       DATA PRIVS/'CMKRNLCMEXECSYSNAMGRPNAMALLSPODETACHDIAGNOLOG_IOGROUP H      1ACNT  PRMCEBPRMMBXPSWAPMALTPRISETPRVTMPMBXWORLD MOUNT OPER  EXQUOTH      2NETMBXVOLPROPHY_IOBUGCHKPRMGBLSYSGBLPFNMAPSHMEM SYSPRVBYPASSSYSLCK      3'/   	IF (FIRST_CALL) THEN    	    FIRST_CALL = .FALSE.   < 	    SAVE = ITMLST(22)		! (in case user added items already)  ( 	    CALL ITEM_LIST(ITMLST,JPI$_PID,PID," 	1			  JPI$_PRCNAM,PROCNAME,PNLEN,  	2			  JPI$_PROCPRIV,PRIVILEGES, 	3			  JPI$_STS,PROC_STAT,$ 	4			  JPI$_TERMINAL,TERMNAME,TNLEN, 	5			  JPI$_UIC,UIC,$ 	6			  JPI$_USERNAME,USERNAME,UNLEN)   	    ITMLST(22) = SAVE  ' 	    STATUS = SYS$GETJPIW(,,,ITMLST,,,)   1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	    UNLEN = STR_LEN(USERNAME)   	ENDIF   	PRIV = PRIV_NAME    	I = INDEX(PRIVS,PRIV)   	IF (MOD(I,6).NE.1) GO TO 100   $ 	IF (PRIVS(I:I+5).NE.PRIV) GO TO 100  5 	USER_HAS_PRIV = IAND(PRIVILEGES,ISHFT(1,I/6)) .NE. 0    	RETURN    100	USER_HAS_PRIV = .FALSE.    	END, 	LOGICAL FUNCTION GETJPI( FLAGS , SHOWSUSP )   **5 *	LOGICAL FUNCTION GETJPI( [ flags ] , [ showsusp ] )  *  * D *	Returns information about all the processes on the system.  Infor-D *	mation about one process is returned each time GETJPI  is  called.D *	A function value of  .FALSE.  is returned after all processes haveD *	been examined; subsequent calls to GETJPI will start  the  process *	scan again at the beginning. * D *	The optional argument FLAGS may be used to select a class of  pro- *	cesses to be examined: * @ *	    If FLAGS is not present, or is zero, examine all processes * > *	    If FLAGS is one, examine only user interactive processes * 8 *	    If FLAGS is two, examine only user batch processes * D *	    If FLAGS is three, examine only  user  interactive  and  batch *	    processes  * D *	In addition, if bit 8 of FLAGS is on ('100'X), the process scan isD *	restarted again at the beginning, even if all processes  have  notD *	been examined;  only the lower byte of FLAGS is used to select the *	class of processes.  * D *	Only if the calling process has  WORLD  privilege  is  informationD *	about  all  processes  returned.   If the calling process has onlyD *	GROUP privilege, then only this group's processes are scanned.  IfD *	it has neither  WORLD  or  GROUP privilege, then only THIS process4 *	process and its subprocesses (if any) are scanned. *  *	.INDEX ENVIRONMENT>> * = *	The following information is returned in common /GETJPI_1/:  * 5 *	    The PID, process status flags, UIC (longwords),  * D *	    The process name, terminal name (if any), user name (strings), * A *	    The lengths of the valid parts of the name strings (words).  * % *	The format of this common block is:  *  *		INTEGER*4 PID,PROC_STAT,UIC *		CHARACTER*16 PROCNAME *		CHARACTER*8 TERMNAME  *		CHARACTER*12 USERNAME *		INTEGER*2 PNLEN,TNLEN,UNLEN * ' *		COMMON /GETJPI_1/ PID,PROC_STAT,UIC, $ *		1		   PROCNAME,TERMNAME,USERNAME,! *		2		    PNLEN,   TNLEN,   UNLEN  *- * D *	If you desire to see information in addition to this, you can haveD *	additional data returned by placing your requests  in  the  ITMLST@ *	array in common /GETJPI_/.  The format of the common block is: *  *		INTEGER*4 ITMLST(25)  *		COMMON /GETJPI_/ ITMLST * D *	Your requests may start in ITMLST(19).   See the writeup  for  theE *	$GETJPI  System  Service  in the VAX/VMS System Services Reference  D *	Manual for the format of the request (each request uses 3 elementsD *	elements of  ITMLST;  the last request must be followed by  a zeroD *	word).   You may define  ITMLST  to be longer than  25 elements if@ *	necessary; routine ITEM_LIST can be used to add your requests. * D *	If you do request additional information, the information  you re-D *	quest may not be available for processes which are suspended or inD *	MWAIT state.   For instance,  the image name is not  available forD *	suspended jobs.   By default,  if you request such information andD *	the process being examined is suspended or in MWAIT,  the  processD *	is ignored; it is as if it did not exist.  If you wish to see sus-D *	pended processes, use the optional argument SHOWSUSP.   It must beD *	an INTEGER*4 or LOGICAL*4 variable; it will be set  .TRUE.  if theD *	process is not suspended and not in MWAIT, .FALSE. if suspended or *	in MWAIT.  *  * $ *	14 Dec 83	Added SHOWSUSP argument.) *	14 Mar 85	Use GETJPIW instead of GETJPI  *	14 Dec 86	Use LIB$GET_EF *  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	18 Nov 1983	   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)L   	INTEGER*4 PID,PROC_STAT,UIC 	CHARACTER*16 PROCNAME 	CHARACTER*8 TERMNAME( 	CHARACTER*12 USERNAME 	INTEGER*2 PNLEN,TNLEN,UNLEN  @ 	COMMON /GETJPI_1/ PID,PROC_STAT,UIC,PROCNAME,TERMNAME,USERNAME,$ 	1				       PNLEN,   TNLEN,   UNLEN  ! 	PARAMETER ( PCB$V_BATCH = 'E'X )W  % 	PARAMETER ( JPI$_PID      = '319'X )D% 	PARAMETER ( JPI$_PRCNAM   = '31C'X )I% 	PARAMETER ( JPI$_STS      = '305'X )B% 	PARAMETER ( JPI$_TERMINAL = '31D'X )N% 	PARAMETER ( JPI$_UIC      = '304'X )E% 	PARAMETER ( JPI$_USERNAME = '202'X )R   	INTEGER*4 ITMLST(25) / 25*0 /   	COMMON /GETJPI_/ ITMLST   	INTEGER*2 IOSB(4)   	LOGICAL FIRST_CALL / .TRUE. / 	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  1 	EXTERNAL SS$_SUSPENDED,SS$_NOPRIV,SS$_NOMOREPROC   * 	FLAGS_ = DEFAULT_ARG(%VAL(IARGPTR()),1,0)  1 	IF (FIRST_CALL.OR.IAND(FLAGS_,'100'X).NE.0) THENA   	    IF (FIRST_CALL) THEN  		STATUS = LIB$GET_EF(EFN). 		IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))
 	    ENDIF   	    FIRST_CALL = .FALSE.X  < 	    SAVE = ITMLST(19)		! (in case user added items already)  ( 	    CALL ITEM_LIST(ITMLST,JPI$_PID,PID," 	1			  JPI$_PRCNAM,PROCNAME,PNLEN, 	2			  JPI$_STS,PROC_STAT,$ 	3			  JPI$_TERMINAL,TERMNAME,TNLEN, 	4			  JPI$_UIC,UIC,$ 	5			  JPI$_USERNAME,USERNAME,UNLEN)   	    ITMLST(19) = SAVE   	    PIDADR = -1   	ENDIF  C 10	STATUS = SYS$GETJPIW( %VAL(EFN) , PIDADR , , ITMLST , IOSB , , )    	IF (.NOT.STATUS) THEN  0 	    IF (STATUS.EQ.%LOC(SS$_SUSPENDED)) GO TO 200 	    IF (STATUS.EQ.%LOC(SS$_NOPRIV))    GO TO 10  - 	    IF (STATUS.EQ.%LOC(SS$_NOMOREPROC)) THENg 		GETJPI = .FALSE.
 		PIDADR = -1  		RETURN
 	    ENDIF    	    CALL LIB$STOP(%VAL(STATUS))   	ENDIF   20	IF (.NOT.IOSB(1)) THEN   - 	    IF (IOSB(1).EQ.%LOC(SS$_SUSPENDED)) THENA  1 		IF (.NOT.ARG_EXIST(%VAL(IARGPTR()),2)) GO TO 10.  	 	    ELSEd   		CALL LIB$STOP(%VAL(IOSB(1)))  
 	    ENDIF   	ENDIF   	GETJPI = .TRUE.   	UNLEN = STR_LEN(USERNAME)  5 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) SHOWSUSP = IOSB(1)C   	IF (FLAGS_.EQ.0) RETURN  	 	MODE = 0, 	IF (TNLEN.NE.0) MODE = 1L8 	IF (IAND(PROC_STAT,ISHFT(1,PCB$V_BATCH)).NE.0) MODE = 2  % 	IF (IAND(FLAGS_,MODE).EQ.0) GO TO 10    	END9 	INTEGER FUNCTION SEND_MESSAGE(USERNAME,MESSAGE,FLAGS,ID)    **A *	INTEGER FUNCTION SEND_MESSAGE ( user , message [,flags] [,id] )u *  *iD *	Sends a message to a given terminal, to a given logged-in user, orD *	to all connected terminals.  This routine requires OPER privilege,( *	and works cluster-wide on VAXclusters. *8D *	The  first  two arguments are required, and are character strings. *1D *	If the first argument contains a colon, it is assumed  to  be  theB *	name of a terminal, and the message is sent there.  For example: *D' *		CALL SEND_MESSAGE('TTA0:',' Hello ')Q *$D *	If the first argument is blank, the message is sent to all termin-D *	als connected  to the system, whether users are  logged in at them	 *	or not.  *GD *	Otherwise, the first argument is assumed to be someone's Username.D *	The message is sent to all terminals  (if any)  at which the named" *	user is logged in.  For example: *e *		INTEGER SEND_MESSAGEc *a* *		N = SEND_MESSAGE('JONES','  Goodbye  ') * D *	In this case, the calling process needs OPER privilege,  and GROUPD *	privilege  if the user is in the same group, or WORLD privilege ifD *	privilege if the user is not in the same group.  The function res-? *	ult is the number of terminals to which the message was sent.h *r3 *	The message must not be over 256 characters long.s * D *	The optional integer argument FLAGS controls the formatting of the6 *	message.  Each bit controls one formatting function: *R9 *		Bit 0 -- Ring the recieving terminal's bell four timesR *T= *		Bit 1 -- Display the message on the recieving terminal  inL6 *			 bold  reverse  video  (valid  for VTxxx terminals6 *			 only).  For best readability, the message  should6 *			 be  surrounded by blanks, like in the above exam-
 *			 ples. *i= *		Bit 2 -- Do not send this message cluster-wide.   This bit 6 *			 only has effect on a VAXcluster,  and only if the6 *			 message is  being sent to a user or to  all users6 *			 (messages sent  to terminal names  are never sent *			 cluster-wide).t *  *	.INDEX MESSAGES>>h *-D *	If FLAGS  is omitted,  the default value of 3 is used  (ring bell,/ *	display in reverse video, send cluster-wide).r *eD *	The optional integer argument ID controls the class of the messageD *	as defined by the SET BROADCAST command.   If omitted, the default8 *	is GENERAL.  The value 4 is SHUTDOWN, and 5 is URGENT. *d * = *	1 Aug 85	Add carriage return at  beginning of message,  addi4 *			option to send to all users, upgrade to VMS 4.0. * > *	31 Aug 85	Change meaning of blank first argument from  "send6 *			to all logged-in users" to  "send to all connected *			terminals".1 *P% *	19 Nov 92	Add optional ID argument.C *A *R1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53R* *	20 Nov 1983	   Dahlgren, Virginia  22448 *D   	IMPLICIT INTEGER (A-Z)M  / 	PARAMETER ( BRK$C_ALLUSERS = '3'x )	! Not usedN$ 	PARAMETER ( BRK$C_ALLTERMS = '4'x )$ 	PARAMETER ( BRK$C_DEVICE   = '1'x )$ 	PARAMETER ( BRK$C_USERNAME = '2'x )& 	PARAMETER ( BRK$M_CLUSTER  = '800'x )$ 	PARAMETER ( BRK$C_SHUTDOWN = '4'x )$ 	PARAMETER ( BRK$C_URGENT   = '5'x )   	CHARACTER*(*) USERNAME,MESSAGEA   	INTEGER*2 IOSB(4)  	LOGICAL*1 FIRST_CALL / .TRUE. /   	CHARACTER*280 BUFFER    	CHARACTER*1 ESC,BEL,CRS 	CHARACTER*6 FRT 	CHARACTER*3 BCK 	CHARACTER*4 BELSf   	PARAMETER ( CR   = CHAR(13) ) 	PARAMETER ( ESC  = CHAR(27) ) 	PARAMETER ( BEL  = CHAR(7) ) " 	PARAMETER ( FRT  = ESC//'[1;7m' ) 	PARAMETER ( BCK  = ESC//'[m' )Y( 	PARAMETER ( BELS = BEL//BEL//BEL//BEL )   	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR   	EXTERNAL SS$_DEVOFFLINE  - 	FLAGS_ = DEFAULT_ARG(%VAL(IARGPTR()),3,'3'x)M- 	ID_    = DEFAULT_ARG(%VAL(IARGPTR()),4,'0'x)R   	MLEN = LEN(MESSAGE) + 1 	BUFFER(1:MLEN) = CR // MESSAGET   	IF (IAND(FLAGS_,1).NE.0) THEN! 	    BUFFER(MLEN+1:MLEN+4) = BELS( 	    MLEN = MLEN + 4 	ENDIF   	IF (IAND(FLAGS_,2).NE.0) THEN: 	    BUFFER(1:MLEN+9) = CR // FRT // BUFFER(2:MLEN) // BCK 	    MLEN = MLEN + 9 	ENDIF   	BFLAGS = 0_  G 	IF ( INDEX(USERNAME,':') .NE. 0 ) THEN	       ! Send to given terminal    	    SNDTYP = BRK$C_DEVICE   	ELSE IF (USERNAME.EQ.' ') THEN    	    SNDTYP = BRK$C_ALLTERMS4 	    IF (IAND(FLAGS_,4).EQ.0) BFLAGS = BRK$M_CLUSTER   	ELSE    	    SNDTYP = BRK$C_USERNAME4 	    IF (IAND(FLAGS_,4).EQ.0) BFLAGS = BRK$M_CLUSTER   	ENDIF   	IF (FIRST_CALL) THENN 	    FIRST_CALL = .FALSE.. 	    STATUS = LIB$GET_EF(EF)1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))J 	ENDIF  8 	STATUS = SYS$BRKTHRUW(%VAL(EF),BUFFER(1:MLEN),USERNAME,; 	1	    %VAL(SNDTYP),IOSB,,%VAL(BFLAGS),%VAL(ID_),%VAL(5),,)    	SEND_MESSAGE = IOSB(2)n  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   , 	IF (IOSB(1).EQ.%LOC(SS$_DEVOFFLINE)) RETURN  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))e   	END' 	SUBROUTINE SEND_SECURITY_MESSAGE(TEXT)t   *** *	SUBROUTINE SEND_SECURITY_MESSAGE( text ) *	 * D *	Uses the $SNDOPR System Service  to send a message to the OperatorD *	Log and to all terminals enabled as SECURITY operators.  The mess-D *	age is the character string argument TEXT,  which can be up to 255 *	characters long. *	 * > *	19 Sep 88	Set OPER12 bit as well as SECURITY bit, so message6 *			will go to log,  even if no terminals are SECURITY *			operators.9 *	 4 Oct 88	Do not limit message length to 80 characters.,> *	 4 Jan 90	Remove 19 Sep 88 change; not believed necessary in *			VMS 5.2.( *	 4 Mar 90	Re-install 19 Sep 88 change. *r *	.INDEX MESSAGES>>d * 1 *	Alan L. Zirkle     Naval Surface Warfare Centerh *			   Code K53 ) *	6 Aug 1987	   Dahlgren, Virginia  22448b *    	IMPLICIT NONE   	INCLUDE '($OPCDEF)'   	CHARACTER*(*) TEXTR   	STRUCTURE /MESSAGE/ 	  UNION 	    MAP 	      BYTE TYPE 	      BYTE %FILL(3) 	      INTEGER*4 RQSTIDe 	      CHARACTER*255 TEXT	 	    END MAP 	    MAP 	      INTEGER*4 TARGET. 	    ENDMAPX 	    MAP 	      CHARACTER*263 STRINGo 	    END MAP 	  END UNION 	END STRUCTURE   	RECORD /MESSAGE/ MSGBUF  ! 	INTEGER*4 SLEN,STATUS,SYS$SNDOPR	  = 	MSGBUF.TARGET = ISHFT(OPC$M_NM_SECURITY,8)	! Order dependent,5 	1		     + ISHFT(OPC$M_NM_OPER12,8)	! Order dependents 							! Order dependent/ 	MSGBUF.TYPE = OPC$_RQ_RQST			! Order dependentR   	MSGBUF.RQSTID = 0   	MSGBUF.TEXT = TEXTE   	SLEN = LEN(TEXT) + 8   , 	STATUS = SYS$SNDOPR(MSGBUF.STRING(1:SLEN),)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))T   	END6 	INTEGER FUNCTION SYMBOL_SUBSTITUTE(LINE,NEWLEN,FOUND)   **A *	INTEGER FUNCTION SYMBOL_SUBSTITUTE( line , [newlen] , [found] )t *h * D *	Performs DCL symbol substitution on any symbol  names  found  in aD *	character  string.   The symbol name must be delimited by apostro-D *	phes (single quotes)(').  There should not be two adjacent openingD *	apostrophes, as in some DCL constructs.   If the substring betweenD *	apostrophes is not a defined DCL symbol, this is not considered an *	error. *fD *	You may also re-define the delimiters to be  characters other thanD *	apostrophes.  The opening and closing delimiters can be different,D *	if desired.   To do this, place the desired characters in the var-* *	iables OPEN and CLOSE, as defined below: *q *		CHARACTER*1 OPEN,CLOSEu# *		COMMON /SYMBOL_SUBS_/ OPEN,CLOSEm *oD *	This routine is useful for processing lines  read  from  SYS$INPUTD *	within command procedures, since these lines do not have automatic' *	symbol substitution performed by DCL.t *	D *	LINE is the character string to be processed.   The optional inte-D *	ger  argument  NEWLEN, if supplied, is set upon exit to the lengthD *	of LINE, not counting any rightmost blanks or tabs, after any sub-D *	stitutions have been made. The optional integer argument FOUND, ifD *	supplied,  is set upon exit  to the number of symbol substitutions *	made., *AD *	The functional result is the status value SS$_NORMAL,  unless sym-D *	bol  substitution caused non-blank, non-tab characters to be trun-D *	cated from the right end of LINE, in which case the  status  value *	STR$_TRU is returned.8 *v *86 *	21 Mar 1986	Allow delimiters other than apostrophes. *Z *	.INDEX DCL SYMBOLS>> *T1 *	Alan L. Zirkle     Naval Surface Warfare CenterM *			   Code K53 * *	16 Feb 1984	   Dahlgren, Virginia  22448 *O   	IMPLICIT INTEGER (A-Z)U   	CHARACTER*(*) LINEE   	CHARACTER*256 VALUE   	EXTERNAL SS$_NORMAL, STR$_TRU   	LOGICAL ARG_EXIST   	CHARACTER*1 OPEN,CLOSE   ! 	COMMON /SYMBOL_SUBS_/ OPEN,CLOSER   	DATA OPEN,CLOSE / '''','''' /   	GOOD_LEN = STR_LEN(LINE)R  % 	SYMBOL_SUBSTITUTE = %LOC(SS$_NORMAL)M	 	SUBS = 0_ 	COL = 1  # 10	COL1 = SUBINDEX(LINE, COL, OPEN)= 	IF (COL1.EQ.0) GO TO 30  & 20	COL = SUBINDEX(LINE, COL1+1, CLOSE) 	IF (COL.EQ.0) GO TO 30)  9 	STATUS = LIB$GET_SYMBOL(LINE(COL1+1:COL-1), VALUE, VLEN)G  F 	IF (.NOT.STATUS) THEN	      ! Name between quotes is not a DCL symbol   	    COL1 = COLV
 	    GO TO 20,   	ENDIF	F   	SUBS = SUBS + 1    	DELTA = VLEN - (COL - COL1 + 1)  , 	LINE(COL1:) = VALUE(1:VLEN) // LINE(COL+1:)  & 	IF (GOOD_LEN+DELTA.GT.LEN(LINE)) THEN  ' 	    SYMBOL_SUBSTITUTE = %LOC(STR$_TRU)E 	    GOOD_LEN = LEN(LINE))
 	    GO TO 30e   	ENDIF   	GOOD_LEN = GOOD_LEN + DELTA 	COL = COL + DELTA + 1	 	GO TO 10I  6 30	IF (ARG_EXIST(%VAL(IARGPTR()),2)) NEWLEN = GOOD_LEN  / 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) FOUND = SUBSI   	END! 	INTEGER FUNCTION STR_LEN(STRING)    **$ *	INTEGER FUNCTION STR_LEN( string ) *E *FD *	Returns, as the functional result, the  length  of  the  characterD *	string  argument  STRING,  minus any rightmost blanks and/or tabs. *O *	.INDEX STRING MANIPULATION>> *_1 *	Alan L. Zirkle     Naval Surface Warfare Center_ *			   Code K53g* *	26 Feb 1984	   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)$   	CHARACTER*(*) STRINGD   	STR_LEN = LEN(STRING)   	DO WHILE (STR_LEN.GT.0)  . 	    IF ( STRING(STR_LEN:STR_LEN).NE.' ' .AND.4 	1		     STRING(STR_LEN:STR_LEN).NE.CHAR(9) ) RETURN   	    STR_LEN = STR_LEN - 1   	ENDDO   	END1 	INTEGER FUNCTION SUBINDEX(STRING,COLUMN,PATTERN))   **9 *	INTEGER FUNCTION SUBINDEX ( string , column , pattern )  *A *.D *	This is very much like the Fortran INDEX built-in function, exceptD *	that SUBINDEX begins the search at an arbitrary column within  the	 *	string.1 * D *	STRING is the character string to be searched.  COLUMN is the col-D *	umn number at which to begin the search.  PATTERN is the substring *	for which we are searching.a *vD *	The functional result is zero if the pattern is not found  in  theD *	string.   If the pattern is found, the functional result is set to> *	the column where the first occurrence of the pattern begins. *rA *	The following example shows a common mistake in using SUBINDEX:  *i5 *	    INCORRECT:   COL = SUBINDEX(STRING(22:),22,' ')e *g0 *	      CORRECT:   COL = SUBINDEX(STRING,22,' ') *A *	.INDEX STRING MANIPULATION>> *e1 *	Alan L. Zirkle     Naval Surface Warfare Centerl *			   Code K53o* *	16 Feb 1984	   Dahlgren, Virginia  22448 *e   	IMPLICIT INTEGER (A-Z)G   	CHARACTER*(*) STRING,PATTERN    	INTEGER*2 COLUMNo  * 	SUBINDEX = INDEX(STRING(COLUMN:),PATTERN)  4 	IF (SUBINDEX.NE.0) SUBINDEX = SUBINDEX + COLUMN - 1   	END5 	INTEGER FUNCTION STR_REMOVE(STRING,SUBSTRING,LENGTH)N   **@ *	INTEGER FUNCTION STR_REMOVE ( string , substring [ ,length ] ) *e * C *	Removes the  first occurrence,  if any,  of the  character stringrC *	SUBSTRING from the character string  STRING.   If a matching sub-eC *	string is found and removed,  the functional result is set to the C *	column where the string occurred, and the INTEGER*4 value  LENGTHtC *	(if present) is decremented by the length of the substring. If norC *	matching substring is found, the functional result is set to zero:C *	and the contents of the STRING and LENGTH (if present)  arguments  *	are not altered. * 0 *	Example:	Before:  STRING = 'AB~DE'  LENGTH = 5 *v, *				 COLUMN = STR_REMOVE(STRING,'~',LENGTH) *l) *			After:   STRING = 'ABDE '  LENGTH = 4u *				 COLUMN = 3 *e *	.INDEX STRING MANIPULATION>> *-1 *	Alan L. Zirkle     Naval Surface Warfare Centera *			   Code K53 * *	12 Jun 1984	   Dahlgren, Virginia  22448 *r   	IMPLICIT INTEGER (A-Z)s   	CHARACTER*(*) STRING,SUBSTRING    	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  % 	STR_REMOVE = INDEX(STRING,SUBSTRING)d   	IF (STR_REMOVE.GT.0) THEN   	    L = LEN(SUBSTRING)d  < 	    STRING = STRING(:STR_REMOVE-1) // STRING(STR_REMOVE+L:)  : 	    IF (ARG_EXIST(%VAL(IARGPTR()),3)) LENGTH = LENGTH - L   	ENDIF   	END" 	INTEGER FUNCTION COLLAPSE(STRING)   **& *	INTEGER FUNCTION COLLAPSE ( string ) *t *dD *	Removes all  blanks and tab characters  from the  character stringD *	argument STRING.   The resultant  length of the non-blank  part of, *	STRING is returned as the function result. *. *	.INDEX STRING MANIPULATION>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center- *			   Code K53n) *	9 Mar 1984	   Dahlgren, Virginia  22448	 *N   	IMPLICIT NONE   	CHARACTER*(*) STRING	   	INTEGER*4 I  
 	COLLAPSE = 0W   	DO I = 1,LEN(STRING)d  > 	    IF (STRING(I:I).NE.' ' .AND. STRING(I:I).NE.CHAR(9)) THEN   		COLLAPSE = COLLAPSE + 1R  ) 		STRING(COLLAPSE:COLLAPSE) = STRING(I:I)M  
 	    ENDIF   	ENDDO  7 	IF (LEN(STRING).GT.COLLAPSE) STRING(COLLAPSE+1:) = ' 'B   	END" 	INTEGER FUNCTION COMPRESS(STRING)   **& *	INTEGER FUNCTION COMPRESS ( string ) *  *xD *	Replaces every string of consecutive blanks and/or tabs in charac-D *	ter string argument STRING with exactly one blank.   The resultingE *	length of the compressed STRING is returned as the function result.A *R *	.INDEX STRING MANIPULATION>> *M1 *	Alan L. Zirkle     Naval Surface Warfare Center2 *			   Code K55(* *	17 Jul 1990	   Dahlgren, Virginia  22448 *1   	IMPLICIT NONE   	CHARACTER*(*) STRINGP   	INTEGER*4 I 	LOGICAL*4 LASTBLANK  
 	COMPRESS = 0E 	LASTBLANK = .FALSE.   	DO I = 1,LEN(STRING)F  > 	    IF (STRING(I:I).NE.' ' .AND. STRING(I:I).NE.CHAR(9)) THEN   		LASTBLANK = .FALSE.)   		COMPRESS = COMPRESS + 1S  ) 		STRING(COMPRESS:COMPRESS) = STRING(I:I)   " 	    ELSE IF (.NOT.LASTBLANK) THEN   		LASTBLANK = .TRUE.   		COMPRESS = COMPRESS + 1E  ! 		STRING(COMPRESS:COMPRESS) = ' 'N  
 	    ENDIF   	ENDDO  7 	IF (LEN(STRING).GT.COMPRESS) STRING(COMPRESS+1:) = ' '    	END 	INTEGER FUNCTION TRIM(STRING)   **" *	INTEGER FUNCTION TRIM ( string ) *v *tD *	Removes all  leading and trailing  blanks and tabs  from characterD *	string argument STRING; the resulting length of the trimmed STRING% *	is returned as the function result.S *Y *	.INDEX STRING MANIPULATION>> *L1 *	Alan L. Zirkle     Naval Surface Warfare CenterI *			   Code K55E* *	17 Jul 1990	   Dahlgren, Virginia  22448 *I   	IMPLICIT NONE   	CHARACTER*(*) STRINGB   	INTEGER*4 STR_LEN   	IF (LEN(STRING).GT.0) THENW  > 	    DO WHILE (STRING(1:1).EQ.' ' .OR. STRING(1:1).EQ.CHAR(9))   		STRING = STRING(2:))  
 	    ENDDO   	ENDIF   	TRIM = STR_LEN(STRING)S   	END8 	LOGICAL FUNCTION ELEMENT(N,DELIM,STRING,COL1,COL2,ELEN)   **D *	LOGICAL FUNCTION ELEMENT (n , delim , string , col1 , col2 , len ) *O *ND *	Locates the Nth "element" in character string argument STRING.  AnD *	element is a substring between occurrences of the single characterD *	DELIM.   If two delimiters appear consecutively,  they have a nullD *	element between them.   If STRING begins or ends with a delimiter,D *	it is assumed to actually begin or end with a null element.   Ele-1 *	ments are numbered 0,1,2,... and an example is:g *o. *	  if  STRING = 'A,BCD,,E,'  and  DELIM = ',' *t *	  then	element 0 = 'A' *		element 1 = 'BCD' *		element 2 = ''	 *		element 3 = 'E'" *		element 4 = ''   (last element) *nD *	Unlike the similar  DCL Lexical Function  F$ELEMENT,  this routineD *	must, for a given string,  be called in order N=0, N=1, ... , i.e.D *	it must only be used to parse a string left-to-right,  starting atD *	the beginning  of the string.   If this is not followed, no errorsD *	will occur,  but the results will be incorrect.   Also,  F$ELEMENTD *	considers a null string  to be composed  of one null element; thisD *	routine considers a null string to have no elements.  The functionD *	result is .TRUE. unless it is called  with N past the last elementD *	in the string.   Integer arguments COL1 and COL2 locate the begin-D *	ning and ending columns,  within STRING, of the element.   IntegerD *	argument LEN gives the length of the element (zero for a null ele- *	ment). *E *	.INDEX STRING MANIPULATION>> *R1 *	Alan L. Zirkle     Naval Surface Warfare CenterS *			   Code K55 * *	23 Jul 1990	   Dahlgren, Virginia  22448 *)   	IMPLICIT NONE   	INTEGER*4 N- 	CHARACTER*1 DELIM	! Note--one character onlyY 	CHARACTER*(*) STRINGW 	INTEGER*4 COL1,COL2,ELEN    	INTEGER*4 LASTCOL   	IF (N.EQ.0) THEN  	    LASTCOL = -1 & 	    IF (LEN(STRING).EQ.0) LASTCOL = 0 	ENDIF  ! 	IF (LASTCOL.GE.LEN(STRING)) THENs   	    ELEMENT = .FALSE.   	ELSEl   	    COL1 = LASTCOL + 2(* 	    COL2 = INDEX(STRING(COL1:),DELIM) - 1   	    IF (COL2.LT.0) THEN 		COL2 = LEN(STRING)	 	    ELSE  		COL2 = COL2 + LASTCOL + 1p
 	    ENDIF   	    ELEN = COL2 - COL1 + 1   / 	    LASTCOL = COL2		! For next call to ELEMENTr   	    ELEMENT = .TRUE.o   	ENDIF   	END* 	INTEGER FUNCTION CLI_INT(QUALIFIER,VALUE)   **/ *	INTEGER FUNCTION CLI_INT( qualifier , value )d *h * D *	Parses a command line parameter or qualifier which has an  integerD *	value.   The supplied value may be in either of the following for- *	mats:L *m *		i	%Di	%Oj	%Xk *iD *	where 'i' is one or more decimal digits, 'j' is one or more  octal4 *	digits, and 'k' is one or more hexadecimal digits. *yD *	The calling routine specifies in character argument QUALIFIER  theD *	name of the qualifier (or parameter) whose value is to be fetched.D *	The integer value is returned in the INTEGER*4 argument VALUE. TheD *	functional result shows the status of the parse; it is  SS$_NORMAL  *	(integer value 1) for success. * D *	If the parameter or qualifier is not present, and is not defaultedE *	present, CLI_INT will return the status value CLI$_ABSENT (current-L* *	ly hex 000381F0) as its function result. *bD *	The Command Language Definition (CLD) which includes the parameterC *	or qualifier being referenced by CLI_INT must include the clause:8 *	 *		Value( Type=$NUMBER ) *oD *	and, if a default value is to be defined, it should also be inclu- *	ed in the CLD.  Examples:C *e7 *	    Qualifier A , Value( Type=$NUMBER, Default="10" )  *4@ *	    Qualifier B , Default, Value( Type=$NUMBER, Default="10" ) *TD *	The two examples differ in the following way:  if the qualifier /BD *	is omitted entirely, the value "10" will be used;  it is defaultedD *	to be present.  If the qualifier  /A  is omitted, CLI_INT will re-D *	turn CLI$_ABSENT; if /A is present with no value, 10 will be used. *	D *	If the value is present or is defaulted in, but is not in the for-D *	mat of a legal integer, then the functional result will be a fail- *	ure status code: *LD *	    The value  0  will be returned if the qualifier was present orD *	    defaulted, but no value was present or defaulted  (i.e.  "/A",D *	    not "/A=10", and no default was defined).  Note that the usage5 *	    /QUAL="" will act as if /QUAL=0 were specified.N *ND *	    The value OTS$_INPCONERR (hex value 0017802C) will be returnedD *	    if the value is not a legal  decimal/octal/hex integer.   NoteE *-	    that this cannot happen if the "Type=$NUMBER" clause was used,2D *	    since in that case the  CLI Parser  will catch  and SIGNAL the *	    error. *G *	.INDEX ENVIRONMENT>>% *	.INDEX COMMAND LANGUAGE INTERFACE>>  *i/ *	20 Nov 87	Completely redefined and rewritten., *e *e1 *	Alan L. Zirkle     Naval Surface Warfare CenterG *			   Code K53t* *	15 Apr 1984	   Dahlgren, Virginia  22448 *A   	IMPLICIT NONE   	CHARACTER*(*) QUALIFIER 	INTEGER*4 VALUE  = 	INTEGER*4 STATUS,CLI$PRESENT,CLI$GET_VALUE,VLEN,OTS$CVT_TI_L8 	CHARACTER*32 RAW_VALUE     	STATUS = CLI$PRESENT(QUALIFIER)   	IF (.NOT.STATUS) THEN   	    CLI_INT = STATUS    	ELSE   1 	    CALL CLI$GET_VALUE(QUALIFIER,RAW_VALUE,VLEN)N   	    IF (VLEN.EQ.0) THEN  
 		CLI_INT = 0   	 	    ELSER  1 		CLI_INT = OTS$CVT_TI_L(RAW_VALUE(1:VLEN),VALUE)X  
 	    ENDIF   	ENDIF   	END2 	LOGICAL FUNCTION LIST_CHECK(ORDINAL,LIST,LISTLEN)   **9 *	INTEGER FUNCTION LIST_CHECK( ordinal , list , listlen )i *u *iD *	Searches a list of integer ranges which was constructed by routineD *	LIST_PARSE  to see if integer ORDINAL is within one of the ranges.D *	INTEGER*4 array LIST(2,LISTLEN) is the list which is checked.  ForD *	I from 1 to LISTLEN, each LIST(1,I) is the first value in a range,D *	and LIST(2,I) is the last value in the range.   The ranges are NOTD *	assumed to be in ascending order, but for each I, LIST(1,I) is as- *	sumed to be .LE. LIST(2,I).c *fD *	The function result is set to .TRUE. if ORDINAL is withinin one ofD *	the, ranges, or to .FALSE. if ORDINAL is not in any of the ranges. *,( *	See routine LIST_PARSE for an example. *E *	.INDEX ENVIRONMENT>>% *	.INDEX COMMAND LANGUAGE INTERFACE>>n * 1 *	Alan L. Zirkle     Naval Surface Warfare Centerd *			   Code K551) *	8 Jun 1992	   Dahlgren, Virginia  22448P *I   	IMPLICIT NONE  * 	INTEGER*4 ORDINAL,LISTLEN,LIST(2,LISTLEN)   	INTEGER*4 I   	DO I = 1, LISTLEN  % 	    IF (ORDINAL .GE. LIST(1,I) .AND.U& 	1				ORDINAL .LE. LIST(2,I)) GO TO 10   	ENDDO  ( 	LIST_CHECK = .FALSE.	! Not in any range 	RETURN	  # 10	LIST_CHECK = .TRUE.	! In a ranges  
 	END									h )8 	INTEGER FUNCTION LIST_PARSE(STRING,LIST,MAXLEN,LISTLEN)   **A *	INTEGER FUNCTION LIST_PARSE( string , list , maxlen , listlen )  *a *iD *	Parses a character string which contains a comma-separated list of+ *	integers and integer ranges; for example:  *  *		"1,3-5,6-11,13,18-22,25+" *iD *	Any blanks within the string are ignored;  ranges like "10-10" are' *	accepted; ranges like "10-9" are not.  *uE *	The output from the parse is in the INTEGER*4 array LIST(2,MAXLEN).sD *	For each single integer,  LIST(1,I) and  list(2,I) are both set toD *	the integer's value; for each range, LIST(1,I) is set to the firstD *	value in the range, and LIST(2,I)  is set to the last value in theD *	range.  For ranges like "5+", LIST(1,I) is set to 5, and LIST(2,I)? *	is set to hexadecimal 7FFFFFFF, the largest positive integer.V *iD *	The calling program must provide the array LIST and integer MAXLEND *	which tells LIST_PARSE how may rows LIST has.  LIST_PARSE sets in-? *	teger LISTLEN to the number of rows of LIST it actually uses.L *S5 *	The function result is one of the following values:R *( *		0 - Syntax error  *		1 - Successful return) *		2 - More than MAXLEN numbers or rangesE= *		3 - Successful return, but numbers and/or ranges aren't inN5 *		     ascending order ("3,2" or "3-6,5-7" or "3,3")  * D *	Routines LIST_PARSE and LIST_CHECK can be used as in the following *	simple example:  *-: *	    A command has a qualifier /SELECT, which is used as: *. *		/SELECT=(1,5,6-11,13)6 *		/SEL=("1,4,6+")		! If + used, the "+" needs quoting *e$ *	    The CLD (fragment) looks like: *l- *		Qualifier SELECT , Value( Required, List )  *A0 *	    The program (FORTRAN fragment) looks like: * . *		INTEGER*4 LIST(2,20),SLEN /0/, S, L, IVALUE *		CHARACTER*64 STRING *		. . . *- *N= *		DO WHILE (CLI$GET_VALUE( 'SELECT' , STRING(SLEN+1:) , S ))  *		    SLEN = SLEN + S + 1 *		    STRING(SLEN:SLEN) = ',' *		ENDDO: *		STATUS = LIST_PARSE( STRING(1:SLEN-1) , LIST , 20 , L ) *		IF (.NOT.STATUS) . . .  *		. . . *		IVALUE = . . . 1 *		IF (.NOT.LIST_CHECK( IVALUE , LIST ,L )) . . .k *n *	.INDEX ENVIRONMENT>>% *	.INDEX COMMAND LANGUAGE INTERFACE>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare CenterS *			   Code K55 ) *	8 Jun 1992	   Dahlgren, Virginia  22448N *A   	IMPLICIT NONE   	CHARACTER*(*) STRINGl( 	INTEGER*4 MAXLEN,LIST(2,MAXLEN),LISTLEN  & 	INTEGER*4 ICOL,CCOL,HCOL,OTS$CVT_TI_L   	INTEGER*4 I,J,K,CVT 	  CVT(I,J,K) =)A 	1    OTS$CVT_TI_L( STRING(I:J-1) , LIST(K,LISTLEN) , , %VAL(1) )L    	IF (LEN(STRING).EQ.0) GO TO 100   	LISTLEN = 0	 	ICOL = 1(  ; 10	CCOL = INDEX(STRING(ICOL:),',')		! Find first/next comma  	IF (CCOL.EQ.0) THEN8 	    CCOL = LEN(STRING) + 1		! If no comma, simulate one 	ELSE 4 	    CCOL = CCOL + (ICOL-1)		! Get true comma column 	ENDIF  ) 	IF (CCOL.EQ.ICOL) GO TO 100	! Null valueS  0 	LISTLEN = LISTLEN + 1		! Assume we have a value! 	IF (LISTLEN.GT.MAXLEN) GO TO 110R  > 	HCOL = INDEX(STRING(ICOL:CCOL-1),'+')	! Is there a plus sign? 	IF (HCOL.NE.0) THEN% 	    IF (HCOL+ICOL.NE.CCOL) GO TO 100g+ 	    IF (.NOT.CVT(ICOL,CCOL-1,1)) GO TO 100r2 	    LIST(2,LISTLEN) = '7FFFFFFF'x	! Plus infinity
 	    GO TO 20I 	ENDIF  ; 	HCOL = INDEX(STRING(ICOL:CCOL-1),'-')	! Is there a hyphen?A 	IF (HCOL.EQ.0) THEN  ) 	    IF (.NOT.CVT(ICOL,CCOL,1)) GO TO 100	& 	    LIST(2,LISTLEN) = LIST(1,LISTLEN)   	ELSE    	    HCOL = HCOL + (ICOL-1) A 	    IF (HCOL.EQ.CCOL .OR. HCOL.EQ.CCOL-1) GO TO 100	! Bad hyphen.) 	    IF (.NOT.CVT(ICOL,HCOL,1)) GO TO 100 + 	    IF (.NOT.CVT(HCOL+1,CCOL,2)) GO TO 100S6 	    IF (LIST(2,LISTLEN).LT.LIST(1,LISTLEN)) GO TO 100   	ENDIF   20	ICOL = CCOL + 1" 	IF (ICOL.LE.LEN(STRING)) GO TO 10   	LIST_PARSE = 1A 	ICOL = LISTLENT   30	IF (ICOL.EQ.1) RETURN4 	IF (LIST(1,ICOL).LE.LIST(2,ICOL-1)) LIST_PARSE = 3	 	ICOL = ICOL - 1	 	GO TO 30R  , 100	LIST_PARSE = 0	! Failure -- Syntax error 	RETURN   ( 110	LIST_PARSE = 2	! Failure -- Overflow  
 	END									s t5 	INTEGER FUNCTION DETAB(IN_STRING,OUT_STRING,OUT_LEN)S   **= *	LOGICAL FUNCTION DETAB ( in_string , out_string , out_len )e *  *eD *	Transforms the input character  string  IN_STRING  to  the  outputD *	string  OUT_STRING  by  converting ASCII tab characters to blanks.D *	The output argument OUT_LEN is set to the  last  valid  column  of
 *	OUT_STRING.' *	D *	If any tabs are present in IN_STRING, its length must be less than; *	the length of OUT_STRING, or else an overflow will occur.i * D *	The functional result will be .TRUE. unless an overflow has occur-D *	red.   A  .FALSE.  result  means that one or more tabs did not getD *	converted to blanks; no characters will be missing from the end of
 *	OUT_STRING.r *tD *	The standard VAX/VMS tab column spacing scheme is assumed, and theD *	IN_STRING's first column is assumed to be column 1 of this scheme. *t+ *	The input and output strings may overlap.t *  *	.INDEX STRING MANIPULATION>> *t1 *	Alan L. Zirkle     Naval Surface Warfare Center2 *			   Code K53-* *	31 Mar 1984	   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)r  $ 	CHARACTER*(*) IN_STRING, OUT_STRING   	CHARACTER*1 TAB   	PARAMETER ( TAB = CHAR(9) )  " 	CHARACTER*8 BLANKS / '        ' /   	DETAB = .TRUE.e
 	START = 1   	IN_LEN  = LEN(IN_STRING)J 	OUT_LEN = IN_LEN,  ) 	IF (%LOC(OUT_STRING).NE.%LOC(IN_STRING))T- 	1			       OUT_STRING(1:OUT_LEN) = IN_STRINGt  2 10	COL = SUBINDEX(OUT_STRING(1:OUT_LEN),START,TAB)   	IF (COL.EQ.0) RETURNC   	COUNT = 8 - MOD(COL-1,8)   1 	IF ( OUT_LEN+COUNT-1 .GT. LEN(OUT_STRING) ) THEN0  # 	    DETAB = .FALSE.					! Overflow) 	    RETURN    	ENDIF  5 	OUT_STRING(COL:OUT_LEN+COUNT-1) = BLANKS(1:COUNT) // & 	1				       OUT_STRING(COL+1:OUT_LEN)   	OUT_LEN = OUT_LEN + COUNT - 1   	START = START + COUNT  
 	GO TO 10	   	END" 	INTEGER FUNCTION MONTH_NUM(MONTH)   **% *	INTEGER FUNCTION MONTH_NUM( month )  *l * D *	Converts an alphabetic, three-character month (such as 'FEB', intoD *	an integer month number (2 for 'FEB').   The alphabetic  month  isD *	passed  as  the argument  MONTH;  it can be upper, lower, or mixed= *	case.  The month number is returned as the function result.i *rD *	If the argument is not a valid month, the error SS$_IVTIME is sig-D *	nalled;  this will abort the  program unless  an exception handler *	has been defined.e *x *	.INDEX DATES>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Centern *			   Code K53 * *	20 Apr 1984	   Dahlgren, Virginia  22448 *l   	IMPLICIT INTEGER (A-Z)    	CHARACTER*3 MONTH,MONTH_t  ? 	CHARACTER*36 MONTHS / 'JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC' /t   	EXTERNAL SS$_IVTIME   	CALL STR$UPCASE(MONTH_,MONTH)  + 	MONTH_NUM = (INDEX(MONTHS,MONTH_) + 2) / 3   0 	IF (MONTH_NUM.EQ.0) CALL LIB$SIGNAL(SS$_IVTIME)   	END 	SUBROUTINE GO_WAIT(SECONDS)   **  *	SUBROUTINE GO_WAIT ( seconds ) *t *uD *	Places the process in a wait state for  the  specified  number  ofD *	seconds.   The  process  will show up as being in HIB state in theD *	SHOW SYSTEM and MONITOR displays.  The program will become  active *	prematurely if an AST occurs.o * / *	See also routines TIMER_SET and TIMER_CANCEL.  * > *	 4 Jan 86	Hibernate,  instead of waiting for event flag,  so *			it is easier to cancel.  *e *	.INDEX PROCESS CONTROL>> *	1 *	Alan L. Zirkle     Naval Surface Warfare Centerh *			   Code K53	* *	14 Nov 1983	   Dahlgren, Virginia  22448 *d *i   	IMPLICIT INTEGER (A-Z)s   	INTEGER*4 DAYTIME(2)A  + 	CALL LIB$EMUL(-SECONDS,10000000,0,DAYTIME)E    	STATUS = SYS$SCHDWK(,,DAYTIME,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))r   	CALL GO_HIBERNATE   	END. 	SUBROUTINE DECLARE_EXIT_HANDLER(ROUTINE,ARGS)   **D *	SUBROUTINE DECLARE_EXIT_HANDLER( routine , [arg2] , ... , [arg9] ) *i *bD *	Enables an 'exit handler' routine,  which is a subroutine providedD *	by the user, which VMS calls when the image exits.   More than oneD *	exit handler can be enabled; at exit time, they are called in rev-D *	erse order of enabling.  Using DECLARE_EXIT_HANDLER, up to ten ex- *	it handlers can be enabled.d *	D *	Argument ROUTINE is the name of the subroutine to be enabled as anD *	exit handler.  Remember to declare this name EXTERNAL in the call- *	ing routine. * D *	The first argument  passed to an exit handler subroutine is alwaysD *	the longword VMS condition value  giving the reason for exit.   UpD *	to eight  other arguments can  optionally be specified.   RememberD *	that if variables are  specified as arguments,  values passed willD *	be the values  at program  exit time,  not the values  at the time" *	DECLARE_EXIT_HANDLER was called. *SD *	If the program decides,  before exiting,  that an exit handler  isD *	no longer needed, it can call CANCEL_EXIT_HANDLER  to tell VMS not *	to call the exit handler.E *  *	.INDEX PROCESS CONTROL>> *L1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	29 Apr 1985	   Dahlgren, Virginia  22448 *L   	IMPLICIT INTEGER (A-Z)E    	INTEGER*4 DESBLK(12,10),STATUS_   	INTEGER*4 IARGPTR   	EXTERNAL ROUTINE*  1 	DATA N / 0 /		! Number of exit handlers declaredt   	N = MIN(N+1,10)   	DESBLK(2,N) = %LOC(ROUTINE)	h  , 	DESBLK(3,N) = MIN(9,NARGS(%VAL(IARGPTR())))   	DESBLK(4,N) = %LOC(STATUS_)   	IF (DESBLK(3,N).GT.1) THEN*   	    DO I=2,DESBLK(3,N)t  0 		DESBLK(I+3,N) = ARG_ADDRESS(%VAL(IARGPTR()),I)  
 	    ENDDO   	ENDIF  " 	STATUS_ = SYS$DCLEXH(DESBLK(1,N))  / 	IF (.NOT.STATUS_) CALL LIB$STOP(%VAL(STATUS_))e   	RETURNu      # 	ENTRY CANCEL_EXIT_HANDLER(ROUTINE)I   **+ *	SUBROUTINE CANCEL_EXIT_HANDLER( routine )  *  *hD *	Cancels the enabling of an  exit handler routine  which was previ-D *	ously enabled by calling routine  DECLARE_EXIT_HANDLER.   ArgumentD *	ROUTINE is the name of the exit handler subroutine to be disabled.@ *	Remember to declare this name EXTERNAL in the calling routine. *l4 *	See routine DECLARE_EXIT_HANDLER for more details. *  *	.INDEX PROCESS CONTROL>> *I1 *	Alan L. Zirkle     Naval Surface Warfare CenterS *			   Code K53I* *	29 Apr 1985	   Dahlgren, Virginia  22448 *D  	 	DO I=1,NT  + 	    IF (DESBLK(2,I).EQ.%LOC(ROUTINE)) THENT  # 		STATUS_ = SYS$CANEXH(DESBLK(1,I))	  0 		IF (.NOT.STATUS_) CALL LIB$STOP(%VAL(STATUS_))   		DESBLK(2,I) = 0E  
 	    ENDIF   	ENDDO  
 	NEW_N = 0  	 	DO I=1,NN  $ 	    IF (DESBLK(2,I).NE.0) NEW_N = I   	ENDDO  
 	N = NEW_N   	END- 	SUBROUTINE DAY_OF_WEEK(TODAY,LENGTH,DAYTIME)a   **9 *	SUBROUTINE DAY_OF_WEEK( today , [length]  , [daytime] )s *d *tD *	Sets the character string TODAY to the name of the current day  ofD *	the week, in capital letters.   If the optional argument LENGTH is/ *	present, it is set to the length of the name.u *tD *	If the optional argument DAYTIME is present, it must be a quadwordD *	system binary time; the day of the week of this time is  returned,) *	instead of the current day of the week.e *o *	.INDEX DATES>> *n1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 ) *	4 Oct 1983	   Dahlgren, Virginia  22448, *d   	IMPLICIT INTEGER (A-Z)a   	CHARACTER*(*) TODAY 	CHARACTER*10 DAYS(0:6)    	INTEGER*4 LENGTHg 	INTEGER*4 DAYTIME(2)r   	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  8 	DATA DAYS / 'WEDNESDAY','THURSDAY','FRIDAY','SATURDAY',# 	1				'SUNDAY','MONDAY','TUESDAY' /L  ' 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THENr   	    CALL LIB$DAY(IDAY,DAYTIME)s   	ELSE	   	    CALL LIB$DAY(IDAY)S   	ENDIF   	IDAY=MOD(IDAY,7)h   	TODAY=DAYS(IDAY)r  Q 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) LENGTH=MIN(LEN(TODAY),INDEX(DAYS(IDAY),' ')-1)d   	END$ 	SUBROUTINE BANNER_LINE(UNIT,STRING)   *** *	SUBROUTINE BANNER_LINE ( unit , string ) *n *e5 *	Prints a 'banner line' on FORTRAN file number UNIT.  *uD *	The banner line consists of the contents  of  STRING  (up  to  tenD *	characters)  printed  in large letters across the page.  Each let-D *	ter is 14 print lines tall and thirteen  columns  wide  (includingD *	inter-letter spacing).   Two  blank  lines  are printed before theD *	banner, and two are printed after.  all lines are printed at eight0 *	lines per inch (on PRINTRONIX/LXYnn printers). *SD *	If an asterisk appears in STRING, then that banner  position  willD *	contain, instead of the asterisk, a block giving the date and time
 *	of the run.	 * 1 *	The characters which can appear in banners are:  *I* *		alphabetic characters (upper case only) *  *		numeric charactersT * 0 *		special characters  (  )  [  ]  .  -  /  $  _ *  *		asterisk (see above)W *aD *	You do not have to physically set the printer to 8  lpi;  this  isD *	done under  program control.   The 8 lpi printing will cause pagesD *	containing banners to be prematurely ejected at  the  end  of  the *	page.I *K *	 3 May 1988	Add "$" and "_". *V *	.INDEX BANNERS>> *	.INDEX PRINTING>>  *V1 *	Alan L. Zirkle     Naval Surface Warfare CenterS *			   Code K53 ) *	1 Jul 1982	   Dahlgren, Virginia  22448  *d   	IMPLICIT INTEGER (A-Z)O  ' 	CHARACTER*13 PATTERN(14,48),OUTPUT(10)! 	CHARACTER*130 BUFFER(14) $ 	CHARACTER*1 SYMBOL,PRINTRONIX_8_LPI$ 	CHARACTER*9 DATE_STRING,TIME_STRING 	CHARACTER*(*) STRING0   	INTEGER POINTER(0:127)= 	LOGICAL CENTER,PRINTw   	COMMON /CENTER_/ CENTER  > 	DATA POINTER / 32*0,0,3*0,45,3*0,41,42,48,2*0,40,43,37,27,28,9 	1	       29,30,31,32,33,34,35,36,0,44,5*0,1,2,3,4,5,6,7,+8 	2	       8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,7 	3	       24,25,26,38,0,39,0,46,0,1,2,3,4,5,6,7,8,9,10,n7 	4	       11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,O 	5	       26,5*0 /    0 	DATA (PATTERN(I,01),I=1,14) /	'             ' , 	1				'     MM      ' ,  	1				'    MMMM     ' ,) 	1				'   MMMMMM    ' ,S 	1				'  MMMM MMM   ' ,( 	1				' MMMM   MMM  ' ,Q 	1				' MMM     MM  ' ,) 	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,O 	1				' MMMMMMMMMM  ' ,  	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,( 	1				'MMMMM   MMMM ' ,L 	1				'             ' /   0 	DATA (PATTERN(I,02),I=1,14) /	'             ' , 	1				'MMMMMMMMM    ' ,  	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,L 	1				' MMM    MMM  ' ,L 	1				' MMM   MMM   ' ,O 	1				' MMMMMMMM    ' ,  	1				' MMM   MMM   ' ,i 	1				' MMM    MMM  ' ,T 	1				' MMM    MMM  ' ,2 	1				' MMM    MMM  ' ,  	1				' MMM   MMM   ' ,G 	1				'MMMMMMMMM    ' ,N 	1				'             ' /   0 	DATA (PATTERN(I,03),I=1,14) /	'             ' , 	1				'    MMMMMM   ' ,	 	1				'   MMMMMMMM  ' ,a 	1				'  MMM     M  ' ,t 	1				' MMM         ' ,  	1				' MMM         ' ,g 	1				' MMM         ' ,b 	1				' MMM         ' ,m 	1				' MMM         ' ,  	1				' MMM         ' ,  	1				'  MMM     M  ' ,a 	1				'   MMMMMMMM  ' ,_ 	1				'    MMMMMM   ' ,e 	1				'             ' /o  0 	DATA (PATTERN(I,04),I=1,14) /	'             ' , 	1				'MMMMMMMM     ' ,i 	1				' MMM  MMM    ' ,e 	1				' MMM   MMM   ' ,  	1				' MMM    MMM  ' ,s 	1				' MMM    MMM  ' ,d 	1				' MMM    MMM  ' ,b 	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,f 	1				' MMM    MMM  ' ,h 	1				' MMM   MMM   ' ,l 	1				' MMM  MMM    ' ,u 	1				'MMMMMMMM     ' ,' 	1				'             ' /   0 	DATA (PATTERN(I,05),I=1,14) /	'             ' , 	1				'MMMMMMMMMMM  ' ,p 	1				' MMM     MM  ' ,A 	1				' MMM         ' ,L 	1				' MMM         ' ,e 	1				' MMM  MM     ' ,C 	1				' MMMMMMM     ' ,  	1				' MMM  MM     ' ,8 	1				' MMM         ' ,  	1				' MMM         ' ,I 	1				' MMM     MM  ' ,C 	1				' MMM     MM  ' ,T 	1				'MMMMMMMMMMM  ' ,C 	1				'             ' /   0 	DATA (PATTERN(I,06),I=1,14) /	'             ' , 	1				'MMMMMMMMMMM  ' ,N 	1				' MMM     MM  ' ,U 	1				' MMM         ' ,N 	1				' MMM         ' ,I 	1				' MMM  MM     ' ,t 	1				' MMMMMMM     ' ,_ 	1				' MMM  MM     ' ,A 	1				' MMM         ' ,R 	1				' MMM         ' ,L 	1				' MMM         ' ,O 	1				' MMM         ' ,) 	1				'MMMMM        ' ,. 	1				'             ' /   0 	DATA (PATTERN(I,07),I=1,14) /	'             ' , 	1				'    MMMMMM   ' ,  	1				'   MMMMMMMM  ' ,( 	1				'  MMM     M  ' ,N 	1				' MMM         ' ,  	1				' MMM         ' ,  	1				' MMM         ' ,G 	1				' MMM   MMMM  ' ,T 	1				' MMM    MMM  ' ,I 	1				' MMM    MMM  ' ,l 	1				'  MMM   MMM  ' ,b 	1				'   MMMMMMMM  ' ,t 	1				'    MMMMMM   ' ,	 	1				'             ' /2  0 	DATA (PATTERN(I,08),I=1,14) /	'             ' , 	1				'MMMMM  MMMMM ' ,  	1				' MMM    MMM  ' ,r 	1				' MMM    MMM  ' ,h 	1				' MMM    MMM  ' ,e 	1				' MMM    MMM  ' ,	 	1				' MMMMMMMMMM  ' ,v 	1				' MMM    MMM  ' ,_ 	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,g 	1				' MMM    MMM  ' ,h 	1				' MMM    MMM  ' ,d 	1				'MMMMM  MMMMM ' ,  	1				'             ' /N  0 	DATA (PATTERN(I,09),I=1,14) /	'             ' , 	1				'  MMMMMMMM   ' ,r 	1				'    MMMM     ' ,I 	1				'    MMMM     ' ,A 	1				'    MMMM     ' ,  	1				'    MMMM     ' ,A 	1				'    MMMM     ' ,O 	1				'    MMMM     ' ,  	1				'    MMMM     ' ,P 	1				'    MMMM     ' ,N 	1				'    MMMM     ' ,N 	1				'    MMMM     ' ,N 	1				'  MMMMMMMM   ' ,N 	1				'             ' /S  0 	DATA (PATTERN(I,10),I=1,14) /	'             ' , 	1				'       MMMMM ' ,	 	1				'        MMM  ' ,a 	1				'        MMM  ' ,i 	1				'        MMM  ' ,. 	1				'        MMM  ' ,w 	1				'        MMM  ' ,  	1				'        MMM  ' ,  	1				' MMM    MMM  ' ,o 	1				' MMM    MMM  ' ,  	1				'  MMM  MMM   ' ,c 	1				'   MMMMMM    ' ,u 	1				'    MMMM     ' ,_ 	1				'             ' /	  0 	DATA (PATTERN(I,11),I=1,14) /	'             ' , 	1				'MMMMM   MMMM ' ,l 	1				' MMM     MM  ' ,C 	1				' MMM    MM   ' ,i 	1				' MMM   MM    ' ,r 	1				' MMM  MM     ' ,  	1				' MMM MMMM    ' ,h 	1				' MMMMMMMM    ' ,d 	1				' MMMM MMMM   ' ,  	1				' MMM   MMM   ' ,I 	1				' MMM   MMMM  ' ,- 	1				' MMM    MMM  ' ,E 	1				'MMMMM   MMMM ' ,K 	1				'             ' /.  0 	DATA (PATTERN(I,12),I=1,14) /	'             ' , 	1				'MMMMM        ' ,N 	1				' MMM         ' ,U 	1				' MMM         ' ,U 	1				' MMM         ' ,( 	1				' MMM         ' ,  	1				' MMM         ' ,e 	1				' MMM         ' ,n 	1				' MMM         ' ,  	1				' MMM         ' ,w 	1				' MMM     MM  ' ,m 	1				' MMM     MM  ' ,e 	1				'MMMMMMMMMMM  ' ,n 	1				'             ' /   0 	DATA (PATTERN(I,13),I=1,14) /	'             ' , 	1				'MMMM     MMM ' ,  	1				' MMMM   MMM  ' ,  	1				' MMMMM MMMM  ' ,r 	1				' MMMMMMMMMM  ' ,e 	1				' MMMMMMMMMM  ' ,e 	1				' MMM MMM MM  ' ,l 	1				' MMM  M  MM  ' ,t 	1				' MMM     MM  ' ,c 	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,s 	1				' MMM     MM  ' ,r 	1				'MMMMM   MMMM ' ,o 	1				'             ' /e  0 	DATA (PATTERN(I,14),I=1,14) /	'             ' , 	1				'MMMM    MMMM ' ,l 	1				' MMMM    MM  ' ,r 	1				' MMMMM   MM  ' ,  	1				' MMMMMM  MM  ' ,  	1				' MM MMMM MM  ' ,t 	1				' MM  MMMMMM  ' ,i 	1				' MM   MMMMM  ' ,a 	1				' MM    MMMM  ' ,T 	1				' MM     MMM  ' ,  	1				' MM      MM  ' ,  	1				' MM       M  ' ,  	1				'MMMM      M  ' ,n 	1				'             ' /A  0 	DATA (PATTERN(I,15),I=1,14) /	'             ' , 	1				'  MMMMMMMM   ' ,X 	1				' MMM    MMM  ' ,	 	1				' MMM    MMM  ' ,S 	1				' MMM    MMM  ' ,	 	1				' MMM    MMM  ' ,1 	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,N 	1				' MMM    MMM  ' ,4 	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,T 	1				' MMM    MMM  ' ,  	1				'  MMMMMMMM   ' ,a 	1				'             ' /M  0 	DATA (PATTERN(I,16),I=1,14) /	'             ' , 	1				'MMMMMMMMM    ' ,A 	1				' MMM   MMM   ' ,( 	1				' MMM    MMM  ' ,I 	1				' MMM    MMM  ' ,* 	1				' MMM    MMM  ' ,N 	1				' MMM   MMM   ' ,R 	1				' MMMMMMMM    ' ,, 	1				' MMM         ' ,F 	1				' MMM         ' ,( 	1				' MMM         ' ,. 	1				' MMM         ' ,A 	1				'MMMMM        ' ,  	1				'             ' /H  0 	DATA (PATTERN(I,17),I=1,14) /	'             ' , 	1				'  MMMMMMMM   ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,e 	1				' MMM    MMM  ' ,  	1				' MMM    MMM  ' ,e 	1				' MMM    MMM  ' ,  	1				' MMM MM MMM  ' ,. 	1				' MMM MM MMM  ' ,h 	1				' MMM  MMMMM  ' ,a 	1				'  MMMMMMMM   ' ,  	1				'        MMM  ' /L  0 	DATA (PATTERN(I,18),I=1,14) /	'             ' , 	1				'MMMMMMMMM    ' ,  	1				' MMM   MMM   ' ,n 	1				' MMM    MMM  ' ,	 	1				' MMM    MMM  ' ,V 	1				' MMM   MMM   ' ,  	1				' MMMMMMMM    ' ,( 	1				' MMM MMM     ' ,E 	1				' MMM  MMM    ' ,E 	1				' MMM   MMM   ' ,( 	1				' MMM    MMM  ' ,O 	1				' MMM     MMM ' ,B 	1				'MMMMM     MM ' ,F 	1				'             ' /   0 	DATA (PATTERN(I,19),I=1,14) /	'             ' , 	1				'   MMMMMM    ' ,  	1				'  MMMMMMMM   ' ,F 	1				' MMMM   MMM  ' ,E 	1				' MMM     MM  ' ,Y 	1				'  MMMM       ' ,] 	1				'   MMMMM     ' ,  	1				'    MMMMM    ' ,n 	1				'      MMMM   ' ,e 	1				' M     MMMM  ' ,e 	1				' MM   MMMMM  ' ,  	1				' MMMMMMMMM   ' ,L 	1				' MMMMMMM     ' ,s 	1				'             ' /   0 	DATA (PATTERN(I,20),I=1,14) /	'             ' , 	1				' MMMMMMMMMMM ' ,o 	1				' M   MMM   M ' ,  	1				'     MMM     ' ,i 	1				'     MMM     ' ,n 	1				'     MMM     ' ,o 	1				'     MMM     ' ,X 	1				'     MMM     ' ,i 	1				'     MMM     ' ,r 	1				'     MMM     ' ,  	1				'     MMM     ' ,l 	1				'     MMM     ' ,d 	1				'    MMMMM    ' ,Z 	1				'             ' /Y  0 	DATA (PATTERN(I,21),I=1,14) /	'             ' , 	1				'MMMMM   MMMM ' ,L 	1				' MMM     MM  ' ,R 	1				' MMM     MM  ' ,/ 	1				' MMM     MM  ' ,F 	1				' MMM     MM  ' ,	 	1				' MMM     MM  ' ,Y 	1				' MMM     MM  ' ,A 	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,Y 	1				' MMM     MM  ' ,C 	1				' MMMMMMMMMM  ' ,D 	1				'  MMMMMMMM   ' ,  	1				'             ' /I  0 	DATA (PATTERN(I,22),I=1,14) /	'             ' , 	1				'MMMMM   MMMM ' ,1 	1				' MMM     MM  ' ,A 	1				' MMM     MM  ' ,  	1				' MMMM   MMM  ' ,I 	1				'  MMM   MM   ' ,  	1				'  MMMM MMM   ' ,n 	1				'   MMMMMM    ' ,  	1				'   MMMMMM    ' ,l 	1				'    MMMM     ' ,n 	1				'    MMMM     ' ,t 	1				'     MM      ' ,d 	1				'     MM      ' ,  	1				'             ' /e  0 	DATA (PATTERN(I,23),I=1,14) /	'             ' , 	1				'MMMMM   MMMM ' ,t 	1				' MMM     MM  ' ,  	1				' MMM     MM  ' ,e 	1				' MMM     MM  ' ,r 	1				' MMM  M  MM  ' ,e 	1				' MMM MM  MM  ' ,	 	1				' MMM MM  MM  ' ,O 	1				' MMMMMMMMMM  ' ,  	1				'  MMMMMMMM   ' ,i 	1				'  MMMM MMM   ' ,r 	1				'   MM  MM    ' ,i 	1				'   MM  MM    ' ,k 	1				'             ' /   0 	DATA (PATTERN(I,24),I=1,14) /	'             ' , 	1				'MMMMM   MMMM ' ,e 	1				' MMM     MM  ' ,r 	1				'  MMM   MM   ' ,  	1				'   MMM MM    ' ,T 	1				'    MMMM     ' ,r 	1				'    MMM      ' ,  	1				'     MMM     ' ,a 	1				'    MMMM     ' ,h 	1				'   MM MMM    ' ,  	1				'  MM   MMM   ' ,  	1				' MM     MMM  ' ,  	1				'MMMM   MMMMM ' ,t 	1				'             ' /o  0 	DATA (PATTERN(I,25),I=1,14) /	'             ' , 	1				'MMMMM  MMMM  ' ,K 	1				' MMM    MM   ' ,n 	1				' MMM    MM   ' ,E 	1				'  MMM  MM    ' ,  	1				'  MMM  MM    ' ,  	1				'   MMMMM     ' ,n 	1				'   MMMMM     ' ,	 	1				'    MMM      ' ,i 	1				'    MMM      ' ,P 	1				'    MMM      ' ,C 	1				'    MMM      ' ,) 	1				'   MMMMM     ' ,1 	1				'             ' /R  0 	DATA (PATTERN(I,26),I=1,14) /	'             ' , 	1				' MMMMMMMMMM  ' ,( 	1				' MM    MMM   ' ,I 	1				'      MMM    ' ,N 	1				'      MMM    ' ,N 	1				'     MMM     ' ,N 	1				'     MMM     ' ,1 	1				'    MMM      ' ,, 	1				'    MMM      ' ,3 	1				'   MMM       ' ,4 	1				'  MMM    MM  ' ,0 	1				' MMM     MM  ' ,1 	1				'MMMMMMMMMMM  ' ,  	1				'             ' /,  0 	DATA (PATTERN(I,27),I=1,14) /	'             ' , 	1				'     888     ' ,O 	1				'    88888    ' ,  	1				'   888 888   ' ,1 	1				'  888   888  ' ,1 	1				'  888   888  ' ,1 	1				'  888   888  ' ,1 	1				'  888   888  ' ,1 	1				'  888   888  ' ,1 	1				'  888   888  ' ,1 	1				'   888 888   ' ,1 	1				'    88888    ' ,1 	1				'     888     ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,28),I=1,14) /	'             ' , 	1				'      88     ' ,1 	1				'     888     ' ,  	1				'    8888     ' ,1 	1				'   88888     ' ,1 	1				'  888888     ' ,1 	1				'    8888     ' ,1 	1				'    8888     ' ,1 	1				'    8888     ' ,1 	1				'    8888     ' ,1 	1				'    8888     ' ,1 	1				'    8888     ' ,1 	1				'   888888    ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,29),I=1,14) /	'             ' , 	1				'   888888    ' ,1 	1				'  88888888   ' ,  	1				'  8    8888  ' ,1 	1				'        888  ' ,1 	1				'        888  ' ,1 	1				'      8888   ' ,1 	1				'    8888     ' ,1 	1				'   8888      ' ,1 	1				'  8888       ' ,1 	1				' 8888        ' ,1 	1				' 8888888888  ' ,1 	1				' 8888888888  ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,30),I=1,14) /	'             ' , 	1				'  888888     ' ,1 	1				' 88888888    ' ,  	1				' 8     888   ' ,1 	1				'        888  ' ,1 	1				'       888   ' ,1 	1				'     8888    ' ,1 	1				'       888   ' ,1 	1				'        888  ' ,1 	1				'        888  ' ,1 	1				' 8     888   ' ,1 	1				' 88888888    ' ,1 	1				'  888888     ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,31),I=1,14) /	'             ' , 	1				'       888   ' ,1 	1				'      8888   ' ,  	1				'     88888   ' ,1 	1				'    888888   ' ,1 	1				'   888 888   ' ,1 	1				'  888  888   ' ,1 	1				'  888  888   ' ,1 	1				' 888   888   ' ,1 	1				' 8888888888  ' ,1 	1				'       888   ' ,1 	1				'       888   ' ,1 	1				'      88888  ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,32),I=1,14) /	'             ' , 	1				' 8888888888  ' ,1 	1				' 888         ' ,  	1				' 888         ' ,1 	1				' 888         ' ,1 	1				' 88888888    ' ,1 	1				' 888888888   ' ,1 	1				'        888  ' ,1 	1				'         888 ' ,1 	1				'         888 ' ,1 	1				' 8      888  ' ,1 	1				' 8888888888  ' ,1 	1				'  88888888   ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,33),I=1,14) /	'             ' , 	1				'         88  ' ,1 	1				'       888   ' ,  	1				'     888     ' ,1 	1				'    888      ' ,1 	1				'   888       ' ,1 	1				'  888888     ' ,1 	1				' 8888  888   ' ,1 	1				' 888    888  ' ,1 	1				' 888    888  ' ,1 	1				'  888  888   ' ,1 	1				'   888888    ' ,1 	1				'    8888     ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,34),I=1,14) /	'             ' , 	1				' 8888888888  ' ,1 	1				' 88    8888  ' ,  	1				'       888   ' ,1 	1				'      8888   ' ,1 	1				'      888    ' ,1 	1				'     8888    ' ,1 	1				'     888     ' ,1 	1				'    8888     ' ,1 	1				'    888      ' ,1 	1				'   8888      ' ,1 	1				'   888       ' ,1 	1				'   888       ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,35),I=1,14) /	'             ' , 	1				'    88888    ' ,1 	1				'   888 888   ' ,  	1				'  888   888  ' ,1 	1				'  888   888  ' ,1 	1				'   888 888   ' ,1 	1				'    88888    ' ,1 	1				'   8888888   ' ,1 	1				'  888   888  ' ,1 	1				' 888     888 ' ,1 	1				'  888   888  ' ,1 	1				'   8888888   ' ,1 	1				'    88888    ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,36),I=1,14) /	'             ' , 	1				'    8888     ' ,1 	1				'   888888    ' ,  	1				'  888  888   ' ,1 	1				' 888    888  ' ,1 	1				' 888    888  ' ,1 	1				'  888  8888  ' ,1 	1				'    888888   ' ,1 	1				'      888    ' ,1 	1				'     888     ' ,1 	1				'    888      ' ,1 	1				'  888        ' ,1 	1				' 88          ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,37),I=1,14) /	'        MMM  ' , 	1				'        MMM  ' ,1 	1				'       MMM   ' ,  	1				'      MMM    ' ,1 	1				'      MMM    ' ,1 	1				'     MMM     ' ,1 	1				'    MMM      ' ,1 	1				'    MMM      ' ,1 	1				'   MMM       ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				' MMM         ' ,1 	1				'MMM          ' ,1 	1				'MMM          ' /1  0 	DATA (PATTERN(I,38),I=1,14) /	'  MMMMMMM    ' , 	1				'  MMMMMMM    ' ,1 	1				'  MMM        ' ,  	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMMMMMM    ' ,1 	1				'  MMMMMMM    ' /1  0 	DATA (PATTERN(I,39),I=1,14) /	'   MMMMMMM   ' , 	1				'   MMMMMMM   ' ,1 	1				'       MMM   ' ,  	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'   MMMMMMM   ' ,1 	1				'   MMMMMMM   ' /1  0 	DATA (PATTERN(I,40),I=1,14) /	'             ' , 	1				'             ' ,1 	1				'             ' ,  	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				' MMMMMMMMMM  ' ,1 	1				' MMMMMMMMMM  ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,41),I=1,14) /	'     MMM     ' , 	1				'    MMM      ' ,1 	1				'   MMM       ' ,  	1				'   MMM       ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'  MMM        ' ,1 	1				'   MMM       ' ,1 	1				'   MMM       ' ,1 	1				'    MMM      ' ,1 	1				'     MMM     ' /1  0 	DATA (PATTERN(I,42),I=1,14) /	'    MMM      ' , 	1				'     MMM     ' ,1 	1				'      MMM    ' ,  	1				'      MMM    ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'       MMM   ' ,1 	1				'      MMM    ' ,1 	1				'      MMM    ' ,1 	1				'     MMM     ' ,1 	1				'    MMM      ' /1  0 	DATA (PATTERN(I,43),I=1,14) /	'             ' , 	1				'             ' ,1 	1				'             ' ,  	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'    MMMM     ' ,1 	1				'   MMMMMM    ' ,1 	1				'   MMMMMM    ' ,1 	1				'    MMMM     ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,44),I=1,14) /	'             ' , 	1				'             ' ,1 	1				'             ' ,  	1				'             ' ,1 	1				'    MMMM     ' ,1 	1				'   MMMMMM    ' ,1 	1				'    MMMM     ' ,1 	1				'             ' ,1 	1				'    MMMM     ' ,1 	1				'   MMMMMM    ' ,1 	1				'    MMMMM    ' ,1 	1				'      MMM    ' ,1 	1				'      MM     ' ,1 	1				'     MM      ' /1  0 	DATA (PATTERN(I,45),I=1,14) /	'     MM      ' , 	1				'    MMMM     ' ,1 	1				'  MMMMMMMM   ' ,  	1				' MM  MM MMM  ' ,1 	1				' MM  MM  MM  ' ,1 	1				'  MMMMM      ' ,1 	1				'    MMM      ' ,1 	1				'     MMMM    ' ,1 	1				'     MMMMM   ' ,1 	1				' M   MM MMM  ' ,1 	1				' MM  MM MMM  ' ,1 	1				'  MMMMMMMM   ' ,1 	1				'    MMMM     ' ,1 	1				'     MM       ' /  0 	DATA (PATTERN(I,46),I=1,14) /	'             ' , 	1				'             ' ,1 	1				'             ' ,  	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				' MMMMMMMMMMM ' ,1 	1				' MMMMMMMMMMM ' /1  0 	DATA (PATTERN(I,47),I=1,14) /	'             ' , 	1				'             ' ,1 	1				'             ' ,  	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' /1  0 	DATA (PATTERN(I,48),I=1,14) /	'             ' , 	1				'             ' ,1 	1				'             ' ,  	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' ,1 	1				'             ' /1   	DATA PRINTRONIX_8_LPI / 6 / 	DATA CENTER / .FALSE. /   	PRINT = .TRUE.1  	 	GO TO 10         " 	ENTRY BANNER_ARRAY(BUFFER,STRING)   **- *	SUBROUTINE BANNER_ARRAY ( buffer , string )M *  *MD *	Similar to routine BANNER_LINE, except  that  the  banner  is  notE *	written  to  a  file;  it  is placed in the character string array 	# *	BUFFER, which must be defined as:M *  *		CHARACTER*130 BUFFER(14)r *1D *	in the calling program.  The first byte of each element  DOES  NOT' *	contain carriage control information.  *  *	.INDEX BANNERS>> *	.INDEX PRINTING>>	 * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53   *			   Dahlgren, Virginia  22448 *M   	PRINT = .FALSE.   10	CALL DATE(DATE_STRING)  	CALL TIME(TIME_STRING)    	IF (PRINT) THEN' 	    WRITE (UNIT,1000) PRINTRONIX_8_LPI ' 	    WRITE (UNIT,1000) PRINTRONIX_8_LPI  	ENDIF   	DO I=2,12,4* 	    PATTERN(I,48)   = '  ' // DATE_STRING1 	    PATTERN(I+2,48) = '    ' // TIME_STRING(1:5)  	ENDDO   	LOUT=1  	L=MIN(10,LEN(STRING))  
 	DO LINE=1,14M   	    DO COL=1,L	   		SYMBOL=STRING(COL:COL)   		PTR=POINTER(ICHAR(SYMBOL))   		IF (PTR.NE.0) THEN  # 		    OUTPUT(COL)=PATTERN(LINE,PTR)C   		ELSE    		    OUTPUT(COL)='            '   		ENDIF	  
 	    ENDDO  
 	    TAB=3  " 	    IF (CENTER) TAB=3+(10-L)*13/2   	    IF (PRINT) THEN  6 		WRITE (UNIT,1000) PRINTRONIX_8_LPI,(OUTPUT(I),I=1,L)  	 	    ELSE   - 		WRITE (BUFFER(LINE),1001) (OUTPUT(I),I=1,L)   
 	    ENDIF   	ENDDO   	IF (PRINT) THEN' 	    WRITE (UNIT,1000) PRINTRONIX_8_LPI ' 	    WRITE (UNIT,1000) PRINTRONIX_8_LPI	 	ENDIF  " 1000	FORMAT (1X,A1,:,T<TAB>,10A13) 1001	FORMAT (T<TAB-2>,10A13)   	END( 	SUBROUTINE CLUSTER_NODE(NODE_NAME,NLEN)   **- *	SUBROUTINE CLUSTER_NODE( node_name , nlen )	 *  *8B *	Returns the VAXcluster node name  of the node on which this pro-B *	cess is running.   The name is returned  in the character stringB *	argument  NODE_NAME, and the length  of the name  is returned in! *	longword integer argument NLEN.  *  *	.INDEX ENVIRONMENT>> *11 *	Alan L. Zirkle     Naval Surface Warfare Center, *			   Code K53 * *	17 Jun 1986	   Dahlgren, Virginia  22448 *8   	IMPLICIT INTEGER (A-Z)8  & 	PARAMETER ( SYI$_NODENAME = '10D9'X )   	CHARACTER*(*) NODE_NAME   	INTEGER*4 ITMLST(4),IOSB(2)  4 	CALL ITEM_LIST(ITMLST,SYI$_NODENAME,NODE_NAME,NLEN)  ' 	STATUS = SYS$GETSYIW(,,,ITMLST,IOSB,,)   - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))T  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))	   	END+ 	LOGICAL FUNCTION CLUSTER_MEMBER(NODE_NAME)    **. *	LOGICAL FUNCTION CLUSTER_MEMBER( node_name ) *  *8B *	Returns an indication of whether the specified node is currentlyB *	a member of a VAXcluster.  The NODE_NAME argument is a characterB *	string  which must  either be blank  (to check the node on whichB *	this is running)  or contain the name of the node  to be checkedB *	(lower case and trailing blanks are allowed).   The node must be& *	in the same VAXcluster as this node. * = *	11 Jun 87	Add blank argument option; allow trailing blanks.1 *	 *	.INDEX ENVIRONMENT>> *	1 *	Alan L. Zirkle     Naval Surface Warfare Center	 *			   Code K53 * *	17 Jun 1986	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	CHARACTER*(*) NODE_NAME   	INTEGER SYI$_CLUSTER_MEMBER, 	PARAMETER ( SYI$_CLUSTER_MEMBER = '10CF'X )   	CHARACTER*16 NODE< 	INTEGER*4 NLEN,STR_LEN,ITMLST(4),IOSB(2),STATUS,SYS$GETSYIW
 	LOGICAL FLAG    	EXTERNAL SS$_NOSUCHNODE   	NLEN = STR_LEN(NODE_NAME)  ( 	CALL STR$UPCASE(NODE(1:NLEN),NODE_NAME)  0 	CALL ITEM_LIST(ITMLST,SYI$_CLUSTER_MEMBER,FLAG)   	IF (NODE_NAME.NE.' ') THENT  7 	    STATUS = SYS$GETSYIW(,,NODE(1:NLEN),ITMLST,IOSB,,)    	ELSE	  + 	    STATUS = SYS$GETSYIW(,,,ITMLST,IOSB,,)    	ENDIF  ( 	IF (STATUS.EQ.%LOC(SS$_NOSUCHNODE) .OR.- 	1			   IOSB(1).EQ.%LOC(SS$_NOSUCHNODE)) THEN1   	    CLUSTER_MEMBER = .FALSE.	   	ELSE IF (.NOT.STATUS) THEN     	    CALL LIB$STOP(%VAL(STATUS))   	ELSE IF (.NOT.IOSB(1)) THEN  ! 	    CALL LIB$STOP(%VAL(IOSB(1)))E   	ELSEI   	    CLUSTER_MEMBER = FLAG   	ENDIF   	END- 	INTEGER*4 FUNCTION TIMER_SET(SECONDS,AST,ID)    **6 *	INTEGER*4 FUNCTION TIMER_SET( seconds, ast [, id ] ) *	 * D *	Queues a timer request  which will expire  in the specified numberD *	of seconds.   When the timer expires, a subroutine provided by theD *	user is called at AST level.   The name of the subroutine is givenD *	as the AST argument  (remember to declare it EXTERNAL in the call-D *	ing routine).   The subroutine  is called  with one argument,  theD *	value of ID.  NOTE THAT THIS ARGUMENT  IS PASSED BY VALUE  TO YOUR
 *	SUBROUTINE.1 *	D *	The ID value  allows your subroutine  to tell which timer expired,D *	when more than one is used.   It also allows a program to cancel aD *	timer  before it expires,  to prevent  the  subroutine  from beingD *	called (see routine TIMER_CANCEL).  The ID can be any 32-bit inte-D *	ger.   If you omit the ID argument to TIMER_SET,  it will assign aD *	value, beginning with 1000001 and incremented by one for each callD *	to TIMER_SET.   The ID value used is returned as the function res- *	ult. *8 *	.INDEX PROCESS CONTROL>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K538# *	11 May 1987	   Dahlgren, Virginia  *	   	IMPLICIT NONE   	INTEGER*4 SECONDS,ID 
 	EXTERNAL AST8   	LOGICAL*4 ARG_EXIST 	INTEGER*4 IARGPTR6 	INTEGER*4 DEFAULT_ID,ID_,STATUS,SYS$SETIMR,SYS$CANTIM 	REAL*8 VMSTIME1   	DATA DEFAULT_ID / 1000000 /  + 	CALL LIB$EMUL(-SECONDS,10000000,0,VMSTIME)   ' 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THENI
 	    ID_ = ID' 	ELSE   	    DEFAULT_ID = DEFAULT_ID + 1 	    ID_ = DEFAULT_ID  	ENDIF  , 	STATUS = SYS$SETIMR(,VMSTIME,AST,%VAL(ID_))  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))1   	TIMER_SET = ID_   	END 	SUBROUTINE TIMER_CANCEL(ID)   **# *	SUBROUTINE TIMER_CANCEL( [ id ] )  *  *	D *	Cancels a timer request  which has not  expired yet.   See the de-D *	scription for  routine TIMER_SET for information on queueing timer *	requests.1 *	D *	If the optional ID argument is omitted, then all outstanding timerD *	requests by the program are cancelled.   If a 32-bit integer ID isD *	supplied,  then only the timer request with this ID  is cancelled.D *	Using an ID for an  already-expired or non-existant request is not1 *	considered an error; it is effectively a no-op.1 *) *	.INDEX PROCESS CONTROL>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K531# *	11 May 1987	   Dahlgren, Virginia  *	   	IMPLICIT NONE  
 	INTEGER*4 ID1    	INTEGER*4 ID_,STATUS,SYS$CANTIM 	LOGICAL*4 ARG_EXIST 	INTEGER*4 IARGPTR  ' 	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN 
 	    ID_ = ID  	ELSE  	    ID_ = 0 	ENDIF    	STATUS = SYS$CANTIM(%VAL(ID_),)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	END6 	INTEGER*4 FUNCTION INT$SET_SYMBOL(SYMBOL,VALUE,TABLE)   **= *	INTEGER FUNCTION INT$SET_SYMBOL ( symbol , value [,table] )  *	 * D *	Creates a DCL symbol with an integer value.   This routine is muchD *	like LIB$SET_SYMBOL,  except that the VALUE argument is an integerD *	longword value instead of a character string.  The SYMBOL argumentD *	is the name of the symbol  to be defined,  and the optional  TABLED *	argument  can be 1  to use the local symbol table  or 2 to use the7 *	global symbol table (the default is the local table).  *	D *	This routine converts  the integer value to a character string andD *	calls LIB$SET_SYMBOL with that string.  The function result is the# *	return value from LIB$SET_SYMBOL.1 *) *	.INDEX DCL SYMBOLS>> *	1 *	Alan L. Zirkle     Naval Surface Warfare Center	 *			   Code K531* *	14 Jul 1987	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	CHARACTER*(*) SYMBOL  	INTEGER*4 VALUE 	BYTE TABLE    	CHARACTER*16 WORK 	INTEGER*4 W,LIB$SET_SYMBOL  	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  ' 	CALL SYS$FAO('!UL',W,WORK,%VAL(VALUE))1  ' 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THEN   < 	    INT$SET_SYMBOL = LIB$SET_SYMBOL(SYMBOL,WORK(1:W),TABLE)   	ELSE   6 	    INT$SET_SYMBOL = LIB$SET_SYMBOL(SYMBOL,WORK(1:W))   	ENDIF   	END0 	INTEGER FUNCTION HOLIDAY(MONTH,DAY,DAY_OF_WEEK)   **7 *	INTEGER FUNCTION HOLIDAY( month , day , day_of_week )  *1D *	Returns an indication of whether  the given day of the given monthD *	is a federal holiday or not.  Returns zero if it is not a holiday,D *	or a non-zero integer giving the holiday number (described below). *	D *	The required integer input arguments are MONTH (1-12), DAY (1-31),? *	and DAY_OF_WEEK (1 = Sunday, 2 = Monday, ... , 7 = Saturday).  *M5 *	The function result is one of the following values:  *  *		0 = Not a holiday *		1 = New Year's Day A *	       -1 = Fri or Mon off when New Year's Day is on Sat or Sun	$ *		2 = Martin Luther King's Birthday# *		3 = George Birthington's Washday	 *		4 = Memorial Day ( *		5 = Independence Day (Fourth of July) *		6 = Labor Day *		7 = Columbus Day	 *		8 = Veterans Day ? *	       -8 = Fri or Mon off when Veterans Day is on Sat or SunM *		9 = Thanksgiving DayM *	       10 = Christmas Day @ *	      -10 = Fri or Mon off when Christmas Day is on Sat or Sun *  *	.INDEX DATES>> *	1 *	Alan L. Zirkle     Naval Surface Warfare Center	 *			   Code K551* *	 7 Jul 1992	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE    	INTEGER*4 MONTH,DAY,DAY_OF_WEEK   	HOLIDAY = 0  ) 	GO TO (1,2,3,4,5,6,7,8,9,10,11,12),MONTH	  0 1	IF (DAY.EQ.1) HOLIDAY = 1			  ! New Year's DayI 	IF (DAY.EQ.2 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -1 ! New Year's Day (obs)	 	IF (DAY_OF_WEEK.EQ.2) THEN C 	    IF (DAY.GE.15 .AND. DAY.LE.21) HOLIDAY = 2	  ! King's Birthday  	ENDIF 	RETURN    2	IF (DAY_OF_WEEK.EQ.2) THENH 	    IF (DAY.GE.15 .AND. DAY.LE.21) HOLIDAY = 3	 ! Washington's Birthday 	ENDIF 	RETURN    3	RETURN   4	RETURN   5	IF (DAY_OF_WEEK.EQ.2) THEN1 	    IF (DAY.GE.25) HOLIDAY = 4			 ! Memorial DayN 	ENDIF						 !  (Last Monday)' 	RETURN	   6	RETURN  5 7	IF (DAY.EQ.3 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -5 !11 	IF (DAY.EQ.4) HOLIDAY = 5			  ! Independence Day14 	IF (DAY.EQ.5 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -5 ! 	RETURN    8	RETURN   9	IF (DAY_OF_WEEK.EQ.2) THEN- 	    IF (DAY.LE.7) HOLIDAY = 6			 ! Labor Day1 	ENDIF 	RETURN    10	IF (DAY_OF_WEEK.EQ.2) THEN1> 	    IF (DAY.GE.8 .AND. DAY.LE.14) HOLIDAY = 7	 ! Columbus Day 	ENDIF 	RETURN   8 11	IF (DAY.EQ.10 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -8  !1 	IF (DAY.EQ.11) HOLIDAY = 8			    ! Veterans' Day 6 	IF (DAY.EQ.12 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -8  ! 	IF (DAY_OF_WEEK.EQ.5) THEN C 	    IF (DAY.GE.22 .AND. DAY.LE.28) HOLIDAY = 9	 ! Thanksgiving DayR 	ENDIF 	RETURNe  9 12	IF (DAY.EQ.24 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -10  !l2 	IF (DAY.EQ.25) HOLIDAY = 10			    ! Christmas Day7 	IF (DAY.EQ.26 .AND. DAY_OF_WEEK.EQ.2) HOLIDAY = -10  !DI 	IF (DAY.EQ.31 .AND. DAY_OF_WEEK.EQ.6) HOLIDAY = -1 !New Year's Day (obs)W 	RETURNn  
 	END									 