: 	INTEGER*4 FUNCTION TEXT_OPEN_INPUT_(UNIT,F_A,F_L,D_A,D_L)   **? *	INTEGER FUNCTION TEXT_OPEN_INPUT_( unit , fa , fl , da , dl )  *  * ' *	This is part of the Text I/O Package.  * D *	This routine is not called by the user.   It is called by  routineD *	TEXT_OPEN_INPUT.   This routine  opens  the file;  TEXT_OPEN_INPUTD *	pre-processes the arguments  and passes five  items of data:   theD *	integer unit number, the address of the string containing the fileD *	name,  the length of the string containing the file name,  the ad-D *	dress of the string containing the default file name  (or zero, ifD *	no default file name,  and the length of the string containing the *	default file name (or zero). * > *	See the description of TEXT_OPEN_INPUT for more information. *  *	.INDEX DISK I/O>>  * 0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	INCLUDE '($FABDEF)' 	INCLUDE '($RABDEF)' 	INCLUDE '($NAMDEF)'  % 	INTEGER*4 UNIT,F_A,D_A,LLEN,FLEN,RFA  	BYTE	  CC,F_L,D_L 	CHARACTER*(*) LINE,FILE  = 	INTEGER*4 TEXT_OPEN_OUTPUT_,TEXT_CLOSE,TEXT_READ,TEXT_WRITE, : 	1	  TEXT_FILE_NAME,TEXT_CC_TYPE,TEXT_VFC,TEXT_OPEN_ERROR,1 	2	  TEXT_ERROR,TEXT_ERROR_HANDLER,TEXT_USEROPEN, ' 	3	  TEXT_REWIND,TEXT_RFA,TEXT_READ_RFA     	CHARACTER*255 TEXT_FILES(10:13), 	INTEGER*4 UNIT_,TFLEN(10:13),CC_TYPE(10:13) 	INTEGER*2 VFC(10:11) & 	LOGICAL*1 OPEN(10:13) / 4 * .FALSE. /   	RECORD /FABDEF/	FAB(10:13)  	RECORD /RABDEF/ RAB(10:13)  	RECORD /NAMDEF/ NAM   	INTEGER*4 STATUS,MSGVEC(5)  	INTEGER*4 ERROR_ROUTINE / 0 /! 	INTEGER*4 USEROPEN_ROUTINE / 0 /  	CHARACTER*255 TEXT_FILES_ERR   : 	INTEGER*4 LBYTE,SYS$OPEN,SYS$CREATE,SYS$CONNECT,SYS$CLOSE/ 	INTEGER*4 SYS$GET,SYS$PUT,SYS$REWIND,LIB$CALLG  	EXTERNAL TEXT_MSG_FORMAT     : 	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. OPEN(UNIT)) GO TO 110  ' 	CALL RMS_INIT(FAB(UNIT),RAB(UNIT),NAM)   4 	FAB(UNIT).FAB$B_SHR = FAB$M_SHRGET + FAB$M_SHRPUT +& 	1				     FAB$M_SHRDEL + FAB$M_SHRUPD 	FAB(UNIT).FAB$B_DNS = D_L 	FAB(UNIT).FAB$L_DNA = D_A 	FAB(UNIT).FAB$B_FNS = F_L 	FAB(UNIT).FAB$L_FNA = F_A  	FAB(UNIT).FAB$L_FOP = FAB$M_SQO  4 	RAB(UNIT).RAB$L_RHB = %LOC(VFC(UNIT))	! VFC Support  - 	NAM.NAM$B_RSS = LBYTE(LEN(TEXT_FILES(UNIT))) ' 	NAM.NAM$L_RSA = %LOC(TEXT_FILES(UNIT)) + 	NAM.NAM$B_ESS = LBYTE(LEN(TEXT_FILES_ERR)) % 	NAM.NAM$L_ESA = %LOC(TEXT_FILES_ERR)   ? 	IF (USEROPEN_ROUTINE.NE.0) CALL TEXT_USEROPEN_(UNIT,FAB(UNIT), - 	1			       RAB(UNIT),NAM,1,USEROPEN_ROUTINE)    	STATUS = SYS$OPEN(FAB(UNIT))    	IF (STATUS) THEN $ 	    STATUS = SYS$CONNECT(RAB(UNIT))( 	    CC_TYPE(UNIT) = RAB(UNIT).RAB$L_STV 	ELSE ( 	    CC_TYPE(UNIT) = FAB(UNIT).FAB$L_STV 	ENDIF   	TEXT_OPEN_INPUT_ = STATUS   	IF (.NOT.STATUS) THEN  	    TFLEN(UNIT) = NAM.NAM$B_ESL& 	    TEXT_FILES(UNIT) = TEXT_FILES_ERR 	    USEROPEN_ROUTINE = 0  	    RETURN  	ENDIF   	TFLEN(UNIT) = NAM.NAM$B_RSL  > 	STATUS = FAB(UNIT).FAB$B_RAT		! Compute carriage control type" 	STATUS = IAND(STATUS,'00000007'x) 	CC_TYPE(UNIT) = STATUS 2 	IF (STATUS.EQ.1) CC_TYPE(UNIT) = 0	!  0 = Fortran/ 	IF (STATUS.EQ.2) CC_TYPE(UNIT) = 1	!  1 = List / 	IF (STATUS.EQ.0) CC_TYPE(UNIT) = 2	!  2 = None . 	IF (STATUS.EQ.4) CC_TYPE(UNIT) = 3	!  3 = VFC 	OPEN(UNIT) = .TRUE.    	IF (USEROPEN_ROUTINE.NE.0) THEN( 	    CALL TEXT_USEROPEN_(UNIT,FAB(UNIT),- 	1			       RAB(UNIT),NAM,2,USEROPEN_ROUTINE)  	    USEROPEN_ROUTINE = 0  	ENDIF   	RETURN       1 	ENTRY TEXT_OPEN_OUTPUT_(UNIT,CC,F_A,F_L,D_A,D_L)    **D *	INTEGER FUNCTION TEXT_OPEN_OUTPUT_( unit , c , fa , fl , da , dl ) *  * ' *	This is part of the Text I/O Package.  * D *	This routine is not called by the user.   It is called by  routineD *	TEXT_OPEN_OUTPUT.  This routine  opens the file;  TEXT_OPEN_OUTPUTD *	pre-processes the arguments and passes six items of data:  the in-D *	teger unit number, the integer carriage control type (default is 1D *	for LIST) the address of the string containing the file name,  theD *	length of the string containing the file name,  the address of theD *	string containing the default file name  (or zero,  if no  defaultD *	file name,  and  the  length  of the string containing the default *	file name (or zero). * ? *	See the description of TEXT_OPEN_OUTPUT for more information.  *  *	.INDEX DISK I/O>>  * 0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *   9 	IF (UNIT.LT.12 .OR. UNIT.GT.13 .OR. CC.LT.0 .OR. CC.GT.2 & 	1				      .OR. OPEN(UNIT)) GO TO 110  ' 	CALL RMS_INIT(FAB(UNIT),RAB(UNIT),NAM)     	FAB(UNIT).FAB$B_RFM = FAB$C_VAR 	FAB(UNIT).FAB$B_DNS = D_L 	FAB(UNIT).FAB$L_DNA = D_A 	FAB(UNIT).FAB$B_FNS = F_L 	FAB(UNIT).FAB$L_FNA = F_A  	FAB(UNIT).FAB$L_FOP = FAB$M_SQO   	FAB(UNIT).FAB$B_RAT = FAB$M_CR - 	IF (CC.EQ.0) FAB(UNIT).FAB$B_RAT = FAB$M_FTN % 	IF (CC.EQ.2) FAB(UNIT).FAB$B_RAT = 0   - 	NAM.NAM$B_RSS = LBYTE(LEN(TEXT_FILES(UNIT))) ' 	NAM.NAM$L_RSA = %LOC(TEXT_FILES(UNIT)) + 	NAM.NAM$B_ESS = LBYTE(LEN(TEXT_FILES_ERR)) % 	NAM.NAM$L_ESA = %LOC(TEXT_FILES_ERR)   ? 	IF (USEROPEN_ROUTINE.NE.0) CALL TEXT_USEROPEN_(UNIT,FAB(UNIT), - 	1			       RAB(UNIT),NAM,1,USEROPEN_ROUTINE)    	STATUS = SYS$CREATE(FAB(UNIT))    	IF (STATUS) THEN $ 	    STATUS = SYS$CONNECT(RAB(UNIT))( 	    CC_TYPE(UNIT) = RAB(UNIT).RAB$L_STV 	ELSE ( 	    CC_TYPE(UNIT) = FAB(UNIT).FAB$L_STV 	ENDIF   	TEXT_OPEN_OUTPUT_ = STATUS    	IF (.NOT. STATUS) THEN   	    TFLEN(UNIT) = NAM.NAM$B_ESL& 	    TEXT_FILES(UNIT) = TEXT_FILES_ERR 	    USEROPEN_ROUTINE = 0  	    RETURN  	ENDIF   	TFLEN(UNIT) = NAM.NAM$B_RSL 	CC_TYPE(UNIT) = CC  	OPEN(UNIT) = .TRUE.    	IF (USEROPEN_ROUTINE.NE.0) THEN( 	    CALL TEXT_USEROPEN_(UNIT,FAB(UNIT),- 	1			       RAB(UNIT),NAM,2,USEROPEN_ROUTINE)  	    USEROPEN_ROUTINE = 0  	ENDIF   	RETURN        	ENTRY TEXT_CLOSE(UNIT)    **% *	INTEGER FUNCTION TEXT_CLOSE( unit )  *  * ' *	This is part of the Text I/O Package.  * D *	Closes the file previously  opened by routine  TEXT_OPEN_INPUT  orD *	TEXT_OPEN_OUTPUT  on the specified unit,  which must be an integerD *	10, 11, 12, or 13.  After the unit is closed, the same unit number) *	may be re-used in opening another file.  * > *	The function result will return the VMS status of the close. *  *	.INDEX DISK I/O>>  * 0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *   ? 	IF (UNIT.LT.10 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110   " 	TEXT_CLOSE = SYS$CLOSE(FAB(UNIT))   	OPEN(UNIT) = .FALSE.    	RETURN        	ENTRY TEXT_REWIND(UNIT)   **& *	INTEGER FUNCTION TEXT_REWIND( unit ) *  * ' *	This is part of the Text I/O Package.  * D *	Rewinds the file previously opened by routine  TEXT_OPEN_INPUT  orD *	TEXT_OPEN_OUTPUT  on the specified unit,  which must be an integer *	10, 11, 12, or 13. * ? *	The function result will return the VMS status of the rewind.  *  *	.INDEX DISK I/O>>  * 0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55) *	17 Sep 1991	  Dahlgren, Virginia  22448  *   ? 	IF (UNIT.LT.10 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110   $ 	TEXT_REWIND = SYS$REWIND(RAB(UNIT))   	RETURN         	ENTRY TEXT_READ(UNIT,LINE,LLEN)   **2 *	INTEGER FUNCTION TEXT_READ( unit , line , llen ) *  * ' *	This is part of the Text I/O Package.  * D *	Reads one record from  the file previously opened on the specifiedE *	unit by routine TEXT_OPEN_INPUT.  UNIT must be an integer 10 or 11.  * D *	The function result will be a  TRUE  (odd)  value  if the read wasD *	successful, or a FALSE (even) value if end-of-file was encountered *	and no record was read.  * D *	The record is read into character string  LINE,  and the length is *	returned in integer LLEN.  * D *	If an error occurs while reading the record  (for  example  if theD *	string LINE is too short to hold the record) then the program willD *	abort with a meaningful message, unless routine TEXT_ERROR_HANDLERD *	was previously called to set up an error handling routine; in this1 *	case the error handling routine will be called.  *  *	.INDEX DISK I/O>>  * 0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *   ? 	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. .NOT.OPEN(UNIT)) GO TO 110   ! 	RAB(UNIT).RAB$L_UBF = %LOC(LINE)   	RAB(UNIT).RAB$W_USZ = LEN(LINE)   	TEXT_READ = SYS$GET(RAB(UNIT))    	LLEN = RAB(UNIT).RAB$W_RSZ    	IF (.NOT.TEXT_READ) THEN & 	    IF (TEXT_READ.EQ.'1827A'x) RETURN& 	    IF (ERROR_ROUTINE.NE.0) GO TO 100= 	    CALL LIB$STOP(%VAL(TEXT_READ),%VAL(RAB(UNIT).RAB$L_STV))  	ENDIF   	RETURN    100	MSGVEC(1) = 3  	MSGVEC(2) = %LOC(UNIT) & 	MSGVEC(3) = %LOC(RAB(UNIT).RAB$L_STS)& 	MSGVEC(4) = %LOC(RAB(UNIT).RAB$L_STV)$ 	MSGVEC(5) = UNIT			! For TEXT_ERROR  2 	TEXT_READ = LIB$CALLG(MSGVEC,%VAL(ERROR_ROUTINE)) 	RETURN   5 110	CALL LIB$PUT_OUTPUT('%TEXT_PACKAGE-F-BADCALL, '// 4 	1		     'the Text I/O package was used improperly') 	CALL EXIT('10000004'x)       ( 	ENTRY TEXT_READ_RFA(UNIT,LINE,LLEN,RFA)   **< *	INTEGER FUNCTION TEXT_READ_RFA( unit , line , llen , rfa ) *  * ' *	This is part of the Text I/O Package.  * D *	This is identical to routine TEXT_READ,  except that the RFA argu-D *	ment specifies the  Record File Address  of the record to be read.C *	This provides a basic form of random access to a sequential file.  * C *	The RFA which is input to TEXT_READ_RFA must have been saved from C *	a previous call to TEXT_RFA.  Thus, to randomly access records of C *	the file,  the RFA of each record must have been previously saved 1 *	when creating or sequentially reading the file.  * C *	To use TEXT_READ_RFA, routine TEXT_USEROPEN must have been called C *	before opening the file, to specify a useropen routine.  The user C *	must provide this routine,  which must zero out the FAB$M_SQO bit C *	of the FAB$L_FOP field of the file's FAB before the file is open-  *	ed.  An example is:  *  *		EXTERNAL MYROUTINE " *		CALL TEXT_USEROPEN( MYROUTINE ) *		CALL TEXT_OPEN_INPUT(10, ...  *		.... *		SUBROUTINE MYROUTINE(UNIT,FAB,RAB,NAM,CODE) *		INCLUDE '($FABDEF)' *		INTEGER*4 UNIT,RAB,NAM,CODE *		RECORD /FABDEF/	FAB# *		IF (CODE.EQ.1) FAB.FAB$L_FOP = 0  *		END *  *	.INDEX DISK I/O>>R *F0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55) *	20 Oct 1992	  Dahlgren, Virginia  22448a *d  ? 	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. .NOT.OPEN(UNIT)) GO TO 110r  ! 	RAB(UNIT).RAB$L_UBF = %LOC(LINE)t  	RAB(UNIT).RAB$W_USZ = LEN(LINE)  	RAB(UNIT).RAB$B_RAC = RAB$C_RFA  * 	CALL LIB$MOVC3(6,RFA,RAB(UNIT).RAB$W_RFA)  # 	TEXT_READ_RFA = SYS$GET(RAB(UNIT))t   	RAB(UNIT).RAB$B_RAC = 0   	LLEN = RAB(UNIT).RAB$W_RSZc   	IF (.NOT.TEXT_READ_RFA) THENl& 	    IF (ERROR_ROUTINE.NE.0) GO TO 100= 	    CALL LIB$STOP(%VAL(TEXT_READ),%VAL(RAB(UNIT).RAB$L_STV))l 	ENDIF   	RETURNf       	ENTRY TEXT_WRITE(UNIT,LINE)   **, *	INTEGER FUNCTION TEXT_WRITE( unit , line ) *  * ' *	This is part of the Text I/O Package._ *ND *	Writes the contents of character string LINE as one record  on theD *	file previously opened by routine TEXT_OPEN_OUTPUT on the specifi-4 *	ed unit number.  UNIT must be an integer 12 or 13. *UD *	If an error occurs while writing the line (for example if the diskD *	fills up),  then the program will abort with a meaningful message,D *	unless routine TEXT_ERROR_HANDLER  was previously called to set upD *	an error handling routine; in this case the error handling routine *	will be called.R *N *	.INDEX DISK I/O>>  * 0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *(  ? 	IF (UNIT.LT.12 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110.    	RAB(UNIT).RAB$W_RSZ = LEN(LINE)! 	RAB(UNIT).RAB$L_RBF = %LOC(LINE)R    	TEXT_WRITE = SYS$PUT(RAB(UNIT))   	IF (.NOT.TEXT_WRITE) THEN& 	    IF (ERROR_ROUTINE.NE.0) GO TO 100> 	    CALL LIB$STOP(%VAL(TEXT_WRITE),%VAL(RAB(UNIT).RAB$L_STV)) 	ENDIF   	RETURNS      % 	ENTRY TEXT_FILE_NAME(UNIT,FILE,FLEN)T   **1 *	SUBROUTINE TEXT_FILE_NAME( unit , file , flen )I *U *.' *	This is part of the Text I/O Package.  *1D *	This routine obtains the current file name of the specified  unit,D *	after  TEXT_OPEN_INPUT or TEXT_OPEN_OUTPUT has been called to openD *	the unit.  The unit number must be integer 10, 11, 12, or 13.  TheD *	file name is returned  in character string FILE, and the length ofD *	the name is returned in integer  FLEN.   String FILE should be 255A *	characters long to ensure that it can hold any valid file name.( *TD *	If the file open succeeded, the name returned will be the full ac-D *	tual name of the file.  If the open failed, the name returned will? *	be the full name of the file on which the open was attempted.N *U *	.INDEX DISK I/O>>Y *P0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *L  * 	IF (UNIT.LT.10 .OR. UNIT.GT.13) GO TO 110   	FLEN = TFLEN(UNIT)X 	FILE = TEXT_FILES(UNIT)   	RETURNT       	ENTRY TEXT_CC_TYPE(UNIT)M   **' *	INTEGER FUNCTION TEXT_CC_TYPE( unit )E *  * ' *	This is part of the Text I/O Package.D * D *	If called after a file has been opened by routine  TEXT_OPEN_INPUTD *	or TEXT_OPEN_OUTPUT, the function result of this routine is an in-D *	teger code  describing the type of carriage control which the file. *	uses.  The code can be one of the following: *  *			0   Fortran  *			1   List *			2   None *			3   VFCU *QD *	If called  after  a  failure  has occured in opening the file, theD *	function result will be the RMS STV  value  generated by the fail-D *	ure.  This can be used in calls to LIB$STOP or LIB$SIGNAL to print *	meaningful error messages. *T *	.INDEX DISK I/O>>, *F0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *   * 	IF (UNIT.LT.10 .OR. UNIT.GT.13) GO TO 110   	TEXT_CC_TYPE = CC_TYPE(UNIT)    	RETURNd       	ENTRY TEXT_VFC(UNIT)P   **# *	INTEGER FUNCTION TEXT_VFC( unit )E *U *T' *	This is part of the Text I/O Package.s *xD *	This routine must only be called when reading a file using routineD *	TEXT_READ,  and then only when the file's carriage control type isD *	VFC.  The function result of this routine will be the VFC carriageD *	control  value  from the last record read.  The most common valuesC *	encountered (in hexadecimal), and their Fortran equivalents, are:n *o1 *		8D01   blank - one LF+CR before line, CR after	. *		8D02	0    - two LF+CR before line, CR after' *		8D8C	1    - FF before line, CR after , *		8D00	+    - nothing before line, CR after3 *		0001	$    - one LF+CR before line, nothing afteri4 *		0000   nul   - nothing before line, nothing after *.D *	See the VAX RMS manual for a full explanation of the fields in the* *	value.  Note that the bytes are swapped. *F *	.INDEX DISK I/O>>  *B0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *B    7 	IF (UNIT.LT.10 .OR. UNIT.GT.11 .OR. CC_TYPE(UNIT).NE.3C& 	1				  .OR. .NOT.OPEN(UNIT)) GOTO 110   						! 8D02 = '0'$ 	TEXT_VFC = VFC(UNIT)			! 8D8C = '1'/ 	TEXT_VFC = IAND(TEXT_VFC,'FFFF'x)	! 8D00 = '+'M 						! 0001 = '$' 	RETURN					! 0000 = nul      & 	ENTRY TEXT_OPEN_ERROR(UNIT,LINE,FILE)   **9 *	SUBROUTINE TEXT_OPEN_ERROR( unit , keyword , filetype )X *S *P' *	This is part of the Text I/O Package.T *AD *	This routine is meant to be called  after routine  TEXT_OPEN_INPUTD *	or TEXT_OPEN_OUTPUT fails.  It puts out meaningful error messages,8 *	and aborts the program.  Three arguments are required: *FD *	     1. The integer unit number  (10-13)  used with the file which *		encountered the failure.M *MD *	     2. A character string keyword which will be used in the first1 *		error message.  This message is in the format:M *R; *		  %<KEYWORD>-F-OPENERR, error opening <FILETYPE> file...E *O3 *		Usually this keyword is the name of the utility.N *,D *	     3. A lower-case character string  describing the type of file= *		which was being opened.   This is usually  something  like* *		'input' or 'output'._ *SD *	The first error message also  gives the full name of the file  (asD *	much as can be determined.  The second message describes the fail-D *	ure in standard VMS error message format,  and then the program is
 *	aborted. *. *	.INDEX DISK I/O>>l *d0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *M  
 	UNIT_ = UNITl  , 	IF (UNIT_.LT.10 .OR. UNIT_.GT.13) GO TO 110  < 	CALL LIB$PUT_OUTPUT('%'//LINE//'-F-OPENERR, error opening '; 	1	    //FILE//' file '//TEXT_FILES(UNIT_)(1:TFLEN(UNIT_)))I   120	MSGVEC(1) = 2N! 	MSGVEC(2) = FAB(UNIT_).FAB$L_STS  	IF (MSGVEC(2)) THEN% 	    MSGVEC(2) = RAB(UNIT_).RAB$L_STS % 	    MSGVEC(3) = RAB(UNIT_).RAB$L_STVN 	ELSEU% 	    MSGVEC(3) = FAB(UNIT_).FAB$L_STVh 	ENDIF  * 	CALL SYS$PUTMSG(MSGVEC,TEXT_MSG_FORMAT,,)0 	CALL LIB$STOP(%VAL(IOR(MSGVEC(2),'10000000'x)))   	RETURNE       	ENTRY TEXT_ERRORe   ** *	SUBROUTINE TEXT_ERRORi *g * ' *	This is part of the Text I/O Package.r *lD *	This routine  is meant to be called from a program's error handlerD *	which was declared using the TEXT_ERROR_HANDLER routine.   It putsD *	out  an error message describing the last error encountered during> *	a TEXT_READ or TEXT_WRITE operation, and aborts the program. *SD *	Note that errors are more frequent during file opens; these errors+ *	are processed by routine TEXT_OPEN_ERROR.l * 0 *	Here is an example of how to use this routine: *a *		  ... *		EXTERNAL MY_ERROR_HANDLER *		  ..., *		CALL TEXT_ERROR_HANDLER(MY_ERROR_HANDLER) *		  ... *		  ..., *		SUBROUTINE MY_ERROR_HANDLER(UNIT,STS,STV) *		IF (UNIT.EQ.10) THEN 4 *		  PRINT *,'%MYPROG-F-INPERR, error on input file' *		ELSE( *		  ... *		ENDIF *		CALL TEXT_ERROR *		END *o *	.INDEX DISK I/O>>  *	0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *r   	UNIT_ = MSGVEC(5)
 	GO TO 120       	ENTRY TEXT_ERROR_HANDLER(UNIT)    **7 *	SUBROUTINE TEXT_ERROR_HANDLER( handler_routine_name )  *h *m' *	This is part of the Text I/O Package.R *HD *	Defines to the Text I/O Package an  error handling routine provid-D *	ed by the caller.   The Package will call this routine when an I/OD *	error occurs while performing a TEXT_READ or TEXT_WRITE operation. *	D *	The  name  of  the desired routine must be passed as the argument.D *	This name must be declared EXTERNAL  in  the  routine  which callsD *	TEXT_ERROR_HANDLER.  The routine may be changed as often as neces- *	sary.T *BD *	If no error handling routine is used, TEXT_READ or TEXT_WRITE willD *	abort the program when an error occurs,  displaying the associatedD *	VMS error message on  SYS$OUTPUT.   This default action can be re-D *	stored by caling TEXT_ERROR_HANDLER with an argument of "%VAL(0)". * D *	The default action is fine, except that it does not output any ap-D *	lication-specific diagnostic messages;  the default message  tellsD *	what error occurred,  but it  does not tell the user which file it1 *	occurred on; this may be necessary information.O *cD *	When an error occurs,  the  error  handling routine is called withD *	three integer arguments:  the file unit number  (10-13),  the  VMSD *	status  code  describing the error, and the RMS STV value from theD *	error.  This allows the routine to take different paths, if neces-) *	sary, depending on what error occurred.F * D *	The error handling routine must be an integer function.  It can do *	one of three things: * D *	--- It can abort the program.  It should do any cleaning up neces-D *	    sary,  and output any  application-specific messages,  then itD *	    should either exit the program or call routine TEXT_ABORT; theD *	    latter is recommended, since it puts out the VMS error messageB *	    describing the error.   See TEXT_ABORT for more information. *eD *	--- It can return  with a function result of 1.   The operation inD *	    progress (TEXT_READ or TEXT_WRITE) will appear to have succes-D *	    fully completed.  The error handler can output messages or set) *	    flags as desired before it returns.N * E *	--- It can return with  any other function result.   This value is 	D *	    then used as the function result  of the operation in progressD *	    (TEXT_READ or TEXT_WRITE); the calling program then can decideB *	    what to do about the error.  Usually, the value used will be9 *	    the VMS status value passed as the second argument.o *K *	.INDEX DISK I/O>>a *r0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448     	ERROR_ROUTINE = %LOC(UNIT)) 	RETURNZ       	ENTRY TEXT_USEROPEN(UNIT)   **3 *	SUBROUTINE TEXT_USEROPEN( useropen_routine_name )  *T *_' *	This is part of the Text I/O Package.I *RD *	Defines to the  Text I/O Package  a routine provided by the callerD *	which will participate  in the next file open  (i.e. the next callD *	to routine TEXT_OPEN_INPUT or TEXT_OPEN_OUTPUT).  The Package willD *	call this routine twice:  after the FAB,  RAB, and NAM blocks haveD *	been initialized,  and after the file has been opened.   The firstD *	call can be used to modify  information in  the RMS blocks,  or toD *	add XAB blocks.   The second call can be used to retrieve informa-> *	tion from the blocks which was deposited by RMS on the open. * D *	This routine is analogous to using the USEROPEN keyword  on a For-D *	tran OPEN statement.  The name of the desired routine is passed asD *	the argument.   This name must be declared EXTERNAL in the routineD *	which calls  TEXT_USEROPEN.   The routine is only used on the very) *	next file open by the Text I/O Package.L *iD *	The useropen routine is called with five arguments:  the file unitD *	number (integer 10-13), the address of the FAB, the address of theD *	RAB, the address of the NAM, and an integer code which is 1 on the' *	first call, and 2 on the second call.T * D *	Unlike Fortran USEROPEN routines, this routine must not perform an *	$OPEN, $CREATE, or $CONNECT. *T *	.INDEX DISK I/O>>V *R0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55( *	7 Sep 1989	  Dahlgren, Virginia  22448 *_   	USEROPEN_ROUTINE = %LOC(UNIT) 	RETURN	       	ENTRY TEXT_RFA(UNIT,RFA)a   **# *	SUBROUTINE TEXT_RFA( unit , rfa )t *l *a' *	This is part of the Text I/O Package._ *ND *	Returns the RFA  (Record File Address)  of the last record read byD *	TEXT_READ  or written by  TEXT_WRITE  on the specified unit, which' *	must be an integer 10, 11, 12, or 13.l *tD *	The RFA is returned in the second argument, which must either be aD *	BYTE array or six elements,  an INTEGER*2 array of three elements,; *	an INTEGER*4 array of two elements, or a REAL*8 variable.b *hD *	The RFA value can be used in a subsequent call to TEXT_READ_RFA to> *	directly access this record without searching down the file. *t *	.INDEX DISK I/O>>X *S0 *	Alan L. Zirkle    Naval Surface Warfare Center *			  Code K55) *	20 Oct 1992	  Dahlgren, Virginia  22448i *   ? 	IF (UNIT.LT.10 .OR. UNIT.GT.13 .OR. .NOT.OPEN(UNIT)) GO TO 110   * 	CALL LIB$MOVC3(6,RAB(UNIT).RAB$W_RFA,RFA) 	RETURN   
 	END									T (5 	INTEGER FUNCTION GET_LINE(UNIT,STRING,LENGTH,CCTYPE)    **@ *	INTEGER FUNCTION GET_LINE( unit , string , length , [cctype] ) *i *hD *	Reads file whose unit number is the argument UNIT, and returns oneD *	'logical' line.   The calling program must have previously  openedD *	the file using routine TEXT_OPEN_INPUT. Only unit numbers 10 or 11D *	can be used.  These two units can be processed concurrently if de- *	sired. *UD *	The line is returned in character string STRING; the length of the2 *	line is returned in the longword integer LENGTH. *eD *	If the file does not have Fortran  Carriage  Control,  the  actualD *	line read (the 'physical' line) is reformatted so that STRING con-D *	tains  a  Fortran-like  line;  i.e. column 1 contains the carriageD *	control for the line.  In doing this reformatting, it may  be  ne-D *	cessary  for  GET_LINE to split the physical line into two or moreD *	logical lines.  Only one logical line is returned  per  call;  theD *	remaining  part(s) of the physical line are returned on subsequent *	calls. *nD *	The functional result is 1 (.TRUE.) unless end-of-file was reachedD *	in which case it is 0 (.FALSE.).  GET_LINE does NOT close the fileD *	when it senses end-of-file.  To close the file, routine TEXT_CLOSE *	must be used.r *. *	.INDEX DISK I/O>>u * D *	This routine cannot handle every type of file.  It is designed  to	 *	handle:  *l. *	    * Any file with Fortran Carriage Control * 3 *	    * Files output from the DSR or RNO utilities.  *oD *	    * Files with 'List' Carriage Control (i.e.  files  created  asD *	      listing files by VMS components, or normal files created us-D *	      ing EDT) which have no embedded ASCII control characters ex-
 *	      cept:  *t= *		a.  A Form Feed (page eject) or Line Feed (double spacing)F- *		    may appear at the beginning of a line.  *a= *		b.  A Carriage Return may  appear  anywhere  in  the line.e= *		    (This  is  used  for  underlining  and  overprinting.). *_= *		c.  A Carriage Return/Line Feed pair may  appear  anywhere	= *		    in  the  line.   (This  is used to pack multiple print  *		    lines onto one record.) *++ *	    * A subset of VFC/Print Format files.n *-D *	Files with records longer than 255 characters are not handled.   AD *	file with 'Unknown' Carriage Control is assumed to be a List file;D *	this assumption is, of course, not too good if the file is an .OBJ *	or .EXE file.N *	D *	If the first character in a line is the European left quote (asciiD *	code 171 decimal, looks like '<<'), then this character is used as. *	the carriage control character for the line. *hD *	If  the  optional  longword  integer  argument  CCTYPE is present,D *	GET_LINE returns in it the type of Carriage Control the file  has,
 *	as follows:  *  *		FORTRAN  --  0% *		   LIST  --  1,. *		   NONE  --  2	   (DSR or RNO output files) *	      VFC/PRINT  --  3 *f" *	See also routine GET_LINE_RESET. *a *c@ *	23 Apr 1984	Treat UNKNOWN files same as  LIST;  the assumption6 *			is that they are VFC/Print Format files created by *			the VMS OPEN/WRITE command.o2 *			Handle double spacing (Line Feed in column 1).4 *	 3 May 1984	Handle CR/LF in col 1-2 of list files.@ *	20 Jun 1984	Do not  close file  upon EOF;  calling program may" *			need to do special processing.4 *	 8 Mar 1985	Treat V4.0 DSR method of overprinting.@ *	 6 Nov 1985	Add test for European left quote in col 1 of line.@ *	27 Jan 1988	Handle RNO files, which have formfeeds on lines by *			themselves.0< *	 3 Oct 1988	Handle <CR> on line by itself, which can occur- *			when using RNO commands .LEFT TITLE, etc.1/ *	 7 Dec 1988	Handle <CR> at end of LIST lines.)? *	21 Aug 1989	Handle <CR><LF> and <CR> in middle of NONE lines.R: *	 7 Sep 1989	Use TEXT_IO routines instead of Fortran I/O.6 *			Handle VFC/Print Format files correctly  (to  some *			degree).3 *	21 Oct 1992	Handle VFC/Print Format files better.( *		S *C1 *	Alan L. Zirkle     Naval Surface Warfare CenterR *			   Code K55R* *	18 Mar 1984	   Dahlgren, Virginia  22448 *h   	IMPLICIT NONE   	INTEGER*4 UNITi 	CHARACTER*(*) STRINGe 	INTEGER*4 LENGTHe 	INTEGER*4 CCTYPEc   	INTEGER*4 GET_LINE_RESET_    	CHARACTER CRLF*2,CR*1,LF*1,FF*1  * 	PARAMETER ( CRLF = CHAR(13) // CHAR(10) ) 	PARAMETER ( CR   = CHAR(13) ) 	PARAMETER ( LF   = CHAR(10) ) 	PARAMETER ( FF   = CHAR(12) )   	CHARACTER*256 BUFFER(10:11)  F 	INTEGER*2 BLEN(10:11) / -1,-1 /	! Non-neg means buffer has data in it 					!  from last callF 	BYTE CC_TYPE(10:11) / -1,-1 /	! Minus one means initialization needed& 	LOGICAL THIS_LINE_CRLF,LAST_LINE_CRLF 	INTEGER*4 LEN,VFC,COL,COL2.  ) 	INTEGER*4 TEXT_CC_TYPE,TEXT_VFC,SUBINDEXI 	LOGICAL ARG_EXIST,TEXT_READ 	INTEGER*4 IARGPTR  = 	IF (CC_TYPE(UNIT).LT.0) THEN		! First call after file openedE' 	    CC_TYPE(UNIT) = TEXT_CC_TYPE(UNIT)I 	    THIS_LINE_CRLF = .TRUE. 	ENDIF    	LAST_LINE_CRLF = THIS_LINE_CRLF 	THIS_LINE_CRLF = .FALSE.   : 	IF (ARG_EXIST(%VAL(IARGPTR()), 4)) CCTYPE = CC_TYPE(UNIT)   	IF (BLEN(UNIT).LT.0) THEN  = 	    IF (BLEN(UNIT).EQ.-3) GO TO 100		! Used by RNO <FF> codei  9 	    IF (.NOT.TEXT_READ(UNIT,BUFFER(UNIT),LEN)) GO TO 100    	    LEN = MIN(255,LEN)/  0 	    IF (BLEN(UNIT).EQ.-2) THEN			! For V4.0 DSR   		BLEN(UNIT) = -1a 		LEN = LEN + 1h3 		BUFFER(UNIT)(1:LEN) = CR // BUFFER(UNIT)(1:LEN-1)n  
 	    ENDIF   	ELSER   	    LEN = BLEN(UNIT)    	    BLEN(UNIT) = -1   	ENDIF  
 	GET_LINE = 1e  > 	IF (CC_TYPE(UNIT).EQ.2) THEN		! Pre-process DSR and RNO lines  - 	    IF (LEN.EQ.1) THEN				! Handle RNO <FF>se( 	      IF (BUFFER(UNIT)(1:1).EQ.FF) THEN9 		IF (.NOT.TEXT_READ(UNIT,BUFFER(UNIT)(2:),LEN)) GO TO 90r 		LEN = MIN(LEN,254) + 1 	      ENDIF
 	    ENDIF" 						! Remove <CR><LF> if present 	    IF (LEN.GE.2) THENY0 	      IF (BUFFER(UNIT)(LEN-1:LEN).EQ.CRLF) THEN7 		THIS_LINE_CRLF = .TRUE.		! We do not handle the case:( 		LEN = LEN - 2			!   REC1 	      ENDIF				!   REC2. 	    ENDIF				! Which is supposed to come out: 						!   REC1REC2 	ENDIF   	IF (LEN.EQ.0) THENh   	    STRING(1:1) = ' ' 	    LENGTH = 1h 	    RETURNf  B 	ELSE IF (CC_TYPE(UNIT).EQ.0) THEN	  ! Copy Fortran files verbatim  ( 	    STRING(1:LEN) = BUFFER(UNIT)(1:LEN) 	    LENGTH = LEN  	    RETURNe  > 	ELSE IF (CC_TYPE(UNIT).EQ.3) THEN	  ! Process VFC/PRINT Files  * 	    STRING(2:LEN+1) = BUFFER(UNIT)(1:LEN)- 	    LENGTH = LEN + 1				! We handle only the 1 	    VFC = TEXT_VFC(UNIT)			!  cases which trans-n5 	    IF (VFC.EQ.'8D02'x) THEN			!  late to Fortran 0,u* 		STRING(1:1) = '0'			!  1,+,$,null,blank.! 		RETURN					!  If blank, we pro- 7 	    ELSE IF (VFC.EQ.'8D8C'x) THEN		!  cess the line ase( 		STRING(1:1) = '1'			!  if it were LIST 		RETURN" 	    ELSE IF (VFC.EQ.'8D00'x) THEN 		STRING(1:1) = '+'r 		RETURN" 	    ELSE IF (VFC.EQ.'0001'x) THEN 		STRING(1:1) = '$'n 		RETURN" 	    ELSE IF (VFC.EQ.'0000'x) THEN 		STRING(1:1) = CHAR(0)  		RETURN% 	    ENDIF					! All other cases falln 							!  through to LISTs 	ENDIF  " 	IF (BUFFER(UNIT)(1:1).EQ.FF) THEN   	    STRING(1:1) = '1' 	    COL = 2  ' 	ELSE IF (BUFFER(UNIT)(1:1).EQ.CR) THENr  A 	    STRING(1:1) = '+'	! NSWC local convention for LASER -- CR at 7 	    COL = 2		!  beginning of LIST line means overprintc  * 	    IF (LAST_LINE_CRLF) STRING(1:1) = ' '  3 	    IF (LEN.GE.2.AND.BUFFER(UNIT)(2:2).EQ.LF) THEN  		STRING(1:1) = '0'E	 		COL = 3t
 	    ENDIF  ' 	ELSE IF (BUFFER(UNIT)(1:1).EQ.LF) THENo   	    STRING(1:1) = '0' 	    COL = 2  ( 	ELSE IF (BUFFER(UNIT)(1:1).EQ.'') THEN   	    STRING(1:1) = '' 	    COL = 2   	ELSE    	    STRING(1:1) = ' ' 	    COL = 1   	ENDIF  ' ! Check for embedded control characters,  2 	COL2 = SUBINDEX( BUFFER(UNIT)(1:LEN) , COL , CR )   	IF (COL2.NE.0) THEN  C 	    IF (THIS_LINE_CRLF) LEN = LEN + 2	! Restore CRLF for next callm 	    THIS_LINE_CRLF = .FALSE.   @ 	    IF (COL2.EQ.LEN) THEN	! <CR> at end is no-op for LIST files; 	   	LEN = LEN - 1		! But V4.0 DSR uses it for overprintinge) 		IF (CC_TYPE(UNIT).EQ.2) BLEN(UNIT) = -2r
 		GO TO 80
 	    ENDIF   	    LENGTH = COL2-1 - COL + 20 	    STRING(2:LENGTH) = BUFFER(UNIT)(COL:COL2-1)  ; 	    IF (BUFFER(UNIT)(COL2:COL2+1).EQ.CRLF) COL2 = COL2 + 2l    	    BLEN(UNIT) = LEN - COL2 + 1  8 	    BUFFER(UNIT)(1:BLEN(UNIT)) = BUFFER(UNIT)(COL2:LEN)   	    RETURN    	ENDIF   80	LENGTH = LEN - COL + 2o) 	STRING(2:LENGTH) = BUFFER(UNIT)(COL:LEN)w 	    s 	RETURNd  < 90	STRING(1:1) = '1'	! <FF> is last character in a RNO file. 	LENGTH = 1e 	BLEN(UNIT) = -3 	RETURNE   100	CC_TYPE(UNIT) = -1 	BLEN(UNIT) = -1  
 	GET_LINE = 0	 	RETURNe       	ENTRY GET_LINE_RESET(UNIT)T   **# *	SUBROUTINE GET_LINE_RESET( unit )S *P * D *	Function GET_LINE will in some instances read ahead and store someD *	upcoming lines in a buffer.  This can cause a problem if the call-D *	ing program does not sequentially read the file all the way to itsD *	end-of-file.  For example, if the file is read up to its fifteenthD *	record,  then rewound, then the next GET_LINE call may return rec-* *	ord sixteen instead of the first record. * D *	Calling routine GET_LINE_RESET fixes the problem by discarding theD *	contents of the buffer.  In the above example, this should be done *	when the file is rewound.V *i *	.INDEX DISK I/O>>E *E1 *	Alan L. Zirkle     Naval Surface Warfare Center_ *			   Code K55 * *	21 Oct 1992	   Dahlgren, Virginia  22448 *a   	BLEN(UNIT) = -1  
 	END									a _! 	SUBROUTINE PUT_LINE(UNIT,STRING)l   **& *	SUBROUTINE PUT_LINE( unit , string ) *A *oD *	Writes file whose unit number is the argument  UNIT;  one  line isD *	processed  per  call.   The  calling  program must have previouslyD *	opened the file using routine TEXT_OPEN_OUTPUT.  Only unit numbersD *	12 or 13 can be used. These two units can be processed concurrent- *	ly is desired. *bD *	The line to be written is passed in character string STRING.  ThisD *	line must be constructed with  Fortran carriage control  (i.e. theD *	first character  should either be a blank,  a plus sign, a zero, a* *	one, or a nine [NSWC local page eject]). *rD *	If the file does not have Fortran  Carriage  Control,  the  actualD *	line written is reformatted so that the output record has the pro-D *	per structure for the file's type  of Carriage Control.   In doingD *	this reformatting, it may be necessary for PUT_LINE to combine twoD *	or more input strings into one output record.   Output records are0 *	limited to a maximum length of 256 characters. *aD *	It is important to note that subroutine PUT_LINE_END must be call-D *	ed after  final call to PUT_LINE,  to cause the  last record to beD *	written to the file.   This is not necessary if the file  has For- *	tran Carriage Control. *g *R> *	10 Oct 85	Use -1 instead of 0 for default BLEN value so that, *			zero-length lines are handled correctly.8 *	 7 Sep 89	Use TEXT_IO routines instead of Fortran I/O. *s *	.INDEX DISK I/O>>a *d1 *	Alan L. Zirkle     Naval Surface Warfare Centere *			   Code K53c) *	4 Jan 1985	   Dahlgren, Virginia  22448e *I   	IMPLICIT NONE  
 	BYTE UNIT 	CHARACTER*(*) STRINGf 	  	CHARACTER*256 BUFFER(12:13) 	INTEGER*2 BLEN(12:13) 	LOGICAL*1 INIT(12:13) 	BYTE CCTYPE(12:13)t 	INTEGER*4 L1,TEXT_CC_TYPE   	CHARACTER*1 CC,CR,LF,FF   	PARAMETER ( CR = CHAR(13) ) 	PARAMETER ( LF = CHAR(10) ) 	PARAMETER ( FF = CHAR(12) )  $ 	DATA BLEN,INIT / 2*-1 , 2*.FALSE. /   	IF (.NOT.INIT(UNIT)) THEN 	    INIT(UNIT) = .TRUE.& 	    CCTYPE(UNIT) = TEXT_CC_TYPE(UNIT) 	ENDIF  D 	IF (CCTYPE(UNIT).EQ.0) THEN	! Fortran is easy case; just copy line.  ! 	    CALL TEXT_WRITE(UNIT,STRING)t 	    RETURN   : 	ELSE IF (CCTYPE(UNIT).EQ.1 .AND. STRING(1:1).EQ.'+') THEN  A 	    L1 = MAX(BLEN(UNIT),0)	   ! For overprint on LIST files, thei8 	    IF (L1.GE.256) RETURN	   !  lines must be appended.  / 	    BLEN(UNIT) = MIN( 256 , L1 + LEN(STRING) )V5 	    BUFFER(UNIT)(L1+1:BLEN(UNIT)) = CR // STRING(2:)  	    RETURNv  E 	ELSE IF (BLEN(UNIT).GE.0) THEN	   ! Previous line can now be writtenF  8 	    IF (CCTYPE(UNIT).EQ.1 .OR. STRING(1:1).EQ.'+') THEN2 		CALL TEXT_WRITE(UNIT,BUFFER(UNIT)(1:BLEN(UNIT)))	 	    ELSE : 		CALL TEXT_WRITE(UNIT,BUFFER(UNIT)(1:BLEN(UNIT))//CR//LF)
 	    ENDIF, 					! Note that for NONE files, we appended0 	ENDIF				! CR/LF Unless THIS line is overprint.  ; 	IF (STRING(1:1).EQ.' ') THEN		! Normal, single-spaced linel. 10	    BLEN(UNIT) = MIN( 256 , LEN(STRING)-1 ), 	    BUFFER(UNIT)(1:BLEN(UNIT)) = STRING(2:) 	    RETURNh/ 	ELSE IF (STRING(1:1).EQ.'1') THEN	! Page ejecte 	    CC = FF; 	ELSE IF (STRING(1:1).EQ.'9') THEN	! Page eject, NSWC local; 	    CC = FF7 	ELSE IF (STRING(1:1).EQ.'0') THEN	! Double spaced line  	    CC = LFC 	ELSE IF (STRING(1:1).EQ.'+') THEN	! Overprinted (file must be NONE , 	    CC = CR				!  since we did other cases)" 	ELSE IF (STRING(1:1).EQ.'') THEN
 	    CC = ''r 	ELSEa3 	    GO TO 10		! '$' or 'nul', etc. are not handled  	ENDIF  " 	BLEN(UNIT) = MIN(256,LEN(STRING)). 	BUFFER(UNIT)(1:BLEN(UNIT)) = CC // STRING(2:) 	RETURN          	ENTRY PUT_LINE_END(UNIT)N   **! *	SUBROUTINE PUT_LINE_END( unit )  *  * D *	Writes any buffered lines  (stored by subroutine PUT_LINE)  to the7 *	file  whose unit number is the integer argument UNIT.W *iD *	This routine is used with subroutine PUT_LINE; see its description *	for further information. *M *P: *	 7 Sep 1989	Use TEXT_IO routines instead of Fortran I/O. *u *	.INDEX DISK I/O>>	 *d1 *	Alan L. Zirkle     Naval Surface Warfare Centero *			   Code K53 ) *	4 Jan 1985	   Dahlgren, Virginia  22448  *s     	IF (BLEN(UNIT).GE.0) THEN  5 	    CALL TEXT_WRITE(UNIT,BUFFER(UNIT)(1:BLEN(UNIT)))d   	    BLEN(UNIT) = -1   	ENDIF   	INIT(UNIT) = .FALSE.1  
 	END									l  6 	LOGICAL FUNCTION CHECK_ACCESS(USERNAME,FILENAME,MODE)   **= *	LOGICAL FUNCTION CHECK_ACCESS( username , filename , mode )i *R *cD *	Checks to see if user USERNAME can legally access file FILENAME inD *	the given MODE.   The user and the file must exist.  The MODE mustD *	be a string composed of one or more of the characters  R, W, E, D,D *	or C (in either upper- or lowercase), which stand for Read, Write,D *	Execute, Delete, and Control.   All of the arguments are character
 *	strings. *SD *	The function result is .TRUE. if the access is legal.  If the res-D *	ult is  .FALSE.  it contains a VMS status code which describes whyD *	the access is illegal.  This will be either  SS$_NOPRIV  or an RMSD *	error code caused by the file not existing.   SS$_NOPRIV will also) *	be returned if the username is invalid.  *R *	.INDEX ENVIRONMENT>> *	.INDEX FILE PROTECTION>> * 1 *	Alan L. Zirkle     Naval Surface Warfare CenterI *			   Code K531* *	16 Nov 1987	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE  % 	CHARACTER*(*) USERNAME,FILENAME,MODE!   	INCLUDE '($ACLDEF)' 	INCLUDE '($ARMDEF)' 	INCLUDE '($CHPDEF)' 	INCLUDE '($RMSDEF)' 	INCLUDE '($SSDEF)'   2 	INTEGER*4 ITMLST(4),MODE_,STATUS,SYS$CHECK_ACCESS
 	LOGICAL M 	CHARACTER*1 C   	M(C) = INDEX(MODE,C) .GT. 0  
 	MODE_ = 0  4 	IF (M('R').OR.M('r')) MODE_ = IOR(MODE_,ARM$M_READ)5 	IF (M('W').OR.M('w')) MODE_ = IOR(MODE_,ARM$M_WRITE) 7 	IF (M('E').OR.M('e')) MODE_ = IOR(MODE_,ARM$M_EXECUTE)L6 	IF (M('D').OR.M('d')) MODE_ = IOR(MODE_,ARM$M_DELETE)7 	IF (M('C').OR.M('c')) MODE_ = IOR(MODE_,ARM$M_CONTROL)(  ) 	CALL ITEM_LIST(ITMLST,CHP$_ACCESS,MODE_)d  ? 	STATUS = SYS$CHECK_ACCESS(ACL$C_FILE,FILENAME,USERNAME,ITMLST)    	CHECK_ACCESS = STATUS  > *	Abort if we get an error status code which is neither NOPRIVA *	nor any RMS-related status code.  Checking protection of a file)@ *	containing a node name gets SS$_IVLOGNAM; this is unfortunate.   	IF (.NOT.CHECK_ACCESS) THEN% 	    IF (STATUS.EQ.SS$_NOPRIV) RETURN.' 	    IF (STATUS.EQ.SS$_IVLOGNAM) RETURN > 	    IF (IAND(STATUS,'0FFF0000'x)/'10000'x .EQ. RMS$_FACILITY) 	1							  RETURNF  	    CALL LIB$STOP(%VAL(STATUS)) 	ENDIF   	END  	LOGICAL FUNCTION FILE_PROT(FAB)   **0 *	LOGICAL FUNCTION FILE_PROT ( funct , protstr ) *  *pD *	Allows creation of a file (using FORTRAN OPEN) with explicit spec-D *	ification  of the file's protection.   The following steps must be *	performed: *	D *	  1. Call FILE_PROT with  FUNCT  being 0 or 1, and PROTSTR being aD *	     character string specifying a file protection expression (forD *	     example 'S:RE,O:REWD,G,W').  Blanks or lower-case letters areD *	     not allowed in the expression.  If the expression omits clas-D *	     ses of users (for example 'S:R,O:RE,G' omits WORLD), then theD *	     omitted classes are given NO access if FUNCT=0,  or are givenD *	     the access of the process default protection if FUNCT=1.   IfD *	     the function value of FILE_PROT is .FALSE., the expression is *	     not syntactally correct.t *oD *	  2. Open files using  FORTRAN  OPEN statements.   The OPEN state-' *	     ments must include the keywords:. *') *			USEROPEN=FILE_PROT  and  STATUS='NEW'G *1D *	     The name FILE_PROT must be declared EXTERNAL  in all subprog- *	     rams doing these OPENs. *ND *	OPENs which do not use the USEROPEN keyword, and non-FORTRAN opensD *	are not affected; they continue to use the process default protec- *	tion.D *	 *	.INDEX DISK I/O>>f *	.INDEX FILE PROTECTION>> *s1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53'* *	10 Jul 1987	   Dahlgren, Virginia  22448 *.  D *	Note that when FILE_PROT is called as the USEROPEN procedure,  its< *	arguments are defined differently than as described above.  @ *	Our use of ARG_ADDRESS in this routine is required because ourC *	second argument is a character string when the user calls us, but B *	is a RAB when FORTRAN calls us in OPEN processing.  Note that weD *	don't even declare the second argument on the FUNCTION line.  FOR-D *	TRAN does funny things then you pass a character string as an arg-D *	ument when the routine expects something else.  This is one way toC *	get around it; other ways are to code in MACRO, or have two separI# *	ate routines for these two cases.I   	IMPLICIT NONE   	INCLUDE '($FABDEF)' 	INCLUDE '($XABDEF)' 	INCLUDE '($XABPRODEF)'    	RECORD /FABDEF/ FAB   	STRUCTURE /XABPRO/  	  UNION 	    MAP 	      RECORD /XABPRODEF1/ PRO 	    END MAP 	    MAP 	      RECORD /XABDEF/ XAB 	    END MAP 	  END UNION 	END STRUCTURE   	RECORD /XABPRO/ XABPRO+  : 	INTEGER*4 ARG_ADDRESS,ARG_LONGWORD,SYS$CREATE,SYS$CONNECT 	INTEGER*4 IARGPTR 	INTEGER*2 PROTS" 	LOGICAL ARG_EXIST,FILE_PROT_PARSE  : 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) THEN		! Create the file  % 	    XABPRO.XAB.XAB$B_COD = XAB$C_PRO ( 	    XABPRO.XAB.XAB$B_BLN = XAB$C_PROLEN) 	    XABPRO.XAB.XAB$L_NXT = FAB.FAB$L_XABT! 	    XABPRO.PRO.XAB$W_PRO = PROTS   ! 	    FAB.FAB$L_XAB = %LOC(XABPRO)N    	    FILE_PROT = SYS$CREATE(FAB)  Q 	    IF (FILE_PROT) FILE_PROT = SYS$CONNECT(%VAL(ARG_ADDRESS(%VAL(IARGPTR()),2)))Y  " 	ELSE						! Parse the protections  5 	    IF (ARG_LONGWORD(%VAL(IARGPTR()),1,0).EQ.0) THEN 3 		PROTS = 'FFFF'X			! Unspecified means 'No Access'p	 	    ELSEs= 		CALL SYS$SETDFPROT(,PROTS)	! Unspecified means 'Use Processg. 	    ENDIF				!                       Defaults  L 	    FILE_PROT = FILE_PROT_PARSE(%VAL(ARG_ADDRESS(%VAL(IARGPTR()),2)),PROTS)   	ENDIF   	END0 	LOGICAL FUNCTION FILE_PROT_PARSE(PROTSTR,PROTS)   **5 *	LOGICAL FUNCTION FILE_PROT_PARSE( protstr , prots )  *t * C *	Parses a character string (the PROTSTR argument) which contains a C *	VMS file protection expression  (such as 'S:RE,O:REWD,G:E,W') andsC *	builds from this a binary file protection field,  as used by RMS.SC *	The resultant field is returned as the  INTEGER*2 argument PROTS.VC *	Before calling FILE_PROT_PARSE,  the caller must initialize PROTSTC *	to a default value;  if the protection expression omits any classgC *	(such as GROUP or WORLD), then the default initialized into PROTSn& *	is used (one-bits mean 'no access'). *cC *	Bits 0-3 of PROTS  control SYSTEM access,  bits 4-7 control OWNER C *	access,  bits 8-11 control GROUP access,  and bits 12-15  controlwC *	WORLD access.  Within each four-bit subfield, bit 0 controls READeC *	access, bit 1 controls WRITE access,  bit 2 controls EXECUTE acc-s( *	ess, and bit 3 controls DELETE access. *oC *	The protection expression must not contain any blanks and must begC *	upper case.   A .TRUE. function result from FILE_PROT_PARSE meanseC *	that the expression was syntactically correct;  PROTS must not bew' *	used if a .FALSE. result is returned.r *r *	.INDEX DISK I/O>>  *	.INDEX FILE PROTECTION>> *o1 *	Alan L. Zirkle     Naval Surface Warfare Center, *			   Code K53a* *	10 Jul 1987	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE  < 	CHARACTER*(*) PROTSTR	! 'S:REWD,O:RWE,G:RE,W' (for example)= 	INTEGER*2 PROTS		! On input, process default protection maskt   	INTEGER*2 PLEN,COL,CCOL,SHIFT 	CHARACTER*4 SOGW,RWED 	CHARACTER*1 ICHR   4 	FILE_PROT_PARSE = .TRUE.	! Assume successful result 	SOGW = 'SOGW' 	PLEN = LEN(PROTSTR) 	COL = 0  E 10	IF (COL.EQ.PLEN) GO TO 100	! Error--empty string or dangling commav 	COL = COL + 1 	ICHR = PROTSTR(COL:COL) 	CCOL = INDEX(SOGW,ICHR): 	IF (CCOL.EQ.0) GO TO 100	! Error--class not S, O, G, or W: 	SOGW(CCOL:CCOL) = CHAR(0)	! Prevent duplicate class specs 	SHIFT = 4 * (CCOL - 1)5E 	PROTS = IOR( PROTS, ISHFT( 'F'X , SHIFT ) )	! Init this class to 'No  							!  Access'T 	IF (COL.EQ.PLEN) RETURN	T 	COL = COL + 1 	ICHR = PROTSTR(COL:COL) 	IF (ICHR.EQ.',') GO TO 10 	IF (ICHR.NE.':') GO TO 100R 	RWED = 'RWED'  7 20	IF (COL.EQ.PLEN) RETURN		! (dangling colons ignored)) 	COL = COL + 1 	ICHR = PROTSTR(COL:COL)6 	IF (ICHR.EQ.',') GO TO 10	! (dangling colons ignored) 	CCOL = INDEX(RWED,ICHR) 	IF (CCOL.EQ.0) GO TO 100  	RWED(CCOL:CCOL) = CHAR(0)* 	PROTS = IBCLR( PROTS , SHIFT + CCOL - 1 )	 	GO TO 20H   100	FILE_PROT_PARSE = .FALSE.o   	END( 	LOGICAL FUNCTION MOUNTED_DISK(FILENAME)   **+ *	LOGICAL FUNCTION MOUNTED_DISK( filename )I *1 *.D *	Given a file name  (or part of one)  in the character string  arg-D *	ument FILENAME, this function checks to see if the file resides onD *	a valid, mounted, disk device.   If the file name does not includeD *	an explicit device name,  the current default disk is assumed  (asD *	per usual conventions).  Note that the current default disk is not+ *	necessarily a valid, mounted disk device.N *	D *	The need for this routine  came about  when somebody used the fileD *	name  "OPA:[dir]fil.typ", where OPA is the logical name  of a diskD *	which happened to not be currently mounted.   RMS assumed that the5 *	file was on device OPA0, with strange consequences.N *a *s+ *	 27 May 87	Check for status SS$_IVDEVNAM.2 *, *	.INDEX DISK I/O>>  *F1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K531* *	20 Mar 1986	   Dahlgren, Virginia  22448 *E   	IMPLICIT INTEGER (A-Z)   * 	PARAMETER ( SS$_IVDEVNAM  =      '144'X )* 	PARAMETER ( SS$_NOSUCHDEV =      '908'X )* 	PARAMETER ( DVI$_DEVCHAR  =        '2'X )* 	PARAMETER ( DEV$M_MNT     =    '80000'X )* 	PARAMETER ( DEV$M_RND     = '10000000'X )* 	PARAMETER ( DEV$M_DIR     =        '8'X )   	CHARACTER*(*) FILENAME  	INTEGER*4 IOSB(2),ITMLST(4)   	INTEGER*4 FNB,FN_LENE 	CHARACTER*256 FULLNAME( 	INTEGER*2 FIELDS(6,2)  4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	MOUNTED_DISK = .FALSE.T  $ 	STATUS = FILE_NAME_INFO(FILENAME,3)  4 	IF (.NOT.STATUS) RETURN			    ! Bad syntax on name?  , 	CALL ITEM_LIST(ITMLST,DVI$_DEVCHAR,DEVCHAR)  : 	STATUS = SYS$GETDVIW(,,FULLNAME(FIELDS(2,1):FIELDS(2,2)), 	1						 ITMLST,IOSB,,,)   	IF (.NOT.STATUS) THEN> 	    IF (STATUS.EQ.SS$_IVDEVNAM)  RETURN	    ! No such device?> 	    IF (STATUS.EQ.SS$_NOSUCHDEV) RETURN	    ! No such device?  	    CALL LIB$STOP(%VAL(STATUS)) 	ENDIF  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))i  ; 	IF (IAND(DEVCHAR,DEV$M_MNT).EQ.0) RETURN    ! Not mounted? A 	IF (IAND(DEVCHAR,DEV$M_RND).EQ.0) RETURN    ! Not random access?1H 	IF (IAND(DEVCHAR,DEV$M_DIR).EQ.0) RETURN    ! Not directory structured?   	MOUNTED_DISK = .TRUE.   	END: 	SUBROUTINE GET_A_FILE_NAME(PARAM_NAME,FILE_NAME,NAME_LEN, 	1						DEFAULT_NAME,*,*)	   **7 *	SUBROUTINE GET_A_FILE_NAME ( param_name , file_name ,  * ) *+					 name_len , default_name , * , * )u *e *tD *	Processes a DCL parameter value which is a file name or a list  ofD *	file  names  (separated  by commas).  The name(s) may contain wildD *	card characters.  Each time this subroutine is called,  it returnsD *	the  actual  name  of  one file which matches the parameter value.? *	When no more matches are found, an alternate return is taken.a *SD *	Another alternate return is taken if no file is found to match theD *	value.  If the value is a list, this return is taken each time  noD *	file is found which matches the current list element being examin-D *	ed; subsequent calls to GET_A_FILE_NAME will check succeeding listD *	elements.   (Thus  when this  second alternate return is taken,  aD *	diagnostic message may be printed if desired,  but then  the callsD *	to  this  subroutine should be continued until the first alternate *	return is taken. *$D *	Common /GET_FILE_NAME/ contains the current  parameter  list  item6 *	being examined.  The format of this common block is: *R *		INTEGER*4 PARAM_LEN *		CHARACTER*255 PARAM_VALUE * / *		COMMON /GET_FILE_NAME/ PARAM_LEN,PARAM_VALUE  *	.INDEX FILE NAMES>>M *_0 *	The required arguments to GET_A_FILE_NAME are: *DD *	    PARAM_NAME  ----  Name of the DCL parameter  to  be  examined.6 *			      See  Chapter 5  of the VAX-11 Utilities Ref-6 *			      erence manual.  This is a  character  string# *			      input to GET_A_FILE_NAME.S *LD *	    FILE_NAME  -----  Actual name of one file  which  matches  the6 *			      parameter value.  This is a character string& *			      output from GET_A_FILE_NAME. *iD *	    NAME_LEN  ------  Length of non-blank part of FILE_NAME.  This4 *			      is an integer output from GET_A_FILE_NAME. * D *	    DEFAULT_NAME  --  Blank, or a default name to be used  in  de-6 *			      termining FILE_NAME when the parameter value6 *			      is an incomplete file specification. This is6 *			      a character string input to GET_A_FILE_NAME. *AD *	    * (RETURN 1)  --  Statement label in the calling routine which6 *			      is returned to (instead of the statement im-6 *			      mediately  following  the  call  to  routine6 *			      GET_A_FILE_NAME)  when  no  more files exist* *			      which match the parameter value. *-D *	    * (RETURN 2)  --  Statement label in the calling routine which6 *			      is returned to when no file is  found  which6 *			      matches  one  element of the parameter value6 *			      list (or the entire value if  it  is  not  a6 *			      list).   The calling routine may print a di-6 *			      agnostic message if desired, but should con-( *			      tinue calling GET_A_FILE_NAME. *f *t1 *	Alan L. Zirkle     Naval Surface Warfare Centera *			   Code K53i* *	11 May 1983	   Dahlgren, Virginia  22448 *t   	IMPLICIT INTEGER (A-Z)O  0 	CHARACTER*(*) PARAM_NAME,FILE_NAME,DEFAULT_NAME+ 	CHARACTER PARAM_VALUE*255,RELATED_NAME*255r 	LOGICAL WITHIN,FOUNDONE  - 	COMMON /GET_FILE_NAME/ PARAM_LEN,PARAM_VALUEI  + 	DATA WITHIN,RELATED_NAME / .FALSE. , ' ' /o   10	IF (.NOT.WITHIN) THEN  ; 	    STATUS=CLI$GET_VALUE(PARAM_NAME,PARAM_VALUE,PARAM_LEN)n   	    IF (.NOT.STATUS) THEN   		RELATED_NAME = ' '  
 		RETURN 1  
 	    ENDIF   	    WITHIN   = .TRUE. 	    FOUNDONE = .FALSE.F   	    CONTEXT=0   	ENDIF  4 	STATUS=LIB$FIND_FILE(PARAM_VALUE,FILE_NAME,CONTEXT,! 	1					DEFAULT_NAME,RELATED_NAME)V   	IF (.NOT.STATUS) THEN   	    WITHIN=.FALSE.i    	    IF (.NOT.FOUNDONE) RETURN 2  
 	    GO TO 10    	ENDIF  / 	CALL STR$TRIM(RELATED_NAME,FILE_NAME,NAME_LEN)    	FOUNDONE = .TRUE.   	END0 	INTEGER FUNCTION FILE_NAME_INFO(FILENAME,FLAGS)   **9 *	INTEGER FUNCTION FILE_NAME_INFO( filename [ , flags ] )T *  *lD *	Obtains various items of information about a file name.  The inputD *	string  FILENAME  contains the name to be interrogated.  WildcardsD *	may be present, and parts  (even all)  of the name may be omitted.D *	The file  does not have to exist  (but any device,  directory,  orD *	node name specified  must exist, or you will  get an error status,0 *	unless you use the FLAGS argument--see below). *CD *	The function result is the status returned by the RMS $PARSE oper-D *	ation.   The possible values are documented  under the descriptionD *	of the $PARSE service in the VAX RMS Reference Manual. An error isD *	most likely to be a syntax error in a part of the name, or a node,( *	device, or directory which is unknown. *E *	.INDEX FILE NAMES>>  *TD *	The information about FILENAME is returned  in variables in common< *	block /FILE_NAME_INFO_/.  The definition of this block is: *_ *		INTEGER*4 FNB,FN_LENB *		CHARACTER*256 FULLNAMER *		INTEGER*2 FIELDS(6,2) *X6 *		COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS *  *	The information is:( *PD *	  FNB -- a longword bit string giving status information about the= *		 file name.   The definitions of the bits are found in theS= *		 VAX  RMS  Reference Manual,  in the discussion of the FNBR= *		 field of the NAM block (section 6.13).  To get these def-n8 *		 initions in your Fortran program, use the statement: *s *				INCLUDE '($NAMDEF)' * = *		 An example of one of the bits is NAM$M_WILDCARD, which isT5 *		 set if FILENAME contains any wildcard characters., *TD *	  FULLNAME(1:FN_LEN) -- The  resultant file name  derived from the/ *				input file name,  after application of de-t- *				faults and translation of logical names.n *tD *	  FIELDS -- An INTEGER*2 6-by-2 array,  giving the character posi-= *		    tions, in FULLNAME, of each of the file name's compon-n= *		    ents.   FIELDS(n,1) has the start column,  FIELDS(n,2)i5 *		    the end column, of the n-th field, as follows:e *		    *			1 node		4 file namee/ *			2 device	5 file type ("." if no type given)l/ *			3 directory	6 version   (";" if none given)g *-= *		    For fields  which are not present  (this could only beT= *		    the node or file name),  FIELDS(n,2) will be  equal toR= *		    FIELDS(n,1) minus one, indicating  a null string (For- ( *		    tran accepts this without error). *- * D *	If the optional FLAGS argument is provided, it can be used to mod-D *	ify the action of FILE_NAME_INFO.   Each bit in FLAGS controls oneD *	function, and can be set in combination as desired.  The bits, and *	their functions, are:n *nD *	  Bit 0 -- Do not conceal concealed logical names in the resultant *		   file name. *nD *	  Bit 1 -- Do not check to see  if any node,  device, or directory, *		   names used in FILENAME actually exist. *  *I@ *	17 Apr 1992	Do not attempt  to set fields when a bad directory6 *			name has been passed;  can be caused  by using SET& *			DEFAULT with a search list, as in:( *				$ DEFINE TEST DISK:[A.B],DISK:[A.C] *				$ SET DEFAULT TESTR( *			then calling this routine with '[]'. *p * 0 *	Alan L. Zirkle	   Naval Surface Warfare Center *			   Code K53 * *	19 Jan 1986	   Dahlgren, Virginia  22448 *F   	IMPLICIT INTEGER (A-Z)s   	CHARACTER*(*) FILENAMEG   	INTEGER*4 FNB,FN_LENR 	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)  4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INCLUDE '($FABDEF)' 	INCLUDE '($NAMDEF)'   	RECORD /FABDEF/ FAB 	RECORD /NAMDEF/ NAM   	INTEGER*4 IARGPTR 	LOGICAL ARG_EXIST   	FLAGS_ = 0t1 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) FLAGS_ = FLAGSP   	FAB.FAB$B_BID = FAB$C_BID 	FAB.FAB$B_BLN = FAB$C_BLN   	FAB.FAB$L_FNA = %LOC(FILENAME) % 	FAB.FAB$B_FNS = LBYTE(LEN(FILENAME))    	FAB.FAB$L_NAM = %LOC(NAM)   	NAM.NAM$B_BID = NAM$C_BID 	NAM.NAM$B_BLN = NAM$C_BLN   	NAM.NAM$L_ESA = %LOC(FULLNAME)E. 	NAM.NAM$B_ESS = LBYTE(MIN(LEN(FULLNAME),255))   	NAM.NAM$B_NOP = 09 	IF (IAND(FLAGS_,1).NE.0) NAM.NAM$B_NOP = NAM$M_NOCONCEALe9 	IF (IAND(FLAGS_,2).NE.0) NAM.NAM$B_NOP = NAM.NAM$B_NOP +R 	1						    NAM$M_SYNCHK    	FILE_NAME_INFO = SYS$PARSE(FAB)   	FN_LEN = ZEXT(NAM.NAM$B_ESL)O   	FNB = NAM.NAM$L_FNB  1 	IF (NAM.NAM$L_NODE.EQ.0) RETURN			! AZ 17 Apr 92	  1 	FIELDS(1,1) = NAM.NAM$L_NODE - NAM.NAM$L_ESA + 1	5 	FIELDS(1,2) = FIELDS(1,1) + ZEXT(NAM.NAM$B_NODE) - 1t  0 	FIELDS(2,1) = NAM.NAM$L_DEV - NAM.NAM$L_ESA + 14 	FIELDS(2,2) = FIELDS(2,1) + ZEXT(NAM.NAM$B_DEV) - 1  0 	FIELDS(3,1) = NAM.NAM$L_DIR - NAM.NAM$L_ESA + 14 	FIELDS(3,2) = FIELDS(3,1) + ZEXT(NAM.NAM$B_DIR) - 1  1 	FIELDS(4,1) = NAM.NAM$L_NAME - NAM.NAM$L_ESA + 1r5 	FIELDS(4,2) = FIELDS(4,1) + ZEXT(NAM.NAM$B_NAME) - 1d  1 	FIELDS(5,1) = NAM.NAM$L_TYPE - NAM.NAM$L_ESA + 1 5 	FIELDS(5,2) = FIELDS(5,1) + ZEXT(NAM.NAM$B_TYPE) - 1i  0 	FIELDS(6,1) = NAM.NAM$L_VER - NAM.NAM$L_ESA + 14 	FIELDS(6,2) = FIELDS(6,1) + ZEXT(NAM.NAM$B_VER) - 1   	END 	SUBROUTINE FILE_ERROR(UNIT)   **! *	SUBROUTINE FILE_ERROR( [unit] )	 *  * D *	Displays one or more  error messages associated with the last For-D *	tran I/O statement executed.   This routine should be called after9 *	taking an ERR= branch from an I/O statement.  Examples:E *  *		OPEN (1 , ... , ERR=100)D	 *		 . . .  *	    100 CALL FILE_ERROR$ *S *D *		WRITE (1, ... , ERR=200) ...D	 *		 . . .  *	    200 CALL FILE_ERROR(8) *VD *	If the optional argument  UNIT  is omitted, the error messages areD *	written to the file SYS$OUTPUT; it may also write  the messages toD *	the file  SYS$ERROR  if  SYS$ERROR is assigned to a different fileD *	than SYS$OUTPUT (they normally are the same file) and the error is *	severe enough. *LD *	If the optional argument UNIT is specified, it is the Fortran unitD *	number to which the messages  are to be written.  The messages areD *	then written to this file instead of  SYS$OUTPUT.   NOTE THAT THISD *	UNIT NUMBER IS WHERE THE MESSAGES ARE TO BE WRITTEN; IT IS NOT THE3 *	UNIT NUMBER OF THE FILE WHERE THE ERROR OCCURRED.  *ND *	In either of the above cases,  a blank line is written to the file< *	before the first line of messages and after the last line. *O *	.INDEX DISK I/O>>% *(1 *	Alan L. Zirkle     Naval Surface Warfare CenterT *			   Code K53t* *	21 Feb 1985	   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)I    	INTEGER*4 MSGVEC(4) / 3,0,0,0 /   	INTEGER*4 IARGPTR 	LOGICAL ARG_EXIST   	EXTERNAL FILE_ERROR_1  # 	CALL ERRSNS(,MSGVEC(2),MSGVEC(4),)E  ' 	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN*   	    WRITE (UNIT,1000)  / 	    CALL SYS$PUTMSG(MSGVEC,FILE_ERROR_1,,UNIT)	   	    WRITE (UNIT,1000)   	ELSE    	    PRINT 1000s   	    CALL SYS$PUTMSG(MSGVEC,,,)a   	    PRINT 1000t   	ENDIF   1000	FORMAT (' ')    	END, 	LOGICAL FUNCTION FILE_ERROR_1(MESSAGE,UNIT)   **1 *	LOGICAL FUNCTION FILE_ERROR_1( message , unit )s *	 * D *	This routine is used by subroutine FILE_ERROR and is not called by *	user code. *aD *	FILE_ERROR_1 is called by  SYS$PUTMSG  once for each line of errorD *	message.   This routine writes the line to the Fortran unit numberD *	passed as the second argument, and returns a .FALSE. result, whichD *	tells SYS$PUTMSG not to write the line on SYS$OUTPUT or SYS$ERROR. *E *_1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	21 Feb 1985	   Dahlgren, Virginia  22448 *t   	IMPLICIT INTEGER (A-Z)f   	CHARACTER*(*) MESSAGE   	WRITE (UNIT,1000) MESSAGE   	FILE_ERROR_1 = .FALSE.e   1000	FORMAT (1X,A)   	END	a 	LOGICAL FUNCTION FILE_BUSY()M   ** *	LOGICAL FUNCTION FILE_BUSY ()t *t * D *	When this logical function is called after an unsuccessful attemptD *	to do a Fortran OPEN on a file, a determination  is  made  whetherD *	the OPEN failed because another user has the file open.  If so, weD *	wait two seconds and return a .TRUE. result, and the calling prog-: *	ram can retry the OPEN.  Otherwise, .FALSE. is returned. *5 *	Usage: *			LOGICAL FILE_BUSY		 *			. . .n% *		     10	OPEN (1 , . . . , ERR=100)g	 *			. . .  *			<file is open>	 *			. . . $ *		    100 IF (FILE_BUSY()) GO TO 10	 *			. . .w( *			<file is not busy, cannot be opened>	 *			. . .i *  *	.INDEX DISK I/O>>	 * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	14 Nov 1983	   Dahlgren, Virginia  22448 *s *    	IMPLICIT INTEGER (A-Z)I   	CALL ERRSNS(,STATUS,,,)  ! 	FILE_BUSY = STATUS .EQ. '1828A'X    	IF (FILE_BUSY) CALL GO_WAIT(2)n   	END' 	INTEGER FUNCTION DISK_SPACE(PACK_NAME)s   *** *	INTEGER FUNCTION DISK_SPACE( pack_name ) *  *hD *	Determines the number of free blocks remaining on  the  disk  unitD *	whose logical name is PACK_NAME.  The argument must be a characterD *	string  containing the logical name of the pack;  a trailing colon *	is optional. *	D *	The routine will abort the program if an incorrect logical name is+ *	specified, or if the pack is not mounted.R *) *	See also routine FILE_SPACE. *g *	.INDEX DISK I/O>>  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	16 Nov 1983	   Dahlgren, Virginia  22448 *(   	IMPLICIT INTEGER (A-Z)    	CHARACTER*(*) PACK_NAME   	CHARACTER*63 FILE_NAMEp  & 	PARAMETER ( DVI$_FREEBLOCKS = '2A'X )   	INTEGER ITMLST(4)   	FILE_NAME = PACK_NAME  	 	GO TO 10N         	ENTRY FILE_SPACE(UNIT_NUMBER)   **, *	INTEGER FUNCTION FILE_SPACE( unit_number ) *8 * D *	Determines the number of free blocks remaining on the disk unit onD *	which the file, whose FORTRAN unit number is UNIT_NUMBER, resides.D *	The argument must be an integer constant or variable.   FILE_SPACE@ *	must be declared to be of type INTEGER in the calling program. *oD *	The routine will abort the program if an incorrect unit number  is2 *	specified, or if the file is not currently open. *  *	See also routine DISK_SPACE. *  *	.INDEX DISK I/O>>W *I1 *	Alan L. Zirkle     Naval Surface Warfare CenterE *			   Code K53 * *	16 Nov 1983	   Dahlgren, Virginia  22448 *T  % 	INQUIRE (UNIT_NUMBER,NAME=FILE_NAME)   4 10	CALL ITEM_LIST(ITMLST,DVI$_FREEBLOCKS,FREEBLOCKS)  - 	STATUS = SYS$GETDVIW(,,FILE_NAME,ITMLST,,,,)   - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))A   	DISK_SPACE = FREEBLOCKS   	END! 	INTEGER FUNCTION SD_(PARAM,PRIV)O   **' *	INTEGER FUNCTION SD_( param [,priv] )_ *E *FD *	Accepts a parameter string containing one or more  'SD' type oper-D *	ations, and computes the resultant device and directory.   The op-D *	erations in the parameter string must be in upper case and must be> *	separated by one or more blanks.   The legal operations are: *i. *	  ^	 Use directory one subdirectory level up *p: *	  ^^	 Use master directory at or above current directory *s+ *	  .	 Use login default directory and disk  *h? *	  <n	 Use n'th directory in the SD stack (default for n is 1)  *t3 *	  >X	 Use directory [z.X] when currently in [z.y]d *r! *	  .X	 Use directory [current.X]t *V  *	  X.Y.Z	 Use directory [X.Y.Z] * 2 *	  n	 Use n'th predefined directory (n = 0 to 99) *e8 *	  >	 Traverse horizontally (i.e. from [A.A1] to [A.A2] *	@ *	  \	 Traverse to next node in directory tree (preorder traver- *								      sal)  *m= *	  #	 Use directory [SYSj.XXX] when currently in [SYSi.XXX],:! *						where j=i+1 in hexadecimalCA *	  #n     Use directory [SYSn.XXX] when currently in [SYSi.XXX],L! *						 where n,i are hexadecimalI *SD *	  @user	 Use specified user's login directory; requires privileges * 
 *	Example: *iB *	  If in USER:[A.B], '^ .C' or '>C' or '^^ .C' selects USER:[A.C] *  *	.INDEX ENVIRONMENT>>0 *	The resultant device and directory must exist. *lD *	The  function result will be one of the following VMS error status	 *	values:r *p% *	  SS$_NORMAL   '00000001'x  SuccessC *ED *	  RMS$_DIR     '000184CC'x  Error in directory name  (syntax error' *				    or undefined value of n or <n)a *w1 *	  RMS$_DNF     '0001C04A'x  Directory not found  *-D *	  SS$_NOPRIV   '0024'x  No privilege for attempted operation (user( *				has no privilege to read directory) *o4 *	  SS$_NOSUCHDEV  '0908'x  No such device available *-D *	  SS$_NOMOREFILES  '0930'x  No more files (An \ or > traversal has% *				    exhausted all possibilities)e *.D *	The resultant device and directory are placed in character stringsD *	DEVICE and DIRECTORY, respectively.  The valid lengths of the str-D *	ings are in the INTEGER*4 variables DEVLEN and DIRLEN, respective-< *	ly.  These are all in common /SD_LOC/, defined as follows: *n! *		CHARACTER*128 DEVICE,DIRECTORY	 * 1 *		COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYl *R *	D *	SD_ always attempts to use a logical name as the resultant device,D *	even when the input parameter specifies a physical one.   SD_ usesD *	the equivalent of lexical function F$GETDVI(device,"LOGVOLNAM") toD *	get  a logical name  when necessary;  SD_  won't use the resulting! *	name if it begins with "DISK$"., *dD *	The '<n' form of operand requires that the DCL symbols  SD_SP  andD *	SD_SLOTn (n=0,1,2,...,20)  exist; these are defined by the SD com-D *	mand.  The 'n' form of operand requires  that the DCL symbol SD__nD *	exist for each value of 'n' to be used; see the installation docu- *	ment for the SD command. *yD *	The second (optional) argument PRIV is a logical quantity (the de-D *	fault is .FALSE.).  If true, then certain SD operations work diff-
 *	erently: *UD *	    SD ^  from DEV:[A] will go to DEV:[000000]  (normally it stays *								   at [A])c *aD *	    SD ^  from ROOT:[A] will go to F$TRNLNM(ROOT)  (same as above) *8D *	    SD >  from ROOT:[A] will go to [B]             (same as above) *4D *	    SD @user  is performed  (normally it generates a syntax error) *  *- *	17 Mar 86	Complete rewrite.M *I> *	 5 Jun 86	Don't let SD >  go from ROOT:[A] to [B] unless the *			user is privileged.E6 *			Allow wildcard characters in directory parameters;, *			SD will go the FIRST matching directory. *S> *	30 Nov 90	Extensive rewrite of this routine and all routines *			which it calls.A *%' *	 1 Feb 91	General rewrite for SD 4.0.N *L> *	 8 Apr 91	Fix problem  of SD<n not showing error when device *			does not exist.= *M> *	12 Apr 91	Remove extra "." and "]" from right end of operand *			beginning with "..") * > *	20 Jun 91	Allow "SD," (same as "SD.") since this is a common *			typing error.  *N *L1 *	Alan L. Zirkle     Naval Surface Warfare Center	 *			   Code K55C* *	19 Oct 1984	   Dahlgren, Virginia  22448 *E   	IMPLICIT NONE   	CHARACTER*(*) PARAM
 	LOGICAL PRIVN  . 	INTEGER*4   NAM$M_CNCL_DEV, NAM$M_NODE		!NODE+ 	PARAMETER ( NAM$M_CNCL_DEV = '00001000'x ) 1 	PARAMETER ( NAM$M_NODE     = '00020000'x )	!NODEE  " 	INTEGER*4 VALUE,EXPDEV,SLEN / 0 / 	CHARACTER*256 STRINGF* 	COMMON /SD_WORK/ VALUE,EXPDEV,SLEN,STRING   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORYF/ 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY1   	INTEGER*4 FNB,FN_LENM 	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INTEGER*4 WLEN. 	CHARACTER*256 WORKD 	COMMON /WORK/ WLEN,WORK  . 	INTEGER*4 COL,PCOL,PCOL2,PLEN,VALUE2,SUBINDEX 	INTEGER*4 IARGPTR? 	LOGICAL SD_GET_SLOT,OTS$CVT_TI_L,SD_LASTDOT,SD_EXIST,SD_SPLIT,DA 	1    SD_TRAVERSE,ARG_EXIST,PRIV_,LIB$GET_SYMBOL,SD_NEW_DIRECTORYt  A 	SD_ = '184CC'x	    ! Default status is 'Error in Directory Name't   	PRIV_ = .FALSE./ 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) PRIV_ = PRIV   > *	If SLEN > 0, the calling program has already put the current> *	default device and directory (or the desired baseline point). *	into STRING(1:SLEN).  We assume it is valid.   	IF (SLEN.EQ.0) THEN: 	    CALL SD_SPLIT('[]')			! Current default:  SYS$DISK:[] 	ELSE B 	    CALL SD_SPLIT(STRING(1:SLEN))	! User-specified starting point 	ENDIF( 	CALL SD_CHECK_UNUSUAL(DIRECTORY,DIRLEN)  + 	IF (IAND(FNB,NAM$M_NODE).NE.0) THEN		!NODEr. 	    COL = INDEX(DEVICE(1:DEVLEN),'::')		!NODE) 	    DEVICE = DEVICE(COL+2:DEVLEN)		!NODEo& 	    DEVLEN = DEVLEN - COL - 1			!NODE 	ENDIF						!NODEi  0 	EXPDEV = .FALSE.	! No device in any SD operands  	 	PCOL = 1t 	PLEN = LEN(PARAM)   10	IF (PCOL.GT.PLEN) THENl9 	    IF (IAND(FNB,NAM$M_CNCL_DEV).EQ.0) CALL SD_TRANSLATES 	    SD_ = SD_EXIST()  	    GO TO 100 	ENDIF  ! 	PCOL2 = SUBINDEX(PARAM,PCOL,' ')    	IF (PCOL2.EQ.0) THEN  	    PCOL2 = PLEN + 1e 	ELSE IF (PCOL2.EQ.PCOL) THENn 	    PCOL = PCOL + 1
 	    GO TO 10  	ENDIF   	SLEN = PCOL2 - PCOL  . 	STRING(1:SLEN+1) = PARAM(PCOL:PCOL2-1) // ' '  K 20	IF (STRING(1:SLEN).EQ.'.' .OR. STRING(1:SLEN).EQ.',') THEN     ! 6/20/91e    	    CALL SD_SPLIT('SYS$LOGIN:')  # 	ELSE IF (STRING(1:2).EQ.'..') THEN/    	    CALL SD_SPLIT('SYS$LOGIN:')2 	    IF (STRING(SLEN:SLEN).EQ.']') SLEN = SLEN - 12 	    IF (STRING(SLEN:SLEN).EQ.'.') SLEN = SLEN - 1< 	    DIRECTORY(DIRLEN:DIRLEN+SLEN-1) = STRING(2:SLEN) // ']' 	    DIRLEN = DIRLEN + SLEN - 1N  & 	ELSE IF (STRING(1:SLEN).EQ.'^^') THEN  ) 	    COL = INDEX(DIRECTORY(1:DIRLEN),'.')G   	    IF (COL.NE.0) THENt 		DIRLEN = COL  		DIRECTORY(DIRLEN:DIRLEN) = ']'
 	    ENDIF  % 	ELSE IF (STRING(1:SLEN).EQ.'^') THEN    	    IF (PRIV_) THEN9 		CALL SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),1)i  	    ELSE IF (SD_LASTDOT()) THEN 		DIRLEN = VALUE  		DIRECTORY(DIRLEN:DIRLEN) = ']'
 	    ENDIF  " 	ELSE IF (STRING(1:1).EQ.'#') THEN  & 	    CALL SD_INCREMENT(STRING(1:SLEN))  " 	ELSE IF (STRING(1:1).EQ.'@') THEN  @ 	    IF (INDEX(STRING(1:SLEN),'.').NE.0) THEN	! Allow SD @user.x& 		PCOL2 = SUBINDEX(PARAM,PCOL,'.') - 1 		SLEN = PCOL2 - PCOL + 1 
 	    ENDIF  + 	    CALL SD_USERHOME(STRING(1:SLEN),PRIV_)   @ 	ELSE IF (STRING(1:SLEN).EQ.'>' .OR. STRING(1:SLEN).EQ.'\') THEN  2 	    IF (.NOT.SD_TRAVERSE(STRING(1:1),PRIV_)) THEN% 		SD_ = '00000930'x ! 'no more files'  		GO TO 1001
 	    ENDIF  " 	ELSE IF (STRING(1:1).EQ.'>') THEN   	    IF (SD_LASTDOT()) THENY7 		DIRECTORY(VALUE+1:VALUE+SLEN) = STRING(2:SLEN) // ']'r 		DIRLEN = VALUE + SLEN 	 	    ELSEo4 		DIRECTORY(1:SLEN+1) = '[' // STRING(2:SLEN) // ']' 		DIRLEN = SLEN + 1 
 	    ENDIF  " 	ELSE IF (STRING(1:1).EQ.'<') THEN   	    IF (SLEN.EQ.1) THEN 		VALUE = 1r; 	    ELSE IF (.NOT.OTS$CVT_TI_L(STRING(2:SLEN),VALUE)) THENr
 		GO TO 30
 	    ENDIF   	    CALL SD_GET_SP(VALUE2)I  * 	    VALUE = MOD( VALUE2-VALUE+021 , 021 )  & 	    IF (.NOT.SD_GET_SLOT(VALUE)) THEN 		WORK(1:10) = 'Sys$Login:'I 		WLEN = 10)
 	    ENDIF  D 	    SD_ = SD_SPLIT(WORK(1:WLEN))   	! Assume this is full dev:[dir] 	    IF (.NOT.SD_) THEN	# 		IF (SD_.EQ.'184C4'x) SD_ = '908'xa 		GO TO 100	
 	    ENDIF  2 	ELSE IF (OTS$CVT_TI_L(STRING(1:SLEN),VALUE)) THEN  4 	    IF (.NOT.LIB$GET_SYMBOL('SD__'//STRING(1:SLEN), 	1					  STRING,SLEN)) GO TO 308
 	    GO TO 20L   	ELSEA  < 30	     IF (.NOT.SD_NEW_DIRECTORY(STRING(1:SLEN))) GO TO 100   	ENDIF   	PCOL = PCOL2 + 1_	 	GO TO 10_   100	SLEN = 0  
 	END									n e* 	INTEGER FUNCTION SD_NEW_DIRECTORY(STRING)   **- *	INTEGER FUNCTION SD_NEW_DIRECTORY( string )m *  *aD *	This  routine is not called by the user;  it is called by functionD *	SD_ to parse a parameter  which appears to be a device name and/or *	directory name.c *n * > *	17 Jul 85	Save first logical name (if any) used in the input6 *			string, so it can be used later in the result out- *			put string.N *l' *	 1 Feb 91	General rewrite for SD 4.0.  *	. *	20 Jun 91	Disallow "[,oct]", "[oct,]", "[,]" *P *I1 *	Alan L. Zirkle     Naval Surface Warfare CenterA *			   Code K55M* *	19 Oct 1984	   Dahlgren, Virginia  22448 *   = *	STRING is  LOG:[DIR]  or  LOG:  or  LOG  or  [DIR]  or  DIR  *E> *	LOG could be  DEV  or  DEV:[DIR]  (or even DEV:[DIR]FIL.TYP)   	IMPLICIT NONE   	CHARACTER*(*) STRINGn   	INTEGER*4   NAM$M_ROOT_DIRo+ 	PARAMETER ( NAM$M_ROOT_DIR = '00002000'x )O   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORYs/ 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYE   	INTEGER*4 FNB,FN_LENe 	CHARACTER*256 FULLNAMEa 	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INTEGER*4 VALUE 	LOGICAL EXPDEVl 	COMMON /SD_WORK/ VALUE,EXPDEV   	INTEGER*4 WLENS 	CHARACTER*256 WORKX 	COMMON /WORK/ WLEN,WORK   	LOGICAL OTS$CVT_TO_L,SD_SPLIT2 	INTEGER*4 COL,COL1,SUBINDEX,STATUS,FILE_NAME_INFO   	SD_NEW_DIRECTORY = .TRUE.   	WLEN = LEN(STRING)F 	WORK(1:WLEN) = STRING    10	COL = INDEX(WORK(1:WLEN),':')  ) 	IF (WORK(COL:COL+1).EQ.'::') THEN		!NODET* 	    COL = SUBINDEX(WORK,COL+2,':')		! ... 	    IF (COL.EQ.WLEN) THEN0 		WORK(WLEN+1:WLEN+DIRLEN) = DIRECTORY(1:DIRLEN) 		WLEN = WLEN + DIRLEN
 	    ENDIF 	    GO TO 30					! ...E 	ENDIF						!NODEa  C 	IF (COL.EQ.0 .OR. COL.EQ.WLEN) THEN	! "XXXX" or "XXXX:" either oneo$ 						!  is a potential logical name 	    COL1 = WLEN - 1 	    IF (COL.EQ.0) THENi6 		IF (WORK(1:1).EQ.'[' .OR. WORK(1:1).EQ.'.') GO TO 20
 		COL1 = WLEN.
 	    ENDIF  3 	    STATUS = FILE_NAME_INFO( WORK(1:COL1) // ':' )t  ' 	    IF (STATUS.EQ.'1C04A'x) STATUS = 1o  D 	    IF (STATUS) THEN	! We do have a logical name, and it is reason-0 				!  able (not a MAIL distribution list, etc.)  E !	        If the logical name is rooted, see if the rooting is at thee? !		 first translation, like SYS$SYSROOT, or not, like SYS$HELP... !		 Fix for SD NSWC$ROOT: EXE (blank between).  ) 		IF (IAND(FNB,NAM$M_ROOT_DIR).NE.0) THEN	2 		    CALL LOG_TRANS(WORK(1:COL1),FN_LEN,FULLNAME)1 		    IF (FULLNAME(FN_LEN-1:FN_LEN).EQ.'.]') THEN( 			DEVICE = WORK(1:COL1) // ':'s 			DEVLEN = COL1 + 1 			EXPDEV = .TRUE.	 			RETURNt 		    ENDIFX 		ENDIF	  . 		WLEN = FIELDS(3,2) - FIELDS(1,1) + 1			!NODE8 		WORK(1:WLEN) = FULLNAME(FIELDS(1,1):FIELDS(3,2))	!NODE 		EXPDEV = .TRUE.e
 		GO TO 10  
 	    ENDIF   	    IF (COL.EQ.0) THENe8 20		WORK(1:WLEN+DEVLEN) = DEVICE(1:DEVLEN)//WORK(1:WLEN) 		WLEN = DEVLEN + WLEN 		COL = DEVLEN
 	    ENDIF   	ELSE    30	    EXPDEV = .TRUE.   	ENDIF  > 	IF (WORK(COL+1:COL+1).EQ.'<') THEN	! Process directory name's- 	    WORK(COL+1:COL+1) = '['		!  left bracket	( 	ELSE IF (WORK(COL+1:COL+1).NE.'[') THEN1 	    WORK(COL+1:WLEN+1) = '[' // WORK(COL+1:WLEN)  	    WLEN = WLEN + 1 	ENDIF  < 	IF (WORK(WLEN:WLEN).EQ.'>') THEN	! Process directory name's, 	    WORK(WLEN:WLEN) = ']'		!  right bracket& 	ELSE IF (WORK(WLEN:WLEN).NE.']') THEN 	    WORK(WLEN+1:WLEN+1) = ']' 	    WLEN = WLEN + 1 	ENDIF  > 	IF (WORK(WLEN-1:WLEN-1).EQ.'.') THEN	! Change [XXX.] to [XXX] 	    WLEN = WLEN - 1 	    WORK(WLEN:WLEN) = ']' 	ENDIF  5 	IF (WORK(COL+1:COL+2).EQ.'[.') THEN	! Process [.XXX]  	    IF (COL.GT.0) THENd 		DEVLEN = COL  		DEVICE(1:DEVLEN) = WORK(1:COL)
 	    ENDIF* 	    DIRECTORY(DIRLEN:) = WORK(COL+2:WLEN)# 	    DIRLEN = DIRLEN + (WLEN-COL-2)a 	    EXPDEV = .TRUE. 	    RETURNv 	ENDIF% 						! Check for [octal,octal], eachf5 	COL1 = INDEX(WORK(1:WLEN),',')		!  3 or fewer digits	 	IF (COL1.GT.0) THENI 	    IF (WORK(COL1-1:COL1).EQ.'[,'.OR.COL1.GE.WLEN-1) GO TO 100 ! 6/20/91l5 	    IF (COL1.GT.COL+5 .OR. WLEN.GT.COL1+4) GO TO 100n 	    DO WHILE (COL1.LT.COL+5)c. 		WORK(COL+2:WLEN+1) = '0' // WORK(COL+2:WLEN) 		WLEN = WLEN + 1e 		COL1 = COL1 + 1o
 	    ENDDO 	    DO WHILE (WLEN.LT.COL1+4)0 		WORK(COL1+1:WLEN+1) = '0' // WORK(COL1+1:WLEN) 		WLEN = WLEN + 1	
 	    ENDDO* 	    WORK(COL1:WLEN-1) = WORK(COL1+1:WLEN) 	    WLEN = WLEN - 1= 	    IF (.NOT.OTS$CVT_TO_L(WORK(COL+2:WLEN-1),COL)) GO TO 100a 	ENDIF  D 	IF (.NOT.SD_SPLIT(WORK(1:WLEN))) THEN	! Fix for SD SYS$HELP:XXX not& 	    IF (COL.GT.0) THEN			!  aborting. 		DEVICE = WORK(1:COL) 		DEVLEN = COL
 	    ENDIF! 	    DIRECTORY = WORK(COL+1:WLEN)s 	    DIRLEN = WLEN - COL 	ENDIF  , 	IF (DIRECTORY(1:DIRLEN).EQ.'[000000]' .AND.- 	1			     IAND(FNB,NAM$M_ROOT_DIR).NE.0) THENr  A 	    CALL FILE_NAME_INFO(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),3)t9 	    IF (EXPDEV .OR. WORK(COL+1:WLEN).NE.'[000000]') THENO 		COL = INDEX(FULLNAME,'.]') 		FULLNAME(COL:COL) = ']'g	 	    ELSE  		COL = INDEX(FULLNAME,':') $ 		FULLNAME(COL+1:COL+8) = '[000000]' 		COL = COL + 8s
 	    ENDIF# 	    CALL SD_SPLIT(FULLNAME(1:COL))e   	ENDIF   	RETURNo   100	SD_NEW_DIRECTORY = .FALSE.  
 	END										 s 	LOGICAL FUNCTION SD_LASTDOT()   **  *	LOGICAL FUNCTION SD_LASTDOT( ) *  *	D *	This  routine is not called by the user;  it is called by functionD *	SD_ to remove the last  subdirectory from a character  string con-) *	taining a directory tree specification.	 *A *9' *	 1 Feb 91	General rewrite for SD 4.0.w *  *i1 *	Alan L. Zirkle     Naval Surface Warfare Centert *			   Code K55o* *	19 Oct 1984	   Dahlgren, Virginia  22448 *)   	IMPLICIT NONE   	INTEGER*4 VALUE 	COMMON /SD_WORK/ VALUEo   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORYS/ 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYt   	INTEGER*4 I  ' 	VALUE = INDEX(DIRECTORY(1:DIRLEN),'.')    	SD_LASTDOT = VALUE .NE. 0   	IF (SD_LASTDOT) THENM   	    DO I = VALUE+1, DIRLEN   & 		IF (DIRECTORY(I:I).EQ.'.') VALUE = I  
 	    ENDDO   	ENDIF  
 	END									0  $ 	INTEGER FUNCTION SD_SPLIT(FILENAME)   **' *	INTEGER FUNCTION SD_SPLIT( filename )O *  *UD *	This  routine is not called by the user;  it is called by functionD *	SD_ to split a device/directory specification into separate deviceD *	and directory parts.  The function result is .FALSE. if the speci-8 *	fication is not syntactally correct or does not exist. *G *4' *	 1 Feb 91	General rewrite for SD 4.0.R *W; *	 8 Apr 91	Compute DEVICE, DIRECTORY even if error occurs.I *G *41 *	Alan L. Zirkle     Naval Surface Warfare CenterD *			   Code K55L* *	19 Oct 1984	   Dahlgren, Virginia  22448 *_   	IMPLICIT NONE   	CHARACTER*(*) FILENAME   ' 	INTEGER*4 NAM$M_EXP_DEV,NAM$M_EXP_DIR	a* 	PARAMETER ( NAM$M_EXP_DEV = '00000080'x )* 	PARAMETER ( NAM$M_EXP_DIR = '00000040'x )   	INTEGER*4 VALUE 	LOGICAL EXPDEVp 	COMMON /SD_WORK/ VALUE,EXPDEV   	INTEGER*4 FNB,FN_LENs 	CHARACTER*256 FULLNAMEn 	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORY / 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYt   	INTEGER*4 FILE_NAME_INFOD  $ 	SD_SPLIT = FILE_NAME_INFO(FILENAME)   !!!	IF (.NOT.SD_SPLIT) RETURN	  / 	DEVLEN = FIELDS(2,2) - FIELDS(1,1) + 1			!NODEO; 	DEVICE(1:DEVLEN) = FULLNAME(FIELDS(1,1):FIELDS(2,2))	!NODE   ' 	DIRLEN = FIELDS(3,2) - FIELDS(3,1) + 1i8 	DIRECTORY(1:DIRLEN) = FULLNAME(FIELDS(3,1):FIELDS(3,2))  
 	END									  ( 	SUBROUTINE SD_TRANSLATE   ** *	SUBROUTINE SD_TRANSLATE$ *N *DD *	This  routine is not called by the user;  it is called by functionD *	SD_ to attempt to translate any  physical device  names  to  site- *	specific logical names.E *  *(' *	 1 Feb 91	General rewrite for SD 4.0.1 *  *G1 *	Alan L. Zirkle     Naval Surface Warfare Center( *			   Code K55(* *	19 Oct 1984	   Dahlgren, Virginia  22448 *Q   	IMPLICIT NONE   	INCLUDE '($DVIDEF)'   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORYT/ 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYY   	CHARACTER*128 WORKR 	CHARACTER*64 VOLNAM( 	INTEGER*4 WLEN,STATUS,ITMLST(4),IOSB(2) 	INTEGER*2 VNLEN8 	COMMON /WORK/ WLEN,WORK,VOLNAM,ITMLST,STATUS,IOSB,VNLEN    	INTEGER*4 SYS$GETDVIW,LOG_TRANS   	VOLATILE VOLNAM,VNLEN    3 	CALL ITEM_LIST(ITMLST,DVI$_LOGVOLNAM,VOLNAM,VNLEN)1  8 	STATUS = SYS$GETDVIW(,,DEVICE(1:DEVLEN),ITMLST,IOSB,,,)  * 	IF (.NOT.STATUS .OR. .NOT.IOSB(1)) RETURN   	IF (VNLEN.EQ.0) RETURNE  2 	IF (VNLEN.GT.5 .AND. VOLNAM(1:5).EQ.'DISK$') THEN  : 	    IF (.NOT.LOG_TRANS('SYS$SYSDEVICE',WLEN,WORK)) RETURN  / 	    IF (WORK(1:WLEN).EQ.DEVICE(1:DEVLEN)) THENN
 		DEVLEN = 14 ! 		DEVICE(1:14) = 'SYS$SYSDEVICE:'.
 	    ENDIF   	ELSEC   	    DEVLEN = VNLEN + 1L. 	    DEVICE(1:DEVLEN) = VOLNAM(1:VNLEN) // ':'   	ENDIF  
 	END									, ) 	INTEGER FUNCTION SD_EXIST()   ** *	INTEGER FUNCTION SD_EXIST( ) *  *LD *	This  routine is not called by the user;  it is called by functionD *	SD_ to verify that the resultant device and directory actually ex- *	ist. *  * 9 *	 5 Jun 86	Handle wildcards in directory specifications.0 *0' *	 1 Feb 91	General rewrite for SD 4.0.  *E *F1 *	Alan L. Zirkle     Naval Surface Warfare CenterS *			   Code K55Y* *	19 Oct 1984	   Dahlgren, Virginia  22448 *E   	IMPLICIT NONE  : 	INTEGER*4 NAM$M_WILDCARD,NAM$M_ROOT_DIR,NAM$M_SEARCH_LIST4 	PARAMETER ( NAM$M_WILDCARD    = '00000100'x )	!WILD. 	PARAMETER ( NAM$M_ROOT_DIR    = '00002000'x ). 	PARAMETER ( NAM$M_SEARCH_LIST = '00000800'x )   	INTEGER*4 VALUE,EXPDEV,SLEN 	CHARACTER*256 STRINGT* 	COMMON /SD_WORK/ VALUE,EXPDEV,SLEN,STRING   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORY / 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYy   	INTEGER*4 FNB,FN_LEN  	CHARACTER*256 FULLNAMES 	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	LOGICAL SD_WILDCARD				!WILD=- 	INTEGER*4 SD_PARENT,OPEN_TEST,FILE_NAME_INFO(    @ 10	SD_EXIST = SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),2)  / 	IF (IAND(FNB,NAM$M_WILDCARD).NE.0) THEN		!WILDG( 	    IF (SD_WILDCARD()) GO TO 10			!WILD 	ENDIF						!WILD_  ; !	IF (IAND(FNB,NAM$M_SEARCH_LIST).NE.0) RETURN		!AZ 2/20/91 8 	IF (IAND(FNB,NAM$M_SEARCH_LIST).NE.0) THEN		!AZ 2/20/91. 	    SD_EXIST = FILE_NAME_INFO(				!AZ 2/20/91- 	1			  DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN)) ( 	    IF (SD_EXIST) RETURN				!AZ 2/20/91 	ENDIF							!AZ 2/20/91   	IF (.NOT.SD_EXIST) THEN  ; 	    IF (SD_EXIST.EQ.'1C04A'x) THEN ! 'directory not found'   9 		IF (.NOT.EXPDEV.AND.IAND(FNB,NAM$M_ROOT_DIR).NE.0) THENu  A *	If directory does not exist, and we are looking for ROOT:[DIR],u: *	i.e. DEVICE:[XXX.][DIR], then check to see if there is a3 *	DEVICE:[DIR] on the same device; if so, go to it."   		    CALL FILE_NAME_INFO(- 	1			DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),3) 4 		    DEVLEN = FIELDS(2,2) - FIELDS(1,1) + 1		 !NODE@ 		    DEVICE(1:DEVLEN) = FULLNAME(FIELDS(1,1):FIELDS(2,2)) !NODE 		    CALL SD_TRANSLATEo 		    GO TO 10   		ENDIF[  
 	    ENDIF  # !	184C4 = 'error in device name...'N$ !	1829A = 'insufficent privilege...'C 	    IF (SD_EXIST.EQ.'184C4'x) SD_EXIST = '908'x ! 'no such device'N@ 	    IF (SD_EXIST.EQ.'1829A'x) SD_EXIST = '24'x	! 'no privilege' 	    RETURNT   	ENDIF  > *	Check that this process has read permission in the resultant *	directory.  . 	SD_EXIST = OPEN_TEST(FULLNAME(1:FIELDS(6,2)))   	IF (SD_EXIST) THENL- 30	    IF (DIRECTORY(1:8).EQ.'[000000.') THENT 		DIRLEN = DIRLEN - 7R4 		DIRECTORY(1:DIRLEN) = '[' // DIRECTORY(9:DIRLEN+7)
 		GO TO 30
 	    ENDIFC 	ELSE  IF (SD_EXIST.EQ.'1829A'x) THEN ! 'insufficient privilege...'T/ 	    SD_EXIST = '00024'x		     ! 'no privilege'I !	18292 = 'file not found'& !	18744 = 'invalid wildcard operation'D 	ELSE IF (SD_EXIST.EQ.'18292'x .OR. SD_EXIST.EQ.'18744'x) THEN	!WILD6 	    SD_EXIST = '1C04A'x		     ! 'directory not found' 	ENDIF  
 	END									E  - 	INTEGER FUNCTION SD_PARENT(FILENAME,OPTIONS)E   **4 *	INTEGER FUNCTION SD_PARENT( filename [, options] ) *X *rD *	Computes the directory name of the file whose name is in the char-D *	acter  string argument FILENAME.   Information about the directoryD *	name is returned  in variables in common block  /FILE_NAME_INFO_/,D *	which is described in the documentation of routine FILE_NAME_INFO. *UD *	Examples:  After  SD_PARENT('UDISK2:[AA.BB]') is called, character7 *		   variable FULLNAME contains 'UDISK2:[AA]BB.DIR;1'.) * = *		   After SD_PARENT('UDISK2:[A]') is called,  FULLNAME con-a% *		   tains 'UDISK2:[000000]A.DIR;1'.$ *R= *		   After SD_PARENT('SYS$MANAGER') is called, FULLNAME con-a= *		   tains  (for example)  'DUA0:[SYS0]SYSMGR.DIR;1'.   Note = *		   that device  name is always translated  to physical  inA *		   this case. *QD *	SD_PARENT calls FILE_NAME_INFO (and SYS$PARSE) two or three times.D *	The function result  returned from SD_PARENT is the result it gets4 *	from FILE_NAME_INFO for the parent directory name. *	D *	If the optional argument OPTIONS is present,  it contains the fol- *	lowing bits: *ID *	  Bit 0 - Also perform the function of routine SD_SPLIT on the re-# *		  sulting parent directory name.  *ED *	  Bit 1 - The device name in the file name is a search list; don't= *		  translate this name.  This allows us to find a directory = *		  which only exists  in elements of the search list  after1 *		  the first.H * D *	  Bit 2 - Return ROOT:[000000], not DEV:[ROOTXXX] as the parent of *		  ROOT:[EXE]. *R *L' *	 1 Feb 91	General rewrite for SD 4.0.  *e *	.INDEX FILE NAMES>>) *'1 *	Alan L. Zirkle     Naval Surface Warfare Center' *			   Code K55R, *	14 March 1986	   Dahlgren, Virginia  22448 *D   	IMPLICIT NONE   	CHARACTER*(*) FILENAME  	INTEGER*4 OPTIONS  ; 	INTEGER*4 NAM$M_SEARCH_LIST,NAM$M_DIR_LVLS,NAM$M_ROOT_DIR,  	1						  NAM$V_DIR_LVLS. 	PARAMETER ( NAM$M_SEARCH_LIST = '00000800'x ). 	PARAMETER ( NAM$M_DIR_LVLS    = '00E00000'x ). 	PARAMETER ( NAM$M_ROOT_DIR    = '00002000'x )% 	PARAMETER ( NAM$V_DIR_LVLS    = 21 )+   	INTEGER*4 FNB,FN_LENE 	CHARACTER*256 FULLNAME  	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORY(/ 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY    	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR: 	INTEGER*4 OPTIONS_,SUBINDEX,FILE_NAME_INFO,SUB_LVLS,COL,I 	INTEGER*4 BITS)  
 	OPTIONS_ = 0L5 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) OPTIONS_ = OPTIONSE  	 	BITS = 2  	IF (OPTIONS_.EQ.2) BITS = 0  * 	SD_PARENT = FILE_NAME_INFO(FILENAME,BITS)  A 	IF (OPTIONS_.EQ.2 .AND. IAND(FNB,NAM$M_SEARCH_LIST).NE.0) RETURNE   	IF (.NOT.SD_PARENT) GO TO 100  > 	SUB_LVLS = ISHFT( IAND(FNB,NAM$M_DIR_LVLS) , -NAM$V_DIR_LVLS)   	IF (SUB_LVLS.GT.0) THEN 							! Case 1: DEV:[A.B...]P 	    COL = FIELDS(3,1) 	    DO I=1,SUB_LVLS$ 		COL = SUBINDEX(FULLNAME,COL+1,'.')
 	    ENDDO  = 	    FULLNAME(COL:) = ']' // FULLNAME(COL+1:FIELDS(3,2)-1) //L 	1							'.DIR;1'R  - 	ELSE IF (IAND(FNB,NAM$M_ROOT_DIR).NE.0) THENA 							! Case 2: ROOT:[A]) 	    IF (OPTIONS_.NE.4) THEN  ( 		SD_PARENT = FILE_NAME_INFO(FILENAME,3) 		IF (.NOT.SD_PARENT) GO TO 100+   		COL = INDEX(FULLNAME,'.]')  : 		FULLNAME(COL:) = ']' // FULLNAME(COL+3:FIELDS(3,2)-1) // 	1							'.DIR;1'(	 	    ELSE'   		COL = FIELDS(3,1) + 1  		FULLNAME(COL:) = '000000]' // - 	1			 FULLNAME(COL:FIELDS(3,2)-1) // '.DIR;1' 
 	    ENDIF   	ELSE  							! Case 3: DEV:[A] 	    COL = FIELDS(2,2) + 2  > 	    FULLNAME(COL:) = '000000]' // FULLNAME(COL:FIELDS(3,2)-1) 	1						     // '.DIR;1'   	ENDIF  , 	SD_PARENT = FILE_NAME_INFO(FULLNAME(1:255))  + !	186D4 = 'file specification syntax error' # !	184CC = 'error in directory name'i  3 100	IF (SD_PARENT.EQ.'186D4'x) SD_PARENT = '184CC'xa  " 	IF (IAND(OPTIONS_,1).EQ.0) RETURN  / 	DEVLEN = FIELDS(2,2) - FIELDS(1,1) + 1			!NODE ; 	DEVICE(1:DEVLEN) = FULLNAME(FIELDS(1,1):FIELDS(2,2))	!NODE   ' 	DIRLEN = FIELDS(3,2) - FIELDS(3,1) + 1 8 	DIRECTORY(1:DIRLEN) = FULLNAME(FIELDS(3,1):FIELDS(3,2))  
 	END									R  ( 	INTEGER FUNCTION SD_TRAVERSE(TYPE,PRIV)   **- *	INTEGER FUNCTION SD_TRAVERSE( type , priv )D *E *'D *	This  routine is not called by the user;  it is called by functionD *	SD_ to perform a traversal operation (i.e. SD > or SD \).  Charac-- *	ter string TYPE must be either '>' or '\').G *F8 *	See routine SD_ for a definition of the PRIV argument. *( *l' *	 1 Feb 91	General rewrite for SD 4.0.c *e *y> *	 5 Jun 86	Don't let SD >  go from ROOT:[A] to [B] unless the *			user is privileged.o *p *t1 *	Alan L. Zirkle     Naval Surface Warfare Centerl *			   Code K55h* *	17 Mar 1986	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	CHARACTER*(*) TYPEe
 	LOGICAL PRIVo  7 	INTEGER*4 NAM$M_ROOT_DIR,NAM$M_DIR_LVLS,NAM$V_DIR_LVLSi+ 	PARAMETER ( NAM$M_ROOT_DIR = '00002000'x ) + 	PARAMETER ( NAM$M_DIR_LVLS = '00E00000'x )5" 	PARAMETER ( NAM$V_DIR_LVLS = 21 )   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORY / 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYM   	INTEGER*4 FNB,FN_LEN0 	CHARACTER*256 FULLNAMEN 	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INTEGER*4 WLENV 	CHARACTER*255 WORK_ 	COMMON /WORK/ WLEN,WORK  * 	INTEGER*4 SUB_LVLS,CONTEXT,COL1,COL2,COL3+ 	LOGICAL SD_LASTDOT,SD_PARENT,LIB$FIND_FILEG  & 	IF (TYPE.EQ.'>' .AND. .NOT.PRIV) THEN  A 	   SUB_LVLS = ISHFT( IAND(FNB,NAM$M_DIR_LVLS) , -NAM$V_DIR_LVLS)G  ? 	   IF (SUB_LVLS.EQ.0 .AND. IAND(FNB,NAM$M_ROOT_DIR).EQ.0) THEN	 		SD_TRAVERSE = 0R 		RETURN	 	   ENDIFI  < 	ELSE IF (TYPE.EQ.'\') THEN	! Try going down one level first   	    CONTEXT = 0  3 	    SD_TRAVERSE = LIB$FIND_FILE(DEVICE(1:DEVLEN)// 4 	1		    DIRECTORY(1:DIRLEN)//'*.DIR;1',WORK,CONTEXT)  B 	    IF (SD_TRAVERSE) GO TO 20	! Yes, there is a subdirectory here  B 	    IF (.NOT.SD_LASTDOT()) GO TO 30	! If no subs under [A], don't 						!  go to [B] 	ENDIF  A 	SD_TRAVERSE = SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),4)    	IF (.NOT. SD_TRAVERSE) RETURN   	CONTEXT = 0  B 10	SD_TRAVERSE = LIB$FIND_FILE(FULLNAME(1:FIELDS(3,2))//'*.DIR;1', 	1						   WORK,CONTEXT)   	IF (.NOT.SD_TRAVERSE) GO TO 30,  . 	IF (WORK.NE.FULLNAME(1:FIELDS(6,2))) GO TO 10  @ 	SD_TRAVERSE = LIB$FIND_FILE(FULLNAME(1:FIELDS(3,2))//'*.DIR;1', 	1						   WORK,CONTEXT)   	IF (.NOT.SD_TRAVERSE) THEN  	    IF (TYPE.EQ.'>') GO TO 30< 	    CALL SD_PARENT(DEVICE(1:DEVLEN)//DIRECTORY(1:DIRLEN),1)4 	    IF (DIRECTORY(1:DIRLEN).EQ.'[000000]') GO TO 30
 	    GO TO 10  	ENDIF   20	COL1 = INDEX(WORK,'[') + 1L3 	IF (WORK(COL1:COL1+5).EQ.'000000') COL1 = COL1 + 7O   	COL2 = INDEX(WORK,']')S  	COL3 = INDEX(WORK,'.DIR;1') - 1   	WORK(COL2:COL2) = '.'   	DIRLEN = COL3 - COL1 + 3(  4 	DIRECTORY(1:DIRLEN) = '[' // WORK(COL1:COL3) // ']'  " 30	CALL LIB$FIND_FILE_END(CONTEXT)  
 	END									O R 	LOGICAL FUNCTION SD_WILDCARD()E   **! *	LOGICAL FUNCTION SD_WILDCARD( ): *L *)D *	This  routine is not called by the user;  it is called by functionD *	SD_ to attempt to remove wildcards from a directory specification.D *	The function result is .TRUE. if a directory exists  which matches *	the wildcard specification.I *S *X( *	  1 Feb 91	General rewrite for SD 4.0. * ? *	 17 Apr 91	Fix problem:  if in ROOT:[A] and SD >B*, should gor" *			to ROOT:[BX], not DISK:[Y.BX]. *e * 1 *	Alan L. Zirkle     Naval Surface Warfare Centere *			   Code K55o* *	 5 Jun 1986	   Dahlgren, Virginia  22448 *0   	IMPLICIT NONE   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORYY/ 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY    	INTEGER*4 FNB,FN_LENG 	CHARACTER*256 FULLNAME_ 	INTEGER*2 FIELDS(6,2)4 	COMMON /FILE_NAME_INFO_/ FNB,FN_LEN,FULLNAME,FIELDS   	INTEGER*4 WLENM 	CHARACTER*256 WORK0 	COMMON /WORK/ WLEN,WORK  ! 	INTEGER*4 VALUE					! AZ 4/17/91T' 	COMMON /SD_WORK/ VALUE				! AZ 4/17/91S  ! 	INTEGER*4 CONTEXT,COL1,COL2,COL3V/ 	LOGICAL LIB$FIND_FILE,SD_LASTDOT		! AZ 4/17/91T   	CONTEXT = 0  C !!!	SD_WILDCARD = LIB$FIND_FILE(FULLNAME(1:FN_LEN),WORK,CONTEXT)	 !4 									 ! ! 	IF (SD_LASTDOT()) THEN						 !AZ2D 	    SD_WILDCARD = LIB$FIND_FILE(FULLNAME(1:FN_LEN),WORK,CONTEXT) !4 	ELSE								 !17DD 	    SD_WILDCARD = LIB$FIND_FILE(DEVICE(1:DEVLEN)//'[000000]'//	 !916 	1		     DIRECTORY(2:DIRLEN-1)//'.DIR',WORK,CONTEXT) ! 	ENDIF								 !   	IF (SD_WILDCARD) THEN   	    COL1 = INDEX(WORK,'[')D 	    COL2 = INDEX(WORK,']')	  	    COL3 = INDEX(WORK,'.DIR;1')   	    DIRLEN = COL3 - COL1 + 1/   	    WORK(COL2:COL2) = '.' 	    WORK(COL3:COL3) = ']'  * 	    DIRECTORY(1:DIRLEN) = WORK(COL1:COL3)   	ENDIF    	CALL LIB$FIND_FILE_END(CONTEXT)  
 	END									I S 	SUBROUTINE SD_INCREMENT(PARAM)E   **" *	SUBROUTINE SD_INCREMENT( param ) *  *ND *	This  routine is not called by the user;  it is called by functionD *	SD_ to process a parameter of the form "#" or "#nnn",  where "nnn" *	is a hexadecimal number. *  *k1 *	Alan L. Zirkle     Naval Surface Warfare Centere *			   Code K55 * *	30 Nov 1990	   Dahlgren, Virginia  22448 *i   *	If PARAM is "#":D *	  If current directory is [SYSi], or [SYSi.xxx...], then we change< *	  to [SYSj], or [SYSj.xxx...], where j=i+1 in hexadeximal. *	If PARAM is "#z":FD *	  If current directory is [SYSi], or [SYSi.xxx...], then we change; *	  to [SYSz], or [SYSz.xxx...], where i,z are hexadeximal.e   	IMPLICIT NONE  + 	CHARACTER*(*) PARAM	! Either '#' or '#xxx'_   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORY / 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORY   , 	INTEGER*4 COL1,COL2,COL3,VALUE,OTS$CVT_TZ_L 	CHARACTER*8 VALUE_e  - 	IF (DEVICE(1:DEVLEN).EQ.'SYS$SYSROOT:') THENS0 	    CALL LOG_TRANS('SYS$SYSROOT',DEVLEN,DEVICE)' 	    COL1 = INDEX(DEVICE(1:DEVLEN),'[')1' 	    COL2 = INDEX(DEVICE(1:DEVLEN),']')E; 	    DIRECTORY = DEVICE(COL1:COL2-1) // DIRECTORY(2:DIRLEN) * 	    DIRLEN = (COL2 - COL1) + (DIRLEN - 1) 	    DEVLEN = 14$ 	    DEVICE(1:14) = 'SYS$SYSDEVICE:' 	ENDIF  ) 	COL1 = INDEX(DIRECTORY(1:DIRLEN),'[SYS')    	IF (COL1.EQ.0) RETURN   	COL1 = COL1 + 4  ) 	COL2 = INDEX(DIRECTORY(COL1:DIRLEN),'.')R   	IF (COL2.LE.1) THEN- 	    COL2 = INDEX(DIRECTORY(COL1:DIRLEN),']')i 	    IF (COL2.LE.1) RETURN 	ENDIF   	COL2 = COL2 + COL1 - 2T  : 	IF (.NOT.OTS$CVT_TZ_L(DIRECTORY(COL1:COL2),VALUE)) RETURN  2 	IF (LEN(PARAM).EQ.1) THEN	! Parameter is just '#'  . 	    CALL SYS$FAO('!XL',,VALUE_,%VAL(VALUE+1))  
 	    COL3 = 8r# 10	    IF (VALUE_(1:1).EQ.'0') THENa 		VALUE_ = VALUE_(2:)a 		COL3 = COL3 - 1v
 		GO TO 10
 	    ENDIF   	ELSE				! Parameter is '#nnn'   	    COL3 = LEN(PARAM) - 1   	    VALUE_ = PARAM(2:)    	ENDIF  2 	DIRECTORY = DIRECTORY(1:COL1-1) // VALUE_(1:COL3)& 	1				     // DIRECTORY(COL2+1:DIRLEN)' 	DIRLEN = DIRLEN - (COL2-COL1+1) + COL3e  
 	END									K A# 	SUBROUTINE SD_USERHOME(PARAM,PRIV)    **( *	SUBROUTINE SD_USERHOME( param , priv ) *D *RD *	This  routine is not called by the user;  it is called by functionD *	SD_ to process a parameter of the form  "@"  or "@username", where4 *	"username" is the login username of some VAX user. *	 *P1 *	Alan L. Zirkle     Naval Surface Warfare Centerh *			   Code K55 * *	30 Nov 1990	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	CHARACTER*(*) PARAM
 	LOGICAL PRIVc   	INCLUDE '($UAIDEF)'   	INTEGER*4 DEVLEN,DIRLEN 	CHARACTER*128 DEVICE,DIRECTORY / 	COMMON /SD_LOC/ DEVLEN,DIRLEN,DEVICE,DIRECTORYf  & 	INTEGER*4 STATUS,SYS$GETUAI,ITMLST(7)   	VOLATILE /SD_LOC/   	IF (PARAM.EQ.'@') THEN   	    CALL SD_SPLIT('SYS$LOGIN:') 	    RETURNl 	ENDIF   	IF (.NOT.PRIV) THEN= 	    CALL SD_MESSAGE('Syntax Error')	! Simulate CALL ERROR(1)s7 	    CALL EXIT('10000004'x)		! Abort, without a messaget 	ENDIF  1 	CALL ITEM_LIST(ITMLST,UAI$_DEFDEV,DEVICE,DEVLEN,s' 	1		      UAI$_DEFDIR,DIRECTORY,DIRLEN)   + 	STATUS = SYS$GETUAI(,,PARAM(2:),ITMLST,,,)	   	IF (.NOT.STATUS) THENC 	    CALL SD_MESSAGE('No Such User as '//PARAM(2:)) ! CALL ERROR(2) 7 	    CALL EXIT('10000004'x)		! Abort, without a messageI 	ENDIF   	DEVLEN = ICHAR(DEVICE(1:1)) 	DIRLEN = ICHAR(DIRECTORY(1:1))M   	DEVICE(1:DEVLEN) = DEVICE(2:)$ 	DIRECTORY(1:DIRLEN) = DIRECTORY(2:)  
 	END									M S& 	INTEGER FUNCTION SD_GET_SLOT(ORDINAL)   **) *	INTEGER FUNCTION SD_GET_SLOT( ordinal )N *M *OD *	This  routine is not called by the user;  it is called by functionD *	SD_ to get the current value of DCL Symbol SD_SLOTn,  where "n" is *	the value of integer ORDINAL.N *N *L1 *	Alan L. Zirkle     Naval Surface Warfare CenterR *			   Code K55T* *	30 Nov 1990	   Dahlgren, Virginia  22448 *E   	IMPLICIT NONE   	INTEGER*4 ORDINAL 	CHARACTER*(*) STRINGT   	INTEGER*4 SD_PUT_SLOT   	INTEGER*4 WLEN  	CHARACTER*256 WORKO 	COMMON /WORK/ WLEN,WORK   	CHARACTER*2 ORD 	INTEGER*4 O,LIB$GET_SYMBOLT  ( 	CALL SYS$FAO('!UL',O,ORD,%VAL(ORDINAL))  < 	SD_GET_SLOT = LIB$GET_SYMBOL('SD_SLOT'//ORD(1:O),WORK,WLEN)   	RETURN,      " 	ENTRY SD_PUT_SLOT(ORDINAL,STRING)   **, *	SUBROUTINE SD_PUT_SLOT( ordinal , string ) *, *$D *	This  routine is not called by the user;  it is called by functionD *	SD_ to store a new value in DCL Symbol SD_SLOTn,  where "n" is theD *	value of integer ORDINAL, and "n" ranges from 0 to 19.  These sym-D *	bols record  the last 20 directories  to which SD has moved;  theyD *	implement a circular buffer; DCL Symbol SD_SP contains the ordinal$ *	of the current slot in the buffer. *R * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55O* *	30 Nov 1990	   Dahlgren, Virginia  22448 *'  ( 	CALL SYS$FAO('!UL',O,ORD,%VAL(ORDINAL))  2 	CALL LIB$SET_SYMBOL('SD_SLOT'//ORD(1:O),STRING,2)  
 	END									) ' 	SUBROUTINE SD_GET_SP(VALUE)   ** *	SUBROUTINE SD_GET_SP( value )D *  *ED *	This  routine is not called by the user;  it is called by functionD *	SD_ to get the current value of DCL Symbol SD_SP.   If this symbolD *	is undefined,  we assume a value of "0" and we also set DCL SymbolC *	SD_SLOT0 to the name of the current default device and directory.i *t * 1 *	Alan L. Zirkle     Naval Surface Warfare Center= *			   Code K55 * *	30 Nov 1990	   Dahlgren, Virginia  22448 *L   	IMPLICIT NONE   	INTEGER*4 VALUE,NEWVALUEE   	INTEGER*4 WLENE 	CHARACTER*256 WORK	 	COMMON /WORK/ WLEN,WORK   	INTEGER*4 SD_SP / -1 /D  & 	INTEGER*4 LIB$GET_SYMBOL,OTS$CVT_TI_L   	IF (SD_SP.GE.0) THEN	  
 	    GO TO 10R  1 	ELSE IF (LIB$GET_SYMBOL('SD_SP',WORK,WLEN)) THENC  3 	    IF (OTS$CVT_TI_L(WORK(1:WLEN),SD_SP)) GO TO 10n   	ENDIF  
 	SD_SP = 0  " 	CALL DEFAULT_DIRECTORY(WORK,WLEN)  ! 	CALL SD_PUT_SLOT(0,WORK(1:WLEN)).   10	VALUE = SD_SP   	RETURN        	ENTRY SD_PUT_SP(NEWVALUE)   **" *	SUBROUTINE SD_PUT_SP( newvalue ) *n * D *	This  routine is not called by the user;  it is called by functionD *	SD_ to store a new value in Global DCL Symbol SD_SP.  VMS does notD *	allow us to create an integer symbol, so we create a string symbol *	with an integer value. *  *h1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55 * *	30 Nov 1990	   Dahlgren, Virginia  22448 *R   	SD_SP = NEWVALUE$  * 	CALL SYS$FAO('!UL',WLEN,WORK,%VAL(SD_SP))  , 	CALL LIB$SET_SYMBOL('SD_SP',WORK(1:WLEN),2)  
 	END									0  0 	SUBROUTINE SD_CHECK_UNUSUAL(DIRECTORY_,DIRLEN_)   **3 *	SUBROUTINE SD_CHECK_UNUSUAL( directory , dirlen )  *_ */D *	This routine is not called by the user; it is called by the SD andD *	LET  utilities to check for directory names in legal but "unusual"D *	formats, and to normalize them into the regular formats.   UnusualD *	formats  include use of angle brackets instead of square brackets,4 *	and directories in octal UIC format.  For example: *Q1 *		SYS$SYSDEVICE:<AAA>  --->  SYS$SYSDEVICE:[AAA] 4 *		SYS$SYSDEVICE:[1,7]  --->  SYS$SYSDEVICE:[001007]4 *		SYS$SYSDEVICE:<1,7>  --->  SYS$SYSDEVICE:[001007] *	1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55T) *	1 Feb 1991	   Dahlgren, Virginia  22448  *N   	IMPLICIT NONE   	CHARACTER*(*) DIRECTORY_V 	INTEGER*4 DIRLEN_   	INTEGER*4 COL 	CHARACTER*2 PAD / '00' /T  ! 	IF (DIRECTORY_(1:1).EQ.'<') THEN0 	    DIRECTORY_(1:1) = '['& 	    DIRECTORY_(DIRLEN_:DIRLEN_) = ']' 	ENDIF  + 	COL = INDEX( DIRECTORY_(1:DIRLEN_) , ',' )[   	IF (COL.EQ.0) RETURNE   	IF (DIRLEN_-COL.LT.4) THEND3 	    DIRECTORY_(COL+1:) = PAD(1:4-(DIRLEN_-COL)) //U& 	1				       DIRECTORY_(COL+1:DIRLEN_) 	ENDIF   	IF (COL.LT.5) THEN37 	    DIRECTORY_ = '[' // PAD(1:5-COL) // DIRECTORY_(2:)D 	ENDIF  / 	DIRECTORY_ = DIRECTORY_(1:4) // DIRECTORY_(6:))  $ 	DIRLEN_ = INDEX( DIRECTORY_ , ']' )  
 	END									L 3! 	SUBROUTINE SD_CONFIGURE_TERMINALO   **" *	SUBROUTINE SD_CONFIGURE_TERMINAL *I *TD *	This routine is not called by the user; it is called by the SD andD *	LET utilities to determine whether the utility is being run inter-! *	actively from a video terminal.N *( *K1 *	Alan L. Zirkle     Naval Surface Warfare Center1 *			   Code K55C* *	30 Nov 1990	   Dahlgren, Virginia  22448 *R   	IMPLICIT NONE   	INCLUDE '($TTDEF)'R 	INCLUDE '($TT2DEF)'   	LOGICAL TOOWIDE% 	INTEGER*4 SCREEN_LENGTH,SCREEN_WIDTH 0 	COMMON /SD_TERMINAL/ SCREEN_LENGTH,SCREEN_WIDTH   	STRUCTURE /CHARBUF/ 	  BYTE DEVICE_CLASS 	  BYTE DEVICE_TYPES 	  INTEGER*2 PAGE_WIDTH	 	  union 	    map 	      INTEGER*4 BASIC_CHARa 	    end map 	    map 	      BYTE %FILL (3)l 	      BYTE PAGE_LENGTHp 	    end map 	  end union 	  INTEGER*4 EXT_CHARd 	END STRUCTURE   	RECORD /CHARBUF/ CHARBUFd   	COMMON /SMGL_CHAR/ CHARBUF     	CALL SMGL_GET_TERMINAL_SETTINGS  $ 	SCREEN_LENGTH = CHARBUF.PAGE_LENGTH# 	SCREEN_WIDTH  = CHARBUF.PAGE_WIDTHR  ? 	IF (IAND(CHARBUF.BASIC_CHAR,TT$M_SCOPE).EQ.0) SCREEN_WIDTH = 0a   	RETURNC       	ENTRY SD_RESTORE_TERMINAL   **  *	SUBROUTINE SD_RESTORE_TERMINAL *I *ID *	This routine  is not called  by the user;  it is called by  the SDD *	utility to set the VTnnn numeric keypad from application mode back! *	to numeric mode when necessary.I *G *21 *	Alan L. Zirkle     Naval Surface Warfare CenterF *			   Code K55 * *	30 Nov 1990	   Dahlgren, Virginia  22448 *   2 	IF (IAND(CHARBUF.EXT_CHAR,TT2$M_APP_KEYPAD).EQ.0) 	1					       CALL SCREEN('>')   
 	END									G 4 	SUBROUTINE SD_MESSAGE(TEXT)   ** *	SUBROUTINE SD_MESSAGE( text )7 *T * D *	This routine is not called by the user; it is called by the SD andD *	LET utilities  to display  a message.   If the user  is on a videoD *	terminal,  the message is displayed in reverse video and the term- *	inal bell is rung twice. *D *L1 *	Alan L. Zirkle     Naval Surface Warfare Center1 *			   Code K552* *	30 Nov 1990	   Dahlgren, Virginia  22448 *	   	IMPLICIT NONE   	CHARACTER*(*) TEXTL  % 	INTEGER*4 SCREEN_LENGTH,SCREEN_WIDTHO0 	COMMON /SD_TERMINAL/ SCREEN_LENGTH,SCREEN_WIDTH   	LOGICAL SD_DEBUG  	COMMON /SD_DEBUG/ SD_DEBUG=   	CHARACTER*10 PREFIX5 	PARAMETER (PREFIX = CHAR(10)//CHAR(10)//'[1;7m  ' )  	CHARACTER*8  SUFFIX: 	PARAMETER (SUFFIX = '  [m'//CHAR(10)//CHAR(7)//CHAR(7) )   	IF (SD_DEBUG) THEN*8 	    CALL LIB$PUT_OUTPUT(CHAR(10)//'  '//TEXT//CHAR(10))+ 	    CALL LIB$SET_SYMBOL('SD_MESSAGE',TEXT)b 	    RETURN	 	ENDIF   	CALL SD_CONFIGURE_TERMINAL"  % 	IF (SCREEN_WIDTH.NE.0) THEN		! Videoc  & 	    CALL SCREEN(PREFIX//TEXT//SUFFIX)   	ELSE					! Hardcopy   	    CALL LIB$PUT_OUTPUT(' ')v$ 	    CALL LIB$PUT_OUTPUT('  '//TEXT) 	    CALL LIB$PUT_OUTPUT(' ')c   	ENDIF  
 	END									  [0 	SUBROUTINE DEFAULT_DIRECTORY(DIR_STRING,LENGTH)   **9 *	SUBROUTINE DEFAULT_DIRECTORY( dir_string , [ length ] )	 *f *rD *	Returns, in the character string DIR_STRING, the name of the  cur-D *	rent  default device and directory.  The string DIR_STRING must be> *	long enough to contain the name, or this routine will abort. *,D *	If the optional integer*4 argument LENGTH  is  supplied,  then the' *	length of the name is returned there.O *C *,2 *	 1 Feb 91	Use LOG_TRANS routine, not SYS$TRNLOG. *( *	.INDEX ENVIRONMENT>> *)1 *	Alan L. Zirkle     Naval Surface Warfare CenterV *			   Code K55 ) *	9 Nov 1983	   Dahlgren, Virginia  22448N *(   	IMPLICIT NONE   	CHARACTER*(*) DIR_STRING( 	INTEGER*4 LENGTHE   	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR1 	INTEGER*4 LEN1,LEN2,STATUS,LOG_TRANS,SYS$SETDDIR:  / 	STATUS = LOG_TRANS('SYS$DISK',LEN1,DIR_STRING)E/ 	  IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))N  0 	STATUS = SYS$SETDDIR(,LEN2,DIR_STRING(LEN1+1:))/ 	  IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	LEN1 = LEN1 + LEN2D  7 	IF (LEN1.LT.LEN(DIR_STRING)) DIR_STRING(LEN1+1:) = ' '   0 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) LENGTH = LEN1  
 	END									) E+ 	INTEGER FUNCTION LOG_TRANS(NAME,LEN,VALUE)r   **2 *	INTEGER FUNCTION LOG_TRANS( name , len , value ) *) * D *	Attempts to translate logical name NAME.   If it fails, it returnsD *	a .FALSE. function result.   If it succeeds,  it returns  a .TRUE.D *	result and puts the translation into string VALUE and sets integer' *	LEN to the length of the translation.C *- *	.INDEX ENVIRONMENT>> *	1 *	Alan L. Zirkle     Naval Surface Warfare Center- *			   Code K55C* *	30 Nov 1990	   Dahlgren, Virginia  22448 *H   	IMPLICIT NONE   	CHARACTER*(*) NAME,VALUEE 	INTEGER*4 LEN   	INCLUDE '($LNMDEF)'   	INTEGER*4 ITMLST(4),SYS$TRNLNM   - 	CALL ITEM_LIST(ITMLST,LNM$_STRING,VALUE,LEN)o   	LOG_TRANS =; 	1	SYS$TRNLNM(LNM$M_CASE_BLIND,'LNM$FILE_DEV',NAME,,ITMLST)   
 	END										 P" 	INTEGER FUNCTION FPRINT_2(STRING)   **& *	INTEGER FUNCTION FPRINT_2 ( string ) *	 *DD *	This routine is not normally called by the user.   It is called byD *	routine  FPRINT  to print a line  after the line has been built by *	the $FAO system service. * D *	You can  provide your own FPRINT_2 routine to replace this one, if: *	necessary; see the notes for routine FPRINT for details. *@ *T1 *	Alan L. Zirkle     Naval Surface Warfare Centerl *			   Code K53.* *	10 Aug 1984	   Dahlgren, Virginia  22448 *r   	IMPLICIT INTEGER (A-Z)1   	CHARACTER*(*) STRING0   	PRINT 1000,STRING  
 	FPRINT_2 = 1D   1000	FORMAT (A)S   	END) 	LOGICAL FUNCTION LOGICAL_NAME(NAME,EXEC)$   **1 *	LOGICAL FUNCTION LOGICAL_NAME( name [ ,exec ] )M *) *MD *	Returns a result of .TRUE. if and only if the logical name  in theD *	character string NAME exists.  The translation of the name is  NOT *	returned.  *sD *	If the optional second argument EXEC is supplied,  then the resultD *	will be .TRUE. if and only if the logical name exists as an Execu- *	tive Mode logical name.M *S *	.INDEX LOGICAL NAMES>> *O> *	26 Jun 85	Added capability to test for Executive Mode names. *O *	1 *	Alan L. Zirkle     Naval Surface Warfare Centerl *			   Code K53	* *	14 Nov 1983	   Dahlgren, Virginia  22448 *L *,   	IMPLICIT INTEGER (A-Z)   , 	PARAMETER ( LNM$_CASE_BLIND = '02000000'X ), 	PARAMETER ( LNM$_ACMODE     = '6'X        ), 	PARAMETER ( PSL$C_EXEC      = '1'X        )   	CHARACTER*(*) NAMEE   	INTEGER ITMLST(4)   	INTEGER*4 IARGPTR 	LOGICAL ARG_EXIST   	EXTERNAL SS$_NOLOGNAM  * 	CALL ITEM_LIST(ITMLST,LNM$_ACMODE,ACMODE)  = 	STATUS = SYS$TRNLNM(LNM$_CASE_BLIND,'LNM$DCL_LOGICAL',NAME,,Y 	1							 ITMLST)V   	LOGICAL_NAME = STATUS   	IF (.NOT.STATUS) THEN  A 	   IF (STATUS.NE.%LOC(SS$_NOLOGNAM)) CALL LIB$STOP(%VAL(STATUS))L  , 	ELSE IF (ARG_EXIST(%VAL(IARGPTR()),2)) THEN  ) 	   LOGICAL_NAME = ACMODE .EQ. PSL$C_EXECc   	ENDIF   	END