: /* Copyright (C) 1988, 1989 Free Software Foundation, Inc. This file is part of GNU Make.  @ GNU Make is free software; you can redistribute it and/or modifyD it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 1, or (at your option)  any later version.  ; GNU Make is distributed in the hope that it will be useful, > but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License < along with GNU Make; see the file COPYING.  If not, write toI the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */    #include "make.h"  #include "file.h"  #include "variable.h"     @ /* Structure used to represent a selective VPATH searchpath.  */   struct vpath   { I     struct vpath *next;	/* Pointer to next struct in the linked list.  */ /     char *pattern;	/* The pattern to match.  */ B     char *percent;	/* Pointer into `pattern' where the `%' is.  */5     unsigned int patlen;/* Length of the pattern.  */ B     char **searchpath;	/* Null-terminated list of directories.  */G     unsigned int maxlen;/* Maximum length of any entry in the list.  */    };  + /* Linked-list of all selective VPATHs.  */    static struct vpath *vpaths;  = /* Structure for the general VPATH given in the variable.  */   # static struct vpath *general_vpath;                             % static int selective_vpath_search ();   5 /* Reverse the chain of selective VPATH lists so they 7    will be searched in the order given in the makefiles 6    and construct the list from the VPATH variable.  */   void build_vpath_lists () { !   register struct vpath *new = 0; %   register struct vpath *old, *nexto;    register char *p;      /* Reverse the chain.  */ +   for (old = vpaths; old != 0; old = nexto)      {        nexto = old->next;       old->next = new;       new = old;     }      vpaths = new;   E   /* If there is a VPATH variable with a nonnull value, construct the I      general VPATH list from it.  We use variable_expand rather than just I      calling lookup_variable so that it will be recursively expanded.  */ #   p = variable_expand ("$(VPATH)");    if (*p != '\0')      { $       construct_vpath_list ("%", p);B       /* VPATHS will be nil if there have been no previous `vpath': 	 directives and none of the given directories exists.  */       if (vpaths == 0) 	general_vpath = 0; 
       else 	{ 	  general_vpath = vpaths;+ 	  /* It was just put into the linked list, ; 	     but we don't want it there, so we must remove it.  */   	  vpaths = general_vpath->next; 	}     }  }                                   D /* Construct the VPATH listing for the pattern and searchpath given.  I    This function is called to generate selective VPATH lists and also for G    the general VPATH list (which is in fact just a selective VPATH that H    is applied to everything).  The returned pointer is either put in theC    linked list of all selective VPATH lists or in the GENERAL_VPATH     variable.  C    If SEARCHPATH is nil, remove all previous listings with the same :    pattern.  If PATTERN is nil, remove all VPATH listings.B    Existing and readable directories that are not "." given in theD    searchpath separated by colons are loaded into the directory hashF    table if they are not there already and put in the VPATH searchpathF    for the given pattern with trailing slashes stripped off if present/    (and if the directory is not the root, "/"). O    The length of the longest entry in the list is put in the structure as well. =    The new entry will be at the head of the VPATHS chain.  */    void' construct_vpath_list (pattern, dirpath)       char *pattern, *dirpath;  {    register unsigned int elem;    register char *p;    register char **vpath;!   register unsigned int maxvpath;    unsigned int maxelem;    char *percent;     if (pattern != 0)      { 7       pattern = savestring (pattern, strlen (pattern)); '       percent = find_percent (pattern);      }      if (dirpath == 0)      { &       /* Remove matching listings.  */-       register struct vpath *path, *lastpath;          lastpath = vpaths;H       for (path = vpaths; path != 0; lastpath = path, path = path->next) 	if (pattern == 0 . 	    || (((percent == 0 && path->percent == 0); 		 || (percent - pattern == path->percent - path->pattern)) % 		&& streq (pattern, path->pattern)))  	  {+ 	    /* Remove it from the linked list.  */  	    if (lastpath == vpaths) 	      vpaths = path->next; 	 	    else # 	      lastpath->next = path->next;   $ 	    /* Free its unused storage.  */ 	    free (path->pattern);& 	    free ((char *) path->searchpath); 	    free ((char *) path); 	  }       if (pattern != 0)  	free (pattern);
       return;      }   &   /* Skip over any initial colons.  */   p = dirpath;
 #ifdef VMS   while (*p == ';')  #else    while (*p == ':')  #endif     ++p;  7   /* Figure out the maximum number of VPATH entries and 8      put it in MAXELEM.  We start with 2, one before the5      first colon and one nil, the list terminator and ?      increment our estimated number for each colon we find.  */    maxelem = 2;   while (*p != '\0')
 #ifdef VMS     if (*p++ == ';') #else      if (*p++ == ':') #endif       ++maxelem;  8   vpath = (char **) xmalloc (maxelem * sizeof (char *));   maxvpath = 0;      elem = 0;    p = dirpath;   while (*p != '\0')     {        char *v;       unsigned int len;   !       /* Find the next entry.  */ 
 #ifdef VMS%       while (*p != '\0' && *p == ';')  #else %       while (*p != '\0' && *p == ':')  #endif 	++p;        if (*p == '\0')  	break;   (       /* Find the end of this entry.  */       v = p;
 #ifdef VMS%       while (*p != '\0' && *p != ';')  #else %       while (*p != '\0' && *p != ':')  #endif 	++p;          len = p - v;-       /* Make sure there's no trailing slash, ) 	 but still allow "/" as a directory.  */  #ifndef VMS "       if (len > 1 && p[-1] == '/') 	--len;  #endif  H /* I'm lost here, i wish this f___ing code was commented better! - MM */        if (len == 1 && *v == '.')
 	continue;         v = savestring (v, len);$       if (dir_file_exists_p (v, "")) 	{  	  vpath[elem++] = dir_name (v); 	  free (v); 	  if (len > maxvpath) 	    maxvpath = len; 	}
       else
 	free (v);     }      if (elem > 0)      {        struct vpath *path; :       /* ELEM is now incremented one element past the last2 	 entry, to where the nil-pointer terminator goes.8 	 Usually this is maxelem - 1.  If not, shrink down.  */       if (elem < (maxelem - 1)) , 	vpath = (char **) xrealloc ((char *) vpath,& 				    (elem + 1) * sizeof (char *));  I       /* Put the nil-pointer terminator on the end of the VPATH list.  */        vpath[elem] = 0;  K       /* Construct the vpath structure and put it into the linked list.  */ >       path = (struct vpath *) xmalloc (sizeof (struct vpath));       path->searchpath = vpath;        path->maxlen = maxvpath;       path->next = vpaths;       vpaths = path;          /* Set up the members.  */       path->pattern = pattern;       path->percent = percent;&       path->patlen = strlen (pattern);     }    elseF     /* There were no entries, so free whatever space we allocated.  */     free ((char *) vpath); }                           D /* Search the VPATH list whose pattern matches *FILE for a directoryI    where the name pointed to by FILE exists.  If it is found, the pointer E    in FILE is set to the newly malloc'd name of the existing file and +    we return 1.  Otherwise we return 0.  */    int  vpath_search (file)       char **file;  {    register struct vpath *v;   B   /* If there are no VPATH entries or FILENAME starts at the root,$      there is nothing we can do.  */  ;   if (**file == '/' || (vpaths == 0 && general_vpath == 0)) 
     return 0;   '   for (v = vpaths; v != 0; v = v->next) 8     if (pattern_matches (v->pattern, v->percent, *file))+       if (selective_vpath_search (v, file)) 
 	return 1;     if (general_vpath != 06       && selective_vpath_search (general_vpath, file))
     return 1;a     return 0;w };    E /* Search the given VPATH list for a directory where the name pointeda:    to by FILE exists.  If it is found, the pointer in FILEJ    is set to the newly malloc'd name of the existing file and we return 1.    Otherwise we return 0.  */i  
 static int# selective_vpath_search (path, file)u      struct vpath *path;      char **file;T {r
 #ifdef VMSE     /* because I don't feel like deciphering and porting this code */e
     return 1;h #elsev   int not_target;f   char *name, *n;b   char *filename; +   register char **vpath = path->searchpath; '   unsigned int maxvpath = path->maxlen;7   register unsigned int i;&   unsigned int flen, vlen, name_dplen;   int exists = 0;i  #   /* Find out if *FILE is a target.uB      If and only if it is NOT a target, we will accept prospective@      files that don't exist but are mentioned in a makefile.  */   {i)     struct file *f = lookup_file (*file); )     not_target = f == 0 || !f->is_target;e   }o     flen = strlen (*file);  E   /* Split *FILE into a directory prefix and a name-within-directory.s@      NAME_DPLEN gets the length of the prefix; FILENAME gets theE      pointer to the name-within-directory and FLEN is its length.  */   
 #ifdef VMS   n = rindex (*file, ']');*   name_dplen = n != 0 ? n - *file + 1 : 0; #elsef   n = rindex (*file, '/');&   name_dplen = n != 0 ? n - *file : 0; #endif,   filename = name_dplen > 0 ? n + 1 : *file;   if (name_dplen > 0)s
 #ifdef VMS     flen -= name_dplen;  #elsev     flen -= name_dplen + 1;l #endif  7   /* Allocate enough space for the biggest VPATH entry,t8      a slash, the directory prefix that came with *FILE,7      another slash (although this one may not always bei9      necessary), the filename, and a null terminator.  */ D   name = (char *) alloca (maxvpath + 1 + name_dplen + 1 + flen + 1);     /* Try each VPATH entry.  */!   for (i = 0; vpath[i] != 0; ++i)e     {;       n = name;t  M       /* Put the next VPATH entry into NAME at N and increment N past it.  */h       vlen = strlen (vpath[i]);i        bcopy (vpath[i], n, vlen);       n += vlen;  7       /* Add the directory prefix already in *FILE.  */d       if (name_dplen > 0)p 	{0 #ifndef VMS /* I hate this cryptic code! - MM */ 	  *n++ = '/'; #endif  	  bcopy (*file, n, name_dplen); 	  n += name_dplen;n 	}  B       /* Now add the name-within-directory at the end of NAME.  */ #ifndef VMSf$       if (n != name && n[-1] != '/')
 	*n = '/'; #endif(       bcopy (filename, n + 1, flen + 1);         if (not_target) / 	/* Since *FILE is not a target, if the file ism9 	   mentioned in a makefile, we consider it existent.  */ " 	exists = lookup_file (name) != 0;         if (!exists) 	{1 	  /* That file wasn't mentioned in the makefile.T$ 	     See if it actually exists.  */  5 	  /* Clobber a null into the name at the last slash.s; 	     Now NAME is the name of the directory to look in.  */e
 	  *n = '\0';)  B 	  /* Make sure the directory exists and we know its contents.  */7 	  if (name_dplen > 0 && !dir_file_exists_p (name, "")). 	    /* It doesn't exist.  */m 	    continue;  C 	  /* We know the directory is in the hash table now because eitherA? 	     construct_vpath_list or the code just above put it there.., 	     Does the file we seek exist in it?  *// 	  exists = dir_file_exists_p (name, filename);i 	}         if (exists)a 	{ 	  /* We have found a file.h< 	     Store the name we found into *FILE for the caller.  */  % 	  /* Put the slash back in NAME.  */o 	  *n = '/';  4 	  *file = savestring (name, (n + 1 - name) + flen);   	  return 1; 	}     }l     return 0;e #endif /* not VMS */ }o                                              1 /* Print the data base of VPATH search paths.  */d   void print_vpath_data_base () {     register unsigned int nvpaths;   register struct vpath *v;t  $   puts ("\n# VPATH Search Paths\n");     nvpaths = 0;'   for (v = vpaths; v != 0; v = v->next)      {        register unsigned int i;         ++nvpaths;  '       printf ("vpath %s ", v->pattern);   -       for (i = 0; v->searchpath[i] != 0; ++i)R" 	printf ("%s%c", v->searchpath[i],* 		v->searchpath[i + 1] == 0 ? '\n' : ':');     }a     if (vpaths == 0)(     puts ("# No `vpath' search paths.");   else7     printf ("\n# %u `vpath' search paths.\n", nvpaths);t     if (general_vpath == 0) <     puts ("\n# No general (`VPATH' variable) search path.");   else     {t7       register char **path = general_vpath->searchpath;l       register unsigned int i;  H       fputs ("\n# General (`VPATH' variable) search path:\n# ", stdout);  $       for (i = 0; path[i] != 0; ++i)9 	printf ("%s%c", path[i], path[i + 1] == 0 ? '\n' : ':');(     }  }h