+ /* Job execution and handling for GNU Make. 6 Copyright (C) 1988-1991 Free Software Foundation, Inc. This file is part of GNU Make.  @ GNU Make is free software; you can redistribute it and/or modifyD it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 1, or (at your option)  any later version.  ; GNU Make is distributed in the hope that it will be useful, > but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License < along with GNU Make; see the file COPYING.  If not, write toI the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */    #include "make.h"  #include "commands.h"  #include "job.h" #include "file.h"  #include "variable.h"  #include <errno.h>  . /* Default path to search for executables.  */. static char default_path[] = ":/bin:/usr/bin";   /* Default shell to use.  */! char default_shell[] = "/bin/sh";    extern int errno;   ( #if	defined(USG) && !defined(HAVE_VFORK) #define	vfork	fork #define	VFORK_NAME	"fork" # #else	/* Have vfork or not USG.  */  #define	VFORK_NAME	"vfork"' #endif	/* USG and don't have vfork.  */  extern int vfork ();   #ifdef	_POSIX_SOURCE #include <sys/wait.h>   : #define	WAIT_NOHANG(status)	waitpid(-1, (status), WNOHANG)   #else	/* Not _POSIX_SOURCE.  */   
 #ifdef VMS #include <time.h>  #else + #if	defined(HAVE_SYS_WAIT) || !defined(USG)  #include <sys/wait.h>  #include <sys/time.h>  #include <sys/resource.h>   
 #ifndef	wait3  extern int wait3 (); #endifI #define	WAIT_NOHANG(status)	wait3((status), WNOHANG, (struct rusage *) 0)    #ifndef	wait extern int wait ();  #endif" #endif	/* HAVE_SYS_WAIT || !USG */ #endif /* not VMS */ #endif	/* _POSIX_SOURCE.  */  B #if	defined(WTERMSIG) || (defined(USG) && !defined(HAVE_SYS_WAIT)) #define	WAIT_T int   #ifndef	WTERMSIG  #define WTERMSIG(x) ((x) & 0x7f) #endif #ifndef	WCOREDUMP ! #define WCOREDUMP(x) ((x) & 0x80)  #endif #ifndef	WEXITSTATUS * #define WEXITSTATUS(x) (((x) >> 8) & 0xff) #endif #ifndef	WIFSIGNALED * #define WIFSIGNALED(x) (WTERMSIG (x) != 0) #endif #ifndef	WIFEXITED ( #define WIFEXITED(x) (WTERMSIG (x) == 0) #endif  C #else	/* WTERMSIG not defined and have <sys/wait.h> or not USG.  */   
 #ifdef VMS static int vms_jobsefnmask=0;  #else    #define WAIT_T union wait # #define WTERMSIG(x)	((x).w_termsig) % #define WCOREDUMP(x)	((x).w_coredump) & #define WEXITSTATUS(x)	((x).w_retcode) #ifndef	WIFSIGNALED ) #define	WIFSIGNALED(x)	(WTERMSIG(x) != 0)  #endif #ifndef	WIFEXITED ' #define	WIFEXITED(x)	(WTERMSIG(x) == 0)  #endif #endif /* VMS */  B #endif	/* WTERMSIG defined or USG and don't have <sys/wait.h>.  */     #ifndef VMS 6 #if	defined(__GNU_LIBRARY__) || defined(_POSIX_SOURCE) #include <sys/types.h> #define	GID_T	gid_t  #ifdef	hpux  #include <sys/param.h> #define getdtablesize() NOFILE #endif #else	/* Not GNU C library.  */    #define	GID_T	int    extern int dup2 ();  extern int fork (), execve (); extern void _exit (); " extern int geteuid (), getegid ();  extern int setgid (), getgid ();   #ifndef USG  extern int getdtablesize (); #else  #include <sys/param.h> #define getdtablesize() NOFILE #endif #endif	/* GNU C library.  */ #endif /* VMS */    ! extern void wait_to_start_job (); ! extern int start_remote_job_p (); 1 extern int start_remote_job (), remote_status ();      #ifndef VMS = #if	(defined(USG) && !defined(HAVE_SIGLIST)) || defined(DGUX)  static char *sys_siglist[NSIG];  void init_siglist (); 1 #else	/* Not (USG and HAVE_SIGLIST), or DGUX.  */  extern char *sys_siglist[]; 0 #endif	/* USG and not HAVE_SIGLIST, or DGUX.  */ #endif /* VMS */   int child_handler (); ( static void free_child (), start_job ();                                     /* Chain of all children.  */    struct child *children = 0;   , /* Number of children currently running.  */    unsigned int job_slots_used = 0;  6 /* Nonzero if the `good' standard input is in use.  */   static int good_stdin_used = 0;                                       = /* Write an error message describing the exit status given in A    EXIT_CODE, EXIT_SIG, and COREDUMP, for the target TARGET_NAME. 0    Append "(ignored)" if IGNORED is nonzero.  */  
 #ifdef VMS static void A child_error (target_name, exit_code, exit_sig, coredump, ignored)       char *target_name; '      int exit_code, exit_sig, coredump;       int ignored;  { 4   char *ignore_string = ignored ? " (ignored)" : "";     if (!(exit_code & 1)) J       error("*** [%s] Error %d%s", target_name, exit_code, ignore_string); }  #else  static void A child_error (target_name, exit_code, exit_sig, coredump, ignored)       char *target_name; '      int exit_code, exit_sig, coredump;       int ignored;  { 4   char *ignore_string = ignored ? " (ignored)" : "";     if (exit_sig == 0)I     error ("*** [%s] Error %d%s", target_name, exit_code, ignore_string);    else     { ?       char *coredump_string = coredump ? " (core dumped)" : ""; *       if (exit_sig > 0 && exit_sig < NSIG) 	error ("*** [%s] %s%s",= 	       target_name, sys_siglist[exit_sig], coredump_string); 
       elseH 	error ("*** [%s] Signal %d%s", target_name, exit_sig, coredump_string);     }  }  #endif /* VMS */                                            A extern void block_remote_children (), unblock_remote_children ();    extern int fatal_signal_mask;   
 #ifdef	USGH /* Set nonzero in the interval when it's possible that we may see a dead0    child that's not in the `children' chain.  */) static int unknown_children_possible = 0;  #endif    < /* Block the child termination signal and fatal signals.  */   static void  block_signals () { 
 #ifdef USG  B   /* Tell child_handler that it might see children that aren't yet!      in the `children' chain.  */     unknown_children_possible = 1;  1   /* Ignoring SIGCLD makes wait always return -1. 7      Using the default action does the right thing.  */ "   (void) SIGNAL (SIGCLD, SIG_DFL);   #else	/* Not USG.  */   
 #ifdef VMS   /* Block the signals.  */ &   (void) sigblock (fatal_signal_mask); #else    /* Block the signals.  */ :   (void) sigblock (fatal_signal_mask | sigmask (SIGCHLD));   #endif /* not VMS */ #endif     block_remote_children ();  }   > /* Unblock the child termination signal and fatal signals.  */ static void  unblock_signals () { 
 #ifdef	USG  (   (void) SIGNAL (SIGCLD, child_handler);  N   /* It should no longer be possible for children not in the chain to die.  */    unknown_children_possible = 0;   #else	/* Not USG.  */   
 #ifdef VMS   /* Unblock the signals.  */ :   (void) sigsetmask (sigblock (0) & ~(fatal_signal_mask)); #else    /* Unblock the signals.  */ N   (void) sigsetmask (sigblock (0) & ~(fatal_signal_mask | sigmask (SIGCHLD)));   #endif /* not VMS */ #endif     unblock_remote_children ();  }   ) static char *signals_blocked_p_stack = 0; * static unsigned int signals_blocked_p_max;, static unsigned int signals_blocked_p_depth;  F /* Make signals blocked in FLAG is nonzero, unblocked if FLAG is zero.A    Push this setting on the signals_blocked_p_stack, so it can be +    popped off by pop_signals_blocked_p.  */    void push_signals_blocked_p (flag)       int flag; {    int blocked;  #   if (signals_blocked_p_stack == 0)      {         signals_blocked_p_max = 8;5       signals_blocked_p_stack = (char *) xmalloc (8); "       signals_blocked_p_depth = 1;(       signals_blocked_p_stack[0] = flag;         blocked = 0;     }    else     { ;       if (signals_blocked_p_depth == signals_blocked_p_max)  	{ 	  signals_blocked_p_max += 8; 	  signals_blocked_p_stack1 	    = (char *) xrealloc(signals_blocked_p_stack,  				signals_blocked_p_max);  	}  ,       blocked = (signals_blocked_p_depth > 0< 		 && signals_blocked_p_stack[signals_blocked_p_depth - 1]);  D       signals_blocked_p_stack[++signals_blocked_p_depth - 1] = flag;     }      if (blocked && !flag)      unblock_signals ();    else if (flag && !blocked)     block_signals ();a }h  3 /* Pop the signals_blocked_p setting from the stackf3    and block or unblock signals as appropriate.  */.   void pop_signals_blocked_p () {n   int blocked, block;   (   blocked = (signals_blocked_p_depth > 0A 	     && signals_blocked_p_stack[signals_blocked_p_depth-- - 1]);h  &   block = (signals_blocked_p_depth > 0= 	   && signals_blocked_p_stack[signals_blocked_p_depth - 1]);l     if (block && !blocked)     block_signals ();n   else if (blocked && !block)A     unblock_signals ();A }R            8 extern int shell_function_pid, shell_function_completed;  
 #ifdef VMS. /* Wait for nchildren children to terminate */& void vmsWaitForChildren(int nchildren) {l     int status;t     int efnstates;     int dead_children = 0;       while (1) {M 	if (!vms_jobsefnmask) 	    return;   #ifdef MIKESJOBDEBUGO 	fprintf(stderr,"jbsmsk=%08x, nch=%d, waiting...\n",vms_jobsefnmask,nchildren);. 	fflush(stderr); #endif( 	status = sys$wflor(32,vms_jobsefnmask); #ifdef MIKESJOBDEBUG% 	fprintf(stderr,"done waiting...\n");  	fflush(stderr); #endif 	dead_children++;e  	if (dead_children == nchildren) 	    return;     }R }  #endif   #ifndef VMSfB /* Handle a child-termination signal (SIGCHLD, or SIGCLD for USG),H    storing the returned status and the new command state (`cs_finished')A    in the `file' member of the `struct child' for the dead child,n)    and removing the child from the chain.   ?    If we were called as a signal handler, SIG should be SIGCHLDeF    (SIGCLD for USG).  If instead it is zero, we were called explicitly1    and should block waiting for running children.<I    If SIG is < 0, - SIG is the maximum number of children to bury (recordA,    status of and remove from the chain).  */   ints child_handler (sig)	
      int sig;t {i   WAIT_T status;!   unsigned int dead_children = 0;e     if (sig > 0)     block_signals ();C     while (1)e     {T       int remote = 0;)       register int pid;T(       int exit_code, exit_sig, coredump;'       register struct child *lastc, *c;f       int child_failed;f  .       /* First, check for remote children.  */@       pid = remote_status (&exit_code, &exit_sig, &coredump, 0);       if (pid < 0) 	{8 	  /* No remote children.  Check for local children.  */   #ifdef	WAIT_NOHANG 	  if (sig > 0)G! 	    pid = WAIT_NOHANG (&status);M 	  elsee 	    pid = wait (&status);) #else	/* USG and don't HAVE_SYS_WAIT.  */v; 	  /* System V cannot do non-blocking waits, so we have twof< 	     choices if called as a signal handler: handle only one: 	     child (there may be more if the signal was blocked),9 	     or block waiting for more.  The latter option makese< 	     parallelism useless, so we must choose the former.  */ 	  pid = wait (&status);' #endif	/* HAVE_SYS_WAIT or not USG.  */    	  if (pid <= 0) 	    /* No local children.  */ 	    break;_ 	  elseR 	    {& 	      /* Chop the status word up.  */( 	      exit_code = WEXITSTATUS (status);? 	      exit_sig = WIFSIGNALED (status) ? WTERMSIG (status) : 0; % 	      coredump = WCOREDUMP (status);f 	    } 	}
       else 	/* We got a remote child.  */ 	remote = 1;  @       /* Check if this is the child of the `shell' function.  *//       if (!remote && pid == shell_function_pid)n 	{> 	  /* It is.  Leave an indicator for the `shell' function.  */) 	  if (exit_sig == 0 && exit_code == 127) # 	    shell_function_completed = -1;x 	  else " 	    shell_function_completed = 1;  9 	  /* Check if we have reached our quota of children.  */e 	  ++dead_children;n( 	  if (sig < 0 && dead_children == -sig) 	    break;|+ #if	defined(USG) && !defined(HAVE_SYS_WAIT)I 	  else if (sig > 0) 	    break;	 #endif 	  elseA 	    continue; 	}  5       child_failed = exit_sig != 0 || exit_code != 0;o  :       /* Search for a child matching the deceased one.  */       lastc = 0;8       for (c = children; c != 0; lastc = c, c = c->next)* 	if (c->remote == remote && c->pid == pid)	 	  break;c         if (c == 0)  	{  	  /* An unknown child died.  */
 #ifdef	USG" 	  if (!unknown_children_possible) 	    { #endif 	      char buf[100]; G 	      sprintf (buf, "Unknown%s job %d", remote ? " remote" : "", pid);  	      if (child_failed)2 		child_error (buf, exit_code, exit_sig, coredump, 			     ignore_errors_flag); 	      else  		error ("%s finished.", buf);
 #ifdef	USG 	    } #endif 	}
       else 	{? 	  /* If this child had the good stdin, say it is now free.  */_ 	  if (c->good_stdin)  	    good_stdin_used = 0;   : 	  if (child_failed && !c->noerror && !ignore_errors_flag) 	    {7 	      /* The commands failed.  Write an error message,(. 		 delete non-precious targets, and abort.  */E 	      child_error (c->file->name, exit_code, exit_sig, coredump, 0); " 	      c->file->update_status = 1; 	      if (exit_sig != 0)r 		delete_child_targets (c);  	    } 	  elseo 	    { 	      if (child_failed) 		{r2 		  /* The commands failed, but we don't care.  */ 		  child_error (c->file->name,), 			       exit_code, exit_sig, coredump, 1); 		  child_failed = 0;r 		}   C 	      /* If there are more commands to run, try to start them.  */e 	      start_job (c);x  & 	      switch (c->file->command_state) 		{s 		case cs_running:= 		  /* Successfully started.  Loop to reap more children.  */e
 		  continue;[   		case cs_finished:t$ 		  if (c->file->update_status != 0) 		    { / 		      /* We failed to start the commands.  */ ! 		      delete_child_targets (c);e 		    } 
 		  break;  
 		default:0 		  error ("internal error: `%s' command_state \% %d in child_handler", c->file->name);e
 		  abort (); 
 		  break; 		}  	    }  ? 	  /* Set the state flag to say the commands have finished.  */c( 	  c->file->command_state = cs_finished;" 	  notice_finished_file (c->file);  6 	  /* Remove the child from the chain and free it.  */ 	  if (lastc == 0) 	    children = c->next; 	  else  	    lastc->next = c->next;  	  free_child (c);  ) 	  /* There is now another slot open.  */  	  --job_slots_used;  @ 	  /* If the job failed, and the -k flag was not given, die.  */( 	  if (child_failed && !keep_going_flag)
 	    die (1);   8 	  /* See if we have reached our quota for blocking.  */ 	  ++dead_children;g( 	  if (sig < 0 && dead_children == -sig) 	    break;a+ #if	defined(USG) && !defined(HAVE_SYS_WAIT)k 	  else if (sig > 0) 	    break;  #endif 	}     }   
 #ifdef	USG   if (sig > 0)'     (void) SIGNAL (sig, child_handler);s #endif     if (sig > 0)     unblock_signals ();_     return 0;  }d #endif /* not VMS */  . /* Wait for N children, blocking if necessary.3    If N is zero, wait until we run out of children.i:    If ERR is nonzero and we have any children to wait for,!    print a message on stderr.  */t   void wait_for_children (n, err)      unsigned int n;
      int err;) {    push_signals_blocked_p (1);s  8   if (err && (children != 0 || shell_function_pid != 0))     {i       fflush (stdout);4       error ("*** Waiting for unfinished jobs....");     }   
 #ifdef VMS   vmsWaitForChildren((int) n); #elset+   /* Call child_handler to do the work.  */c#   (void) child_handler (- (int) n);; #endif     pop_signals_blocked_p ();n }e                    , /* Free the storage allocated for CHILD.  */   static voidc free_child (child)"      register struct child *child; {*    if (child->command_lines != 0)     {        register unsigned int i;=       for (i = 0; i < child->file->cmds->ncommand_lines; ++i)n  	free (child->command_lines[i]);+       free ((char *) child->command_lines);      }i     if (child->environment != 0)     {_.       register char **ep = child->environment;       while (*ep != 0) 	free (*ep++);)       free ((char *) child->environment);x     }      free ((char *) child); }             6 /* Start a job to run the commands specified in CHILD.L    CHILD is updated to reflect the commands and ID of the child process.  */   static void  start_job (child)e"      register struct child *child; {;   static int bad_stdin = -1;   char *end;   register char *p;=   int backslash;   char noprint = 0, recursive;
 #ifdef VMS
   char *argv;i #else    char **argv; #endif  ?   /* Set RECURSIVE if the unexpanded line contains $(MAKE).  */tD   recursive = child->file->cmds->lines_recurse[child->command_line];  =   if (child->command_ptr == 0 || *child->command_ptr == '\0')      {sC       /* There are no more lines in the expansion of this line.  */dC       if (child->command_line == child->file->cmds->ncommand_lines)s 	{1 	  /* There are no more lines to be expanded.  */  	  child->command_ptr = 0;, 	  child->file->command_state = cs_finished;" 	  child->file->update_status = 0;
 	  return; 	}
       else! 	/* Get the next line to run.  */oB 	child->command_ptr = child->command_lines[child->command_line++];     }d  K   /* Find the end of this line.  Backslash-newlines don't mean the end.  */      end = child->command_ptr;    while (*end != '\0')     {m       p = index (end, '\n');       if (p == 0)n 	{ 	  end += strlen (end);d	 	  break;. 	}         end = p;       backslash = 0;       while (*--p == '\\') 	backslash = !backslash;         if (backslash) 	{	 	  ++end;r2 	  /* If there is a tab after a backslash-newline,6 	     remove it, since it was most likely used to line6 	     up the continued line with the previous one.  */ 	  if (*end == '\t') 	    strcpy (end, end + 1);r 	}
       else 	break;t     }t     p = child->command_ptr;e     if (*end == '\0')      child->command_ptr = 0;u   else     {h       *end = '\0';#       child->command_ptr = end + 1;      }I     child->noerror = 0;n   while (*p != '\0')     {C       if (*p == '@')
 	noprint = 1;d       else if (*p == '-')  	child->noerror = 1;       else if (*p == '+')n 	recursive = 1;I'       else if (*p != ' ' && *p != '\t')  	break;e
       ++p;     }   :   /* If -q was given, just say that updating `failed'.  */"   if (question_flag && !recursive)     goto error;   9   /* There may be some preceding whitespace left if there_7      was nothing but a backslash on the first line.  */0   p = next_token (p);p     if (*p == '\0')c     {iB       /* There were no commands on this line.  Go to the next.  */m #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */t       start_job (child); #endif
       return;/     }m     /* Print out the command.  */d  4   if (just_print_flag || (!noprint && !silent_flag))
     puts (p);G  G   /* If -n was given, recurse to get the next line in the sequence.  */H  $   if (just_print_flag && !recursive)     {nm #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */e       start_job (child); #endif
       return;      }k  2   /* Collapse backslash-newlines in this line.  */     collapse_continuations (p);o  <   /* Figure out an argument list from this command line.  */  
 #ifdef VMS   argv = p;  #elsed1   argv = construct_command_argv (p, child->file);_ #endif     if (argv == 0)     {tm #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */M8       /* This line has no commands.  Go to the next.  */       start_job (child); #endif
       return;l     }   J   /* Flush the output streams so they won't have things written twice.  */     fflush (stdout);   fflush (stderr);    #ifndef VMS C   /* Set up a bad standard input that reads from a broken pipe.  */e     if (bad_stdin == -1)     { F       /* Make a file descriptor that is the read end of a broken pipe.< 	 This will be used for some children's standard inputs.  */       int pd[2];       if (pipe (pd) == 0)g 	{ 	  /* Close the write side.  */b 	  (void) close (pd[1]); 	  /* Save the read side.  */e 	  bad_stdin = pd[0];b 	}     }d  @   /* Decide whether to give this child the `good' standard inputD      (one that points to the terminal or whatever), or the `bad' one7      that points to the read side of a broken pipe.  */;  '   child->good_stdin = !good_stdin_used;e   if (child->good_stdin)     good_stdin_used = 1; #endif /* VMS */     child->deleted = 0;d  .   /* Set up the environment for the child.  */   if (child->environment == 0):     child->environment = target_environment (child->file);     if (start_remote_job_p ())     { $       int is_remote, id, used_stdin;D       if (start_remote_job (argv, child->good_stdin ? 0 : bad_stdin,% 			    &is_remote, &id, &used_stdin))d 	goto error;
       else 	{( 	  if (child->good_stdin && !used_stdin) 	    { 	      child->good_stdin = 0;  	      good_stdin_used = 0;o 	    } 	  child->remote = is_remote;e 	  child->pid = id;i 	}     }s   else     { '       if (child->command_line - 1 == 0)e 	{0 	  /* Wait for the load to be low enough if this/ 	     is the first command in the sequence.  */_ 	  make_access (); 	  wait_to_start_job (); 	  user_access (); 	}  $       /* Fork the child process.  */         child->remote = 0;
 #ifdef VMS-       if (!child_execute_job (argv, child)) {m 	  /* Fork failed!  */% 	  perror_with_name (VFORK_NAME, "");> 	  goto error;       }d #else_       child->pid = vfork ();       if (child->pid == 0) 	/* We are the child side.  */9 	child_execute_job (child->good_stdin ? 0 : bad_stdin, 1,   			   argv, child->environment);       else if (child->pid < 0) 	{ 	  /* Fork failed!  */% 	  perror_with_name (VFORK_NAME, "");o 	  goto error; 	} #endif /* VMS */     }f  .   /* We are the parent side.  Set the state to1      say the commands are running and return.  */c  m #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */h*   child->file->command_state = cs_running; #endif  <   /* Free the storage used by the child's argument list.  */   #ifndef VMSh   free (argv[0]);e   free ((char *) argv);s #endif  	   return;h    error:;!   child->file->update_status = 1;o+   child->file->command_state = cs_finished;  }     G /* Create a `struct child' for FILE and start its commands running.  */l   void new_job (file)       register struct file *file; {b.   register struct commands *cmds = file->cmds;   register struct child *c;    char **lines;f   register unsigned int i;m #if defined(VMS) && !defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */0#   register struct child *lastc,*c1;k #endif  @   /* Chop the commands up into lines if they aren't already.  */   chop_commands (cmds);      if (job_slots > 0).     /* Wait for a job slot to be freed up.  */'     while (job_slots_used == job_slots)_       wait_for_children (1, 0);   A   /* Expand the command lines and store the results in LINES.  */.I   lines = (char **) xmalloc (cmds->ncommand_lines * sizeof (char *) + 1);o,   for (i = 0; i < cmds->ncommand_lines; ++i)J     lines[i] = allocated_variable_expand_for_file (cmds->command_lines[i], 						   file);i   lines[i] = 0;u  3   /* Start the command sequence, record it in a new 3      `struct child', and add that to the chain.  */(     push_signals_blocked_p (1);n  7   c = (struct child *) xmalloc (sizeof (struct child));i   c->file = file;n   c->command_lines = lines;a   c->command_line = 0;   c->command_ptr = 0;l   c->environment = 0;fm #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */c   start_job (c);   switch (file->command_state)     {h     case cs_running:       c->next = children;        children = c;g)       /* One more job slot is in use.  */l       ++job_slots_used;+       break;       case cs_finished:        free_child (c);i"       notice_finished_file (file);       break;       default:C       error ("internal error: `%s' command_state == %d in new_job",p- 	     file->name, (int) file->command_state);i       abort ();x       break;     }c     pop_signals_blocked_p ();   :   if (job_slots == 1 && file->command_state == cs_running)     {pD       /* Since there is only one job slot, make things run linearly.G 	 Wait for the child to finish, setting the state to `cs_finished'.  */t0       while (file->command_state != cs_finished) 	wait_for_children (1, 0);     }r #elset-   while (c->command_lines[c->command_line]) {e       start_job(c);    }f2   start_job(c); /* To finish off the last stuff */     pop_signals_blocked_p ();   >   /* Set the state flag to say the commands have finished.  */'   c->file->command_state = cs_finished;p!   notice_finished_file (c->file);e  5   /* Remove the child from the chain and free it.  */    children = 0;m   free_child (c);> #endif }>                                
 #ifdef VMS #include <descrip.h> #include <clidef.h>m  C /* This is called as an AST when a child process dies (it won't geti6    interrupted by anything except a higher level AST). */+ int vmsHandleChildTerm(struct child *child)t {      int status;n%     register struct child *lastc, *c;      int child_failed;   1     vms_jobsefnmask &= ~(1 << (child->efn - 32));        lib$free_ef(&child->efn);h       block_signals ();m  8 #ifndef VMS /* for now the shell function doesnt work */>     /* Check if this is the child of the `shell' function.  */$     if (pid == shell_function_pid) {< 	/* It is.  Leave an indicator for the `shell' function.  */: 	if (!(child->cstatus & 1 || ((child->cstatus & 7) == 0)))! 	  shell_function_completed = -1;l 	elses  	  shell_function_completed = 1;     }i #endif  H     child_failed = !(child->cstatus & 1 || ((child->cstatus & 7) == 0));  8     /* Search for a child matching the deceased one.  */     lastc = 0;m #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */ E     for (c = children; c != 0 && c != child; lastc = c, c = c->next);( #else@     c = child; #endif  =     if (child_failed && !c->noerror && !ignore_errors_flag) {=1 	/* The commands failed.  Write an error message,&/ 	   delete non-precious targets, and abort.  */ 2 	child_error (c->file->name, c->cstatus, 0, 0, 0); 	c->file->update_status = 1; 	delete_child_targets (c);     }*
     else { 	if (child_failed) {3 	    /* The commands failed, but we don't care.  */h6 	    child_error (c->file->name, c->cstatus, 0, 0, 1); 	    child_failed = 0; 	}  m #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */v= 	/* If there are more commands to run, try to start them.  */  	start_job (c);i  " 	switch (c->file->command_state) { 	  case cs_running:c! 	    /* Successfully started.  */a 	    break;t   	  case cs_finished:' 	    if (c->file->update_status != 0) {s) 		/* We failed to start the commands.  */H 		delete_child_targets (c);! 	    } 	    break;i   	  default: 1 	    error ("internal error: `%s' command_state \ % %d in child_handler", c->file->name);e 	    abort (); 	    break;e 	} #endif     }   m #if !defined(VMS) || defined(RECURSIVEJOBS) /* I've had problems with recursive stuff and process handling */u@     /* Set the state flag to say the commands have finished.  */)     c->file->command_state = cs_finished;d#     notice_finished_file (c->file);   7     /* Remove the child from the chain and free it.  */I     if (lastc == 0)r       children = c->next;      else       lastc->next = c->next;     free_child (c);  #endif  *     /* There is now another slot open.  */     --job_slots_used;   A     /* If the job failed, and the -k flag was not given, die.  */w)     if (child_failed && !keep_going_flag)t       die (EXIT_FAILURE);        unblock_signals ();p  
     return 1;m }b  G /* Spawn a process executing the command in ARGV and return its pid. */s into child_execute_job (argv, child)n      char *argv;      struct child *child;' {t
     int i;*     static struct dsc$descriptor_s cmddsc; #ifndef DONTWAITFORCHILD     int spflags = 0; #elsed     int spflags = CLI$M_NOWAIT;r #endif     int status;d     char cmd[4096],*p,*c;    /* Remove backslashes */*     for (p = argv, c = cmd; *p; p++,c++) { 	if (*p == '\\') p++;t	 	*c = *p;w     })     *c = *p;  &     cmddsc.dsc$w_length = strlen(cmd);     cmddsc.dsc$a_pointer = cmd;g'     cmddsc.dsc$b_dtype = DSC$K_DTYPE_T;l'     cmddsc.dsc$b_class = DSC$K_CLASS_S;        child->efn = 0;h0     while (child->efn < 32 || child->efn > 63) {" 	status = lib$get_ef(&child->efn); 	if (!(status & 1))h 	    return 0;     }e       sys$clref(child->efn);  0     vms_jobsefnmask |= (1 << (child->efn - 32));   #ifdef MIKESJOBDEBUG*     fprintf(stderr,"spawning child...\n");     fflush(stderr);t #endif #ifndef DONTWAITFORCHILDJ     status = lib$spawn(&cmddsc,0,0,&spflags,0,&child->pid,&child->cstatus, 		       &child->efn,0,0);     vmsHandleChildTerm(child); #elsesJ     status = lib$spawn(&cmddsc,0,0,&spflags,0,&child->pid,&child->cstatus,/ 		       &child->efn,vmsHandleChildTerm,child);l #endif #ifdef MIKESJOBDEBUG&     fprintf(stderr,"child spawned\n");     fflush(stderr);m #endif       if (!(status & 1)) {' 	printf("Error spawning, %d\n",status);u 	fflush(stdout);     }        return (status & 1); }/ #else F /* Replace the current process with one executing the command in ARGV.M    STDIN_FD and STDOUT_FD are used as the process's stdin and stdout; ENVP istJ    the environment of the new program.  This function does not return.  */   void3 child_execute_job (stdin_fd, stdout_fd, argv, envp)(      int stdin_fd, stdout_fd;i      char **argv, **envp;e {r   if (stdin_fd != 0)     (void) dup2 (stdin_fd, 0);   if (stdout_fd != 1)o     (void) dup2 (stdout_fd, 1);   "   /* Free up file descriptors.  */   {      register int d;e     int max = getdtablesize ();s     for (d = 3; d < max; ++d)        (void) close (d);n   }S  1   /* Don't block signals for the new process.  */    unblock_signals ();c     /* Run the command.  */l   exec_command (argv, envp); }e #endif                           #ifndef VMS' /* Search PATH for FILE.B    If successful, store the full pathname in PROGRAM and return 1.%    If not sucessful, return zero.  */u  
 static int! search_path (file, path, program)=!      char *file, *path, *program;  {r#   if (path == 0 || path[0] == '\0')m     path = default_path;     if (index (file, '/') != 0)t     {l       strcpy (program, file);        return 1;f     }d   else     {s       unsigned int len;*   #ifndef	USGi       extern int getgroups ();#       static GID_T groups[NGROUPS];I       static int ngroups = -1;       if (ngroups == -1)' 	ngroups = getgroups (NGROUPS, groups);k #endif	/* Not USG.  */         len = strlen (file) + 1;       do 	{ 	  struct stat st; 	  int perm; 	  char *p;t   	  p = index (path, ':');  	  if (p == 0) 	    p = path + strlen (path);   	  if (p == path)   	    bcopy (file, program, len); 	  elsen 	    {' 	      bcopy (path, program, p - path);S 	      program[p - path] = '/';o3 	      bcopy (file, program + (p - path) + 1, len);o 	    }   	  if (stat (program, &st) == 0  	      && S_ISREG (st.st_mode))x 	    {# 	      if (st.st_uid == geteuid ())	 		perm = (st.st_mode & 0100); ( 	      else if (st.st_gid == getegid ()) 		perm = (st.st_mode & 0010);, 	      else  		{e #ifndef	USG  		  register int i;k! 		  for (i = 0; i < ngroups; ++i))! 		    if (groups[i] == st.st_gid)  		      break; 		  if (i < ngroups)! 		    perm = (st.st_mode & 0010);  		  else #endif	/* Not USG.  */! 		    perm = (st.st_mode & 0001);d 		}d   	      if (perm != 0)a 		return 1;t 	    }   	  path = p + 1; 	} while (*path != '\0');      }      return 0;o }n #endif /* VMS */  
 #ifdef VMSD /* Replace the current process with one running the command in ARGV,=    with environment ENVP.  This function does not return.  */    void exec_command (argv, envp)       char **argv, **envp;  {i     /* Run the program.  */ !     execve (argv[0], argv, envp);o+     perror_with_name ("execve: ", argv[0]);i     _exit (EXIT_FAILURE);a }  #elseiD /* Replace the current process with one running the command in ARGV,=    with environment ENVP.  This function does not return.  */_   void exec_command (argv, envp)       char **argv, **envp;j {s   char *shell, *path;n   char program[MAXPATHLEN];t   register char **ep;t     shell = path = 0;*!   for (ep = envp; *ep != 0; ++ep)e     {f3       if (shell == 0 && !strncmp(*ep, "SHELL=", 6))  	shell = &(*ep)[6];i6       else if (path == 0 && !strncmp(*ep, "PATH=", 5)) 	path = &(*ep)[5];'       else if (path != 0 && shell != 0)n 	break;e     }      /* Be the user.  */a   user_access ();d  ,   if (!search_path (argv[0], path, program))-     error ("%s: Command not found", argv[0]);)   else     {v       /* Run the program.  */f#       execve (program, argv, envp);e         if (errno == ENOEXEC)  	{/ 	  char shell_program[MAXPATHLEN], *shell_path;i 	  if (shell == 0)  	    shell_path = default_shell; 	  elsea 	    {4 	      if (search_path (shell, path, shell_program)) 		shell_path = shell_program;/ 	      elsel 		{d 		  shell_path = 0;i1 		  error ("%s: Shell program not found", shell);l 		}s 	    }   	  if (shell_path != 0)  	    { 	      char **new_argv;i 	      int argc;   	      argc = 1; 	      while (argv[argc] != 0)	 		++argc;i  F 	      new_argv = (char **) alloca ((1 + argc + 1) * sizeof (char *));  	      new_argv[0] = shell_path; 	      new_argv[1] = program;l 	      while (argc > 0)i 		{e$ 		  new_argv[1 + argc] = argv[argc]; 		  --argc;  		}i  + 	      execve (shell_path, new_argv, envp);)1 	      perror_with_name ("execve: ", shell_path);e 	    } 	}
       else( 	perror_with_name ("execve: ", program);     }>     _exit (127); }d #endif /* VMS */               #ifndef VMS C /* Figure out the argument list necessary to run LINE as a command.SD    Try to avoid using a shell.  This routine handles only ' quoting.B    Starting quotes may be escaped with a backslash.  If any of theC    characters in sh_chars[] is seen, or any of the builtin commandsfF    listed in sh_cmds[] is the first word of a line, the shell is used.  >    SHELL is the shell to use, or nil to use the default shell.>    IFS is the value of $IFS, or nil (meaning the default).  */   static char **2 construct_command_argv_internal (line, shell, ifs)      char *line;      char *shell, *ifs;  { 1   static char sh_chars[] = "#;\"*?[]&|<>(){}=$`";cC   static char *sh_cmds[] = { "cd", "eval", "exec", "exit", "login", 9 			     "logout", "set", "umask", "wait", "while", "for",v4 			     "case", "if", ":", ".", "break", "continue",7 			     "export", "read", "readonly", "shift", "times",r 			     "trap", "switch", 0 };   register int i;>   register char *p;c   register char *ap;   char *end;   int instring;    char **new_argv = 0;  8   /* See if it is safe to parse commands internally.  */2   if (shell != 0 && strcmp (shell, default_shell))     goto slow;     if (ifs != 0)k%     for (ap = ifs; *ap != '\0'; ++ap)a3       if (*ap != ' ' && *ap != '\t' && *ap != '\n')  	goto slow;)     i = strlen (line) + 1;  5   /* More than 1 arg per character is impossible.  */R5   new_argv = (char **) xmalloc (i * sizeof (char *));   =   /* All the args can fit in a buffer as big as LINE is.   */m*   ap = new_argv[0] = (char *) xmalloc (i);   end = ap + i;i  :   /* I is how many complete arguments have been found.  */   i = 0;   instring = 0;d!   for (p = line; *p != '\0'; ++p)r     {        if (ap > end) 
 	abort ();         if (instring)x 	{E 	  /* Inside a string, just copy any char except a closing quote.  */  	  if (*p == '\'') 	    instring = 0; 	  elsea 	    *ap++ = *p; 	})       else if (index (sh_chars, *p) != 0)l5 	/* Not inside a string, but it's a special char.  */  	goto slow;i
       else 	/* Not a special char.  */a 	switch (*p) 	  {
 	  case '\\':i& 	    if (p[1] != '\0' && p[1] != '\n')/ 	      /* Copy and skip the following char.  */  	      *ap++ = *++p; 	    break;   
 	  case '\'':c 	    instring = 1; 	    break;   
 	  case '\n':O 	  case ' ':
 	  case '\t': ' 	    /* We have the end of an argument. / 	       Terminate the text of the argument.  */c 	    *ap++ = '\0'; 	    new_argv[++i] = ap;- 	    /* If this argument is the command name,p. 	       see if it is a built-in shell command., 	       If so, have the shell handle it.  */ 	    if (i == 1) 	      { 		register int j;D# 		for (j = 0; sh_cmds[j] != 0; ++j)s( 		  if (streq (sh_cmds[j], new_argv[0])) 		    goto slow; 	      }  - 	    /* Ignore multiple whitespace chars.  */l 	    p = next_token (p);B 	    /* Next iteration should examine the first nonwhite char.  */	 	    --p;s 	    break;h   	  default:; 	    *ap++ = *p; 	    break;p 	  }     }"     if (instring)"9     /* Let the shell deal with an unterminated quote.  */      goto slow;  ;   /* Terminate the last argument and the argument list.  */   
   *ap = '\0';0   if (new_argv[i][0] != '\0')i     ++i;   new_argv[i] = 0;     if (new_argv[0] == 0),     /* Line was empty.  */
     return 0;h   else     return new_argv;    slow:;d   /* We must use the shell.  */i     if (new_argv != 0)     { ;       /* Free the old argument list we were working on.  */i       free (new_argv[0]);s       free (new_argv);     }   3   if (shell == 0 || !strcmp (shell, default_shell))t     {eL       /* The shell is the default, or we're in a recursive call to constructD 	 the argument list for the real shell.  Construct a simple argument# 	 list using the default shell.  */ 9       new_argv = (char **) xmalloc (4 * sizeof (char *));sK       new_argv[0] = savestring (default_shell, sizeof (default_shell) - 1);n       new_argv[1] = "-c"; 5       new_argv[2] = savestring (line, strlen (line));1       new_argv[3] = 0;     }    else     {eE       /* SHELL may be a multi-word command.  Construct a command linee: 	 "SHELL -c LINE", with all special chars in LINE escaped.< 	 Then recurse, expanding this command line to get the final 	 argument list.  */  .       unsigned int shell_len = strlen (shell);%       static char minus_c[] = " -c "; ,       unsigned int line_len = strlen (line);       J       char *new_line = (char *) alloca (shell_len + (sizeof (minus_c) - 1) 					+ (line_len * 2) + 1);          ap = new_line;#       bcopy (shell, ap, shell_len);        ap += shell_len;0       bcopy (minus_c, ap, sizeof (minus_c) - 1);!       ap += sizeof (minus_c) - 1;f%       for (p = line; *p != '\0'; ++p)  	{ 	  if (*p == '\\' || *p == '\''u/ 	      || *p == ' ' || *p == '\t' || *p == '\n't$ 	      || index (sh_chars, *p) != 0) 	    *ap++ = '\\'; 	  *ap++ = *p; 	}       *ap = '\0';   ;       new_argv = construct_command_argv_internal (new_line,=  						  (char *) 0, (char *) 0);     }      return new_argv; }   C /* Figure out the argument list necessary to run LINE as a command. D    Try to avoid using a shell.  This routine handles only ' quoting.B    Starting quotes may be escaped with a backslash.  If any of theC    characters in sh_chars[] is seen, or any of the builtin commands F    listed in sh_cmds[] is the first word of a line, the shell is used.  ?    FILE is the target whose commands these are.  It is used for 2    variable expansion for $(SHELL) and $(IFS).  */   char ** # construct_command_argv (line, file)       char *line;      struct file *file;	 {mF   char *shell = allocated_variable_expand_for_file ("$(SHELL)", file);B   char *ifs = allocated_variable_expand_for_file ("$(IFS)", file);   char **argv;  <   argv = construct_command_argv_internal (line, shell, ifs);     free (shell);e
   free (ifs);.     return argv; }t #endif /* VMS */                                                              = #if	(defined(USG) && !defined(HAVE_SIGLIST)) || defined(DGUX)o /* Initialize sys_siglist.  */   void init_siglist ()e {p   char buf[100];   register unsigned int i;     for (i = 0; i < NSIG; ++i)     switch (i)       {        default: 	sprintf (buf, "Signal %u", i);a1 	sys_siglist[i] = savestring (buf, strlen (buf));  	break;c       case SIGHUP: 	sys_siglist[i] = "Hangup";( 	break;"       case SIGINT: 	sys_siglist[i] = "Interrupt"; 	break;a       case SIGQUIT:s 	sys_siglist[i] = "Quit";n 	break;,       case SIGILL:( 	sys_siglist[i] = "Illegal Instruction"; 	break;d       case SIGTRAP:  	sys_siglist[i] = "Trace Trap";j 	break;h       case SIGIOT: 	sys_siglist[i] = "IOT Trap";  	break;c
 #ifdef	SIGEMT        case SIGEMT: 	sys_siglist[i] = "EMT Trap";p 	break;f #endif #ifdef	SIGDANGER       case SIGDANGER: " 	sys_siglist[i] = "Danger signal"; 	break;t #endif       case SIGFPE:- 	sys_siglist[i] = "Floating Point Exception";t 	break;        case SIGKILL:e 	sys_siglist[i] = "Killed";  	break;s       case SIGBUS: 	sys_siglist[i] = "Bus Error"; 	break;)       case SIGSEGV:m' 	sys_siglist[i] = "Segmentation fault";v 	break;*       case SIGSYS:0 	sys_siglist[i] = "Bad Argument to System Call"; 	break;        case SIGPIPE:c  	sys_siglist[i] = "Broken Pipe"; 	break;i       case SIGALRM:   	sys_siglist[i] = "Alarm Clock"; 	break;        case SIGTERM:a 	sys_siglist[i] = "Terminated";r 	break;h( #if	!defined (SIGIO) || SIGUSR1 != SIGIO       case SIGUSR1:=* 	sys_siglist[i] = "User-defined signal 1"; 	break;) #endif* #if	!defined (SIGURG) || SIGUSR2 != SIGURG       case SIGUSR2:r* 	sys_siglist[i] = "User-defined signal 2"; 	break;i #endif
 #ifdef	SIGCLD	       case SIGCLD: #endif( #if	defined(SIGCHLD) && !defined(SIGCLD)       case SIGCHLD:n #endif) 	sys_siglist[i] = "Child Process Exited";r 	break; 
 #ifdef	SIGPWR>       case SIGPWR:" 	sys_siglist[i] = "Power Failure"; 	break;	 #endif #ifdef	SIGVTALRM       case SIGVTALRM:)( 	sys_siglist[i] = "Virtual Timer Alarm"; 	break;e #endif #ifdef	SIGPROF       case SIGPROF:"* 	sys_siglist[i] = "Profiling Alarm Clock"; 	break;e #endif #ifdef	SIGIO       case SIGIO: ! 	sys_siglist[i] = "I/O Possible";e 	break;o #endif #ifdef	SIGWINDOW       case SIGWINDOW: ) 	sys_siglist[i] = "Window System Signal";. 	break;t #endif #ifdef	SIGSTOP       case SIGSTOP:I% 	sys_siglist[i] = "Stopped (signal)";[ 	break;, #endif #ifdef	SIGTSTP       case SIGTSTP:n 	sys_siglist[i] = "Stopped"; 	break;  #endif #ifdef	SIGCONT       case SIGCONT:o 	sys_siglist[i] = "Continued"; 	break;  #endif #ifdef	SIGTTIN       case SIGTTIN:e( 	sys_siglist[i] = "Stopped (tty input)"; 	break;_ #endif #ifdef	SIGTTOU       case SIGTTOU:l) 	sys_siglist[i] = "Stopped (tty output)";c 	break;c #endif
 #ifdef	SIGURG)       case SIGURG:/ 	sys_siglist[i] = "Urgent Condition on Socket";" 	break;  #endif #ifdef	SIGXCPU       case SIGXCPU:i' 	sys_siglist[i] = "CPU Limit Exceeded";" 	break;k #endif #ifdef	SIGXFSZ       case SIGXFSZ:a- 	sys_siglist[i] = "File Size Limit Exceeded";i 	break;; #endif       }i } ' #endif	/* USG and not HAVE_SIGLIST.  */;  : #if	defined(USG) && !defined(USGr3) && !defined(HAVE_DUP2) inte dup2 (old, new)       int old, new; {l	   int fd;f     (void) close (new);h   fd = dup (old);)   if (fd != new)     {(       (void) close (fd);       errno = EMFILE;a       return -1;     }      return fd; }!2 #endif	/* USG and not USGr3 and not HAVE_DUP2.  */