$! "make" ZT* programs for VAX (assuming VMS V5.4 or greater), and for AXP
$!
$! w.j.m. 27-oct-1993 (AXP $LINK command after G.K.Newman's example driver)
$! mod 29-jan-1994 wjm: no longer require EVAX.MAR prefix
$! mod 31-jan-1994 wjm: add ZT1B0 (example server for "_ZTB0:")
$! mod 25-feb-1994 wjm: ZT1B0 obsoleted by new ZT1, add ZT1D/ZT1-D
$! mod 18-mar-1994 wjm: update for STEP2, LINK now from device support dev.guide
$! mod 29-jul-1994 wjm: new ZT4 uses UCX socket interface, no more NETLIB
$! mod 09-jan-1995 wjm: support DECC compilation on VAX
$! mod 06-feb-1995 wjm: link modified ZTNS2 with REDIRECT
$!------------------------------------------------------------------------------
$!
$ gosub := GOSUB
$ gosub mm_setup
$!
$ evax = f$getsyi("CPU").gt.127
$!
$ d_vaxcopt = "VAXC.OPT"			! assume VAXC on VAX
$ q_vaxcopt = ",SYS$DISK:[]VAXC.OPT/OPTION"
$ if evax
$ then
$	CC := CC/STANDARD=VAXC
$	d_vaxcopt = ""
$ 	q_vaxcopt = ""
$ else
$	if f$search("SYS$SYSTEM:DECC$COMPILER.EXE").nes.""
$	then
$		CC := CC/DECC/STANDARD=VAXC
$		d_vaxcopt = ""
$	 	q_vaxcopt = ""
$	endif
$ endif
$ if evax then MACRO := MACRO/MIGRATION/MACHINE
$!
$ q_sysexe = ""				! SYS.STB on VAX implicit via .LINK
$ if evax then q_sysexe = "/SYSEXE"
$ dep_sysexe = "SYS$SYSTEM:SYS.STB"
$ if evax then dep_sysexe = "SYS$LOADABLE_IMAGES:SYS$BASE_IMAGE.EXE"
$!
$!
$!*****	macro library is common to VAX and AXP
$!
$ mm_target 	ZT.MLB
$ mm_depend	ZTDEF.MAR
$ mm_do write SYS$ERROR "Creating ZT.MLB ..."
$ mm_do	library/log/macro/create=block=0 ZT.MLB ZTDEF.MAR
$!
$!
$!*****	make the driver (architecture-dependent)
$!
$ mm_target	ZT_DRIVER.OBJ
$ mm_depend	ZT_DRIVER.MAR
$ mm_depend	ZT.MLB	SYS$LIBRARY:LIB.MLB
$ if evax
$ then
$	mm_do write SYS$ERROR "... Expect 5 %AMAC-I diagnostic messages ..."
$ endif
$ mm_do write SYS$ERROR "Compiling ZT_DRIVER ..."
$ mm_do	macro ZT_DRIVER.MAR/list/object
$!
$ mm_target	ZT_DRIVER.EXE
$ mm_depend	ZT_DRIVER.OBJ
$ mm_depend	'dep_sysexe'
$ if evax then mm_depend	SYS$LIBRARY:STARLET.OLB
$ mm_if_required
$ then
$	write SYS$ERROR "Linking ZT_DRIVER ..."
$	if evax 
$	then
$	 	link/native/bpage=14/section/notrace/nodemand/nosysshr -
			/sysexe/share=ZT_DRIVER.EXE/map=ZT_DRIVER.MAP/full -
				SYS$INPUT:/options
cluster=ZT_DRIVER,,,-
	ZT_DRIVER.OBJ,-
	SYS$LIBRARY:VMS$VOLATILE_PRIVATE_INTERFACES.OLB/LIB,-
	SYS$LIBRARY:STARLET.OLB/include=(SYS$DOINIT,SYS$DRIVER_INIT)

collect=NONPAGED_READONLY_PSECTS/attributes=resident,-
	$$$115_DRIVER,-
        $CODE$

psect_attr=$LINK$,		wrt
psect_attr=$INITIAL$,		wrt
psect_attr=$LITERAL$,		nopic,noshr,wrt
psect_attr=$READONLY$,		nopic,noshr,wrt
psect_attr=$$$105_PROLOGUE,	nopic
psect_attr=$$$110_DATA,		nopic
psect_attr=$$$115_LINKAGE,	wrt

collect=NONPAGED_READWRITE_PSECTS/attributes=resident,-
	$$$105_PROLOGUE,-
	$$$110_DATA,-
	$$$115_LINKAGE,-
        $PLIT$,-
        $GLOBAL$,-
        $OWN$,-
	$INITIAL$,-
        $LINK$,-
	$BSS$,-
	$DATA$,-
	$LITERAL$,-
	$READONLY$

psect_attr=EXEC$INIT_CODE,	noshr
psect_attr=EXEC$INIT_LINKAGE,	pic,exe,wrt

collect=INITIALIZATION_PSECTS/attributes=initialization_code,-
        EXEC$INIT_LINKAGE,-
        EXEC$INIT_CODE,-
        EXEC$INIT_000,-
        EXEC$INIT_001,-
        EXEC$INIT_002,-
        EXEC$INIT_SSTBL_000,-
        EXEC$INIT_SSTBL_001,-
        EXEC$INIT_SSTBL_002
$!
$	else
$		write SYS$ERROR "... Expect 1 %LINK-W diagnostic message ..."
$		on error then goto mm__error
$ 		link ZT_DRIVER.OBJ/map/full,SYS$INPUT:/options
base=0
$		on warning then goto mm__error
$	endif
$ endif
$!
$!
$!*****	kernel mode stuff code used by 'server' images
$!
$ mm_target	ZTSERVER.OBJ
$ mm_depend	ZTSERVER.MAR
$ mm_depend	ZT.MLB	SYS$LIBRARY:LIB.MLB
$ mm_do write SYS$ERROR "Compiling ZTSERVER ..."
$ mm_do	macro ZTSERVER.MAR/list/object
$!
$!
$!*****	make some header files required by C programs
$!
$! NOTE: ZT.H _must_ reflect ZTDEF.MAR,
$!	but I can't generate it automatically ...
$!
$ mm_target	MTDEF.H	IODEF.H
$ mm_depend	SYS$LIBRARY:STARLET.MLB
$ mm_do write SYS$ERROR "Generating MTDEF.H and IODEF.H ..."
$ mm_do	@GENDEF.COM	MTDEF
$ mm_do	@GENDEF.COM	IODEF
$!
$ mm_target	UCBDEF.H		! not as critical as it seems,
$ mm_depend	SYS$LIBRARY:LIB.MLB	! since only UCB$M_VALID is used,
$ mm_do write SYS$ERROR "Generating UCBDEF.H ..."
$ mm_do	@GENDEF.COM	UCBDEF		! and that's unlikely to ever change
$!
$!
$!*****	a few subroutines
$!
$ mm_target	FEHLER.OBJ		! FEHLER = German for "error"
$ mm_depend	FEHLER.C
$ mm_do write SYS$ERROR "Compiling FEHLER.C ..."
$ mm_do	cc FEHLER.C
$!
$ mm_target	REDIRECT.OBJ
$ mm_depend	REDIRECT.C
$ mm_do write SYS$ERROR "Compiling REDIRECT.C ..."
$ mm_do	cc REDIRECT.C
$!
$!
$!*****	"memory tape" & "disk tape" servers (great for tests ...)
$!
$ mm_target	ZT1.OBJ
$ mm_depend	ZT1.C
$ mm_depend	ZT.H	UCBDEF.H	MTDEF.H	IODEF.H
$ mm_do write SYS$ERROR "Compiling ZT1 ..."
$ mm_do	cc ZT1.C
$!
$ mm_target	ZT1T.OBJ
$ mm_depend	ZT1T.C
$ mm_do write SYS$ERROR "Compiling ZT1T ..."
$ mm_do	cc ZT1T.C
$!
$ mm_target	ZT1D.OBJ
$ mm_depend	ZT1D.C
$ mm_do write SYS$ERROR "Compiling ZT1D ..."
$ mm_do	cc ZT1D.C
$!
$ mm_target	ZT1.EXE
$ mm_depend	ZT1.OBJ	ZT1T.OBJ
$ mm_depend	ZTSERVER.OBJ
$ mm_depend	FEHLER.OBJ	REDIRECT.OBJ	'd_vaxcopt'
$ mm_do write SYS$ERROR "Linking ZT1 ..."
$ mm_do	link'q_sysexe' ZT1.OBJ,ZT1T.OBJ,ZTSERVER.OBJ,-
			FEHLER.OBJ,REDIRECT.OBJ 'q_vaxcopt'
$!
$ mm_target	ZT1-D.EXE
$ mm_depend	ZT1.OBJ	ZT1D.OBJ
$ mm_depend	ZTSERVER.OBJ
$ mm_depend	FEHLER.OBJ	REDIRECT.OBJ	'd_vaxcopt'
$ mm_do write SYS$ERROR "Linking ZT1-D ..."
$ mm_do	link'q_sysexe' ZT1.OBJ,ZT1D.OBJ/exe=ZT1-D.EXE,ZTSERVER.OBJ,-
			FEHLER.OBJ,REDIRECT.OBJ 'q_vaxcopt'
$!
$!
$!*****	DECnet-based "remote tape" server
$!
$ mm_target	ZT2.OBJ
$ mm_depend	ZT2.C
$ mm_depend	ZT.H	ZTNS.H	UCBDEF.H	MTDEF.H	IODEF.H
$ mm_do write SYS$ERROR "Compiling ZT2 ..."
$ mm_do	cc ZT2.C
$!
$ mm_target	ZT2.EXE
$ mm_depend	ZT2.OBJ
$ mm_depend	ZTSERVER.OBJ
$ mm_depend	FEHLER.OBJ	REDIRECT.OBJ	'd_vaxcopt'
$ mm_do write SYS$ERROR "Linking ZT2 ..."
$ mm_do	link'q_sysexe' ZT2.OBJ,ZTSERVER.OBJ,FEHLER.OBJ,REDIRECT.OBJ 'q_vaxcopt'
$!
$!
$!*****	DECnet-based VMS "remote tape" client
$!
$ mm_target	ZTNS2.OBJ
$ mm_depend	ZTNS2.C
$ mm_depend	ZTNS.H	MTDEF.H	IODEF.H
$ mm_do write SYS$ERROR "Compiling ZTNS2 ..."
$ mm_do	cc ZTNS2.C
$!
$ mm_target	ZTNS2.EXE
$ mm_depend	ZTNS2.OBJ
$ mm_depend	FEHLER.OBJ	REDIRECT.OBJ	'd_vaxcopt'
$ mm_do write SYS$ERROR "Linking ZTNS2 ..."
$ mm_do	link ZTNS2.OBJ,FEHLER.OBJ,REDIRECT.OBJ 'q_vaxcopt'
$!
$!
$!****************** some more "private" programs ******************************
$!
$ if f$search("ZT1T20.C").eqs."" then goto skip_zt1t20
$!
$ mm_target	ZT1T20.OBJ
$ mm_depend	ZT1T20.C
$ mm_do write SYS$ERROR "Compiling ZT1T20 ..."	! ZT offline (20s) after UNLOAD
$ mm_do	cc ZT1T20.C
$!
$ mm_target	ZT1T20.EXE
$ mm_depend	ZT1.OBJ	ZT1T20.OBJ
$ mm_depend	ZTSERVER.OBJ
$ mm_depend	FEHLER.OBJ	REDIRECT.OBJ	'd_vaxcopt'
$ mm_do write SYS$ERROR "Linking ZT1T20 ..."
$ mm_do	link'q_sysexe' ZT1.OBJ,ZT1T20.OBJ/exe,ZTSERVER.OBJ,-
				FEHLER.OBJ,REDIRECT.OBJ 'q_vaxcopt'
$skip_zt1t20:
$!
$!
$ if f$search("ZT4.C").eqs."" then goto skip_zt4
$ if f$search("SYS$SHARE:UCX$IPC_SHR.EXE").eqs.""
$ then
$	write SYS$ERROR "=== UCX$IPC_SHR.EXE not found, ZT4_UCX not made ==="
$	goto skip_zt4
$ endif
$ if EVAX
$ then
$	ucx_ipc_lib = ""
$ else
$	if f$search("SYS$SHARE:UCX$IPC.OLB").eqs.""
$	then
$		write SYS$ERROR "=== UCX$IPC.OLB not found, ZT4_UCX not made ==="
$		goto skip_zt4
$	endif
$	ucx_ipc_lib = ",SYS$SHARE:UCX$IPC/lib"
$ endif
$!
$ mm_target	ZT4_UCX.OBJ
$ mm_depend	ZT4.C
$ mm_depend	ZT.H	ZTNS4.H	UCBDEF.H	MTDEF.H	IODEF.H
$ mm_do write SYS$ERROR "Compiling ZT4 (for UCX) ..."	! ZT server via TCP/IP
$ mm_do	cc ZT4.C/object=ZT4_UCX.OBJ
$!
$ mm_target	ZT4_UCX.EXE
$ mm_depend	ZT4_UCX.OBJ
$ mm_depend	ZTSERVER.OBJ
$ mm_depend	FEHLER.OBJ	REDIRECT.OBJ	'd_vaxcopt'
$ mm_do write SYS$ERROR "Linking ZT4_UCX ..."
$ mm_do	link'q_sysexe' ZT4_UCX.OBJ,ZTSERVER.OBJ,FEHLER.OBJ,REDIRECT.OBJ-
			'ucx_ipc_lib' 'q_vaxcopt'
$skip_zt4:
$!
$!
$!******************************************************************************
$!
$ gosub mm_cleanup
$!
$ exit
$!
$!------------------------------------------------------------------------------
$! subroutines for "make"-like dependency checking
$! w.j.m. 27-oct-1993
$!
$! naming convention (both symbols and labels):
$!	mm_*	=> intended for use
$!	mm__*	=> visible locally (not to be used)
$!	mm___*	=> global symbols (not to be used)
$!
$mm_setup: mm__verify_p = 'f$verify(0,f$environ("verify_image"))'	! GOSUB
$ mm__verify_i = f$environ("verify_image")
$ set = "set"
$ set symbol/scope=(noglobal,nolocal)/verb
$ set symbol/scope=(global,local)/general
$ if "''mm___debug'" then set verify
$ mm_target = "call mm__target"		! usage: $ mm_target file[,...] ...
$ mm_depend = "call mm__depend"		! usage: $ mm_depend file[,...] ...
$ mm_do = "if mm___reqd then"		! usage: $ mm_do command
$ mm_if_required = "if mm___reqd"	! usage: $ mm_if_required
$!					!	 $ then ...
$ mm__starttime = f$cvtim("")
$ mm___targetlist == ""
$ on warning then goto mm__error
$ on control_y then goto mm__ctly
$ return 1.or.f$verify(mm__verify_p,mm__verify_i)
$!
$mm_cleanup: ! 'f$verify(0,0)'						! GOSUB
$ if "''mm___debug'" then set verify
$ if f$type(mm___targetlist).nes."" then delete/symbol/global mm___targetlist
$ if f$type(mm___tdate).nes."" then delete/symbol/global mm___tdate
$ if f$type(mm___reqd).nes."" then delete/symbol/global mm___reqd
$ return 1.or.f$verify(mm__verify_p,mm__verify_i)
$!
$!
$mm__target:	subroutine	! 'f$verify(0,0)'
$ if "''mm___debug'" then set verify
$ mm___targetlist == ""
$ mm___tdate == "9999-99-99"		! w/o target, no reason to build
$ mm___reqd == 0
$ args = f$edit(p1+","+p2+","+p3+","+ p4+","+ p5+","+p6+","+p7+","+p8,-
		"collapse,trim")
$ i = 0
$aloop:
$ arg = f$element(i,",",args)
$ if arg.eqs."," then goto aloop_end
$ if arg.nes.""
$ then
$	if f$search(arg).eqs.""
$	then
$		mm___tdate == " "	! target missing
$		mm___reqd == 1
$	else
$		rdt = f$cvtim(f$file(arg,"rdt"))
$		if rdt.lts.mm___tdate then mm___tdate == rdt
$	endif
$ endif
$ i = i + 1
$ goto aloop
$aloop_end:
$ mm___targetlist == args
$ exit 1.or.f$verify(mm__verify_p,mm__verify_i)
$ endsubroutine
$!
$!
$mm__depend:	subroutine	! 'f$verify(0,0)'
$ if "''mm___debug'" then set verify
$ on warning then exit $status + f$verify(mm__verify_p,mm__verify_i)*0
$ args = f$edit(p1+","+p2+","+p3+","+ p4+","+ p5+","+p6+","+p7+","+p8,-
		"collapse,trim")
$ i = 0
$aloop:
$ arg = f$element(i,",",args)
$ if arg.eqs."," then goto aloop_end
$ if arg.nes.""
$ then
$	if f$cvtim(f$file(arg,"rdt")).gts.mm___tdate then mm___reqd == 1
$ endif
$ i = i + 1
$ goto aloop
$aloop_end:
$ exit 1.or.f$verify(mm__verify_p,mm__verify_i)
$ endsubroutine
$!
$!
$!-----	error handler, will delete curerent target(s) and exit
$!	... so we need not care for symbol naming here
$!
$mm__error: ! 'f$verify(0,0)'						! GOTO
$ xstat = $status
$ goto mm__handler
$mm__ctly: ! 'f$verify(0,0)'						! GOTO
$ xstat = %x00000614			! F, SS$_CONTROLY
$mm__handler:
$ if "''mm___debug'" then set verify
$ set noon
$ if f$type(mm__starttime).eqs."" then goto mm__handler_del_done
$ if f$type(mm___targetlist).eqs."" then goto mm__handler_del_done
$ i = 0
$mm__handler_del_loop:				! ... delete targets on error
$ arg = f$element(i,",",mm___targetlist)
$ if arg.eqs."," then goto mm__handler_del_done
$ if arg.nes.""
$ then
$	fn = f$search(arg)
$	if fn.nes.""
$	then
$		cdt = f$cvtim(f$file(fn,"cdt"))
$		if cdt.ges.mm__starttime then delete/log 'fn'
$	endif
$ endif
$ i = i + 1
$ goto mm__handler_del_loop
$mm__handler_del_done:
$ gosub mm_cleanup
$ exit xstat
$ stop
