 /* OS_VMS.C */ /* Boilerplate header.	*/  #include	<unixio.h>  #include	<stat.h>    #include	"headers.h"   #include <netdb.h>   /* Can Access file */ H /*----------------------------------------------------------------------3        Check if we can access a file in a given way   '    Args: file      -- The file to check N          mode      -- The mode ala the access() system call, see ACCESS_EXISTS,                       and friends in pine.h.  I  Result: returns 0 if the user can access the file according to the mode, +          -1 if he can't (and errno is set).   ----*/  int  can_access(file, mode)     char *file;      int   mode;  {      return(access(file, mode));  }          /* File Size */ H /*----------------------------------------------------------------------.       Return the number of bytes in given file       Args: file -- file name   8   Result: the number of bytes in the file is returned or3           -1 on error, in which case errno is valid   ----*/  long file_size(file)      char *file;  {      struct stat buffer;   !     if (stat(file, &buffer) != 0)          return(-1L);     return(buffer.st_size);  }         6 /* Is_writable_dir function.  Return success always */ is_writable_dir(char *s) { 
 	return 0; }   H /*----------------------------------------------------------------------#       Create the mail subdirectory.   .   Args: dir -- Name of the directory to create   F  Result: Directory is created.  Returns 0 on success, else -1 on error 	 and errno is valid.    ----*/ create_mail_dir(dir)     char *dir; {      if(mkdir(dir, 0700) < 0)       return(-1);        (void)chmod(dir, 0700);      return(0); }       H /*----------------------------------------------------------------------       Rename a file   $   Args: tmpfname -- Old name of file$         fname    -- New name of file   A  Result: File is renamed.  Returns 0 on success, else -1 on error  	 and errno is valid.    ----*/ rename_file(tmpfname, fname)     char *tmpfname, *fname;  { $     return(rename(tmpfname, fname)); }       H /*----------------------------------------------------------------------3       Paste together two pieces of a file name path   +   Args: pathbuf      -- Put the result here $         first_part   -- of path name$         second_part  -- of path name   A  Result: New path is in pathbuf.  No check is made for overflow.    O BUGS:  This is a first stab at dealing with fs naming dependencies, and others   still exist.   ----*/ void, build_path(pathbuf, first_part, second_part)-     char *pathbuf, *first_part, *second_part;  { 
     int n;       if (first_part == NULL) *       sprintf(pathbuf, "%s", second_part);  >     else if ((n=strlen(first_part)) && first_part[n-1] == '/')?       sprintf(pathbuf, "%.*s%s", n-1, first_part, second_part);        else8       sprintf(pathbuf, "%s%s", first_part, second_part); }    char *fnexpand(buf, len)
 char	*buf; int	len; { %     return(len ? buf : (char *)NULL);  }     H /*----------------------------------------------------------------------3       Return pointer to last component of pathname.   %   Args: filename     -- The pathname.    I  Result: Returned pointer points to last component in the input argument.    ----*/ char * last_cmpnt(filename)     char *filename;  {      register char *p;   ?     for(p = filename + strlen(filename) -1; p > filename; p--){ '         if(*p == '/' && *(p+1) != '\0')            return(p+1);     }      return(p); }   $ /* On VMS - return the same name.	*/ int  expand_foldername(filename)      char *filename;  { 
 	return 1; }       H /*----------------------------------------------------------------------,     Filter file names for strange characters  )    Args:  file  -- the file name to check    (  Result: Returns NULL if file name is OK5          Returns formatted error message if it is not    ----*/ char * filter_filename(file)      char *file;  {  #ifdef ALLOW_WEIRD+     static char illegal[] = {'\177', '\0'};  #else H     static char illegal[] = {'"', '#', '$', '%', '&', '\'','(', ')','*',F                           ',', ':', ';', '<', '=', '>', '?', '[', ']',8                           '\\', '^', '|', '\177', '\0'}; #endif     static char error[100]; 6     char ill_file[MAXPATH+1], *ill_char, *ptr, e2[10];       ptr = file; 9     while (*ptr == ' ') ptr++;	/* leading spaces GONE! */        if(*ptr == '*') 7       ptr++; /* Allow * at beginning for news groups */   =     while(*ptr && *ptr > ' ' && strindex(illegal, *ptr) == 0)        ptr++;       if(*ptr != '\0') {         if(*ptr == ' ') { !             ill_char = "<space>"; !         } else if(*ptr == '\n') { #             ill_char = "<newline>"; !         } else if(*ptr == '\r') { +             ill_char = "<carriage return>"; !         } else if(*ptr == '\t') {      	    ill_char = "<tab>";         } else if(*ptr < ' ') { 2             sprintf(e2, "control-%c", *ptr + '@');             ill_char = e2;$         } else if (*ptr == '\177') {     	    ill_char = "<del>";         } else {     	    e2[0] = *ptr;     	    e2[1] = '\0';     	    ill_char = e2; 	         }          if(ptr != file) { 0             strncpy(ill_file, file, ptr - file);(             ill_file[ptr - file] = '\0';O             sprintf(error,"Character \"%s\" after \"%s\" not allowed",ill_char,                      ill_file);         } else {             sprintf(error,;                     "First character, \"%s\", not allowed",                      ill_char);	         }                       return(error);     }      return((char *)NULL);  }     H /*----------------------------------------------------------------------     Read whole file into memory   -   Args: filename -- path name of file to read   J   Result: Returns pointer to malloced memory with the contents of the file           or NULL   C This won't work very well if the file has NULLs in it and is mostly % intended for fairly small text files.   ----*/  char * read_file(filename)      char *filename;  { 
     FILE	*fd;      struct stat statbuf;"     char       *buf, record[1024];       fd = fopen(filename, "r");     if(fd == NULL)       return((char *)NULL);        stat(filename, &statbuf);   (     buf = fs_get(statbuf.st_size + 512);     *buf = '\0';  8     while(fgets(record, sizeof(record) - 1, fd) != NULL) 	strcat(buf, record);        fclose(fd);        return(buf); }   H /*----------------------------------------------------------------------B    Create a temporary file, the name of which we don't care about @ and that goes away when it is closed.  Just like ANSI C tmpfile.   ----*/ FILE  *  create_tmpfile() {      return(tmpfile()); }   H /*----------------------------------------------------------------------H       Return a unique file name in a given directory.  This is not quiteJ       the same as the usual tempnam() function, though it is very similar.I       We want it to use the TMP environment variable only if dir is NULL, 3       instead of using TMP regardless if it is set.   7   Args: dir      -- The directory to create the name in &         prefix   -- Prefix of the name   J  Result: Malloc'd string equal to new name is returned.  It must be free'dD 	 by the caller.  Returns the string on success and NULL on failure.   ----*/ char * temp_nam(dir, prefix)      char *dir, *prefix;  {  	char	*name;  1     if((name = malloc(512)) == NULL) return NULL;        if(dir == NULL) - 	sprintf(name, "SYS$LOGIN:%sXXXXXX", prefix);      else* 	sprintf(name, "%s%sXXXXXX", dir, prefix);     return(mktemp(name));  } H /*----------------------------------------------------------------------      Abort with a core dump   ----*/  void
 coredump() {      abort(); }     H /*----------------------------------------------------------------------        Call system gethostname  2   Args: hostname -- buffer to return host name in @         size     -- Size of buffer hostname is to be returned in  4  Result: returns 0 if the hostname is correctly set,&          -1 if not (and errno is set).  ----*/  hostname(hostname,size)      char *hostname; 
     int size;  { S     return get_local_host_name(hostname, size);	/* defined in C-CLIENT/OSDEP_VMS */  }     H /*----------------------------------------------------------------------,        Get the current host and domain names  8     Args: hostname   -- buffer to return the hostname in,           hsize      -- size of buffer above7           domainname -- buffer to return domain name in ,           dsize      -- size of buffer above  I   Result: The system host and domain names are returned. If the full host A           name is akbar.cac.washington.edu then the domainname is            cac.washington.edu.   C On Internet connected hosts this look up uses /etc/hosts and DNS to E figure all this out. On other less well connected machines some other C file may be read. If there is no notion of a domain name the domain D name may be left blank. On a PC where there really isn't a host name? this should return blank strings. The .pinerc will take care of B configuring the domain names. That is, this should only return theA native system's idea of what the names are if the system has such 
 a concept.  ----*/  void2 getdomainnames(hostname, hsize, domainname, dsize)      char *hostname, *domainname;     int   hsize, dsize;  { -     char           *dn, hname[MAX_ADDRESS+1];        *hostname = *hname = '\0';/     get_local_host_name(hostname, MAX_ADDRESS);   0     if((dn = strindex(hostname, '.')) != NULL) {+         strncpy(domainname, dn+1, dsize-1);      } else {/         strncpy(domainname, hostname, dsize-1);      }      domainname[dsize-1] = '\0';  }       H /*----------------------------------------------------------------------F        Return canonical form of host name ala c-client (UNIX version).  #    Args: host      -- The host name   7  Result: Canonical form, or input argument (worst case)   ----*/  char * canonical_name(host)     char *host;  {      struct hostent *hent;      char hostname[MAILTMPLEN];     char tmp[MAILTMPLEN];      extern char *lcase(); <                                 /* domain literal is easy */9     if (host[0] == '[' && host[(strlen (host))-1] == ']')        return host;  ?     strcpy (hostname,host);       /* UNIX requires lowercase */   H                                 /* lookup name, return canonical form */     return (host); }     H /*----------------------------------------------------------------------E      This routine returns 1 if job control is available.  Note, thiis C      could be some type of fake job control.  It doesn't have to be        real BSD-style job control.   ----*/ have_job_control() { 
     return 0;  }     H /*----------------------------------------------------------------------?     If we don't have job control, this routine is never called.    ----*/ stop_process() {      kill(0, SIGKILL);  }       H /*----------------------------------------------------------------------)        Return string describing the error   5    Args: errnumber -- The system error number (errno)   6  Result:  long string describing the error is returned   ----*/ char * error_description(errnumber)     int errnumber; {      static char buffer[128];  + 	sprintf(buffer, "%d", errnumber);	/*~~~~*/ 0 /*~~~    strcpy(buffer, strerror(errnumber));	*/       return ( (char *) buffer); }     H /*----------------------------------------------------------------------I   This collection of routines looks up the login name and password on the I system. For things like PC's it's OK for these to return NULL since there H is no system login. Other code will figure out who the user actually is.   ----*/  H /*----------------------------------------------------------------------B       Fill in homedir, login, and fullname for the logged in user.C       These are all pointers to static storage so need to be copied        in the caller.  3  Args: ui    -- struct pointer to pass back answers     Result: fills in the fields   ----*/ void get_user_info(ui)      struct user_info *ui;  { I 	char	*get_system_homedir(), *get_system_login(), *get_system_fullname();   )       ui->homedir = get_system_homedir(); %       ui->login = get_system_login(); +       ui->fullname = get_system_fullname();  }     H /*----------------------------------------------------------------------D   Since VMS does not have the GCOS notion we simply copy the string.  ,  Result: returns pointer to buffer with name   ----*/
 static char *  gcos_name(gcos_field, logname)     char *logname, *gcos_field;  { )     static char fullname[MAX_FULLNAME+1];    	strcpy(fullname, gcos_field);     return(fullname);  }      char * get_system_login() { ) 	return(cpystr((char *)(cuserid(NULL))));  }    /*$  | Use $GETUAI to get the full name.  */  #include <uaidef.h>  char * get_system_fullname()  {      int	sys$getuai(), status;        struct	{ short length; 		  short	type;  		  char *address;
 	} usernameD; !     char	Username[64], owner[34]; 9     static char	OwnerName[34];	/* Return here the name */        struct {3         short   length,         /* Buffer length */ 6                 code;           /* Item/action code */:         char    *buffer;        /* Input buffer address */E         int     *Olength;       /* Where to place length of result */          } itmlst[] = {*          {32,		UAI$_OWNER, 	owner, NULL },          {0, 0, NULL, NULL } };   $ /* Get the username and upcase it */) 	strcpy(Username, (char *)cuserid(NULL));      ucase(Username);  !     usernameD.address = Username; (     usernameD.length = strlen(Username);     usernameD.type = 0; ;     status = sys$getuai(0, 0, &usernameD, itmlst, 0, 0, 0);        if((status & 0x1) == 0) F         return "";                 /* unexpected error of some kind */  5 /* Copy the owner's name which is a counted string */ 4    strncpy(OwnerName, &owner[1], (owner[0] & 0xff));%    OwnerName[owner[0] & 0xff] = '\0';     return OwnerName; }      char * get_system_homedir() {   	return(cpystr(getenv("HOME"))); }    char * get_system_passwd()  { 
 	return NULL;  }     H /*----------------------------------------------------------------------D       Look up a userid on the local system and return rfc822 address  3  Args: name  -- possible login name on local system   A  Result: returns NULL or pointer to static string rfc822 address.    ----*/ char * local_name_lookup(name)      char *name;  { 
 	return NULL;  }     E /*-----------------------------------------------------------------*/  change_passwd()  { 
 	return 0; }   H /*----------------------------------------------------------------------(        Can we display this type/subtype?  ,    Args: type      -- the MIME type to check&          subtype   -- the MIME subtype           params    -- parameters  ;  Result: returns 1 if the type is displayable, 0 otherwise.   ----*/ 3 mime_can_display(type, subtype, params, use_viewer) 
     int type;      char *subtype;     PARAMETER *params;2     int	*use_viewer;	/* Use an external viewer? */ {    if(use_viewer)4 	*use_viewer = 0;	/* Default - no external viewer */     switch(type) {     case TYPETEXT:/         /* we always try to display text now */ 
 	return 1;       case TYPEAUDIO:       return(0);        case TYPEIMAGE: (       if(getenv("DECW$DISPLAY") == NULL)         return(0);(       if(strucmp(subtype, "gif") == 0 ||(          strucmp(subtype, "pgm") == 0 ||(          strucmp(subtype, "pbm") == 0 ||" 	 strucmp(subtype, "tiff") == 0 ||" 	 strucmp(subtype, "jpeg") == 0) {- 	  *use_viewer = 1;	/* Use an external one */            return(1);       } else         return(0);         case TYPEAPPLICATION:        return(0);       case TYPEMULTIPART:        return(1);       case TYPEMESSAGE:        return(1);       default:       return(0);   }  }     H /*----------------------------------------------------------------------'        We don't know how to play audio.   ----*/  void gf_play_sound(f, c, flg)     FILTER_S *f;     int       c, flg;  {  }     H /*----------------------------------------------------------------------6    This is just a call to the ANSI C fgetpos function.   ----*/ fget_pos(stream, ptr)a
 FILE *stream;u fpos_t *ptr; {i!     return(fgetpos(stream, ptr));r }"    H /*----------------------------------------------------------------------6    This is just a call to the ANSI C fsetpos function.   ----*/ fset_pos(stream, ptr)i
 FILE *stream;A fpos_t *ptr; { !     return(fsetpos(stream, ptr));  }-    #include "[.osdep]sendmail_vms."  H /*----------------------------------------------------------------------8        Dummy srandom function.  Srandom isn't important.  ----*/e void
 srandom(i)
     int i; {e }o  
 truncate() {}  $ close_system_pipe(PIPE_S **p, int i) { return -1; }   display_system_pipe_output() { return -1; }   void flush_input() { }e  3 PIPE_S * open_system_pipe(char *s, char **t, int i)- { return NULL; }   void" exec_mailcap_cmd(command, file, i)! char	*command,	/* Command name */n$ 	*file;		/* Which file to display */ int i; /* dummy */ {  	system(command);  }o   inth exec_mailcap_test_cmd(command)! char	*command;	/* Command name */r {i 	system(command);t }a     /* ==== DEBUGGING ==== */, #ifdef DEBUGH /*----------------------------------------------------------------------3      Initialize debugging - open the debug log filew     Args: none  ,  Result: opens the debug logfile for dprints  B    Opens the file "~/.pine-debug1. Also maintains .pine-debug[2-4]?    by renaming them each time so the last 4 sessions are saved.r   ----*/ void init_debug() {r     char nbuf[5];n2     char newfname[MAXPATH+1], filename[MAXPATH+1];
     int i;       if(!debug)
       return;;       ?     /* Delete the highest version of the file, if one exists */(9     build_path(filename, ps_global->home_dir, DEBUGFILE);-4     sprintf(newfname,"%s%d",filename,NUMDEBUGFILES);     (void)delete(newfname);s  +     for(i = NUMDEBUGFILES - 1; i > 0; i--){ =         build_path(filename, ps_global->home_dir, DEBUGFILE);o#         strcpy(newfname, filename);r         sprintf(nbuf, "%d", i);f         strcat(filename, nbuf);m!         sprintf(nbuf, "%d", i+1);n         strcat(newfname, nbuf); .         (void)rename_file(filename, newfname);     }-  9     build_path(filename, ps_global->home_dir, DEBUGFILE);a     strcat(filename, "1");  %     debugfile = fopen(filename, "w");s     if(debugfile != NULL){  	time_t now = time((time_t *)0); 	if(debug > 7) 	  setbuf(debugfile, NULL);eF 	dprint(1, (debugfile, "Debug output of the Pine program (at debug"));7 	dprint(1, (debugfile, " level %d).  Version %s\n%s\n",-' 		  debug, pine_version, ctime(&now)));t     }d }r    H /*----------------------------------------------------------------------?      Try to save the debug file if we crash in a controlled way   *   Args: dfile:  pointer to open debug file  G  Result: tries to move the appropriate .pine-debugx file to .pine-crashd  G    Looks through the four .pine-debug files hunting for the one that ist2    associated with this pine, and then renames it.   ----*/ void save_debug_on_crash(dfile) FILE *dfile; {-     char nbuf[5];-3     char crashfile[MAXPATH+1], filename[MAXPATH+1]; 
     int i;     struct stat sbuf;o     ino_t our_debug_ino;     dev_t our_debug_dev;#     time_t now = time((time_t *)0);n       if(!debug)
       return;   I     fprintf(dfile, "\nsave_debug_on_crash: Version %s: debug level %d\n",  	pine_version, debug);?     fprintf(dfile, "\n                   : %s\n", ctime(&now));   >     build_path(crashfile, ps_global->home_dir, ".pine-crash");  (     if(fstat(fileno(dfile), &sbuf) != 0)
       return;            our_debug_dev = sbuf.st_dev;#     our_debug_ino = sbuf.st_ino[0];r  I     fprintf(dfile, "\nAttempting to save debug file to %s\n", crashfile);-     fprintf(stderr,rB 	"\n\n       Attempting to save debug file to %s\n\n", crashfile);       fclose(dfile);  (     for(i = 1; i <= NUMDEBUGFILES; i++){=         build_path(filename, ps_global->home_dir, DEBUGFILE);r         sprintf(nbuf, "%d", i);h         strcat(filename, nbuf);D# 	    if(stat(filename, &sbuf) != 0), 	        continue;. 	    /* This must be the current debug file */2 	    if( strcmp(sbuf.st_dev, our_debug_dev)==0 && 1                 sbuf.st_ino[0] == our_debug_ino){ . 	            rename_file(filename, crashfile); 	            break;c 	    }     }  }      #define CHECK_EVERY_N_TIMES 100,# #define MAX_DEBUG_FILE_SIZE 200000L  /*C  * This is just to catch runaway Pines that are looping spewing out=I  * debugging (and filling up a file system).  The stop doesn't have to belD  * at all precise, just soon enough to hopefully prevent filling theG  * file system.  If the debugging level is high (9 for now), then we'rer:  * presumably looking for some problem, so don't truncate.  */l intr do_debug(debug_fp) FILE *debug_fp;p {=-     static int counter = CHECK_EVERY_N_TIMES;e     static int ok = 1;     long filesize;  *     if(debug < 9 && ok && --counter <= 0){/ 	if((filesize = fp_file_size(debug_fp)) != -1L)rE 	  ok = (unsigned long)filesize < (unsigned long)MAX_DEBUG_FILE_SIZE;t   	counter = CHECK_EVERY_N_TIMES; 	 	if(!ok){ ; 	    fprintf(debug_fp, "\n\n --- No more debugging ---\n");; 	    fprintf(debug_fp,= 		"     (debug file growing too large - over %ld bytes)\n\n",( 		MAX_DEBUG_FILE_SIZE);e 	    fflush(debug_fp); 	}     }]     return(ok);  }  #endif /* DEBUG */  H /*----------------------------------------------------------------------.       Return the number of bytes in given file       Args: file -- file namec  8   Result: the number of bytes in the file is returned or3           -1 on error, in which case errno is valid;  ----*/  long name_file_size(file)     char *file;- {-     struct stat buffer;-        if(stat(file, &buffer) != 0)       return(-1L);       return(buffer.st_size);- }a    H /*----------------------------------------------------------------------.       Return the number of bytes in given file  $     Args: fp -- FILE * for open file  8   Result: the number of bytes in the file is returned or3           -1 on error, in which case errno is valid   ----*/e long fp_file_size(fp)
     FILE *fp;s {      struct stat buffer;*       if(!fp) return(-1L);'     if(fstat(fileno(fp), &buffer) != 0)L       return(-1L);       return(buffer.st_size);m }&    H /*----------------------------------------------------------------------0       Return the modification time of given file       Args: file -- file name   J   Result: the time of last modification (mtime) of the file is returned or3           -1 on error, in which case errno is valide  ----*/i time_t name_file_mtime(file)c     char *file;h {g     struct stat buffer;d        if(stat(file, &buffer) != 0)       return((time_t)(-1));)       return(buffer.st_mtime); }     H /*----------------------------------------------------------------------0       Return the modification time of given file  $     Args: fp -- FILE * for open file  J   Result: the time of last modification (mtime) of the file is returned or3           -1 on error, in which case errno is valid   ----*/t time_t fp_file_mtime(fp) 
     FILE *fp;  {      struct stat buffer;e       if(!fp) return(-1L);'     if(fstat(fileno(fp), &buffer) != 0)        return((time_t)(-1));e       return(buffer.st_mtime); }u    H /*----------------------------------------------------------------------.       Return the permission mode of given file       Args: file -- file namec  -   Result: the mode of the file is returned or)3           -1 on error, in which case errno is valid,  ----*/I unsigned short name_file_mode(file)     char *file;X {X     struct stat buffer;u        if(stat(file, &buffer) != 0)#       return((unsigned short)(-1));-       return(buffer.st_mode);o }w    H /*----------------------------------------------------------------------.       Return the permission mode of given file  $     Args: fp -- FILE * for open file  -   Result: the mode of the file is returned orn3           -1 on error, in which case errno is valids  ----*/t unsigned short fp_file_mode(fp)
     FILE *fp;t {e     struct stat buffer;        if(!fp) return(-1L);'     if(fstat(fileno(fp), &buffer) != 0) #       return((unsigned short)(-1));        return(buffer.st_mode);a }h