/*
 * Simple CGI script to use lbrio routines to return named
 * module from text library.  The path_translated CGI variable is
 * the encoded name of the text library plus module name:
 *
 *    /path/file.module.ext (e.g. /www_root/doc/formss.sick-leave.tlb).
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cgilib.h"
#include "lbrio.h"

int main ( int argc, char **argv )
{
    int status, j, i, path_len, first_period, last_period;
    char *path, *fname, *last_slash, mod_name[100], lib_name[256];
    char buffer[8192];
    lbr_index ndx;
    /*
     * setup CGI environment.
     */
    status = cgi_init ( argc, argv );
    if ( (status&1) == 0 ) exit ( status );
    /*
     * Get path translated and verify it meets length limits.
     */
    path = cgi_info ( "PATH_TRANSLATED" );
    if ( path ) path_len = strlen(path); else path_len = 0;

    if ( path_len <=0 || path_len >= sizeof(lib_name) ) {
	cgi_printf("content-type: text/plain\nstatus:400 bad path\n\n");
	cgi_printf("Missing or invalid URL path\n");
	exit(1);
    }
    /*
     * Convert path to VMS filespec.
     */
    last_slash = "";
    for ( j = 0, i = 1; i < path_len; i++ ) {
	lib_name[j] = path[i];
	if ( path[i] == '/' ) {
	    if ( !*last_slash ) {
		lib_name[j++] = ':';
		lib_name[j] = '[';
	    } else {
	        if ( *last_slash == ']' ) *last_slash = '.';
		lib_name[j] = ']';
	    }
	    last_slash = &lib_name[j];
	}
	j = j + 1;
    }
    lib_name[j] = '\0';
    if ( *last_slash == '[' ) {
	/* No directory */
	char *cp;
	for ( cp = last_slash; cp; cp++ ) *cp = cp[1];
	--last_slash;	/* point to colon */
    }
    /*
     * Extract module from middle of filename.
     */
    last_period = first_period = 0;
    fname = &last_slash[1];
    for ( i = 0; fname[i]; i++ ) if ( fname[i] == '.' ) {
	first_period = i;
	for ( j = i; fname[j]; j++ ) if ( fname[j] == '.' ) last_period = j;
	break;
    }
    if ( last_period > first_period ) {
	for ( i = first_period+1; i < last_period; i++ ) 
		mod_name[i-first_period-1] = fname[i];
	mod_name[i-first_period-1] = '\0';
    } else {
	cgi_printf("content-type: text/plain\nstatus:400 missing module\n\n");
	cgi_printf("Missing module name\n");
	exit(1);
    }
    for ( i = first_period; fname[i]; i++ ) fname[i+1] = fname[++last_period];
    /*
     * Open library and lookup module.
     */
    status = lbr_open ( lib_name, "[000000].TLB", &ndx );
    if ( (status&1) == 0 ) {
	cgi_printf("content-type: text/plain\nstatus:400 Open error\n\n");
	cgi_printf("Open error on library, status: %d\n", status );
	exit(1);
    }
    status = lbr_set_module ( ndx, mod_name );
    if ( (status&1) == 0 ) {
	cgi_printf("content-type: text/plain\nstatus:400 Open error\n\n");
	cgi_printf("Unable to read mod %s in library, status: %d\n", 
		mod_name, status );
	exit(1);
    }
    /*
     * Return the records in the module.
     */
    cgi_printf("Content-type: text/plain\n");
    cgi_printf("Status: 200 returning library module\n\n");
    for ( ; ; ) {
	status = lbr_fgets ( buffer, sizeof(buffer), ndx );
	if ( (status&1) == 0 ) break;
	status = cgi_printf("%s", buffer );
    }
    return 1;
}
