
/*
 * SSL server high-level interface.  Applications using this interface
 * supply callback routines that this layer will call to perform raw
 * input and output to the client connection.  The get/put callbacks
 * match the semantics of tserver_tcp's interface.
 *
 * All function return values are integers that follow the OpenVMS convention
 * for status return codes: odd numbers (i.e. 1) for success and even
 * values (e.g. 2160) for failure.
 */

#ifndef SSL_CTX
typedef void *ssl_context;	/* opaque pointer for clients */
#endif

/***************************************************************************/
/* Function tssl_initalize() should be called once per image invocation.
 * It handles any global configuration needed by the ssl_server module.
 *
 * Status messages may be output via the error callback argument.
 */
int tssl_initialize ( int (*error) ( int code, char *text) );

/***************************************************************************/
/* Initialize context for new client connect.  SSL negoitation takes place
 * at this point.
 */
int tssl_init_server_context ( ssl_context *ctx,	/* New context */
    int (*get) ( void *, char *, int, int * ),
    int (*put) ( void *, char *, int ),
    int (*error) ( int code, char *text ),
    void *io_ctx,		/* I/O context for get() and put() calls */
    int max_io_size );		/* Max I/O length per get or put call */

/*****************************************************************************/
/*  The tssl_put_app_data function encypts the application data and sends
 *  it to the client.  The application data may be buffered prior to
 *  encryption.
 */
int tssl_put_app_data ( ssl_context ctx,  unsigned char *data, int length );

/*****************************************************************************/
/* Tssl_get_app_data flushes any pending output data and reads sll records
 * until more application data arrives.  The function returns a pointer to
 * the decrypted application data.
 */
int tssl_get_app_data ( ssl_context ctx, int *length, unsigned char **data );

/*****************************************************************************/
/* Cleanup context (session IDs for context may still be cached).  If flags
 * bit 0 is set, rundown will flush pending output data before performing
 * rundown.
 */
int tssl_rundown_context ( ssl_context ctx, int flags );
