  r /*****************************************************************************************************************  +  Program:	XECN		Show Ethernet line counters   Module:	XECN.C	(the root)  Author:	Nick de Smith	May 1986 R 		Applied Telematics Group, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England.( 		+44 892 511000, PSI%234213300154::NICK  `  From an original idea (in Pascal) by Kevin Carosso and Dan Newman in PAGESWAPPER, November 1984  \  Copyright (c) 1987, 1988, 1989, 1990 by Applied Telematics Group Limited and Nick de Smith.m  This software is supplied for information only. No guarantee is supplied for this software, and no liability m  will be accepted for any action resulting from the use of this software or the information contained herein. i  Under no circumstances may this software be used for commercial gain, including its sale, lease or loan. N  This software may be copied only with the inclusion of this copyright notice.f  The author is prepared to enter into correspondance with interested parties, but will not necessarily8  maintain this software. Having said all that, enjoy it!    Edit	Edit date	By	Reason (  2.08	09-Aug-90	NMdS	Add in /PROMISCUOUSD  2.07	08-May-90	NMdS	Add in /ZERO to initialise counters on startup.c  2.06	09-Feb-90	NMdS	Change bytes in/out to Kbytes in/out so that rates > 100,000kb/sec can be seen Y  2.05	04-Dec-89	NMdS	Change to display data at AST level, and help at non-AST level. This T 				stops the data display being confused when help is used or the screen refreshed.! 				Correct various comments etc. \  2.04	14-Nov-89	NMdS	Tidy up a bit. Change error handling to allow VMS to do the signalling.6  2.03	02-Jun-89	NMdS	Fixed stupid bug in MAP decoding."  2.02	30-May-89	NMdS	DECUS version  2.01	19-May-89	NMdS	VMS V5.1 0 				Much more efficient - uses all integer maths" 				Display real device name used.< 				Work round bug/mis-feature in VMS V5.x 802 device driver 				Use correct user protocol  				Tidy up !   01	07-Jul-86	NMdS	First attempt   r *****************************************************************************************************************/   #define	VERSION	"V2.08"  #module		XECN		VERSION  = #include	descrip							/* Define DSC$xxx - VAX descriptors	*/ @ #include	dvidef							/* Define DVI$xxxx - Device information	*/> #include	iodef							/* Define IO$xxxx - I/O function codes	*/@ #include	psldef							/* Define PSL$xxx - Access mode symbols	*/? #include	smgdef							/* Define SMG$xxxx - Screen management	*/ ? #include	ssdef							/* Define SS$xxxx - System status codes	*/ ? #include	stsdef							/* Define STS$M_xxxx - VMS status bits	*/   C #include	"nmadef.h"						/* Define NMA$xxxx - Network management	*/   0 #define	TRUE	(1 == 1)						/* Logical TRUE				*/1 #define	FALSE	(1 == 0)						/* Logical FALSE			*/   , /* Define parameters for the DATA display */  2 #define	P_ROW	1							/* Pasteboard row number		*/5 #define	P_COL	1							/* Pasteboard column number		*/ 2 #define	MINROW	1							/* Minimum virtual row			*/3 #define	MAXROW	24							/* Maximum virtual row			*/ C #define	ROWS	(MAXROW-MINROW+1)					/* Number of rows in display		*/ 4 #define	MINCOL	1							/* Minimum virtual column		*/5 #define	MAXCOL	80							/* Maximum virtual column		*/ F #define	COLS	(MAXCOL-MINCOL+1)					/* Number of columns in display		*/> #define	H_ROW	5							/* Row at which to paste help display	*/B #define	H_COL	10							/* Column at which to paste help display */4 #define	H_ROWS	12							/* Rows in help display			*/6 #define	H_COLS	60							/* Columns in help display		*/    D static	long	pasteboard	= 0;					/* Physical device to paste on to	*/: static	long	keyboard	= 0;					/* Keyboard input device		*/< static	long	display		= 0;					/* Main window for display		*/@ static	long	help_display	= 0;					/* Window for help display		*/J static	long	help_active	= FALSE;				/* Set to TRUE when HELP is allowed	*/  V #define	$DESC( string )	{ sizeof( string ) - 1, DSC$K_DTYPE_T, DSC$K_CLASS_S, string }  a static readonly struct dsc$descriptor_s rx_eth_devices[] = {		/* Names of devices to check for	*/ V 	$DESC("NI$DEVICE"), $DESC("ESA0:"), $DESC("XQA0:"), $DESC("ETA0:"), $DESC("XEA0:"), 0 };  C static	short	w_eth_chan = 0;						/* Channel to Ethernet device		*/ L static	struct dsc$descriptor_d x_devnam = {				/* Name of device to scan		*/& 	0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };J static	long	reset_flag = FALSE;					/* TRUE to reset counters when read	*/R static	long	no_previous = TRUE;					/* TRUE when no previous data records exist */F #define	DEFAULT_INTERVAL	5					/* Default timer interval in seconds	*/U static	long	l_interval = DEFAULT_INTERVAL;				/* Interval between scans in seconds	*/ : static	long	l_timer_efn;						/* EFN to use for timer			*/  = enum COUNTER_TYPES {							/* Types of counters available		*/ ( 	DBR, MBL, RFL, BRC, MBY, OVR, LBE, DBS,( 	MBS, BSM, BS1, BID, BSN, MSN, SFL, CDC," 	UFD, SBU, UBU, NUM_OF_COUNTERS };   /*r  Definitions from ECRDEF.SDL for MAP values associated with RFL (receive failure) and SFL (send failure) counters.k  These values come from the V5.0 microfiche. As of V5, the Ethernet drivers have all unsupported interfaces q  not listed in the fiche. However, the SDL files have the values for the masks, and the V4 fiche has the required 
  information.  */ typedef struct MAP { 	short	w_mask; 	struct dsc$descriptor x_name; } MAP, *MAP_PTR;  7 #define	RFL_M_BCE	0x0001						/* Block check error			*/ 3 #define	RFL_M_FME	0x0002						/* Framing error			*/ 4 #define	RFL_M_FTL	0x0004						/* Frame too long			*/ static MAP rfl_map[] = {^ 	{ 0	   , { 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 } },		/* First element is the display string	*/  	{ RFL_M_BCE, $DESC("BlkChk")	},  	{ RFL_M_FME, $DESC("FrmErr")	},  	{ RFL_M_FTL, $DESC("FrmLng")	}, 	{ 0 } };: #define	SFL_M_EXC	0x0001						/* Excessive collisions			*/8 #define	SFL_M_CCF	0x0002						/* Carrier check fail			*/3 #define	SFL_M_SHC	0x0004						/* Short circuit			*/ 3 #define	SFL_M_OPC	0x0008						/* Open circuit				*/ 4 #define	SFL_M_FTL	0x0010						/* Frame too long			*/< #define	SFL_M_RFD	0x0020						/* Remote failure to defer		*/ static MAP sfl_map[] = {^ 	{ 0	   , { 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 } },		/* First element is the display string	*/  	{ SFL_M_EXC, $DESC("ExcCol")	},! 	{ SFL_M_CCF, $DESC("CarFail")	},   	{ SFL_M_SHC, $DESC("ShtCir")	},  	{ SFL_M_OPC, $DESC("OpnCir")	},  	{ SFL_M_FTL, $DESC("FrmLng")	},  	{ SFL_M_RFD, $DESC("RemDef")	}, 	{ 0 } };   static readonly struct {E 	enum	COUNTER_TYPES	counter;				/* Counter this element applies to	*/ 5 	long	line;							/* Line number for this element		*/ 0 	char	*title;							/* Title of this element		*/ } header[ NUM_OF_COUNTERS ] = {  /* Received:	 3	*/? 	{ BRC,	 4 , "  Kilo Bytes"		} ,			/* BRC - Bytes received			*/ F 	{ DBR,	 5 , "  Packets (Pk)"		} ,			/* DBR - Data blocks received		*/K 	{ MBY,	 6 , "  Multicast Bytes"	} ,			/* MBY - Multicast bytes received	*/ N 	{ MBL,	 7 , "  Multicast Packets"	} ,			/* MBL - Multicast blocks received	*/\ 	{ RFL,	 8 , "  Pk Lost - Receive Failure" } ,			/* RFL - Packets received in error (MAP) */_ 	{ OVR,	 9 , "  Pk Lost - Data Overrun"	} ,			/* OVR - Receives lost - Internal buffer error */ b 	{ LBE,	10 , "  Pk Lost - Local Buffer Errors" } ,		/* LBE - Receives lost - Local buffer error */ /* Transmitted:	11	*/ ; 	{ BSN,	12 , "  Kilo Bytes"		} ,			/* BSN - Bytes sent			*/ B 	{ DBS,	13 , "  Packets (Pk)"		} ,			/* DBS - Data blocks sent		*/H 	{ MSN,	14 , "  Multicast Bytes"	} ,			/* MSN - Multicast bytes sent		*/K 	{ MBS,	15 , "  Multicast Packets"	} ,			/* MBS - Multicast blocks sent		*/ Q 	{ SFL,	16 , "  Pk Send Failure"	} ,			/* SFL - Transmit packets aborted (MAP)	*/ W 	{ BID,	17 , "  Pk Initially Deferred"	} ,			/* BID - Packets transmitted - Deferred	*/ T 	{ BS1,	18 , "  Pk Single Collision"	} ,			/* BS1 - Packets transmitted - 1 error	*/] 	{ BSM,	19 , "  Pk Multiple Collision"	} ,			/* BSM - Packets transmitted - Several errors */ a 	{ CDC,	20 , "  Collision Detect Check Failure" } ,		/* CDC - Transmit collision check failure */ _ 	{ UFD,	21 , "  Unrecognised Frame Destination" } ,		/* UFD - Unrecognised frame destination	*/ 
 /* Other:		*/ T 	{ SBU,	22 , "System Buffer Unavailable" } ,			/* SBU - System buffer unavailable	*/N 	{ UBU,	23 , "User Buffer Unavailable"	}			/* UBU - User buffer unavailable	*/ };   static struct { 8 	unsigned long	current;					/* Current counter value		*/7 	unsigned long	previous;					/* Value at last scan			*/ / 	unsigned long	rate;						/* Current rate				*/ B 	unsigned long	accumulated;					/* Cumulated rates since start		*/7 	unsigned long	min;						/* Minimum rate value seen		*/ 7 	unsigned long	max;						/* Maximum rate value seen		*/ 6 	short		map;						/* MAP value (if any) for counter	*/ } stats[ NUM_OF_COUNTERS ];   ? static	unsigned current_time	= 0;					/* Time of this scan			*/ F static	unsigned last_time	= 0;					/* Time when last scan was done		*/< static	unsigned sample		= 0;					/* Count of scans done			*/  \ #define	LINE_CTR_BUFSIZ	0x6A						/* Size of buffer to return data in (from XEDRIVER.MAR) */N static	unsigned char retbuf[ LINE_CTR_BUFSIZ ];			/* Returned data buffer			*/+ static	struct	dsc$descriptor_s x_retbuf = { 9 	LINE_CTR_BUFSIZ, DSC$K_DTYPE_T, DSC$K_CLASS_S, retbuf };   N static void	Collect_Info();						/* Action routine to collect port counters */  + /* Macro to check returned system status	*/   ! #define	ss_check( command ) {			\  	long ss_status = (command);		\ , 	if ( (ss_status & STS$M_SUCCESS) == 0 ) { \ 		return ss_status;		\ 	}					\ } ' #define	ss_check_signal( command ) {		\  	long ss_status = (command);		\ , 	if ( (ss_status & STS$M_SUCCESS) == 0 ) { \ 		LIB$SIGNAL( ss_status );	\ 	}					\ }   P /* Check the success status of a VMS system service that uses a quadword IOSB */  % #define	ss_check_iosb( command ) {		\  	short iosb[ 4 ];			\  	long	ss_status = (command);		\ % 	if ( ss_status & STS$M_SUCCESS ) {	\  		ss_status = iosb[ 0 ];		\  	}					\, 	if ( (ss_status & STS$M_SUCCESS) == 0 ) { \ 		return ss_status;		\ 	}					\ }     r /*****************************************************************************************************************  
 						X E C N   
  Entry point.   r *****************************************************************************************************************/   XECN() { 
 	long	status; R 	static $DESCRIPTOR( x_device_name, "DEVICE_NAME" );		/* Device name from CLD			*/U 	static $DESCRIPTOR( x_interval	 , "INTERVAL" );		/* Interval in seconds from CLD		*/ E 	static $DESCRIPTOR( x_zero	 , "ZERO" );			/* Zero counters flag			*/ L 	static struct dsc$descriptor_d x_junk = {			/* Junk, working descriptor		*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };   i 	if ( CLI$PRESENT( &x_device_name ) & STS$M_SUCCESS ) {		/* If a specific device name was specified... */ Y 		ss_check( CLI$GET_VALUE( &x_device_name, &x_devnam, 0 ) ) /* ...get the device name		*/  	}X 	if ( CLI$PRESENT( &x_interval ) & STS$M_SUCCESS ) {		/* If /INTERVAL=n specified...		*/X 		ss_check( CLI$GET_VALUE( &x_interval, &x_junk, 0 ) ) /* ...get the qualifier value		*/W 		ss_check( OTS$CVT_TU_L( &x_junk, &l_interval ) )	/* ...convert the value to binary	*/  	}  N 	ss_check( LIB$GET_EF( &l_timer_efn ) )				/* Get an event flag for timing		*/  C 	ss_check( Startup_Port() )					/* Set up the link to the device	*/   @ 	ss_check( Init_Screen() )					/* Set up the screen handling		*/  ? 	ss_check( Init_Counters() )					/* Initialise the counters		*/   Z 	if ( CLI$PRESENT( &x_zero ) & STS$M_SUCCESS ) {			/* If the counters must be zeroed...	*/ 		reset_flag = TRUE;B 		ss_check( Get_Counters() )				/* Read and reset the counters		*/I 		ss_check( ReCollect_Data( l_interval ) )		/* Wait for next interval		*/ 	 	} else { 6 		Collect_Info();						/* Get and process the data		*/ 	}  0 	SYS$HIBER();							/* Sleep until all over			*/  B 	ss_check( Shutdown_XE() )					/* Close down the Ethernet port		*/  5 	return SS$_NORMAL;						/* Return success to VMS		*/  }     r /*****************************************************************************************************************   					S t a r t u p _ P o r t  E  Assign a channel to the Ethernet device and initialise our protocol.   r *****************************************************************************************************************/ static Startup_Port() { R 	static $DESCRIPTOR( x_promiscuous, "PROMISCUOUS" );		/* Use promiscuous mode			*/ 	static readonly struct {  		unsigned	: 16; 		unsigned	: 32; 	} startup_buffer[] = { E 		{ NMA$C_PCLI_FMT,	NMA$C_LINFM_ETH	},		/* Ethernet packet format		*/ H 		{ NMA$C_PCLI_BFN,	1		},		/* Number of pre-allocated receive buffers */> 		{ NMA$C_PCLI_PTY,	0x0660		} };		/* Protocol value: 60-06		*/ 	static readonly struct {  		unsigned	: 16; 		unsigned	: 32; 	} startup_buffer_prm[] = { E 		{ NMA$C_PCLI_FMT,	NMA$C_LINFM_ETH	},		/* Ethernet packet format		*/ H 		{ NMA$C_PCLI_BFN,	1		},		/* Number of pre-allocated receive buffers */5 		{ NMA$C_PCLI_PRM,	0		} };		/* Promiscuous mode			*/ 6 	struct {							/* Descriptor for startup buffer...	*/L 		unsigned long l_size;					/* ...must be two longs, not a real decriptor */ 		unsigned long l_address;4 	} startup_desc;							/* Descriptor for startup		*/G 	struct	dsc$descriptor_s *ax_device;				/* => array of device names		*/  	int	status;  \ 	if ( CLI$PRESENT( &x_promiscuous ) & STS$M_SUCCESS ) {		/* If /PROMISCUOUS specified...		*/2 		startup_desc.l_size	= sizeof startup_buffer_prm;. 		startup_desc.l_address	= startup_buffer_prm;	 	} else { . 		startup_desc.l_size	= sizeof startup_buffer;* 		startup_desc.l_address	= startup_buffer; 	}U 	if ( x_devnam.dsc$w_length != 0 ) {				/* If there was an explicit device name... */ ? 		status = SYS$ASSIGN(					/* Assign a channel to the device	*/ ; 			&x_devnam	,				/* Name of device to assign channel to	*/ 0 			&w_eth_chan	,				/* Returned I/O channel			*/6 			PSL$C_USER	,				/* Access mode is user (highest)	*/' 			0		);				/* Mailbox name to use			*/ 	 	} else { i 		for ( ax_device = &rx_eth_devices[0]; ax_device->dsc$w_length; ax_device++ ) { /* For each device... */ ? 			status = SYS$ASSIGN(				/* Assign a channel to the device	*/ ; 				ax_device	,			/* Name of device to assign channel to	*/ 0 				&w_eth_chan	,			/* Returned I/O channel			*/6 				PSL$C_USER	,			/* Access mode is user (highest)	*/' 				0		);			/* Mailbox name to use			*/ = 			if ( status & STS$M_SUCCESS ) {			/* If we got one...			*/ * 				break;					/* ...quit while ahead			*/ 			} 		}  	}7 	ss_check( status )						/* Check completion status		*/    	ss_check( LIB$GETDVI(4 		&DVI$_FULLDEVNAM,					/* Get full device name			*/* 		&w_eth_chan	,					/* Channel number			*/* 		0		,					/* No device name specified		*/2 		0		,					/* Returned numeric value - not used	*/; 		&x_devnam	,					/* Returned string value (device name)	*/ . 		0		) )					/* Returned length (not used)		*/  5 	ss_check_iosb( SYS$QIOW(					/* Call the driver			*/  		0		,					/* EFN 0				*/ + 		w_eth_chan	,					/* Ethernet channel			*/ K 		IO$_SETMODE | IO$M_STARTUP | IO$M_CTRL,			/* Start the specified port		*/ & 		iosb		,					/* I/O status block			*/ 		0		,					/* AST routine				*/   		0		,					/* AST parameter			*/ 		0		,					/* P1					*/ 9 		&startup_desc	,					/* P2 = Startup characteristics		*/  		0		,					/* P3					*/  		0		,					/* P4					*/   		0		,					/* P5 - not used			*/" 		0		) )					/* P6 - not used			*/  8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************   					S h u t d o w n _ X E  &  Close down our port on the XE device.  r *****************************************************************************************************************/ static
 Shutdown_XE()  { 5 	ss_check_iosb( SYS$QIOW(					/* Call the driver			*/  		0		,					/* EFN 0				*/ + 		w_eth_chan	,					/* Ethernet channel			*/ A 		IO$_SETMODE | IO$M_SHUTDOWN | IO$M_CTRL,		/* Stop the port			*/ & 		iosb		,					/* I/O status block			*/ 		0		,					/* AST routine				*/   		0		,					/* AST parameter			*/ 		0		,					/* P1					*/  		0		,					/* P2					*/  		0		,					/* P3					*/  		0		,					/* P4					*/   		0		,					/* P5 - not used			*/" 		0		) )					/* P6 - not used			*/  J 	ss_check( SYS$DASSGN( w_eth_chan ) )				/* Close the ethernet channel		*/  8 	return SS$_NORMAL;						/* Return success to caller		*/ }c e  r /*****************************************************************************************************************   						I n i t _ S c r e e no  4  Initialise the physical screen and virtual display.  r *****************************************************************************************************************/ static
 Init_Screen()o {a@ 	static readonly $DESCRIPTOR( pasteboard_port, "SYS$COMMAND:" );> 	static readonly $DESCRIPTOR( keyboard_port, "SYS$COMMAND:" );c 	static readonly $DESCRIPTOR( x_devnam_format, "Device: !AS" );	/* Format string for device name	*/n  B 	void	Keyboard_Ast();						/* AST routine for unsolicited input	*/B 	long	application_mode = 1;					/* Use keypad application mode		*/ 	long	loop;p   	ss_check( LIB$SYS_FAO( 4 		&x_devnam_format,					/* Format control string		*/& 		0		,					/* No resultant length			*/' 		&x_devnam	,					/* Output string			*/a6 		&x_devnam	) )					/* Add in the real device name		*/  C 	ss_check( SMG$CREATE_PASTEBOARD( &pasteboard, &pasteboard_port ) )i  A 	ss_check( SMG$CREATE_VIRTUAL_DISPLAY( &ROWS, &COLS, &display ) )t  E 	ss_check( SMG$CREATE_VIRTUAL_KEYBOARD( &keyboard, &keyboard_port ) )8@ 	ss_check( SMG$SET_KEYPAD_MODE( &keyboard, &application_mode ) )F 	ss_check( SMG$ENABLE_UNSOLICITED_INPUT( &pasteboard, Keyboard_Ast ) )  O 	ss_check( SMG$PASTE_VIRTUAL_DISPLAY( &display, &pasteboard, &P_ROW, &P_COL ) )T  H 	ss_check( SMG$ERASE_DISPLAY( &display ) )			/* Erase whole display			*/1 	ss_check( SMG$BEGIN_DISPLAY_UPDATE( &display ) )   3 	for ( loop = 0; loop < NUM_OF_COUNTERS; loop++ ) {S 		if ( header[ loop ].line ) {? 			Put_Text( header[ loop ].title, header[ loop ].line, 1, 0 );  		}o 	}* 	Put_Descriptor( &x_devnam	,  1,  1, 0 ); ; 	Put_Text( "Ethernet Line Counters",1, 26, SMG$M_REVERSE );-" 	Put_Text( VERSION		,  1, 55, 0 );" 	Put_Text( "Time:"		,  1, 66, 0 );/ 	Put_Text( "Received:"		,  3,  1, SMG$M_BOLD );*- 	Put_Text( "Current"		,  3, 37, SMG$M_BOLD );8- 	Put_Text( "Average"		,  3, 46, SMG$M_BOLD );	- 	Put_Text( "Minimum"		,  3, 55, SMG$M_BOLD );i- 	Put_Text( "Maximum"		,  3, 64, SMG$M_BOLD ); - 	Put_Text( "Counter"		,  3, 74, SMG$M_BOLD );I1 	Put_Text( "Transmitted:"	, 11,  1, SMG$M_BOLD );	8 	Put_Text( "Press HELP for help"	, 24,  1, SMG$M_BOLD );  L 	ss_check( SMG$END_DISPLAY_UPDATE( &display ) )			/* Update the display			*/  8 	return SS$_NORMAL;						/* Return success to caller		*/ }* f  r /*****************************************************************************************************************   						P u t _ T e x to  /  Put a C null terminated string to the display.g  r *****************************************************************************************************************/ static	 Put_Text(	? 	char	*buffer		,					/* => null terminated string to display	*/i+ 	long	row		,					/* Display row to use			*/	- 	long	col		,					/* Display column to use		*/AA 	long	rendition_set	)					/* Attributes to use when displaying	*/L {	H 	struct dsc$descriptor_s line = {				/* VMS descriptor for 'C' string	*/, 		0, DSC$K_DTYPE_T, DSC$K_CLASS_S, buffer };  C 	while ( *buffer++ ) {						/* Avoid using strlen()	(no VAXCRTL)	*/w 		line.dsc$w_length++; 	}  b 	return Put_Descriptor( &line, row, col, rendition_set );	/* Display string as a VMS descriptor	*/ }w  r /*****************************************************************************************************************  ! 						P u t _ D e s c r i p t o r   ,  Put a VMS string descriptor to the display.  r *****************************************************************************************************************/ static Put_Descriptor(tL 	struct dsc$descriptor * text,					/* => VMS string descriptor to display	*/+ 	long	row		,					/* Display row to use			*/S- 	long	col		,					/* Display column to use		*/rA 	long	rendition_set	)					/* Attributes to use when displaying	*/e {eL 	ss_check( SMG$PUT_CHARS( &display, text, &row, &col, &0, &rendition_set ) )  8 	return SS$_NORMAL;						/* Return success to caller		*/ }; 	  r /*****************************************************************************************************************   					I n i t _ C o u n t e r s    Initialise the counters.F  r *****************************************************************************************************************/ static Init_Counters()E {L 	long	loop;	  3 	for ( loop = 0; loop < NUM_OF_COUNTERS; loop++ ) {	5 		stats[ loop ].previous = stats[ loop ].current = 0;c  		stats[ loop ].accumulated = 0; 		stats[ loop ].max = 0;% 		stats[ loop ].min = 0xffffff * 100;S 		stats[ loop ].map = 0; 	} 	last_time = 0;D 	current_time = 1;  8 	return SS$_NORMAL;						/* Return success to caller		*/ }U    r /*****************************************************************************************************************   					C o l l e c t _ I n f o  i  Collect and display the information. Called initially at non-AST level, but subsequently at AST level by   ReCollect_Data().  r *****************************************************************************************************************/ static voidt Collect_Info() {sQ 	ss_check_signal( Get_Counters() )				/* Start the data collection and display */	G 	ss_check_signal( Parse_Buffer() )				/* Parse the returned data...		*/rL 	ss_check_signal( Compute_Results() )				/* ...compute the screen output		*/E 	ss_check_signal( Display_Results() )				/* Display the new data			*/s  P 	ss_check_signal( ReCollect_Data( l_interval ) )			/* Wait for next interval		*/ }S  r /*****************************************************************************************************************    					R e C o l l e c t _ D a t a  K  Called to wait for the passed number of seconds before re-collecting data.   r *****************************************************************************************************************/ static ReCollect_Data(m? 	unsigned	l_interval	)				/* Interval in seconds to wait for	*/, {C 	long	q_time[] = {@ 		l_interval * -10000000, -1 };				/* Delta time for timeout		*/   	ss_check( SYS$SETIMR ({0 		l_timer_efn		,				/* Event flag for timer			*/- 		q_time			,				/* Delta time to wait for		*/	1 		Collect_Info		,				/* Timer service routine		*/ 7 		&l_timer_efn		) )				/* Request ID for this timer		*/{  = 	help_active = TRUE;						/* Allow help now AST is primed		*/   8 	return SS$_NORMAL;						/* Return success to caller		*/ }  a  r /*****************************************************************************************************************   						G e t _ C o u n t e r se  n  Read the MOP counters for the specified device. If a read-with-reset is required (user typed CTRL/R) then add  in the required modifier.  r *****************************************************************************************************************/ static Get_Counters() {}8 	long	func = 0;						/* Extra function codes required	*/  C 	if ( reset_flag ) {						/* If we want to reset the counters...	*/ F 		func = IO$M_CLR_COUNT;					/* ...clear the counters after reading	*/ 	}5 	ss_check_iosb( SYS$QIOW(					/* Call the driver			*/d 		0		,					/* EFN 0				*/i+ 		w_eth_chan	,					/* Ethernet channel			*/{T 		IO$_SENSEMODE | IO$M_RD_COUNT | IO$M_CTRL | func ,	/* Read the device counters		*/& 		iosb		,					/* I/O status block			*/ 		0		,					/* AST routine				*/t  		0		,					/* AST parameter			*/ 		0		,					/* P1					*/{5 		&x_retbuf	,					/* P2 = Buffer to return data in	*/p 		0		,					/* P3					*/  		0		,					/* P4					*/l  		0		,					/* P5 - not used			*/" 		0		) )					/* P6 - not used			*/  ( 	sample++;							/* Count this scan			*/  8 	return SS$_NORMAL;						/* Return success to caller		*/ }  l  r /*****************************************************************************************************************   					P a r s e _ B u f f e r  K  Parse the returned buffer from the driver and extract the required fields.e  r *****************************************************************************************************************/ static Parse_Buffer() {,A 	unsigned long	field_value;					/* Encoded counter field name		*/  	long	junk;sH 	unsigned short	Get_Word();					/* Return 16 bits from counter buffer	*/= 	void		Get_Item();					/* Get one item from counter buffer	*/o  L 	Buf_Init( retbuf, LINE_CTR_BUFSIZ );				/* Initialise the buffer scanner	*/   /*k  With ANSI XJ311 C we could build the counter constant value within the #define, but VAX C does not supportix  the "##" operator. As some people may not be using ANSI C compilers we use a really nasty hack to build the case label. */ #define	$ITEM( entry )			\" 	case NMA$C_CTLIN_/**/entry/**/:	\J 		Get_Item( field_value, &stats[ entry ].current, &stats[ entry ].map ); \ 		break;   	while ( Buf_Data_Left() ) {8 		switch( (field_value = Get_Word()) & NMA$M_CNT_TYP ) {< 			case NMA$C_CTLIN_ZER:				/* Seconds since last zeroed		*/. 				Get_Item( field_value, &current_time, 0 );
 				break;- 			$ITEM( DBR );					/* Packets received			*/ 6 			$ITEM( MBL );					/* Multicast packets received		*/: 			$ITEM( RFL );					/* Packets received in error (MAP)	*/+ 			$ITEM( BRC );					/* Bytes received			*/ 4 			$ITEM( MBY );					/* Multicast bytes received		*/@ 			$ITEM( OVR );					/* Receives lost - Internal buffer error */= 			$ITEM( LBE );					/* Receives lost - Local buffer error	*/ - 			$ITEM( DBS );					/* Data blocks sent			*/ 1 			$ITEM( MBS );					/* Multicast blocks sent		*/M? 			$ITEM( BSM );					/* Packets transmitted - Several errors	*/ 8 			$ITEM( BS1 );					/* Packets transmitted - 1 error	*/9 			$ITEM( BID );					/* Packets transmitted - Deferred	*/)( 			$ITEM( BSN );					/* Bytes sent				*/1 			$ITEM( MSN );					/* Multicast bytes sent			*/C9 			$ITEM( SFL );					/* Transmit packets aborted (MAP)	*/s; 			$ITEM( CDC );					/* Transmit collision check failure	*/ 9 			$ITEM( UFD );					/* Unrecognised frame destination	*/*5 			$ITEM( SBU );					/* System buffer unavailable		*/*3 			$ITEM( UBU );					/* User buffer unavailable		*/ : 			default:					/* Something we don't know about - junk	*/P 				Get_Item( field_value, &junk, 0 );	/* Just eat junk - everybody else does	*/
 				break; 		}D 	}8 	return SS$_NORMAL;						/* Return success to caller		*/ }L 	  r /*****************************************************************************************************************  " 					C o m p u t e _ R e s u l t s     Compute the figures to display.  r *****************************************************************************************************************/ static Compute_Results()  {	 	long	loop;i  P 	for ( loop = 0; loop < NUM_OF_COUNTERS; loop++ ) {		/* For each counter...			*/? 		if ( no_previous ) {					/* If counters have been reset...	*/NE 			stats[ loop ].rate = (100*(stats[ loop ].current)) / current_time;/
 		} else {\ 			stats[ loop ].rate = (100*(stats[ loop ].current - stats[ loop ].previous)) / l_interval; 		}_1 		stats[ loop ].previous = stats[ loop ].current;lN 		if ( loop == BRC || loop == BSN ) {			/* If its bytes sent or received...	*/B 			stats[ loop ].rate /= 1000;			/* ...turn it into Kbytes/sec		*/! 			stats[ loop ].current /= 1000;h 		}I2 		stats[ loop ].accumulated += stats[ loop ].rate;1 		if ( stats[ loop ].min > stats[ loop ].rate ) {t* 			stats[ loop ].min = stats[ loop ].rate; 		}&1 		if ( stats[ loop ].max < stats[ loop ].rate ) {o* 			stats[ loop ].max = stats[ loop ].rate; 		}o 	} 	last_time = current_time;  : 	if ( reset_flag ) {						/* If counters were reset...		*/8 		reset_flag = 0;						/* ...clear the one-shot flag		*/= 		no_previous = TRUE;					/* ...there is no previous data		*/		 	} else {p< 		no_previous = FALSE;					/* There is now previous data		*/ 	}8 	return SS$_NORMAL;						/* Return success to caller		*/ }n c  r /*****************************************************************************************************************  " 					D i s p l a y _ R e s u l t s    Display the computed results.  r *****************************************************************************************************************/ static Display_Results()* {*_ 	static readonly $DESCRIPTOR( x_line_format,  "!5UL.!2ZL !5UL.!2ZL !5UL.!2ZL !5UL.!2ZL !9UL" );IC 	static	struct dsc$descriptor_d x_line = {			/* Line to output			*/ ' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };am 	static readonly $DESCRIPTOR( x_time_format, "!AS!2UL:!2ZL:!2ZL" ); /* Format to use for time since zeroed */	B 	static readonly $DESCRIPTOR( x_space, " " );			/* One space				*/K 	static readonly $DESCRIPTOR( x_brocket, ">" );			/* Greater than sign			*/ * 	static	struct dsc$descriptor_d x_time = {' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };	Z 	struct	dsc$descriptor *ax_range = &x_space;			/* Default to displaying a leading space */O 	unsigned long hours	= current_time / 3600;			/* Who doesn't do long hours?		*/eO 	unsigned long seconds	= current_time % 3600;			/* Seconds since last reset		*/_I 	unsigned long minutes	= seconds / 60;				/* Minutes since last reset		*/  	long	loop;}  A 	seconds	= seconds % 60;						/* Lose minutes part of seconds		*/iB 	if ( current_time == 65535 ) {					/* If the time is stuck...		*/< 		ax_range = &x_brocket;					/* ...display a leading ">"		*/ 	}  Z 	ss_check( SMG$BEGIN_DISPLAY_UPDATE( &display ) )		/* Start batching of display updates	*/   	ss_check( LIB$SYS_FAO(f3 		&x_time_format	,					/* Format control string		*/s& 		0		,					/* No resultant length			*/& 		&x_time		,					/* Output string			*/( 		ax_range	,					/* Range indicator			*/" 		hours		,					/* Hours part				*/& 		minutes		,					/* Minutes part				*/( 		seconds		) )					/* Seconds part				*/T 	ss_check( SMG$PUT_CHARS( &display, &x_time, &1, &72 ) )		/* Write out the time			*/  3 	for ( loop = 0; loop < NUM_OF_COUNTERS; loop++ ) {	& #define	COUNTER	header[ loop ].counter 		ss_check( LIB$SYS_FAO(3 			&x_line_format	,				/* Format control string		*/t& 			0		,				/* No resultant length			*/& 			&x_line		,				/* Output string			*/7 			stats[ COUNTER ].rate / 100	,		/* Rate / second			*/   			stats[ COUNTER ].rate % 100	,O 			(stats[ COUNTER ].accumulated / sample) / 100 ,	/* Average rate / second		*/m2 			(stats[ COUNTER ].accumulated / sample) % 100 ,= 			stats[ COUNTER ].min / 100	,		/* Minimum rate / second		*/o 			stats[ COUNTER ].min % 100	, = 			stats[ COUNTER ].max / 100	,		/* Maximum rate / second		*/	 			stats[ COUNTER ].max % 100	, = 			stats[ COUNTER ].current	) )		/* Current counter value		*/   d 		ss_check( SMG$PUT_CHARS( &display, &x_line, &header[ loop ].line, &36 ) ) /* Write out the line	*/ 	}E 	Update_Map( RFL, rfl_map, 3 );					/* Update receive failure map		*/RC 	Update_Map( SFL, sfl_map, 11 );					/* Update send failure map		*/t  Y 	SMG$SET_CURSOR_ABS( &display, &MAXROW, &MINCOL );		/* Move cursor to bottom of screen	*/   K 	ss_check( SMG$END_DISPLAY_UPDATE( &display ) )			/* Update the screen			*/A  8 	return SS$_NORMAL;						/* Return success to caller		*/ }	 	  r /*****************************************************************************************************************   						U p d a t e _ M a p   n  Analyse the passed counter's map to see if it has changed. If it has, build a string containing a description0  of the bit mask, display it, and ring the bell.  r *****************************************************************************************************************/ static Update_Map(*D 	enum COUNTER_TYPES	counter	,				/* Counter for map to be updated	*/2 	MAP			map[]	,				/* Map translation structure		*/: 	unsigned		line	)				/* Display line on which to output	*/ {*- 	static readonly $DESCRIPTOR( x_comma, "," ); ; 	MAP_PTR		map_ptr = &map[ 1 ];				/* => MAP mask array			*/ 3 	long		l_length;					/* String length as a LONG		*/nI 	static struct dsc$descriptor_d x_text = {			/* New string to display		*/,' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };*  O 	if ( map[ 0 ].w_mask != stats[ counter ].map ) {		/* If MAP has changed...		*/eD 		ss_check( STR$FREE1_DX( &x_text ) )			/* ...remove old string			*/B 		while ( map_ptr->w_mask ) {				/* While some bits to test...		*/R 			if ( map_ptr->w_mask & stats[ counter ].map ) {	/* ...if this bit is set...		*/P 				if ( x_text.dsc$w_length != 0 ) {	/* ...add in a "," if already some text */0 					ss_check( STR$APPEND( &x_text, &x_comma ) ) 				}*W 				ss_check( STR$APPEND( &x_text, &map_ptr->x_name ) ) /* ...add in the description */	 			}
 			map_ptr++;  		} ^ 		if ( x_text.dsc$w_length < map[ 0 ].x_name.dsc$w_length ) { /* If string has shortened...	*/H 			l_length = map[ 0 ].x_name.dsc$w_length;	/* Get length as a LONG			*/W 			ss_check( STR$DUPL_CHAR( &map[ 0 ].x_name, &l_length ) ) /* Generate space string	*/:N 			ss_check( SMG$PUT_CHARS( &display, &map[ 0 ].x_name, &line, &14, &0, &0 ) ) 		}yN 		ss_check( SMG$PUT_CHARS( &display, &x_text, &line, &14, &0, &SMG$M_BLINK ) )N 		ss_check( SMG$RING_BELL( &display ) )			/* Ring the bell to tell the user	*/N 		ss_check( STR$COPY_DX( &map[ 0 ].x_name, &x_text ) )	/* Save new string			*/A 		map[ 0 ].w_mask = stats[ counter ].map;			/* Save new MAP				*/  	}8 	return SS$_NORMAL;						/* Return success to caller		*/ }	 	  ? static	char *buf_ptr = 0;						/* Pointer to buffer to scan		*/cA static	long   buf_offset = 0;						/* Offset into scan buffer		*/bD static	long   buf_data_len = 0;					/* Ammount of data in buffer		*/  r /*****************************************************************************************************************   						B u f _ I n i to  >  Initialise the buffer extraction routine's working variables.  r *****************************************************************************************************************/ static	 Buf_Init(s+ 	char	*ptr		,					/* => buffer to scan			*/h+ 	long	count		)					/* Length of buffer			*/  {f> 	buf_ptr	= ptr;							/* Initialise pointer to buffer start	*/= 	buf_offset = 0;							/* Start at the start of the buffer	*/l@ 	buf_data_len = count;						/* Total length of data in buffer	*/  8 	return SS$_NORMAL;						/* Return success to caller		*/ }R  r /*****************************************************************************************************************   						B u f _ D a t a _ L e f t   L  Return TRUE if there is some unscanned data left in the buffer, FALSE else.  r *****************************************************************************************************************/ static Buf_Data_Left()x {"3 	return (buf_offset < buf_data_len) ? TRUE : FALSE;r }  P  r /*****************************************************************************************************************   						G e t _ B y t e/  F  Get a byte from the passed buffer, and adjust the offset accordingly.  r *****************************************************************************************************************/ static unsigned char
 Get_Byte() {lY 	unsigned char value = *((unsigned char *) (buf_ptr + buf_offset)); /* Get the value			*/*D 	buf_offset += sizeof( unsigned char );				/* Adjust the offset			*/- 	return value;							/* Return the value			*/  }n  r /*****************************************************************************************************************   						G e t _ W o r di  F  Get a word from the passed buffer, and adjust the offset accordingly.  r *****************************************************************************************************************/ static unsigned shorte
 Get_Word() {;R 	unsigned short value = *((short *) (buf_ptr + buf_offset));	/* Get the value			*/= 	buf_offset += sizeof( short );					/* Adjust the offset			*/*- 	return value;							/* Return the value			*/* }*  r /*****************************************************************************************************************   						G e t _ L o n g*  J  Get a longword from the passed buffer, and adjust the offset accordingly.  r *****************************************************************************************************************/ static unsigned long
 Get_Long() {	P 	unsigned long value = *((long *) (buf_ptr + buf_offset));	/* Get the value			*/< 	buf_offset += sizeof( long );					/* Adjust the offset			*/- 	return value;							/* Return the value			*/i }s )  r /*****************************************************************************************************************   						G e t _ I t e m*  K  Return an item of the correct type from the next field in the data buffer. o  NMA fldid fields are bit encoded. The low 12 bits are the unique request code, the other 4 bits contain useful*8  information such as the type of data that was returned.  r *****************************************************************************************************************/ static void 	 Get_Item(o6 	long	field		,					/* Encoded field value to return	*/= 	unsigned long *item_ptr	,					/* Where to return counter		*/lB 	unsigned short *map_ptr	)					/* Where to return MAP (if any)		*/ {n 	unsigned char	Get_Byte(); 	unsigned short	Get_Word();* 	unsigned long	Get_Long();  E 	if ( field & NMA$M_CNT_MAP ) {					/* If there was a MAP word...		*/oA 		if ( map_ptr != 0 ) {					/* ...and we wanted it returned...	*/d: 			*map_ptr = Get_Word();				/* ...return the MAP word		*/
 		} else {; 			Get_Word();					/* ...otherwise just eat the MAP word	*/* 		}* 	}  b 	switch ( (field & NMA$M_CNT_WID) >> NMA$V_CNT_WID ) {		/* Depending on counter size, return...	*/  % 		case 1:							/* 8 bit counter			*/d* 			*item_ptr = (unsigned long) Get_Byte();	 			break;_& 		case 2:							/* 16 bit counter			*/* 			*item_ptr = (unsigned long) Get_Word();	 			break;.& 		case 3:							/* 32 bit counter			*/ 			*item_ptr = Get_Long();	 			break;p: 		default:						/* Should never get here as VMS will...	*/< 			break;						/* ...BUGCHECK NOBUFPCKT in XnDRIVER first */ 	} }* *  r /*****************************************************************************************************************   					K e y b o a r d _ A s t  I  AST routine called by the SMG package whenever unsolicited input occurs.*  r *****************************************************************************************************************/ static voids
 Keyboard_Ast(l 	long	p_board		, 	long	param		) {f 	unsigned short term_char;: 	static readonly struct dsc$descriptor_s x_help_text[] = {C /*		         1         2         3         4         5         6	*/aC /*		123456789012345678901234567890123456789012345678901234567890	*/o: 	$DESC( "XE (c) 1989,1990 ATG Ltd. and Nick de Smith"			), 	$DESC( " "								),DF 	$DESC( "XE is a tool that provides a MONITOR type display for the"	),F 	$DESC( "equivalent of an NCP SHO LINE <ethernet-device> COUNTERS."	), 	$DESC( " "								),*H 	$DESC( "Only one person may use XE on a particular VAX at any time."	), 	$DESC( ""								),H 	$DESC( " Format: $ XE [device] [/INTERVAL=n] [/ZERO] [/PROMISCUOUS]"	), 	$DESC( " "								), C 	$DESC( "If \"device\" is not specified, XE searches the list:"		),eA 	$DESC( "     NI$DEVICE, ESA0:, XQA0:, ETA0:, XEA0: in order"		),*D 	$DESC( "If \"/INTERVAL=n\" is not specified, the scan interval"		),( 	$DESC( "defaults to 5 seconds."						),H 	$DESC( "If \"/ZERO\" is specified, the counters will be initialised"	),( 	$DESC( "before the first scan."						),H 	$DESC( "If \"/PROMISCUOUS\" is specified, the receive counters will"	),J 	$DESC( "reflect all data on the ethernet. PHY_IO privilege is needed."	), 	$DESC( ""								),$ 	$DESC( "Keyboard commands:"						), 	$DESC( " "								),N7 	$DESC( "CTRL/R      Reset counters at next scan" 			),	+ 	$DESC( "CTRL/W      Refresh screen"					),	6 	$DESC( "CTRL/Z      Exit (or CTRL/Y or CTRL/C)"				),5 	$DESC( "PF2         Help (or HELP, ?, H or h)"				),  	$DESC( ""								),/ 	$DESC( "Received block failure reasons:"				),4 	$DESC( " "								), 6 	$DESC( "     BlkChk          Block check error"				),2 	$DESC( "     FrmErr          Framing error"				),3 	$DESC( "     FrmLng          Frame too long"				),  	$DESC( ""								),2 	$DESC( "Transmitted block failure reasons:"				), 	$DESC( " "								),*8 	$DESC( "     ExcCol          Excessive collisions"			),6 	$DESC( "     CarFail         Carrier check fail"			),2 	$DESC( "     ShtCir          Short circuit"				),1 	$DESC( "     OpnCir          Open circuit"				),*3 	$DESC( "     FrmLng          Frame too long"				),u; 	$DESC( "     RemDef          Remote failure to defer"			),r 	0 };n9 	struct dsc$descriptor *ax_help_text = &x_help_text[ 0 ];R< 	static $DESCRIPTOR( x_press, "Press any key to continue" );  X 	SMG$READ_KEYSTROKE( &keyboard, &term_char );			/* Get the key causing us to get here	*/   	switch ( term_char ) {   . 		case SMG$K_TRM_QUESTION_MARK:				/* ?					*/, 		case SMG$K_TRM_LOWERCASE_H:				/* h					*/, 		case SMG$K_TRM_UPPERCASE_H:				/* H					*/6 		case SMG$K_TRM_PF2:					/* Keypad function key 2		*/1 		case SMG$K_TRM_HELP:					/* LK2xx HELP key			*/	@ 			if ( !help_active ) {				/* Someone trying to be clever...	*/2 				break;					/* ...don't let them stop things	*/ 			}, 			SYS$CLRAST();					/* Dismiss the AST			*/C 			if ( help_display == 0 ) {			/* If no help display before...		*/ E 				$DESCRIPTOR( x_help, "Help" );		/* ...create the help display		*/lQ 				SMG$CREATE_VIRTUAL_DISPLAY( &H_ROWS, &H_COLS, &help_display, &SMG$M_BORDER );	/ 				SMG$LABEL_BORDER( &help_display, &x_help );e 			}S 			SMG$ERASE_DISPLAY( &help_display );		/* Ensure help display is clean at start */	K 			SMG$PASTE_VIRTUAL_DISPLAY( &help_display, &pasteboard, &H_ROW, &H_COL );/M 			while ( ax_help_text->dsc$b_dtype != 0 ) {	/* While data to display...		*/BI 				if ( ax_help_text->dsc$w_length ) {	/* ...if line is non-blank...		*/ E 					SMG$PUT_LINE( &help_display, ax_help_text ); /* ...output it		*/* 				} else {B 					static $DESCRIPTOR( x_press, "Press any key for more help" );O 					SMG$PUT_CHARS( &help_display, &x_press, &H_ROWS, &1, &0, &SMG$M_REVERSE );nO 					SMG$READ_KEYSTROKE( &keyboard, &term_char ); /* ...wait for a character	*/;( 					SMG$ERASE_DISPLAY( &help_display ); 				}  				ax_help_text++;c 			}M 			SMG$PUT_CHARS( &help_display, &x_press, &H_ROWS, &1, &0, &SMG$M_REVERSE ); L 			SMG$READ_KEYSTROKE( &keyboard, &term_char );	/* Wait for a character			*/\ 			SMG$UNPASTE_VIRTUAL_DISPLAY( &help_display, &pasteboard ); /* ...then unpaste the help	*/	 			break;	  + 		case SMG$K_TRM_CTRLR:					/* CTRL/R				*/	; 			reset_flag = TRUE;				/* Reset counters at next read		*/b	 			break;e  + 		case SMG$K_TRM_CTRLW:					/* CTRL/W				*/	H 			SMG$REPAINT_SCREEN( &p_board );			/* Repaint the screen when ready	*/	 			break;*  + 		case SMG$K_TRM_CTRLC:					/* CTRL/C				*/*+ 		case SMG$K_TRM_CTRLY:					/* CTRL/Y				*/u+ 		case SMG$K_TRM_CTRLZ:					/* CTRL/Z				*/tZ 			SMG$BEGIN_DISPLAY_UPDATE( &display );		/* Ensure we stay in batch and output is done */Z 			SMG$SET_CURSOR_ABS( &display, &MAXROW, &MINCOL ); /* Move cursor to bottom of screen	*/K 			SMG$END_DISPLAY_UPDATE( &display );		/* Move the cursor (physically)		*/	4 			SYS$WAKE( 0, 0 );				/* Wake up the main code		*/	 			break;	  
 		default:D 			SMG$RING_BELL( &display );			/* Ring the bell to tell the user	*/	 			break;p 	} }  1