4 /* FILE.C, a utility to modify file characteristics.   K    Written by Joe Meadows Jr, at the Fred Hutchinson Cancer Research Center     BITNET: JOE@FHCRCVAX     PHONE: (206) 467-4970   K    There are no restrictions on this code, you may sell it, include it with N    any commercial package, or feed it to a whale.. However, I would appreciateJ    it if you kept this comment in the source code so that anyone receivingI    this code knows who to contact in case of problems. Note that I do not     demand this condition..  */  /* Modifications:       05-OCT-1987A      changed calls to strcmp() into strncmp() to fix problem with E      not being able to abbreviate keywords in /TYPE and /ORGANIZATION       15-SEP-1987G      modified handling of qualifiers, move check for /OUTPUT outside of D      loop, get values of all other qualifiers before looping through      wildcarded filenames.      22-AUG-1987C      Bugfixes (argh!). Fixed output of /NOEXACT, added "-" to first I      line of output. Handle list of file names, as documented.. Make sure >      all lines are under 80 characters, so mailers don't barf.      25-Jan-1989B      Add call to init_cli, so it can be defined as foreign command      or a real command.       26-SEP-1989H      Fixed handling of efblk and hiblk w.r.t. large files (> 64k blocks)      06-OCT-1989!      Added /PROTECTION qualifier!       10-OCT-19893      added "-" to end of /protection output (argh!)       11-OCT-1989      Added /OWNER qualifier       13-APR-1990 (Ned Freed)4      Fixed problem with local negation of qualifiers  #      11-JAN-1990 16:55:42.11 Portia E      added /FID qualifier so we can "recover" a file which was marked B      for delete, the /char=nomark_for_delete does not seem to workC      so all we did was to make a directory entry for the file, then       it could be copied, etc. )         FILE/FID=(100,2,1) D0:[dir]file.x >      will enter file whose fid was (100,2,1) as d0:[dir]file.x  4      20-JUL-1990 JEM - changed output of OWNER field */      #include "standard.h"    #ifndef __GNUC__ #   include descrip  #   include rms  #   include stdio  #   include iodef  #   include atrdef #   include climsgdef  #else  #   include <descrip.h>  #   include <rms.h>  #   include <stdio.h>  #   include <iodef.h> F #   include <atrdef.h>  /* this gets created with the c3.0 compiler */F #   include <fibdef.h>  /* this gets created with the c3.0 compiler */! #  define CLI$_NEGATED 0X000381F8 ! #  define CLI$_LOCNEG  0X00038230  #endif    #include "fibdef.h"  #include "fatdef.h"  #include "fchdef.h"  #include "fjndef.h"  #include "cld.h"   2 #define RTYPE fat$r_rtype_overlay.fat$r_rtype_bits8 #define RATTRIB fat$r_rattrib_overlay.fat$r_rattrib_bits4 #define EFBLK fat$r_efblk_overlay.fat$r_efblk_fields4 #define HIBLK fat$r_hiblk_overlay.fat$r_hiblk_fields    char *cvt_time();  char *format_uic();  unsigned int change(); unsigned int antichange();    #ifndef __GNUC__   globalvalue FILE_CLD;  #else    extern FILE_CLD; #endif    main() {    static struct FAB Fab;   static struct NAM Nam;+   static struct fibdef Fib; /* short fib */    (   static struct dsc$descriptor FibDesc =3     {sizeof(Fib),DSC$K_DTYPE_Z,DSC$K_CLASS_S,&Fib}; *   static struct dsc$descriptor_s DevDesc =6     {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,&Nam.nam$t_dvi[1]};   static struct fatdef Fat;    static union {     struct fchdef fch;     long int dummy; 
   } uchar;   static struct fjndef jnl; 6   static long int Cdate[2],Rdate[2],Edate[2],Bdate[2];   static short int revisions;    static unsigned long uic;    static union {     unsigned short int value;      struct {       unsigned system : 4;       unsigned owner : 4;        unsigned group : 4;        unsigned world : 4;      } bits; 	   } prot;        static struct atrdef Atr[] = {D     {sizeof(Fat),ATR$C_RECATTR,&Fat},        /* record attributes */G     {sizeof(uchar),ATR$C_UCHAR,&uchar},      /* File characteristics */ @     {sizeof(Cdate),ATR$C_CREDATE,&Cdate[0]}, /* Creation date */@     {sizeof(Rdate),ATR$C_REVDATE,&Rdate[0]}, /* Revision date */B     {sizeof(Edate),ATR$C_EXPDATE,&Edate[0]}, /* Expiration date */>     {sizeof(Bdate),ATR$C_BAKDATE,&Bdate[0]}, /* Backup date */L     {sizeof(revisions),ATR$C_ASCDATES,&revisions}, /* number of revisions */C     {sizeof(prot),ATR$C_FPRO,&prot},         /* file protection  */ =     {sizeof(uic),ATR$C_UIC,&uic},            /* file owner */ @     {sizeof(jnl),ATR$C_JOURNAL,&jnl},        /* journal flags */     {0,0,0}    } ;    "   static char EName[NAM$C_MAXRSS];"   static char RName[NAM$C_MAXRSS];+   static struct dsc$descriptor_s FileName = &     {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};L   static struct dsc$descriptor_s string = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};   static short int DevChan;    static short int iosb[4];       static long int i,j,status;    static char *retval;   static short int output = 0;   %   status = init_cli(FILE_CLD,"FILE");    "   if (cli_present("OUTPUT") & 1) {B     /* see if they want output to go to a file or to SYS$OUTPUT */-     status = cli_get_value("OUTPUT",&retval);      if (status & 1) 4       freopen(retval,"w",stdout,"rfm=var","rat=cr");     output = 1;    };   +   while (cli_get_value("P1",&retval) & 1) { F     /* initialize RMS structures, we need a NAM to retrieve the FID */     Fab = cc$rms_fab; /     Fab.fab$l_fna = retval ; /* name of file */ #     Fab.fab$b_fns = strlen(retval); 9     Fab.fab$l_nam = &Nam; /* FAB has an associated NAM */      Nam = cc$rms_nam; 3     Nam.nam$l_esa = &EName; /* expanded filename */ "     Nam.nam$b_ess = sizeof(EName);4     Nam.nam$l_rsa = &RName; /* resultant filename */"     Nam.nam$b_rss = sizeof(RName);   $     /* do $PARSE and $SEARCH here */     status = sys$parse(&Fab); &     if (!(status & 1)) return(status);   E     /* fill in the FID if specified *//* can not do a list of them */ !     if (cli_present(t_fid) & 1) {        int tmpfid;   ,       status = cli_get_value(t_fid,&retval);(       if (!(status & 1)) return(status);       tmpfid = atoi(retval);-       Nam.nam$w_fid[0] = tmpfid & 0x0000ffff;    ,       status = cli_get_value(t_fid,&retval);(       if (!(status & 1)) return(status);&       Nam.nam$w_fid[1] = atoi(retval);   ,       status = cli_get_value(t_fid,&retval);(       if (!(status & 1)) return(status);&       Nam.nam$w_fid[2] = atoi(retval);       if (tmpfid > 0x0000ffff)L       { /* this code is untested - I don't have this many files anywhere! */9         Nam.nam$w_fid[2] |= ((tmpfid & 0x00ff0000) >> 8);        }        status = sys$enter(&Fab);      } 
     else {<       /* search for the first file.. If none signal error */        status = sys$search(&Fab);(       if (!(status & 1)) return(status);     }        while (status & 1) {=       /* dummy cli_get_value, used merely to reset context */ /       status = cli_get_value("OUTPUT",&retval);    J       /* initialize Device name length, note that this points into the NAML          to get the device name filled in by the $PARSE, $SEARCH services */.       DevDesc.dsc$w_length = Nam.nam$t_dvi[0];   1       status = sys$assign(&DevDesc,&DevChan,0,0); (       if (!(status & 1)) return(status);   .       FileName.dsc$a_pointer = Nam.nam$l_name;J       FileName.dsc$w_length = Nam.nam$b_name+Nam.nam$b_type+Nam.nam$b_ver;          /* Initialize the FIB */       for (i=0;i<3;i++) <         Fib.fib$r_fid_overlay.fib$w_fid[i]=Nam.nam$w_fid[i];       for (i=0;i<3;i++) <         Fib.fib$r_did_overlay.fib$w_did[i]=Nam.nam$w_did[i];   E       /* Use the IO$_ACCESS function to return info about the file */ K       /* Note, used this way, the file is not opened, and the expiration */ /       /* and revision dates are not modified */ 7       status = sys$qiow(0,DevChan,IO$_ACCESS,&iosb,0,0, 7                         &FibDesc,&FileName,0,0,&Atr,0); (       if (!(status & 1)) return(status);       status = iosb[0]; (       if (!(status & 1)) return(status);          if (output) {    L         /* if it's /noexact, use only name & type part of the result name */I         /* also fudge the resultant file name to have null termination */ '         if (cli_present("EXACT") & 1) {            i = 0;           j = Nam.nam$b_rsl;	         }          else {=           i = Nam.nam$b_node + Nam.nam$b_dev + Nam.nam$b_dir; ,           j = Nam.nam$b_name+Nam.nam$b_type;	         } .         printf("$ FILE %.*s-\n",j,&RName[i] );   #         /* print protection here */ B         printf("  /%s=(S%s%s,O%s%s,G%s%s,W%s%s) -\n",t_protection,K              (prot.bits.system != 15)?":":"", t_fileprot[prot.bits.system], I              (prot.bits.owner != 15)?":":"", t_fileprot[prot.bits.owner], I              (prot.bits.group != 15)?":":"", t_fileprot[prot.bits.group], J              (prot.bits.world != 15)?":":"", t_fileprot[prot.bits.world]);8         printf("  /%s=%s -\n",t_owner, format_uic(uic));C         printf("  /%s=%s",t_rtype,ta_rtype[Fat.RTYPE.fat$v_rtype]); M         printf("  /%s=%s -\n",t_fileorg,ta_fileorg[Fat.RTYPE.fat$v_fileorg]); 1         printf("  /%s=(%s%s,%s%s,%s%s,%s%s) -\n",            t_attr, :           Fat.RATTRIB.fat$v_fortrancc?"":"NO",t_fortrancc,:           Fat.RATTRIB.fat$v_impliedcc?"":"NO",t_impliedcc,6           Fat.RATTRIB.fat$v_printcc?"":"NO",t_printcc,5           Fat.RATTRIB.fat$v_nospan?"NO":"",t_nospan);    1         printf("  /%s=(%s%s,%s%s,%s%s,%s%s, -\n",            t_char, 2           uchar.fch.fch$v_badacl?"":"NO",t_badacl,6           uchar.fch.fch$v_nobackup?"NO":"",t_nobackup,4           uchar.fch.fch$v_contigb?"":"NO",t_contigb,6          uchar.fch.fch$v_nocharge?"NO":"",t_nocharge);3         printf("    %s%s,%s%s,%s%s,%s%s,%s%s, -\n", 2           uchar.fch.fch$v_contig?"":"NO",t_contig,8           uchar.fch.fch$v_directory?"":"NO",t_directory,0           uchar.fch.fch$v_erase?"":"NO",t_erase,6           uchar.fch.fch$v_badblock?"":"NO",t_badblock,3           uchar.fch.fch$v_locked?"":"NO",t_locked); 3         printf("    %s%s,%s%s,%s%s,%s%s,%s%s) -\n", 4           uchar.fch.fch$v_markdel?"":"NO",t_markdel,0           uchar.fch.fch$v_spool?"":"NO",t_spool,8           uchar.fch.fch$v_readcheck?"":"NO",t_readcheck,8           uchar.fch.fch$v_writeback?"":"NO",t_writeback,9           uchar.fch.fch$v_writcheck?"":"NO",t_writcheck); 8         printf("  /%s=%d",t_vfcsize,Fat.fat$b_vfcsize );4         printf("  /%s=%d",t_rsize,Fat.fat$w_rsize );:         printf("  /%s=%d -\n",t_maxrec,Fat.fat$w_maxrec );"         printf("  /%s=%d",t_efblk,D                (Fat.EFBLK.fat$w_efblkh<<16)|Fat.EFBLK.fat$w_efblkl);:         printf("  /%s=%d -\n",t_ffbyte,Fat.fat$w_ffbyte );&         printf("  /%s=%d -\n",t_hiblk,D                (Fat.HIBLK.fat$w_hiblkh<<16)|Fat.HIBLK.fat$w_hiblkl);:         printf("  /%s=%d -\n",t_defext,Fat.fat$w_defext );<         printf("  /%s=%d -\n",t_bktsize,Fat.fat$b_bktsize );4         printf("  /%s=%d -\n",t_gbc,Fat.fat$w_gbc );=         printf("  /%s=%d -\n",t_dirvers,Fat.fat$w_versions ); >         printf("  /%s=%d -\n",t_versions,Fib.fib$w_verlimit );@         printf("  /%s=(%s%s,%s%s,%s%s,%s%s,%s%s,%s%s,%s%s) -\n",           t_journal,8           jnl.fjn$v_journal_file?"":"NO",t_journal_file,*           jnl.fjn$v_aijnl?"":"NO",t_aijnl,*           jnl.fjn$v_atjnl?"":"NO",t_atjnl,*           jnl.fjn$v_bijnl?"":"NO",t_bijnl,*           jnl.fjn$v_rujnl?"":"NO",t_rujnl,0           jnl.fjn$v_never_ru?"":"NO",t_never_ru,/           jnl.fjn$v_only_ru?"":"NO",t_only_ru); +         if ((Cdate[0]==0) && (Cdate[1]==0)) *           printf("  /NO%s -\n",t_credate);         else?           printf("  /%s=\"%s\" -\n",t_credate,cvt_time(Cdate)); +         if ((Rdate[0]==0) && (Rdate[1]==0)) &           printf("  /NO%s",t_revdate);         else;           printf("  /%s=\"%s\"",t_revdate,cvt_time(Rdate)); 5         printf("  /%s=%d -\n",t_revisions,revisions); +         if ((Edate[0]==0) && (Edate[1]==0)) *           printf("  /NO%s -\n",t_expdate);         else?           printf("  /%s=\"%s\" -\n",t_expdate,cvt_time(Edate)); +         if ((Bdate[0]==0) && (Bdate[1]==0)) (           printf("  /NO%s\n",t_bakdate);         else=           printf("  /%s=\"%s\"\n",t_bakdate,cvt_time(Bdate)); -       }; /* if (cli_present("OUTPUT") & 1) */    %       if (cli_present(t_rtype) & 1) { 0         status = cli_get_value(t_rtype,&retval);         for (i=0;i<7;i++) <           if (strncmp(retval,ta_rtype[i],strlen(retval))==0)&             Fat.RTYPE.fat$v_rtype = i;       };'       if (cli_present(t_fileorg) & 1) { 2         status = cli_get_value(t_fileorg,&retval);         for (i=0;i<4;i++) >           if (strncmp(retval,ta_fileorg[i],strlen(retval))==0)(             Fat.RTYPE.fat$v_fileorg = i;       };$       if (cli_present(t_attr) & 1) {%         Fat.RATTRIB.fat$v_fortrancc = C             change(Fat.RATTRIB.fat$v_fortrancc,t_attr,t_fortrancc); %         Fat.RATTRIB.fat$v_impliedcc = C             change(Fat.RATTRIB.fat$v_impliedcc,t_attr,t_impliedcc); %         Fat.RATTRIB.fat$v_printcc   = ?             change(Fat.RATTRIB.fat$v_printcc,t_attr,t_printcc); %         Fat.RATTRIB.fat$v_nospan    = A             antichange(Fat.RATTRIB.fat$v_nospan,t_attr,t_nospan);        };$       if (cli_present(t_char) & 1) {          uchar.fch.fch$v_badacl =9           change(uchar.fch.fch$v_badacl,t_char,t_badacl); "         uchar.fch.fch$v_nobackup =A           antichange(uchar.fch.fch$v_nobackup,t_char,t_nobackup); !         uchar.fch.fch$v_contigb = ;           change(uchar.fch.fch$v_contigb,t_char,t_contigb); "         uchar.fch.fch$v_nocharge =A           antichange(uchar.fch.fch$v_nocharge,t_char,t_nocharge);           uchar.fch.fch$v_contig =9           change(uchar.fch.fch$v_contig,t_char,t_contig); #         uchar.fch.fch$v_directory = ?           change(uchar.fch.fch$v_directory,t_char,t_directory);          uchar.fch.fch$v_erase = 7           change(uchar.fch.fch$v_erase,t_char,t_erase); "         uchar.fch.fch$v_badblock ==           change(uchar.fch.fch$v_badblock,t_char,t_badblock);           uchar.fch.fch$v_locked =9           change(uchar.fch.fch$v_locked,t_char,t_locked); !         uchar.fch.fch$v_markdel = ;           change(uchar.fch.fch$v_markdel,t_char,t_markdel); M         uchar.fch.fch$v_spool = change(uchar.fch.fch$v_spool,t_char,t_spool); #         uchar.fch.fch$v_readcheck = ?           change(uchar.fch.fch$v_readcheck,t_char,t_readcheck); #         uchar.fch.fch$v_writeback = ?           change(uchar.fch.fch$v_writeback,t_char,t_writeback); #         uchar.fch.fch$v_writcheck = ?           change(uchar.fch.fch$v_writcheck,t_char,t_writcheck);        };'       if (cli_present(t_vfcsize) & 1) { 2         status = cli_get_value(t_vfcsize,&retval);)         Fat.fat$b_vfcsize = atoi(retval);        };%       if (cli_present(t_rsize) & 1) { 0         status = cli_get_value(t_rsize,&retval);'         Fat.fat$w_rsize = atoi(retval);        };&       if (cli_present(t_maxrec) & 1) {1         status = cli_get_value(t_maxrec,&retval); (         Fat.fat$w_maxrec = atoi(retval);       };%       if (cli_present(t_efblk) & 1) { 0         status = cli_get_value(t_efblk,&retval);2         Fat.EFBLK.fat$w_efblkh = atoi(retval)>>16;7         Fat.EFBLK.fat$w_efblkl = atoi(retval) & 0xffff;        };&       if (cli_present(t_ffbyte) & 1) {1         status = cli_get_value(t_ffbyte,&retval); (         Fat.fat$w_ffbyte = atoi(retval);       };%       if (cli_present(t_hiblk) & 1) { 0         status = cli_get_value(t_hiblk,&retval);2         Fat.HIBLK.fat$w_hiblkh = atoi(retval)>>16;7         Fat.HIBLK.fat$w_hiblkl = atoi(retval) & 0xffff;        };&       if (cli_present(t_defext) & 1) {1         status = cli_get_value(t_defext,&retval); (         Fat.fat$w_defext = atoi(retval);       };'       if (cli_present(t_bktsize) & 1) { 2         status = cli_get_value(t_bktsize,&retval);)         Fat.fat$b_bktsize = atoi(retval);        };#       if (cli_present(t_gbc) & 1) { .         status = cli_get_value(t_gbc,&retval);%         Fat.fat$w_gbc = atoi(retval);        };'       if (cli_present(t_dirvers) & 1) { 2         status = cli_get_value(t_dirvers,&retval);*         Fat.fat$w_versions = atoi(retval);       };(       if (cli_present(t_versions) & 1) {3         status = cli_get_value(t_versions,&retval); *         Fib.fib$w_verlimit = atoi(retval);$         if (Fib.fib$w_verlimit == 0)%           Fib.fib$w_verlimit = 32767;e       };:       /* if this value is illegal, don't try to set it! */%       if (Fib.fib$w_verlimit > 32767)c!           Fib.fib$w_verlimit = 0;t'       if (cli_present(t_journal) & 1) {           jnl.fjn$v_journal_file =D             change(jnl.fjn$v_journal_file,t_journal,t_journal_file);D         jnl.fjn$v_aijnl = change(jnl.fjn$v_aijnl,t_journal,t_aijnl);D         jnl.fjn$v_atjnl = change(jnl.fjn$v_atjnl,t_journal,t_atjnl);D         jnl.fjn$v_bijnl = change(jnl.fjn$v_bijnl,t_journal,t_bijnl);D         jnl.fjn$v_rujnl = change(jnl.fjn$v_rujnl,t_journal,t_rujnl);M         jnl.fjn$v_never_ru = change(jnl.fjn$v_never_ru,t_journal,t_never_ru);oJ         jnl.fjn$v_only_ru = change(jnl.fjn$v_only_ru,t_journal,t_only_ru);       };&       status = cli_present(t_credate);       if (status & 1) { 2         status = cli_get_value(t_credate,&retval);         bintim(retval,Cdate);t       }l
       elseB         if ((status == CLI$_NEGATED) || (status == CLI$_LOCNEG)) {           Cdate[0]=0;n           Cdate[1]=0;9
         };&       status = cli_present(t_revdate);       if (status & 1) {o2         status = cli_get_value(t_revdate,&retval);         bintim(retval,Rdate);        }e
       elseB         if ((status == CLI$_NEGATED) || (status == CLI$_LOCNEG)) {           Rdate[0]=0;"           Rdate[1]=0;o
         };)       if (cli_present(t_revisions) & 1) {l4         status = cli_get_value(t_revisions,&retval);!         revisions = atoi(retval);s       };&       status = cli_present(t_expdate);       if (status & 1) {a2         status = cli_get_value(t_expdate,&retval);         bintim(retval,Edate);d       }e
       elseB         if ((status == CLI$_NEGATED) || (status == CLI$_LOCNEG)) {           Edate[0]=0;e           Edate[1]=0;F
         };&       status = cli_present(t_bakdate);       if (status & 1) { 2         status = cli_get_value(t_bakdate,&retval);         bintim(retval,Bdate);i       }t
       elseB         if ((status == CLI$_NEGATED) || (status == CLI$_LOCNEG)) {           Bdate[0]=0;            Bdate[1]=0;d
         };   $       status = cli_present(t_owner);       if (status & 1) {h>         status = cli_get_value(t_owner,&string.dsc$a_pointer);*         if (!(status & 1)) return(status);<         string.dsc$w_length = strlen (string.dsc$a_pointer);*         status = parse_uic(&string, &uic);         if (!(status & 1))+           printf("UIC %.*s is not valid\n",e;                  string.dsc$w_length,string.dsc$a_pointer);c       }d  h)       status = cli_present(t_protection);$       if (status & 1) {pD           prot.bits.system = parse_protection(t_protection,"SYSTEM",@                                               prot.bits.system);C           prot.bits.owner  = parse_protection(t_protection,"OWNER",o?                                               prot.bits.owner); C           prot.bits.group  = parse_protection(t_protection,"GROUP",_?                                               prot.bits.group);sC           prot.bits.world  = parse_protection(t_protection,"WORLD",t?                                               prot.bits.world);E       }C  SJ       /* note, part of the FIB was cleared by earlier QIOW, so reset it */;       Fib.fib$r_acctl_overlay.fib$l_acctl = FIB$M_NORECORD;t       for (i=0;i<3;i++) <         Fib.fib$r_fid_overlay.fib$w_fid[i]=Nam.nam$w_fid[i];       for (i=0;i<3;i++)t<         Fib.fib$r_did_overlay.fib$w_did[i]=Nam.nam$w_did[i];  tE       /* Use the IO$_MODIFY function to change info about the file */nK       /* Note, used this way, the file is not opened, however this would */iL       /* normally cause the expiration and revision dates to be modified. */?       /* Using FIB$M_NORECORD prohibits this from happening. */s7       status = sys$qiow(0,DevChan,IO$_MODIFY,&iosb,0,0,e7                         &FibDesc,&FileName,0,0,&Atr,0);e(       if (!(status & 1)) return(status);  C       status = iosb[0];r(       if (!(status & 1)) return(status);  A#       status = sys$dassgn(DevChan); (       if (!(status & 1)) return(status);   6       /* look for next file, if none, no big deal.. */        status = sys$search(&Fab);       }i   }) }R  A long int cli_present(s)u
   char *s; {nJ   static struct dsc$descriptor s_desc = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};   "   s_desc.dsc$w_length = strlen(s);   s_desc.dsc$a_pointer = s;s   return(cli$present(&s_desc));  }     long int cli_get_value(s1,s2)    char *s1,**s2; {cI   static struct dsc$descriptor s1_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};cI   static struct dsc$descriptor s2_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};t   static char null = '\0';*   static struct dsc$descriptor null_desc =/          {1,DSC$K_DTYPE_T,DSC$K_CLASS_S,&null};t   long int status;  c$   s1_desc.dsc$w_length = strlen(s1);   s1_desc.dsc$a_pointer = s1;t   ,   status = cli$get_value(&s1_desc,&s2_desc);      if (status & 1)n     {U$     str$append(&s2_desc,&null_desc);      *s2 = s2_desc.dsc$a_pointer;     }    else     *s2 = 0;   return(status);a }     char *cvt_time(date)   long int date[2];" {d   static char str[27];N   static struct dsc$descriptor date_str={26,DSC$K_DTYPE_T,DSC$K_CLASS_S,&str};  i#   if ((date[0]==0) && (date[1]==0))A     return("none");    !   sys$asctim(0,&date_str,date,0);$   str[26]='\0';/  a   return(&str);  }a  a bintim(time,binval)a
   char *time;a   long int binval[2];h {aJ   static struct dsc$descriptor date_str={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};'   date_str.dsc$w_length = strlen(time);     date_str.dsc$a_pointer = time;      sys$bintim(&date_str,binval);  }   . unsigned int change(orig,s1,s2)    unsigned int orig;   char *s1,*s2;  {tI   static struct dsc$descriptor s1_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};fI   static struct dsc$descriptor s2_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};_I   static struct dsc$descriptor s3_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};t   static char point = '.';N   static struct dsc$descriptor pt_desc={1,DSC$K_DTYPE_T,DSC$K_CLASS_S,&point};   long int status;   unsigned int i;t  s$   s1_desc.dsc$w_length = strlen(s1);   s1_desc.dsc$a_pointer = s1;t$   s2_desc.dsc$w_length = strlen(s2);   s2_desc.dsc$a_pointer = s2;g  v   /* s3 = s1 + "." + s2 */!   str$copy_dx(&s3_desc,&s1_desc);     str$append(&s3_desc,&pt_desc);    str$append(&s3_desc,&s2_desc);   !   status = cli$present(&s3_desc);I	   i=orig;    if (status & 1)w     i=1;:   if ((status == CLI$_NEGATED) || (status == CLI$_LOCNEG))     i=0;   return(i); }s  t# unsigned int antichange(orig,s1,s2)    unsigned int orig;   char *s1,*s2;s {aI   static struct dsc$descriptor s1_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};rI   static struct dsc$descriptor s2_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};eI   static struct dsc$descriptor s3_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};r   static char point = '.';N   static struct dsc$descriptor pt_desc={1,DSC$K_DTYPE_T,DSC$K_CLASS_S,&point};   long int status;   unsigned int i;$  R$   s1_desc.dsc$w_length = strlen(s1);   s1_desc.dsc$a_pointer = s1; $   s2_desc.dsc$w_length = strlen(s2);   s2_desc.dsc$a_pointer = s2;&  )   /* s3 = s1 + "." + s2 */!   str$copy_dx(&s3_desc,&s1_desc);n    str$append(&s3_desc,&pt_desc);    str$append(&s3_desc,&s2_desc);  a!   status = cli$present(&s3_desc);h	   i=orig;    if (status & 1)+     i=0;:   if ((status == CLI$_NEGATED) || (status == CLI$_LOCNEG))     i=1;   return(i); }   i; int parse_protection(char *s1, char *s2, unsigned int orig)  {UI   static struct dsc$descriptor s1_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};,I   static struct dsc$descriptor s2_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};dI   static struct dsc$descriptor s3_desc={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};_   static char point = '.';N   static struct dsc$descriptor pt_desc={1,DSC$K_DTYPE_T,DSC$K_CLASS_S,&point};   long int status, j;s
   char *c;   unsigned int i = orig;  t$   s1_desc.dsc$w_length = strlen(s1);   s1_desc.dsc$a_pointer = s1;c$   s2_desc.dsc$w_length = strlen(s2);   s2_desc.dsc$a_pointer = s2;u      /* s3 = s1 + "." + s2 */!   str$copy_dx(&s3_desc,&s1_desc);f    str$append(&s3_desc,&pt_desc);    str$append(&s3_desc,&s2_desc);  $!   status = cli$present(&s3_desc);    if (status & 1)a   {o
     i = 0x0f;d.     status = cli$get_value(&s3_desc,&s3_desc);     if (status & 1)      { 0       /* loop through checking for R, W, E, D */        c = s3_desc.dsc$a_pointer;*       for (j=0;j<s3_desc.dsc$w_length;j++)       {s         switch (*c) 	         { $           case 'R' : i &= ~1; break;$           case 'W' : i &= ~2; break;$           case 'E' : i &= ~4; break;$           case 'D' : i &= ~8; break;           default:=             printf("Illegal protection specified '%c'\n",*c);t             break;
         };         ++c;       };     };   };   return(i); },   char *format_uic(uic);     unsigned long uic; {,     static char id[66];EL     static struct dsc$descriptor id_str={65,DSC$K_DTYPE_T,DSC$K_CLASS_S,id};     unsigned short int idlen;n     long int status;
     struct     {          VARIANT_UNION 	         {T             unsigned long l1;o             VARIANT_STRUCT
             {e"                 unsigned short w1;"                 unsigned short w2;             } END_VARIANT;         } END_VARIANT;     } uic_overlay;       id[0] = '\0';%3     status = sys$idtoasc(uic,&idlen,&id_str,0,0,0);      if (status & 1)a     {:         id[idlen] = '\0';c     }.     else     {O         uic_overlay.l1 = uic;a?         sprintf(id, "[%o,%o]", uic_overlay.w2, uic_overlay.w1);n     }?       return(id);; } 