 /* **++ **  FACILITY:	MX Examples  **: **  ABSTRACT:	Example of a message filter for use with MX. ** **  MODULE DESCRIPTION:  **? **  	This module contains routines for use by the MX Router for D **  filtering messages based on envelope and header information.  To **  build it, use: ** **  $ CC FILTER L **  $ LINK/NOTRACE/SHARE/EXEC=MX_EXE:FILTERSHR.EXE FILTER.OBJ,SYS$INPUT:/OPT **8 **  For VAX systems, enter the following linker options:C **    SYS$LIBRARY:VAXCRTL/SHARE    (only if using VAX C, not DEC C) " **    UNIVERSAL=INIT,FILTER,FINISH3 **  For Alpha systems, enter these options instead: F **    SYMBOL_VECTOR=(INIT=PROCEDURE,FILTER=PROCEDURE,FINISH=PROCEDURE) **3 **  Once linked, define the following logical name:  **D **  $ DEFINE/SYSTEM/EXEC MX_SITE_MESSAGE_FILTER MX_EXE:FILTERSHR.EXE **1 **  Then stop and restart or reset the MX Router:  ** **  $ MCP RESET ROUTER **C **  -- You should NOT use the C run-time memory-allocation routines G **     (e.g., malloc and free) to allocate dynamic memory here.  Please . **     use LIB$GET_VM and LIB$FREE_VM instead. ** ** -------------F **  PLEASE NOTE:  This is an UNDOCUMENTED and UNSUPPORTED interface to< **  	    	  MX that is subject to change in future versions. ** -------------   ** **  AUTHOR: 	    M. Madison   '    Copyright (c) 2008, Matthew Madison.          All rights reserved.      E    Redistribution and use in source and binary forms, with or without E    modification, are permitted provided that the following conditions     are met:      =        * Redistributions of source code must retain the above D          copyright notice, this list of conditions and the following          disclaimer.@        * Redistributions in binary form must reproduce the aboveD          copyright notice, this list of conditions and the followingH          disclaimer in the documentation and/or other materials provided          with the distribution. E        * Neither the name of the copyright owner nor the names of any F          other contributors may be used to endorse or promote productsB          derived from this software without specific prior written          permission.     F    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSD    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTH    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORG    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT H    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,C    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT H    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,H    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYF    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTH    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEG    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  08-SEP-1997  ** **  MODIFICATION HISTORY:  **1 **  	08-SEP-1997 V1.0    Madison 	Initial coding.  **-- */ #include <lib$routines.h>  #include <ssdef.h> #include <stsdef.h>  #include <descrip.h> #include <string.h>  #include <stdlib.h>  #include "mx_filterdef.h"    /*- **  Item lists are used to convey information  */ #pragma member_alignment __save  #pragma nomember_alignment      typedef struct item_list_3 {#     	unsigned short bufsiz, itmcod;      	void *bufadr, *retlen;      } ITMLST3;   /*0 **  The returned-information item list structure0 **  uses the third longword a little differently( **  (and only for header modifications). */'     typedef struct return_item_list_3 { #     	unsigned short bufsiz, itmcod;      	void *bufadr;'     	unsigned short preference, tagnum;      } RITMLST3; " #pragma member_alignment __restore   /*5 **  Context structure for tracking memory we allocate  */     typedef struct {     	unsigned int rcptbufsize;     	RITMLST3 *rcptbuf;      	unsigned int hdrbufsize;      	RITMLST3 *hdrbuf;     	} CONTEXT;   7     static unsigned int CONTEXT_SIZE = sizeof(CONTEXT);  /* **  Forward declarations */(     unsigned int INIT(CONTEXT **contxt);K     unsigned int FILTER(CONTEXT **contxt, ITMLST3 *envlst, ITMLST3 *hdrlst, C     	    	    	struct dsc$descriptor *msgfile, RITMLST3 **addrcpts, #     	    	    	RITMLST3 **addhdrs); *     unsigned int FINISH(CONTEXT **contxt);   /* **++ **  ROUTINE:	INIT  ** **  FUNCTIONAL DESCRIPTION:  **0 **  	Initializes context for the message filter. ** **  RETURNS:	condition value ** **  PROTOTYPE: ** **  	INIT  contxt  **D **  contxt: 	user_arg, longword (unsigned), write only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */& unsigned int INIT (CONTEXT **contxt) {       unsigned int status;  0     status = LIB$GET_VM (&CONTEXT_SIZE, contxt);  $     if ($VMS_STATUS_SUCCESS(status))&     	memset(*contxt, 0, CONTEXT_SIZE);       return status;   } /* INIT */   /* **++ **  ROUTINE:	FILTER  ** **  FUNCTIONAL DESCRIPTION:  ** **  	Runs the message filter.  ** **  RETURNS:	condition value ** **  PROTOTYPE: **> **  	FILTER  contxt, envlst, hdrlst, msgfile, addrcpt, addhdrs **@ **  contxt: 	user_arg, longword (unsigned), modify, by referenceF **  envlst: 	item_list_3, longword (unsigned), read only, by referenceF **  hdrlst: 	item_list_3, longword (unsigned), read only, by referenceD **  msgfile:	char_string, character string, read only, by descriptorT **  addrcpt:	address (of item_list_3), longword (unsigned), write only, by referenceT **  addhdrs:	address (of item_list_3), longword (unsigned), write only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */H unsigned int FILTER (CONTEXT **contxt, ITMLST3 *envlst, ITMLST3 *hdrlst,C     	    	     struct dsc$descriptor *msgfile, RITMLST3 **addrcpts, $     	    	     RITMLST3 **addhdrs) {       ITMLST3 *itm;      RITMLST3 *ritm; .     unsigned int message_size, message_source;     int found_org;     int sender_len;      char *sender_ptr;   <     static char rewrite_test_recip[] = "<testuser@rewrite>";>     static char rewrite_target_recip[] = "<resutset@etirwer>";:     static char delete_test_recip[] = "<testuser@delete>";:     static char reject_test_recip[] = "<testuser@reject>";G     static char reject_message[] = "This is a test rejection message."; :     static char bouncemaster[] = "<bounce@bounce.master>";3     static char organization[] = "X-Organization:"; Z     static char my_organization[] = "X-Organization: International Union of Mail Hackers";   /*& **  Run through the envelope itemlist. */H     for (itm = envlst; !(itm->bufsiz == 0 && itm->itmcod == 0); itm++) {       	switch (itm->itmcod) {  /*< **  FLTR__ENV_MSGSIZE:  size of message, in bytes (longword)5 **  This is provided for informational purposes only.  */     	case FLTR__ENV_MSGSIZE:5     	    message_size = *(unsigned int *)itm->bufadr;      	    break;    /*? **  FLTR__ENV_SOURCE:	code indicating message source (longword) > **  This is provided for informational purposes only.  See the0 **  FLTR_K_SOURCE_* constants in MX_FILTERDEF.H. */4     	case FLTR__ENV_SOURCE:  /* This is read-only */7     	    message_source = *(unsigned int *)itm->bufadr;      	    break;  /*0 **  FLTR__ENV_SENDER:	address of sender (string)? **  This item comes with a pointer to another ITMLST3 structure C **  in the retlen field for returning information.  You can rewrite C **  the sender address by setting the itmcod field in the returned- A **  information item and providing the new address in the bufsiz/  **  bufadr fields there. */     	case FLTR__ENV_SENDER: "     	    sender_len	= itm->bufsiz;"     	    sender_ptr	= itm->bufadr;     	    break;  /*3 **  If we were to rewrite the sender, we would use:  ** **  	    ritm = itm->retlen;& **  	    ritm->itmcod = FLTR__REWRITE;- **  	    ritm->bufsiz = length of new address @ **  	    ritm->bufadr = pointer to string containing new address **G **  It's important that the new address be surrounded by angle brackets   **  just as the old address was. */   /*B **  Each recipient is listed in the item list, and each comes with> **  a returned-information ITMLST3 structure pointed at by the= **  retlen field.  Valid returned-information item codes are: 3 **       FLTR__REWRITE       to rewrite the address = **       FLTR__REJECT        to cause delivery to be rejected G **                           (with an error message returned to sender) F **       FLTR__DELETE        to cause delivery to be skipped, silently ** **  See the examples below.  */     	case FLTR__ENV_RECIPIENT:;     	    if (itm->bufsiz == sizeof(rewrite_test_recip)-1 && J     	    	    memcmp(itm->bufadr, rewrite_test_recip, itm->bufsiz) == 0) {     	    	ritm = itm->retlen; 6     	    	ritm->bufsiz = strlen(rewrite_target_recip);.     	    	ritm->bufadr = rewrite_target_recip;'     	    	ritm->itmcod = FLTR__REWRITE; 
     	    }  :     	    if (itm->bufsiz == sizeof(reject_test_recip)-1 &&I     	    	    memcmp(itm->bufadr, reject_test_recip, itm->bufsiz) == 0) {      	    	ritm = itm->retlen; ]     	    	ritm->bufsiz = strlen(reject_message);  /* If you do not specify a message here, */ ]     	    	ritm->bufadr = reject_message;          /* a generic message will be used        */ &     	    	ritm->itmcod = FLTR__REJECT;
     	    }  :     	    if (itm->bufsiz == sizeof(delete_test_recip)-1 &&I     	    	    memcmp(itm->bufadr, delete_test_recip, itm->bufsiz) == 0) {      	    	ritm = itm->retlen; &     	    	ritm->itmcod = FLTR__DELETE;
     	    }     	    break; 
     	default:      	    break;      	} /* switch */        } /* for */    /*L **  Any additional recipients you might want to add should be provided in anN **  item list (an array of ITMLST3 structures, with list termination indicatedJ **  by bufsiz & itmcod fields equal to zero) that you allocate.  Place theA **  address of the itemlist in the _addrcpts_ argument.  Example:  */J     if (sender_len == 2 && *sender_ptr == '<' && *(sender_ptr+1) == '>') {     	RITMLST3 *newlst;     	unsigned int newsize;  $     	newsize = 2 * sizeof(RITMLST3);@     	if ($VMS_STATUS_SUCCESS (LIB$GET_VM (&newsize, &newlst))) {     	    newlst[0].itmcod = 0;1     	    newlst[0].bufsiz = strlen(bouncemaster);R)     	    newlst[0].bufadr = bouncemaster; 5     	    newlst[0].preference = newlst[0].tagnum = 0; 1     	    newlst[1].itmcod = newlst[1].bufsiz = 0;n     	    *addrcpts = newlst;J     	    (*contxt)->rcptbuf = newlst; /* Save pointer for freeing later */*     	    (*contxt)->rcptbufsize = newsize;     	}     }C   /*Q **  The header list is also provided as an item list, with a returned-information/[ **  item pointed to by the retlen field of each item.  You can use the returned-informationM8 **  item to delete, rewrite, and/or reorder the headers. **S **  Note that the bufadr/buflen fields point only to the TEXT of the header, and do R **  not include the tag (e.g., "Subject:", "From:", etc.).  The tag is representedR **  numerically by the itmcod field.  If the itmcod field is FLTR__HDR_OTHER, thenG **  the tag was not recognized by MX and the text DOES include the tag.. **  	-R **  Use the FLTR__DELETE and FLTR__REWRITE item codes (as above for recipients) to **  delete and modify headers. **J **  To delete a header, simply set the ritm->itmcod field to FLTR__DELETE.K **  To modify a header, set ritm->itmcod to FLTR__REWRITE, set ritm->bufsiz K **  to the length of the text of the header, and ritm->bufadr to the stringbK **  representing the header text.  Then set ritm->tagnum to the appropriate H **  FLTR__HDR_* code.  If the tag code is FLTR__HDR_OTHER, then the textH **  _should_ include the header tag; otherwise, it _should not_.  DO NOTK **  cheat and use FLTR__HDR_OTHER to insert headers with tags recognized byd+ **  MX -- use the appropriate code instead.* **I **  To reorder the headers:  by default, the headers will be written backcN **  in the order provided to you in the item list, with any additional headersL **  you provide added to the end of the original list.   If you need to haveM **  the headers provided in a certain order, you can set the ritm->preferenceDL **  code to specify the relative preference for each header (with the lowestJ **  preference headers coming first in the list).  The preference code canN **  be any arbitrary integer from zero to 32767, but it will be most efficientI **  if you keep to a small range of integers.  Multiple headers can shareQN **  a single preference value; they will simply be replaced in the order found **  in this list.O */   /*G **  In this example, we'll add an X-Organization: header to the messageYG **  if one is not already there.  If one _is_ there already, we replace E **  it with the one we want.  This applies only to locally-originatedE **  messages, of course. **B **  MX does not have a header code for X-Organization:, so we look3 **  for FLTR__HDR_OTHER and do a string comparison.* */     found_org = 0;  0     if (message_source == FLTR_K_SOURCE_LOCAL) {I     	for (itm = hdrlst; !(itm->bufsiz == 0 && itm->itmcod == 0); itm++) { .     	    if (itm->itmcod == FLTR__HDR_OTHER) {h     	    	if (itm->bufsiz == sizeof(my_organization)-1 &&                     	/* don't replace it if */b     	    	    	memcmp(itm->bufadr, my_organization, itm->bufsiz) == 0) 	/* it's already correct */     	    	    found_org = 1;;     	    	else if (itm->bufsiz >= sizeof(organization)-1 &&ib     	    	    	memcmp(itm->bufadr, organization, sizeof(organization)-1) == 0) {  /* replace it */     	    	    found_org = 1;!     	    	    ritm = itm->retlen;s+     	    	    ritm->itmcod = FLTR__REWRITE;d5     	    	    ritm->bufsiz = strlen(my_organization);M-     	    	    ritm->bufadr = my_organization;*-     	    	    ritm->tagnum = FLTR__HDR_OTHER;a     	    	} 
     	    }     	}  1     	if (!found_org) {   /* none there, add it */b     	    RITMLST3 *newlst;     	    unsigned int newsize;  (     	    newsize = 2 * sizeof(RITMLST3);D     	    if ($VMS_STATUS_SUCCESS (LIB$GET_VM (&newsize, &newlst))) {Y     	    	newlst[0].itmcod = FLTR__HDR_OTHER;  /* note NORMAL place for this code here */ 5     	    	newlst[0].bufsiz = strlen(my_organization);e-     	    	newlst[0].bufadr = my_organization; 6     	    	newlst[0].preference = newlst[0].tagnum = 0;2     	    	newlst[1].itmcod = newlst[1].bufsiz = 0;
     	    }     	    *addhdrs = newlst;*I     	    (*contxt)->hdrbuf = newlst; /* Save pointer for freeing later */v)     	    (*contxt)->hdrbufsize = newsize;n     	}     }o       return SS$_NORMAL;   } /* FILTER */ y /* **++ **  ROUTINE:	FINISHT ** **  FUNCTIONAL DESCRIPTION:O **" **  	Cleans up after a filter run. ** **  RETURNS:	condition value ** **  PROTOTYPE: ** **  	FINISH  contxtC **@ **  contxt: 	user_arg, longword (unsigned), modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.s ** **  COMPLETION CODES:	See code.I ** **  SIDE EFFECTS:   	None. ** **-- */( unsigned int FINISH (CONTEXT **contxt) {       CONTEXT *c = *contxt;        if (c->rcptbuf != 0)0     	LIB$FREE_VM (&c->rcptbufsize, &c->rcptbuf);     if (c->hdrbuf != 0)c.     	LIB$FREE_VM (&c->hdrbufsize, &c->hdrbuf);  $     LIB$FREE_VM (&CONTEXT_SIZE, &c);       *contxt = 0;       return SS$_NORMAL;   } /* FINISH */