# A VMS MMS description file to build the pcal program.
# This has been tested with OpenVMS v5.5-1 & v6.1 on both a VAX and an AXP.
#
# Written by: Rick Dyson (richard-dyson@uiowa.edu) for pcal v4.5
#              6-OCT-1994
#
# To use this 'makefile' on a  VAX, just type
#           MMS /Description = Makefile.mms
# To use this 'makefile' on an AXP, just type
#           MMS /Description = Makefile.mms /Macro = (AXP=1)

DEFS = /Define = ("TIMEZONE=""6 [Iowa City]""", EPS)

.ifdef AXP
CFLAGS	= $(CFLAGS) $(DEFS) /NoList /Optimize /NoDebug /Standard = VAXC
OPTS	= 
.else
CFLAGS	= $(CFLAGS) $(DEFS) /NoList /Optimize /NoDebug
OPTS	= ,VAXCRTL.OPT /Option
.endif

OBJECTS = exprpars.obj moonphas.obj pcalutil.obj readfile.obj writefil.obj
OBJLIST = exprpars,moonphas,pcalutil,readfile,writefil

pcal :	pcal.exe pcal.hlb
	!
	! pcal (v4.5) is now ready for use.  Use @setup to define variables

pcal.exe :	pcal.obj $(OBJECTS) pcalinit.h
	Link pcal,$(OBJLIST)$(OPTS)
#	Set Protection = (System:RWE, Owner:RWE, Group:RE, World:RE) *.*

pcalinit.exe :	pcalinit.obj
	Link $(LDFLAGS) pcalinit$(OPTS)

pcalinit.h :	pcalinit.exe pcalinit.ps
	MCR Sys$Disk:[]pcalinit pcalinit.ps pcalinit.h header

pcal.hlb :	pcal.hlp
exprpars.obj :	exprpars.c pcaldefs.h
moonphas.obj :	moonphas.c pcaldefs.h pcalglob.h
pcal.obj :	pcal.c pcaldefs.h pcalglob.h pcallang.h protos.h
pcalutil.obj :	pcalutil.c pcaldefs.h pcalglob.h pcallang.h protos.h
readfile.obj :	readfile.c pcaldefs.h pcalglob.h pcallang.h protos.h
writefil.obj :	writefil.c pcaldefs.h pcalglob.h pcallang.h pcalinit.h protos.h
pcalinit :	pcalinit.exe
pcal.hlb :	pcal.hlp


#	Library /Log /Create /Help PCAL.HLB PCAL.HLP
#	Set Protection = (System:RWE, Owner:RWE, Group:RE, World:RE) PCAL.HLB
#	Set File /Truncate PCAL.HLB

clean :
	@- Set Protection = Owner:RWED *.*;-1,*.obj,pcalinit.h,pcalinit.exe
	@- Purge /NoLog /NoConfirm
	@- Delete /NoLog /NoConfirm *.obj;*,pcalinit.h;,pcalinit.exe;
#	@- Set Protection = (System:RWE, Owner:RWE) *.*

clobber :
	@- Set Protection = Owner:RWED *.*;-1,*.obj,pcalinit.h
	@- Purge /NoLog /NoConfirm
	@- Delete /NoLog /NoConfirm *.obj;*,pcalinit.h;
#	@- Set Protection = (System:RWE, Owner:RWE) *.*
