 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mkutil.cA This file contains all the miscellaneous utility routines used by ? other parts of the program.  If you can't find something in the / file where it is called, odds are it's in here.    Modifications: SAM		Stephen A. Meadows  	 E SAM 89-May-9	Added the '%' Macro to extract the target file name only ; 		(ie. removed the type/ext, device, and path names).  This = 		proves useful when src/obj/map/lis files exist in different  		paths.  *$  *	Hunter Goatley		 5-JUL-1993 14:547  *		Added definition of FIB$W_FID to allow for the fact 4  *		that fibdef contains variant_unions under Alpha. */   #include <climsgdef.h> #include <fab.h> #include <nam.h> #include <rmsdef.h>  #include <iodef.h> #include <atrdef.h>  #include <fibdef.h>  #include "make.h"   2 #if defined(__union) && (__union == variant_union) #define FIB$W_FID	fib$w_fid  #else - #define FIB$W_FID	fib$r_fid_overlay.fib$w_fid ) #endif	/* #if __union == variant_union */    print_prefix() {  	int i;    	printf(Verbose_prefix);% 	for (i = 0; i < Update_level; i++) {  		putchar(' ');  	} }    /* Translate a logical name. */    translate(str, buf, bufsize) char *str, *buf; int bufsize; {  	int stat, length; 	STR_DESC src, dst;   # 	if (str == NULL || *str == '\0') {  		*buf == '\0'; 
 		return (0);  	}' 	src.sd_len = strlen(src.sd_str = str);  	dst.sd_len = bufsize; 	dst.sd_str = buf; 	length = 0;4 	lib$sys_trnlog(&src, &length, &dst, ___, ___, ___); 	buf[length] = '\0'; 	return (length);  }   H /* Copy the given file name into the space pointed to by buffer, settingF the file type to ftype.  If buffer is NULL, allocate space for the new: file name string.  Return pointer to start of new name. */   char *# set_file_type(fname, ftype, buffer)  char *fname, *ftype, *buffer;  {  	int length;  ! 	/* Make sure file name given. */    	if (fname == NULL) {  		return (NULL); 	}  ; 	/* Get length of file name, excluding file type string. */   ( 	length = find_file_type(fname) - fname;  * 	/* If no buffer given, allocate space. */   	if (buffer == NULL) {1 		buffer = err_alloc(length + strlen(ftype) + 2);  	}  # 	/* Create new file name string. */    	if (buffer != fname) { 
 #ifdef VAXVMS # 		lib$movc3(length, fname, buffer);  #else # 		byte_copy(fname, buffer, length);  #endif 	}! 	buffer[length] = FILE_TYPE_CHAR; % 	strecpy(ftype, &buffer[length + 1]);  	return (buffer);  }   M /* Get file name only, terminated at start of its type, if any. SAM 890509 */    char * file_name(fname, buffer) char *fname, *buffer;  {  	register i; 	register char *pos;   	if (fname != NULL) {    		i   = strlen(fname); 		pos = fname + i;   		while(i--) {	 			pos--; $ 			if (*pos == ']' || *pos == ':') {
 				pos++;
 				break; 			} 		}    		if (buffer == NULL) {  			buffer = newstr(pos, -1); 		} ! 		*find_file_type(buffer) = '\0';  	} 	return (buffer);  }   = /* Terminate a file name at the start of its type, if any. */    char * rm_file_type(fname, buffer)  char *fname; {  	if (fname != NULL) {  		if (buffer == NULL) {  			buffer = newstr(fname, -1); 		} ! 		*find_file_type(buffer) = '\0';  	} 	return (buffer);  }   > /* Return pointer to FILE_TYPE_CHAR, if any; otherwise pointer8 to end of string.  This routine is for VMS filenames. */   char * find_file_type(fname)  register char *fname;  {  	int in_dir_spec;    	in_dir_spec = FALSE;  	while (*fname) {  		switch (*fname) {  		case '[':  			in_dir_spec = TRUE;	 			break;  		case ']':  			in_dir_spec = FALSE; 	 			break;  		case FILE_TYPE_CHAR: 			if (!in_dir_spec) { 				return (fname);  			}	 			break;  		} 
 		fname++; 	} 	return (fname); }    /* Delete the named file. */   delete_file(filename)  char *filename;  {  	STR_DESC fnmdesc;  4 	fnmdesc.sd_len = strlen(fnmdesc.sd_str = filename); 	lib$delete_file(&fnmdesc);  }   = /* Allocate the indicated number of bytes.  Exit on error. */    char * err_alloc(nbyte)
 int nbyte; {  	char *ptr;   % 	if ((ptr = malloc(nbyte)) == NULL) {  #ifdef VMS_ERROR! 		lib$stop(&Mak_alloc, 1, nbyte);  #else @ 		printf("  ** Fatal error, can't allocate %d bytes.\n", nbyte); 		make_exit(NORMAL_EXIT);  #endif 	} 	return (ptr); }   : /* This function returns TRUE if the named file exists. */   file_exists(fname) char *fname; {  	FILE *fptr;  * 	if ((fptr = fopen(fname, "r")) == NULL) { 		return (FALSE);  	} 	fclose(fptr); 	return (TRUE);  }   N /* Run-time initialization of ctype characters which are defined constants. */   init_ctype() {  	Ctype[DEPENDENCY] |= T_;  	Ctype[DEFINE_MACRO] |= T_;  	Ctype[CURR_TARG_NO_EXT] |= S_; A 	Ctype[CURR_TARG_FILE] |= S_;	/* SAM 890509 for file name only */  	Ctype[CURRENT_TARGET] |= S_;  	Ctype[DEPENDENCY_LIST] |= S_; 	Ctype[OUT_OF_DATE_DEPS] |= S_;  	Ctype[UP_TO_DATE_DEPS] |= S_; }   G /* Copy next token from source string into tokbuf.  A token consists of H all characters in source string up to either a null or a token separatorF (sepchr).  Return pointer to first character after token separator, or7 to end of source string if there are no more tokens. */    char *  make_tokstr(str, tokbuf, sepchr) register char *str, *tokbuf; register int sepchr; {  	register int c;  . 	while ((c = *str++) != '\0' && c != sepchr) { 		*tokbuf++ = c; 	} 	*tokbuf = '\0'; 	return (c ? str : str - 1); }   E /* Create a new copy of the given string.  Return pointer to copy. */    char * newstr(string, length)
 char *string;  int length;  {  	char *newptr;   	if (length < 0) { 		length = strlen(string); 	}  	newptr = err_alloc(length + 1); 	strecpy(string, newptr);  	return (newptr);  }   1 /* Free a MAKE_TARGET and any associated data. */    free_target(tgptr) register MAKE_TARGET *tgptr; { ( 	register MAKE_COMMAND *cmdptr, *oldcmd; 	register MAKE_TARGET *oldtptr;    	while (tgptr != NULL) { 		oldtptr = tgptr; 		tgptr = tgptr->tg_next;  		free_token(oldtptr->tg_name);  		free_token(oldtptr->tg_dep); 		cmdptr = oldtptr->tg_cmd;  		while (cmdptr != NULL) { 			oldcmd = cmdptr;  			cmdptr = cmdptr->cmd_next; " 			if (oldcmd->cmd_word != NULL) {! 				free_token(oldcmd->cmd_word);  			} 			free(oldcmd); 		}  		free(oldtptr); 	} }   K /* Free the first MAKE_TOKEN in a list.  Return pointer to rest of list. */    MAKE_TOKEN * free_first_token(tokptr) register MAKE_TOKEN *tokptr; {  	register MAKE_TOKEN *nextptr;   	if (tokptr == NULL) { 		return (NULL); 	}   	nextptr = tokptr->mt_next;  	tokptr->mt_next = NULL; 	free_token(tokptr); 	return (nextptr); }   ! /* Free a list of MAKE_TOKENs. */    free_token(tokptr) register MAKE_TOKEN *tokptr; {  	register MAKE_TOKEN *old_tok;   	while (tokptr != NULL) {  		old_tok = tokptr;  		tokptr = tokptr->mt_next; ! 		if (old_tok->mt_text != NULL) {  			free(old_tok->mt_text); 		}  		free(old_tok); 	} }    #ifndef VAXVMS+ /* Copy count bytes from source to dest. */    byte_copy(source, dest, count) register char *source, *dest;  register int count;  { ) 	/* Check for possible buffer overlap. */    	if (source + count > dest) {  		source += count; 		dest += count; 		while (count-- > 0) {  			*--dest = *--source;  		} 	 	} else {  		while (count-- > 0) {  			*dest++ = *source++;  		}  	} }  #endif  > /* Copy character chr to the nbyte bytes pointed to by ptr. */   byte_fill(ptr, chr, nbyte) register char *ptr;  register int chr, nbyte; {  	while (nbyte-- > 0) { 		*ptr++ = chr;  	} }   G /* Copy the null-terminated string pointed to by source into the buffer L pointed to by dest.  Return a pointer to the null-terminator of the copy. */   char * strecpy(source, dest)  register char *source, *dest;  {  	while (*dest++ = *source++) 		;  	return (dest - 1);  }   : /* Return 1 if the parameter or qualifier whose name (as a< null-terminated string) is pointed to by nmptr was specified< on the command line which invoked this program.  Return 0 if; it was not specified, and -1 if it was negated (/NOxxx). */    cli_present(nmptr) char *nmptr; { 
 	int clistat;  	STR_DESC nmdesc;   / 	nmdesc.sd_len = strlen(nmdesc.sd_str = nmptr);   	clistat = cli$present(&nmdesc); 	if (clistat == CLI$_NEGATED) {  		return (-1); 	} 	return (clistat & 1); }   I /* Attempt to read the value of the command line parameter whose name (as F given in the .CLD file) is in the null-terminated string pointed to byD nmptr.  If the parameter was specified, its value is returned in theC buffer of length valsize which is pointed to by valptr.  Return the B length of the parameter value string, or -1 if the named parameter) was not specified on the command line. */   % cli_get_value(nmptr, valptr, valsize)  char *nmptr, *valptr;  int valsize; { 
 	int val_len;  	STR_DESC nmdesc, valdesc;  
 	val_len = 0; D 	valdesc.sd_len = valsize - 1;	/* leave room for terminating null */ 	valdesc.sd_str = valptr; / 	nmdesc.sd_len = strlen(nmdesc.sd_str = nmptr);   9 	if (!(cli$get_value(&nmdesc, &valdesc, &val_len) & 1)) {  		*valptr = '\0';  		return (-1); 	}   	valptr[val_len] = '\0'; 	return (val_len); }   ' /* Based on code by Joe Meadows, Jr. */   - setfdate(fdscptr, cretm, revtm, baktm, exptm) ; int *fdscptr;		/* address of file name string descriptor */ # int *cretm, *revtm, *baktm, *exptm;  {  	register int *fidptr; 	short chan; 	int status;
 	int fibd[2];  	int atr[4*2 + 1]; 	struct FAB fab; 	struct NAM nam; 	struct fibdef fib; ) 	char es[NAM$C_MAXRSS], rs[NAM$C_MAXRSS];   > 	if (~(status = date_init(1, fdscptr, &cretm, &fab, &nam, atr,' 	    es, rs, &fib, fibd, &chan)) & 1) {  		return (status); 	}  : 	/* This loop processes each file matched by the file name* 	string (which may contain wild-cards). */  < 	while ((status = sys$search(&fab, ___, ___)) != RMS$_NMF) { 		if (status == RMS$_PRV) {  			continue; 		}  		if (status & 1) {   & 			/* Copy file ID from NAM to FIB. */   			fidptr = &fib.FIB$W_FID; % 			*fidptr++ = *(int *)nam.nam$w_fid; ' 			*(short *)fidptr = nam.nam$w_fid[2];    			/* Set date(s). */      			status = sys$qiow( & 			    ___, 		/* default event flag */% 			    chan,		/* channel to device */ ' 			    IO$_MODIFY,		/* function code */ & 			    ___,		/* no I/O status block */) 			    ___, ___,		/* no completion AST */ ( 	  		    fibd,		/* P1, FIB descriptor */) 			    ___, ___, ___,	/* P2-P4, unused */ % 			    atr,		/* P5, attribute list */  			    ___);		/* P6, unused */ 		}  		if (~status & 1) { 			sys$dassgn(chan);  			return (status); 		}  	} 	sys$dassgn(chan); 	return (1); }   > /* Copy the requested file times into the buffers provided. */  - getfdate(fdscptr, cretm, revtm, baktm, exptm) ; int *fdscptr;		/* address of file name string descriptor */ # int *cretm, *revtm, *baktm, *exptm;  {  	register int *fidptr; 	short chan; 	int status;
 	int fibd[2];  	int atr[4*2 + 1]; 	struct FAB fab; 	struct NAM nam; 	struct fibdef fib; ) 	char es[NAM$C_MAXRSS], rs[NAM$C_MAXRSS];   > 	if (~(status = date_init(0, fdscptr, &cretm, &fab, &nam, atr,' 	    es, rs, &fib, fibd, &chan)) & 1) {  		return (status); 	}2 	if (~(status = sys$search(&fab, ___, ___)) & 1) { 		sys$dassgn(chan);  		return (status); 	}  $ 	/* Copy file ID from NAM to FIB. */   	fidptr = &fib.FIB$W_FID; # 	*fidptr++ = *(int *)nam.nam$w_fid; % 	*(short *)fidptr = nam.nam$w_fid[2];    	/* Get date(s). */    	status = sys$qiow( $ 	    ___, 		/* default event flag */# 	    chan,		/* channel to device */ % 	    IO$_ACCESS,		/* function code */ $ 	    ___,		/* no I/O status block */' 	    ___, ___,		/* no completion AST */ $ 	    fibd,		/* P1, FIB descriptor */' 	    ___, ___, ___,	/* P2-P4, unused */ # 	    atr,		/* P5, attribute list */  	    ___);		/* P6, unused */ 	sys$dassgn(chan); 	return (status);  }   H /* Perform initialization required by both setfdate() and getfdate(). */   staticP date_init(setting, fdscptr, tmptr, fabp, namp, atrp, es, rs, fibp, fibdp, chanp)3 int setting;		/* non-zero if dates are to be set */ ; int *fdscptr;		/* pointer to file name string descriptor */ M register int **tmptr;	/* pointer to array of four pointers to date buffers */ 2 register struct FAB *fabp;	/* FAB to initialize */3 register struct NAM *namp;	/* NAM for FAB to use */ 8 register int *atrp;	/* address of file attribute list */+ char *es, *rs;		/* buffers for NAM block */ / struct fibdef *fibp;	/* FIB to get/set dates */ ! int *fibdp;		/* FIB descriptor */ E int *chanp;		/* address of word to hold channel assigned to device */  {  	register int datenum; 	int devnmdsc[2];  	static int atrcode[4] = {( 		ATR$S_CREDATE | (ATR$C_CREDATE << 16),( 		ATR$S_REVDATE | (ATR$C_REVDATE << 16),( 		ATR$S_BAKDATE | (ATR$C_BAKDATE << 16),( 		ATR$S_EXPDATE | (ATR$C_EXPDATE << 16), 	};   " 	/* Create file attribute list. */  , 	for (datenum = 0; datenum < 4; datenum++) { 		if (*tmptr != NULL) {  			*atrp++ = atrcode[datenum]; 			*atrp++ = *tmptr; 			if (setting && datenum != 2) 			    && (**tmptr | (*tmptr)[1]) == 0) {  				sys$gettim(*tmptr);  			} 		} 
 		tmptr++; 	} 	*atrp = 0;    	/* Initialize FAB. */  4 	lib$movc5(&0, 0, &'\0', &sizeof(struct FAB), fabp);  	fabp->fab$b_bln = FAB$C_BLN; 	fabp->fab$b_bid = FAB$C_BID;  	fabp->fab$l_nam = namp;# 	fabp->fab$b_fns = *fdscptr & 0xFF;  	fabp->fab$l_fna = fdscptr[1];   	/* Initialize NAM. */  4 	lib$movc5(&0, 0, &'\0', &sizeof(struct NAM), namp); 	namp->nam$b_bln = NAM$C_BLN;  	namp->nam$b_bid = NAM$C_BID;   	namp->nam$b_ess = NAM$C_MAXRSS;  	namp->nam$b_rss = NAM$C_MAXRSS; 	namp->nam$l_esa = es; 	namp->nam$l_rsa = rs;   	/* Initialize FIB. */         7 	lib$movc5(&0, 0, &'\0', &sizeof(struct fibdef), fibp);   	*fibdp = sizeof(struct fibdef); 	fibdp[1] = (int)fibp;  2 	if (~(datenum = sys$parse(fabp, ___, ___)) & 1) { 		return (datenum);  	}) 	devnmdsc[0] = namp->nam$t_dvi[0] & 0xFF; ( 	devnmdsc[1] = (int)&namp->nam$t_dvi[1];0 	return (sys$assign(devnmdsc, chanp, ___, ___)); }    #ifdef NO_CASEG /* Return -1 if the string pointed to by str1 is less than that pointed G to by str2, 0 if the strings are the same, or 1 if string 1 > string 2. F Perform the comparison considering uppercase the same as lowercase. */   casecmp(str1, str2)  register char *str1, *str2;  {  	register int c1, c2;    	do {  		c1 = *str1++ & 0xFF; 		if (IS_LOWER(c1)) {  			c1 += 'A' - 'a';  		}  		c2 = *str2++ & 0xFF; 		if (IS_LOWER(c2)) {  			c2 += 'A' - 'a';  		}  	} while (c1 && c1 == c2);   	if (c1 < c2) {  		return (-1); 	} else if (c1 == c2) { 
 		return (0); 	 	} else { 
 		return (1);  	} }  #endif