   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFNAM              %%   \ @  *                %% |           chfnam.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *?  *  Copyright (C) 2003, 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *J  *  CHFNAM is a specialized simulation of the DCL RENAME command. While itK  *  does not utilize most of the qualifiers provided by RENAME, the primary E  *  purpose is to rename a given file, or using wildcards, a group of K  *  of files, without changing the modification/revision date of the target F  *  file(s) from the date/time info present prior to executing CHFNAM.  *L  *  CHFNAM has been designed as a system management tool and is not intendedJ  *  to be accessed by general users. As described below, certain privs areI  *  required to succesfully execute CHFNAM. Additionally, if the image is J  *  located where global access is available, it is prudent for the sysmgr   *  to have trusted users enter:  *,  *      DEFINE /JOB /EXEC SECURE_LNM ENABLED  *D  *  prior to attempting execution. CHFNAM requires SYSPRV and BYPASSI  *  to successfully complete required RMS calls. If SETPRV is enabled for I  *  the caller, the above privs will be enabled for the duration of image K  *  activation. If not, user will see 'RMS-E-PRV' message at exit. If image L  *  is built with SECURE defined, user will see 'SYSTEM-x-AUTHFAIL' if thereE  *  is a descrepancy with LNM definition. See source (#ifdef SECURE).   *E  *  Note that this information is not documented elsewhere. This is a G  *  poor mans substitute for an identifier, most unpriv'ed users cannot K  *  access another users job table. There may be some user with the ability J  *  to determine the need for this logical to be defined in the JOB table,D  *  but not be able to define it with EXEC priv. See the source code   *  (search for 'ifdef SECURE').  *K  *  Online help is available only after the foreign symbol is defined; From   *  DCL simply enter:   *  *      CHFNAM /HELP  *G  *  Naturally, being freeware, there are restrictions which will affect -  *  successful execution of CHFNAM. They are:   *F  *      - Previous versions of CHFNAM required user to set default to C  *        the directory to which changes were to be performed. This (  *        restriction no longer applies.  *E  *      - It is expected CHFNAM will be invoked as a foreign command.   *E  *      - User must have Control access or privileges enabled (SYSPRV .  *        or BYPASS) for SYS$RENAME rms calls.D  *        BYPASS should only be required if a rename operation is to*  *        be performed on directory files.  *J  *      - Input and output filenames must appear on the command line. User*  *        is not prompted for these names.  *G  *      - Input file must not be open by any process or the program may H  *        exit with an error. Only highest version of target file should  *        be renamed.   *G  *      - CHFNAM supports RMS wildcard usage for the '*' and '%' chars.   *6  *  Below is an example of CHFNAM usage with wildcard:  *   *      $ chfnam *.axp_exe *.exe  *5  *        Target: DKA100:[LWEST.TOOLS.DECW]*.AXP_EXE; =  *                      CATCLOCK.AXP_EXE;1 --> CATCLOCK.EXE;1 8  *                           GMT.AXP_EXE;4 --> GMT.EXE;1:  *                         XEYES.AXP_EXE;2 --> XEYES.EXE;1=  *                      XFONTSEL.AXP_EXE;1 --> XFONTSEL.EXE;1 :  *                         XHTML.AXP_EXE;1 --> XHTML.EXE;1=  *                      XMEASURE.AXP_EXE;8 --> XMEASURE.EXE;1 ;  *                        XNLOCK.AXP_EXE;1 --> XNLOCK.EXE;1 :  *                         XSNOW.AXP_EXE;1 --> XSNOW.EXE;17  *                            XV.AXP_EXE;9 --> XV.EXE;1   *  *G  *  As shown above, an unplanned but handy usage of CHFNAM is to revert G  *  the version numbers of all or specific (wildcards) files in a given 6  *  directory and retain all previous datetime values:  *  *      $ chfnam *.c (or)   *      $ chfnam *.*  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V2.0-2" #pragma module CHFNAM VERSION     #include <stdio.h> #include <ctype.h> #include <climsgdef.h> #include <descrip.h> #include <dvidef.h>  #include <jpidef.h>  #include <lib$routines.h>  #include <prvdef.h>  #include <ssdef.h> #include <starlet.h> #include <string.h>  #include <stdlib.h> A #include <rms.h>                /* Include the RMS definitions */    @ struct FAB PsFab;               /* parse-search FAB Structure */@ struct NAM PsNam;               /* parse-search NAM Structure */   A struct FAB OldFab, NewFab;      /* FAB's for old-new filenames */ A struct NAM OldNam, NewNam;      /* NAM's for old-new filenames */ D struct XABDAT xabdat;           /* date/time info for oldfilename */M struct XABRDT xabrdt;           /* set revision date on $CLOSE of new file */    8 struct {short len, code; char *buf, *retlen;} DviItm[2];   ? int CreBin[2];                  /* target file creation date */ H int RevBin[2];                  /* modify/revision date of input file */ int status;    B short CopyFlg;                  /* copy create date to rev date */I short NewEqsOld;                /* use same dir for infile and outfile */ F short RevdFlg;                  /* user specified new revision date */H short RevnFlg;                  /* user specified new revision number */I short RevNum;                   /* revision count of input file header */    I char CmdVerb[32];               /* foreign command inviking this image */ = char DevName[24];               /* target disk device name */ A char PsEsa[NAM$C_MAXRSS];       /* SYS$PARSE expanded filename */ F char NewFname[80];              /* output filename after SYS$SEARCH */B char NewFspec[80];              /* output filespec from cmdline */H char NewWildFileStr[80];        /* copy of new filespec with wildcard */E char OldFname[80];              /* input filename after SYS$SEARCH */ A char OldFspec[80];              /* input filespec from cmdline */ H char OldWildFileStr[80];        /* copy of old filespec with wildcard */C char PsRsa[NAM$C_MAXRSS];       /* SYS$SEARCH resultant filename */  char *ptr1;  char *ptr2;     extern int RenameFile(); extern int CheckPrv();   I #define DEV$M_SWL 0x2000000         /* device is software write locked */ D #define RMS$_RMV 0x1C0FC            /* ACP remove function failed */    #ifdef __ALPHA #define ARCH 1 #else  #define ARCH 0 #endif     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  main routineM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 int main() { 
     int indx;      int devchar;   @     short CvLen;                    /* Length of command verb */     short NameLen;        char CmdLine[80];      char tempspec[80];     char enable_lnm[32];     char *ptr;   !     $DESCRIPTOR(DscCmd, CmdLine); !     $DESCRIPTOR(DscDev, DevName); F     $DESCRIPTOR(DscVerb, CmdVerb);  /* foreign invoking symbol name */        DviItm[0].len    = 4; $     DviItm[0].code   = DVI$_DEVCHAR;>     DviItm[0].buf    = &devchar;    /* disk characteristics */     DviItm[0].retlen = 0;      DviItm[1].len    = 0;      DviItm[1].code   = 0;         PsFab = cc$rms_fab;      PsNam = cc$rms_nam;    @         /* define the security logical name, even if not used */   %     strcpy(enable_lnm, "SECURE_LNM");    <         /* get the command line used to invoke this image */   M     status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CvLen] = 0;    3         /* extract foreign cmd verb from CmdLine */    $     sscanf(CmdLine, "%s", &CmdVerb);     ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);   2         /* get the cli values from command line */        status = GetCliInfo();*     if(status != SS$_NORMAL) exit(status);   M         /* check for presence of several security parameters for this user */    >     status = CheckPrv();            /* sysprv and/or bypass */*     if(status != SS$_NORMAL) exit(status);   P         /* we call 'CheckLnm' with the address of the job logical name to check.G            If the return status is SS$_NORMAL, then the logical does in J            fact exist and the pointer address now contains the equivalenceK            string of the logical. We then verify this string is what we are O            are expecting and react appropriately. Note that if this test fails, N            the user only receives a AUTHFAIL message for security purposes. */   
 #ifdef SECURE K         /* Some notes about error messages from the next few lines of code: J             W-AUTHFAIL - indicates logical IS defined, but the equivalenceC                          string is defined incorrectly (lowercase?) I             F-AUTHFAIL - Indicates the logical name is not defined in the E                          user's LNM$JOB table or wrong access mode */    7     status = CheckLnm(&enable_lnm, sizeof(enable_lnm)); J     if(status == SS$_NORMAL) { /* this says logical defined to some str */M         if(strcmp(enable_lnm, "ENABLED") != 0) { /* must match this string */ M             exit(0x2760);     /* %SYSTEM-W-AUTHFAIL, authorization failure */ 	         }      } J     else exit(0x2764);     /* %SYSTEM-F-AUTHFAIL, authorization failure */ #endif        if(strchr(OldFspec, '*')) { )         strcpy(OldWildFileStr, OldFspec); )         strcpy(NewWildFileStr, NewFspec);      }        PsFab.fab$l_dna = OldFspec; '     PsFab.fab$b_dns = strlen(OldFspec); J     PsFab.fab$l_nam = &PsNam;            /* Assign address of NAM block */   H     PsNam.nam$l_esa = PsEsa;             /* result str from sys$parse */C     PsNam.nam$b_ess = sizeof(PsEsa);     /* length of esa buffer */ I     PsNam.nam$l_rsa = PsRsa;             /* result str from sys$search */ C     PsNam.nam$b_rss = sizeof(PsRsa);     /* Length of rsa buffer */    K         /*  This section first does the parse of the input string to verify I          *  it exists. This path is written to PsEsa and is the basis for E          *  sys$search in single file or wildcard file name presence. F          *  It checks the value of the return status, and if not equalE          *  to RMS$_NORMAL, the program exits with the return status.           */    <     if ((status = sys$parse(&PsFab, 0, 0)) == RMS$_NORMAL) {&         PsEsa[PsNam.nam$b_esl] = '\0';(         printf("\nTarget: %s\n", PsEsa);   I         /* Before we go any deeper, the rest of the code is irrelevant if J          * we can't change anything because this is a readonly device. GetF          * the device name. use $GETDVI to check, then exit or proceed@          * based on the state of DVI$M_SWL (device write locked)          */    -         memset(&DevName, 0, sizeof(DevName)); ;         strncpy(DevName, PsNam.nam$l_dev, PsNam.nam$b_dev); .         DscDev.dsc$w_length = strlen(DevName);A         status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0); .         if(devchar & DEV$M_SWL) exit(0x182ba);     }      else exit(status);   A         /*  Here we actually search for the file. If it is found, B          *  get the last modify date/time info from original file,J          *  save this binary info in a local 64 bit variable, then renamesI          *  the file. The new file is then opened and xabrdt structure is N          *  updated to the previous revision date, and the new file is closed.H          *  Rename errors which are nonfatal will be displayed inline in"          *  place of new filename           */    @     while ((status = sys$search(&PsFab, 0, 0)) == RMS$_NORMAL) {B         PsRsa[PsNam.nam$b_rsl] = '\0';      /* convert to ASCIZ */D         NameLen = PsNam.nam$b_name+PsNam.nam$b_type+PsNam.nam$b_ver;/         memset(&OldFname, 0, sizeof(OldFspec));           strcpy(OldFname, PsRsa);         status = RenameFile();         switch(status) {             case RMS$_NORMAL: A                 printf("  %30s --> %-30s\n", OldFname, NewFname);                  break;              case SS$_ACCONFLICT:F                 printf("  %30s --> file access conflict\n", OldFname);                 break;               case RMS$_FLK:P                 printf("  %30s --> file locked by another process\n", OldFname);                 break;               case RMS$_RMV:L                 printf("  %30s --> ACP remove function failed\n", OldFname);                 break;               case RMS$_PRV:J                 printf("  %30s --> privilege/file protection violation\n","                         OldFname);                 break;             default:                 printf("\n");                  exit(status); 
          }     }         printf("\n"); C     if(status == RMS$_NMF) exit(SS$_NORMAL);     /* exit quietly */ :     exit(status);   /* Else exit with the return status */ }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *    RenameFile - Parse input and output filenames to determine actual I  *                 desired output filename (assuming wildcard operation). H  *                 Open oldfilename, get the last modify date/time info,E  *                 save this quadword value in 'RevBin' variable, and I  *                 close infile. Call SYS$RENAME to change filename. Then L  *                 open newfilename, and copy 'RevBin' data into 'xab$q_rdt'J  *                 update NewFname with final version info and close file.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int RenameFile() {      int NameLen = 0;     int rms_stat = 0;      char OldNamstr[32];      char OldTypstr[32];      char NewNamstr[32];      char NewTypstr[32];      char tempspec[80];     char *dotptr;      char *semiptr;<     char oldrsa[132], oldesa[132], newrsa[132], newesa[132];   ?         /* if a destination file not provided from cmdline, use              the input filespec */   5     if(!strlen(NewFspec)) strcpy(NewFspec, OldFspec);   K         /* Input file already parsed, if we get here, this code only breaks D            out filename and filetype into separate strings. First weB            break out 'name' and 'type' strings for old filename */   -     memset(&OldNamstr, 0, sizeof(OldNamstr)); ;     strncpy(OldNamstr, PsNam.nam$l_name, PsNam.nam$b_name); -     memset(&OldTypstr, 0, sizeof(OldTypstr)); ?     strncpy(OldTypstr, PsNam.nam$l_type+1, PsNam.nam$b_type-1);       if(strlen(OldWildFileStr)) {D         if(strlen(NewWildFileStr)) strcpy(NewFspec, NewWildFileStr);.         else strcpy(NewFspec, OldWildFileStr);     }   I         /* if cmdline provided only an output filepath, use same filename @            as input, so append that name to provided filepath */       if(strlen(NewFspec)) {%         ptr1 = strchr(NewFspec, ']');          if(ptr1) {             ptr1++;              if(!strlen(ptr1)) { F                 sprintf(NewFname, "%s%s", NewFspec, PsNam.nam$l_name);3                 strcat(NewFspec, PsNam.nam$l_name);*
             }*	         }*(         else strcpy(NewFname, NewFspec);     }*  G         /* if new filespec provides filepath info, save the path string B            and build output name and type strings. Then create the.            new filespec using these strings */  +     memset(&tempspec, 0, sizeof(tempspec));F!     ptr1 = strchr(NewFspec, ']');      if(ptr1) {#         strcpy(tempspec, NewFspec);\%         ptr2 = strchr(tempspec, ']');e         ptr2++;          *ptr2 = 0;         ptr1++;          ptr2 = ptr1;     }%     else ptr1 = &NewFname;  =         /* determine the name and type values for new file */        ptr2 = strchr(ptr1, '.');      if(ptr2) {         dotptr = ptr2;         *dotptr = '\0'; !         ptr2 = strchr(ptr1, '*'); .         if(ptr2) strcpy(NewNamstr, OldNamstr);%         else strcpy(NewNamstr, ptr1);_         *dotptr = '.';         ptr1 = dotptr;         ptr1++; $         semiptr = strchr(ptr1, ';');$         if(semiptr) *semiptr = '\0';!         ptr2 = strchr(ptr1, '*'); .         if(ptr2) strcpy(NewTypstr, OldTypstr);%         else strcpy(NewTypstr, ptr1);e     }m  D         /* if cmdline is 'chfnam abc:123.zzz 123.yyy' we must assumeG            (as does RENAME) the output file is to be located at 'abc:', F            else it will be put into default dir. If no filepath stringB            is present for output (new) file, use input filepath */       if(!strlen(tempspec)) {           strcpy(tempspec, PsRsa);%         ptr1 = strchr(tempspec, ']');u         ptr1++;d         *ptr1 = 0;     }tA     sprintf(NewFname, "%s%s.%s", tempspec, NewNamstr, NewTypstr);e  i	        /* J         * The following declarations are for the old and new FAB, NAM, and6         * XAB declarations with respect to SYS$RENAME.
         */  pK     OldFab = cc$rms_fab;           /* Initialize the input FAB structure */aL     NewFab = cc$rms_fab;           /* Initialize the output FAB structure */K     OldNam = cc$rms_nam;           /* Initialize the input NAM structure */LL     NewNam = cc$rms_nam;           /* Initialize the output NAM structure */H     xabdat = cc$rms_xabdat;        /* Initialize the XABDAT structure */H     xabrdt = cc$rms_xabrdt;        /* Initialize the XABRDT structure */   &     memset(oldrsa, 0, sizeof(oldrsa));&     memset(oldesa, 0, sizeof(oldesa));&     memset(newrsa, 0, sizeof(newrsa));&     memset(newesa, 0, sizeof(newesa));   6         /*  Build old FAB and associated structures */  f      OldFab.fab$l_fna = OldFname;(     OldFab.fab$b_fns = strlen(OldFname);B     OldFab.fab$b_fac = FAB$M_GET;   /* We only want read access */<     OldFab.fab$l_xab = &xabdat;     /* chain the date xab */L     OldFab.fab$l_nam = &OldNam;     /* Point the 'fab' to the 'nam' block */K     OldNam.nam$l_esa = oldesa;      /* Init the pointers and size fields */i;     OldNam.nam$l_rsa = oldrsa;      /* of the ESA & RSA. */ L     OldNam.nam$b_ess = 255;         /* These variables are declared above */     OldNam.nam$b_rss = 255;*   C         /* open old file, get/save revision date, close old file */i   !     rms_stat = sys$open(&OldFab);e1     if(rms_stat != RMS$_NORMAL) return(rms_stat);o$     oldesa[OldNam.nam$b_esl] = '\0';  C         /* if user specified /REVDATE qualifier without a value, weeB            use the creation date amd time for the revision info */  C     if(CopyFlg) {        /* if change revise date to create date */*8         if(CreBin[0]) memset(CreBin, 0, sizeof(CreBin));E         memcpy(&CreBin, &xabdat.xab$q_cdt, sizeof(xabdat.xab$q_cdt));Y     }o
     else {F         /* if user specified new revision date and/or revision number,;            use user value(s) rather than old file values */r           if(!RevdFlg) {<             if(RevBin[0]) memset(RevBin, 0, sizeof(RevBin));I             memcpy(&RevBin, &xabdat.xab$q_rdt, sizeof(xabdat.xab$q_rdt));t	         }r         if(!RevnFlg) {"             if(RevNum) RevNum = 0;I             memcpy(&RevNum, &xabdat.xab$w_rvn, sizeof(xabdat.xab$w_rvn));d	         }      }*  e"     rms_stat = sys$close(&OldFab);1     if(rms_stat != RMS$_NORMAL) return(rms_stat);    6         /*  Build new FAB and associated structures */   K     NewFab.fab$l_fna = NewFname;         /* Addr of new filename cmdline */ E     NewFab.fab$b_fns = strlen(NewFname); /* Length of new filename */SH     NewFab.fab$b_fac = FAB$M_PUT;        /* We only want write access */E     NewFab.fab$l_xab = &xabrdt;          /* chain the revision xab */EQ     NewFab.fab$l_nam = &NewNam;          /* Point the 'fab' to the 'nam' block */ R     NewNam.nam$l_esa = newesa;           /* Initialize pointers and size fields */@     NewNam.nam$l_rsa = newrsa;           /* of the ESA & RSA. */Q     NewNam.nam$b_ess = 255;              /* These variables are declared above */i     NewNam.nam$b_rss = 255;   bF         /* a directory rename will require BYPASS priv. If a directoryF            file was specified on the command line, then CheckPrv() hasE            already determined this and we would not be here if BYPASSrH            priv was not set. If a wildcard rename is in progress, we mayG            see directory files here, but BYPASS is not normally enabled H            so we could see access or priv messages here for directories.8            This is expected behavior and not an error */  u2     rms_stat = sys$rename(&OldFab, 0, 0, &NewFab);1     if(rms_stat != RMS$_NORMAL) return(rms_stat);f   M         /* open new file FAB, set revision date and number, close new file */l  h!     rms_stat = sys$open(&NewFab); 1     if(rms_stat != RMS$_NORMAL) return(rms_stat);PC     if(CopyFlg) memcpy(&xabrdt.xab$q_rdt, &CreBin, sizeof(CreBin));m<     else memcpy(&xabrdt.xab$q_rdt, &RevBin, sizeof(RevBin));7     memcpy(&xabrdt.xab$w_rvn, &RevNum, sizeof(RevNum));   7         /* save old and new filespecs and file names */n  !     oldrsa[OldNam.nam$b_rsl] = 0; !     newrsa[NewNam.nam$b_rsl] = 0;m       strcpy(OldFspec, oldrsa);      strcpy(NewFspec, newrsa);O  C     NameLen = OldNam.nam$b_name+OldNam.nam$b_type+OldNam.nam$b_ver;v+     memset(&OldFname, 0, sizeof(OldFname)); 2     strncpy(OldFname, OldNam.nam$l_name, NameLen);  C     NameLen = NewNam.nam$b_name+NewNam.nam$b_type+NewNam.nam$b_ver; +     memset(&NewFname, 0, sizeof(NewFname));a2     strncpy(NewFname, NewNam.nam$l_name, NameLen);  1         /* close the file and return to caller */   "     rms_stat = sys$close(&NewFab);     return(rms_stat);  }   rH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *B  *  ShowVers - displays current installed version, build date, andB  *             required privs for interactive usage and/or the VMS  *             install utility.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */P void ShowVers()e {e1     printf("\n\t\t%s by Lyle W West\n", CmdVerb);eF     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");;     printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");   n
 #ifdef SECUREh6     printf("\t\tRequired Privs: SETPRV [Secure]\n\n"); #else 7     printf("\t\tRequired Privs: SYSPRV [,BYPASS]\n\n");i #endif     exit(1); }e     h