L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              DIRSORT              %%   \ @  *                %% |          support.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #include "version.h" #pragma module SUPPORT VERSION    #include <stdio.h> #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <libdtdef.h>  #include <lnmdef.h>  #include <prvdef.h>  #include <psldef.h> A #include <rms.h>                /* Include the RMS definitions */  #include <ssdef.h> #include <stdlib.h>  #include <string.h>  #include "defs.h"    D extern int DateContext;         /* context for output date format */ extern int status;D extern int ProcPriv[2];         /* process privs of invoking user */   ? extern int BckBin[2];           /* backup date of input file */ A extern int CreBin[2];           /* creation date of input file */ 2 extern int CurBin[2];           /* current date */B extern int DeltaBin[2];         /* quadword value for DeltaTime */C extern int ExpBin[2];           /* expiration date of input file */ H extern int RevBin[2];           /* modify/revision date of input file */B extern int CliStat;             /* return status from cli calls */   J extern short ChangeFlg;         /* bit flag to indicated values changed */B extern short CliStrLen;         /* length of cli value returned */> extern short DateLen;           /* ascii date string length */J extern short DeltaFlg;          /* user specified /DELTATIME qualifier  */F extern short KeepFlg;           /* keep orig time, just change date */: extern short RvnNum;            /* file revision number */   6 extern char Buffer[80];         /* cli value string */7 extern char CliStr[80];         /* cli string buffer */ H extern char CmdVerb[32];        /* foreign symbol invoking this image */> extern char DateFormat[40];     /* ascii date format string */L extern char DateStr[28];        /* date string for ascii date to bin date */G extern char LayoutStr[32];      /* output field order keyword string */ M extern char LineBuf[132];       /* modified cmdline fed into cli$dcl_parse */    ? extern FILE_LIST *ListPtr;      /* file pointer for FileList */    ' extern struct dsc$descriptor_s DscDate; ) extern struct dsc$descriptor_s DscFormat;     globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: FormatDateStr D  * Description: Formats the date-time info for current file based onG  *              DeltaFlg variable. If flag is clear, use DIRSORT_FORMAT H  *              logical to determine date display format. If flag is setI  *              determine delta time value. In either case, the date-time 5  *              result is placed in buffer 'DateStr'.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void FormatDateStr() {      int datelen = 0;$     $DESCRIPTOR(Dsc_Delta, DateStr);   7     if(DeltaFlg) {      /* display delta time format */ E         status = lib$sub_times(&CurBin, ListPtr->BinTime, &DeltaBin); 3         if(status != LIB$_NORMAL) sys$exit(status); @         status = sys$asctim(&datelen, &Dsc_Delta, &DeltaBin, 0);2         if(status != SS$_NORMAL) sys$exit(status);         DateStr[datelen] = 0;          return;      } 8     else {              /* display normal time format */         if(!DateContext) {8             DscFormat.dsc$w_length = strlen(DateFormat);=             status = lib$init_date_time_context(&DateContext, 2                 &LIB$K_OUTPUT_FORMAT, &DscFormat);6             if(status != SS$_NORMAL) sys$exit(status);	         }    G         /* format output string using binary time from ListPtr->BinTime $            save output to DateStr */   O         status = lib$format_date_time(&DscDate, ListPtr->BinTime, &DateContext,              &datelen, 0); 2         if(status != SS$_NORMAL) sys$exit(status);         DateStr[datelen] = 0;      }  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm L  * Description: Function to translate a provided logical name to the definedI  *              equivalence string. Only the current PROCESS logical name J  *              table is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used to L  *              provide the input logical name (*lnmstr) so caller must makeG  *              certain the buffer containing the input logical name is F  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ & int CheckLnm(char *lnmstr, int buflen) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */ K     int eqvattrb = 0;               /* returned attributes of eqv string */      int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;<     char acmode;                    /* requires exec mode */<     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */ I     char LnmEqv[80];                /* logical name equivalence string */    >     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);   <     acmode = PSL$C_USER;            /* requires only mode */'     memset(&LnmEqv, 0, sizeof(LnmEqv));      strcpy(LnmDef, lnmstr); $     strcpy(LnmTable, "LNM$PROCESS");   /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);    %     lnmitm[0].len = sizeof(eqvattrb); %     lnmitm[0].code = LNM$_ATTRIBUTES; !     lnmitm[0].bufadr = &eqvattrb;      lnmitm[0].retlen = 0; %     lnmitm[1].len = sizeof(LnmTable);       lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;       lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv); !     lnmitm[2].code = LNM$_STRING;      lnmitm[2].bufadr = &LnmEqv;       lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;    N     lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {          LnmEqv[eqv_len] = '\0'; !         LnmTable[tbl_len] = '\0'; 4         if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);#         else return(SS$_BUFFEROVF);      } 8     if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(lnmstat);  }          H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowHelpI  * Description: Display a brief combination of DIRSORT.README and the cdu J  *              DIRSORT.CLD file. It provides a command line glance at the:  *              optional implementations of DIRSORT usage.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);O     printf("\t%s is a custom subset of the DCL DIRECTORY command.\n", CmdVerb); M     printf("\tIt lists only filename and timestamp information about the\n"); O     printf("\tfiles in target directory. The output is sorted by the date-\n"); M     printf("\ttime stamp rather than filename, and can sort the dates in\n"); D     printf("\teither descending or ascending (default) order.\n\n");P     printf("\tFile dates are displayed by default in the YYYY-Mmm-DD format\n");M     printf("\tThis is user definable by setting the process logical name\n"); 6     printf("\tDIRSORT_FORMAT to another format:\n\n");R     printf("\t $ define DIRSORT_FORMAT \"|!DB-!MAAU-!Y4 !H04:!M0:!S0.!C2|\"\n\n");J     printf("\twhich would display the date in Vms DD-MMM-YYYY format.\n");A     printf("\tSee Programming Concepts, Tables 6-6 and 6-8\n\n"); "     printf("    Parameters:\n\n");G     printf("\t%s accepts one parameter, a VMS filepath which is the\n",          CmdVerb); P     printf("\ttarget directory. If omitted, default directory is displayed.\n");=     printf("\tRMS wildcards (* and %%) are also valid.\n\n"); "     printf("    Qualifiers:\n\n");R     printf("\t/DATE=xxxx - if present, %s will sort the target directory files\n",         CmdVerb); I     printf("\t\tusing the specified date keyword. Valid keywords are\n"); B     printf("\t\tBACKUP, CREATE, EXPIRE or REVISE (default).\n\n");N     printf("\t/DELTATIME - if present, %s will display time info\n", CmdVerb);K     printf("\t\tfor each file as a delta time value, the difference of\n"); D     printf("\t\tthe current date-time and the file date-time.\n\n");P     printf("\t/LAYOUT=xxx - Determines the display format for filenames and\n");N     printf("\t\tdatestamps. Three keyword values are accepted, DATEFIRST,\n");M     printf("\t\t(default), FILEFIRST and TRUNCATE. The latter two appear\n"); J     printf("\t\tidentical until the filename exceeds 31 characters.\n\n");J     printf("\t/SORT=xxx - if present, %s will sort output as specified\n",         CmdVerb); M     printf("\t\tby the keyword entered. Accepted keywords are DESCENDING\n"); .     printf("\t\tor ASCENDING (default).\n\n");/     printf("\t/HELP - Displays this text\n\n"); =     printf("\t/VERSION - %s displays version, build date,\n",          CmdVerb); B     printf("\t\tand required privs for VMS Install utility.\n\n");     sys$exit(1); }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1; "             return(SS$_BUFFEROVF);	         }      } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */         Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      