 [inherit('PQM_OBJ:GLOBALDEF' 	,'SYS$LIBRARY:STARLET' # 	,'SYS$LIBRARY:PASCAL$LIB_ROUTINES' # 	,'SYS$LIBRARY:PASCAL$SMG_ROUTINES'  )] Module QUEUES (output); P {*******************************************************************************  ,   	QUEUES		Routines which operate on a queue  <   This module contains the routines which manipulate queues.  ?   	Created 7-Nov-2000 by J.Begg, VSM Software Services Pty Ltd. H   	Copyright  2000-2013 VSM Software Development.  All rights reserved.  P *******************************************************************************}   CONST 2 	{ Define the layout of the queue detail display }  z 	DETAIL_LABEL	= 'Queue Details for ';		{ Line 1:        Queue Details for XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX     On: XXXXXX } 	DETAIL_ROW	= 1;   	NODE_LABEL	= 'On: ';  	NODE_ROW	= 1;  a 	ROW_1_LENGTH	= length(DETAIL_LABEL) + QUEUE_NAME_SIZE + length(NODE_LABEL) + 5 + NODE_NAME_SIZE;   b 	DESCR_LABEL	= 'Description: ';		{ Line 2: Description: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX	} 	DESCR_ROW	= 2; # 	DESCR_COL	= length(DESCR_LABEL)+1;    	PENDING_LABEL	= 'Jobs: pending ';		{ Line 3: Jobs: pending XXXX  holding XXXX  completed XXXX   Device: XXXXXXXXXXXXXXXXXXXXX	} 	PENDING_ROW	= 3; ' 	PENDING_COL	= length(PENDING_LABEL)+1;    	HOLDING_LABEL	= ' holding ';  	HOLDING_ROW	= 3; 3 	HOLDING_COL	= length(HOLDING_LABEL)+PENDING_COL+4;   ! 	COMPLETED_LABEL	= ' completed ';  	COMPLETED_ROW	= 3; 7 	COMPLETED_COL	= length(COMPLETED_LABEL)+HOLDING_COL+4;    	DEVICE_LABEL	= 'Device: ';  	DEVICE_ROW	= 3;3 	DEVICE_COL	= length(DEVICE_LABEL)+COMPLETED_COL+5;    	QUEUE_DETAIL_ROWS	= 3;   1 	QUEUE_BROWSER_PASTE_ROW	= QUEUE_DETAIL_ROWS + 4; D 	QUEUE_BROWSER_QUEUE	= 26;		{ No. of characters for 'Queue' column }F 	QUEUE_BROWSER_STATUS	= 25;		{ No. of characters for 'Status' column }B 	QUEUE_BROWSER_FORM	= 25;		{ No. of characters for 'Form' column }W 	QUEUE_BROWSER_HEADING	= 'QUEUE                       STATUS                     FORM';    	SINGLE_QUEUE	= TRUE;  	MULTIPLE_QUEUES	= FALSE;      VAR  	detail_display		: unsigned; 	DETAIL_COL		: integer;  	NODE_COL		: integer;   ) 	queue_browser		: browse_list value ZERO;   ) 	first, last		: queue_info_ptr value NIL;   	queue_count		: integer value 0;  + 	force_queue_refresh	: boolean value FALSE; & 	show_filenames		: boolean value TRUE;  6 	qui_search_name		: varying [QUEUE_NAME_SIZE] of char;0 	qui_search_flags	: [readonly] SEARCH_FLAGS$TYPE) 				  value [QUI$V_SEARCH_SYMBIONT: TRUE; " 					 QUI$V_SEARCH_ALL_JOBS: TRUE;) 				         QUI$V_SEARCH_WILDCARD: TRUE;  					 otherwise ZERO];  % 	qui_queue_flags		: QUEUE_FLAGS$TYPE; & 	qui_queue_status	: QUEUE_STATUS$TYPE; 	qui_holding_jobs	: integer; 	qui_pending_jobs	: integer; 	qui_retained_jobs	: integer;  	qui_timed_jobs		: integer; # 	qui_job_status		: JOB_STATUS$TYPE; 2 	qui_pending_job_reason	: PENDING_JOB_REASON$TYPE; 	qui_job_entry		: unsigned; 5 	qui_queue_name		: varying [QUEUE_NAME_SIZE] of char; 3 	qui_form_name		: varying [FORM_NAME_SIZE] of char; 7 	qui_device_name		: varying [DEVICE_NAME_SIZE] of char; 1 	qui_job_name		: varying [JOB_NAME_SIZE] of char; 2 	qui_job_form		: varying [FORM_NAME_SIZE] of char;7 	qui_description		: varying [DESCRIPTION_SIZE] of char; 5 	qui_scsnode_name	: varying [NODE_NAME_SIZE] of char; 5 	qui_job_first_file	: varying [NAM$C_MAXRSS] of char; @ 	qui_generic_target	: varying [(QUEUE_NAME_SIZE+1)*124] of char;6 	qui_assigned_to		: varying [QUEUE_NAME_SIZE] of char;& 	qui_decoded_status	: Que_Status_Text;  E 	qui_queue_itemlist	: packed array [1..16] of Item_List_3 value ZERO; B 	qui_job_itemlist	: packed array [1..7] of Item_List_3 value ZERO;C 	qui_file_itemlist	: packed array [1..2] of Item_List_3 value ZERO; C 	qui_form_itemlist	: packed array [1..3] of Item_List_3 value ZERO;   P {******************************************************************************* *									       * *	DISPLAY_HELP							       *  *									       *P * Displays on-line help about the commands available in the Queue display.     * *									       *P *******************************************************************************}   Procedure DISPLAY_HELP; - var help_display : [static] unsigned value 0; "     terminator	 : [word] 0..65535; begin  if help_display = 0 then	     begin P     SMG$CREATE_VIRTUAL_DISPLAY (pasteboard_rows, pasteboard_cols, help_display);f     SMG$PUT_LINE_HIGHWIDE (help_display, '    PQM '+PQM_VERSION+ '    Queues Display', 3, SMG$M_BOLD);    r     SMG$PUT_LINE (help_display, ' The Queues Display is divided into two panels.  The lower panel lists all the');p     SMG$PUT_LINE (help_display, ' queues defined on this system, together with the queue status and currently');s     SMG$PUT_LINE (help_display, ' mounted formtype, or the job/file currently being printed (if any).  The upper'); r     SMG$PUT_LINE (help_display, ' panel shows specific details about the currently selected queue (as indicated');C     SMG$PUT_LINE (help_display, ' by the reverse video text).', 2);   j     SMG$PUT_LINE (help_display, ' Within the lower panel you can use the following keys to move around:');q     SMG$PUT_LINE (help_display, ' P or Prev Screen   Move up the queue list by approximately 2/3 of the screen'); s     SMG$PUT_LINE (help_display, ' N or Next Screen   Move down the queue list by approximately 2/3 of the screen'); Z     SMG$PUT_LINE (help_display, ' Up Arrow           Move up the queue list by one line');\     SMG$PUT_LINE (help_display, ' Down Arrow         Move down the queue list by one line');n     SMG$PUT_LINE (help_display, ' M, Do or PF4       Display a menu of operations appropriate to this queue');V     SMG$PUT_LINE (help_display, ' Return/Enter       Display the jobs in this queue');Y     SMG$PUT_LINE (help_display, ' Space bar          Force an update of the queue list'); n     SMG$PUT_LINE (help_display, ' F                  Display the file currently being printed by each queue');m     SMG$PUT_LINE (help_display, ' J                  Display the job currently being printed by each queue'); @     SMG$PUT_LINE (help_display, ' Q                  Quit PQM');I     SMG$PUT_LINE (help_display, ' Ctrl/W             Redraw the screen'); C     SMG$PUT_LINE (help_display, ' Ctrl/Z             Quit PQM', 2);   c     SMG$PUT_LINE (help_display, 'Press any key to return to PQM', pasteboard_rows,, SMG$M_REVERSE);   J     SMG$CHANGE_RENDITION (help_display, 11, 2, 2, 1, SMG$M_BOLD);	{ P, N }_     SMG$CHANGE_RENDITION (help_display, 11, 7, 2, 11, SMG$M_BOLD);	{ Prev Screen, Next Screen } N     SMG$CHANGE_RENDITION (help_display, 13, 2, 1, 8, SMG$M_BOLD);	{ Up Arrow }Q     SMG$CHANGE_RENDITION (help_display, 14, 2, 1, 10, SMG$M_BOLD);	{ Down Arrow } G     SMG$CHANGE_RENDITION (help_display, 15, 2, 1, 1, SMG$M_BOLD);	{ M } H     SMG$CHANGE_RENDITION (help_display, 15, 5, 1, 2, SMG$M_BOLD);	{ Do }J     SMG$CHANGE_RENDITION (help_display, 15, 11, 1, 3, SMG$M_BOLD);	{ PF4 }S     SMG$CHANGE_RENDITION (help_display, 16, 2, 1, 12, SMG$M_BOLD);	{ Return/Enter } O     SMG$CHANGE_RENDITION (help_display, 17, 2, 1, 9, SMG$M_BOLD);	{ Space bar } M     SMG$CHANGE_RENDITION (help_display, 18, 2, 3, 1, SMG$M_BOLD);	{ F, J, Q } T     SMG$CHANGE_RENDITION (help_display, 21, 2, 2, 6, SMG$M_BOLD);	{ Ctrl/W, Ctrl/Z }       end;  > SMG$PASTE_VIRTUAL_DISPLAY (help_display, pasteboard_id, 1, 1);- SMG$READ_KEYSTROKE (keyboard_id, terminator); : SMG$UNPASTE_VIRTUAL_DISPLAY (help_display, pasteboard_id); end;  P {******************************************************************************* *									       *" *	PROTECT_QUEUE_NAME						       * *									       *P * This routine sets up logical names which override any existing logical name  *: * that happens to be the same as a queue name.				       * *									       *P * The queue listing shown to the user is generated by a wildcard search of all *P * queues, and $GETQUI ignores logical names when performing such a search.     *P * However when PQM displays details for a specific queue it calls $GETQUI with *P * the specific queue name (as determined earlier by the wildcard search) and   *P * $GETQUI will attempt a logical name translation on the supplied name.  This  *P * means that the queue details retreived might be those for another queue,     *> * i.e. not the queue highlighted on the queue list.			       * *									       *P * To work around this problem, Get_Queue_Info compares the queue name returned *P * by $GETQUI against the queue name actually requested.  If they are different *P * and the requested queue name was not a wildcard name, we assume there is a   *P * logical name matching the requested queue name.  We define the same logical  *P * name in a process-private table with the equivalence string set to be the    *P * logical name.  An attempt to translate the logical then produces the same    *P * string as the logical name itself, at which point $GETQUI gives up on the    *I * logical name and gets us the details for the requested queue.		       *  *									       *P *******************************************************************************}  = Procedure Protect_Queue_Name (qname : varying [len] of char); ( const PQM_PROTECT_TABLE	= 'PQM___TABLE';, type  String_Buffer	= varying [255] of char; var      ret_status		: integer;5     pqm_table_created	: [static] boolean value FALSE; 3     lnm_protect_list	: array [1..3] of Item_List_3; 2     lnm_attributes	: integer value LNM$M_TERMINAL;  #     procedure create_private_table; A     var lnm_itemlist	: array [-1..128] of Item_List_3 value ZERO; ; 	equivalences	: array [0..127] of String_Buffer value ZERO;  	eqv_maxidx, e	: integer;  	dummy		: integer;	     begin B     ret_status := $CRELNT (attr := LNM$M_CONFINE + LNM$M_CREATE_IF! 			  ,tabnam := PQM_PROTECT_TABLE ) 			  ,partab := 'LNM$PROCESS_DIRECTORY');      if not odd(ret_status) then  	beginT 	MESSAGE ('Error 0x'+hex(ret_status,8,8)+' calling $CRELNT('+PQM_PROTECT_TABLE+')'); 	LIB$SIGNAL(ret_status)  	end;   ,     { Get the current value of LNM$PROCESS }     lnm_itemlist[-1] := Item_List_3[item_code: LNM$_MAX_INDEX; item_len: 4; bufaddr: iaddress(eqv_maxidx); retaddr: iaddress(dummy)];      lnm_itemlist[0] := Item_List_3[item_code: LNM$_STRING; item_len: 255; bufaddr: iaddress(equivalences[0].body); retaddr: iaddress(equivalences[0].length)];P     ret_status := $TRNLNM(,'LNM$PROCESS_DIRECTORY','LNM$PROCESS',,lnm_itemlist);     if not odd(ret_status) then  	beginK 	MESSAGE('Error 0x'+hex(ret_status,8,8)+' calling $TRNLNM("LNM$PROCESS")');  	LIB$SIGNAL(ret_status)  	end;      if eqv_maxidx > 0 then 	begin 	for e := 1 to eqv_maxidx do 	    lnm_itemlist[e] := Item_List_3[item_code: LNM$_STRING; item_len: 255; bufaddr: iaddress(equivalences[e].body); retaddr: iaddress(equivalences[e].length)]; U 	ret_status := $TRNLNM(,'LNM$PROCESS_DIRECTORY','LNM$PROCESS',,%ref lnm_itemlist[1]);  	if not odd(ret_status) then
 	    beginU 	    MESSAGE('Error 0x'+hex(ret_status,8,8)+' calling $TRNLNM("LNM$PROCESS") again');  	    LIB$SIGNAL(ret_status) 	 	    end;  	end;   E     { Redefine LNM$PROCESS, prefixing it with our PQM-private table }      lnm_itemlist[-1] := Item_List_3[item_code: LNM$_STRING; item_len: length(PQM_PROTECT_TABLE); bufaddr: iaddress(PQM_PROTECT_TABLE); retaddr: 0]; ^     if eqv_maxidx > 126 then eqv_maxidx := 126;   { We have to drop one to make space for us }     for e := 0 to eqv_maxidx do  	begin4 	lnm_itemlist[e].item_len := equivalences[e].length;< 	lnm_itemlist[e].bufaddr  := iaddress(equivalences[e].body); 	lnm_itemlist[e].retaddr  := 0 	end; '     lnm_itemlist[eqv_maxidx+1] := ZERO; k     ret_status := $CRELNM(LNM$M_CONFINE, 'LNM$PROCESS_DIRECTORY', 'LNM$PROCESS', PSL$C_USER, lnm_itemlist);      if not odd(ret_status) then  	beginC 	MESSAGE('Error 0x'+hex(ret_status,8,8)+' redefining LNM$PROCESS');  	end;      pqm_table_created := TRUE      end;   begin 8 { First step is to create a private logical name table }3 if not pqm_table_created then create_private_table;   A { We protect the queue name by defining it in our private table }  lnm_protect_list[1] := Item_List_3[item_code: LNM$_STRING; item_len: length(qname); bufaddr: iaddress(qname.body); retaddr: 0]; { lnm_protect_list[2] := Item_List_3[item_code: LNM$_ATTRIBUTES; item_len: 4; bufaddr: iaddress(lnm_attributes); retaddr: 0];  lnm_protect_list[3] := ZERO;P ret_status := $CRELNM(, PQM_PROTECT_TABLE, qname, PSL$C_USER, lnm_protect_list); if not odd(ret_status) then L     MESSAGE('Error 0x'+hex(ret_status,8,8)+' protecting queue name '+qname); end;  P {******************************************************************************* *									       *% *	DISPLAY_QUEUE_DETAILS						       *  *									       *P * This routine updates the queue details heading at the top of the queue page. * *									       *  *	ONE_LINE_SUMMARY						       * *									       *P * This routine builds the text string which provides a one-line summary of the *3 * queue for the queue browser display.					       *  *									       *P *******************************************************************************}  5 Procedure DISPLAY_QUEUE_DETAILS (queue : queue_info); " var f : string(pasteboard_cols-2); begin * SMG$BEGIN_DISPLAY_UPDATE (detail_display);
 with queue do 	     begin      f := '';  APPEND_FIELD (f, name, size(name.body));  SMG$PUT_CHARS (detail_display, f, DETAIL_ROW, DETAIL_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);E     if flags.QUI$V_QUEUE_GENERIC or (length(generic_target) > 0) then  	{ Generic or Logical queue }  	beginp 	SMG$PUT_CHARS (detail_display, '-n/a- ', NODE_ROW, NODE_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT); 	SMG$PUT_CHARS (detail_display, generic_target, DEVICE_ROW, DEVICE_COL, SMG$M_ERASE_TO_EOL, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);  	end     else 	{ Standard execution queue }  	beginl 	SMG$PUT_CHARS (detail_display, node, NODE_ROW, NODE_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT); 	SMG$PUT_CHARS (detail_display, device, DEVICE_ROW, DEVICE_COL, SMG$M_ERASE_TO_EOL, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);  	end;      f := '';  APPEND_FIELD (f, description, pasteboard_cols-2-DESCR_COL);  SMG$PUT_CHARS (detail_display, f, DESCR_ROW, DESCR_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);      writev (f, pending_jobs:1); SMG$PUT_CHARS (detail_display, pad(f, ' ', 4), PENDING_ROW, PENDING_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);      writev (f, (holding_jobs+timed_jobs):1); SMG$PUT_CHARS (detail_display, pad(f,' ', 4), HOLDING_ROW, HOLDING_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);      writev (f, retained_jobs:1); SMG$PUT_CHARS (detail_display, pad(f, ' ', 4), COMPLETED_ROW, COMPLETED_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);     {      f := '';  APPEND_FIELD (f, device, size(device.body));  SMG$PUT_CHARS (detail_display, f, DEVICE_ROW, DEVICE_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);     }      end;( SMG$END_DISPLAY_UPDATE (detail_display); end;    E Procedure ONE_LINE_SUMMARY (var buffer : string; queue : queue_info);  begin 
 buffer := ''; : APPEND_FIELD (buffer, queue.name, QUEUE_BROWSER_QUEUE, 2);% if queue.status.QUI$V_QUEUE_BUSY then ^     APPEND_FIELD (buffer, queue.decoded_status, QUEUE_BROWSER_STATUS + 2 + QUEUE_BROWSER_FORM) else	     begin I     APPEND_FIELD (buffer, queue.decoded_status, QUEUE_BROWSER_STATUS, 2); +     if queue.flags.QUI$V_QUEUE_GENERIC then C 	APPEND_FIELD (buffer, ' -- generic queue -- ', QUEUE_BROWSER_FORM)      else7 	APPEND_FIELD (buffer, queue.form, QUEUE_BROWSER_FORM);      end; end;  P {******************************************************************************* *									       * *	GET_QUEUE_INFO							       *  *									       *P * This routine makes three calls to SYS$GETQUIW to retrieve information about  *P * a single queue.  It assumes that the queue name being searched on has been   *P * put into qui_search_name.  This routine is called by UPDATE_ONE_QUEUE and    *& * by update_queue_list.							       * *									       *P *******************************************************************************}   Function Get_Queue_Info (efn : integer; var context : unsigned; var qc : [truncate] integer; ignore_servers : boolean) : integer;  Label GQI_Get_Queue; var ret_status : integer;      que_status : integer; !     IOSB       : IO_Status_Block; Z     single_Q   : boolean;	{ Flag to indicate we're here to get details on just one queue }  "     procedure decode_queue_status;6     var f : [volatile] varying [NAM$C_MAXRSS] of char;	     begin ,     with qui_queue_status, qui_job_status do 	begin1 	{ Set a default string -- assume queue is idle } Y 	if QUI$V_QUEUE_CLOSED then qui_decoded_status := 'Closed' else qui_decoded_status := '';   2 	{ Now try to be a little more precise about it! }] 	if QUI$V_QUEUE_AVAILABLE or QUI$V_QUEUE_BUSY or QUI$V_QUEUE_STALLED or QUI$V_QUEUE_IDLE then N 	    { Determine the job status and/or file which is currently being printed }
 	    beginK 	    if QUI$V_JOB_EXECUTING or QUI$V_JOB_STALLED or QUI$V_JOB_STARTING then ) 		{ Get the file which is being printed }  		begin F 		if      QUI$V_JOB_STALLED   then qui_decoded_status := 'Stalled on 'F 		else if QUI$V_QUEUE_SERVER  then qui_decoded_status := 'Processing 'D 		else if QUI$V_JOB_STARTING  then qui_decoded_status := 'Starting 'E 		else                             qui_decoded_status := 'Printing ';  		if show_filenames then 		    begin  		    LIB$TRIM_FILESPEC (qui_job_first_file, %descr f, QUEUE_BROWSER_STATUS + QUEUE_BROWSER_FORM + 2 - length(qui_decoded_status)); 2 		    qui_decoded_status := qui_decoded_status + f	 		    end  		else> 		    qui_decoded_status := qui_decoded_status + qui_job_name; 		end # 	    else if QUI$V_JOB_PENDING then * 		{ Work out why the job is not printing }I 		DECODE_PENDING_JOB_REASON (qui_decoded_status, qui_pending_job_reason); ) 	    end  { available/busy/stalled/idle }   D 	else if QUI$V_QUEUE_ALIGNING		then qui_decoded_status := 'Aligning'_ 	else if QUI$V_QUEUE_AUTOSTART_INACTIVE	then qui_decoded_status := 'Stopped (a/start inactive)' N 	else if QUI$V_QUEUE_DISABLED		then qui_decoded_status := 'Stopped (disabled)'@ 	else if QUI$V_QUEUE_PAUSED		then qui_decoded_status := 'Paused'B 	else if QUI$V_QUEUE_PAUSING		then qui_decoded_status := 'Pausing'M 	else if QUI$V_QUEUE_RESETTING		then qui_decoded_status := 'Stopping (reset)' M 	else if QUI$V_QUEUE_RESUMING		then qui_decoded_status := 'Starting (resume)' D 	else if QUI$V_QUEUE_STARTING		then qui_decoded_status := 'Starting'K 	else if QUI$V_QUEUE_STOP_PENDING	then qui_decoded_status := 'Stop pending' B 	else if QUI$V_QUEUE_STOPPED		then qui_decoded_status := 'Stopped'D 	else if QUI$V_QUEUE_STOPPING		then qui_decoded_status := 'Stopping'R 	else if QUI$V_QUEUE_UNAVAILABLE		then qui_decoded_status := 'Device unavailable';   	end; { with }      end; { Decode_Queue_Status }    N     {------------------------------------------------------------------------}N     { get_device_info attempts to map the device name returned by $GETQUI    }N     { to a actual target, e.g. an IP address.  It is complicate by the fact  }N     { that if the output device is a terminal device it might be spooled,    }N     { and therefore we have to get both primary and secondary characteristcs.}N     {------------------------------------------------------------------------}       procedure get_device_info;.     type DVI_Location = varying [255] of char;     var ret_status : integer;  	c	   : integer; 	dn_length  : integer;" 	locn	   : [unsafe] ^DVI_Location; 	devchar    : DEV$TYPE; & 	IOSB	   : IO_Status_Block value ZERO;5 	item_list  : array [1..4] of Item_List_3 value ZERO; ' 	dev3	   : packed array [1..3] of char; & 	location1  : DVI_Location value ZERO;& 	location2  : DVI_Location value ZERO;$ 	lnm_tmp    : varying [255] of char;	     begin      ret_status := 0;      locn := iaddress(location1);;     { Strip leading and trailing double-quotes if present } )     dn_length := length(qui_device_name); M     if (qui_device_name[1] = '"') and (qui_device_name[dn_length] = '"') then : 	qui_device_name := substr(qui_device_name,2,dn_length-2);?     { Attempt to determine what sort of output device we have } *     dev3 := substr(qui_device_name, 1, 3);k     if eq(dev3,'NTY') or eq(dev3,'TNA') or ((qui_device_name[1] = 'T') and (qui_device_name[2] = 'T')) then  	begin= 	{ Terminal device ... use $GETQUI(TT_ACCPORNAM) to resolve } g 	item_list[1].item_code	:= DVI$_DEVCHAR + DVI$C_SECONDARY;	{ "Primary" device will *never* be spooled }  	item_list[1].item_len	:= 4;+ 	item_list[1].bufaddr	:= iaddress(devchar); % 	item_list[1].retaddr	:= iaddress(c); - 	item_list[2].item_code	:= DVI$_TT_ACCPORNAM;  	item_list[2].item_len	:= 64; 2 	item_list[2].bufaddr	:= iaddress(location1.body);4 	item_list[2].retaddr	:= iaddress(location1.length);? 	item_list[3].item_code	:= DVI$_TT_ACCPORNAM + DVI$C_SECONDARY;  	item_list[3].item_len	:= 64; 2 	item_list[3].bufaddr	:= iaddress(location2.body);4 	item_list[3].retaddr	:= iaddress(location2.length);C 	ret_status := $GETDVIW(EFN$C_ENF,,qui_device_name,item_list,IOSB); 0 	if odd(ret_status) then ret_status := IOSB.sts; 	if odd(ret_status) then
 	    begin; 	    if devchar.DEV$V_SPL then locn := iaddress(location2);   	    c := index(locn^, '/Appl');& 	    if c > 0 then locn^.length := c-1 	    end( 	else if ret_status = SS$_NOSUCHDEV then
 	    begin# 	    locn^ := '* no such device *';  	    ret_status := 1 	    end 	end      else if eq(dev3, 'NLP') then 	beginA 	{ MultiNet NLP device ... use $TRNLNM to resolve, if necessary } ' 	item_list[1].item_code	:= LNM$_STRING;  	item_list[1].item_len	:= 255;2 	item_list[1].bufaddr	:= iaddress(location1.body);4 	item_list[1].retaddr	:= iaddress(location1.length);7 	if qui_device_name[length(qui_device_name)] = ':' then e 	    lnm_tmp := 'MULTINET_' + substr(qui_device_name,1,length(qui_device_name)-1) + '_REMOTE_ADDRESS'  	else B 	    lnm_tmp := 'MULTINET_' + qui_device_name + '_REMOTE_ADDRESS';K 	ret_status := $TRNLNM(LNM$M_CASE_BLIND,'LNM$SYSTEM', lnm_tmp,, item_list);  	end,     else if eq(qui_device_name,'DCPS$') then 	begin; 	{ DCPS queue with target device stored in a logical name } ' 	item_list[1].item_code	:= LNM$_STRING;  	item_list[1].item_len	:= 255;2 	item_list[1].bufaddr	:= iaddress(location1.body);4 	item_list[1].retaddr	:= iaddress(location1.length);6 	lnm_tmp := 'DCPS$' + qui_queue_name + '_DEVICE_NAME';K 	ret_status := $TRNLNM(LNM$M_CASE_BLIND,'LNM$SYSTEM', lnm_tmp,, item_list);  	if odd(ret_status) then
 	    begin" 	    qui_device_name := location1; 	    ret_status := 0 	    end 	end; S     if odd(ret_status) then qui_device_name := qui_device_name + ' (' + locn^ + ')'      end; { Get_Device_Info }     begin { Get_Queue_Info } single_Q := not present(qc); repeat GQI_Get_Queue:X     que_status := $GETQUIW (efn, QUI$_DISPLAY_QUEUE, context, qui_queue_itemlist, IOSB);3     if odd(que_status) then que_status := IOSB.sts;      if odd(que_status) then  	begin7 	{ See if the queue we've got is the one we asked for } > 	if single_Q and_then ne(qui_search_name, qui_queue_name) then4 	    { Ooops, protect the queue name and try again }
 	    begin) 	    protect_queue_name(qui_search_name); ; 	    $GETQUIW (efn, QUI$_CANCEL_OPERATION, context,, IOSB); 8  	    context := -1;		{ Reset for trying $GETQUI again }A 	    qui_queue_status := ZERO;	{ Don't trip up on SERVER queues } 2 	    single_Q := FALSE;		{ Avoid an endless loop }' 	    goto GQI_Get_Queue;		{ Try again } 	 	    end; 1 	{ OK, get information about jobs in this queue } 5 	if length(qui_device_name) > 3 then get_device_info; Q 	ret_status := $GETQUIW (efn, QUI$_DISPLAY_JOB, context, qui_job_itemlist, IOSB); 0 	if odd(ret_status) then ret_status := IOSB.sts; 	if odd(ret_status) then
 	    begin 	    qui_job_first_file := '';W 	    ret_status := $GETQUIW (efn, QUI$_DISPLAY_FILE, context, qui_file_itemlist, IOSB); 4 	    if odd(ret_status) then ret_status := IOSB.sts; 	    if not odd(ret_status) and (ret_status <> JBC$_NOMOREFILE) and (ret_status <> JBC$_NOSUCHFILE) then LIB$SIGNAL (ret_status);  	    end 	else   	    { SYS$GETQUIW(JOB) failed }
 	    begin 	    qui_job_status := ZERO;$ 	    qui_pending_job_reason := ZERO; 	    if not odd(ret_status) and (ret_status <> JBC$_NOMOREJOB) and (ret_status <> JBC$_NOSUCHJOB) then LIB$SIGNAL (ret_status); 	 	    end;  	decode_queue_status;  	end     elsec 	if (que_status <> JBC$_NOMOREQUE) and (que_status <> JBC$_NOSUCHQUE) then LIB$SIGNAL (que_status);  until not odd(que_status) or_else not (present(ignore_servers) and_then (ignore_servers and qui_queue_status.QUI$V_QUEUE_SERVER));5 if odd(que_status) and present(qc) then qc := qc + 1;  Get_Queue_Info := que_status end;  P {******************************************************************************* *									       *  *	UPDATE_ONE_QUEUE						       * *									       *P * This routine gets the latest information about the specified queue, and      *P * updates the queue display accordingly.  It is called by routines in this     *4 * module and also from the JOBS module.					       * *									       *P *******************************************************************************}   [global]= Function UPDATE_ONE_QUEUE (var queue : queue_info) : integer; + var efn	       : [static] unsigned value 0;      ret_status : integer;      context    : unsigned;-     buffer     : string (queue_browser.cols); !     IOSB       : IO_Status_Block;  begin ! if efn = 0 then LIB$GET_EF (efn);  context := -1; qui_search_name := queue.name;5 qui_queue_itemlist[1].item_len := length(queue.name); , ret_status := get_queue_info (efn, context);4 $GETQUIW(efn,QUI$_CANCEL_OPERATION, context,, IOSB); if not odd (ret_status) then	     begin       force_queue_refresh := TRUE;     return ret_status      end;
 with queue do 	     begin $     description		:= qui_description;     form		:= qui_form_name;      flags		:= qui_queue_flags;      status		:= qui_queue_status;%     holding_jobs	:= qui_holding_jobs; %     pending_jobs	:= qui_pending_jobs; '     retained_jobs	:= qui_retained_jobs; "     timed_jobs		:= qui_timed_jobs;     node		:= qui_scsnode_name;     device		:= qui_device_name; "     job_status		:= qui_job_status;+     job_pending		:= qui_pending_job_reason; )     job_first_file	:= qui_job_first_file;      job_form		:= qui_job_form;&     job_entry_number	:= qui_job_entry;)     decoded_status	:= qui_decoded_status;      end;' if queue.flags.QUI$V_QUEUE_GENERIC then 	     begin *     if length(qui_generic_target) = 0 then 	queue.generic_target := ''      else4 	queue.generic_target := '--> ' + qui_generic_target     end ( else if length(qui_assigned_to) > 0 then5     queue.generic_target := '--> ' + qui_assigned_to;    display_queue_details (queue);! one_line_summary (buffer, queue); A SMG$SET_CURSOR_ABS (queue_browser.display, queue.display_row, 1); - SMG$PUT_LINE (queue_browser.display, buffer); 5 BROWSE_SELECT_ROW (queue_browser, queue.display_row);  UPDATE_ONE_QUEUE := ret_status end;  P {******************************************************************************* *									       *# *	BUILD_FORM_SELECTOR						       *  *									       *P * This routine builds an SMG menu which lists the available form types, and    *& * puts it on the screen.						       * *									       *P *******************************************************************************}   [global]; Procedure BUILD_FORM_SELECTOR (var forms    : SMG_Menu_Ptr; ! 			       target_row   : integer; K 			       initial_form : [truncate] packed array [l0..h0:integer] of char);  type     form_ptr	= ^form;      form	= record  		      next : form_ptr;0 		      name : varying [FORM_NAME_SIZE] of char; 		  end;% var efn		: [static] unsigned value 0;      ret_status	: integer;      context	: unsigned; !     form_count	: integer value 0;      form_idx	: integer;      longest	: integer value 0;     IOSB	: IO_Status_Block; $     first_form	: form_ptr value NIL;#     last_form	: form_ptr value NIL;    begin  if forms = NIL then 	     begin ,     { Build a list of the known form names }7     MESSAGE ('Getting form names ...', MESSAGE_SILENT); %     if efn = 0 then LIB$GET_EF (efn);      context := -1;     qui_search_name := '*'; =     qui_form_itemlist[1].item_len := length(qui_search_name); V     ret_status := $GETQUIW (efn, QUI$_DISPLAY_FORM, context, qui_form_itemlist, IOSB);3     if odd(ret_status) then ret_status := IOSB.sts;      while odd(ret_status) do
         begin %         form_count := form_count + 1;           if last_form <> NIL then
 	    begin 	    new(last_form^.next);! 	    last_form := last_form^.next  	    end 	else 
 	    begin 	    new(first_form);  	    last_form := first_form	 	    end;  	last_form^.next := NIL;" 	last_form^.name := qui_form_name;J 	if length(qui_form_name) > longest then longest := length(qui_form_name);S 	ret_status := $GETQUIW (efn, QUI$_DISPLAY_FORM, context, qui_form_itemlist, IOSB); 0 	if odd(ret_status) then ret_status := IOSB.sts; 	end; h     if (ret_status <> JBC$_NOSUCHFORM) and (ret_status <> JBC$_NOMOREFORM) then LIB$SIGNAL (ret_status);     if last_form <> NIL then 	begin 	new(last_form^.next); 	last_form := last_form^.next;" 	last_form^.name := '<no change>'; 	end     else 	begin 	new(first_form);  	last_form := first_form; & 	last_form^.name := '<no forms found>' 	end;      last_form^.next := NIL; !     form_count := form_count + 1;        { . 	Use the above list to build the menu choices.& 	The list is destroyed in the process.     } "     new(forms,form_count,longest);     forms^ := ZERO; 5     for form_idx := 1 to form_count do with forms^ do  	begin' 	choices[form_idx] := first_form^.name; Z 	if (selection = 0) and_then eq(first_form^.name,initial_form) then selection := form_idx; 	last_form := first_form;   	first_form := first_form^.next; 	dispose(last_form); 	end;        end    else with forms^ do      { Menu already exists } !     if present(initial_form) then @ 	{ Binary search of the form menu for the initial value string } 	begin+ 	form_idx := 1; form_count := forms^.count;  	repeat 0 	    selection := (form_idx + form_count) div 2;8 	    if gt(initial_form, forms^.choices[selection]) then 		form_idx := selection + 1 	 	    else  		form_count := selection - 1 N 	until eq(forms^.choices[selection], initial_form) or (form_idx > form_count);C 	if ne(forms^.choices[selection], initial_form) then selection := 1  	end     else 	selection := 1;  6 $GETQUIW (efn, QUI$_CANCEL_OPERATION, context,, IOSB); { /   Prepare the SMG menu and put it on the screen  } 6 PREPARE_MENU (forms^, target_row, SMG$M_FIXED_FORMAT); end;  P {******************************************************************************* *									       *$ *	BUILD_QUEUE_SELECTOR						       * *									       *P * This routine builds an SMG menu which lists the available queues to which    *< * job(s) can be moved, and puts it on the screen.			       * *									       *P *******************************************************************************}   [global]B Procedure BUILD_QUEUE_SELECTOR (var queue_selector : SMG_Menu_Ptr;! 				target_row         : integer; K 				exclude_queue      : [truncate] packed array [l0..h0:integer] of char);  var queue_idx	: integer;     queue	: queue_info_ptr;    begin    { Create the menu structure } 0 new(queue_selector,queue_count,QUEUE_NAME_SIZE); queue_selector^ := ZERO; queue := first;  queue_idx := 1;  with queue_selector^ do 	     begin 9     while (queue_idx < queue_count) and (queue <> NIL) do  	begin' 	if ne(queue^.name, exclude_queue) then 
 	    begin' 	    choices[queue_idx] := queue^.name;  	    queue_idx := queue_idx+1 	 	    end;  	queue := queue^.next  	end; *     choices[queue_count] := '<no change>';     selection := 1;      end;  1 { Prepare the SMG menu and put it on the screen } . PREPARE_MENU (queue_selector^, target_row, 0); end;  P {******************************************************************************* *									       *$ *	DELETE_MULTIPLE_JOBS						       * *									       *P * This procedure is called to delete multiple jobs from the queue, either all  *P * jobs ("Empty Queue") or only those whose files no longer exist ("Cleanup     *P * Queue").  Access to this functionality is controlled by PQM logical names    *' * and rights identifiers.						       *  *									       *P *******************************************************************************}   [global]0 Procedure DELETE_MULTIPLE_JOBS (queue		: string; 				delete_all	: boolean);; type entries(count: integer) = array [1..count] of integer;u( var efn		: [static] unsigned value ZERO;-     alert_box	: [static] unsigned value ZERO;      ret_status	: integer;p     dummy	: integer;     context	: unsigned;r     IOSB	: IO_Status_Block;e     entry_count	: integer;     entry_idx	: integer;     all_entries	: ^entries;tR     all_missing	: boolean;	{ Flag to indicate all files in a job no longer exist }  9     queue_items	: array [1..8] of Item_List_3 value ZERO; 0     queue_flags	: integer;	{ QUI$_SEARCH_FLAGS }4     queue_pcnt	: integer;	{ QUI$_PENDING_JOB_COUNT }5     queue_rcnt	: integer;	{ QUI$_RETAINED_JOB_COUNT }X4     queue_hcnt	: integer;	{ QUI$_HOLDING_JOB_COUNT }:     queue_tcnt	: integer;	{ QUI$_TIMED_RELEASE_JOB_COUNT }6     queue_ecnt	: integer;	{ QUI$_EXECUTING_JOB_COUNT }  7     job_items	: array [1..3] of Item_List_3 value ZERO;n.     job_entry	: integer;	{ QUI$_ENTRY_NUMBER }.     job_flags	: integer;	{ QUI$_SEARCH_FLAGS }  8     file_items	: array [1..3] of Item_List_3 value ZERO;/     file_spec	: varying [NAM$C_MAXRSS] of char;e     file_ident	: packed record+ 		      dvi : packed array [1..16] of char;= 		      fid,5 		      did : packed array [1..3] of [word] 0..65535;G 		  end;  7     sjc_items	: array [1..2] of Item_List_3 value ZERO;C  "     function RMS_search : integer;     {R= 	Uses $PARSE and $SEARCH to look for the file and returns the4A 	RMS status.  The job will be deleted if this status is RMS$_FNF.  	Notes:V@ 	 * If the job is a spooled file (and therefore not entered in a? 	   directory), $PARSE will return RMS$_DNF and so PQM will notE 	   try to delete the job.? 	 * If the file has been deleted *and* its parent directory (orc@ 	   a directory further up the directory chain) has been deleted? 	   or renamed, $PARSE will fail with RMS$_DNF and so PQM won't  	   try to delete the job.     }      var rms_status : integer;U' 	FAB	   : [static] FAB$TYPE value ZERO; ' 	NAM	   : [static] NAM$TYPE value ZERO;T
 	expanded,6 	resultant  : [static] varying [NAM$C_MAXRSS] of char;	     begina.     if FAB.FAB$B_BID = 0 then with FAB, NAM do 	begin 	fab$b_bid	:= FAB$C_BID; 	fab$b_bln	:= FAB$C_BLN; 	fab$l_nam	:= iaddress(NAM); 	nam$b_bid	:= NAM$C_BID; 	nam$b_bln	:= NAM$C_BLN;& 	nam$l_esa	:= iaddress(expanded.body); 	nam$b_ess	:= NAM$C_MAXRSS;r' 	nam$l_rsa	:= iaddress(resultant.body);Q 	nam$b_rss	:= NAM$C_MAXRSS;  	end;U     with FAB, NAM do 	begin 	fab$l_fop := FAB$M_NAM;' 	fab$l_fna := iaddress(file_spec.body);   	fab$b_fns := length(file_spec); 	end;q     rms_status := $PARSE (FAB);P8     if odd(rms_status) then rms_status := $SEARCH (FAB);     RMS_search := rms_status     end;   beginj dummy := iaddress(dummy);s! if efn = 0 then LIB$GET_EF (efn);n  g sjc_items[1] := Item_List_3[item_code: SJC$_ENTRY_NUMBER; item_len: 4; bufaddr: dummy; retaddr: dummy];_   queue_items[1] := Item_List_3[item_code: QUI$_SEARCH_NAME; item_len: length(queue); bufaddr: iaddress(queue.body); retaddr: dummy];qy queue_items[2] := Item_List_3[item_code: QUI$_SEARCH_FLAGS; item_len: 4; bufaddr: iaddress(queue_flags); retaddr: dummy];a} queue_items[3] := Item_List_3[item_code: QUI$_PENDING_JOB_COUNT; item_len: 4; bufaddr: iaddress(queue_pcnt); retaddr: dummy];C~ queue_items[4] := Item_List_3[item_code: QUI$_RETAINED_JOB_COUNT; item_len: 4; bufaddr: iaddress(queue_rcnt); retaddr: dummy];} queue_items[5] := Item_List_3[item_code: QUI$_HOLDING_JOB_COUNT; item_len: 4; bufaddr: iaddress(queue_hcnt); retaddr: dummy];  queue_items[6] := Item_List_3[item_code: QUI$_TIMED_RELEASE_JOB_COUNT; item_len: 4; bufaddr: iaddress(queue_tcnt); retaddr: dummy];O queue_items[7] := Item_List_3[item_code: QUI$_EXECUTING_JOB_COUNT; item_len: 4; bufaddr: iaddress(queue_ecnt); retaddr: dummy];*% queue_flags := QUI$M_SEARCH_WILDCARD;	  u job_items[1] := Item_List_3[item_code: QUI$_ENTRY_NUMBER; item_len: 4; bufaddr: iaddress(job_entry); retaddr: dummy]; u job_items[2] := Item_List_3[item_code: QUI$_SEARCH_FLAGS; item_len: 4; bufaddr: iaddress(job_flags); retaddr: dummy];*# job_flags := QUI$M_SEARCH_ALL_JOBS;eP { if not delete_all then job_flags := job_flags + QUI$M_SEARCH_FREEZE_CONTEXT; }   file_items[1] := Item_List_3[item_code: QUI$_FILE_SPECIFICATION; item_len: size(file_spec.body); bufaddr: iaddress(file_spec.body); retaddr: iaddress(file_spec.length)];  file_items[2] := Item_List_3[item_code: QUI$_FILE_IDENTIFICATION; item_len: size(file_ident); bufaddr: iaddress(file_ident); retaddr: dummy];     Y { Determine the number of entries in the queue and prepare to get all the entry numbers }t   context := -1;M ret_status := $GETQUIW (efn, QUI$_DISPLAY_QUEUE, context, queue_items, IOSB);e/ if odd(ret_status) then ret_status := IOSB.sts;) if not odd(ret_status) then_	     begind     SYS_MESSAGE(ret_status);     LIB$WAIT (3.0);r
     return     end;  N entry_count := queue_pcnt + queue_rcnt + queue_hcnt + queue_tcnt + queue_ecnt; if entry_count = 0 then(	     beginy(     MESSAGE ('No jobs to delete',, 1.0);
     return     end;E entry_count := entry_count + 10;	{ Allow for a few extras to arrive }  new(all_entries, entry_count);    = { Get all jobs in the queue which match our search criteria }x   entry_idx := 0;n6 while odd(ret_status) and (entry_idx < entry_count) do	     begin_M     ret_status := $GETQUIW (efn, QUI$_DISPLAY_JOB, context, job_items, IOSB); 3     if odd(ret_status) then ret_status := IOSB.sts;M     if odd(ret_status) thene 	begin 	if delete_all thene 	    { We'll delete this job }
 	    begin  	    entry_idx := entry_idx + 1;) 	    all_entries^[entry_idx] := job_entryy 	    end 	else $ 	    { Check each file in this job }
 	    begin 	    all_missing := TRUE;c 	    repeat M 		ret_status := $GETQUIW (efn, QUI$_DISPLAY_FILE, context, file_items, IOSB); 1 		if odd(ret_status) then ret_status := IOSB.sts;eP 		if odd(ret_status) then all_missing := all_missing and (RMS_search = RMS$_FNF)2 	    until not odd(ret_status) or not all_missing;] 	    if ret_status = JBC$_NOMOREFILE then ret_status := 1;  { This is actually a good thing } ' 	    if all_missing and odd(ret_status) 	 	    thenU. 		{ There are no files for this job to print } 		begin  		entry_idx := entry_idx + 1;l& 		all_entries^[entry_idx] := job_entry 		endd 	    end 	end;E     end;  5 $GETQUIW (efn, QUI$_CANCEL_OPERATION, context, IOSB);M   { Delete the selected entries }N   if entry_idx > 0 then 	     beginM     entry_count := entry_idx;S(     { Alert the user before proceeding }e     if alert_box = 0 then SMG$CREATE_VIRTUAL_DISPLAY (2, 48, alert_box, SMG$M_BORDER, SMG$M_REVERSE);M"     SMG$ERASE_DISPLAY (alert_box);N     writev (file_spec, ' ** You are about to delete ', entry_count:1, ' job');     if entry_count = 1 then   	file_spec := file_spec + ' ** '     else" 	file_spec := file_spec + 's ** ';f     if length(file_spec) < 47 then file_spec := pad(' ',' ',(48-length(file_spec)) div 2) + file_spec;  (     SMG$PUT_LINE (alert_box, file_spec);P     SMG$PUT_LINE (alert_box, '     Please confirm by responding Yes or No.', 0);p     SMG$PASTE_VIRTUAL_DISPLAY (alert_box, pasteboard_id, pasteboard_rows div 2 - 1, (pasteboard_cols-48) div 2);#     if CONFIRM ('Delete jobs') thenT 	begin8 	SMG$UNPASTE_VIRTUAL_DISPLAY (alert_box, pasteboard_id); 	if entry_count = 1 then5 	    MESSAGE ('Deleting 1 entry ...', MESSAGE_SILENT)p 	elser
 	    begin@ 	    writev(file_spec, 'Deleting ', entry_idx:1,' entries ...');( 	    MESSAGE (file_spec, MESSAGE_SILENT)	 	    end;U% 	for entry_idx := 1 to entry_count do 
 	    begin? 	    sjc_items[1].bufaddr := iaddress(all_entries^[entry_idx]);nE 	    ret_status := $SNDJBCW (efn, SJC$_DELETE_JOB,, sjc_items, IOSB);	4 	    if odd(ret_status) then ret_status := IOSB.sts;y 	    if not odd(ret_status) then MESSAGE('Error 0x'+hex(ret_status,8,8)+' deleting entry '+dec(all_entries^[entry_idx]));* 	    end 	end     else8 	SMG$UNPASTE_VIRTUAL_DISPLAY (alert_box, pasteboard_id);     endc else(     MESSAGE ('No jobs to delete',, 2.0);   { Clean up and exit }    dispose(all_entries);g end;  P {******************************************************************************* *									       * *	MANAGE_QUEUES							       * *									       *P * This is the outermost routine for managing queues.  It builds a list of all  *P * the "printer" queues on the system, then displays that list and invites the  *P * user to manipulate the selected queue or the jobs contained therein.         * *									       *P *******************************************************************************}   [global]1 Procedure MANAGE_QUEUES (initial_queue		: string;  			 start_with_jobs	: boolean;$ 			 ignore_server_queues	: boolean);   Type<     Menu_Actions	= (MENU_START_QUEUE	{ START/QUEUE		       }8 			  ,MENU_SET_FORMTYPE	{ SET QUEUE/FORM=formtype      }- 			  ,MENU_PAUSE_QUEUE	{ STOP/QUEUE		       }t0 			  ,MENU_STOP_QUEUE	{ STOP/QUEUE/NEXT	       }2 			  ,MENU_RESET_QUEUE	{ STOP/QUEUE/RESET	       }2 			  ,MENU_ABORT_JOB	{ DELETE/ENTRY=entry	       }5 			  ,MENU_DISPLAY_JOBS	{ Go to JOBS display	       }a8 			  ,MENU_CLEANUP_QUEUE	{ Delete unviable jobs	       }1 			  ,MENU_EMPTY_QUEUE	{ Delete all jobs	       }t0 			  ,MENU_SHOW_QUEUE	{ SHOW QUEUE/FULL	       }- 			  ,MENU_EXIT		{ Don't do anything	       }a 			 );   Var ret_status		: integer;     scroll_index	: integer;M&     read_terminator	: [word] 0..65535;)     selected		: queue_info_ptr value NIL;[)     queue_action	: [unsafe] Menu_Actions;v     get_next_queue	: boolean;iY     queue_stopped_menu	: SMG_Menu_ptr value NIL;	{ Actions for a queue which is stopped }_b     queue_running_menu	: SMG_Menu_ptr value NIL;	{ Actions for a queue which is processing a job }S     queue_idle_menu	: SMG_Menu_ptr value NIL;	{ Actions for a queue which is idle }S    )     function update_queue_list : boolean;$     {'@ 	Calls SYS$GETQUIW to get details on all queues.  The queues are@ 	provided in name order, so we merge them into the existing list
 	(if any).     }d)     var efn		: [static] unsigned value 0;d 	ret_status	: integer; 	context		: unsigned;  	IOSB		: IO_Status_Block;_ 	q, tmp_q	: queue_info_ptr;;  O 	function create_queue_info (prev_q, next_q : queue_info_ptr) : queue_info_ptr;n 	var nq : queue_info_ptr;t 	begin	 	new(nq);N 	with nq^ do
 	    begin 	    prev := prev_q; 	    next := next_q; 	    name		:= qui_queue_name;E% 	    description		:= qui_description;n 	    form		:= qui_form_name; 	    flags		:= qui_queue_flags; ! 	    status		:= qui_queue_status; & 	    holding_jobs	:= qui_holding_jobs;& 	    pending_jobs	:= qui_pending_jobs;( 	    retained_jobs	:= qui_retained_jobs;# 	    timed_jobs		:= qui_timed_jobs;r 	    node		:= qui_scsnode_name;r  	    device		:= qui_device_name;# 	    job_status		:= qui_job_status;t, 	    job_pending		:= qui_pending_job_reason;* 	    job_first_file	:= qui_job_first_file; 	    job_form		:= qui_job_form;P' 	    job_entry_number	:= qui_job_entry;t* 	    decoded_status	:= qui_decoded_status;& 	    if flags.QUI$V_QUEUE_GENERIC then 		begina( 		if length(qui_generic_target) = 0 then 		    generic_target := '' 		else3 		    generic_target := '--> ' + qui_generic_targetE 		endE- 	    else if length(qui_assigned_to) > 0 thene- 		generic_target := '--> ' + qui_assigned_to;k 	    display_row := 0; 	    selected := FALSE	 	    end;  	create_queue_info := nq;= 	end;  { create_queue_info }        begin  { update_queue_list }%     if efn = 0 then LIB$GET_EF (efn);r     queue_count := 0;      q := first;v     context := -1;     qui_search_name := '*';N>     qui_queue_itemlist[1].item_len := length(qui_search_name);S     ret_status := get_queue_info (efn, context, queue_count, ignore_server_queues);e+     while odd(ret_status) and (q <> NIL) doe 	begin 	get_next_queue := FALSE;  	{F 	   Merge the existing queue list with the queues returned by repeated 	   calls to SYS$GETQUIW.d4 	   'q' is a queue which we found on an earlier scan0 	  ' qui_xxx' are the details found on this scan 	}/ 	if eq(qui_queue_name, q^.name) then with q^ do;) 	    { Update the existing queue's data }(
 	    begin% 	    description		:= qui_description;I 	    form		:= qui_form_name; 	    flags		:= qui_queue_flags;d! 	    status		:= qui_queue_status; & 	    holding_jobs	:= qui_holding_jobs;& 	    pending_jobs	:= qui_pending_jobs;( 	    retained_jobs	:= qui_retained_jobs;# 	    timed_jobs		:= qui_timed_jobs;r 	    node		:= qui_scsnode_name;e  	    device		:= qui_device_name;# 	    job_status		:= qui_job_status;*, 	    job_pending		:= qui_pending_job_reason;* 	    job_first_file	:= qui_job_first_file; 	    job_form		:= qui_job_form; ' 	    job_entry_number	:= qui_job_entry;i* 	    decoded_status	:= qui_decoded_status;& 	    if flags.QUI$V_QUEUE_GENERIC then 		begin ( 		if length(qui_generic_target) = 0 then 		    generic_target := '' 		else3 		    generic_target := '--> ' + qui_generic_targetw 		endp- 	    else if length(qui_assigned_to) > 0 then*- 		generic_target := '--> ' + qui_assigned_to;* 	    get_next_queue	:= TRUE; 	    q := q^.next; 	    end) 	else if lt(qui_queue_name, q^.name) thene2 	    { Insert this new queue into the queue list }
 	    begin- 	    tmp_q := create_queue_info (q^.prev, q);P 	    if q^.prev = NIL then  		{ New queue is first in list } 		first := tmp_q	 	    elseL 		q^.prev^.next := tmp_q;O 	    q^.prev := tmp_q; 	    get_next_queue := TRUEE 	    end 	elset 	    {F 	      This queue from the queue list is no longer accessible (e.g. it5 	      has been deleted), so remove it from the list.T 	    }
 	    begin 	    tmp_q := q;K 	    if q^.prev <> NIL then q^.prev^.next := q^.next else first := q^.next;CJ 	    if q^.next <> NIL then q^.next^.prev := q^.prev else last := q^.prev; 	    if q^.selected then6 		{ We have to select a different queue to highlight } 		begineF 		if q^.next <> NIL then selected := q^.next else selected := q^.prev;^ 		MESSAGE ('Warning: '+q^.name+' is no longer accessible; selected queue has changed.',, 1.5); 		end; 	    q := q^.next; 	    dispose(tmp_q) 	 	    end;;g 	if get_next_queue then ret_status := get_queue_info (efn, context, queue_count, ignore_server_queues);W 	end;_       {AA 	If we've run out of queues from SYS$GETQUIW before we've reachediB 	the end of the queue list, the queues at the end of the list must' 	no longer be accessible (e.g. deleted)      }V     if (q <> NIL) then 	begin 	last := q^.prev;m 	repeat1 	    tmp_q := q; 	    if q^.selected then 		beginI6 		{ We have to select a different queue to highlight } 		selected := NIL;^ 		MESSAGE ('Warning: '+q^.name+' is no longer accessible; selected queue has changed.',, 1.5); 		end; 	    q := q^.next; 	    dispose(tmp_q); 	until q = NIL; 9 	if last <> NIL then last^.next := NIL else first := NIL;) 	end      else if odd(ret_status) then 	{F 	  If we've run off the end of the queue list but still have queues to= 	  process from SYS$GETQUIW, add them to the end of the list.  	} 	begin' 	last := create_queue_info (last, NIL);q# 	if first = NIL then first := last;:P 	ret_status := get_queue_info (efn, context, queue_count, ignore_server_queues); 	while odd(ret_status) do 
 	    begin1 	    last^.next := create_queue_info (last, NIL);T 	    last := last^.next;T 	    ret_status := get_queue_info (efn, context, queue_count, ignore_server_queues); 	    end 	end;f  ?     { Release the queue context so we don't run out of memory } 9     $GETQUIW(efn, QUI$_CANCEL_OPERATION, context,, IOSB);_  >     { Check the status from Get_Queue_Info and exit if error }(     if ret_status <> JBC$_NOMOREQUE then 	begin$ 	if ret_status = SS$_DEVOFFLINE then[ 	    MESSAGE ('Unable to get queue information: JOB_CONTROLLER process not running!',, 3.0)t) 	else if ret_status = JBC$_JOBQUEDIS thenmf 	    MESSAGE ('Unable to get queue information: System job/queue manager has not been started!',, 3.0) 	elsei 	    LIB$SIGNAL (ret_status);c 	update_queue_list := FALSE  	end     else 	begin* 	if selected = NIL then selected := first;4 	if selected <> NIL then selected^.selected := TRUE; 	update_queue_list := TRUE 	end;n       end;  { update_queue_list }     !     procedure display_queue_list;      {;) 	Displays the collected queue informatione     }e     var q	   : queue_info_ptr;( 	buffer	   : string(queue_browser.cols); 	r, sel	   : integer;k  	     begineJ     { Work down the queue information, updating each line in the display }5     SMG$BEGIN_DISPLAY_UPDATE (queue_browser.display); .     BROWSE_ERASE (queue_browser, queue_count);     q := first;q     r := 1;u
     sel := 0;u"     while (q <> NIL) do with q^ do 	begin3 	{ Build the line of information about this queue }_ 	one_line_summary (buffer, q^);u. 	SMG$PUT_LINE (queue_browser.display, buffer);E 	display_row := r;		{ Remember what line we displayed this queue on }E? 	if selected then sel := r;	{ Remember what line to highlight }t( 	r := r + 1;			{ Move to the next line }' 	q := q^.next;			{ And the next queue }  	end;U(     if (sel = 0) and (first <> NIL) then 	begin
 	sel := 1; 	first^.selected := TRUE 	end;e+     BROWSE_SELECT_ROW (queue_browser, sel);_3     SMG$END_DISPLAY_UPDATE (queue_browser.display);	     end;    T     procedure build_queue_menu (menu_type : integer; var queue_menu : SMG_Menu_ptr);     const MENU_ITEM_WIDTH = 15;i     varl 	idx		: integer;} 	action_set	: set of Menu_Actions value [MENU_SET_FORMTYPE, MENU_RESET_QUEUE, MENU_DISPLAY_JOBS, MENU_SHOW_QUEUE, MENU_EXIT];t  Z 	procedure add_item (item : packed array [l0..h0:integer] of char; action : Menu_Actions); 	begin" 	queue_menu^.choices[idx] := item;$ 	queue_menu^.actions[idx] := action; 	idx := idx + 1: 	end;e  	     begin+2     { Work out how many menu items there will be }Q     if (menu_type = QUI$M_QUEUE_AVAILABLE) or (menu_type = QUI$M_QUEUE_IDLE) thenq 	{- 	  The menu will contain the following items:e 		Set Formtype
 		Pause Queuel 		Stop Queue
 		Reset QueueA! 		Abort Job	(not for IDLE queues)  		Display Jobs1 		Cleanup Queue	(provided the user is authorised)d/ 		Empty Queue	(provided the user is authorised)f 		SHOW QUEUE/FULLE 	} 	begin@ 	action_set := action_set + [MENU_PAUSE_QUEUE, MENU_STOP_QUEUE];V 	if menu_type = QUI$M_QUEUE_AVAILABLE then action_set := action_set + [MENU_ABORT_JOB] 	end     else 	{- 	  The menu will contain the following items:d
 		Start Queuep 		Set Formtype
 		Reset QueueQ 		Display Jobs1 		Cleanup Queue	(provided the user is authorised)s/ 		Empty Queue	(provided the user is authorised)s 		SHOW QUEUE/FULLs 	}/ 	action_set := action_set + [MENU_START_QUEUE];        { Add authorised actions }\     if user_rights[PQM__QUEUE_CLEANUP] then action_set := action_set + [MENU_CLEANUP_QUEUE];Z     if user_rights[PQM__QUEUE_EMPTY]   then action_set := action_set + [MENU_EMPTY_QUEUE];  8     { Allocate the menu data structure and populate it }7     new(queue_menu, card(action_set), MENU_ITEM_WIDTH);-     queue_menu^ := ZERO;     with queue_menu^ doe 	begin
 	idx := 1;= 	{ The sequence below sets the order of items on the screen }aY 	if MENU_START_QUEUE   in action_set then add_item ('Start Queue',     MENU_START_QUEUE);vZ 	if MENU_SET_FORMTYPE  in action_set then add_item ('Set Formtype',    MENU_SET_FORMTYPE);Y 	if MENU_PAUSE_QUEUE   in action_set then add_item ('Pause Queue',     MENU_PAUSE_QUEUE);-X 	if MENU_STOP_QUEUE    in action_set then add_item ('Stop Queue',      MENU_STOP_QUEUE);Y 	if MENU_RESET_QUEUE   in action_set then add_item ('Reset Queue',     MENU_RESET_QUEUE);;W 	if MENU_ABORT_JOB     in action_set then add_item ('Abort Job',       MENU_ABORT_JOB);kZ 	if MENU_DISPLAY_JOBS  in action_set then add_item ('Display Jobs',    MENU_DISPLAY_JOBS);[ 	if MENU_CLEANUP_QUEUE in action_set then add_item ('Cleanup Queue',   MENU_CLEANUP_QUEUE);ZY 	if MENU_EMPTY_QUEUE   in action_set then add_item ('Empty Queue',     MENU_EMPTY_QUEUE);aX 	if MENU_SHOW_QUEUE    in action_set then add_item ('SHOW QUEUE/FULL', MENU_SHOW_QUEUE);R 	if MENU_EXIT          in action_set then add_item ('Exit this menu',  MENU_EXIT); 	end;d       end; { build_queue_menu }c    ^     procedure do_queue_menu (queue : queue_info; var selected_action : [unsafe] Menu_Actions);     {h6 	Displays a menu of commands applicable to this queue,' 	and then performs the selected action.q     }c     var ret_status	: integer;e 	queue_menu	: SMG_Menu_ptr;nB 	queue_row	: integer;		{ Where to display the menu on the screen } 	terminator	: [word] 0..65535;7 	sjc_itemlist	: array [1..3] of Item_List_3 value ZERO;b 	IOSB		: IO_Status_Block;.$ 	warn_str	: string(pasteboard_cols);  	     begine;     sjc_itemlist[1] := Item_List_3 [item_code : SJC$_QUEUE;2' 				    item_len  : length(queue.name);_. 				    bufaddr   : iaddress(queue.name.body); 				    retaddr   : ZERO];  5     { Determine the menu type and default selection }i     with queue.status do 	begin% 	if QUI$V_QUEUE_AUTOSTART_INACTIVE ort 	   QUI$V_QUEUE_PAUSED or_ 	   QUI$V_QUEUE_PAUSING or 	   QUI$V_QUEUE_RESETTING or 	   QUI$V_QUEUE_STALLED or 	   QUI$V_QUEUE_STOP_PENDING orD 	   QUI$V_QUEUE_STOPPED or 	   QUI$V_QUEUE_STOPPING thene
 	    begin& 	    queue_menu := queue_stopped_menu;) 	    if QUI$V_QUEUE_AUTOSTART_INACTIVE orE 	       QUI$V_QUEUE_PAUSED oro 	       QUI$V_QUEUE_STALLED or  	       QUI$V_QUEUE_STOPPED then, 		queue_menu^.selection := 1 { Start Queue }	 	    elseO, 		queue_menu^.selection := 3 { Reset Queue } 	    end 	else 
 	    begin 	    if QUI$V_QUEUE_IDLE thenl 		begind  		queue_menu := queue_idle_menu;R 		if (queue.pending_jobs > 0) and queue.job_pending.QUI$V_PEND_STOCK_MISMATCH then1 		    queue_menu^.selection := 1	{ Set Formtype }i 		else/ 		    queue_menu^.selection := 3	{ Stop queue }i 		ende	 	    elsed 		begina# 		queue_menu := queue_running_menu;e 		if QUI$V_QUEUE_BUSY then0 		    queue_menu^.selection := 2	{ Pause Queue } 		else/ 		    queue_menu^.selection := 3	{ Stop queue }S 		ends 	    end 	end;: 	M\     queue_row := queue.display_row - queue_browser.viewport_start + QUEUE_BROWSER_PASTE_ROW;*     PREPARE_MENU (queue_menu^, queue_row);  3     ret_status := SMG$SELECT_FROM_MENU (keyboard_idP 				       ,queue_menu^.display 3 				       ,queue_menu^.selection	{ selected item }_2 				       ,queue_menu^.selection	{ initial item } 				       ,			{ flags }+ 				       ,'PQM_HELPLIB'		{ help library }r& 				       ,300			{ 5-minute timeout } 				       ,terminator);E     SMG$UNPASTE_VIRTUAL_DISPLAY (queue_menu^.display, pasteboard_id);_     if not odd(ret_status) thent 	begin> 	if (ret_status = SMG$_EOF) or (ret_status = SS$_TIMEOUT) then 	    { Don't do anything }
 	    begin" 	    selected_action := MENU_EXIT; 	    ret_status := SS$_NORMAL  	    end* 	else if (ret_status = SS$_BADESCAPE) then
 	    begin 	    SYS_MESSAGE (ret_status); 	    FLUSH_KEYBOARD_INPUT;" 	    selected_action := MENU_EXIT; 	    ret_status := SS$_NORMALt 	    end 	else 
 	    begin" 	    if ret_status = RMS$_FNF then 		beginf= 		MESSAGE ('PQM_HELPLIB not defined or not accessible',,2.0);s 		ret_status := SS$_NORMAL 		ende	 	    else  		LIB$SIGNAL (ret_status);! 	    selected_action := MENU_EXIT  	    end 	end     else? 	selected_action := queue_menu^.actions[queue_menu^.selection];   !     { Process the selected item },     case selected_action oftH 	MENU_START_QUEUE:	{ Start Queue without changing any queue properties }	 	   begint= 	   MESSAGE ('Starting queue ' + queue.name, MESSAGE_SILENT);aN 	   ret_status := $SNDJBCW (EFN$C_ENF, SJC$_START_QUEUE,, sjc_itemlist, IOSB);3 	   if odd(ret_status) then ret_status := IOSB.sts;h 	   end;  $ 	MENU_SET_FORMTYPE:	{ Set Formtype }	 	   begin$C 	   BUILD_FORM_SELECTOR (form_selector, queue_row, queue.job_form);i3 	   ret_status := SMG$SELECT_FROM_MENU (keyboard_idd" 					      ,form_selector^.display6 					      ,form_selector^.selection	{ selected item }5 					      ,form_selector^.selection	{ initial item }S! 					      ,				{ control flags }r+ 					      ,'PQM_HELPLIB'		{ help library }t& 					      ,300			{ timeout - 5 mins } 					      ,terminator);6 	   if not odd(ret_status) then with form_selector^ do 		begin 0 		selection := count;  { Don't change the form }? 		if (ret_status = SMG$_EOF) or (ret_status = SS$_TIMEOUT) theni 		    begin_B 		    MESSAGE ('Queue formtype not changed', MESSAGE_SILENT, 1.5); 		    ret_status := SS$_NORMAL	 		    end + 		else if (ret_status = SS$_BADESCAPE) thenl 		    begins 		    SYS_MESSAGE (ret_status);_ 		    FLUSH_KEYBOARD_INPUT;n 		    selection := count;  		    ret_status := SS$_NORMAL	 		    ende$ 		else if ret_status = RMS$_FNF then 		    ret_status := SS$_NORMAL 		else 		    LIB$SIGNAL (ret_status); 		end;H 	   SMG$UNPASTE_VIRTUAL_DISPLAY (form_selector^.display, pasteboard_id);R 	   if form_selector^.selection < form_selector^.count then with form_selector^ do
 	       beginAC 	       sjc_itemlist[2] := Item_List_3 [item_code : SJC$_FORM_NAME;h3 					       item_len  : length(choices[selection]); 5 					       bufaddr   : iaddress(choices[selection]);a 					       otherwise ZERO];R 	       ret_status := $SNDJBCW (EFN$C_ENF, SJC$_ALTER_QUEUE,, sjc_itemlist, IOSB);7 	       if odd(ret_status) then ret_status := IOSB.sts;* 	       end; 	   end;  " 	MENU_PAUSE_QUEUE:	{ Pause Queue }	 	   begini< 	   MESSAGE ('Pausing queue ' + queue.name, MESSAGE_SILENT);N 	   ret_status := $SNDJBCW (EFN$C_ENF, SJC$_PAUSE_QUEUE,, sjc_itemlist, IOSB);3 	   if odd(ret_status) then ret_status := IOSB.sts;B 	   end;    	MENU_STOP_QUEUE:	{ Stop Queue }	 	   beginx= 	   MESSAGE ('Stopping queue ' + queue.name, MESSAGE_SILENT);.M 	   ret_status := $SNDJBCW (EFN$C_ENF, SJC$_STOP_QUEUE,, sjc_itemlist, IOSB); 3 	   if odd(ret_status) then ret_status := IOSB.sts;  	   end;  ' 	MENU_RESET_QUEUE:	{ Stop/Reset queue }u	 	   begin > 	   MESSAGE ('Resetting queue ' + queue.name, MESSAGE_SILENT);N 	   ret_status := $SNDJBCW (EFN$C_ENF, SJC$_RESET_QUEUE,, sjc_itemlist, IOSB);3 	   if odd(ret_status) then ret_status := IOSB.sts;s 	   end;   	MENU_ABORT_JOB:		{ Abort Job } 	 	   beginn> 	   writev(warn_str, 'Delete job ', queue.job_entry_number:1); 	   if CONFIRM (warn_str) then 		begin;@ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;/ 						item_len  : size(queue.job_entry_number);d3 						bufaddr   : iaddress(queue.job_entry_number);: 						retaddr   : ZERO];E 		writev(warn_str, 'Deleting job ', queue.job_entry_number:1, '...'); % 		MESSAGE (warn_str, MESSAGE_SILENT); J 		ret_status := $SNDJBCW (EFN$C_ENF, SJC$_ABORT_JOB,, sjc_itemlist, IOSB);1 		if odd(ret_status) then ret_status := IOSB.sts;r 		end' 	   end;  ' 	MENU_DISPLAY_JOBS:	{ Go to JOBS menu }e	 	   begint 	   end;  X 	MENU_CLEANUP_QUEUE:	{ Cleanup Queue, i.e. delete all jobs whose files no longer exist }
 	    begin0 	    if not user_rights[PQM__QUEUE_CLEANUP] then 		beginuD 		MESSAGE ('You are not authorised to use this PQM function',, 3.0); 		end$	 	    elseu 		begine+ 		DELETE_MULTIPLE_JOBS (queue.name, FALSE);e 		end; 	    ret_status := SS$_NORMALO	 	    end;   E 	MENU_EMPTY_QUEUE:	{ Empty Queue, i.e. delete all jobs in the queue }*
 	    begin. 	    if not user_rights[PQM__QUEUE_EMPTY] then 		beginOD 		MESSAGE ('You are not authorised to use this PQM function',, 3.0); 		end 	 	    elsev 		begino* 		DELETE_MULTIPLE_JOBS (queue.name, TRUE); 		end; 	    ret_status := SS$_NORMAL*	 	    end;*  1 	MENU_SHOW_QUEUE:	{ DCL command SHOW QUEUE/FULL }*	 	   begin  	   ret_status := DISPLAY_DCL_COMMAND ('SHOW QUEUE/FULL ' + queue.name, QUEUE_BROWSER_PASTE_ROW-1, queue_browser.viewport_rows+1); 	   end;  " 	MENU_EXIT:		{ Don't do anything } 	   ret_status := SS$_NORMAL;o           end;  C     if (ret_status = JBC$_NORMAL) or (ret_status = SS$_NORMAL) thenI 	ERASE_MESSAGE     else 	SYS_MESSAGE (ret_status);  0     SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);E     { SMG$POP_VIRTUAL_DISPLAY (queue_menu^.display, pasteboard_id); }        end; { do_queue_menu }     Begin	{ MANAGE_QUEUES }k   { Build the queue structures }  % if not update_queue_list then return;L! if length(initial_queue) > 0 then 	     begin I     while (selected <> NIL) and_then ne(selected^.name, initial_queue) dom 	begin 	selected^.selected := FALSE;= 	selected := selected^.next  	end;x-     if selected = NIL then selected := first;_6     if selected <> NIL then selected^.selected := TRUE     end;    # { Create the queue detail display }   n ret_status := SMG$CREATE_VIRTUAL_DISPLAY (QUEUE_DETAIL_ROWS, pasteboard_cols-2, detail_display, SMG$M_BORDER); if not odd(ret_status) then 	     begin:5     writeln('Unable to create Queue detail display');      LIB$SIGNAL (ret_status);     end;P DETAIL_COL := (pasteboard_cols-2-ROW_1_LENGTH) div 2 + length(DETAIL_LABEL) + 1;D NODE_COL   := DETAIL_COL + QUEUE_NAME_SIZE + 5 + length(NODE_LABEL); SMG$PUT_CHARS (detail_display, DETAIL_LABEL, DETAIL_ROW, (pasteboard_cols-2-ROW_1_LENGTH) div 2 + 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);Y SMG$PUT_CHARS (detail_display, NODE_LABEL, NODE_ROW, DETAIL_COL + QUEUE_NAME_SIZE + 5,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);dp SMG$PUT_CHARS (detail_display, DESCR_LABEL, DESCR_ROW, 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);t SMG$PUT_CHARS (detail_display, PENDING_LABEL, PENDING_ROW, 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT); SMG$PUT_CHARS (detail_display, HOLDING_LABEL, HOLDING_ROW, PENDING_COL+4,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT); SMG$PUT_CHARS (detail_display, COMPLETED_LABEL, COMPLETED_ROW, HOLDING_COL+4,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT); SMG$PUT_CHARS (detail_display, DEVICE_LABEL, DEVICE_ROW, COMPLETED_COL+5,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);~ SMG$LABEL_BORDER (detail_display, ' PQM '+PQM_VERSION+' ', SMG$K_TOP, 2, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);    $ { Create the queue browser display }  x ret_status := BROWSE_SETUP (queue_count, pasteboard_rows-QUEUE_BROWSER_PASTE_ROW, QUEUE_BROWSER_HEADING, queue_browser); if not odd(ret_status) thenr	     begino+     writeln('Unable to create Queue list');n     LIB$SIGNAL (ret_status);     end;    A { Create the action menus for stopped queues and running queues }   5 build_queue_menu (QUI$M_QUEUE_IDLE, queue_idle_menu);o; build_queue_menu (QUI$M_QUEUE_STOPPED, queue_stopped_menu);o= build_queue_menu (QUI$M_QUEUE_AVAILABLE, queue_running_menu);f     { J   If the user specified PQM /INITIAL_SCREEN=JOBS=queue then go to the JOBS
   display. }  if start_with_jobs then;     MANAGE_JOBS (selected) else0     SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);     {p   Reveal what we've done.RK   The headings display must be pasted "under" the detail display, otherwise*>   the job displays get occluded by it.  (Bug in SMG, perhaps?) } " display_queue_details (selected^); display_queue_list; N SMG$PASTE_VIRTUAL_DISPLAY (detail_display, pasteboard_id, 2, 2, time_display);p SMG$PASTE_VIRTUAL_DISPLAY (queue_browser.headings, pasteboard_id, QUEUE_BROWSER_PASTE_ROW-1, 1, detail_display);] SMG$PASTE_VIRTUAL_DISPLAY (queue_browser.display, pasteboard_id, QUEUE_BROWSER_PASTE_ROW, 1);U* SMG$END_PASTEBOARD_UPDATE (pasteboard_id);    N { Run in a loop, updating the queue information and processing user requests }   repeat  F     UPDATE_TIME_DISPLAY;   { Update the time displayed on the screen }       if read_timeout > 0 thenO 	ret_status := SMG$READ_KEYSTROKE (keyboard_id, read_terminator,, read_timeout)_     elseA 	ret_status := SMG$READ_KEYSTROKE (keyboard_id, read_terminator);d?     if not odd(ret_status) and (ret_status <> SS$_TIMEOUT) then  	begin& 	if ret_status = SMG$_EOF then return;# 	if ret_status = SS$_BADESCAPE thenq
 	    begin 	    SYS_MESSAGE (ret_status); 	    FLUSH_KEYBOARD_INPUT;( 	    read_terminator := SMG$K_TRM_CTRLW; 	    end 	else  	   LIB$SIGNAL (ret_status); 	end;        case read_terminator ofe 	SMG$K_TRM_HELP,5 	SMG$K_TRM_QUESTION_MARK : { Display some help text }, 			  DISPLAY_HELP;   	SMG$K_TRM_UPPERCASE_P,* 	SMG$K_TRM_LOWERCASE_P,*R 	SMG$K_TRM_PREV_SCREEN : { Jump to the queue which appears 2/3 way up the screen }
 			  begin6 			  SMG$BEGIN_DISPLAY_UPDATE (queue_browser.display);! 			  if selected^.prev = NIL theno+ 			      { We're 'up' as far as we can go }n+ 			      MESSAGE ('Already at top of list')c	 			  elses 			      begin 			      ERASE_MESSAGE;a% 			      selected^.selected := FALSE;	 			      scroll_index := 0; f 			      while (selected^.prev <> NIL) and (scroll_index < (queue_browser.viewport_rows * 2 div 3)) do 				  beginM! 				  selected := selected^.prev;	& 				  scroll_index := scroll_index + 1
 				  end;M 			      if selected^.prev = NIL then MESSAGE('Top of list', MESSAGE_SILENT); $ 			      selected^.selected := TRUE;& 			      update_one_queue (selected^);
 			      end; 4 			  SMG$END_DISPLAY_UPDATE (queue_browser.display);	 			  end;_   	SMG$K_TRM_UPPERCASE_N,_ 	SMG$K_TRM_LOWERCASE_N,nT 	SMG$K_TRM_NEXT_SCREEN : { Jump to the queue which appears 2/3 way down the screen }
 			  begin6 			  SMG$BEGIN_DISPLAY_UPDATE (queue_browser.display);! 			  if selected^.next = NIL thene- 			      { We're 'down' as far as we can go }g. 			      MESSAGE ('Already at bottom of list')	 			  else  			      begin 			      ERASE_MESSAGE;t% 			      selected^.selected := FALSE;  			      scroll_index := 0;Uf 			      while (selected^.next <> NIL) and (scroll_index < (queue_browser.viewport_rows * 2 div 3)) do 				  begino! 				  selected := selected^.next;_& 				  scroll_index := scroll_index + 1
 				  end;P 			      if selected^.next = NIL then MESSAGE('Bottom of list', MESSAGE_SILENT);$ 			      selected^.selected := TRUE;& 			      update_one_queue (selected^);
 			      end;d4 			  SMG$END_DISPLAY_UPDATE (queue_browser.display);	 			  end;   M 	SMG$K_TRM_UP	: { Highlight the queue which appears above the current queue }r
 			  begin6 			  SMG$BEGIN_DISPLAY_UPDATE (queue_browser.display);! 			  if selected^.prev = NIL then$+ 			      { We're 'up' as far as we can go } + 			      MESSAGE ('Already at top of list') 	 			  elseM 			      begin 			      ERASE_MESSAGE;p% 			      selected^.selected := FALSE;n$ 			      selected := selected^.prev;$ 			      selected^.selected := TRUE;& 			      update_one_queue (selected^);
 			      end;*4 			  SMG$END_DISPLAY_UPDATE (queue_browser.display);	 			  end;r  O 	SMG$K_TRM_DOWN	: { Highlight the queue which appears below the current queue }s
 			  begin6 			  SMG$BEGIN_DISPLAY_UPDATE (queue_browser.display);! 			  if selected^.next = NIL thenB- 			      { We're 'down' as far as we can go } . 			      MESSAGE ('Already at bottom of list')	 			  elseA 			      begin 			      ERASE_MESSAGE;F% 			      selected^.selected := FALSE; $ 			      selected := selected^.next;$ 			      selected^.selected := TRUE;& 			      update_one_queue (selected^);
 			      end;A4 			  SMG$END_DISPLAY_UPDATE (queue_browser.display);	 			  end;A   	SMG$K_TRM_UPPERCASE_M,  	SMG$K_TRM_LOWERCASE_M,Q 	SMG$K_TRM_DO,X 	SMG$K_TRM_PF4	: { Display a menu of queue operations and perform the user's selection }
 			  begin 			  ERASE_MESSAGE;f- 			  do_queue_menu (selected^, queue_action);_- 			  if queue_action = MENU_DISPLAY_JOBS then) 			      begin3 			      SMG$END_PASTEBOARD_UPDATE (pasteboard_id);   			      MANAGE_JOBS (selected);$ 			      if exit_flag then continue;$ 			      force_queue_refresh := TRUE 			      end	 			  elseB 			      begin& 			      update_one_queue (selected^);2 			      SMG$END_PASTEBOARD_UPDATE (pasteboard_id) 			      end	 			  end;u   	SMG$K_TRM_CTRLM,(/ 	SMG$K_TRM_ENTER	: { Move to the JOBS display } 
 			  begin 			  MANAGE_JOBS (selected);5 			  if exit_flag then continue;  { Should exit now }u  			  force_queue_refresh := TRUE	 			  end;d   	SMG$K_TRM_TIMEOUT,N3 	SMG$K_TRM_SPACE	: { Update the entire queue list }r
 			  begin1 			  SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);N  			  force_queue_refresh := TRUE	 			  end;q  < 	SMG$K_TRM_CTRLW	: { Redraw the screen without changing it }( 			  SMG$REPAINT_SCREEN (pasteboard_id);   	SMG$K_TRM_UPPERCASE_F,c 	SMG$K_TRM_LOWERCASE_F:u/ 			  { Display filenames instead of job names }_
 			  begin 			  show_filenames := TRUE;1 			  SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);[  			  force_queue_refresh := TRUE	 			  end;O   	SMG$K_TRM_UPPERCASE_J,d 	SMG$K_TRM_LOWERCASE_J:r/ 			  { Display jobnames instead of file names }D
 			  begin 			  show_filenames := FALSE;c1 			  SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);e  			  force_queue_refresh := TRUE	 			  end;]   	SMG$K_TRM_UPPERCASE_Q,Q 	SMG$K_TRM_LOWERCASE_Q:n 			  { Exit program }j 			  exit_flag := TRUE;]  ' 	      otherwise	  { Unexpected input } + 			  MESSAGE ('Unexpected input; ignored');  	end;_       if force_queue_refresh thene 	begin 	if update_queue_list then
 	    begin 	    display_queue_list;' 	    display_queue_details (selected^);c 	    end 	elsei 	    exit_flag := TRUE;]+ 	SMG$END_PASTEBOARD_UPDATE (pasteboard_id);U 	force_queue_refresh := FALSEn 	end;f   until exit_flag;   End;   eP {*******************************************************************************% *	Module Initialisation						       *tP *******************************************************************************}   TO BEGIN DOe   beginr  P {-------------------------------------------------------------------------------+ 	Set up the QUEUE item list for SYS$GETQUIW.P -------------------------------------------------------------------------------}  C qui_queue_itemlist[1]	:= Item_List_3 [item_code : QUI$_SEARCH_NAME;E 					item_len  : 0;l0 					bufaddr   : iaddress(qui_search_name.body); 					retaddr   : ZERO];w  D qui_queue_itemlist[2]	:= Item_List_3 [item_code : QUI$_SEARCH_FLAGS; 					item_len  : 4;u, 					bufaddr   : iaddress(qui_search_flags); 					retaddr	  : ZERO];_  B qui_queue_itemlist[3]	:= Item_List_3 [item_code : QUI$_QUEUE_NAME;+ 					item_len  : size(qui_queue_name.body);o/ 					bufaddr   : iaddress(qui_queue_name.body);_2 					retaddr   : iaddress(qui_queue_name.length)];  A qui_queue_itemlist[4]	:= Item_List_3 [item_code : QUI$_FORM_NAME;g* 					item_len  : size(qui_form_name.body);. 					bufaddr   : iaddress(qui_form_name.body);1 					retaddr   : iaddress(qui_form_name.length)];b  C qui_queue_itemlist[5]	:= Item_List_3 [item_code : QUI$_DEVICE_NAME;W, 					item_len  : size(qui_device_name.body);0 					bufaddr   : iaddress(qui_device_name.body);3 					retaddr   : iaddress(qui_device_name.length)];a  D qui_queue_itemlist[6]	:= Item_List_3 [item_code : QUI$_SCSNODE_NAME;- 					item_len  : size(qui_scsnode_name.body);O1 					bufaddr   : iaddress(qui_scsnode_name.body);a4 					retaddr   : iaddress(qui_scsnode_name.length)];  C qui_queue_itemlist[7]	:= Item_List_3 [item_code : QUI$_QUEUE_FLAGS; ' 					item_len  : size(qui_queue_flags);n+ 					bufaddr   : iaddress(qui_queue_flags);e 					retaddr   : ZERO];G  D qui_queue_itemlist[8]	:= Item_List_3 [item_code : QUI$_QUEUE_STATUS;( 					item_len  : size(qui_queue_status);, 					bufaddr   : iaddress(qui_queue_status); 					retaddr   : ZERO];r  I qui_queue_itemlist[9]	:= Item_List_3 [item_code : QUI$_HOLDING_JOB_COUNT;a 					item_len  : 4;R, 					bufaddr   : iaddress(qui_holding_jobs); 					retaddr	  : ZERO];e  J qui_queue_itemlist[10]	:= Item_List_3 [item_code : QUI$_PENDING_JOB_COUNT; 					item_len  : 4;_, 					bufaddr	  : iaddress(qui_pending_jobs); 					retaddr   : ZERO];;  J qui_queue_itemlist[11]	:= Item_List_3 [item_code : QUI$_QUEUE_DESCRIPTION;, 					item_len  : size(qui_description.body);0 					bufaddr   : iaddress(qui_description.body);3 					retaddr   : iaddress(qui_description.length)];0  K qui_queue_itemlist[12]	:= Item_List_3 [item_code : QUI$_RETAINED_JOB_COUNT;v 					item_len  : 4;o- 					bufaddr   : iaddress(qui_retained_jobs);t 					retaddr   : ZERO];E  P qui_queue_itemlist[13]	:= Item_List_3 [item_code : QUI$_TIMED_RELEASE_JOB_COUNT; 					item_len  : 4;.* 					bufaddr   : iaddress(qui_timed_jobs); 					retaddr   : ZERO];e  G qui_queue_itemlist[14]	:= Item_List_3 [item_code : QUI$_GENERIC_TARGET;N/ 					item_len  : size(qui_generic_target.body);t3 					bufaddr   : iaddress(qui_generic_target.body);s6 					retaddr   : iaddress(qui_generic_target.length)];  L qui_queue_itemlist[15]	:= Item_List_3 [item_code : QUI$_ASSIGNED_QUEUE_NAME;, 					item_len  : size(qui_assigned_to.body);0 					bufaddr   : iaddress(qui_assigned_to.body);3 					retaddr   : iaddress(qui_assigned_to.length)];e  P {------------------------------------------------------------------------------- 	Set up the JOB item listjP -------------------------------------------------------------------------------}  B qui_job_itemlist[1]	:= Item_List_3 [item_code : QUI$_SEARCH_FLAGS;( 					item_len  : size(qui_search_flags);, 					bufaddr   : iaddress(qui_search_flags); 					retaddr   : ZERO];o  @ qui_job_itemlist[2]	:= Item_List_3 [item_code : QUI$_JOB_STATUS;& 					item_len  : size(qui_job_status);* 					bufaddr   : iaddress(qui_job_status); 					retaddr   : ZERO];   H qui_job_itemlist[3]	:= Item_List_3 [item_code : QUI$_PENDING_JOB_REASON;. 					item_len  : size(qui_pending_job_reason);2 					bufaddr   : iaddress(qui_pending_job_reason); 					retaddr   : ZERO];i  ? qui_job_itemlist[4]	:= Item_List_3 [item_code : QUI$_FORM_NAME;o) 					item_len  : size(qui_job_form.body);A- 					bufaddr   : iaddress(qui_job_form.body);T0 					retaddr   : iaddress(qui_job_form.length)];  B qui_job_itemlist[5]	:= Item_List_3 [item_code : QUI$_ENTRY_NUMBER;% 					item_len  : size(qui_job_entry);Q) 					bufaddr   : iaddress(qui_job_entry);U 					retaddr   : ZERO];=  > qui_job_itemlist[6]	:= Item_List_3 [item_code : QUI$_JOB_NAME;) 					item_len  : size(qui_job_name.body);i- 					bufaddr   : iaddress(qui_job_name.body);l0 					retaddr   : iaddress(qui_job_name.length)];    P {------------------------------------------------------------------------------- 	Set up the FILE item listP -------------------------------------------------------------------------------}  I qui_file_itemlist[1]	:= Item_List_3 [item_code : QUI$_FILE_SPECIFICATION;e/ 					item_len  : size(qui_job_first_file.body);:3 					bufaddr   : iaddress(qui_job_first_file.body);i6 					retaddr   : iaddress(qui_job_first_file.length)];  P {------------------------------------------------------------------------------- 	Set up the FORMS item list P -------------------------------------------------------------------------------}  B qui_form_itemlist[1]	:= Item_List_3 [item_code : QUI$_SEARCH_NAME;0 					bufaddr   : iaddress(qui_search_name.body); 					otherwise ZERO];y  @ qui_form_itemlist[2]	:= Item_List_3 [item_code : QUI$_FORM_NAME;* 					item_len  : size(qui_form_name.body);. 					bufaddr   : iaddress(qui_form_name.body);1 					retaddr   : iaddress(qui_form_name.length)];u end;   End.