> /*  C K C F N 3  --  Packet buffer management for C-Kermit  */  4 /* (plus assorted functions tacked on at the end) */   /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   #include "ckcsym.h"  #include "ckcdeb.h"  #include "ckcasc.h"  #include "ckcker.h"  #include "ckcxla.h"    #ifndef NODISPO  #ifdef pdp11 #define NODISPO  #endif /* pdpd11 */  #endif /* NODISPO */  H extern int unkcs, wmax, wcur, discard, bctu, bctl, local, fdispla, what,   sendmode, opnerr;  extern long sendstart;   extern char * ofn2;  extern char ofn1[];  extern int ofn1x;    #ifdef CK_LABELED  extern int xflg; #endif /* CK_LABELED */  extern CHAR *data; extern char filnam[];  #ifndef NOFRILLS5 extern int rprintf, rmailf;		/* REMOTE MAIL, PRINT */ < extern char optbuf[];			/* Options buffer for mail, print */ #endif /* NOFRILLS */  extern int wslots;I extern int fblksiz, frecl, forg, frecfm, fncact, fncsav, fcctrl, lf_opts;  #ifdef pdp11   extern CHAR srvcmd[];    extern char tmpbuf[]; !   CHAR *pktmsg = (CHAR *) tmpbuf;  #else  #ifdef DYNAMIC   extern CHAR *srvcmd;   extern CHAR *pktmsg; #else    extern CHAR srvcmd[];    extern CHAR pktmsg[];  #endif /* DYNAMIC */ #endif /* pdp11 */   extern int binary, spsiz; @ extern int pktnum, cxseen, czseen, bsave, bsavef, nfils, stdinf;/ extern int memstr, stdouf, keep, sndsrc, hcflg;  extern int server, en_cwd;  
 extern intA   atenci, atenco, atdati, atdato, atleni, atleno, atblki, atblko, B   attypi, attypo, atsidi, atsido, atsysi, atsyso, atdisi, atdiso;    #ifdef STRATUS: extern int atfrmi, atfrmo, atcrei, atcreo, atacti, atacto; #endif /* STRATUS */   #ifdef datageneral extern int quiet;  #endif /* datageneral */  $ extern long fsize, filcnt, ffc, tfc;   #ifndef NOCSETS  extern int tcharset, fcharset; extern int ntcsets; * extern struct csinfo tcsinfo[], fcsinfo[];  ' /* Pointers to translation functions */  #ifdef CK_ANSIC G extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* Character set */ O extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* translation functions */ N extern CHAR (*rx)(CHAR); /* Pointer to input character translation function */O extern CHAR (*sx)(CHAR); /* Pointer to output character translation function */  #else C extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])();	/* Character set */ L extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])();	/* translation functions. */J extern CHAR (*rx)();	/* Pointer to input character translation function */N extern CHAR (*sx)();    /* Pointer to output character translation function */ #endif /* CK_ANSIC */  #endif /* NOCSETS */  @ /* Variables global to Kermit that are defined in this module */  5 int winlo;				/* packet number at low window edge  */   , int sbufnum;				/* number of free buffers */( int dum001 = 1234;			/* protection... */. int sbufuse[MAXWS];			/* buffer in-use flag */ int dum003 = 1111;, int rbufnum;				/* number of free buffers */* int dum002 = 4321;			/* more protection */. int rbufuse[MAXWS];			/* buffer in-use flag */5 int sseqtbl[64];			/* sequence # to buffer # table */ 5 int rseqtbl[64];			/* sequence # to buffer # table */ - int sacktbl[64];			/* sequence # ack table */    #ifdef DYNAMIC@ struct pktinfo *s_pkt = NULL;		/* array of pktinfo structures */@ struct pktinfo *r_pkt = NULL;		/* array of pktinfo structures */ #else ? struct pktinfo s_pkt[MAXWS];		/* array of pktinfo structures */ ? struct pktinfo r_pkt[MAXWS];		/* array of pktinfo structures */  #endif /* DYNAMIC */   #ifdef DEBUG* char xbuf[200];				/* For debug logging */ #endif /* DEBUG */   #ifdef DYNAMIC& CHAR *bigsbuf = NULL, *bigrbuf = NULL; #else : char bigsbt[8];				/* Protection (shouldn't need this). */ 					/* BUT DON'T REMOVE IT! */ 7 CHAR bigsbuf[SBSIZ + 5];		/* Send-packet buffer area */ ' char bigrbt[8];				/* Safety padding */ 3 CHAR bigrbuf[RBSIZ + 5];		/* Receive-packet area */  #endif> int bigsbsiz = SBSIZ;			/* Sizes of big send & rcv buffers. */ int bigrbsiz = RBSIZ;    /* FUNCTIONS */   C /* For sanity, use "i" for buffer slots, "n" for packet numbers. */    /* I N I B U F S */    /*-   Allocates the big send and receive buffers. @   Call with size for big send buffer (s) and receive buffer (r).   These sizes can be different. F   Attempts to allocate buffers of the requested size, but if it can't,    it will allocate smaller ones.B   Sets global variables bigsbsiz and bigrbsiz to the actual sizes,9   and bigsbuf and bigrbuf pointing to the actual buffers. '   Designed to be called more than once. &   Returns 0 on success, -1 on failure. */   CHAR *bigbufp = NULL;    int  inibufs(s,r) int s, r; { #ifdef DYNAMIC     unsigned       int size; 
 #ifdef OS2A     unsigned		/* Don't you wish everybody had unsigned long... */  #endif /* OS2 */  
       long z; 
     int x;  !     debug(F101,"inibufs s","",s); !     debug(F101,"inibufs r","",r);   ?     if (s < 80 || r < 80) return(-1);	/* Validate arguments. */   9     if (!s_pkt) {			/* Allocate packet info structures */ H 	if (!(s_pkt = (struct pktinfo *) malloc(sizeof(struct pktinfo)*MAXWS)))* 	  fatal("ini_pkts: no memory for s_pkt");     }      for (x = 0; x < MAXWS; x++) 9       s_pkt[x].pk_adr = NULL;		/* Initialize addresses */        if (!r_pkt) { H 	if (!(r_pkt = (struct pktinfo *) malloc(sizeof(struct pktinfo)*MAXWS)))* 	  fatal("ini_pkts: no memory for s_pkt");     }      for (x = 0; x < MAXWS; x++) 9       r_pkt[x].pk_adr = NULL;		/* Initialize addresses */   1     if (!srvcmd) {			/* Allocate srvcmd buffer */ # 	srvcmd = (CHAR *) malloc(r + 100);  	if (!srvcmd) return(-1);  	*srvcmd = NUL;      } 1     if (!pktmsg) {			/* Allocate pktmsg buffer */  	pktmsg = (CHAR *) malloc(81); 	if (!pktmsg) return(-1);  	*pktmsg = NUL;      }   9     if (bigbufp) {			/* Free previous buffers, if any. */  	free(bigbufp);  	bigbufp = NULL;     } @     size = s + r + 40;			/* Combined requested size + padding */*     z  = (unsigned) s + (unsigned) r + 40;)     debug(F101,"inibufs size 1","",size); &     debug(F101,"inibufs size z","",z);     if ((long) size != z) { % 	debug(F100,"inibufs overflow","",0);  	size = 65535;     }	  K     /* Try to get the space.  If malloc fails, try to get a little less. */ 5     /* (Obviously, this algorithm can be refined.) */   0     while (!(bigbufp = (CHAR *) malloc(size))) {4 	debug(F101,"inibufs bigbuf malloc failed","",size);7 	size = (size * 2) / 3;		/* Failed, cut size by 1/3. */ 3 	if (size < 200)			/* Try again until too small. */  	  return(-1);     } F     debug(F101,"inibufs size 2","",size); /* OK, we got some space. */   /*L   Now divide the allocated space between the send and receive buffers in theJ   requested proportion.  The natural formula would be (s / (s + r)) * sizeM   (for the send buffer), but that doesn't work with integer arithmetic and we L   can't use floating point because some machines don't have it.  This can beL   rearranged as (s * size) / (s + r).  But (s * size) can be VERY large, tooI   large for 32 bits.  So let's do it this way.  This arithmetic works for %   buffer sizes up to about 5,000,000.  */ #define FACTOR 20L8     z = ( (long) s * FACTOR ) / ( (long) s + (long) r );)     x = ( z * ( (long) size / FACTOR ) ); 0     if (x < 0) return(-1);		/* Catch overflow */  1     bigsbsiz = x - 5;			/* Size of send buffer */ 5     bigsbuf = bigbufp;			/* Address of send buffer */ /     debug(F101,"inibufs bigsbsiz","",bigsbsiz);   :     bigrbsiz = size - x - 5;		/* Size of receive buffer */<     bigrbuf = bigbufp + x;		/* Addresss of receive buffer *//     debug(F101,"inibufs bigrbsiz","",bigrbsiz);        return(0);				/* Success */ % #else					/* No dynamic allocation */ 2     bigsbsiz = SBSIZ;			/* Just use the symbols */!     bigrbsiz = RBSIZ;			/* ... */       return(0);				/* Success. */ #endif /* DYNAMIC */ }     9 /* M A K E B U F  --  Makes and clears a new buffers.  */    /* Call with: */6 /*  slots:  number of buffer slots to make, 1 to 32 */% /*  bufsiz: size of the big buffer */ ( /*  buf:    address of the big buffer */G /*  xx:     pointer to array of pktinfo structures for these buffers */   5 /* Subdivides the big buffer into "slots" buffers. */    /* Returns: */5 /*  -1 if too many or too few slots requested,     */ + /*  -2 if slots would be too small.      */ 5 /*   n (positive) on success = size of one buffer. */ C /*   with pktinfo structure initialized for this set of buffers. */    int  makebuf(slots,bufsiz,buf,xx)B /* makebuf */ int slots, bufsiz; CHAR buf[]; struct pktinfo *xx; {       CHAR *a;     int i, size;  #     debug(F101,"makebuf","",slots); +     debug(F101,"makebuf bufsiz","",bufsiz); )     debug(F101,"makebuf MAXWS","",MAXWS);   /     if (slots > MAXWS || slots < 1) return(-1); )     if (bufsiz < slots * 10 ) return(-2);   ;     size = bufsiz / slots;		/* Divide up the big buffer. */ -     a = buf;				/* Address of first piece. */   !     for (i = 0; i < slots; i++) {  	struct pktinfo *x = &xx[i];. 	x->bf_adr = a;			/* Address of this buffer *// 	x->bf_len = size;		/* Length of this buffer */ , 	x->pk_len = 0;			/* Length of data field */+         x->pk_typ = ' ';		/* packet type */ / 	x->pk_seq = -1;			/* packet sequence number */ (         x->pk_flg = 0;			/* ack'd bit */.         x->pk_rtr = 0;			/* retransmissions */$ 	*a = '\0';			/* Clear the buffer */0 	a += size;			/* Position to next buffer slot */     }      return(size);  }   7 /*  M A K S B U F  --  Makes the send-packet buffer  */    int  mksbuf(slots) int slots; {
     int i, x;      sbufnum = 0;:     if ((x = makebuf(slots,bigsbsiz,bigsbuf,s_pkt)) < 0) {* 	debug(F101,"mksbuf makebuf return","",x); 	return(x);      } -     debug(F101,"mksbuf makebuf return","",x); A     for (i = 0; i < 64; i++) {		/* Initialize sequence-number- */ 0 	sseqtbl[i] = -1;		/* to-buffer-number table. */         sacktbl[i] = 0;      }      for (i = 0; i < MAXWS; i++) 6       sbufuse[i] = 0;			/* Mark each buffer as free */     sbufnum = slots;
     wcur = 0;      return(x); }   : /*  M A K R B U F  --  Makes the receive-packet buffer  */   int  mkrbuf(slots) int slots; {
     int i, x;      rbufnum = 0;:     if ((x = makebuf(slots,bigrbsiz,bigrbuf,r_pkt)) < 0) {* 	debug(F101,"mkrbuf makebuf return","",x); 	return(x);      } -     debug(F101,"mkrbuf makebuf return","",x); A     for (i = 0; i < 64; i++) {		/* Initialize sequence-number- */ 0 	rseqtbl[i] = -1;		/* to-buffer-number table. */     }      for (i = 0; i < MAXWS; i++) 6       rbufuse[i] = 0;			/* Mark each buffer as free */     rbufnum = slots;
     wcur = 0;      return(x); }   / /*  W I N D O W  --  Resize the window to n  */    int  window(n) int n; {     debug(F101,"window","",n);'     if (n < 1 || n > MAXWS) return(-1); "     if (mksbuf(n) < 0) return(-1);"     if (mkrbuf(n) < 0) return(-1);     wslots = n;  #ifdef DEBUG     if (deblog) dumpsbuf();      if (deblog) dumprbuf();  #endif /* DEBUG */     return(0); }   2 /*  G E T S B U F  --  Allocate a send-buffer.  */  ? /*  Call with packet sequence number to allocate buffer for. */  /*  Returns: */ @ /*   -4 if argument is invalid (negative, or greater than 63) */L /*   -3 if buffers were thought to be available but really weren't (bug!) */; /*   -2 if the number of free buffers is negative (bug!) */  /*   -1 if no free buffers. */L /*   0 or positive, packet sequence number, with buffer allocated for it. */   int 2 getsbuf(n) int n; {			/* Allocate a send-buffer */
     int i;     if (n < 0 || n > 63) {$ 	debug(F101,"getsbuf bad arg","",n); 	return(-4);	/* Bad argument */      } '     debug(F101,"getsbuf, packet","",n); .     debug(F101,"getsbuf, sbufnum","",sbufnum);8     if (sbufnum == 0) return(-1);	/* No free buffers. */8     if (sbufnum < 0) return(-2);	/* Shouldn't happen. */E     for (i = 0; i < wslots; i++)	/* Find the first one not in use. */ ,       if (sbufuse[i] == 0) {		/* Got one? */, 	  sbufuse[i] = 1;		/* Mark it as in use. */+ 	  sbufnum--;			/* One less free buffer. */ < 	  *s_pkt[i].bf_adr = '\0';	/* Zero the buffer data field */9 	  s_pkt[i].pk_seq = n;		/* Put in the sequence number */ B           sseqtbl[n] = i;		/* Back pointer from sequence number */)           sacktbl[n] = 0;		/* ACK flag */ : 	  s_pkt[i].pk_len = 0;		/* Data field length now zero. */: 	  s_pkt[i].pk_typ = ' ';	/* Blank the packet type too. */- 	  s_pkt[i].pk_flg = 0;		/* Zero the flags */ < 	  s_pkt[i].pk_rtr = 0;		/* Zero the retransmission count */? 	  data = s_pkt[i].bf_adr + 7;	/* Set global "data" address. */ 3 	  if ((what & (W_SEND|W_REMO)) && (++wcur > wmax)) ( 	    wmax = wcur;		/* For statistics. */' 	  return(n);			/* Return its index. */        } )     sbufnum = 0;			/* Didn't find one. */ *     return(-3);				/* Shouldn't happen! */ }    int . getrbuf() {				/* Allocate a receive buffer */
     int i;-     debug(F101,"getrbuf rbufnum","",rbufnum); +     debug(F101,"getrbuf wslots","",wslots); +     debug(F101,"getrbuf dum002","",dum002); +     debug(F101,"getrbuf dum003","",dum003); 8     if (rbufnum == 0) return(-1);	/* No free buffers. */8     if (rbufnum < 0) return(-2);	/* Shouldn't happen. */E     for (i = 0; i < wslots; i++)	/* Find the first one not in use. */ ,       if (rbufuse[i] == 0) {		/* Got one? */, 	  rbufuse[i] = 1;		/* Mark it as in use. */< 	  *r_pkt[i].bf_adr = '\0';	/* Zero the buffer data field */+ 	  rbufnum--;			/* One less free buffer. */ 0 	  debug(F101,"getrbuf new rbufnum","",rbufnum);* 	  if ((what & W_RECV) && (++wcur > wmax))( 	    wmax = wcur;		/* For statistics. */' 	  return(i);			/* Return its index. */        } &     debug(F101,"getrbuf foulup","",i);)     rbufnum = 0;			/* Didn't find one. */ *     return(-3);				/* Shouldn't happen! */ }   M /*  F R E E S B U F  --  Free send-buffer for given packet sequence number */    /*  Returns:  */ /*   1 upon success  */ , /*  -1 if specified buffer does not exist */   int > freesbuf(n) int n; {			/* Release send-buffer for packet n. */
     int i;        debug(F101,"freesbuf","",n);/     if (n < 0 || n > 63)		/* No such packet. */        return(-1); 7     i = sseqtbl[n];			/* Get the window slot number. */       if (i > -1 && i <= wslots) {5 	sseqtbl[n] = -1;		/* If valid, remove from seqtbl */ 3  	sbufnum++;			/* and count one more free buffer */ - 	sbufuse[i] = 0;			/* and mark it as free, */ 9 	if (what & (W_SEND|W_REMO))	/* decrement active slots */ . 	  wcur--;			/* for statistics and display. */     } else {) 	debug(F101," sseqtbl[n]","",sseqtbl[n]);  	return(-1);     }   C /* The following is done only so dumped buffers will look right. */        if (1) {: 	*s_pkt[i].bf_adr = '\0';	/* Zero the buffer data field */< 	s_pkt[i].pk_seq = -1;		/* Invalidate the sequence number */8 	s_pkt[i].pk_len = 0;		/* Data field length now zero. */9 	s_pkt[i].pk_typ = ' ';		/* Blank the packet type too. */ . 	s_pkt[i].pk_flg = 0;		/* And zero the flag */3 	s_pkt[i].pk_rtr = 0;		/* And the retries field. */      }      return(1); }    int = freerbuf(i) int i; {			/* Release receive-buffer slot "i". */ 
     int n;  F /* NOTE !! Currently, this function frees the indicated buffer, but */H /* does NOT erase the data.  The program counts on this.  Will find a */ /* better way later.... */  &     debug(F101,"freerbuf, slot","",i);4     if (i < 0 || i >= wslots) {		/* No such slot. */* 	debug(F101,"freerbuf no such slot","",i); 	return(-1);     } >     n = r_pkt[i].pk_seq;		/* Get the packet sequence number */(     debug(F101,"freerbuf, packet","",n);=     if (n > -1 && n < 64)		/* If valid, remove from seqtbl */        rseqtbl[n] = -1;6     if (rbufuse[i] != 0) {		/* If really allocated, */) 	rbufuse[i] = 0;			/* mark it as free, */ 3 	rbufnum++;			/* and count one more free buffer. */m6 	if (what & W_RECV)		/* Keep track of current slots */. 	  wcur--;			/*  for statistics and display */0 	debug(F101,"freerbuf, new rbufnum","",rbufnum);     }U  C /* The following is done only so dumped buffers will look right. */C       if (1) {D      /* *r_pkt[i].bf_adr = '\0'; */	/* Zero the buffer data field */2 	r_pkt[i].pk_seq = -1;		/* And from packet list */8 	r_pkt[i].pk_len = 0;		/* Data field length now zero. */9 	r_pkt[i].pk_typ = ' ';		/* Blank the packet type too. */d. 	r_pkt[i].pk_flg = 0;		/* And zero the flag */3 	r_pkt[i].pk_rtr = 0;		/* And the retries field. */n     }s     return(1); }e  M /* This is like freerbuf, except it's called with a packet sequence number */ ( /* rather than a packet buffer index. */   VOID freerpkt(seq) int seq; {
     int k;&     debug(F101,"freerpkt seq","",seq);     k = rseqtbl[seq];u"     debug(F101,"freerpkt k","",k);     if (k > -1) {n 	k = freerbuf(k);/& 	debug(F101,"freerpkt freerbuf","",k);     }t }k    7 /*  C H K W I N  --  Check if packet n is in window. */    /*  Returns: */ + /*    0 if it is in the current window,  */ K /*   +1 if it would have been in previous window (e.g. if ack was lost), */x: /*   -1 if it is outside any window (protocol error),   */E /*   -2 if either of the argument packet numbers is out of range.  */E  J /* Call with packet number to check (n), lowest packet number in window */7 /* (bottom), and number of slots in window (slots).  */f   int . chkwin(n,bottom,slots) int n, bottom, slots; {     int top, prev;  %     debug(F101,"chkwin packet","",n); )     debug(F101,"chkwin winlo","",bottom);f(     debug(F101,"chkwin slots","",slots);  J /* First do the easy and common cases, where the windows are not split. */  5     if (n < 0 || n > 63 || bottom < 0 || bottom > 63)        return(-2);,  <     if (n == bottom) return(0);		/* In a perfect world... */  6     top = bottom + slots;		/* Calculate window top. */+     if (top < 64 && n < top && n >= bottom) +       return(0);			/* In current window. */e  <     prev = bottom - slots;		/* Bottom of previous window. */,     if (prev > -1 && n < bottom && n > prev)%       return(1);			/* In previous. */,  > /* Now consider the case where the current window is split. */  )     if (top > 63) {			/* Wraparound... */x1 	top -= 64;			/* Get modulo-64 sequence number */T 	if (n < top || n >= bottom) {* 	    return(0);			/* In current window. */( 	} else {			/* Not in current window. */G 	    if (n < bottom && n >= prev) /* Previous window can't be split. */+, 	      return(1);		/* In previous window. */	 	    else 1 	      return(-1);		/* Not in previous window. */i 	}     }s  K /* Now the case where current window not split, but previous window is. */ o  5     if (prev < 0) {			/* Is previous window split? */c 	prev += 64;			/* Yes. */  	if (n < bottom || n >= prev)T) 	  return(1);			/* In previous window. */*0     } else {				/* Previous window not split. */ 	if (n < bottom && n >= prev) ) 	  return(1);			/* In previous window. */a     }t     G /* It's not in the current window, and not in the previous window... */t  3     return(-1);				/* So it's not in any window. *// }O   int/' dumpsbuf() {				/* Dump send-buffers */e #ifdef DEBUG$     int j, x;				/* to debug log. */       if (! deblog) return(0);'     x = zsoutl(ZDFILE,"SEND BUFFERS:");f     if (x < 0) { 	deblog = 0; 	return(0);      } N     x=zsoutl(ZDFILE,"buffer inuse address length data type seq flag retries");     if (x < 0) { 	deblog = 0; 	return(0);2     } $     for ( j = 0; j < wslots; j++ ) {/ 	sprintf(xbuf,"%4d%6d%10d%5d%6d%4c%5d%5d%6d\n",/
 	       j, 	       sbufuse[j],  	       s_pkt[j].bf_adr, u 	       s_pkt[j].bf_len, 	       s_pkt[j].pk_len, 	       s_pkt[j].pk_typ, 	       s_pkt[j].pk_seq, 	       s_pkt[j].pk_flg, 	       s_pkt[j].pk_rtre
 	       ); 	if (zsout(ZDFILE,xbuf) < 0)  {  	    deblog = 0; 	    return(0);t 	} 	if (s_pkt[j].pk_adr) {*/ 	    x = (int)strlen((char *) s_pkt[j].pk_adr);r 	    if (x)	H 	      sprintf(xbuf,"[%.72s%s]\n",s_pkt[j].pk_adr, x > 72 ? "..." : "");	 	    else0* 	      sprintf(xbuf,"[(empty string)]\n");	 	} else {i( 	    sprintf(xbuf,"[(null pointer)]\n"); 	} 	if (zsout(ZDFILE,xbuf) < 0) { 	    deblog = 0; 	    return(0);i 	}     }	:     sprintf(xbuf,"free: %d, winlo: %d\n", sbufnum, winlo);!     if (zsout(ZDFILE,xbuf) < 0) {g 	deblog = 0; 	return(0);g     }H #endif /* DEBUG */     return(0); }e inta* dumprbuf() {				/* Dump receive-buffers */ #ifdef DEBUG
     int j, x;      if (! deblog) return(0);0     if (zsoutl(ZDFILE,"RECEIVE BUFFERS:") < 0) { 	deblog = 0; 	return(0);u     }*N     x=zsoutl(ZDFILE,"buffer inuse address length data type seq flag retries");     if (x < 0) { 	deblog = 0; 	return(0);d     }e$     for ( j = 0; j < wslots; j++ ) {/ 	sprintf(xbuf,"%4d%6d%10d%5d%6d%4c%5d%5d%6d\n",e
 	       j, 	       rbufuse[j],  	       r_pkt[j].bf_adr, e 	       r_pkt[j].bf_len, 	       r_pkt[j].pk_len, 	       r_pkt[j].pk_typ, 	       r_pkt[j].pk_seq, 	       r_pkt[j].pk_flg, 	       r_pkt[j].pk_rtr 
 	       ); 	if (zsout(ZDFILE,xbuf) < 0) { 	    deblog = 0; 	    return(0);  	}* 	x = (int)strlen((char *)r_pkt[j].bf_adr);B 	sprintf(xbuf,"[%.72s%s]\n",r_pkt[j].bf_adr, x > 72 ? "..." : ""); 	if (zsout(ZDFILE,xbuf) < 0)  {n 	    deblog = 0; 	    return(0);/ 	}     }o:     sprintf(xbuf,"free: %d, winlo: %d\n", rbufnum, winlo);"     if (zsout(ZDFILE,xbuf) < 0)  { 	deblog = 0; 	return(0);e     }) #endif /* DEBUG */     return(0); }( pM /*** Some misc functions also moved here from the other ckcfn*.c modules ***/*' /*** to even out the module sizes. ***/    /* Attribute Packets. */   /*<   Call with xp == 0 if we're sending a real file (F packet),(   or xp != 0 for screen data (X packet).&   Returns 0 on success, -1 on failure. */ intu+ sattr(xp) int xp; {			/* Send Attributes */A     int i, j, aln;
     char *tp;r     struct zattr x;   F     if (zsattr(&x) < 0) return(-1);	/* Get attributes or die trying */:     if (nxtpkt() < 0) return(-1);	/* Next packet number */3     i = 0;				/* i = Data field character number */ %     if (atsido) {			/* System type */N 	data[i++] = '.';fD 	data[i++] = tochar(x.systemid.len); /*  Copy from attr structure */% 	for (j = 0; j < x.systemid.len; j++)k! 	  data[i++] = x.systemid.val[j];b     }	 #ifdef STRATUS&     if (atcreo) {			/* File creator */ 	data[i++] = '$'; C 	data[i++] = tochar(x.creator.len); /*  Copy from attr structure */ $ 	for (j = 0; j < x.creator.len; j++)  	  data[i++] = x.creator.val[j];     },&     if (atacto) {			/* File account */ 	data[i++] = '%';(C 	data[i++] = tochar(x.account.len); /*  Copy from attr structure */ $ 	for (j = 0; j < x.account.len; j++)#    	  data[i++] = x.account.val[j];      }e,     if (atfrmo) {			/* Packet data format */ 	data[i++] = '/'; A 	data[i++] = tochar(x.recfm.len); /*  Copy from attr structure */i" 	for (j = 0; j < x.recfm.len; j++) 	  data[i++] = x.recfm.val[j];     }  #endif /* STRATUS */#     if (attypo) {			/* File type */  	data[i++] = '"';r 	if (1
 #ifdef VMS? 	binary == XYFT_I || binary == XYFT_L || /* IMAGE or LABELED */e3 	!strncmp(x.recfm.val,"F",1)	/* or RECFM=Fxxxxxx */t #else 0 	binary				/* User said SET FILE TYPE BINARY  */ #endif /* VMS */ 	    ) {				/* Binary */1 	    data[i++] = tochar(2);	/*  Two characters */ * 	    data[i++] = 'B';		/*  B for Binary */> 	    data[i++] = '8';		/*  8-bit bytes (note assumption...) */ #ifdef CK_LABELEDd 	    if (binary != XYFT_LB
 #ifdef VMS 		&& binary != XYFT_Io #endif /* VMS */ 		)  		binary = XYFT_B; #endif /* CK_LABELED */k 	} else {			/* Text */3 	    data[i++] = tochar(3);	/*  Three characters */ = 	    data[i++] = 'A';		/*  A = (extended) ASCII with CRLFs */ 3 	    data[i++] = 'M';		/*  M for carriage return */(, 	    data[i++] = 'J';		/*  J for linefeed */
 #ifdef VMS; 	    binary = XYFT_T;		/* We automatically detected text */f #endif /* VMS */   #ifdef NOCSETS% 	    data[i++] = '*';		/* Encoding */i6 	    data[i++] = tochar(1);	/* Length of value is 1 */( 	    data[i++] = 'A';		/* A for ASCII */ #elseb> 	    if (tcharset == TC_TRANSP) { /* Transfer character set */! 		data[i++] = '*';	/* Encoding */s3 		data[i++] = tochar(1);	/* Length of value is 1 */S$ 		data[i++] = 'A';	/* A for ASCII */
 	    } else {Z$ 		tp = tcsinfo[tcharset].designator;4 		if ((tp != NULL) && (aln = (int)strlen(tp)) > 0) {% 		    data[i++] = '*';	/* Encoding */s< 		    data[i++] = tochar(aln+1); /* Length of designator. */A 		    data[i++] = 'C';           /* Text in specified charset. */u6 		    for (j = 0; j < aln; j++)  /* Copy designator */9 		      data[i++] = *tp++;       /*  Example: *&I6/100 */S 		}i 	    } #endif /* NOCSETS */ 	}     }*B     if ((xp == 0) && (x.length > -1L)) { /* If it's a real file */  D 	if (atdato && (aln = x.date.len) > 0) {	/* Creation date, if any */ 	    data[i++] = '#';o 	    data[i++] = tochar(aln);f 	    for (j = 0; j < aln; j++)! 	      data[i++] = x.date.val[j];u 	} 	if (atleno) {, 	    data[i] = '!';			/* File length in K */2 	    sprintf((char *) &data[i+2],"%ld",x.lengthk);+ 	    aln = (int)strlen((char *)(data+i+2));  	    data[i+1] = tochar(aln);z 	    i += aln + 2;  0 	    data[i] = '1';			/* File length in bytes */1 	    sprintf((char *) &data[i+2],"%ld",x.length);s+ 	    aln = (int)strlen((char *)(data+i+2));b 	    data[i+1] = tochar(aln);e 	    i += aln + 2; 	}2 	if (atblko && fblksiz) {		/* Blocksize, if set */ 	    data[i] = '(';+/ 	    sprintf((char *) &data[i+2],"%d",fblksiz);a+ 	    aln = (int)strlen((char *)(data+i+2));= 	    data[i+1] = tochar(aln);r 	    i += aln + 2; 	}     }t #ifndef NOFRILLSF     if ((rprintf || rmailf) && atdiso) { /* MAIL, or REMOTE PRINT?  */$ 	data[i++] = '+';		/* Disposition */J         data[i++] = tochar((int)strlen(optbuf) + 1); /* Options, if any */
 	if (rprintf)	& 	  data[i++] = 'P';		/* P for Print */ 	elseo% 	  data[i++] = 'M';		/* M for Mail */e3 	for (j = 0; optbuf[j]; j++)	/* Copy any options */s 	  data[i++] = optbuf[j];n     }b #endif /* NOFRILLS */  #ifdef CK_RESEND      if (sendmode == SM_RESEND) {$ 	data[i++] = '+';		/* Disposition */         data[i++] = tochar(1);" 	data[i++] = 'R';		/* is RESEND */     }e #endif /* CK_RESEND */.     data[i++] = '@';			/* End of Attributes */$     data[i++] = SP;			/* Length 0 */:     data[i] = '\0';			/* Make sure it's null-terminated */K     aln = (int)strlen((char *)data);	/* Get overall length of attributes */0  H /* Change this code to break attribute data up into multiple packets! */  8     j = (spsiz < 95) ? (92 - bctl) : (spsiz - 2 - bctl);1     if (aln > j) {			/* Check length of result */;E 	spack('A',pktnum,0,(CHAR *)"");	/* send an empty attribute packet */i; 	debug(F101,"sattr pkt too long","",aln); /* if too long */,$ 	debug(F101,"sattr spsiz","",spsiz);     } else {				/* Otherwise */,7 	spack('A',pktnum,aln,data);	/* send the real thing. */n 	debug(F111,"sattr",data,aln);     }o       return(0); }    static char *refused = "";   static char *reason[] = {[E     "size", "type", "date", "creator", "account", "area", "password",rC     "blocksize", "access", "encoding", "disposition", "protection",t%     "protection", "origin", "format",      "sys-dependent",			/* 0 */     "size",				/* 1 */     "2",				/* 2 */f     "3",				/* 3 */r     "4",				/* 4 */f     "5",				/* 5 */      "6",				/* 6 */d     "7",				/* 7 */l     "8",				/* 8 */      "9",				/* 9 */)     ":",				/* : *//     ";",				/* ; */      "<",				/* < */-     "=",				/* = */f     ">",				/* > */w     "name",				/* ? */     "@"o };5 static int nreason = sizeof(reason) / sizeof(char *);  int rejection = -1;    char *? getreason(s) char *s; {			/* Decode attribute refusal reason */      char c, *p;u?     if (rejection == 1)			/* Kludge for SET FIL COLL DISCARD */*:       return("name");			/* when other Kermit doesn't... */
     p = s;:     if (*p++ != 'N') return("");	/* Should start with N */0     else if ((c = *p) > SP) {		/* get reason, */$ 	rejection = c;			/* remember it, */ 	c -= '!';			/* get offset */ D 	p = ((unsigned int) ((CHAR) c) <= nreason) ? reason[c] : "unknown";     },     return(p); }1   intu> rsattr(s) CHAR *s; {			/* Read response to attribute packet */      debug(F111,"rsattr: ",s,*s);>     if (*s == 'N') {			/* If it's 'N' followed by anything, */E 	refused = getreason((char *)s);	/* they are refusing, get reason. */]" 	debug(F110," refused",refused,0);# 	tlog(F110," refused:",refused,0L); 
 	return(-1);	*     }s #ifdef CK_RESENDA     if (sendmode == SM_RESEND && *s == '1') { /* RESEND length */s 	int n; long z; CHAR *p; 	p = s + 1;e 	n = xunchar(*p++); $ 	debug(F101,"rsattr RESEND n","",n); 	z = 0L;6 	while (n-- > 0)			/* We assume the format is good. */% 	  z = 10L * z + (long) (*p++ - '0');d$ 	debug(F101,"rsattr RESEND z","",z); 	if (z > 0L) sendstart = z; 4 	debug(F101,"rsattr RESEND sendstart","",sendstart); 	if (sendstart > 0L)? 	  if (zfseek(sendstart) < 0)	/* Input file is already open. */] 	    return(0);e #ifdef CK_CURSES 	if (fdispla == XYFD_C)&A 	  screen(SCR_FS,0,fsize,"");	/* Refresh file transfer display */t #endif /* CK_CURSES */     }* #endif /* CK_RESEND */     refused = "";u     return(0); }f  8 long rs_len = 0L;			/* Length of file being resent to */   int N gattr(s, yy) CHAR *s; struct zattr *yy; { /* Read incoming attribute packet */     char c, d;
     char *ff;      int aln, i;r  9 #define ABUFL 40			/* Temporary buffer for conversions */d     char abuf[ABUFL];1* #define FTBUFL 10			/* File type buffer */     static char ftbuf[FTBUFL];, #define DTBUFL 40			/* File creation date */     static char dtbuf[DTBUFL];) #define TSBUFL 10			/* Transfer syntax */t     static char tsbuf[TSBUFL];# #define IDBUFL 10			/* System ID */      static char idbuf[IDBUFL]; #ifndef DYNAMIC_& #define DSBUFL 100			/* Disposition */     static char dsbuf[DSBUFL];6 #define SPBUFL 512			/* System-dependent parameters */     static char spbuf[SPBUFL]; #elseW& #define DSBUFL 100			/* Disposition */     static char *dsbuf = NULL;6 #define SPBUFL 512			/* System-dependent parameters */     static char *spbuf = NULL; #endif /* DYNAMIC */) #define RPBUFL 20			/* Attribute reply *//     static char rpbuf[RPBUFL];  .     char *rp;				/* Pointer to reply buffer */$     int retcode;			/* Return code */  +     d = SP;				/* Initialize disposition */p4     ff = filnam;			/* Filename returned by rcvfil */L     if (fncact == XYFX_R && ofn1x && ofn1) /* But watch out for FC=RENAME */:       ff = ofn1;			/* because we haven't renamed it yet */  - /* Fill in the attributes we have received */]  0     rp = rpbuf;				/* Initialize reply buffer */,     *rp++ = 'N';			/* for negative reply. */     *rp = NUL;0     retcode = 0;			/* Initialize return code. */  0     while (c = *s++) {			/* Get attribute tag */7 	aln = xunchar(*s++);		/* Length of attribute string */ 
 	switch (c) { % 	  case '!':			/* File length in K */s= 	    for (i = 0; (i < aln) && (i < ABUFL); i++) /* Copy it */) 	      abuf[i] = *s++;/ 	    abuf[i] = '\0';		/* Terminate with null */rH 	    if (i < aln) s += (aln - i); /* If field was too long for buffer */6 	    yy->lengthk = atol(abuf);	/* Convert to number */ 	    break;e   	  case '"':			/* file type */0 	    for (i = 0; (i < aln) && (i < FTBUFL); i++); 	      ftbuf[i] = *s++;		/* Copy it into a static string */. 	    ftbuf[i] = '\0';o! 	    if (i < aln) s += (aln - i);	4 	    if (attypi) {		/* TYPE attribute is enabled? *// 		yy->type.val = ftbuf;	/* Pointer to string */e* 		yy->type.len = i;	/* Length of string */( 		debug(F111,"gattr file type",ftbuf,i);' 		debug(F101,"gattr binary","",binary);r 		if (			/* Unknown type? */7 		    (*ftbuf != 'A' && *ftbuf != 'B' && *ftbuf != 'I')  #ifdef CK_LABELEDrF /* ... Or our FILE TYPE is LABELED and the incoming file is text... */5 		    || (binary == XYFT_L && *ftbuf == 'A' && !xflg)( #endif /* CK_LABELED */		    p	 		    ) {G) 		    retcode = -1;	/* Reject the file */( 		    *rp++ = c;4 		    if (!opnerr) tlog(F100," refused: type","",0); 		    break; 		}* /*B   The following code moved here from opena() so we set binary modeH   as soon as requested by the attribute packet.  That way when the firstD   data packet comes, the mode of transfer can be displayed correctly   before opena() is called.- */+ 		if (bsavef) {		/* If somehow file mode */07 		    binary = bsave;	/* was saved but not restored, */f$ 		    bsavef = 0;		/* restore it. */5 		    debug(F101,"gattr restoring binary","",binary);i 		}a@ 		if (yy->type.val[0] == 'A') { /* Check received attributes. */9 		    bsave = binary;	/* ASCII.  Save global file type */ 2 		    bsavef = 1;		/* ( restore it in clsof() ) */6 		    binary = XYFT_T;	/* Set current type to Text. */> 		    debug(F100,"gattr attribute A = text","",binary); /*  */& 		} else if (yy->type.val[0] == 'B') {: 		    bsave = binary;	/* Binary.  Save global file type */ 		    bsavef = 1;  #ifdef CK_LABELEDe 		    if (binary != XYFT_L
 #ifdef VMS- 			&& binary != XYFT_U /* VMS special case */u #endif /* VMS */ 			) #endif /* CK_LABELED */e
 #ifdef MAC5 		    if (binary != XYFT_M) /* If not MacBinary... */f #endif /* MAC */ 		      binary = XYFT_B;9 		    debug(F101,"gattr attribute B = binary","",binary);k 		}i 	    } 	    break;*  ' 	  case '#':			/* File creation date */r0 	    for (i = 0; (i < aln) && (i < DTBUFL); i++); 	      dtbuf[i] = *s++;		/* Copy it into a static string */s! 	    if (i < aln) s += (aln - i);) 	    dtbuf[i] = '\0';e 	    if (atdati) {/ 		yy->date.val = dtbuf;	/* Pointer to string */h* 		yy->date.len = i;	/* Length of string */9 		if (fncact == XYFX_U) {	/* Receiving in update mode? */d4 		    if (zstime(ff,yy,1) > 0) { /* Compare dates */4 			*rp++ = c;	/* Discard if older, reason = date. */1 			if (!opnerr) tlog(F100," refused: date","",0);w( 			retcode = -1;	/* Rejection notice. */ 		    }" 		}				  	    } 	    break;y  $ 	  case '(':			/* File Block Size */= 	    for (i = 0; (i < aln) && (i < ABUFL); i++) /* Copy it */o 	      abuf[i] = *s++;/ 	    abuf[i] = '\0';		/* Terminate with null */p! 	    if (i < aln) s += (aln - i);t 	    if (atblki)8 	      yy->blksize = atol(abuf); /* Convert to number */ 	    break;   / 	  case '*':			/* Encoding (transfer syntax) */r0 	    for (i = 0; (i < aln) && (i < TSBUFL); i++); 	      tsbuf[i] = *s++;		/* Copy it into a static string */u! 	    if (i < aln) s += (aln - i);N 	    tsbuf[i] = '\0';e 	    if (atenci) {3 		yy->encoding.val = tsbuf; /* Pointer to string */.. 		yy->encoding.len = i;	/* Length of string */' 		debug(F101,"gattr encoding",tsbuf,i);{ 		switch (*tsbuf) {* #ifndef NOCSETSw, 		  case 'A':		/* Normal, nothing special */@ 		    tcharset = TC_TRANSP; /* Transparent chars untranslated */ 		    break;, 		  case 'C':		/* Specified character set */& 		    for (i = 0; i < ntcsets; i++) { 5 			if (!strcmp(tcsinfo[i].designator,tsbuf+1)) break;  		    }i3 		    debug(F101,"gattr xfer charset lookup","",i);f9 		    if (i == ntcsets) {	/* If unknown character set, */67 			debug(F110,"gattr: xfer charset unknown",tsbuf+1,0);r/ 			if (!unkcs) {	/* and SET UNKNOWN DISCARD, */	+ 			    retcode = -1; /* reject the file. */b 			    *rp++ = c;  			    if (!opnerr)I3 			      tlog(F100," refused: character set","",0);t 			} 		    } else {5 			tcharset = tcsinfo[i].code; /* if known, use it */	7 			rx = xlr[tcharset][fcharset]; /* xlation function */) 		    }D/ 		    debug(F101,"gattr tcharset","",tcharset);	 		break; #endif /* NOCSETS */' 	      default:			/* Something else. */F5 		debug(F110,"gattr unk encoding attribute",tsbuf,0); & 		if (!unkcs) {		/* If SET UNK DISC */ 		    retcode = -1;s 		    *rp++ = c;8 		    if (!opnerr) tlog(F100," refused: encoding","",0); 		}) 		break; 		}  	    } 	    break;t    	  case '+':			/* Disposition */ #ifdef DYNAMIC 	    if (!dsbuf)) 		if ((dsbuf = malloc(DSBUFL+1)) == NULL)b+ 		    fatal("gtattr: no memory for dsbuf");_ #endif /* DYNAMIC */0 	    for (i = 0; (i < aln) && (i < DSBUFL); i++)= 	      dsbuf[i] = *s++;		/* Copy it into a separate string */  	    dsbuf[i] = '\0';)! 	    if (i < aln) s += (aln - i);( 	    rs_len = 0; 	    if (atdisi) {/ 		yy->disp.val = dsbuf;	/* Pointer to string */ * 		yy->disp.len = i;	/* Length of string */
 		d = *dsbuf;d #ifndef NODISPO  /*I   Define NODISPO to disable receipt of mail or print files and of RESEND.  */ 		if (3 #ifndef datageneral			/* MAIL supported only for */ ( #ifndef OS2				/* UNIX, VMS, and OS-9 */ #ifndef MAC  #ifndef GEMDOS
 #ifndef AMIGAl 		    d != 'M' &&		/* MAIL */  #endif /* AMIGA */ #endif /* GEMDOS */  #endif /* MAC */ #endif /* OS/2 */E #endif /* datageneral */ #ifdef CK_RESEND 		    d != 'R' &&		/* RESEND */  #endif /* CK_RESEND */ 		    d != 'P') {		/* PRINT */ 		    retcode = -1;F 		    *rp++ = c;; 		    if (!opnerr) tlog(F100," refused: disposition","",0);l 		}L- 		if (d == 'R') {		/* File is being resent */a #ifdef CK_RESEND2 		    rs_len = zchki(ff); /* Get length of file */+ 		    debug(F111,"gattr RESEND",ff,rs_len);x
 #ifdef VMS? 		    rs_len &= (long) -512; /* Ensure block boundary if VMS */ < 		    rs_len -= 512;	  /* In case last block not complete */+ 		    debug(F111,"gattr rs_len",ff,rs_len);  #endif /* VMS */# 		    if (rs_len < 0L) rs_len = 0L;_ 		    if (rs_len > 0L) {/ 			fncsav = fncact; /* Save collision action */;* 			fncact = XYFX_A; /* Switch to APPEND */ 		    }t #elsea/ 		    retcode = -1;	/* This shouldn't happen */,4 		    *rp++ = c;		/* 'cause it wasn't negotiated. */6 		    if (!opnerr) tlog(F100," refused: resend","",0); #endif /* CK_RESEND */ 		}: #else  /* NODISPO */ 		retcode = -1;( 		*rp++ = c;2 		if (!opnerr) tlog(F100," refused: resend","",0); #endif /* NODISPO */ 	    } 	    break;m  ' 	  case '.':			/* Sender's system ID */t0 	    for (i = 0; (i < aln) && (i < IDBUFL); i++); 	      idbuf[i] = *s++;		/* Copy it into a static string */w 	    idbuf[i] = '\0';n! 	    if (i < aln) s += (aln - i);x 	    if (atsidi) {3 		yy->systemid.val = idbuf; /* Pointer to string */.. 		yy->systemid.len = i;	/* Length of string */ 	    } 	    break;j  0 	  case '0':			/* System-dependent parameters */ #ifdef DYNAMIC- 	    if (!spbuf && !(spbuf = malloc(SPBUFL))) & 		fatal("gattr: no memory for spbuf"); #endif /* DYNAMIC */0 	    for (i = 0; (i < aln) && (i < SPBUFL); i++); 	      spbuf[i] = *s++;		/* Copy it into a static string */' 	    spbuf[i] = '\0';(! 	    if (i < aln) s += (aln - i);  	    if (atsysi) {3 		yy->sysparam.val = spbuf; /* Pointer to string */s. 		yy->sysparam.len = i;	/* Length of string */ 	    } 	    break;r  ) 	  case '1':			/* File length in bytes */c= 	    for (i = 0; (i < aln) && (i < ABUFL); i++) /* Copy it */  	      abuf[i] = *s++;/ 	    abuf[i] = '\0';		/* Terminate with null */ ! 	    if (i < aln) s += (aln - i); 5 	    yy->length = atol(abuf);	/* Convert to number */ 6 	    debug(F111,"gattr length",abuf,(int) yy->length); 	    break;)   #ifdef STRATUS. 	  case '/':			/* Format of data in packets */A 	    /* We just copy it into the record and let the fio module */() 	    /* figure out what to do with it. */*= 	    for (i = 0; (i < aln) && (i < ABUFL); i++) /* Copy it */v 	      abuf[i] = *s++;/ 	    abuf[i] = '\0';		/* Terminate with null */ 5 	    if (atsysi) {		/* same switch as OS-DEPENDENT */F0 		yy->recfm.val = spbuf;	/* Pointer to string */+ 		yy->recfm.len = i;	/* Length of string */x 	    } 	    break;n #endif /* STRATUS */  % 	  default:			/* Unknown attribute */ ( 	    s += aln;			/* Just skip past it */ 	    break;* 	}     }c  K     /* Check file length now, because we also need to know the file type */ M     /* in case zchkspa() differentiates text and binary (VMS version does) */F  3     if (atleni) {			/* Length attribute enabled? */ @ 	if (yy->length > -1L) {		/* Length-in-bytes attribute rec'd? */7 	    if (!zchkspa(ff,(yy->length))) { /* Check space */c$ 		retcode = -1;		     /* Not enuf */ 		*rp++ = '1';2 		if (!opnerr) tlog(F100," refused: length","",0); 	    }C 	} else if (yy->lengthk > -1L) {	/* Length in K attribute rec'd? */S- 	    if (!zchkspa(ff,(yy->lengthk * 1024))) {t" 		retcode = -1;		/* Check space */ 		*rp++ = '!';2 		if (!opnerr) tlog(F100," refused: length","",0); 	    } 	}     }L9     if (yy->length > -1L) {		/* Remember the file size */I 	fsize = yy->length;		#     } else if (yy->lengthk > -1L) {h 	fsize = yy->lengthk * 1024L;*     } else fsize = -1L;a   #ifdef DEBUG     if (deblog) {u 	sprintf(abuf,"%ld",fsize);;" 	debug(F110,"gattr fsize",abuf,0);     }t #endif /* DEBUG */E     if (retcode == 0) rp = rpbuf;	/* Null reply string if accepted */a,     *rp = '\0';				/* End of reply string */ #ifdef CK_RESEND/     if (d == 'R') {			/* Receiving a RESEND? */C' 	debug(F101,"gattr RESEND","",retcode);.0 	/* We ignore retcodes because this overrides */4 	if (binary != XYFT_B) {		/* Reject if not binary */1 	    retcode = -1;		/* in case type field came *//; 	    strcpy(rpbuf,"N+");		/* after the disposition field */i8 	    debug(F111,"gattr RESEND not binary",rpbuf,binary); 	} else {			/* Binary mode *//( 	    retcode = 0;		/* Accept the file */C 	    sprintf(rpbuf+2,"%ld",rs_len); /* Reply with length of file */d5 	    rpbuf[0] = '1';		/* '1' means Length in Bytes */	D 	    rpbuf[1] = tochar((int)strlen(rpbuf+2)); /* Length of length */1 	    debug(F111,"gattr RESEND OK",rpbuf,retcode);  	}     }+ #endif /* CK_RESEND */N     if (retcode == 0 && discard != 0) {	/* Do we still have a discard flag? */; 	strcpy(rpbuf,"N?");		/* Yes, must be filename collision */n3 	retcode = -1;			/* "?" = name (reply-only code) */e     }i?     yy->reply.val = rpbuf;		/* Add it to attribute structure */ '     yy->reply.len = (int)strlen(rpbuf);h2     if (retcode < 0) {			/* If we are rejecting */2 	discard = 1;			/* remember to discard the file */= 	rejection = rpbuf[1];		/* and use the first reason given. */f     }n-     debug(F111,"gattr return",rpbuf,retcode);R     return(retcode); }'  @ /*  I N I T A T T R  --  Initialize file attribute structure  */   int/  initattr(yy) struct zattr *yy; {#     yy->lengthk = yy->length = -1L;n     yy->type.val = "";     yy->type.len = 0;l     yy->date.val = "";     yy->date.len = 0;o     yy->encoding.val = "";     yy->encoding.len = 0;/     yy->disp.val = "";     yy->disp.len = 0;o     yy->systemid.val = "";     yy->systemid.len = 0;/     yy->sysparam.val = "";     yy->sysparam.len = 0;      yy->creator.val = "";f     yy->creator.len = 0;     yy->account.val = "";t     yy->account.len = 0;     yy->area.val = "";     yy->area.len = 0;*     yy->password.val = "";     yy->password.len = 0;e     yy->blksize = -1L;     yy->access.val = "";     yy->access.len = 0;c     yy->lprotect.val = "";     yy->lprotect.len = 0;/     yy->gprotect.val = "";     yy->gprotect.len = 0;c     yy->recfm.val = "";	     yy->recfm.len = 0;     yy->reply.val = "";,     yy->reply.len = 0;     return(0); }a t= /*  A D E B U -- Write attribute packet info to debug log  */*   intb( adebu(f,zz) char *f; struct zattr *zz; { #ifdef DEBUG     if (deblog == 0) return(0);,4     debug(F110,"Attributes for incoming file ",f,0);4     debug(F101," length in K","",(int) zz->lengthk);7     debug(F111," file type",zz->type.val,zz->type.len);z;     debug(F111," creation date",zz->date.val,zz->date.len);r;     debug(F111," creator",zz->creator.val,zz->creator.len);e;     debug(F111," account",zz->account.val,zz->account.len);p2     debug(F111," area",zz->area.val,zz->area.len);>     debug(F111," password",zz->password.val,zz->password.len);0     debug(F101," blksize","",(int) zz->blksize);8     debug(F111," access",zz->access.val,zz->access.len);>     debug(F111," encoding",zz->encoding.val,zz->encoding.len);9     debug(F111," disposition",zz->disp.val,zz->disp.len); A     debug(F111," lprotection",zz->lprotect.val,zz->lprotect.len);aA     debug(F111," gprotection",zz->gprotect.val,zz->gprotect.len);*>     debug(F111," systemid",zz->systemid.val,zz->systemid.len);5     debug(F111," recfm",zz->recfm.val,zz->recfm.len);*>     debug(F111," sysparam",zz->sysparam.val,zz->sysparam.len);.     debug(F101," length","",(int) zz->length);)     debug(F110," reply",zz->reply.val,0);  #endif /* DEBUG */     return(0); }=  2 /*  O P E N A -- Open a file, with attributes.  */ /*J   This function tries to open a new file to put the arriving data in.  TheH   filename is the one in the srvcmd buffer.  File collision actions are:G   OVERWRITE (the existing file is overwritten), RENAME (the new file is{K   renamed), BACKUP (the existing file is renamed), DISCARD (the new file is/L   refused), UPDATE (the incoming file replaces the existing file only if the+   incoming file has a newer creation date).;  +   Returns 0 on failure, nonzero on success.= */ extern char *rf_err;   intS( opena(f,zz) char *f; struct zattr *zz; {     int x, dispos = 0;5     static struct filinfo fcb;		/* Must be static! */0       debug(F110,"opena f",f,0);+     debug(F101,"opena discard","",discard);o  6     adebu(f,zz);			/* Write attributes to debug log */  2     ffc = 0L;				/* Init file-character counter */  '     /* Set up file control structure */t  '     fcb.bs = fblksiz;			/* Blocksize */p #ifndef NOCSETSy,     fcb.cs = fcharset;			/* Character set */ #elsef&     fcb.cs = 0;				/* Character set */ #endif /* NOCSETS */)     fcb.rl = frecl;			/* Record Length */E+     fcb.fmt = frecfm;			/* Record Format */u(     fcb.org = forg;			/* Organization */-     fcb.cc = fcctrl;			/* Carriage control *//"     fcb.typ = binary;			/* Type */E     fcb.dsp = (fncact == XYFX_A) ? XYFZ_A : XYFZ_N; /* Disposition */ 3     fcb.os_specific = '\0';		/* OS-specific info *// #ifdef CK_LABELEDf6     fcb.lblopts = lf_opts;		/* Labeled file options */ #else	     fcb.lblopts = 0; #endif /* CK_LABELED */T  C     if (zz->disp.len > 0) {		/* Incoming file has a disposition? */t: 	debug(F111,"open disposition",zz->disp.val,zz->disp.len);" 	dispos = (int) (*(zz->disp.val));     }L)     debug(F101,"opena dispos","",dispos);u  ;     if (!dispos) {			         /* No special disposition? */oH 	if (fncact == XYFX_B && ofn1x && ofn2) { /* File collision = BACKUP? */E 	    if (zrename(ofn1,ofn2) < 0) {        /* Rename existing file. */U* 		debug(F110,"opena rename fails",ofn1,0);& 		rf_err = "Can't create backup file"; 		return(0);1 	    } else debug(F110,"opena rename ok",ofn2,0);e 	}9     } else if (dispos == 'R') {		/* Receiving a RESEND */  #ifdef COMMENT@         if (fncact == XYFX_R)		/* and file collision = RENAME */
 	  if (ofn1x); #endif) 	    f = ofn1;			/* use original name. */e     }i0     debug(F111,"opena [file]=mode: ",f,fcb.dsp);<     if (x = openo(f,zz,&fcb)) {		/* Try to open the file. */= 	tlog(F110," local name:",f,0L);	/* OK, open, record name. */h7 	if (binary) {			/* Log file mode in transaction log */h1 	    tlog(F101," mode: binary","",(long) binary);e3 	} else {			/* If text mode, check character set */r$ 	    tlog(F100," mode: text","",0L); #ifndef NOCSETSi@ 	    tlog(F110," file character-set",fcsinfo[fcharset].name,0L); 	    if (tcharset == TC_TRANSP)e9 	      tlog(F110," xfer character-set","transparent",0L);		 	    elsenB 	      tlog(F110," xfer character-set",tcsinfo[tcharset].name,0L); #endif /* NOCSETS */D 	    debug(F111," opena charset",zz->encoding.val,zz->encoding.len); 	}, 	if (fsize > -1L) screen(SCR_FS,0,fsize,"");   #ifdef datageneralO /* Need to turn on multi-tasking console interrupt task here, since multiple *// /* files may be received. */O         if ((local) && (!quiet))        /* Only do this if local & not quiet */aH             consta_mt();                /* Start the asynch read task */ #endif /* datageneral */  +     } else {				/* Did not open file OK. */f #ifdef ATTSV 	extern int errno; #ifdef BSD44 #ifdef __386BSD__r #ifndef NDSYSERRLIST 	extern char *sys_errlist[]; #endif /* NDSYSERRLIST */" #else) #ifndef __bsdi__ #ifndef NDSYSERRLIST( 	extern const char *const sys_errlist[]; #endif /* NDSYSERRLIST */r #endif /* __bsdi__ */P #endif /* __386BSD__ */m	 	char *e; ! 	e = (char *) sys_errlist[errno];T 	screen(SCR_EM,0,0l,e);f #else /* !BSD44 */ #ifndef NDSYSERRLIST 	extern char *sys_errlist[]; #endif /* NDSYSERRLIST */ ( 	screen(SCR_EM,0,0l,sys_errlist[errno]); #endif /* BSD44 */   #else /* !ATTSV */   #ifdef BSD4l #ifndef NDSYSERRLIST 	extern char *sys_errlist[]; #endif /* NDSYSERRLIST */d 	extern int errno;( 	screen(SCR_EM,0,0l,sys_errlist[errno]); #elsee. 	screen(SCR_EM,0,0l,"Can't open output file"); #endif /* BSD4 */) #endif /* ATTSV */  *         tlog(F110,"Failure to open",f,0L);     }a6     return(x);				/* Pass on return code from openo */ }f 0@ /*  C A N N E D  --  Check if current file transfer cancelled */   int) canned(buf) CHAR *buf; {      if (*buf == 'X') cxseen = 1;      if (*buf == 'Z') czseen = 1;+     debug(F101,"canned: cxseen","",cxseen); $     debug(F101," czseen","",czseen);'     return((czseen || cxseen) ? 1 : 0);u }n    6 /*  O P E N I  --  Open an existing file for input  */   intb openi(name) char *name; {      int x, filno;      char *name2;  @     if (memstr) return(1);		/* Just return if file is memory. */       debug(F110,"openi",name,0);a$     debug(F101," sndsrc","",sndsrc);  9     filno = (sndsrc == 0) ? ZSTDIO : ZIFILE;    /* ... */e  (     debug(F101," file number","",filno);  8     if (server && !en_cwd) {		/* If running as server */3 	zstrip(name,&name2);		/* and CWD is disabled... */t. 	if (				/* check if pathname was included. */
 #ifdef VMS 	zchkpath(name)# #else  	strcmp(name,name2)r #endif /* VMS */         ) { 0 	    tlog(F110,name,"authorization failure",0L);7 	    debug(F110," openi authorization failure",name,0);l 	    return(0);b 	} else name = name2;      })?     if (zopeni(filno,name)) {		/* Otherwise, try to open it. */l 	debug(F110," ok",name,0);     	return(1);=#     } else {				/* If not found, */d) 	char xname[100];		/* convert the name */ 1 	zrtol(name,xname);		/* to local form and then */,5 	x = zopeni(filno,xname);	/* try opening it again. */: 	debug(F101," zopeni","",x);	 	if (x) {t 	    debug(F110," ok",xname,0); " 	    return(1);			/* It worked. */         } else { #ifdef COMMENTB 	    screen(SCR_EM,0,0l,"Can't open file");  /* It didn't work. */ #endif /* COMMENT *// 	    tlog(F110,xname,"could not be opened",0L); ) 	    debug(F110," openi failed",xname,0);) 	    return(0);i	         }b     }  }v  2 /*  O P E N O  --  Open a new file for output.  */   static int isopen = 0;   intfG openo(name,zz,fcb) char *name; struct zattr *zz; struct filinfo *fcb; {o     char *name2;  -     if (stdouf)				/* Receiving to stdout? */ (       return(zopeno(ZSTDIO,"",zz,NULL));  %     debug(F110,"openo: name",name,0);t  K     if (cxseen || czseen || discard) {	/* If interrupted, get out before */tD 	debug(F100," open cancelled","",0); /* destroying existing file. */' 	return(1);			/* Pretend to succeed. */	     }a8     if (server && !en_cwd) {		/* If running as server */1 	zstrip(name,&name2);		/* and CWD is disabled, */e@ 	if (strcmp(name,name2)) {	/* check if pathname was included. */0 	    tlog(F110,name,"authorization failure",0L);7 	    debug(F110," openo authorization failure",name,0);f 	    return(0);	 	} else name = name2;      }6  E     if (zopeno(ZOFILE,name,zz,fcb) == 0) { /* Try to open the file */) 	isopen = 0;# 	debug(F110,"openo failed",name,0);=& 	tlog(F110,"Failure to open",name,0L); 	return(0);      } else { 	isopen = 1;% 	debug(F110,"openo ok, name",name,0);) 	return(1);      }e }   G /*  O P E N T  --  Open the terminal for output, in place of a file  */t   ints opent(zz) struct zattr *zz; {	     ffc = tfc = 0L;1.     if (bsavef) {			/* If somehow file mode */4 	binary = bsave;			/* was saved but not restored, */  	bsavef = 0;			/* restore it. */0 	debug(F101,"opena restoring binary","",binary);     }U     bsave = binary;c     bsavef = 1;      binary = XYFT_T;&     return(zopeno(ZCTERM,"",zz,NULL)); }0  3 /*  C L S I F  --  Close the current input file. */    int/	 clsif() {o     int x = 0; #ifdef datageneralG     if ((local) && (!quiet))    /* Only do this if local & not quiet */eI         if (nfils < 1)          /* More files to send ... leave it on! */<             connoi_mt(); #endif /* datageneral */5     if (memstr) {			/* If input was memory string, */ & 	memstr = 0;			/* indicate no more. */<     } else x = zclose(ZIFILE);		/* else close input file. *//     if (cxseen || czseen)		/* If interrupted */f/       screen(SCR_ST,ST_INT,0l,"");	/* say so */ -     else if (discard)			/* If I'm refusing */p6       screen(SCR_ST,ST_REFU,0l,refused); /* say why */     else {				/* Otherwise */r$ 	fstats();			/* update statistics */: 	screen(SCR_ST,ST_OK,0l,"");	/* and say transfer was OK */     }'#     hcflg = 0;				/* Reset flags *//0     sendstart = 0L;			/* Don't do this again! */ #ifdef COMMENT /*C   This prevents a subsequent call to clsof() from deleting the file    when given the discard flag. */1     *filnam = '\0';			/* and current file name */+ #endif /* COMMENT */     return(x); }f    , /*  C L S O F  --  Close an output file.  */  7 /*  Call with disp != 0 if file is to be discarded.  */lA /*  Returns -1 upon failure to close, 0 or greater on success. */E   intf clsof(disp) int disp; {	
     int x;  %     debug(F101,"clsof disp","",disp);f6     if (bsavef) {			/* If we saved global file type */0 	debug(F101,"clsof restoring binary","",binary);# 	binary = bsave;			/* restore it */f$ 	bsavef = 0;			/* only this once. */     }n>     if (fncsav != -1) {			/* Saved file collision action... */$ 	fncact = fncsav;		/* Restore it. */  	fncsav = -1;			/* Unsave it. */     }* #ifdef datageneralE     if ((local) && (!quiet))		/* Only do this if local & not quiet */(         connoi_mt(); #endif /* datageneral */?     if ((x = zclose(ZOFILE)) < 0) {	/* Try to close the file */() 	tlog(F100,"Failure to close",filnam,0L);r 	screen(SCR_ST,ST_ERR,0l,"");/5     } else if (disp) {			/* Interrupted or refused */ 8 	if (keep == 0) {		/* If not keeping incomplete files */7 	    if (isopen &&		/* AND the file is actually open */a= 		*filnam && (what & W_RECV)) /* AND we're receiving!!!... */ 6 	      zdelet(filnam);		    /* ONLY THEN, delete it */. 	    debug(F100,"Incomplete: discarded","",0);/ 	    tlog(F100," incomplete: discarded","",0L);e" 	    screen(SCR_ST,ST_DISC,0l,"");& 	} else {			/* Keep incomplete copy */ 	    fstats();@ 	    if (!discard) { /* Unless discarding for other reason... */& 		debug(F100,"Incomplete: Kept","",0);' 		tlog(F100," incomplete: kept","",0L);  	    }! 	    screen(SCR_ST,ST_INC,0l,"");  	}1     } else {				/* Nothing wrong, just keep it */ ? 	debug(F100,"Closed","",0);	/* and give comforting messages. */*
 	fstats(); 	screen(SCR_ST,ST_OK,0L,"");     }*     rs_len = 0; 0     isopen = 0;				/* It's not open any more. */9     cxseen = 0;				/* Reset per-file interruption flag */U7     return(x);				/* Send back zclose() return code. */u }]   #ifdef SUNOS4S5a+ tolower(c) char c; { return((c)-'A'+'a'); } + toupper(c) char c; { return((c)-'a'+'A'); }e #endif /* SUNOS4S5 */d  