N /*****************************************************************************  - TAIL - gets the last "n" records from a file.    V2.4 - 09/10/91    Author: 1 D. Shepperd, Atari Games, Corp. shepperd@dms.UUCP   I This software is supplied with no warranties expressed or implied. Use at J your own risk. Neither Atari Games, Corp. nor I can be held liable for anyJ loss of data or productivity as a result of using this program. Should anyK of your users be caught or killed, the secretary will disavow any knowledge H of your actions. This software may be copied in whole or in part without restriction.   To build this program:
 	$ CC TAIL 	$ LINK TAIL  I It was developed with Vax C 3.0 under VMS 5.1-1 although it ought to work I with earlier and later versions of VMS. (The latest version was developed K under VMS 5.4-2 and C 3.0). Since it uses VMS's RMS for file I/O, it is not  the least bit portable.   . To run this program: Create a foreign command:      $ TAIL :== $dev:[dir]TAIL  	 and type:   H    $ TAIL [/number] [/?] [/S] [/F] [/T secs] input_file(s) [output_file]   where:"    [] denotes optional parameters.    /? - prints a help screen. B    /number - indicates the number in decimal of records to output.*    /S - forces TAIL to use the "safe" way.D    /F - monitors the input file and outputs records as they show up.C    /T secs - sets the monitor update rate in seconds (forces a /F).   J The /F option sets a display rate of 5 seconds. The /T option will force aE /F and sets the display rate to the number of seconds specified. Type J <return>  or some other terminator character on the terminal to advance toL the next  file if wildcards are used on input and the /F option is selected.H If  monitoring batch .LOG files, you will probably want to correlate theH monitor  rate with the batch log's SET OUTPUT_RATE parameter (normally 1 minute).  3 You can use "-" in place of "/" to delimit options.   I The defaults applied to the input file spec are "SYS$DISK:[].LOG" and the I output file defaults to SYS$OUTPUT. The input file may contain wildcards, H however, if you use wildcards on the input filename AND supply an outputH file name, only the first file in the wildcard list will be put into the= specified output file. The rest will be output to SYS$OUTPUT.   G The /S can be used to force TAIL to read the file(s) from the beginning K rather than from the end. You would use /S if, for some reason, TAIL screws J up trying to figure out the record structure on variable  length files but for some reason doesn't notice.    Design goal:  H Make a TAIL utility that can very quickly pickup the last n records of aJ batch log file (which tend to be tens of thousands of blocks long for some
 of our jobs).   I How it works (more or less): For fixed length records, TAIL just seeks to L the desired record and dumps the file from there. For stream record formats,F it reads from the end of the file and counts backwards the appropriateG number of terminators, then seeks to that point and dumps the file from I there. For variable and VFC record formats, it has two modes. The default J mode is for it to seek to the end of the file and read backwards trying toH determine record boundaries based upon some reasoning. This will usuallyL work if the records are relatively short and there are few (preferrably  no)J control characters in it. TAIL trys to figure out if it is getting screwedJ up, and sometimes it may, and will fall back to the "safer" mode if so. ItI may not notice, however, so you can force it to use the "safer" mode with C the /S option. The "safer" mode is where it reads the file from the L beginning, recording the record file address (rfa) of each record as it goesI (modulo the number of desired lines). When it reaches the end of file, it I backs up through the rfa table the desired number of lines, seeks to that G point and dumps the file from there. It always uses the "safer" mode on I input files less than 128 blocks in size. In the "safer" mode, it doesn't L use RMS $GET calls for each record. Instead it reads up to 127 blocks of theI file at a time then decodes the record structure within that 64K of data. I This results in a substantially faster access to the end of the file than L would normally be  available with successive $GET calls. Monitor mode startsL the same way, however, once the record structure has been determined it doesJ successive $GET calls  to obtain the records added to the end of the inputD file. Due to a "feature" of RMS, the input file has to be closed andG reopened in order to gain access to data added to the end of an already I opened file. Although this undoubtly adds overhead to the system (closing J and opening the file every few seconds) TAIL maintains the rfa of the lastK record read, so it can seek to that record to get quick access to the "new" # records at the new end of the file.    BUGS:   H Nothing major has cropped up since the image was released in 4/90. SinceJ this  release has so many new features, it has at least an equal number ofE areas of  potential bugdom. Beware. Besides these new features, there I remains the old tried an true (but yet to happen to me) small possibility H that it could seek to a point in a variable length file that RMS doesn'tL like (only while it is NOT using the "safer" mode). This doesn't seem likelyE because I believe that RMS should like whatever record structure TAIL I decodes even if it is not the correct one. Should TAIL seek to a point in K the file that RMS doesn't like, however, one of several things might occur. J Probably RMS will return an "invalid record format" error. There is a slimF chance that RMS might bugcheck which would not be a nice thing to haveJ happen to you and if your SYSGEN option BUGCHECKFATAL=1, your system wouldL crash. If BUGCHECKFATAL=0, your process would be deleted. I suggest you keepJ BUGCHECKFATAL=0 and use some care if TAIL'ing binary files (or chicken out# and always use /S on binary files).   + Does not treat: <dir>file, only: [dir]file.   H This program is getting to damn big and I can't remember how the hell it works.   Areas for improvment:   I Currently the monitor mode does a double read of the tail end of the file L via multiple $GET's. This could be optimized by having the normal block modeF reader start where the last_rfa pointed and doing a normal "safer" wayG search from there. This would result in a performance improvment if the I file grows by at least dozens of records between monitor mode samples. If J the file grows by less then a screen full of records between samples, then4 changing this probably wouldn't make any difference.  > Use async I/O and double buffering during the safe mode reads.I This might speed up the reading a little (might reduce spindle rotational H latency delays). Probably wouldn't make any difference on files accessed via LAVC or DECnet.   B Accept default values via an environment variable or logical name.  M *****************************************************************************   
 Edit History: @ 	091091_DMS v2.4 Added a -f option (monitor) and set the default8    			number of lines to the terminal's page size. Added8    			some additional comments. This release has lots of5    			BIG changes so there's plenty of room for bugs. 4    			And, as luck would have it, plenty were found.  C 	041790_DMS v2.3 Didn't notice the default input file spec had been 5    			changed to *.* from .LOG; so I changed it back.   A 	041490_DMS v2.2 Made it only output a filename if there was more 1    			than 1 input file. Only did highlighting if :    			outputting to tty, made "maxargs" adjust dynamically3 			instead of being #defined. Put in a help screen. * 			Posted this version to usenet 04/14/90.  A 	031290_KAR v2.1 Kjell Arne Rekaa - EB COMDATA, NORWAY: Corrected 4    			minor error: One line less than specified with6    			/n was displayed. Accepts wildcards on filespec.0 		        Filename displayed prior to each file.  > 	021790_DMS v2.0 added the "read backwards" algorithm for both     			stream and variable rfm's.   	010590_DMS v1.0	image release  L ***************************************************************************/     #ifdef __alpha #include <descrip.h> #include <stdio.h> #include <rms.h> #include <dvidef.h>  #include <dcdef.h> #include <iodef.h> #include <msgdef.h>  #include <ssdef.h> char *malloc(),*strrchr();3 int lib$find_file_end(),strncpy(),exit(),realloc(), D         LIB$FIND_FILE(),strlen(),sys$qio(),que_ttiread(),sys$wake(),I         sys$canwak(),sys$read(),calloc(),sys$get(),sys$put(),sys$close(), D         sys$display(),sys$hiber(),sys$schdwk(),do_stream(),do_var(),H         do_fixed(),skip_through(),sys$create(),sys$connect(),sys$open(),B         que_ttiread(),sys$assign(),fgen(),toupper(),sys$getdviw(); #else  #include <descrip.h>, /*#include descrip		/* descriptor details */+ #include stdio			/* for printf and stuff */ - #include rms			/* for the "real" I/O stuff */ / #include dvidef			/* stuff for the GETDVI ss */ % #include dcdef			/* device classes */   #include iodef			/* QIO stuff */% #include msgdef			/* mailbox stuff */ ' #include ssdef			/* completion codes */  #endif, struct FAB inp_fab;		/* Input fab/rab/xab */ struct RAB inp_rab;  struct XABFHC inp_xab;  ) struct FAB out_fab;		/* Output fab/rab */  struct RAB out_rab;   2 typedef struct {		/* define an item list struct */(    short length;		/* length of buffer */     short code;			/* item code */#    void *ptr;			/* ptr to buffer */ ,    void *retlen;		/* ptr to return length */ } Item;   , typedef struct {		/* Genernic IOSB struct */    short status;    short length;    long devdepend; } Iosb;    typedef struct {&    unsigned long block;		/* block # */3    unsigned short offset;	/* offset within block */ -    unsigned short length;	/* record length */  } Rfa;  0 typedef struct {		/* VMS 64 bit quadword time */    long lsb;    long msb;
 } VMSTime;   #ifdef __alpha9 char inp_buf[65536-512]; /* 127 blocks of buffer space */  #else B unsigned char inp_buf[65536-512]; /* 127 blocks of buffer space */ #endifB int the_safe_way=0;		/* If != then read var files front to back */7 int monitor;			/* if != then loop on display of tail */ ( int sec=5;			/* delay time in seconds */: int tti_chan;			/* channel to use to look for stop code */0 char tti_text[8];		/* room for terminal input */. Iosb tti_iosb;			/* IOSB for terminal input */- int tti_class;			/* SYS$INPUT device class */ . int tto_class;			/* SYS$OUTPUT device class */E int tto_page;			/* SYS$OUTPUT page size (if tto_class == DC$_TERM) */ 6 int were_done;			/* if !=, signals monitor complete */6 int last_rfa_blk;		/* saved rfa of last record read */ int last_rfa_off;   G char default_string[] = "SYS$DISK:[].LOG"; /* default input filename */   ? Item tt_dvi[] = {		/* An item list used to get SYS$xxx class */ "    {4,DVI$_DEVCLASS,&tto_class,0},     {4,DVI$_TT_PAGE,&tto_page,0},    {0,0,0,0} };   $DESCRIPTOR(sysin,"SYS$INPUT"); ! $DESCRIPTOR(sysout,"SYS$OUTPUT");   * /* rfa stands for "record file address" */  . Rfa *rfas;			/* ptr to array of rfa structs */7 int record_count=23;		/* number of records to output */ 3 int	maxargs;		/* records size of next_file array */ ? char **next_file;		/* pts to array of char ptrs to filenames */ Y VMSTime delay = {-5*10*1000*1000, /* 64 bit VMS delta time format for monitor timer... */ -    		 -1};		/* ...initialized to 5 seconds */    char *mini_help_msg[] = { B    "TAIL version 2.4, 09/10/91. D. Shepperd, shepperd@dms.UUCP\n",P    "Usage: TAIL [/record_count] [/S] [/F] [/T secs] input_file [output_file]\n",    0 };   char *help_msg[] = {-    "where: \"[]\" indicates optional data\n", ?    " \"/record_count\" is decimal number of records desired\n", 3    " \"/S\" indicates to use the \"safer\" mode\n", ?    " \"/F\" monitor tail end of file (5 second sample rate)\n", J    " \"/T secs\" monitor tail end of file with sample rate of \"secs\"\n",B    " \"input_file\" is the input filename (can have wildcards)\n",I    " \"output_file\" is output filename (bogus if wildcards on input)\n", O    "Note that a \"-\" can be used in place of the \"/\" to delimit options.\n", R    "White space is required between all arguments (including the /T and secs).\n",J    "Options may appear in any order, but all must preceed filename(s).\n",    0 };     void mini_help() {     char **s;F    for (s=mini_help_msg;*s;++s) fputs(*s,stderr); /* show mini help */
    return; }    void show_help() {     char **s;    mini_help(); I    for (s = help_msg;*s;++s) fputs(*s,stderr);	/* display help message */ 
    return; }    int main(int argc,char *argv[])  { '    int param;			/* Parameter counter */ ,    int err;			/* place to hold rms errors */2    int rfm;			/* loaded with record format code */    int i, files;  1    err = sys$getdviw(0,0,&sysin,&tt_dvi,0,0,0,0);      if ((err&1) == 0) return err;    tti_class = tto_class;   2    err = sys$getdviw(0,0,&sysout,&tt_dvi,0,0,0,0);     if ((err&1) == 0) return err;K    if (tto_class == DC$_TERM) record_count = tto_page > 2 ? tto_page-1 : 2;   9    inp_fab = cc$rms_fab;	/* init the input fab/rab/xab */ 5    inp_fab.fab$b_shr = FAB$M_GET|FAB$M_PUT|FAB$M_UPI; +    inp_fab.fab$b_fac = FAB$M_GET|FAB$M_BRO;     inp_rab = cc$rms_rab;    inp_rab.rab$l_ubf = inp_buf; D    inp_rab.rab$w_usz = sizeof(inp_buf);	/* assume to read the max */    inp_xab = cc$rms_xabfhc; <    inp_rab.rab$l_fab = &inp_fab;	/* tell rab where fab is */D    inp_fab.fab$l_xab = (char *)&inp_xab;	/* tell fab where xab is */D    inp_fab.fab$l_dna = default_string;	/* say input file defaults */0    inp_fab.fab$b_dns = sizeof(default_string)-1;  .    param = 1;			/* start looking at argv[1] */&    --argc;			/* skip the image name */1    while(1) {			/* get all the command options */        char c,*s;       if (argc < 1) break;       s = argv[param];       c = *s++; !       if (c == '/' || c == '-') {  	 c = *s++;  	 c = toupper(c);  	 switch (c) { 	    int secs; 	    case '?': 	    case 'H': 	       show_help(); 	       return 0x10000003;  	    case 'S':		/* safer mode */ 	       the_safe_way = 1;  	       break;1 	    case 'T':		/* set monitor rate in seconds */  	       if (*s == 0) { 		  if (--argc < 1) { 6 		     fputs("Missing delay time parameter\n",stderr); 		     mini_help();  		     return 0x10000002;  		  }  		  s = argv[++param];	 	       } D 	       if (sscanf(s,"%d",&secs) != 1 || secs <= 0 || secs > 2000) {; 		  fprintf(stderr,"Invalid delay time parameter: %s\n",s); A 		  fputs("Time value must be between 1 and 2000 secs\n",stderr);  		  mini_help(); 		  return 0x10000002;	 	       } ' 	       delay.lsb = -secs*10*1000*1000; H 	    /* fall through to /F to default to monitor mode if /T specified */& 	    case 'F':		/* set monitor mode */ 	       monitor = 1; 	       break;7 	    default:		/* assume the param is a record count */ @ 	       --s;		/* backup to the first char of the record count */E 	       if (sscanf(s,"%d",&record_count) != 1 || record_count <= 0) { = 		  fprintf(stderr,"Invalid record count parameter: %s\n",s);  		  mini_help(); 		  return 0x10000002;	 	       }   	 }
 	 ++param;	 	 --argc;        } else { 	 break;       }     }E    record_count++; 	/* Fix of wrong record_count. KAR - 6-mar-1990 */     if (argc < 1) {       show_help();       exit(0x10000003);     }M    files = fgen(argv[param], &next_file, &maxargs);	/* deal with wildcards */     if (files < 1) { /       fputs("No input file(s) found\n",stderr);        return 0x10000002;    }    if (monitor) { "       if (tti_class != DC$_TERM) {H 	 fputs("Cannot monitor files if SYS$INPUT is not a terminal\n",stderr); 	 monitor = 0;       } else {) 	 err = sys$assign(&sysin,&tti_chan,0,0);  	 if ((err&1) == 0) { S 	    fputs("Error assigning channel to SYS$INPUT, monitor mode disabled\n",stderr);  	    monitor = 0;  	 } 5 	 que_ttiread();		/* que up a read to the terminal */        }     }     for (i = 0; i < files; i++) {       if (files > 1) { 	 if (tto_class == DC$_TERM) {N 	    printf("\r\n         \033[7m**************** %s ****************\033[0m", 		     next_file[i]); 
 	 } else {8 	    printf("\r\n	**************** %s ****************", 		     next_file[i]);  	 }        } J       inp_fab.fab$l_fna = next_file[i];	/* input filename is next param *//       inp_fab.fab$b_fns = strlen(next_file[i]); .       if (((err=sys$open(&inp_fab))&1) == 0) {- 	 fputs("Error opening input file\n",stderr);h 	 exit(err);       } 1       if (((err=sys$connect(&inp_rab))&1) == 0) {o/ 	 fputs("Error connecting input rab\n",stderr);  	 exit(err);       } +       if (inp_fab.fab$b_org != FAB$C_SEQ) {s 	 char *oldtype="UNKNOWN";; 	 if (inp_fab.fab$b_org == FAB$C_REL) oldtype = "RELATIVE";o: 	 if (inp_fab.fab$b_org == FAB$C_IDX) oldtype = "INDEXED";9 	 if (inp_fab.fab$b_org == FAB$C_HSH) oldtype = "HASHED";i[ 	 fprintf(stderr,"Input file organization is %s. This program only supports SEQUENTIAL.\n",u
 		  oldtype);w 	 exit(0x10000002);d       }rN       if (inp_fab.fab$b_rfm == FAB$C_UDF || inp_fab.fab$b_rfm > FAB$C_STMCR) {K 	 fputs("Input file has undefined or unsupported record format.\n",stderr);o 	 exit(0x10000002);e       }e7       out_fab = cc$rms_fab;			/* init the output fab */ J       out_fab.fab$b_bks = inp_fab.fab$b_bks;	/* make rest same as input */,       out_fab.fab$w_bls = inp_fab.fab$w_bls;,       out_fab.fab$w_deq = inp_fab.fab$w_deq;$       out_fab.fab$b_fac = FAB$M_PUT;,       out_fab.fab$b_fsz = inp_fab.fab$b_fsz;,       out_fab.fab$w_mrs = inp_fab.fab$w_mrs;,       out_fab.fab$b_rat = inp_fab.fab$b_rat;,       out_fab.fab$b_rfm = inp_fab.fab$b_rfm;       out_rab = cc$rms_rab;t@       out_rab.rab$l_fab = &out_fab;		/* tell rab where fab is */       if (--argc >= 1) {H 	 out_fab.fab$l_fna = argv[++param];	/* output filename is next param */       } else {7 	 out_fab.fab$l_fna = "SYS$OUTPUT:";	/* else default */d       }d4       out_fab.fab$b_fns = strlen(out_fab.fab$l_fna);0       if (((err=sys$create(&out_fab))&1) == 0) {. 	 fputs("Error opening output file\n",stderr); 	 exit(err);       }r1       if (((err=sys$connect(&out_rab))&1) == 0) {o0 	 fputs("Error connecting output rab\n",stderr); 	 exit(err);       } 4       rfm = inp_fab.fab$b_rfm;	/* pickup rfm code */A       last_rfa_blk = last_rfa_off = 0;	/* start at top of file */o       were_done = 0;       while (1) {  	 long oldebk;
 	 int oldffb;lE 	 oldebk = inp_xab.xab$l_ebk;	/* remember the old end of file mark */u 	 oldffb = inp_xab.xab$w_ffb;pH 	 if (last_rfa_blk != 0) {		/* if we've already been through the file */B 	    err = skip_through();	/* then just start where we left off */
 	 } else {! 	    switch (inp_fab.fab$b_rfm) {g 	       case FAB$C_FIX:u 		  err = do_fixed();f
 		  break; 	       case FAB$C_VAR:i 		  err = do_var(); 
 		  break; 	       case FAB$C_VFC:u 		  err = do_var(); 
 		  break; 	       case FAB$C_STM:  		  err = do_stream(2);n
 		  break; 	       case FAB$C_STMCR:) 		  err = do_stream(1);o
 		  break; 	       case FAB$C_STMLF:  		  err = do_stream(0);e
 		  break; 	       default: 		  err = 0x10000004;c, 		  fputs("Unknown record format\n",stderr); 		  exit(err); 	    } 	 }p 	 if ((err&1) == 0) {m 	    if (err != RMS$_EOF) {o. 	       fputs("Error reading input\n",stderr); 	       exit(err); 	    } 	 }t( 	 if (!monitor || were_done == 1) break; 	 while (!were_done) { 	    sys$schdwk(0,0,&delay,0); 	    sys$hiber();bK 	    err = sys$display(&inp_fab);	/* see if stuff has been added to file */r 	    if ((err&1) == 0) {P 	       fputs("Error doing $DISPLAY on input, monitor mode cancelled\n",stderr); 	       were_done = 1; 	       break; 	    }F 	    if (inp_xab.xab$l_ebk == oldebk && inp_xab.xab$w_ffb == oldffb) {< 	       continue;			/* eof hasn't moved, continue waiting */ 	    }X    /* This part is goofy. One would think that a simple sys$display would be all that */X    /* should be required, but nooooooo.... DEC has set some internal flags that will  */X    /* not let me read past the old end of file regardless of the fact the the eof has */X    /* moved. What's really goofy is that sys$display notices that the eof has moved   */X    /* but it won't change those internal flags. Closing/reopening the file every few  */J    /* seconds seems like an expensive proposition to me. Grrrr.			      */4 	    err = sys$close(&inp_fab);	/* close the file */ 	    if ((err&1) == 0) {7 	       fputs("Error closing the input file\n",stderr);  	       exit(err); 	    }4 	    err = sys$open(&inp_fab);	/* reopen the file */ 	    if ((err&1) == 0) {9 	       fputs("Error reopening the input file\n",stderr);e 	       exit(err); 	    }9 	    err = sys$connect(&inp_rab);	/* reconnect the rab */r 	    if ((err&1) == 0) {; 	       fputs("Error reconnecting the input rab\n",stderr);a 	       exit(err); 	    } 	    break;f 	 }A       }h       sys$close(&inp_fab);       sys$close(&out_fab);    }     if ((err&1) != 0) return err;#    if (err != RMS$_EOF) return err;d    return SS$_NORMAL;o }a  K /************************************************************************** ?  * do_seqout - sequentially output the data from the input filel  *  * At entry:"  *	rfa_blk - starting block number3  *	rfa_off - offset within block to start of record   * At exit:dK  *	last_rfa_blk and last_rfa_off are set to the rfa of the last record read '  *	input file has been dumped to outputtL  **************************************************************************/  K do_seqout(long rfa_blk,int rfa_off)	/* seek to desired record and output */e {s    int err,skip=0;>    if (rfa_blk == 0) rfa_blk = 1;	/* start at the beginning */X    if (rfa_blk < last_rfa_blk || (rfa_blk == last_rfa_blk && rfa_off <= last_rfa_off)) {C       rfa_blk = last_rfa_blk;			/* seek to record last displayed */n       rfa_off = last_rfa_off;o$       skip = 1;				/* and skip it */    }7    inp_rab.rab$l_rfa0 = rfa_blk;	/* starting block # */ ?    inp_rab.rab$w_rfa4 = rfa_off;	/* byte offset within block */ A    inp_rab.rab$b_rac = RAB$C_RFA;	/* change to RFA access mode */ =    inp_rab.rab$l_bkt = 0;		/* make sure bkt field is clear */f4    inp_rab.rab$l_rhb = inp_buf;		/* init the ptrs */Q    inp_rab.rab$l_ubf = inp_buf + inp_fab.fab$b_fsz; /* in case making VFC file */d    out_rab.rab$l_rhb = inp_buf;t3    out_rab.rab$l_rbf = inp_buf + inp_fab.fab$b_fsz;n
    while(1) { K       last_rfa_blk = inp_rab.rab$l_rfa0;	/* save rfa of last record read */i(       last_rfa_off = inp_rab.rab$w_rfa4;3       err=sys$get(&inp_rab);		/* read the record */n       if ((err&1) == 0) {y 	 if (err != RMS$_EOF) {+ 	    fputs("Error reading input\n",stderr);h 	    exit(err);  	 }a 	 break;       }sJ       inp_rab.rab$b_rac = RAB$C_SEQ;	/* switch back to sequential reads */,       out_rab.rab$w_rsz = inp_rab.rab$w_rsz;8       if (skip == 0) {			/* if not to skip the record */8 	 if (((err=sys$put(&out_rab))&1) == 0) { /* write it */, 	    fputs("Error writing output\n",stderr); 	    exit(err);o 	 }        }e2       skip = 0;				/* at most, we skip 1 record */    }    return err; }E   char end_mark[] = "\n\r\n";   K /***************************************************************************H  * do_stream - figure out the record structure for one of the 3 types of  *		stream files there are.o  * At entry:2  *	type - record type. 0=stmlf, 1=stmcr, 2=stmcrlf  * At exit:AA  *	has called do_seqout with the computed block and offset of the	  *	desired starting record.tL  **************************************************************************/   do_stream(type)d+ int type;	/* 0=stmlf, 1=stmcr, 2=stmcrlf */e { !    unsigned long block,rfa_blk=0;I/    int rcd_num= 0,err,rfa_off,part1=0,end_char;l #ifdef __alpha    char *s;w #else     unsigned char *s; #endif+    inp_rab.rab$l_bkt = inp_xab.xab$l_ebk+1;t    end_char = end_mark[type];c  :    while(1) {				/* as long as there's data in the file */G       if (inp_rab.rab$l_bkt <= 1) {	/* quit if we already read blk 1 */e. 	 rfa_blk = 1;			/* give 'em the whole file */ 	 rfa_off = 0; 	 break;       }e7       block = inp_rab.rab$l_bkt-(inp_rab.rab$w_usz>>9);s\       if (block == 0 || block > inp_rab.rab$l_bkt) block = 1;	/* but can't start before 1 */E       inp_rab.rab$l_bkt = block;	/* rememebr starting block number */_       err = sys$read(&inp_rab);*       if ((err&1) == 0) {* 	 if (err == RMS$_EOF) break;*F 	 fprintf(stderr,"Error (%08X) trying to read %d bytes at block %d\n",  	 	err,inp_rab.rab$w_usz,block); 	 continue;e       }>.       s = inp_rab.rab$l_ubf+inp_rab.rab$w_rsz;         if (part1) { 	 if (*--s == '\r') {n2 	    rfa_blk = block+((s+2)-inp_rab.rab$l_ubf>>9);- 	    rfa_off = ((s+2)-inp_rab.rab$l_ubf)&511;t* 	    if (++rcd_num >= record_count) break; 	 }a 	 ++s;       }g       part1 = 0;&       while (s >= inp_rab.rab$l_ubf) { 	 if (*--s == end_char) {m 	    char *nrp; / 	    nrp = s+1;			/* next record starts here */n( 	    if (type == 2) {		/* if strmcrlf */: 	       if (s <= inp_rab.rab$l_ubf) {	/* if on the cusp */ 		  part1 = 1;		/* defer */s# 		  break;		/* get somemore data */u	 	       }/= 	       if (*--s != '\r') {	/* else if next char is not cr */O* 		  ++s;			/* then this is not a record */
 		  continue; 	 	       }d 	    }0 	    rfa_blk = block+(nrp-inp_rab.rab$l_ubf>>9);+ 	    rfa_off = (nrp-inp_rab.rab$l_ubf)&511; * 	    if (++rcd_num >= record_count) break; 	 }	       }BA       if (rcd_num >= record_count) break;	/* we got everything */B    }%    if (rfa_blk == 0) return RMS$_EOF;t=    return do_seqout(rfa_blk,rfa_off);	/* write out records */n }n  I /************************************************************************;E  * do_varfast. This procedure trys to figure out the record structureeD  * of a variable length file while reading from the end of the file.  *  * At entry:  *	(called by do_var)s  * At exit: A  *	returns a 0 if it couldn't determine a valid record structure.b>  *	called do_seqout with a computed block and offset if it did4  *		successfuly find an appropriate record boundary.(  *	returns with RMS status in all cases.K  *************************************************************************/p   do_varfast() {5!    unsigned long block,rfa_blk=0;a1    int rcd_num= 0,err,rec_len,rfa_off,min_recsiz;*
    union { #ifdef __alpha       char *s;       short *len;        int align; #else        unsigned char *s;i       unsigned short *len;       unsigned int align;e #endif    } rp;  +    inp_rab.rab$l_bkt = inp_xab.xab$l_ebk+1;     rec_len = 0;t"    min_recsiz = inp_fab.fab$b_fsz;E    inp_rab.rab$w_usz = ((inp_xab.xab$w_lrl+3)*record_count+511)&~511;/  
    while(1) {	L       if (inp_rab.rab$l_bkt <= 1) break; /* quit if we already read blk 1 */7       block = inp_rab.rab$l_bkt-(inp_rab.rab$w_usz>>9);=\       if (block == 0 || block > inp_rab.rab$l_bkt) block = 1;	/* but can't start before 1 */E       inp_rab.rab$l_bkt = block;	/* remember starting block number */r       err = sys$read(&inp_rab);a       if ((err&1) == 0) {t 	 if (err == RMS$_EOF) break;tQ 	 fprintf(stderr,"Error (%08X) trying to read %d bytes at block %d, record %d\n",A( 	 	err,inp_rab.rab$w_usz,block,rcd_num); 	 continue;,       }T1       rp.s = inp_rab.rab$l_ubf+inp_rab.rab$w_rsz;s?       if ((rp.align&1) == 1) ++rp.align;	/* ffb must be even */y  J /*************************************************************************P  * The following procedure loops through the buffer picking up pairs of bytes (aM  * short) on even byte boundaries from the end. If this pair of bytes forms aiQ  * integer whose value points within 1 of the the next record or the current eof,5M  * then the pair is assumed to be the count field of a valid record and is soSQ  * recorded. It can easily get screwed up if there is binary data in the records, N  * but for ascii files such as log files, it ought to work well enough most ofQ  * the time. The integer value represents the length of the record. If this value I  * is greater than the maxium record length recorded for the file (in the/Q  * XAB$W_LRL field of the XABFHC), then this routine assumes to have gotten lost,t  * so it rolls over and dies.eK  *************************************************************************/d         while (1) {_ 	 int len,t; 	 char *tp;b# 	 rp.s -= 2;			/* backup 2 bytes */"C 	 if (rp.s < inp_rab.rab$l_ubf) break;	/* too far, get more data */s 	 len = *rp.len;I 	 if (rec_len >= min_recsiz && 	/* if currently at or greater than min */ 9 	     (len == rec_len ||		/* and lengths match exactly */e-    	      (rec_len > 0 &&		/* or less by 1 */      	       len == rec_len-1))) {K 	    rfa_blk = block+(rp.s-inp_rab.rab$l_ubf>>9); /* remember this point */s, 	    rfa_off = (rp.s-inp_rab.rab$l_ubf)&511; 	    rec_len = 0;m* 	    if (++rcd_num >= record_count) break; 	    continue; 	 }r/ 	 rec_len += 2;			/* increase size of record */ F 	 if (rec_len > inp_xab.xab$w_lrl) return 0; /* we're lost, give up */       } A       if (rcd_num >= record_count) break;	/* we got everything */i    }%    if (rfa_blk == 0) return RMS$_EOF;v=    return do_seqout(rfa_blk,rfa_off);	/* write out records */t }c  I /************************************************************************=G  * skip_through - this routine positions to the desired record begining E  * with a known starting position. It is used in monitor mode to skiprD  * records that may have been added to the input file since the last  * time it was looked at it.  *  * At entry:?  *	last_rfa_blk and last_rfa_off point to the last record read.b  * At exit:s4  *	called do_seqout with a computed block and offsetA  *	last_rfa_blk and last_rfa_off point to a new last record read.w  *	fJ  ************************************************************************/   int skip_through() {=    int err;n-    int first_rfa=0;		/* index to first rfa */b5    int next_rfa=0;		/* index to next available rfa */*  H    if (rfas == (Rfa *)0) rfas = (Rfa *)calloc(record_count,sizeof(Rfa));=    inp_rab.rab$l_rfa0 = last_rfa_blk;	/* where we left off */ %    inp_rab.rab$w_rfa4 = last_rfa_off;rA    inp_rab.rab$b_rac = RAB$C_RFA;	/* change to RFA access mode */ ;    inp_rab.rab$l_bkt = 0;		/* make sure bkt field is off */;4    inp_rab.rab$l_rhb = inp_buf;		/* init the ptrs */Q    inp_rab.rab$l_ubf = inp_buf + inp_fab.fab$b_fsz; /* in case making VFC file */y    while (1) {2       (rfas+next_rfa)->block = inp_rab.rab$l_rfa0;3       (rfas+next_rfa)->offset = inp_rab.rab$w_rfa4;        next_rfa += 1;       next_rfa %= record_count;;"       if (next_rfa == first_rfa) { 	 first_rfa += 1;  	 first_rfa %= record_count;       }        err=sys$get(&inp_rab);       if ((err&1) == 0) {s 	 if (err != RMS$_EOF) {+ 	    fputs("Error reading input\n",stderr);  	    exit(err);  	 }  	 break;       }nD       inp_rab.rab$b_rac = RAB$C_SEQ;	/* switch back to sequential */    }F    return do_seqout((rfas+first_rfa)->block,(rfas+first_rfa)->offset); }   I /************************************************************************dE  * do_var. This procedure positions to the nth record from the end ofeD  * a file by reading the whole file into memory 127 blocks at a timeE  * and skipping through the records recording the block and offset of   * each as it goes.   *  * At entry:  *  * At exit:o6  *	called do_seqout with the computed block and offsetJ  *	last_rfa_blk and last_rfa_off updated to point to the last record read.  *	returns with RMS status.rK  *************************************************************************/g   do_var() {     long block,rcd_num= 0;1    int err; -    int first_rfa=0;		/* index to first rfa */a5    int next_rfa=0;		/* index to next available rfa */  #ifdef __alpha
    char *ebp;  #else"    unsigned char *ebp; #endif
    union {       char *s;       unsigned short *len;       unsigned int align;     } rp;  L /* Unless otherwise indicated, trys to do the fast way first. If that fails,  * it'll do the hard way. */  I    if (the_safe_way == 0 && inp_xab.xab$l_ebk > (inp_rab.rab$w_usz>>9)) {S.       if ((err=do_varfast()) != 0) return err;S       fputs("Unable to determine record structure from backend of file.\n",stderr); :       fputs("Doing it the 'safer' way instead.\n",stderr);G       inp_rab.rab$w_usz = sizeof(inp_buf);	/* assume to read the max */*    }	*    rp.s = inp_rab.rab$l_ubf;    inp_rab.rab$l_bkt = 1;)H    if (rfas == (Rfa *)0) rfas = (Rfa *)calloc(record_count,sizeof(Rfa));
    while(1) {e        block = inp_rab.rab$l_bkt;       err = sys$read(&inp_rab);i8       inp_rab.rab$l_bkt += (inp_rab.rab$w_rsz+511) >> 9;       if ((err&1) == 0) {  	 if (err == RMS$_EOF) break;&Q 	 fprintf(stderr,"Error (%08X) trying to read %d bytes at block %d, record %d\n", ( 	 	err,inp_rab.rab$w_usz,block,rcd_num); 	 continue;p       }r0       ebp = inp_rab.rab$l_ubf+inp_rab.rab$w_rsz;       while (1) {( 	 int len,t; 	 char *tp;S$ 	 if ((rp.align&1) == 1) ++rp.align; 	 if (rp.s >= ebp) { 	    t = rp.s - ebp; 	    inp_rab.rab$l_bkt += t>>9;$& 	    rp.s = inp_rab.rab$l_ubf+(t&511); 	    break;a 	 }$ 	 ++rcd_num; 	 len = *rp.len; 	 if (len > 32767) { 	    if (len == 0xFFFF) {o! 	       rp.s = inp_rab.rab$l_ubf;  	       break;			/* eof */ 	    }a 	    fprintf(stderr,"Warning: Record %d (blk=0x%08X,off=0x%04X): cnt %04X greater than 0x7FFF\n",_P 	 		rcd_num,(rp.s-inp_rab.rab$l_ubf>>9)+block,(rp.s-inp_rab.rab$l_ubf)&511,len); 	 }  	 t = rp.s-inp_rab.rab$l_ubf; , 	 (rfas+next_rfa)->block = block + (t >> 9);$ 	 (rfas+next_rfa)->offset = t & 511;  	 (rfas+next_rfa)->length = len; 	 next_rfa += 1; 	 next_rfa %= record_count;a 	 if (next_rfa == first_rfa) { 	    first_rfa += 1; 	    first_rfa %= record_count;A 	 }U 	 rp.s += len+2;       }     }5    if ((rfas+first_rfa)->block == 0) return RMS$_EOF;_F    return do_seqout((rfas+first_rfa)->block,(rfas+first_rfa)->offset); }   I /************************************************************************ G  * do_fixed. This procedure positions to the nth record from the end ofaC  * a fixed length record file by computing the desired rfa from the D  * required record number, the size of the file and the size of eachF  * record. This is by far the simplest of the three decoding routines.  *  * At entry:  *  * At exit: 6  *	called do_seqout with the computed block and offsetJ  *	last_rfa_blk and last_rfa_off updated to point to the last record read.  *	returns with RMS status.tK  *************************************************************************/i  
 do_fixed() {     int reccnt;    unsigned long size,sbn;    long start,rfa_blk,rfa_off;  K    size = inp_xab.xab$l_ebk*512+inp_xab.xab$w_ffb; /* file size in bytes */p<    reccnt = size/inp_xab.xab$w_mrz;	/* total record count */9    start = reccnt - record_count;	/* starting record # */i;    if (start < 0) start = 0;		/* can't go past beginning */o7    sbn = start*inp_xab.xab$w_mrz;	/* starting byte # */{9    rfa_blk = (sbn >> 9) + 1;		/* starting block number */X/    rfa_off = sbn & 511;			/* offset in block */aW    if (rfa_blk < last_rfa_blk || (rfa_blk == last_rfa_blk && rfa_off < last_rfa_off)) {vL       rfa_blk = last_rfa_blk;		/* don't display records already displayed */F       rfa_off = last_rfa_off+inp_xab.xab$w_mrz; /* advance 1 record */E       if (rfa_off >= 512) {		/* and adjust pointers if appropriate */  	 rfa_off -= 512;  	 rfa_blk += 1;	       }U    }E    return do_seqout(rfa_blk,rfa_off);	/* write the end of the file */  }0  
 int tti_ast()r {     int sts; &    if (tti_iosb.status == SS$_ABORT) {K       return SS$_NORMAL;		/* aborts are ok, since they'll happen at exit */r    }K    if (tti_iosb.status == SS$_NORMAL || tti_iosb.status == SS$_ENDOFFILE) { 3       were_done = 1;			/* signal that we're done */e/       sys$canwak(0,0);			/* cancel our schwk */ 3       sys$wake(0,0);			/* wake up from our hiber */o    } else {n%       if ((tti_iosb.status&1) == 0) { 0 	 fputs("Error reading from maillbox\n",stderr); 	 exit(tti_iosb.status);       }f    }    return que_ttiread(); }s   int que_ttiread()a {n    int sts;     sts = sys$qio(	0,		/* efn */l    			tti_chan,	/* channel */a"    			IO$_READVBLK,	/* function */     			&tti_iosb,	/* iosb addr */    			tti_ast,		/* astadr */    			0,		/* astparam */%    			tti_text,	/* p1 (buffer ptr) */r.    			sizeof(tti_text), /* p2 (buffer size) */$    			0,0,0,0);	/* p3-p6 not used */      if ((sts&1) == 0) {M       fputs("unable to do QIO to SYS$INPUT, monitor mode disabled\n",stderr);n       monitor = 0;    }    return sts; }   H /* ==============================fgen.c============================== */  8 /* #include <rms.h>  ...defined in the program top... */   /*,  * fgen(pattern, result_array, array_length)?  *   fgen generates filenames of files, matching a VMS pattern,/K  *   the results are stored in an array, space for the strings is allocatedg  *   by using malloc.r  * Return values:e  *   -1    : error in patternn  *    0    : no files foundtO  *   n(>0) : number of matching filenames. (Stored in result_array [0] - [n-1])   *L  * Wildcard expansion for VMS is easy;  we just use a run-time library call.  */l   fgen(pat,resarry,len)$ char *pat,**resarry[];	 int *len;& {!5     struct dsc$descriptor_s file_spec, result, deflt;      long context;L"     int count, slen, status, plen;1     char *pp, *rp, result_string[256], *strchr();      char *fnp,**fnpp;a  *     file_spec.dsc$w_length  = strlen(pat);,     file_spec.dsc$b_dtype   = DSC$K_DTYPE_T;,     file_spec.dsc$b_class   = DSC$K_CLASS_S;"     file_spec.dsc$a_pointer = pat;  0     result.dsc$w_length  = sizeof result_string;)     result.dsc$b_dtype   = DSC$K_DTYPE_T;e)     result.dsc$b_class   = DSC$K_CLASS_S;*)     result.dsc$a_pointer = result_string;*  3     deflt.dsc$w_length  = sizeof(default_string)-1;s(     deflt.dsc$b_dtype   = DSC$K_DTYPE_T;(     deflt.dsc$b_class   = DSC$K_CLASS_S;)     deflt.dsc$a_pointer = default_string;b       count = 0;     context = 0;     pp = strrchr(pat, ']');r&     if ( !pp ) pp = strrchr(pat, ':');     if ( !pp ) plen = 0;     else plen = pp - pat + 1;      fnpp = *resarry;J     while ((status = LIB$FIND_FILE(&file_spec, &result, &context, &deflt))O                                                               == RMS$_NORMAL) {* 	if (count >= *len) {c 	    if (*len == 0) *len = 256;c" 	    if (*resarry == (char **)0) {2 		*resarry = (char **)malloc(*len*sizeof(char *));
 	    } else {p5 		*len += *len/2;		/* increase length by 1/2 again */b< 		*resarry = (char **)realloc(*resarry,*len*sizeof(char *)); 	    }" 	    if (*resarry == (char **)0) {, 		perror("Unable to malloc/realloc memory"); 		exit(0x10000004);a 	    } 	    fnpp = *resarry + count;o 	}-         rp = strrchr(result_string, ']') + 1;b         if( !rp )          	rp = result_string;$         slen = strchr(rp, ' ') - rp;4             fnp = *fnpp++ = malloc(slen + plen + 1);         if (plen != 0)$             strncpy(fnp, pat, plen);&         strncpy(fnp + plen, rp, slen);          fnp[slen + plen] = '\0';         ++count;     }a #ifdef DVI$_ALT_HOST_TYPE;>     lib$find_file_end(&context);    /* Only on V4 and later */ #endif&     if (status == RMS$_FNF) return(0);*     if (status == RMS$_NMF) return(count);     return(-1);( })