 /*/         Listen to DECnet MOP SYSTEMID messages    G 	These are broadcast to by all DECnet nodes on a LAN to AB-00-00-02-00  > 	with protocol type 60-02 and contain varying amounts of info.E 	(Usually the LAN interface type and hardware address and a few other  		bits and bobs).   B 	This program interprets any SYSID messages it sees and writes theE 	info to a file. A table of nodes is kept to prevent a node appearing  	in a file more than once.  > 	This program understands DECnet Phase IV SYSID messages only.( 	(MOP V3.0.0 in ETHERNET format frames).  B 	This program uses the famous undocumented NETACP QIO interface toI 	attempt to translate DECnet addresses to names. Apart from that no other B 	undocumented interfaces are used. Privs are required to run this.  9 	This program has been used in the following environments    		VAXC V3.2 VMS VAX V5.5-2.  		DECC V5.0 VMS AXP V6.2 		DECC V6.5 VMS Alpha V7.3-2   	It may work on other versions.   ; 	Any changes or bugs contact me at miller@encompasserve.org     COPYRIGHT NOTICE   5  This software is COPYRIGHT  1996,2005, Ian Miller.    3  Released under licence described in aaareadme.txt      DISCLAIMER   J  This software is provided "AS IS". The author makes no representations orN  warranties with respect to the software and specifically disclaim any impliedE  warranties of merchantability or fitness for any particular purpose.    History	 =======   G 30-nov-1996 I.Miller  V1.0      Created - works for MOP V3 on VAX only. M 10-oct-1996 I.Miller  V1.0-001  Add interpretation of info type 204 based on  >                                 infomation from Galen Tackett.J                                 Tell DECC not to pad structures - now this<                                 program works on AXPVMS too!D 11-OCT-1996 I.Miller  V1.0-002	Add XQA0 etc to ethernet device list.# 				WR90 to comms device name list. D 24-OCT-1996 I.Miller  V1.0-003	Display time in messages to terminal.. 				If node already known don't exit just loop 				to read another message.P 19-OCT-1996 I.Miller  V1.0-004  Add some more Alpha CPU ID (from Galen Tackett).M 05-DEC-1996 I.Miller  V1.0-005	Add display of info types 205,206,207 based on  				info from Galen Tackett./ 				Fix silly bug in code that prevents display  				of nodes more than once.K                                 Split original SYSID.C into seperate files. 2 06-DEC-1996 I.Miller  V1.0-006	Tidy code a little.J 29-JAN-1997 I.Miller  V1.0-007	node table routines moved to LISTEN_TABLE.CL                                 Add protocol and address info to node table.J 04-Feb-1997 I.Miller  V1.0-008	Add IEE 802E MOP support as a build option.1 				i.e. can read ethernet or IEE 802E MOP SYSID   				but not both at same time.2 08-Apr-1997 I.Miller  V1.0-009  Exit on control-C.5 09-apr-1997 I.Miller  V1.0-010  Use save_mop_message. 5 10-Apr-1997 I.Miller  V1.0-011	Update node timestamp. B 04-Jul-2005 I.Miller  V1.0-012	Tidy code a little for new compiler */   #define VERSION "V1.0-012"
 #if __DECC #pragma module SYSID VERSION #else  #module SYSID VERSION  #endif   #define MOPE 0   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <ctype.h> #include <signal.h>    #include <iodef.h> #include <descrip.h> #include <starlet.h>   #include "ethernet.h"  #include "listen_table.h"  #include "listen_subs.h" #include "sysid.h"  
 #if __DECC #pragma member_alignment save  #pragma nomember_alignment #endif   #include "nmadef.h"      #if MOPE
 static struct  { B         unsigned short code0;           /* FMT - frame format   */B         unsigned long format;           /* 802E                 */B         unsigned short code1;           /* PID                  */B         unsigned short pidlen;          /* length of PID        */B         unsigned char pid[5];           /* IEE802E MOP PID      */B         unsigned short code2;           /* MCA - multicast addr */B         unsigned short len;             /* length               */B         unsigned short modifier;        /* modifier - set addr  */B         unsigned char adr[6];           /* MOP multicast addr   */
 } sidparam =   { M  NMA$C_PCLI_FMT,NMA$C_LINFM_802E,                       /* IEE 802E format */ B  NMA$C_PCLI_PID,5,0x08,0x00,0x2b,0x60,0x02,		/* MOP RC PID      */N  NMA$C_PCLI_MCA,8,NMA$C_LINMC_SET,0xAB,00,00,02,00,00};  /* broadcast addr  */   #else   #define MOP_PROTOCOL_TYPE 0x0260  
 static struct  { 2         unsigned short code0;   /* format       */2         unsigned long format;   /* ethernet     */2         unsigned short code1;   /* protocol     */2         unsigned long ptype;    /* MOP RC       */2         unsigned short code2;   /* multicast adr*/2         unsigned short len;     /* value length */2         unsigned short mcaflag; /* set MCA flag */2         unsigned char adr[6];   /* the address  */
 } sidparam =   { M  NMA$C_PCLI_FMT,NMA$C_LINFM_ETH,                        /* Ethernet format */ M  NMA$C_PCLI_PTY,MOP_PROTOCOL_TYPE,                      /* MOP protocol    */ L  NMA$C_PCLI_MCA,8,NMA$C_LINMC_SET,0xAB,00,00,02,00,00, /* broadcast addr  */ }; #endif
 static struct  {          unsigned long len;         void *sidparamptr;- } sidparamdsc = {sizeof(sidparam),&sidparam};   2 /* buffer for recved ethernet frame             */* static unsigned char rcvbuf[NODE_BUFSIZE];2 /* buffer for recived ethernet frame header     */ #if MOPE static FRAME_HEADER_802E hdr;  #else  static FRAME_HEADER_ETH hdr; #endif  
 #if __DECC  #pragma member_alignment restore #endif  S static char *devnames[] = {"ETH","EZA0","ESA0","XQA0","ETA0","XEA0","EXA0","EWA0"}; % static $DESCRIPTOR(devname_dsc,NULL);  #if MOPEL static void save_sysid_msg(unsigned short *timestamp,FRAME_HEADER_802E *hdr,7 	unsigned char *msg,unsigned short len,int node_index);  #else K static void save_sysid_msg(unsigned short *timestamp,FRAME_HEADER_ETH *hdr, 7 	unsigned char *msg,unsigned short len,int node_index);  #endif static void ctrlc(int x);  static int bye;     int main(int argc, char *argv[]) {  	int n;          unsigned long ccode;         unsigned short chan; 	unsigned short iosb[4]; 	char outfile[256];          int tty_output;          FILE *fpOut;         unsigned short now[4];  F         printf("LISTEN_SYSID %s starting at %s\n",VERSION,curtime());	   	tty_output = FALSE; 	/* get name of output file	*/ 	if (argc > 1) 	{ 		strcpy(outfile,argv[1]); 	} 	else  	{% 		printf("Enter output filename : ");  		gets(outfile); 		if (outfile[0] == '\0')  		{ 3 			strcpy(outfile,"TT:");	/* default to terminal */  			tty_output = TRUE;  		}  	}
 	puts(" \n");    	/* open output file		*// 	fpOut = fopen(outfile,"w","rfm=var","rat=cr");  	if (fpOut == NULL)  	{' 		perror("Failed to open output file");  		exit (1);  	}	   *         /* load up the node table       */         read_table(); 
 	bye = FALSE;  	signal(SIGINT,ctrlc);    	/* assign to ethernet device	*/B         for (n = 0; n < sizeof(devnames)/sizeof(devnames[0]); n++)	         { 8                 devname_dsc.dsc$a_pointer = devnames[n];?                 devname_dsc.dsc$w_length = strlen(devnames[n]); =                 ccode = sys$assign(&devname_dsc,&chan,0,0,0);                  if (ccode & 1):                         break;  /* exit loop on success */	         }          if (!(ccode & 1)) 	         { A                 printf("Error 0x%x assigning to device\n",ccode);                  exit(ccode);	         } B         /* start up the channel for listening to SYSID messages */L         ccode = sys$qiow(0,chan,IO$_SETMODE|IO$M_CTRL|IO$M_STARTUP,iosb,0,0,0                         0,&sidparamdsc,0,0,0,0);         if (ccode & 1)                  ccode = iosb[0];         if (!(ccode & 1)) 	         { E                 printf("Error 0x%x (%x,%x,%x,%x) starting channel\n", ?                         ccode,iosb[0],iosb[1],iosb[2],iosb[3]);                  exit(ccode);	         }    	while(!bye) 	{# 	        /* read a sysid message */ 0                 memset(rcvbuf,0,sizeof(rcvbuf));7 	        ccode = sys$qiow(0,chan,IO$_READVBLK,iosb,0,0, % 			rcvbuf,sizeof(rcvbuf),0,0,&hdr,0);  	        if (ccode & 1) ! 	                ccode = iosb[0];  	        if (!(ccode & 1))
 	        {? 	                printf("Error 0x%x (%x,%x) reading message\n",  				ccode,iosb[0],iosb[1]);  	                exit(ccode); 
 	        }&                 sys$gettim(&now);     # 	        /* validate message     */ + 	        if ((hdr.destination[0] & 1) == 1) 
 	        {$ 	                if (rcvbuf[0] == 7) 	                { 				/* its a SYSID message		*/$ 				/* check if this one is known	*/:                                 n = find_node(hdr.source);*                                 if (n < 0)!                                 { B                                         /* its a new one        */A                                         n = add_node(hdr.source); 2                                         if (n < 0)
 				        { 3 				                printf("node table is full\n"); 
 				        } ,                                         else)                                         {  						memcpy(nodes[n].time,now,  							sizeof(nodes[n].time));J                                                 /* save the SYSID msg   */% 						save_sysid_msg(now,&hdr,rcvbuf,  							iosb[1],n);)                                         } < 		                        format_sysid_msg(fpOut,tty_output,E                                                 &hdr,rcvbuf,iosb[1]);  				} $                                 else!                                 { B                                         /* its a known node     */ 					memcpy(nodes[n].time,now, 						sizeof(nodes[n].time)); B                                         /* save the SYSID msg   */$ 					save_sysid_msg(now,&hdr,rcvbuf, 						iosb[1],n); !                                 }  	                } 	                else  	                {A 	                        printf("Message type 0x%x\n",rcvbuf[0]);  	                }
 	        }
 	        else 
 	        {H 	                printf("Desination address not a broadcast address\n");
 	        } 	}! 	write_table();	/* write table */  }    static void  #if MOPES save_sysid_msg(unsigned short *timestamp,FRAME_HEADER_802E *hdr,unsigned char *msg, # 	unsigned short len,int node_index)  #else R save_sysid_msg(unsigned short *timestamp,FRAME_HEADER_ETH *hdr,unsigned char *msg,# 	unsigned short len,int node_index)  #endif {          unsigned short dnet;   	/* add MOP to protocols */  #if MOPE/         add_protocol_802e(node_index,hdr->pid); 8         save_mope_message(node_index,msg,len,timestamp); #else 0 	add_protocol_eth(node_index,MOP_PROTOCOL_TYPE);7         save_mop_message(node_index,msg,len,timestamp);  #endif  6 	if ((hdr->source[0] == 0xAA) && (hdr->source[1] == 0)7 	&&  (hdr->source[2] == 0x04) && (hdr->source[3] == 0))  	{ 		/* add DECnet address   */- 		dnet = hdr->source[4] + hdr->source[5]*256; 2 		add_address(node_index,LT_ADDRESS_DECNET,&dnet); 	} }    static void  ctrlc(int x) {  	signal(SIGINT,ctrlc); 	bye = TRUE; } 