A C**************************************************************** 1 C   Modue Name		Program		Responsible Organization A C---------------------------------------------------------------- 3 C   ETHERNET_MONITOR	ETHERMON	GE-GESD, Syracuse, NY  C  C   Description: C  C   Calling List: 3 C	A list of all units that are called by this unit.  C  C   Inputs:  C	Name		Type			DescriptionA C---------------------------------------------------------------- < C	<user-specified> Ethernet device	the interface device that C						the Ethernet will be  C						monitored from  C  C   Outputs: C	Name		Type			DescriptionA C----------------------------------------------------------------  C	SYS$OUTPUT:	file C 	 C   NOTES  C	Limitations:8 C		This program will only work when the specified device; C		is a DEC-compatible Ethernet interface, although it only 4 C		checks that the device is a serial communications
 C		device. C	Error Handling:  C  C   Revision History:   C	date	version		programmer	SCR #- C	6-6-89	  1A		Andrew Pavlin	Initial turnover 4 C	5-9-90	  2A		Andrew Pavlin	augmentation to resolve" C						user bugs, etc. Itemized as C						follows: 9 C			a) add search capability to find any and all possible 3 C				Ethernet interface devices on the local system 7 C			b) keep track of all protocol types, addresses, and & C				manufacturers used on the network: C			c) sort address, protocol type, and manufacturer lists0 C			d) allow one level of indirect command files4 C			e) size number of receive buffers by BYTLM quota; C			f) autosize DISPLAY command screens per SMG description  C				of output screen 7 C			g) tune accessing of manufacturer and protocol type  C				tables 8 C			h) for addresses and manufacturers, detail reference, C				flags to indicate source or destination8 C			i) fix format problem with large unknown DECnet node C				numbers7 C			j) add more manufacturer codes, optimize display of , C				addresses, protocols, and manufacturers$ C			k) begin adding IEEE 802 support5 C			l) add device name recognition for other sides of 4 C				half-done protocol recognition, add recognition# C				of Bridge and Vitalink bridges 3 C	1-4-91	  2B	Andrew Pavlin	augmentation to resolve ! C					user bugs, etc. Itemized as  C					follows (V2.2): 8 C			a) added more manufacturer prefixes, protocol types,2 C				and multicast addresses per Internet RFC 10605 C			b) completed implementation of IEEE 802.3 support + C			c) added recognition of AppleTalk nodes 5 C			d) added recording of per-address protocol types, 0 C				selective display of enhanced address table5 C			e) fix problem with SUMMARIZE command and DISPLAY * C				command for displaying protocol types C	1-15	  2C	Andrew Pavlin	: C			a) sort hardwired protocols and manufacturer codes for C				more efficient searching 8 C			b) add summarizing over TCP and UDP well-known ports C				in SUMMARIZE INTERNET7 C			c) add dual-mode (Ethernet or IEEE 802.3) operation  C				and PING command  C			d) add parallel tracing 5 C			e) allow multiple ONLY's to be matched in filters & C				for each category (SRC, DST, PRT)< C			f) recognize Ungermann-Bass bridges, DEC DEBNI interface9 C			g) add SHOW PERFORMANCE command for internal analysis / C			h) clean up memory of per-address protocols : C			i) allow filter-free DISPLAY in parallel with filtered C				asynchronous TRACE < C			j) allow symbolic as well as physical Ethernet addresses5 C				for SHOW ADDRESS_NAMES command (DECnet,Internet) 7 C			k) fix bug in LOAD/FILTER for destination addresses ; C			l) add exit handler to properly close down asynchronous  C				TRACE commands 5 C			m) add maximum limit on receive buffer count, add / C				version number display, add missing output - C				reports to SUMMARIZE SIZES and SUMMARIZE  C				STATISTICS 6 C			n) correct some names in protocol and manufacturer2 C				tables, increase number of protocols recorded0 C				per address, add support for SGEC interface3 C				(EZc0:), added /OUTPUT qualifier to SUMMARIZE, 0 C				add some more MOP types, try to fix address  C				assignments for IP gateways7 C			o) recognize IP DNS servers, add /TYPE qualifier to 1 C				SHOW ADDRESS_NAMES command, correct SPAWNing 2 C				problem on systems with enlarged DEFMBXBUFQUO4 C				SYSGEN parameters, fix TRACE/ASCII to recognize4 C				IEEE 802.3 SNAP messages, add logging of filter2 C				adds in LOAD/FILTER command, add SET MESSAGES2 C				and SHOW MESSAGES commands to control display' C				of obnoxious async status messages ? C	5-14-91	  2C1	Andrew Pavlin	account for non-standard names in ( C					VAXCRTL on Internet address calls,, C					improve reporting of multiple IP addrsC C	29-MAY-91 2C2	Andrew Pavlin	fix host file scanning for CMU TCP/IP . C					in LOAD/INTERNET, mark multicast address* C					entries as such in SHOW ADDRESS, add* C					/SORT qualifier to SHOW ADDRESS, add+ C					CLEAR FLAGS command to allow retrying ) C					IP address determination if address . C					table gets screwed up, fix parsing error+ C					for filter ADDRESS=IP-address, detect ( C					garbled IP ARP messages, eliminate, C					storage of illegal IP addresses, clean, C					up PING command, put asynchronous msgs- C					in a controlled window while in DISPLAY . C					mode, fix IEEE mode error in TRACE/ASCIIG C	3-Mar-92  2C3   Andrew Pavlin   fix U-B bridge map analysis code, add : C		(never released)	new Ethernet and FDDI controller names+ C					to auto interface search logic, start + C					handling FDDI peculiarities, clean up , C					protocol table overflow logic, improve) C					unknown port characteristic/counter  C					reporting D C	30-Apr-92 2D	Andrew Pavlin	add "fast" $QIO interface that corrects. C					for VMS V5.4-3+ driver change, add logic, C					to MAP command to pick up "other-side"* C					address of U-B bridges, add symbolic- C					protocol names in command parser, QUERY - C					command added (U-B bridge route table), , C					add recognition of U-B serial numbers ( C					as symbolic Ethernet address, SHOW) C					BRIDGES/MAP plotting command added, + C					attempt to prevent padding from being , C					processed in Ethernet packets received+ C					in IEEE 802.3 extended mode, clean up , C					handling of Apollo DOMAIN ARP queries,- C					improve command syntax error reporting, - C					break up FORTRAN source file for easier * C					e-mail transmittal of product, added- C					support for NRC Fusion to LOAD/INTERNET ) C					command (courtesy of Galen Tackett, - C					DECUServe), add privilege/quota display ) C					to program crash exception handler, . C					clean up TRACE command & add /STATISTICS. C					& /TRUNCATE & /SNIFFER qualifiers to it,- C					correct message loss glitch at start of - C					DISPLAY command, add extra error msg to , C					tell users "RTFM" on FASTSHR failures;- C					remove erroneous code in LAVC analysis, * C					fix privilege restoration problem in) C					SPAWN command, centralize obtaining * C					location of .EXE file, add /ANALYZER, C					function to TRACE command, put address* C					table in global section so /ANALYZER% C					subprocesses can get at it, add ) C					identifying nodes with duplicate IP ) C					addresses, optional flagging of new * C					source nodes, add system/device info. C					to crash dump report, clean up SUMMARIZE+ C					INTERNET command to report meaningful ) C					TCP & UDP port information, correct & C					SUMMARIZE STATISTICS and DISPLAY- C					STATISTICS to ignore "integer overflow" ) C					of unsigned counter values, correct * C					SUMMARIZE STATISTICS averaging, make) C					"rest-of-line" parameters be parsed ( C					more consistently, add DEFINE/KEY,( C					DELETE/KEY, and SHOW KEY commands,+ C					add /MANUFACTURER qualifier to LOAD & , C					SAVE commands, add SET KEYPAD command;( C					fix typo in LOAD/MANUFACTURER, fix. C					MAP command to use Ungermann-Bass bridge. C					path algorithm, add control-C processing. C					to command parser, neaten up "can't make- C					global section" error message, fix typo , C					in SAVE/MANUFACTURER command, clean up- C					flag mask processing in SAVE/ADDRESSES, * C					fix address table scan to also check- C					"other address" field in table, correct * C					bandwidth calculation to account for) C					FDDI and interframe gap, generalize * C					exception handling to use crash-dump) C					handler for non-AST exceptions, add . C					traceback computation (non-symbolic) and+ C					more environmental data to crash dump - C					report, add table overflow checking for . C					manufacturer prefix table in ETHER_READ,' C					add counter saturation checks to  % C					SUMMARIZE and DISPLAY commands; - C					add SYSGEN parameter data to crash dump + C					report, fix TRACE command to properly . C					handle control-C of a synchronous TRACE,- C					enlarge extended characteristics buffer . C					for GET_PORT_STATUS & GET_PORT_COUNTERS,. C					add performance check routine to FASTSHR. C					and FASTCALL (new version of shareable),. C					clean up exception handlers to use param* C					definitions of SS$_ codes instead of, C					external (more compact, faster code in. C					handlers), fix LOAD/FILTER "feature" for- C					address that is last item on line (auto * C					converted to prefix by mistake), use, C					parameters for character array element+ C					lengths in address table COMMON, make . C					control-C logic modular and then disable+ C					control-C traps in SPAWN command, add . C					more version checking to global section,, C					add logic to support creating section  C					w/o using pagefileD C	22-Oct-92 2D1	Andrew Pavlin	fix compile-time subscript range error- C					in SET_MANUFNAM, fix zero-length string ) C					error for filespec in LOAD and SAVE * C					commands, fix control-C trap mask in( C					ENABLE_CONTROL_C_TRAP, fix bug in , C					SET MESSAGE xxx ON command, fix re-use* C					of itemlist array for global section( C					create with explicit mapping file,' C					have control-C abort executing an & C					indirect command file, check for) C					initialization file and open it for . C					command input if one exists, fix command  C					file access to be readonlyA C****************************************************************        PROGRAM ETHERNET_MONITOR C ) CP DATA DECLARATIONS for ETHERNET_MONITOR  C        IMPLICIT NONE  C ! C   declare system symbolic codes  C !       INCLUDE '($DCDEF)		/NOLIST' !       INCLUDE '($DVIDEF)	/NOLIST' !       INCLUDE '($FABDEF)	/NOLIST' "       INCLUDE '($FSCNDEF)	/NOLIST'!       INCLUDE '($IODEF)		/NOLIST' !       INCLUDE '($JPIDEF)	/NOLIST' !       INCLUDE '($PRVDEF)	/NOLIST'        EXTERNAL	RMS$_EOF !       INCLUDE '($SECDEF)	/NOLIST' !       INCLUDE '($SMGDEF)	/NOLIST'        EXTERNAL	SMG$_EOF 9       EXTERNAL	SS$_NORMAL, SS$_NOTNETDEV, SS$_EXGBLPAGFIL  C  C   declare local variables  C        CHARACTER*12 CLV_GSDNAM *       INTEGER*2 NLV_IOSB(0:3), NLV_SECCHAN?       INTEGER*4 ILV_STATUS, ILV_PRVLST(2), ILV_EXITCTLBLK(0:4),       +		ILV_ITMLST(16)        RECORD /FABDEF/ SLV_SECFAB       SAVE ILV_EXITCTLBLK  C  C   declare local COMMON's C        LOGICAL*1 LCV_EXIT        COMMON /LCV_EXIT/ LCV_EXIT       LOGICAL*1 LCV_CMDFIL       COMMON /INPUT/ LCV_CMDFIL !       INCLUDE 'ETHERMON_ADDR.INC'         INCLUDE 'ETHERMON_CMD.INC'        INCLUDE 'ETHERMON_DEV.INC'        INCLUDE 'ETHERMON_ETH.INC'        INCLUDE 'ETHERMON_SMG.INC' C  C   declare local procedures C ;       EXTERNAL	ETHERMON_EXIT_HANDLER, ETHER_READ_EXCPTHDLR,       +		CONTROL_C_TRAP_AST C ( C   declare local symbolic message codes C ,       EXTERNAL	ETH__NOGBLSEC, ETH__CLSINDFIL C  C   declare system procedures  C 4       INTEGER*4 SYS$SETPRV, SYS$DCLEXH, SYS$GETJPIW,:      +		SMG$CREATE_VIRTUAL_KEYBOARD,	SMG$CREATE_KEY_TABLE,<      +		SMG$READ_COMPOSED_LINE, SYS$CRMPSC, SMG$ADD_KEY_DEF,      +		SYS$ASSIGN, SYS$CREATE3       EXTERNAL	SYS$SETPRV, SYS$DCLEXH, SYS$GETJPIW, :      +		SMG$CREATE_VIRTUAL_KEYBOARD,	SMG$CREATE_KEY_TABLE,<      +		SMG$READ_COMPOSED_LINE, SYS$CRMPSC, SMG$ADD_KEY_DEF,      +		SYS$ASSIGN, SYS$CREATE C  CP BEGIN ETHERNET_MONITOR $ CP.  set up default user environment C        LCV_EXIT=.FALSE. C  CP.  enable PHY_IO privilege C -       ILV_PRVLST(1)=PRV$M_PHY_IO+PRV$M_NETMBX        ILV_PRVLST(2)=0 $       ILV_STATUS=SYS$SETPRV(%VAL(1),      +			    ILV_PRVLST,      +			    ,QCVETH_PROCPRIV),       IF(ILV_STATUS.NE.%LOC(SS$_NORMAL))THEN4 	CALL SYS$EXIT(%VAL(IOR(IAND(ILV_STATUS,NOT(7)),4)))       ENDIF  C  CP.  set up exit handler C        ILV_EXITCTLBLK(0)=0 3       ILV_EXITCTLBLK(1)=%LOC(ETHERMON_EXIT_HANDLER)        ILV_EXITCTLBLK(2)=1 /       ILV_EXITCTLBLK(3)=%LOC(ILV_EXITCTLBLK(4)) +       ILV_STATUS=SYS$DCLEXH(ILV_EXITCTLBLK) ,       IF(ILV_STATUS.NE.%LOC(SS$_NORMAL))THEN4 	CALL SYS$EXIT(%VAL(IOR(IAND(ILV_STATUS,NOT(7)),4)))       ENDIF  C L CP.  obtain the directory location of the .EXE file, the process's name, and CP		the process's base priority  C ?       ILV_ITMLST(1)=LEN(CCVNAM_EXEDIR)+JISHFT(JPI$_IMAGNAME,16) '       ILV_ITMLST(2)=%LOC(CCVNAM_EXEDIR) *       ILV_ITMLST(3)=%LOC(NCVNAM_EXEDIRLEN)=       ILV_ITMLST(4)=LEN(CCVNAM_PRCNAM)+JISHFT(JPI$_PRCNAM,16) '       ILV_ITMLST(5)=%LOC(CCVNAM_PRCNAM) *       ILV_ITMLST(6)=%LOC(NCVNAM_PRCNAMLEN)*       ILV_ITMLST(7)=4+JISHFT(JPI$_PRIB,16)%       ILV_ITMLST(8)=%LOC(ICVNAM_PRIB)        ILV_ITMLST(9)=0 H       ILV_ITMLST(10)=4+JISHFT(JPI$_PID,16)	! for global section creation%       ILV_ITMLST(11)=%LOC(ICVNAM_PID)        ILV_ITMLST(12)=0       ILV_ITMLST(13)=06       ILV_STATUS=SYS$GETJPIW(,,,ILV_ITMLST,NLV_IOSB,,)       IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN# 	CALL LIB$SIGNAL(%VAL(NLV_IOSB(0)))        ENDIF )       ILV_ITMLST(1)=JISHFT(FSCN$_NAME,16)        ILV_ITMLST(2)=0        ILV_ITMLST(3)=0 F       CALL SYS$FILESCAN(CCVNAM_EXEDIR(1:NCVNAM_EXEDIRLEN),ILV_ITMLST,)8       NCVNAM_EXEDIRLEN=ILV_ITMLST(2)-%LOC(CCVNAM_EXEDIR) C * CP.  get name of Ethernet interface to use C :       CALL GET_ETHERPORT_NAME(CCVCMD_CMDLIN,NCVCMD_CMDLEN) C % CP.  set up overall exception handler  C .       CALL LIB$ESTABLISH(ETHER_READ_EXCPTHDLR) C H CP.  create global section containing the address name translation table C )       ILV_PRVLST(1)=%LOC(ICVADR_NUMADDRS) /       ILV_PRVLST(2)=%LOC(BCVADR_END_OF_SECTION) 5       CALL SYS$FAOL('ETH_!XL',,CLV_GSDNAM,ICVNAM_PID) !       ILV_ITMLST(10)=SEC$K_MATLEQ &       ILV_ITMLST(11)=ICPADR_SECVERSION*       ILV_ITMLST(12)=((ILV_PRVLST(2)+512)--      +			IAND(ILV_PRVLST(1),'FFFFFE00'X))/512 F       ILV_STATUS=SYS$CRMPSC(ILV_PRVLST,		! specify addresses of table,.      +			    ,			! don't care what got mapped,*      +			    %VAL(3),		! map at user mode,D      +			%VAL(SEC$M_GBL+SEC$M_PAGFIL+SEC$M_WRT+SEC$M_DZRO), ! flags,)      +			    CLV_GSDNAM,		! section name, 2      +			    ILV_ITMLST(10),	! section version ID,&      +			    ,,			! no relpag or chan,0      +			    %VAL(ILV_ITMLST(12)), ! page count,+      +			    ,			! no VBN (no file either), 6      +			    %VAL('FF00'X),	! restrict access to self,      +			    )			! ignore PFC.       IF(.NOT.ILV_STATUS)THEN  	ILV_ITMLST(1)=3" 	ILV_ITMLST(2)=%LOC(ETH__NOGBLSEC) 	ILV_ITMLST(3)=0 	ILV_ITMLST(4)=ILV_STATUS , 	IF(ILV_STATUS.EQ.%LOC(SS$_EXGBLPAGFIL))THEN! 	  SLV_SECFAB.FAB$B_BID=FAB$C_BID ! 	  SLV_SECFAB.FAB$B_BLN=FAB$C_BLN > 	  SLV_SECFAB.FAB$L_ALQ=ILV_ITMLST(12)	! page count of section+ 	  SLV_SECFAB.FAB$B_FAC=FAB$M_PUT+FAB$M_GET > 	  SLV_SECFAB.FAB$L_FNA=%LOC('SYS$SCRATCH:ETH_ADDRTBL.GBLSEC') 	  SLV_SECFAB.FAB$B_FNS=306 	  SLV_SECFAB.FAB$L_FOP=FAB$M_UFO+FAB$M_CBT+FAB$M_SQO+      +					FAB$M_CIF+FAB$M_DLT! 	  SLV_SECFAB.FAB$B_ORG=FAB$C_SEQ ! 	  SLV_SECFAB.FAB$B_RFM=FAB$C_UDF  	  SLV_SECFAB.FAB$B_RTV=-1; 	  SLV_SECFAB.FAB$B_SHR=FAB$M_SHRPUT+FAB$M_SHRGET+FAB$M_UPI $ 	  ILV_STATUS=SYS$CREATE(SLV_SECFAB) 	  IF(ILV_STATUS)THEN D 	    ILV_STATUS=SYS$CRMPSC(ILV_PRVLST,	! specify addresses of table,.      +			    ,			! don't care what got mapped,*      +			    %VAL(3),		! map at user mode,7      +			%VAL(SEC$M_GBL+SEC$M_WRT+SEC$M_DZRO), ! flags, )      +			    CLV_GSDNAM,		! section name, 2      +			    ILV_ITMLST(10),	! section version ID,      +			    ,			! no relpag, @      +			    %VAL(SLV_SECFAB.FAB$L_STV), ! specify file channel,0      +			    %VAL(ILV_ITMLST(12)), ! page count,+      +			    ,			! no VBN (no file either),*6      +			    %VAL('FF00'X),	! restrict access to self,      +			    )			! ignore PFC. 	  ENDIF 	  IF(.NOT.ILV_STATUS)THEN 	    ILV_ITMLST(1)=4 	    ILV_ITMLST(5)=ILV_STATUSR0 	    CALL SYS$DASSGN(%VAL(SLV_SECFAB.FAB$L_STV)) 	  ENDIF 	ENDIF 	IF(.NOT.ILV_STATUS)THEN! 	  CALL SYS$PUTMSG(ILV_ITMLST,,,)t 	ENDIF       ENDIF C       ICVADR_SECVERSION=ICPADR_SECVERSION	! put ID mark in the data-I       ICVADR_SECLENGTH=ILV_PRVLST(2)-ILV_PRVLST(1)+1	! put length in datad Cc1 CP.  connect to and initialize Ethernet interfacer Cf       CALL INIT_ETHERNET Ce CP.  initialize SMG$ interface C-:       ILV_STATUS=SMG$CREATE_VIRTUAL_KEYBOARD(ICVSMG_KEYID)       IF(.NOT.ILV_STATUS)THEN	  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFeL       ILV_STATUS=SYS$ASSIGN('SYS$INPUT:',NCVNAM_INCHAN,,) ! connect to stdin       IF(.NOT.ILV_STATUS)THENc  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFo(       CALL ENABLE_CONTROL_C_TRAP(.TRUE.)4       ILV_STATUS=SMG$CREATE_KEY_TABLE(ICVSMG_KTBLID)       IF(.NOT.ILV_STATUS)THEN-  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFe<       CALL SET_KEYPAD(,,,,,,,%VAL(SMG$M_KEYPAD_APPLICATION))       IF(.NOT.ILV_STATUS)THENa  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFe6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'PF1',,'      +				 SMG$M_KEY_PROTECTED,,'GOLD')c       IF(.NOT.ILV_STATUS)THEN	  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFr<       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'PF1','GOLD','      +				 SMG$M_KEY_PROTECTED,,'GOLD')M       IF(.NOT.ILV_STATUS)THEN   	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFu6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'PF2',,3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,d!      +				 'Help Keypad Default')	       IF(.NOT.ILV_STATUS)THENd  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFe<       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'PF2','GOLD',3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,c      +				 'Help Keypad GOLD')       IF(.NOT.ILV_STATUS)THEN	  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFs6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'PF4',,3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,2$      +				 'SET KEYPAD APPLICATION')       IF(.NOT.ILV_STATUS)THENz  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFr<       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'PF4','GOLD',3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,e       +				 'SET KEYPAD NUMERIC')       IF(.NOT.ILV_STATUS)THENl  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFr6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP0',,3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,mH      +	'TRACE/ANALYZER=ETHERPARSE2/STATISTICS/PARALLEL/INTERVAL=:59:59')       IF(.NOT.ILV_STATUS)THENd  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIF	6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP7',,3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,N      +				 'DISPLAY SOURCES')n       IF(.NOT.ILV_STATUS)THEN	  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFn6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP8',,3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,c"      +				 'DISPLAY DESTINATIONS')       IF(.NOT.ILV_STATUS)THEN   	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIF	6       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP9',,3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,	      +				 'DISPLAY PROTOCOLS')w       IF(.NOT.ILV_STATUS)THENt  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFo<       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP7','GOLD',3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,e&      +				 'DISPLAY SOURCES/NOFILTER')       IF(.NOT.ILV_STATUS)THENl  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFn<       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP8','GOLD',3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,e+      +				 'DISPLAY DESTINATIONS/NOFILTER')	       IF(.NOT.ILV_STATUS)THENr  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIF <       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'KP9','GOLD',3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,a(      +				 'DISPLAY PROTOCOLS/NOFILTER')       IF(.NOT.ILV_STATUS)THEN,  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFE7       ILV_STATUS=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,'HELP',,h3      +				 SMG$M_KEY_TERMINATE+SMG$M_KEY_PROTECTED,R      +				 'Help')       IF(.NOT.ILV_STATUS)THENe  	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFT Cc! CP.  print program signon messageS C 6       CALL LIB$PUT_OUTPUT('ETHERMON '//CCPETH_VERSION) Cn/ CP.  IF initialization command file exists THEN	 Co4       OPEN(UNIT=1,FILE='ETHERMON$INIT',STATUS='OLD',<      +	   DEFAULTFILE='ETHERMON$INIT.COM',IOSTAT=ILV_STATUS,8      +	   ACCESS='SEQUENTIAL',FORM='FORMATTED',READONLY)       IF(ILV_STATUS.EQ.0)THENN CN= CP.  .  mark that it should be used for initial command inputS Ca 	LCV_CMDFIL=.TRUE. Ce
 CP.  ENDIF CS       ENDIF	 CA CP.  REPEATn Co       DO WHILE (.NOT.LCV_EXIT) Cd CP.  .  prompt for command C	 	IF(NCVCMD_CMDLEN.EQ.0)THENr 	  IF(LCV_CMDFIL)THENiC 	    READ(1,'(Q,A)',IOSTAT=ILV_STATUS) NCVCMD_CMDLEN, CCVCMD_CMDLINi 	    IF(ILV_STATUS.EQ.0)THEN* 	      CALL LIB$PUT_OUTPUT('@ETHERMON> '//)      +				CCVCMD_CMDLIN(1:NCVCMD_CMDLEN))e 	      ILV_STATUS=1P	 	    ELSE	 	      IF(ILV_STATUS.EQ.-1)THENE 		ILV_STATUS=%LOC(RMS$_EOF)r 	      ELSEi 		ILV_STATUS=12a 	      ENDIF
 	    ENDIF 	  ELSEsB 	    ILV_STATUS=SMG$READ_COMPOSED_LINE(ICVSMG_KEYID,ICVSMG_KTBLID,&      +					CCVCMD_CMDLIN,'ETHERMON> ',      +					NCVCMD_CMDLEN)  	  ENDIF 	ENDIF Co& CP.  .  IF no command entry error THEN Cc 	IF(ILV_STATUS)THEN  C	' CP.  .  .  parse command and execute itl Ca 	  IF(NCVCMD_CMDLEN.GT.0)THENo 	    LCVCMD_INPROGRESS=.TRUE.r 	    LCVCMD_CTRLC=.FALSE.	0 	    CALL UPCASE(CCVCMD_CMDLIN(1:NCVCMD_CMDLEN)): 	    CALL EVALUATE_COMMAND(CCVCMD_CMDLIN(1:NCVCMD_CMDLEN)) 	    LCVCMD_INPROGRESS=.FALSE. 	  ENDIF CU4 CP.  .  ELSEIF error is end-of-file (control-Z) THEN Cr( 	ELSEIF(ILV_STATUS.EQ.%LOC(SMG$_EOF).OR./      +	       ILV_STATUS.EQ.%LOC(RMS$_EOF))THENa Cd1 CP.  .  .  IF indirect command file was open THEN	 C	 	  IF(LCV_CMDFIL)THENa Ct! CP.  .  .  .  close indirect filee Cd 	    CLOSE(UNIT=1) 	    LCV_CMDFIL=.FALSE.M C  CP.  .  .  ELSE	 Cm 	  ELSEm C # CP.  .  .  .  simulate EXIT command  CF 	    LCV_EXIT=.TRUE. Cs CP.  .  .  ENDIF Ca 	  ENDIF Cr CP.  .  ELSE C	 	ELSEr Co CP.  .  .  report errorR C " 	  CALL LIB$STOP(%VAL(ILV_STATUS)) Ce
 CP.  .  ENDIFU Cv 	ENDIF CvK CP.  .  IF control-C was typed and we were in an indirect command file THEN  CT& 	IF(LCV_CMDFIL .AND. LCVCMD_CTRLC)THEN CU. CP.  .  .  close the indirect file prematurely Ce 	  CLOSE(UNIT=1) 	  LCV_CMDFIL=.FALSE.P C 7 CP.  .  .  tell user that command file was closed early  CF 	  ILV_ITMLST(1)=1% 	  ILV_ITMLST(2)=%LOC(ETH__CLSINDFIL)s! 	  CALL SYS$PUTMSG(ILV_ITMLST,,,)o Cr
 CP.  .  ENDIF	 CW 	ENDIF Cc CP.  UNTIL exit command enteredi Co 	NCVCMD_CMDLEN=0       ENDDO	 Cu CP END ETHERNET_MONITORp Ca	       END	        SUBROUTINE UPCASE(CLA_STR) CR CP DATA DECLARATIONS for UPCASEt Cd       IMPLICIT NONE  Ce  C   declare subroutine arguments C,       CHARACTER*(*) CLA_STR	 C	 C   declare local variablesc Cn       INTEGER*4 Id       LOGICAL*1 LLV_QUOTEI C  CP BEGIN UPCASEm  CP.  initially clear quoted flag C        LLV_QUOTE=.FALSE.o Cc" CP.  DO for all characters in line CL       DO I=1,LEN(CLA_STR)o C"- CP.  .  IF character is double-quote (") THENa Cs 	IF(CLA_STR(I:I).EQ.'"')THEN CS CP.  .  .  toggle quoted flags Cf 	  LLV_QUOTE=.NOT.LLV_QUOTE  C	9 CP.  .  ELSEIF character is lowercase and flag reset THEN  CW 	ELSEIF(.NOT.LLV_QUOTE.AND.N@      +	       (CLA_STR(I:I).GE.'a'.AND.CLA_STR(I:I).LE.'z'))THEN Co CP.  .  .  upshift character CN/ 	  CLA_STR(I:I)=CHAR(ICHAR(CLA_STR(I:I))-'20'X)n Cs
 CP.  .  ENDIF	 Ch 	ENDIF C 
 CP.  ENDDO Cr       ENDDO	 Co CP.  RETURNe Cn       RETURN Ca
 CP END UPCASEl Cc	       END /       SUBROUTINE ETHERMON_EXIT_HANDLER(ILA_STS)m Cd. CP DATA DECLARATIONS for ETHERMON_EXIT_HANDLER CE       IMPLICIT NONEr C   C   declare subroutine arguments Cr       INTEGER*4 ILA_STS  Cr C   declare local variablest C        INTEGER*4 ILV_STATUS Ci C   declare local COMMON's C	        INCLUDE 'ETHERMON_ETH.INC' Cp CP BEGIN ETHERMON_EXIT_HANDLER# CP.  IF trace was in operation THENt C #       IF(NCVETH_TRACEFLAG.NE.0)THENn Ct CP.  .  make it non-repeatinge Ct< 	NCVETH_TRACEFLAG=IAND(NCVETH_TRACEFLAG,NOT(NCPETH_TRC_RPT)) Cl CP.  .  close down the trace Ce' 	CALL SYS$SETAST(%VAL(0))	! block AST's  	CALL TRACE_WAKEUP_AST+ 	CALL SYS$SETAST(%VAL(1))	! re-enable AST's  C	
 CP.  ENDIF C        ENDIF  Cp= CP.  attempt to open global section file (if any was created)	 CaF       OPEN(UNIT=42,FILE='SYS$SCRATCH:ETH_ADDRTBL.GBLSEC',STATUS='OLD',#      +	   SHARED,IOSTAT=ILV_STATUS)h C  CP.  IF open succeeded THEN  CT       IF(ILV_STATUS.EQ.0)THEN, C	$ CP.  .  close the file and delete it Cr 	CLOSE(UNIT=42,DISP='DELETE')o C 
 CP.  ENDIF C	       ENDIFo Cc CP.  RETURNr Cd       RETURN Ce CP END ETHERMON_EXIT_HANDLER Cr	       ENDr2       SUBROUTINE ENABLE_CONTROL_C_TRAP(LLA_ENABLE) Co. CP DATA DECLARATIONS for ENABLE_CONTROL_C_TRAP Ca       IMPLICIT NONE	 C	  C   declare subroutine arguments C        LOGICAL*1 LLA_ENABLE C  C   declare local variableso C        INTEGER*2 NLV_IOSB(0:3)	B       INTEGER*4 ILV_STATUS, ILV_ITMLST(5), ILV_OUTBAND_MSK(2)/0,8/ Ct C   declare local COMMON's Cs        INCLUDE 'ETHERMON_DEV.INC' CP C   declare local procedures Cr!       EXTERNAL	CONTROL_C_TRAP_ASTf Cz C   declare system procedures  C %       INTEGER*4 SYS$GETDVIW, SYS$QIOWn$       EXTERNAL	SYS$GETDVIW, SYS$QIOW CB! C   declare system symbolic codes	 CE!       INCLUDE '($DCDEF)		/NOLIST'e!       INCLUDE '($DVIDEF)	/NOLIST'l!       INCLUDE '($IODEF)		/NOLIST't Cp CP BEGIN ENABLE_CONTROL_C_TRAP/ CP.  determine the stanadrd input's device type, Ce.       ILV_ITMLST(1)=4+JISHFT(DVI$_DEVCLASS,16)'       ILV_ITMLST(2)=%LOC(ILV_ITMLST(5))x       ILV_ITMLST(3)=0c       ILV_ITMLST(4)=0*>       ILV_STATUS=SYS$GETDVIW(,%VAL(NCVNAM_INCHAN),,ILV_ITMLST,      +			     NLV_IOSB,,,)       IF(.NOT.ILV_STATUS)THENr" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN# 	CALL LIB$SIGNAL(%VAL(NLV_IOSB(0)))D       ENDIF  C  CP.  IF not a terminal THENT C )       IF(ILV_ITMLST(5) .NE. DC$_TERM)THENN CD: CP.  .  warn user that control-C trapping may be messed up C 	 	CONTINUE( CI( CP.  ELSEIF trap enabling requested THEN CI       ELSEIF(LLA_ENABLE)THEN C ! CP.  .  enable the control-C trap  C 1 	ILV_STATUS=SYS$QIOW(%VAL(0),		! use scratch EF#,O3      +			    %VAL(NCVNAM_INCHAN),	! device channel,B8      +			    %VAL(IO$_SETMODE+IO$M_OUTBAND), ! function,      +			    NLV_IOSB,,,;      +			    CONTROL_C_TRAP_AST,	! specify out-of-band AST,TA      +			    %REF(ILV_OUTBAND_MSK),! out-of-band bitmask: ctrl/C, *      +			    %VAL(3),,,)		! user mode AST. 	IF(.NOT.ILV_STATUS)THEN" 	  CALL LIB$STOP(%VAL(ILV_STATUS)) 	ELSEIF(.NOT.NLV_IOSB(0))THEN/# 	  CALL LIB$STOP(%VAL(NLV_IOSB(0)))C 	ENDIF C 	 CP.  ELSE/ CU'       ELSE	! disable control-C trappingD CI CP.  .  disable trapping C_1 	ILV_STATUS=SYS$QIOW(%VAL(0),		! use scratch EF#,N3      +			    %VAL(NCVNAM_INCHAN),	! device channel,.8      +			    %VAL(IO$_SETMODE+IO$M_OUTBAND), ! function,      +			    NLV_IOSB,,,.      +			    ,			! specify no out-of-band AST,A      +			    %REF(ILV_OUTBAND_MSK),! out-of-band bitmask: ctrl/C,E*      +			    %VAL(3),,,)		! user mode AST. 	IF(.NOT.ILV_STATUS)THEN" 	  CALL LIB$STOP(%VAL(ILV_STATUS)) 	ELSEIF(.NOT.NLV_IOSB(0))THENR# 	  CALL LIB$STOP(%VAL(NLV_IOSB(0)))_ 	ENDIF C 
 CP.  ENDIF CM       ENDIFY CR CP.  RETURN_ C_       RETURN C$ CP END ENABLE_CONTROL_C_TRAP CL	       END,#       SUBROUTINE CONTROL_C_TRAP_ASTM CR+ CP DATA DECLARATIONS for CONTROL_C_TRAP_AST  C        IMPLICIT NONE_ CE C   declare local COMMON's C         INCLUDE 'ETHERMON_CMD.INC' CP) C   declare system symbolic message codesl Cs       EXTERNAL	SS$_CONTROLC_ CT CP BEGIN CONTROL_C_TRAP_AST_! CP.  flag that control-C happened1 CR       LCVCMD_CTRLC=.TRUE.  C ) CP.  cause an exception of type control-CR CV#       CALL LIB$SIGNAL(SS$_CONTROLC)  C	 CP.  RETURNP CP       RETURN CV CP END CONTROL_C_TRAP_AST) CN	       END$B       INTEGER*4 FUNCTION DISPLAY_CTRLC_EXCPTHDLR(ILA_SIG,ILA_MECH) Cu0 CP DATA DECLARATIONS for DISPLAY_CTRLC_EXCPTHDLR C        IMPLICIT NONEC CH  C   declare subroutine arguments CT+       INTEGER*4 ILA_SIG(0:*), ILA_MECH(0:4)E CC) C   declare system symbolic message codes_ CT!       INCLUDE '($SSDEF)		/NOLIST'O CS  CP BEGIN DISPLAY_CTRLC_EXCPTHDLR4 CP.  assume that this is the wrong exception handler C *       DISPLAY_CTRLC_EXCPTHDLR=SS$_RESIGNAL C,' CP.  IF this is a control-C report THEN' Ca*       IF(ILA_SIG(1) .EQ. SS$_CONTROLC)THEN CM CP.  .  display the message, C  	ILA_SIG(0)=ILA_SIG(0)-2 	CALL SYS$PUTMSG(ILA_SIG,,,) CT" CP.  .  make the exception go away CT% 	DISPLAY_CTRLC_EXCPTHDLR=SS$_CONTINUEP CA
 CP.  ENDIF CL       ENDIFL CC CP.  RETURN  C        RETURN C= CP END DISPLAY_CTRLC_EXCPTHDLR CT	       ENDI9       INTEGER*4 FUNCTION FIND_ADDRSLOT(SLA_ADDR,LLA_TYPE)  C & CP DATA DECLARATIONS for FIND_ADDRSLOT CJ       IMPLICIT NONEf Cg C   declare local COMMON's CL!       INCLUDE 'ETHERMON_ADDR.INC'  CL  C   declare subroutine arguments C0       RECORD /ETH_ADR/ SLA_ADDR,       LOGICAL*1 LLA_TYPE C  C   declare local variablesL CI       INTEGER*4 ILV_COUNT, I C  CP BEGIN FIND_ADDRSLOT! CP.  calculate initial hash valueB C)9       FIND_ADDRSLOT=IAND(SLA_ADDR.NUM(2),ICPADR_MAXADDRS)        ILV_COUNT=02 C ) CP.  block AST's from messing up the scanL CA,       IF (LLA_TYPE) CALL SYS$SETAST(%VAL(0)) C E CP.  DO WHILE current slot doesn't match and current slot is used andn CP		retry count not exceeded C H       DO WHILE ((SCVADR_ADDR(FIND_ADDRSLOT).LNUM .NE. SLA_ADDR.LNUM .OR.@      +		 SCVADR_ADDR(FIND_ADDRSLOT).NUM(2) .NE. SLA_ADDR.NUM(2))H      +    .AND. IAND(ICVADR_FLAGS(FIND_ADDRSLOT),ICPADR_USED).NE.0 .AND.'      +		ILV_COUNT.LT.ICPADR_MAXADDRS/2)L C1 CP.  .  step to next slot  C 4 	FIND_ADDRSLOT=IAND(FIND_ADDRSLOT+1,ICPADR_MAXADDRS) 	ILV_COUNT=ILV_COUNT+1 CD
 CP.  ENDDO C        ENDDOT CT$ CP.  IF matching slot not found THEN CI@       IF(SCVADR_ADDR(FIND_ADDRSLOT).LNUM .NE. SLA_ADDR.LNUM .OR.C      +	 SCVADR_ADDR(FIND_ADDRSLOT).NUM(2) .NE. SLA_ADDR.NUM(2))THENS CL> CP.  .  scan to see if this is an alternate address for a node Cc 	I=05 	DO WHILE ((SCVADR_OTHERADDR(FIND_ADDRSLOT).LNUM .NE.d      +					SLA_ADDR.LNUM .OR.$6      +		   SCVADR_OTHERADDR(FIND_ADDRSLOT).NUM(2) .NE.      +					SLA_ADDR.NUM(2) .OR. /      +    	   IAND(ICVADR_FLAGS(FIND_ADDRSLOT), *      +			ICPADR_USED+ICPADR_OTHERADDR).NE..      +					ICPADR_USED+ICPADR_OTHERADDR) .AND.      +		  I.LE.ICPADR_MAXADDRS)t 	  I=I+1 	ENDDO) 	IF(I.LE.ICPADR_MAXADDRS) FIND_ADDRSLOT=I, C 
 CP.  ENDIF C!       ENDIF  C $ CP.  IF matching slot not found THEN C)A       IF((SCVADR_ADDR(FIND_ADDRSLOT).LNUM .NE. SLA_ADDR.LNUM .OR.SF      +	  SCVADR_ADDR(FIND_ADDRSLOT).NUM(2) .NE. SLA_ADDR.NUM(2)) .AND.E      +	 (IAND(ICVADR_FLAGS(FIND_ADDRSLOT),ICPADR_OTHERADDR).EQ.0 .OR.S2      +	  SCVADR_OTHERADDR(FIND_ADDRSLOT).LNUM .NE.      +					SLA_ADDR.LNUM .OR.$4      +	  SCVADR_OTHERADDR(FIND_ADDRSLOT).NUM(2) .NE.       +					SLA_ADDR.NUM(2)))THEN CCI CP.  .  IF "create new entry" not specified or return slot not empty THEN  C+ 	IF(.NOT.LLA_TYPE.OR.TA      +	   IAND(ICVADR_FLAGS(FIND_ADDRSLOT),ICPADR_USED).NE.0)THEN_ C ( CP.  .  .  change return status to error CA 	  FIND_ADDRSLOT=-1F CM( CP.  .  ELSE {must be "create new slot"} CS 	ELSEA C & CP.  .  .  increment table entry count C$$ 	  ICVADR_NUMADDRS=ICVADR_NUMADDRS+1 C  CP.  .  .  add address to tablec C 0 	  SCVADR_ADDR(FIND_ADDRSLOT).LNUM=SLA_ADDR.LNUM4 	  SCVADR_ADDR(FIND_ADDRSLOT).NUM(2)=SLA_ADDR.NUM(2)* 	  ICVADR_FLAGS(FIND_ADDRSLOT)=ICPADR_USED Ct
 CP.  .  ENDIF  C	 	ENDIF CM
 CP.  ENDIF Ci       ENDIF, C  CP.  unblock AST's Cp,       IF (LLA_TYPE) CALL SYS$SETAST(%VAL(1)) Cs CP.  RETURNh Ce       RETURN C% CP END FIND_ADDRSLOT Cg	       END ;       INTEGER*4 FUNCTION FIND_MANUFSLOT(ILA_MANUF,LLA_TYPE)( C0' CP DATA DECLARATIONS for FIND_MANUFSLOT	 C        IMPLICIT NONE  CD C   declare local COMMON's C "       INCLUDE 'ETHERMON_MANUF.INC' C)  C   declare subroutine arguments CA       INTEGER*4 ILA_MANUF        LOGICAL*1 LLA_TYPE CS C   declare local variablesG CV       INTEGER*4 ILV_MANUF  CI CP BEGIN FIND_MANUFSLOTO CP.  set up to begin scanD Cr       FIND_MANUFSLOT=1+       ILV_MANUF=IAND(ILA_MANUF,'00FFFFFE'X)! Ct) CP.  block AST's from messing up the scann Ca,       IF (LLA_TYPE) CALL SYS$SETAST(%VAL(0)) CEE CP.  DO WHILE current slot doesn't match and entry count not exceededT CIE       DO WHILE (ICVMNF_MANUF_NUM(FIND_MANUFSLOT) .NE. ILV_MANUF .AND.$,      +		FIND_MANUFSLOT .LE. ICVMNF_NUMNAMES) CT CP.  .  step to next slot' CV  	FIND_MANUFSLOT=FIND_MANUFSLOT+1 C 
 CP.  ENDDO CT       ENDDOC C $ CP.  IF matching slot not found THEN C =       IF(ICVMNF_MANUF_NUM(FIND_MANUFSLOT) .NE. ILV_MANUF)THENC CT0 CP.  .  IF "create new entry" not specified THEN CT 	IF(.NOT.LLA_TYPE)THEN CL( CP.  .  .  change return status to error CA 	  FIND_MANUFSLOT=-1 CD( CP.  .  ELSE {must be "create new slot"} Ca 	ELSE  C$& CP.  .  .  increment table entry count C $ 	  ICVMNF_NUMNAMES=ICVMNF_NUMNAMES+1 C') CP.  .  .  add manufacturer code to tableL Cc- 	  ICVMNF_MANUF_NUM(FIND_MANUFSLOT)=ILV_MANUFP& 	  CCVMNF_MANUFNAM(FIND_MANUFSLOT)=' '' 	  NCVMNF_MANUFNAMLEN(FIND_MANUFSLOT)=0'! 	  CCVMNF_NAM(FIND_MANUFSLOT)=' 'P" 	  NCVMNF_NAMLEN(FIND_MANUFSLOT)=0 CT
 CP.  .  ENDIFL CI 	ENDIF C(
 CP.  ENDIF C        ENDIF  C  CP.  unblock AST's CD,       IF (LLA_TYPE) CALL SYS$SETAST(%VAL(1)) CR CP.  RETURNK CP       RETURN C+ CP END FIND_MANUFSLOTl C		       END.7       SUBROUTINE GET_ETHERPORT_NAME(CLA_CMDLIN,NLA_LEN)  C + CP DATA DECLARATIONS for GET_ETHERPORT_NAMEM CT       IMPLICIT NONE  C+  C   declare subroutine arguments CO       CHARACTER*(*) CLA_CMDLIN       INTEGER*2 NLA_LENL CT C   declare local variablesA CL       INTEGER*4 ILP_MAXDEVNAMESL"       PARAMETER(ILP_MAXDEVNAMES=7) C',       CHARACTER*5 CLV_EDNAM(ILP_MAXDEVNAMES)@      +	/'ETx0:','XEx0:','XQx0:','ESx0:','EZx0:','EXx0:','FXx0:'/.       CHARACTER*16 CLV_DEVICES(16), CLV_DEVNAM       CHARACTER*132 CLV_CMDLIN&       INTEGER*2 NLV_IOSB(0:3), LN, LN2?       INTEGER*4 ILV_STATUS, ILV_ITMLST(10), ILV_DEVCLASS, I, J, 0      +		ILV_DEVTYPE, ILV_DEVCNT, K, ILV_GETFLAGS CT C   declare local COMMON's CL       BYTE	BCV_DEVNUMS(13)=       DATA BCV_DEVNUMS/13,14,22,24,25,29,33,34,35,36,38,43,0/	!       CHARACTER*7 CCV_DEVNAMS(13)ED       DATA CCV_DEVNAMS/'NI','DEUNA','DEQNA','DESVA','DELUA','DEBNA',@      +	'DELQA','DEBNI','SGEC','DEMNA','DEQTA','DEMFA','unknown'/0       COMMON /DEVTYPES/ BCV_DEVNUMS, CCV_DEVNAMS       LOGICAL*1 LCV_EXIT        COMMON /LCV_EXIT/ LCV_EXIT        INCLUDE 'ETHERMON_DEV.INC'        INCLUDE 'ETHERMON_ETH.INC'!       INCLUDE 'ETHERMON_PROT.INC'P CA C   declare system procedures  C >       INTEGER*4 LIB$GET_FOREIGN, SYS$GETDVIW, LIB$GET_COMMAND,      +		SYS$ASSIGN=       EXTERNAL	LIB$GET_FOREIGN, SYS$GETDVIW, LIB$GET_COMMAND,F      +		SYS$ASSIGN C ! C   declare system symbolic codes  C !       INCLUDE '($DCDEF)		/NOLIST'Y!       INCLUDE '($DVIDEF)	/NOLIST'	?       EXTERNAL	NMA$C_LINFM_ETH, NMA$C_LINFM_802, NMA$C_STATE_ON !       INCLUDE '($PRVDEF)	/NOLIST'T       EXTERNAL	RMS$_EOF%!       INCLUDE '($SSDEF)		/NOLIST'  CL CP BEGIN GET_ETHERPORT_NAMEM# CP.  get name of Ethernet interfaceG CK0       ILV_STATUS=LIB$GET_FOREIGN(CLV_CMDLIN,,LN)*     1 IF(ILV_STATUS.EQ.%LOC(RMS$_EOF))THEN
 	CALL EXIT!       ELSEIF(.NOT.ILV_STATUS)THEN   	CALL LIB$STOP(%VAL(ILV_STATUS))       ENDIFI CMM CP.  mark where the device name might end (if an initial command is supplied)  C+       IF(LN.GT.0)THENO 	LN2=INDEX(CLV_CMDLIN,',')-1       ENDIFE       IF(LN2.LE.0) LN2=LN_ CT6 CP.  pass initial user command (if any) back to caller C_       IF(LN2+1.GE.LN)THEN+ 	CLA_CMDLIN=' 'R
 	NLA_LEN=0
       ELSE  	CLA_CMDLIN=CLV_CMDLIN(LN2+2:LN) 	NLA_LEN=LN-LN2-1        ENDIFT       LN=LN2 C  CP.  IF query suppled THEN C        IF(LN.EQ.0.OR.-      +	 INDEX(CLV_CMDLIN(1:LN),'?').NE.0)THEN  C+% CP.  .  convert to unlimited wildcardE CD 	CLV_CMDLIN='*'e 	LN=1  C 
 CP.  ENDIF CT       ENDIFL CI  CP.  IF wildcard (or query) THEN CT.       IF(INDEX(CLV_CMDLIN(1:LN),'*').NE.0)THEN C  CP.  .  set up for scanR C  	I=1	! device name categoryI 	J=1	! controller letter index' 	ILV_DEVCNT=0	! number of found devicesT CM CP.  .  REPEAT CD  	DO WHILE (I.LE.ILP_MAXDEVNAMES) CN( CP.  .  .  get next Ethernet-like device C' 	  CLV_EDNAM(I)(3:3)=CHAR(J+64)O* 	  ILV_ITMLST(1)=64+JISHFT(DVI$_DEVNAM,16)$ 	  ILV_ITMLST(2)=%LOC(CCVNAM_DEVNAM)' 	  ILV_ITMLST(3)=%LOC(NCVNAM_DEVNAMLEN)T+ 	  ILV_ITMLST(4)=4+JISHFT(DVI$_DEVCLASS,16)P# 	  ILV_ITMLST(5)=%LOC(ILV_DEVCLASS)L 	  ILV_ITMLST(6)=0* 	  ILV_ITMLST(7)=4+JISHFT(DVI$_DEVTYPE,16)" 	  ILV_ITMLST(8)=%LOC(ILV_DEVTYPE) 	  ILV_ITMLST(9)=0 	  ILV_ITMLST(10)=0V 	  ILV_STATUS=SYS$GETDVIW(,       +			     ,CLV_EDNAM(I),      +			     ILV_ITMLST,E      +			     NLV_IOSB,,,) 	  IF(.NOT.ILV_STATUS.AND.+      +	     ILV_STATUS.NE.SS$_IVDEVNAM.AND.(,      +	     ILV_STATUS.NE.SS$_NOSUCHDEV)THEN$ 	    CALL LIB$STOP(%VAL(ILV_STATUS)) 	  ELSEIF(.NOT.NLV_IOSB(0).AND.S,      +	     NLV_IOSB(0).NE.SS$_IVDEVNAM.AND.-      +	     NLV_IOSB(0).NE.SS$_NOSUCHDEV)THENL% 	    CALL LIB$STOP(%VAL(NLV_IOSB(0)))L 	  ENDIF CF% CP.  .  .  IF next device exists THENr Cr% 	  IF(ILV_STATUS.AND.NLV_IOSB(0).AND. )      +	     ILV_DEVCLASS.EQ.DC$_SCOM)THENa C  CP.  .  .  .  save device name CL 	    ILV_DEVCNT=ILV_DEVCNT+1> 	    CLV_DEVICES(ILV_DEVCNT)=CCVNAM_DEVNAM(1:NCVNAM_DEVNAMLEN) 	    K=1 	    DO WHILE (K.LT.12.AND.V,      +		      BCV_DEVNUMS(K).NE.ILV_DEVTYPE) 	      K=K+1
 	    ENDDO 	    IF(K.LE.12)THEN4 	      CLV_DEVICES(ILV_DEVCNT)(NCVNAM_DEVNAMLEN+1:)=      +			'   '//CCV_DEVNAMS(K)
 	    ENDIF CT CP.  .  .  ELSE_ C) 	  ELSEd CP) CP.  .  .  .  advance to next device typeT C	
 	    I=I+1 	    J=0 CE CP.  .  .  ENDIF C  	  ENDIF Ct4 CP.  .  UNTIL all Ethernet-like device names scanned C  	  J=J+1 	ENDDO C $ CP.  .  IF more than one device THEN CE 	IF(ILV_DEVCNT.GT.1)THEN CI& CP.  .  .  print explanation of prompt CF 	  CALL LIB$PUT_OUTPUT(EB      +'%ETHERMON-I-PORT, enter VMS device name of the Ethernet '//      +'interface to use')  C E CP.  .  .  attempt to engage extra privilege to allow reading deviceso Cn. 	  ILV_ITMLST(1)=IAND(IEOR(QCVETH_PROCPRIV(1),3      +				  PRV$M_SHARE+PRV$M_SYSPRV+PRV$M_BYPASS),a4      +			     PRV$M_SHARE+PRV$M_SYSPRV+PRV$M_BYPASS). 	  ILV_ITMLST(2)=IAND(IEOR(QCVETH_PROCPRIV(2),'      +				  ISHFT(1,PRV$V_READALL-32)),I(      +			     ISHFT(1,PRV$V_READALL-32))+ 	  CALL SYS$SETPRV(%VAL(1),ILV_ITMLST(1),,)I C  CP.  .  .  DO for each device  Cm 	  DO K=1,ILV_DEVCNT C_$ CP.  .  .  .  fill in line initially CE4 	    CALL STR$TRIM(CLV_DEVICES(K),CLV_DEVICES(K),LN)$ 	    CLV_CMDLIN=CLV_DEVICES(K)(1:LN)  	    J=INDEX(CLV_DEVICES(K),':')1 	    CLV_DEVNAM(1:4)='_'//CLV_DEVICES(K)(J-4:J-2)R 	    ILV_GETFLAGS=0	 C . CP.  .  .  .  DO for all possible device units C  	    I=1 	    DO WHILE (I.LE.65535.AND.#      +		      ILV_GETFLAGS.LT.3000)l C 7 CP.  .  .  .  .  attempt to assign channel to that unite Ci6 	      CALL SYS$FAO('!UW:',LN2,CLV_DEVNAM(5:),%VAL(I))? 	      ILV_STATUS=SYS$ASSIGN(CLV_DEVNAM(1:LN2+4),NCVETH_CHAN,,)H C ) CP.  .  .  .  .  IF assign succeeded THENL CQ 	      IF(ILV_STATUS)THENP C.& CP.  .  .  .  .  .  zero retry counter Cs 		ILV_GETFLAGS=0 C(7 CP.  .  .  .  .  .  sense the current state of the unitA CC 		CALL GET_PORT_STATUS Co) CP.  .  .  .  .  .  deassign unit channelS CI$ 		CALL SYS$DASSGN(%VAL(NCVETH_CHAN))' 		CALL SYS$DALLOC(CLV_DEVNAM(1:LN2+4),)E CO8 CP.  .  .  .  .  .  add appropriate stuff to output line CP, 		IF(ICVETH_FMT.EQ.-1.OR.			! V4.x undefined3      +		   ICVETH_FMT.EQ.%LOC(NMA$C_LINFM_ETH))THENT< 		  CALL SYS$FAO('!5UL: !XB-!XB',LN,CLV_CMDLIN(17:),%VAL(I),1      +			%VAL(BCVETH_PTY(1)),%VAL(BCVETH_PTY(2)))* 		  LN=LN+16 		  J=ICVPRT_NUMNAMESi 		  DO WHILE (J.GE.1.AND. %      +			    (LCVPRT_PROT_IEEE(J).OR.N0      +			     NCVETH_PTY.NE.NCVPRT_PROT_NUM(J))) 		    J=J-1_	 		  ENDDOR 		  IF(J.GE.1)THEN. 		    CLV_CMDLIN(LN+1:)=' '//CCVPRT_PROTNAM(J)" 		    LN=LN+1+NCVPRT_PROTNAMLEN(J)	 		  ENDIFe1 		ELSEIF(ICVETH_FMT.EQ.%LOC(NMA$C_LINFM_802))THENC> 		  CALL SYS$FAO('!5UL: IEEE 802, SAP=!XB',LN,CLV_CMDLIN(17:),)      +			       %VAL(I),%VAL(ICVETH_SAP))_ 		ELSE	! IEEE 802 extended; 		  CALL SYS$FAO('!5UL: IEEE 802E, !XB-!XB-!XB,!XB-!XB',LN, (      +			       CLV_CMDLIN(17:),%VAL(I),8      +			       %VAL(BCVETH_PID(0)),%VAL(BCVETH_PID(1)),8      +			       %VAL(BCVETH_PID(2)),%VAL(BCVETH_PID(3)),$      +			       %VAL(BCVETH_PID(4))) 		  LN=LN+16 		  J=ICVPRT_NUMNAMESV 		  DO WHILE (J.GE.1.AND. *      +			    (.NOT.LCVPRT_PROT_IEEE(J).OR.0      +			     NCVETH_PID.NE.NCVPRT_PROT_NUM(J))) 		    J=J-1 	 		  ENDDOr 		  IF(J.GE.1)THEN. 		    CLV_CMDLIN(LN+1:)=' '//CCVPRT_PROTNAM(J)" 		    LN=LN+1+NCVPRT_PROTNAMLEN(J)	 		  ENDIFA 		ENDIF , 		IF(ICVETH_PRM.EQ.%LOC(NMA$C_STATE_ON))THEN4 		  CLV_CMDLIN(LN+1:)=' *CONFLICT* promiscuous user' 		  LN=LN+28 		ENDIFO CA) CP.  .  .  .  .  .  print the output lineb Co' 		CALL LIB$PUT_OUTPUT(CLV_CMDLIN(1:LN))  CN- CP.  .  .  .  .  .  clear the line indicatorsM C2 		CLV_CMDLIN=' ' 		LN=0 C H CP.  .  .  .  .  ELSEIF error was "unit exists, but you can't look" THEN Cr/ 	      ELSEIF(ILV_STATUS .EQ. SS$_DEVALLOC .OR. ,      +		     ILV_STATUS .EQ. SS$_NOPRIV)THEN C & CP.  .  .  .  .  .  zero retry counter CG 		ILV_GETFLAGS=0 C 4 CP.  .  .  .  .  .  report the unknown protocol unit CD* 		CALL SYS$FAO('!5UL: ??? (no access)',LN,&      +			     CLV_CMDLIN(17:),%VAL(I))
 		LN=LN+16' 		CALL LIB$PUT_OUTPUT(CLV_CMDLIN(1:LN))i 		CLV_CMDLIN=' ' 		LN=0 Ce CP.  .  .  .  .  ELSET CT 	      ELSED C_+ CP.  .  .  .  .  .  increment retry counterM C( 		ILV_GETFLAGS=ILV_GETFLAGS+1  C  CP.  .  .  .  .  ENDIF C_ 	      ENDIF CW CP.  .  .  .  ENDDO, CV 	      I=I+1
 	    ENDDO CO- CP.  .  .  .  IF anything left unprinted THENI CI 	    IF(LN.GT.0)THEN C + CP.  .  .  .  .  print device name and typeI CL, 	      CALL LIB$PUT_OUTPUT(CLV_CMDLIN(1:LN)) Co CP.  .  .  .  ENDIF  C 
 	    ENDIF CS CP.  .  .  ENDDO CE 	  ENDDO C.# CP.  .  .  turn off extra privilegea Ce+ 	  CALL SYS$SETPRV(%VAL(0),ILV_ITMLST(1),,)r Ce* CP.  .  .  ask for the desired device name CA? 	  ILV_STATUS=LIB$GET_COMMAND(CLV_CMDLIN,'Ethernet_port_: ',LN)=	 	  GOTO 1A C) CP.  .  ELSEIF no devices THEN C  	ELSEIF(ILV_DEVCNT.LE.0)THEN Ca CP.  .  .  abort with error_ CM% 	  CALL SYS$EXIT(%VAL(SS$_NOSUCHDEV))	 C  CP.  .  ELSE C  	ELSE  CN> CP.  .  .  print notice about selection of one-and-only device C_ 	  CALL LIB$PUT_OUTPUT(dA      +'%ETHERMON-I-ONEPORT, implicitly using the one Ethernet '//(6      +'interface '//CCVNAM_DEVNAM(1:NCVNAM_DEVNAMLEN))/ 	  CLV_CMDLIN=CCVNAM_DEVNAM(1:NCVNAM_DEVNAMLEN)P 	  LN=NCVNAM_DEVNAMLEN CF
 CP.  .  ENDIF/ CU 	ENDIF CE
 CP.  ENDIF Cr       ENDIFD CI# CP.  strip off unit number (if any)S CU-       ILV_ITMLST(1)=64+JISHFT(DVI$_DEVNAM,16)+'       ILV_ITMLST(2)=%LOC(CCVNAM_DEVNAM)n*       ILV_ITMLST(3)=%LOC(NCVNAM_DEVNAMLEN).       ILV_ITMLST(4)=4+JISHFT(DVI$_DEVCLASS,16)&       ILV_ITMLST(5)=%LOC(ILV_DEVCLASS)       ILV_ITMLST(6)=0(       ILV_ITMLST(7)=0o       ILV_STATUS=SYS$GETDVIW(,       +			     ,CLV_CMDLIN(1:LN),      +			     ILV_ITMLST,N      +			     NLV_IOSB,,,)       IF(.NOT.ILV_STATUS)THEN(  	CALL LIB$STOP(%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN! 	CALL LIB$STOP(%VAL(NLV_IOSB(0)))_*       ELSEIF(ILV_DEVCLASS.NE.DC$_SCOM)THEN# 	CALL SYS$EXIT(%VAL(SS$_NOTNETDEV))U       ENDIFC)       NCVNAM_DEVNAMLEN=NCVNAM_DEVNAMLEN-1N*       DO WHILE (NCVNAM_DEVNAMLEN.GT.0.AND.D      +		CCVNAM_DEVNAM(NCVNAM_DEVNAMLEN:NCVNAM_DEVNAMLEN).GE.'0'.AND.@      +		CCVNAM_DEVNAM(NCVNAM_DEVNAMLEN:NCVNAM_DEVNAMLEN).LE.'9')$ 	NCVNAM_DEVNAMLEN=NCVNAM_DEVNAMLEN-1       ENDDOP)       NCVNAM_DEVNAMLEN=NCVNAM_DEVNAMLEN+1 :       CCVNAM_DEVNAM(NCVNAM_DEVNAMLEN:NCVNAM_DEVNAMLEN)=':' Co CP END GET_ETHERPORT_NAMEG C(	       ENDC       SUBROUTINE INIT_ETHERNET CU& CP DATA DECLARATIONS for INIT_ETHERNET C        IMPLICIT NONE* CU C   declare local variablesR CA       CHARACTER*30 CLV_SCRATCH!       INTEGER*2 NLV_IOSB(0:3), LNRC       INTEGER*4 ILV_STATUS, ILV_ITMLST(13), ILV_TEMP, ILV_SYSID(2), <      +		I, ILV_PQL_MBYTLM, ILV_PQL_DBYTLM, ILV_DEFMBXBUFQUO,      +		ILV_BYTLMs C  C   declare local COMMON's CD!       INCLUDE 'ETHERMON_ADDR.INC'Y$       INCLUDE 'ETHERMON_BRIDGES.INC'        INCLUDE 'ETHERMON_DEV.INC'        INCLUDE 'ETHERMON_ETH.INC' C_ C   declare local procedures Co?       INTEGER*4 START_FAST_INTERFACE, FIND_ADDRSLOT, START_PORTH>       EXTERNAL	START_FAST_INTERFACE, FIND_ADDRSLOT, START_PORT C ( C   declare local symbolic message codes Ce>       EXTERNAL	ETH__PORTASNFAI, ETH__NODECNET, ETH__ERRGETSYI,8      +		ETH__ALRDYPRMUSR,ETH__CANTSTART, ETH__NOFASTSHR,4      +		ETH__NOFASTFB, ETH__HOWTOFIX, ETH__HISYSGEN,      +		ETH__LOWBYTLME C* C   declare system proceduresD CL4       INTEGER*4 SYS$ASSIGN, SYS$GETSYIW, SYS$GETJPIW3       EXTERNAL	SYS$ASSIGN, SYS$GETSYIW, SYS$GETJPIWN C ! C   declare system symbolic codesC C        EXTERNAL	NMA$C_LINFM_ETH!       INCLUDE '($JPIDEF)	/NOLIST'A!       INCLUDE '($STSDEF)	/NOLIST' !       INCLUDE '($SYIDEF)	/NOLIST' +       EXTERNAL	SS$_NOMORENODE, SS$_BADPARAMN CD CP BEGIN INIT_ETHERNET+ CP.  assign channel to Ethernet port deviceA CS>       ILV_STATUS=SYS$ASSIGN(CCVNAM_DEVNAM(1:NCVNAM_DEVNAMLEN),      +			    NCVETH_CHAN,,)e       IF(.NOT.ILV_STATUS)THEN 1 	CALL LIB$STOP(ETH__PORTASNFAI,,%VAL(ILV_STATUS))        ENDIFm Ch. CP.  assign channel to DECnet interface device C 2       NCVETH_NETIOSB(0)=1	! to permit first access       LCVETH_DECNETBUSY=.FALSE..8       ILV_STATUS=SYS$ASSIGN('_NET:',NCVETH_DECNETCHAN,,)       IF(.NOT.ILV_STATUS)THENI1 	CALL LIB$SIGNAL(ETH__NODECNET,,%VAL(ILV_STATUS))  	NCVETH_DECNETCHAN=02 	LCVETH_DECNETBUSY=.TRUE.	! to block future access       ENDIFR CT) CP.  set this program's data mode to nullV CU       ICVETH_DISPLAYMODE=0 C B CP.  fill in pre-defined constant addresses into the address table CF%       ICVADR_NUMADDRS=ICPADR_MINADDRSL3       SCVADR_ADDR(ICPADR_MAXADDRS).LNUM='FFFFFFFF'XN1       SCVADR_ADDR(ICPADR_MAXADDRS).NUM(2)='FFFF'Xt*       NCVADR_MISCNAMLEN(ICPADR_MAXADDRS)=9/       ICVADR_FLAGS(ICPADR_MAXADDRS)=ICPADR_USED_1       ICVADR_INETADR(ICPADR_MAXADDRS)='FFFFFFFF'X$1       CCVADR_MISCNAM(ICPADR_MAXADDRS)='Broadcast' %       SCVADR_ADDR(0).LNUM='000000CF'X #       SCVADR_ADDR(0).NUM(2)='0000'XA       NCVADR_MISCNAMLEN(0)=19D!       ICVADR_FLAGS(0)=ICPADR_USEDI-       CCVADR_MISCNAM(0)='Loopback Assistance'.%       SCVADR_ADDR(1).LNUM='010000AB'X #       SCVADR_ADDR(1).NUM(2)='0000'XO       NCVADR_MISCNAMLEN(1)=20 !       ICVADR_FLAGS(1)=ICPADR_USEDo4       CCVADR_MISCNAM(1)='Dump/Load Assistance'	! DEC%       SCVADR_ADDR(2).LNUM='020000AB'X #       SCVADR_ADDR(2).NUM(2)='0000'XE       NCVADR_MISCNAMLEN(2)=14+!       ICVADR_FLAGS(2)=ICPADR_USED,.       CCVADR_MISCNAM(2)='Remote Console'	! DEC%       SCVADR_ADDR(3).LNUM='030000AB'X+#       SCVADR_ADDR(3).NUM(2)='0000'XV       NCVADR_MISCNAMLEN(3)=15M!       ICVADR_FLAGS(3)=ICPADR_USED)/       CCVADR_MISCNAM(3)='Lvl 1,2 Routers'	! DECc%       SCVADR_ADDR(4).LNUM='040000AB'X+#       SCVADR_ADDR(4).NUM(2)='0000'XA       NCVADR_MISCNAMLEN(4)=12I!       ICVADR_FLAGS(4)=ICPADR_USED -       CCVADR_MISCNAM(4)='All Endnodes'		! DECD%       SCVADR_ADDR(5).LNUM='000300AB'Xc#       SCVADR_ADDR(5).NUM(2)='0000'X        NCVADR_MISCNAMLEN(5)=9!       ICVADR_FLAGS(5)=ICPADR_USED_*       CCVADR_MISCNAM(5)='LAT (old)'		! DEC%       SCVADR_ADDR(6).LNUM='012B0009'X.#       SCVADR_ADDR(6).NUM(2)='0000'XN       NCVADR_MISCNAMLEN(6)=11(!       ICVADR_FLAGS(6)=ICPADR_USEDI,       CCVADR_MISCNAM(6)='Bridge Mgmt'		! DEC%       SCVADR_ADDR(7).LNUM='022B0009'X #       SCVADR_ADDR(7).NUM(2)='0000'XE       NCVADR_MISCNAMLEN(7)=13 !       ICVADR_FLAGS(7)=ICPADR_USED .       CCVADR_MISCNAM(7)='Lvl 2 Routers'		! DEC%       SCVADR_ADDR(8).LNUM='00870009'X,#       SCVADR_ADDR(8).NUM(2)='FFFF'Xf       NCVADR_MISCNAMLEN(8)=15M!       ICVADR_FLAGS(8)=ICPADR_USED 2       CCVADR_MISCNAM(8)='Load Assistance'	! Xyplex%       SCVADR_ADDR(9).LNUM='FF00DD01'X #       SCVADR_ADDR(9).NUM(2)='FFFF'XI       NCVADR_MISCNAMLEN(9)=6!       ICVADR_FLAGS(9)=ICPADR_USEDE'       CCVADR_MISCNAM(9)='??? #3'		! U-BO&       SCVADR_ADDR(10).LNUM='022B0009'X$       SCVADR_ADDR(10).NUM(2)='0001'X       NCVADR_MISCNAMLEN(10)=19"       ICVADR_FLAGS(10)=ICPADR_USED4       CCVADR_MISCNAM(10)='DNA Name Svc Advert'	! DEC&       SCVADR_ADDR(11).LNUM='042B0009'X$       SCVADR_ADDR(11).NUM(2)='0000'X       NCVADR_MISCNAMLEN(11)=23"       ICVADR_FLAGS(11)=ICPADR_USED8       CCVADR_MISCNAM(11)='LA Sys Transport (LAST)'	! DEC&       SCVADR_ADDR(12).LNUM='232B0009'X$       SCVADR_ADDR(12).NUM(2)='0000'X       NCVADR_MISCNAMLEN(12)=16"       ICVADR_FLAGS(12)=ICPADR_USED1       CCVADR_MISCNAM(12)='Argonaut Console'	! DECV&       SCVADR_ADDR(13).LNUM='00C28001'X$       SCVADR_ADDR(13).NUM(2)='0000'X       NCVADR_MISCNAMLEN(13)=20"       ICVADR_FLAGS(13)=ICPADR_USED5       CCVADR_MISCNAM(13)='bridge spanning tree'	! ??? &       SCVADR_ADDR(14).LNUM='001E0009'X$       SCVADR_ADDR(14).NUM(2)='0000'X       NCVADR_MISCNAMLEN(14)=6 "       ICVADR_FLAGS(14)=ICPADR_USED+       CCVADR_MISCNAM(14)='DOMAIN'		! ApolloF&       SCVADR_ADDR(15).LNUM='002B0009'X$       SCVADR_ADDR(15).NUM(2)='0000'X       NCVADR_MISCNAMLEN(15)=6_"       ICVADR_FLAGS(15)=ICPADR_USED(       CCVADR_MISCNAM(15)='MUMPS?'		! DEC&       SCVADR_ADDR(16).LNUM='FF070009'X$       SCVADR_ADDR(16).NUM(2)='FFFF'X       NCVADR_MISCNAMLEN(16)=20"       ICVADR_FLAGS(16)=ICPADR_USED5       CCVADR_MISCNAM(16)='Appletalk ARP brdcst'	! ???.&       SCVADR_ADDR(17).LNUM='0001DD01'X$       SCVADR_ADDR(17).NUM(2)='0000'X       NCVADR_MISCNAMLEN(17)=19"       ICVADR_FLAGS(17)=ICPADR_USED4       CCVADR_MISCNAM(17)='spanning tree hello'	! U-B+       SCVADR_ADDR('00BC'X).LNUM='A100DD01'Xe)       SCVADR_ADDR('00BC'X).NUM(2)='00BC'X "       NCVADR_MISCNAMLEN('00BC'X)=6'       ICVADR_FLAGS('00BC'X)=ICPADR_USEDL-       CCVADR_MISCNAM('00BC'X)='??? #2'		! U-B:+       SCVADR_ADDR('00DE'X).LNUM='6800DD01'X )       SCVADR_ADDR('00DE'X).NUM(2)='00DE'XM"       NCVADR_MISCNAMLEN('00DE'X)=6'       ICVADR_FLAGS('00DE'X)=ICPADR_USED -       CCVADR_MISCNAM('00DE'X)='??? #1'		! U-BC+       SCVADR_ADDR('0100'X).LNUM='012B0009'X,)       SCVADR_ADDR('0100'X).NUM(2)='0100'XM#       NCVADR_MISCNAMLEN('0100'X)=12 '       ICVADR_FLAGS('0100'X)=ICPADR_USED32       CCVADR_MISCNAM('0100'X)='Bridge hello'	! DEC+       SCVADR_ADDR('0101'X).LNUM='04020009'XQ)       SCVADR_ADDR('0101'X).NUM(2)='0100'X'#       NCVADR_MISCNAMLEN('0101'X)=12A'       ICVADR_FLAGS('0101'X)=ICPADR_USED_6       CCVADR_MISCNAM('0101'X)='printer msgs'		! Bridge+       SCVADR_ADDR('0102'X).LNUM='047C0009'XR)       SCVADR_ADDR('0102'X).NUM(2)='0100'XN#       NCVADR_MISCNAMLEN('0102'X)=14P'       ICVADR_FLAGS('0102'X)=ICPADR_USED :       CCVADR_MISCNAM('0102'X)='bridge logging'		! Vitalink+       SCVADR_ADDR('0103'X).LNUM='022B0009'XT)       SCVADR_ADDR('0103'X).NUM(2)='0101'X #       NCVADR_MISCNAMLEN('0103'X)=20t'       ICVADR_FLAGS('0103'X)=ICPADR_USEDD:       CCVADR_MISCNAM('0103'X)='DNA Name Svc Solicit'	! DEC+       SCVADR_ADDR('0104'X).LNUM='017C0009'XA)       SCVADR_ADDR('0104'X).NUM(2)='0100'XI#       NCVADR_MISCNAMLEN('0104'X)=13 '       ICVADR_FLAGS('0104'X)=ICPADR_USEDN9       CCVADR_MISCNAM('0104'X)='DLS Multicast'		! Vitalink +       SCVADR_ADDR('0105'X).LNUM='00090009'XI)       SCVADR_ADDR('0105'X).NUM(2)='0100'XF"       NCVADR_MISCNAMLEN('0105'X)=5'       ICVADR_FLAGS('0105'X)=ICPADR_USEDL-       CCVADR_MISCNAM('0105'X)='Probe'			! H-Ph+       SCVADR_ADDR('0106'X).LNUM='002B0009'Xd)       SCVADR_ADDR('0106'X).NUM(2)='0100'X "       NCVADR_MISCNAMLEN('0106'X)=8'       ICVADR_FLAGS('0106'X)=ICPADR_USEDP/       CCVADR_MISCNAM('0106'X)='DSM/DTP?'		! DECl+       SCVADR_ADDR('0107'X).LNUM='00770009'XI)       SCVADR_ADDR('0107'X).NUM(2)='0100'X=#       NCVADR_MISCNAMLEN('0107'X)=20-'       ICVADR_FLAGS('0107'X)=ICPADR_USEDI<       CCVADR_MISCNAM('0107'X)='bridge spanning tree'	! Retix+       SCVADR_ADDR('0108'X).LNUM='057C0009'X )       SCVADR_ADDR('0108'X).NUM(2)='0100'XD"       NCVADR_MISCNAMLEN('0108'X)=8'       ICVADR_FLAGS('0108'X)=ICPADR_USEDq4       CCVADR_MISCNAM('0108'X)='gateway?'		! Vitalink+       SCVADR_ADDR('0200'X).LNUM='04020009'XI)       SCVADR_ADDR('0200'X).NUM(2)='0200'Xe#       NCVADR_MISCNAMLEN('0200'X)=22r'       ICVADR_FLAGS('0200'X)=ICPADR_USEDD?       CCVADR_MISCNAM('0200'X)='All Bridges (DBD/DSTD)'	! Bridgen+       SCVADR_ADDR('0201'X).LNUM='057C0009'X()       SCVADR_ADDR('0201'X).NUM(2)='0200'XN#       NCVADR_MISCNAMLEN('0201'X)=18D'       ICVADR_FLAGS('0201'X)=ICPADR_USEDA=       CCVADR_MISCNAM('0201'X)='Network Validation'	! VitalinkM+       SCVADR_ADDR('0202'X).LNUM='017C0009'X0)       SCVADR_ADDR('0202'X).NUM(2)='0200'X)#       NCVADR_MISCNAMLEN('0202'X)=19 '       ICVADR_FLAGS('0202'X)=ICPADR_USED >       CCVADR_MISCNAM('0202'X)='DLS Hello Multicast'	! Vitalink+       SCVADR_ADDR('0203'X).LNUM='022B0009'XB)       SCVADR_ADDR('0203'X).NUM(2)='0201'X #       NCVADR_MISCNAMLEN('0203'X)=17 '       ICVADR_FLAGS('0203'X)=ICPADR_USEDN7       CCVADR_MISCNAM('0203'X)='DNA Time Service?'	! DECV*       SCVADR_ADDR('300'X).LNUM='002B0009'X(       SCVADR_ADDR('300'X).NUM(2)='0300'X"       NCVADR_MISCNAMLEN('300'X)=19&       ICVADR_FLAGS('300'X)=ICPADR_USED8       CCVADR_MISCNAM('300'X)='LAN Traffic Monitor'	! DEC+       SCVADR_ADDR('0301'X).LNUM='017C0009'XE)       SCVADR_ADDR('0301'X).NUM(2)='0300'X #       NCVADR_MISCNAMLEN('0301'X)=22='       ICVADR_FLAGS('0301'X)=ICPADR_USED)A       CCVADR_MISCNAM('0301'X)='DLS Inlink Hello Multi'	! Vitalink2+       SCVADR_ADDR('0400'X).LNUM='002B0009'XE)       SCVADR_ADDR('0400'X).NUM(2)='0400'X.#       NCVADR_MISCNAMLEN('0400'X)=20V'       ICVADR_FLAGS('0400'X)=ICPADR_USED':       CCVADR_MISCNAM('0400'X)='MAP End-System Hello'	! DEC+       SCVADR_ADDR('0401'X).LNUM='017C0009'Xe)       SCVADR_ADDR('0401'X).NUM(2)='0400'X.#       NCVADR_MISCNAMLEN('0401'X)=21 '       ICVADR_FLAGS('0401'X)=ICPADR_USEDn@       CCVADR_MISCNAM('0401'X)='DLS/Non-DLS Multicast'	! Vitalink+       SCVADR_ADDR('0402'X).LNUM='00090009'X )       SCVADR_ADDR('0402'X).NUM(2)='0400'XI"       NCVADR_MISCNAMLEN('0402'X)=3'       ICVADR_FLAGS('0402'X)=ICPADR_USEDt+       CCVADR_MISCNAM('0402'X)='DTC'			! H-P +       SCVADR_ADDR('0500'X).LNUM='002B0009'X )       SCVADR_ADDR('0500'X).NUM(2)='0500'X(#       NCVADR_MISCNAMLEN('0500'X)=26 '       ICVADR_FLAGS('0500'X)=ICPADR_USED @       CCVADR_MISCNAM('0500'X)='MAP Intermediate-Sys Hello'	! DEC+       SCVADR_ADDR('0501'X).LNUM='027C0009'X	)       SCVADR_ADDR('0501'X).NUM(2)='0500'X #       NCVADR_MISCNAMLEN('0501'X)=11 '       ICVADR_FLAGS('0501'X)=ICPADR_USED 7       CCVADR_MISCNAM('0501'X)='diagnostics'		! Vitalink +       SCVADR_ADDR('0600'X).LNUM='002B0009'X )       SCVADR_ADDR('0600'X).NUM(2)='0600'XE#       NCVADR_MISCNAMLEN('0600'X)=18('       ICVADR_FLAGS('0600'X)=ICPADR_USED)8       CCVADR_MISCNAM('0600'X)='CSMA/CD Encryption'	! DEC+       SCVADR_ADDR('0700'X).LNUM='002B0009'Xl)       SCVADR_ADDR('0700'X).NUM(2)='0700'XD#       NCVADR_MISCNAMLEN('0700'X)=23 '       ICVADR_FLAGS('0700'X)=ICPADR_USED.=       CCVADR_MISCNAM('0700'X)='NetBIOS Emulator (PCSG)'	! DECYD       SCVADR_ADDR('0F00'X).LNUM='002B0009'X	! fix index if enlarging9       SCVADR_ADDR('0F00'X).NUM(2)='0F00'X	! address tableI#       NCVADR_MISCNAMLEN('0F00'X)=11I'       ICVADR_FLAGS('0F00'X)=ICPADR_USED.1       CCVADR_MISCNAM('0F00'X)='LAT (LANCE)'	! DEC  C  CP.  get system name Cr/       ILV_ITMLST(1)=32+JISHFT(SYI$_NODENAME,16)S'       ILV_ITMLST(2)=%LOC(CCVNAM_SYSNAM)h*       ILV_ITMLST(3)=%LOC(NCVNAM_SYSNAMLEN)4       ILV_ITMLST(4)=1+JISHFT(SYI$_CLUSTER_MEMBER,16)"       ILV_ITMLST(5)=%LOC(ILV_TEMP)       ILV_ITMLST(6)=0 1       ILV_ITMLST(7)=4+JISHFT(SYI$_SCSSYSTEMID,16)+&       ILV_ITMLST(8)=%LOC(ILV_SYSID(2))       ILV_ITMLST(9)=0O@       ILV_ITMLST(10)=JISHFT(SYI$_VERSION,16)+LEN(CCVNAM_SYSVERS))       ILV_ITMLST(11)=%LOC(CCVNAM_SYSVERS)6)       ILV_ITMLST(12)=%LOC(NCVNAM_SYSVERS)E       ILV_ITMLST(13)=0       ILV_SYSID(1)='000400AA'X6       ILV_STATUS=SYS$GETSYIW(,,,ILV_ITMLST,NLV_IOSB,,)       IF(.NOT.ILV_STATUS)THENN0 	CALL LIB$STOP(ETH__ERRGETSYI,,%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN1 	CALL LIB$STOP(ETH__ERRGETSYI,,%VAL(NLV_IOSB(0)))_       ENDIF	 CA% CP.  IF system name is not blank THEN, C_6       IF(CCVNAM_SYSNAM(1:NCVNAM_SYSNAMLEN).NE.' ')THEN C	9 CP.  .  IF DECnet is available and system ID defined THEN, CB 	IF(NCVETH_DECNETCHAN.NE.0.AND.        +	   ILV_SYSID(2).NE.0)THEN C+- CP.  .  .  add physical address to known list) C $ 	  I=FIND_ADDRSLOT(ILV_SYSID,.TRUE.) 	  IF(I.GE.0)THEN : 	    CCVADR_DECNETNAM(I)=CCVNAM_SYSNAM(1:NCVNAM_SYSNAMLEN), 	    NCVADR_DECNETNAMLEN(I)=NCVNAM_SYSNAMLEN. 	    ICVADR_FLAGS(I)=ICPADR_USED+ICPADR_DECNET 	    ICVBRG_ADDRPTR(0)=I 	  ENDIF C)
 CP.  .  ENDIF  C	 	ENDIF C	
 CP.  ENDIF CN       ENDIFM CN- CP.  IF node is a member of a VAXcluster THENC CT       IF(ILV_TEMP)THEN C  CP.  .  REPEAT CT
 	ILV_STATUS=1M 	NLV_IOSB(0)=1 	ILV_TEMP=-1	! wildcard CSID& 	DO WHILE (ILV_STATUS.AND.NLV_IOSB(0)) C	# CP.  .  .  get node number and name  C , 	  ILV_ITMLST(1)=30+JISHFT(SYI$_NODENAME,16)" 	  ILV_ITMLST(2)=%LOC(CLV_SCRATCH) 	  ILV_ITMLST(3)=%LOC(LN)M0 	  ILV_ITMLST(4)=4+JISHFT(SYI$_NODE_SYSTEMID,16)# 	  ILV_ITMLST(5)=%LOC(ILV_SYSID(2))  	  ILV_ITMLST(6)=0 	  ILV_ITMLST(7)=0; 	  ILV_STATUS=SYS$GETSYIW(,ILV_TEMP,,ILV_ITMLST,NLV_IOSB,,)E 	  IF(.NOT.ILV_STATUS.AND.3      +	     ILV_STATUS.NE.%LOC(SS$_NOMORENODE))THENS4 	    CALL LIB$STOP(ETH__ERRGETSYI,,%VAL(ILV_STATUS)) 	  ELSEIF(.NOT.NLV_IOSB(0).AND. 1      +		 NLV_IOSB(0).NE.%LOC(SS$_NOMORENODE))THEN,5 	    CALL LIB$STOP(ETH__ERRGETSYI,,%VAL(NLV_IOSB(0)))1 	  ENDIF C_K CP.  .  .  add entry to address table (assuming cluster DECnet is Ethernet)  C.$ 	  I=FIND_ADDRSLOT(ILV_SYSID,.TRUE.) 	  IF(I.GE.0)THENG* 	    CCVADR_DECNETNAM(I)=CLV_SCRATCH(1:LN) 	    NCVADR_DECNETNAMLEN(I)=LN 	    CCVADR_MISCNAM(I)='vc'  	    NCVADR_MISCNAMLEN(I)=2a. 	    ICVADR_FLAGS(I)=ICPADR_USED+ICPADR_DECNET 	  ENDIF CP/ CP.  .  UNTIL all nodes in cluster interrogated  C  	ENDDO CU
 CP.  ENDIF CD       ENDIFo CP; CP.  IF attempt to activate fast $QIO interface failed THEN  CE(       ILV_STATUS=START_FAST_INTERFACE(0)       IF(.NOT.ILV_STATUS)THENA C)$ CP.  .  compute error message vector Cr 	ILV_ITMLST(3)=0 	ILV_ITMLST(4)=ILV_STATUSI* 	IF(IAND(ILV_STATUS,'FFFF0000'X).EQ.0)THEN$ 	  ILV_ITMLST(5)=%LOC(ETH__HOWTOFIX) 	  ILV_ITMLST(1)=4 	ELSE( 	  ILV_ITMLST(5)=0$ 	  ILV_ITMLST(6)=%LOC(ETH__HOWTOFIX) 	  ILV_ITMLST(1)=5 	ENDIF CU; CP.  .  IF operating system version is V5.4-3 or above THENn Cc$ 	IF(((CCVNAM_SYSVERS(1:1).EQ.'V'.OR.,      +	     CCVNAM_SYSVERS(1:1).EQ.'T').AND..      +	    CCVNAM_SYSVERS(2:6).GE.'5.4-3').OR.)      +	   CCVNAM_SYSVERS(1:1).NE.'V'.AND.:)      +	   CCVNAM_SYSVERS(1:1).NE.'T')THENV C(" CP.  .  .  abort with failure code CA% 	  ILV_ITMLST(2)=%LOC(ETH__NOFASTSHR)E! 	  CALL SYS$PUTMSG(ILV_ITMLST,,,) < 	  CALL SYS$EXIT(%VAL(%LOC(ETH__NOFASTSHR)+STS$M_INHIB_MSG)) CJ CP.  .  ELSE C, 	ELSE  C   CP.  .  .  print warning message C $ 	  ILV_ITMLST(2)=%LOC(ETH__NOFASTFB)! 	  CALL SYS$PUTMSG(ILV_ITMLST,,,)I CE
 CP.  .  ENDIF  CL 	ENDIF C=	 CP.  ELSEV CS
       ELSE CT2 CP.  .  mark fast interface as interface of choice CS 	LCVETH_FASTQIO=.TRUE. CC
 CP.  ENDIF C,       ENDIF  CL0 CP.  get Ethernet or FDDI interface's attributes C.       CALL GET_PORT_STATUS CPK CP.  get process's available & allowable BYTLM quota & compute buffer countL CO0       ILV_ITMLST(1)=JISHFT(SYI$_PQL_MBYTLM,16)+4(       ILV_ITMLST(2)=%LOC(ILV_PQL_MBYTLM)       ILV_ITMLST(3)=0N0       ILV_ITMLST(4)=JISHFT(SYI$_PQL_DBYTLM,16)+4(       ILV_ITMLST(5)=%LOC(ILV_PQL_DBYTLM)       ILV_ITMLST(6)=0N2       ILV_ITMLST(7)=JISHFT(SYI$_DEFMBXBUFQUO,16)+4*       ILV_ITMLST(8)=%LOC(ILV_DEFMBXBUFQUO)       ILV_ITMLST(9)=0N       ILV_ITMLST(10)=06       ILV_STATUS=SYS$GETSYIW(,,,ILV_ITMLST,NLV_IOSB,,)       IF(.NOT.ILV_STATUS)THENN0 	CALL LIB$STOP(ETH__ERRGETSYI,,%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN1 	CALL LIB$STOP(ETH__ERRGETSYI,,%VAL(NLV_IOSB(0)))T       ENDIF (       IF(ILV_DEFMBXBUFQUO .GT. 4096 .OR.:      +	 MAX(ILV_PQL_MBYTLM,ILV_PQL_DBYTLM) .GT. 16384)THEN> 	CALL LIB$SIGNAL(ETH__HISYSGEN,%VAL(3),%VAL(ILV_DEFMBXBUFQUO),4      +				%VAL(ILV_PQL_MBYTLM),%VAL(ILV_PQL_DBYTLM))       ENDIFY7       ILV_PQL_MBYTLM=MAX(ILV_PQL_MBYTLM,ILV_PQL_DBYTLM)r=      +			+ILV_DEFMBXBUFQUO+1100	! free bytlm needed for SPAWN 3      +			+(ICVETH_MBS+50)	! bytlm for Ethernet readO:      +			+4*(ICVETH_MBS+50)	! bytlm for analyzer write mbx0      +			+4*512			! bytlm for analyzer SYS$ERROR-      +			+252			! bytlm for analyzer term mbxX,       ILV_ITMLST(1)=JISHFT(JPI$_BYTCNT,16)+4#       ILV_ITMLST(2)=%LOC(ILV_BYTLM)l       ILV_ITMLST(3)=0        ILV_ITMLST(4)=0S6       ILV_STATUS=SYS$GETJPIW(,,,ILV_ITMLST,NLV_IOSB,,)       IF(.NOT.ILV_STATUS)THENA  	CALL LIB$STOP(%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN! 	CALL LIB$STOP(%VAL(NLV_IOSB(0)))t       ENDIFD=       IF(ILV_BYTLM.LT.(ILV_PQL_MBYTLM+1*(ICVETH_MBS+50)))THEN 5 	CALL LIB$STOP(ETH__LOWBYTLM,%VAL(2),%VAL(ILV_BYTLM), 1      +				%VAL(ILV_PQL_MBYTLM+1*(ICVETH_MBS+50)))LA       ELSEIF(ILV_BYTLM.LT.(ILV_PQL_MBYTLM+6*(ICVETH_MBS+50)))THEN 7 	CALL LIB$SIGNAL(ETH__LOWBYTLM,%VAL(2),%VAL(ILV_BYTLM), 1      +				%VAL(ILV_PQL_MBYTLM+6*(ICVETH_MBS+50)))P       ENDIFT8       ICVETH_NUMBUFS=MIN(MAX((ILV_BYTLM-ILV_PQL_MBYTLM)/=      +				(ICVETH_MBS+50),1),127) ! compute number of buffers  C  CP.  start the Ethernet port CFE       ILV_STATUS=START_PORT(2,ILV_ITMLST(1))	! just to clear PAD flag)       CALL STOP_PORT1       ILV_STATUS=START_PORT(.TRUE.,ILV_ITMLST(1))        IF(.NOT.ILV_STATUS)THENp= 	ILV_STATUS=START_PORT(2,ILV_ITMLST(1))	! V5.x w/o IEEE 802.3_       ENDIFS       IF(.NOT.ILV_STATUS)THEN)< 	ILV_STATUS=START_PORT(0,ILV_ITMLST(1))	! V4.x compatibility       ENDIFS.       IF(ILV_STATUS.EQ.%LOC(SS$_BADPARAM))THEN  	CALL SYS$EXIT(ETH__ALRDYPRMUSR)!       ELSEIF(.NOT.ILV_STATUS)THENr: 	CALL LIB$STOP(ETH__CANTSTART,%VAL(1),%VAL(ILV_ITMLST(1)),      +		      %VAL(ILV_STATUS))t       ENDIF  Co CP.  get initial port status CA       CALL GET_PORT_STATUS        ICVETH_INIT_FMT=ICVETH_FMT CL% CP.  IF system name is not blank THENA CM6       IF(CCVNAM_SYSNAM(1:NCVNAM_SYSNAMLEN).NE.' ')THEN CXN CP.  .  IF hardware Ethernet address defined and not the same as physical THEN CP 	IF(.NOT.NCVETH_HWA(0).AND. -      +	   NCVETH_HWA(1).NE.NCVETH_PHA(1).AND. -      +	   NCVETH_HWA(2).NE.NCVETH_PHA(2))THEN  CA- CP.  .  .  add hardware address to known listM C(% 	  I=FIND_ADDRSLOT(NCVETH_HWA,.TRUE.)E 	  IF(I.GE.0)THENS: 	    CCVADR_DECNETNAM(I)=CCVNAM_SYSNAM(1:NCVNAM_SYSNAMLEN), 	    NCVADR_DECNETNAMLEN(I)=NCVNAM_SYSNAMLEN 	    CCVADR_MISCNAM(I)='hdwr'2 	    NCVADR_MISCNAMLEN(I)=4A 	  ENDIF C 
 CP.  .  ENDIFM C= 	ENDIF CA
 CP.  ENDIF CC       ENDIFR CDO CP.  find address slot for actual physical address (not necessarily DECnet) andM CP		store it in bridge table C=(       I=FIND_ADDRSLOT(NCVETH_PHA,.TRUE.)       ICVBRG_ADDRPTR(0)=IC CR CP.  start read AST's' C        IF(LCVETH_FASTQIO)THEN 	CALL QUEUE_ETHER_READ_FASTE5       ELSEIF(ICVETH_FMT.EQ.%LOC(NMA$C_LINFM_ETH))THENA 	CALL QUEUE_ETHER_READ_ETH
       ELSE 	CALL QUEUE_ETHER_READ_IEEE0       ENDIF  CC CP.  RETURNN C2       RETURN C  CP END INIT_ETHERNET C 	       ENDR9       INTEGER*4 FUNCTION START_PORT(LLA_MODE,ILA_DEVCHAR)e C	# CP DATA DECLARATIONS for START_PORT0 CA       IMPLICIT NONED C)  C   declare subroutine arguments CM       INTEGER*4 ILA_DEVCHAR5       LOGICAL*1 LLA_MODE CM C   declare local variables  C 1       INTEGER*2 NLV_INITETH_P2(18), NLV_IOSB(0:3)D:       INTEGER*4 ILV_STATUS, ILV_ITMLST(10), ILV_DESCR(0:1) CA C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' CC C   declare system procedures2 C0       INTEGER*4 SYS$QIOW       EXTERNAL	SYS$QIOWC CR! C   declare system symbolic codesA C7!       INCLUDE '($IODEF)		/NOLIST'M>       EXTERNAL	NMA$C_PCLI_PRM, NMA$C_PCLI_MLT, NMA$C_PCLI_PTY,7      +		NMA$C_PCLI_PAD, NMA$C_PCLI_BUS, NMA$C_PCLI_BFN,S      +		NMA$C_STATE_OFFAG       EXTERNAL	NMA$C_PCLI_FMT, NMA$C_LINFM_802E, NMA$C_LINFM_ETH	! V5.xl       EXTERNAL	SS$_NOMORENODEF CD CP BEGIN START_PORTA6 CP.  initialize device as promiscuous Ethernet monitor C ,       NLV_INITETH_P2(1)=%LOC(NMA$C_PCLI_PRM)       NLV_INITETH_P2(2)=0        NLV_INITETH_P2(3)=02,       NLV_INITETH_P2(4)=%LOC(NMA$C_PCLI_MLT)       NLV_INITETH_P2(5)=00       NLV_INITETH_P2(6)=0),       NLV_INITETH_P2(7)=%LOC(NMA$C_PCLI_BFN)&       NLV_INITETH_P2(8)=ICVETH_NUMBUFS       NLV_INITETH_P2(9)=0 -       NLV_INITETH_P2(10)=%LOC(NMA$C_PCLI_BUS)S#       NLV_INITETH_P2(11)=ICVETH_MBS)       NLV_INITETH_P2(12)=0        IF(LLA_MODE)THEN				! V5.x/ 	NLV_INITETH_P2(13)=%LOC(NMA$C_PCLI_FMT)	! V5.x 1 	NLV_INITETH_P2(14)=%LOC(NMA$C_LINFM_802E) ! V5.xM 	NLV_INITETH_P2(15)=0  	ILV_DESCR(0)=30(       ELSEIF(LLA_MODE.NE.0)THEN			! V5.x/ 	NLV_INITETH_P2(13)=%LOC(NMA$C_PCLI_FMT)	! V5.x'0 	NLV_INITETH_P2(14)=%LOC(NMA$C_LINFM_ETH) ! V5.x 	NLV_INITETH_P2(15)=0(( 	NLV_INITETH_P2(16)=%LOC(NMA$C_PCLI_PAD)) 	NLV_INITETH_P2(17)=%LOC(NMA$C_STATE_OFF)  	NLV_INITETH_P2(18)=0A 	ILV_DESCR(0)=36#       ELSE					! V4.x compatibility(( 	NLV_INITETH_P2(13)=%LOC(NMA$C_PCLI_PAD)) 	NLV_INITETH_P2(14)=%LOC(NMA$C_STATE_OFF)  	NLV_INITETH_P2(15)=0A( 	NLV_INITETH_P2(16)=%LOC(NMA$C_PCLI_PTY) 	NLV_INITETH_P2(17)='FFFF'XD 	NLV_INITETH_P2(18)=0  	ILV_DESCR(0)=36				! V4.x       ENDIFR'       ILV_DESCR(1)=%LOC(NLV_INITETH_P2)N       ILA_DEVCHAR=0C       ILV_STATUS=SYS$QIOW(,'      +			  %VAL(NCVETH_CHAN),64      +			  %VAL(IO$_SETCHAR+IO$M_CTRL+IO$M_STARTUP),      +			  NLV_IOSB,,,      +			  ,      +			  %REF(ILV_DESCR),,,,)        IF(.NOT.ILV_STATUS)THEND 	START_PORT=ILV_STATUS
       ELSE 	START_PORT=NLV_IOSB(0) B 	ILA_DEVCHAR=IOR(JISHFT(JZEXT(NLV_IOSB(3)),16),JZEXT(NLV_IOSB(2)))& 	IF(NLV_IOSB(0)) LCVETH_STARTED=.TRUE.       ENDIF  C  CP.  RETURN( CB       RETURN C0 CP END START_PORTA C(	       ENDM       SUBROUTINE STOP_PORT CN" CP DATA DECLARATIONS for STOP_PORT C0       IMPLICIT NONE  C  C   declare local variables# C	       INTEGER*2 NLV_IOSB(0:3)'       INTEGER*4 ILV_STATUS CA C   declare local COMMON's CM        INCLUDE 'ETHERMON_ETH.INC' C  C   declare system proceduresA CU       INTEGER*4 SYS$QIOW       EXTERNAL	SYS$QIOWC C ! C   declare system symbolic codes0 C'!       INCLUDE '($IODEF)		/NOLIST'2 C0 CP BEGIN STOP_PORT CP.  shut down device  C        LCVETH_STARTED=.FALSE.       ILV_STATUS=SYS$QIOW(,M      +			  %VAL(NCVETH_CHAN), 5      +			  %VAL(IO$_SETCHAR+IO$M_CTRL+IO$M_SHUTDOWN),A      +			  NLV_IOSB,,,      +			  ,,,,,)A       IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))"       ELSEIF(.NOT.NLV_IOSB(0))THEN# 	CALL LIB$SIGNAL(%VAL(NLV_IOSB(0)))D       ENDIFU)       CALL SYS$CANTIM(%VAL(1500),%VAL(3))N C2 CP.  RETURN  C        RETURN C( CP END STOP_PORT CC	       END'        SUBROUTINE GET_PORT_STATUS CS( CP DATA DECLARATIONS for GET_PORT_STATUS C        IMPLICIT NONE' CL C   declare local variablesR CD! D     CHARACTER*128 CLV_UNKETHCHRC D     INTEGER*2 LN'       INTEGER*2 NLV_IOSB(0:3), NLV_CHARA5       INTEGER*4 ILV_STATUS, ILV_DESCRIPTOR(0:1), I, Jo Ci C   declare local COMMON's C0        INCLUDE 'ETHERMON_ETH.INC' CA( C   declare local symbolic message codes CS D      EXTERNAL	ETH__UNKETHCHR CF C   declare system procedures  CC#       INTEGER*4 SYS$QIOW,	LIB$EXTZV	"       EXTERNAL	SYS$QIOW,	LIB$EXTZV C)! C   declare system symbolic codesD C0       INCLUDE '($IODEF)'>       EXTERNAL	NMA$C_PCLI_HWA,	NMA$C_PCLI_BUS,	NMA$C_PCLI_BFN,7      +		NMA$C_PCLI_BSZ,	NMA$C_PCLI_PHA,	NMA$C_PCLI_PRM,h7      +		NMA$C_PCLI_MLT,	NMA$C_PCLI_PAD,	NMA$C_PCLI_EKO,A7      +		NMA$C_PCLI_CRC,	NMA$C_PCLI_PTY, NMA$C_PCLI_DCH,(7      +		NMA$C_PCLI_CON,	NMA$C_PCLI_ACC,	NMA$C_PCLI_DES, '      +		NMA$C_PCLI_MCA, NMA$C_PCLI_MBS,E&      +		NMA$C_PCLI_RES, NMA$C_PCLI_ILPE       EXTERNAL	NMA$C_PCLI_FMT, NMA$C_PCLI_PID, NMA$C_PCLI_SAP,	! V5.xN>      +		NMA$C_PCLI_SRV, NMA$C_PCLI_GSP, NMA$C_PCLI_MED,	! V5.xE      +		NMA$C_PCLI_CCA, NMA$C_PCLI_APC, NMA$C_LINMD_CSMACD, ! V5.4-3+R%      +		NMA$C_LINMD_FDDI				! V5.4-3+        EXTERNAL	SS$_NORMAL= C0 CP BEGIN GET_PORT_STATUS* CP.  build extended characteristics buffer CA,       ILV_DESCRIPTOR(0)=ICPETH_CHARBUFSIZE_B/       ILV_DESCRIPTOR(1)=%LOC(BCSETH_CHARBUF(1))= C0. CP.  query DEUNA/DEQNA for its characteristics Ce6       ILV_STATUS=SYS$QIOW(%VAL(0),		! use scratch EFN,:      +			  %VAL(NCVETH_CHAN),	! specify channel to device,<      +			  %VAL(IO$_SENSEMODE+IO$M_CTRL),! specify function,6      +			  %REF(NLV_IOSB),	! specify I/O status block,!      +			  ,,			! specify no AST,)G      +			  %REF(SCVETH_CHARBUF),	! specify primary characteristics buf,1>      +			  %REF(ILV_DESCRIPTOR), ! specify extended char. buf,/      +			  ,,,)			! specify no more parameters.M       IF(.NOT.ILV_STATUS)THENN" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))1       ELSEIF(NLV_IOSB(0).NE.%LOC(SS$_NORMAL))THEN2# 	CALL LIB$SIGNAL(%VAL(NLV_IOSB(0))) 
       ELSE 	NCVETH_NUMMCA=-1=	 	DO I=0,5B 	  BCVETH_HWA(I)=-10 	  BCVETH_PHA(I)=-1  	  BCVETH_DES(I)=-1M 	  BCVETH_MCA(I)=-1  	  BCVETH_PID(I)=-1X 	ENDDO 	ICVETH_APC=-1 	ICVETH_BUS=-1 	ICVETH_BFN=-1 	ICVETH_BSZ=-1 	ICVETH_CCA=-1 	ICVETH_DCH=-1 	ICVETH_FMT=-1 	ICVETH_PRM=-1  	ICVETH_MED=10	! assume Ethernet 	DCVETH_SPEED=10.0D+69 	ICVETH_MLT=-1 	ICVETH_PAD=-1 	ICVETH_EKO=-1 	ICVETH_CRC=-1 	ICVETH_CON=-1 	ICVETH_ACC=-1 	ICVETH_MBS=-1 	ICVETH_RES=-1 	ICVETH_SAP=-1 	ICVETH_GSP=-1 	ICVETH_SRV=-1 	I=1 	DO WHILE (I.LT.NLV_IOSB(1))- 	  NLV_CHAR=LIB$EXTZV(0,16,BCSETH_CHARBUF(I))A3 	  IF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_HWA)+'1000'X)THENe
 	    DO J=0,5t* 	      BCVETH_HWA(J)=BCSETH_CHARBUF(I+4+J)
 	    ENDDO 	    I=I+10D/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_BUS))THENE3 	    ICVETH_BUS=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))E
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_BFN))THENC3 	    ICVETH_BFN=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2)) 
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_BSZ))THEN(3 	    ICVETH_BSZ=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))n
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_DCH))THENa3 	    ICVETH_DCH=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2)) 
 	    I=I+67 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_PHA)+'1000'X)THEN0
 	    DO J=0,5C* 	      BCVETH_PHA(J)=BCSETH_CHARBUF(I+4+J)
 	    ENDDO 	    I=I+10	/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_PRM))THEN03 	    ICVETH_PRM=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2)) 
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_MLT))THEN=3 	    ICVETH_MLT=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))r
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_PAD))THEN73 	    ICVETH_PAD=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2)) 
 	    I=I+6. 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_EKO).OR..      +		 NLV_CHAR.EQ.%LOC(NMA$C_PCLI_ILP))THEN3 	    ICVETH_EKO=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))'
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_MED))THEN'3 	    ICVETH_MED=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))R
 	    I=I+63 	    IF(ICVETH_MED.EQ.%LOC(NMA$C_LINMD_CSMACD))THEN/ 	      DCVETH_SPEED=10.0D+6C5 	    ELSEIF(ICVETH_MED.EQ.%LOC(NMA$C_LINMD_FDDI))THEN( 	      DCVETH_SPEED=100.0D+6
 	    ENDIF/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_APC))THEN=3 	    ICVETH_APC=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))E
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_CCA))THEN03 	    ICVETH_CCA=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))0
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_CRC))THEN(3 	    ICVETH_CRC=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2)).
 	    I=I+66 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_FMT))THEN ! V5.x= 	    ICVETH_FMT=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))	   ! V5.xS 	    I=I+6						   ! V5.xC6 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_GSP))THEN ! V5.x= 	    ICVETH_GSP=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))	   ! V5.x  	    I=I+6						   ! V5.x)6 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_SAP))THEN ! V5.x= 	    ICVETH_SAP=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))	   ! V5.x  	    I=I+6						   ! V5.x 6 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_SRV))THEN ! V5.x= 	    ICVETH_SRV=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))	   ! V5.xT 	    I=I+6						   ! V5.x > 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_PID)+'1000'X)THEN ! V5.x 	    DO J=0,4						! V5.x_2 	      BCVETH_PID(J)=BCSETH_CHARBUF(I+4+J)		! V5.x 	    ENDDO						! V5.x 	    I=I+9						! V5.x/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_PTY))THENT
 	    DO J=1,4Y* 	      BCVETH_PTY(J)=BCSETH_CHARBUF(I+1+J)
 	    ENDDO
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_CON))THEN_3 	    ICVETH_CON=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))l
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_ACC))THENE3 	    ICVETH_ACC=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2)).
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_MBS))THENL3 	    ICVETH_MBS=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))_
 	    I=I+6/ 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_RES))THENE3 	    ICVETH_RES=LIB$EXTZV(0,32,BCSETH_CHARBUF(I+2))I
 	    I=I+67 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_DES)+'1000'X)THEN 
 	    DO J=0,5 * 	      BCVETH_DES(J)=BCSETH_CHARBUF(I+4+J)
 	    ENDDO 	    I=I+10r7 	  ELSEIF(NLV_CHAR.EQ.%LOC(NMA$C_PCLI_MCA)+'1000'X)THENP6 	    NCVETH_NUMMCA=LIB$EXTZV(0,16,BCSETH_CHARBUF(I+2)) 	    DO J=0,NCVETH_NUMMCA-1H* 	      BCVETH_MCA(J)=BCSETH_CHARBUF(I+4+J)
 	    ENDDO 	    I=I+4+NCVETH_NUMMCA* 	  ELSEIF(IAND(NLV_CHAR,'1000'X).NE.0)THENC D	    CALL SYS$FAOL('ln=!UW:',LN,CLV_UNKETHCHR,BCSETH_CHARBUF(I+2))V/ D	    DO J=1,MIN(ZEXT(BCSETH_CHARBUF(I+2)),100)V0 D	      CALL OTS$CVT_L_TZ(BCSETH_CHARBUF(I+3+J),) D    +				CLV_UNKETHCHR(LN+2*J-1:LN+2*J),S D    +				%VAL(2),%VAL(1)) D	    ENDDO 0 D	    LN=LN+2*MIN(ZEXT(BCSETH_CHARBUF(I+2)),100)< D	    CALL LIB$SIGNAL(ETH__UNKETHCHR,%VAL(2),%VAL(NLV_CHAR), D    +				CLV_UNKETHCHR(1:LN))$ 	    I=I+4+ZEXT(BCSETH_CHARBUF(I+2)) 	  ELSE.? D	    CALL SYS$FAOL('!XL',LN,CLV_UNKETHCHR,BCSETH_CHARBUF(I+2))A< D	    CALL LIB$SIGNAL(ETH__UNKETHCHR,%VAL(2),%VAL(NLV_CHAR), D    +				CLV_UNKETHCHR(1:LN))
 	    I=I+6 	  ENDIF 	ENDDO       ENDIFS CD CP.  RETURNI C.       RETURN CC CP END GET_PORT_STATUS CT	       END -       SUBROUTINE GET_PORT_COUNTERS(LLA_CLEAR)A C)* CP DATA DECLARATIONS for GET_PORT_COUNTERS CD       IMPLICIT NONED CP  C   declare subroutine arguments CI       LOGICAL*1 LLA_CLEARr Ca C   declare local variablesD C '       INTEGER*2 NLV_IOSB(0:3), NLV_FUNCa2       INTEGER*4 ILV_STATUS, ILV_DESCRIPTOR(0:1), I C_ C   declare local COMMON's C         INCLUDE 'ETHERMON_ETH.INC' CP( C   declare local symbolic message codes CI       EXTERNAL	ETH__UNKETHCNTS CU C   declare system procedures0 C)#       INTEGER*4 SYS$QIOW,	LIB$EXTZV_"       EXTERNAL	SYS$QIOW,	LIB$EXTZV C ! C   declare system symbolic codes) CO       INCLUDE '($IODEF)'/       EXTERNAL	NMA$C_CTLIN_ZER,NMA$C_CTLIN_DBR,e8      +		NMA$C_CTLIN_MBL,NMA$C_CTLIN_RFL,NMA$C_CTLIN_BRC,8      +		NMA$C_CTLIN_MBY,NMA$C_CTLIN_OVR,NMA$C_CTLIN_LBE,8      +		NMA$C_CTLIN_DBS,NMA$C_CTLIN_MBS,NMA$C_CTLIN_BSM,8      +		NMA$C_CTLIN_BS1,NMA$C_CTLIN_BID,NMA$C_CTLIN_BSN,8      +		NMA$C_CTLIN_MSN,NMA$C_CTLIN_SFL,NMA$C_CTLIN_CDC,7      +		NMA$C_CTLIN_UFD,NMA$C_CTLIN_SBU,NMA$C_CTLIN_UBUC       EXTERNAL	SS$_NORMAL, C  CP BEGIN GET_PORT_COUNTERS* CP.  build extended characteristics buffer CL,       ILV_DESCRIPTOR(0)=ICPETH_CHARBUFSIZE_B2       ILV_DESCRIPTOR(1)=%LOC(NCVETH_EXTCHARBUF(1)) CL' CP.  query DEUNA/DEQNA for its counters  CI       IF(LLA_CLEAR)THENE> 	NLV_FUNC=IO$_SENSEMODE+IO$M_CTRL+IO$M_RD_COUNT+IO$M_CLR_COUNT
       ELSE/ 	NLV_FUNC=IO$_SENSEMODE+IO$M_CTRL+IO$M_RD_COUNT        ENDIF 6       ILV_STATUS=SYS$QIOW(%VAL(0),		! use scratch EFN,:      +			  %VAL(NCVETH_CHAN),	! specify channel to device,.      +			  %VAL(NLV_FUNC),	! specify function,6      +			  %REF(NLV_IOSB),	! specify I/O status block,!      +			  ,,			! specify no AST,MG      +			  %REF(SCVETH_CHARBUF),	! specify primary characteristics buf,M>      +			  %REF(ILV_DESCRIPTOR), ! specify extended char. buf,/      +			  ,,,)			! specify no more parameters.U       IF(.NOT.ILV_STATUS)THEN=" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))1       ELSEIF(NLV_IOSB(0).NE.%LOC(SS$_NORMAL))THENS# 	CALL LIB$SIGNAL(%VAL(NLV_IOSB(0))))
       ELSE 	ICVETH_C_DBR=0E 	ICVETH_C_MBL=0P 	ICVETH_C_BRC=0% 	ICVETH_C_MBY=0  	ICVETH_C_DBS=0. 	ICVETH_C_MBS=0  	NCVETH_C_ZER=0H 	NCVETH_C_RFL(0)=0 	NCVETH_C_RFL(1)=0 	NCVETH_C_OVR=0I 	NCVETH_C_LBE=0G 	NCVETH_C_SFL(0)=0 	NCVETH_C_SFL(1)=0 	NCVETH_C_CDC=0. 	NCVETH_C_UFD=0C 	NCVETH_C_SBU=0H 	NCVETH_C_UBU=0) 	I=1 	DO WHILE (I.LT.NLV_IOSB(1)/2)% 	  IF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.)+      +			%LOC(NMA$C_CTLIN_ZER)+'C000'X)THENP( 	    NCVETH_C_ZER=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.++      +			%LOC(NMA$C_CTLIN_DBR)+'E000'X)THENO8 	    ICVETH_C_DBR=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ. +      +			%LOC(NMA$C_CTLIN_MBL)+'E000'X)THEN 8 	    ICVETH_C_MBL=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ. +      +			%LOC(NMA$C_CTLIN_RFL)+'D000'X)THENW+ 	    NCVETH_C_RFL(0)=NCVETH_EXTCHARBUF(I+1)_+ 	    NCVETH_C_RFL(1)=NCVETH_EXTCHARBUF(I+2))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.A+      +			%LOC(NMA$C_CTLIN_BRC)+'E000'X)THENB8 	    ICVETH_C_BRC=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.	+      +			%LOC(NMA$C_CTLIN_MBY)+'E000'X)THEN 8 	    ICVETH_C_MBY=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ._+      +			%LOC(NMA$C_CTLIN_OVR)+'C000'X)THENV( 	    NCVETH_C_OVR=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.	+      +			%LOC(NMA$C_CTLIN_LBE)+'C000'X)THENu( 	    NCVETH_C_LBE=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ. +      +			%LOC(NMA$C_CTLIN_DBS)+'E000'X)THEN 8 	    ICVETH_C_DBS=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.S+      +			%LOC(NMA$C_CTLIN_MBS)+'E000'X)THEN 8 	    ICVETH_C_MBS=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.F+      +			%LOC(NMA$C_CTLIN_BSM)+'E000'X)THEN 8 	    ICVETH_C_BSM=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.M+      +			%LOC(NMA$C_CTLIN_BS1)+'E000'X)THEN 8 	    ICVETH_C_BS1=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.L+      +			%LOC(NMA$C_CTLIN_BID)+'E000'X)THEN 8 	    ICVETH_C_BID=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.t+      +			%LOC(NMA$C_CTLIN_BSN)+'E000'X)THEN_8 	    ICVETH_C_BSN=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ. +      +			%LOC(NMA$C_CTLIN_MSN)+'E000'X)THENM8 	    ICVETH_C_MSN=LIB$EXTZV(0,32,NCVETH_EXTCHARBUF(I+1))
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ._+      +			%LOC(NMA$C_CTLIN_SFL)+'D000'X)THENM+ 	    NCVETH_C_SFL(0)=NCVETH_EXTCHARBUF(I+1) + 	    NCVETH_C_SFL(1)=NCVETH_EXTCHARBUF(I+2) 
 	    I=I+3) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.R+      +			%LOC(NMA$C_CTLIN_CDC)+'C000'X)THENc( 	    NCVETH_C_CDC=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ.(+      +			%LOC(NMA$C_CTLIN_UFD)+'C000'X)THENC( 	    NCVETH_C_UFD=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ. +      +			%LOC(NMA$C_CTLIN_SBU)+'C000'X)THENT( 	    NCVETH_C_SBU=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2) 	  ELSEIF(JZEXT(NCVETH_EXTCHARBUF(I)).EQ. +      +			%LOC(NMA$C_CTLIN_UBU)+'C000'X)THENT( 	    NCVETH_C_UBU=NCVETH_EXTCHARBUF(I+1)
 	    I=I+2( 	  ELSEIF(NCVETH_EXTCHARBUF(I).EQ.0)THEN 	    I=NLV_IOSB(1)/2 + 1< 	  ELSEIF(IAND(NCVETH_EXTCHARBUF(I),'F000'X).EQ.'C000'X)THEN- D	    CALL LIB$SIGNAL(ETH__UNKETHCNT,%VAL(3),O- D    +				%VAL(NCVETH_EXTCHARBUF(I)),%VAL(4),e' D    +				%VAL(NCVETH_EXTCHARBUF(I+1))))
 	    I=I+2; 	  ELSEIF(IAND(NCVETH_EXTCHARBUF(I),'F000'X).EQ.'D000'X.OR.:;      +		 IAND(NCVETH_EXTCHARBUF(I),'F000'X).EQ.'E000'X)THENO- D	    CALL LIB$SIGNAL(ETH__UNKETHCNT,%VAL(3), - D    +				%VAL(NCVETH_EXTCHARBUF(I)),%VAL(8),S- D    +				%VAL(JZEXT(NCVETH_EXTCHARBUF(I+1))+ 5 D    +				 JISHFT(JZEXT(NCVETH_EXTCHARBUF(I+2)),16)))N
 	    I=I+3 	  ELSEP* 	    CALL LIB$STOP(ETH__UNKETHCNT,%VAL(3),-      +				%VAL(NCVETH_EXTCHARBUF(I)),%VAL(8),	-      +				%VAL(JZEXT(NCVETH_EXTCHARBUF(I+1))+,5      +				 JISHFT(JZEXT(NCVETH_EXTCHARBUF(I+2)),16)))N 	  ENDIF 	ENDDO       ENDIFN CA CP.  RETURN  Ci       RETURN C  CP END GET_PORT_COUNTERS C 	       ENDL2       INTEGER*4 FUNCTION PORT_SATURATED(ILA_DUMMY) C_' CP DATA DECLARATIONS for PORT_SATURATED  CL       IMPLICIT NONEN CC  C   declare subroutine arguments C0       INTEGER*4 ILA_DUMMY) C  C   declare local COMMON's CC        INCLUDE 'ETHERMON_ETH.INC' CC CP BEGIN PORT_SATURATEDN CP.  assume everything is OK C_       PORT_SATURATED=0 CS CP.  get current port counters CB%       CALL GET_PORT_COUNTERS(.FALSE.)F CAH CP.  IF any of the significant counters are at the saturation point THEN CI"       IF(ICVETH_C_DBR .EQ. -1 .OR.!      +	 ICVETH_C_BRC .EQ. -1)THENI CD% CP.  .  mark that things are not goodT C	 	PORT_SATURATED=1E CP
 CP.  ENDIF CC       ENDIFV C' CP.  RETURNH C(       RETURN CN CP END PORT_SATURATEDI CH	       END ?       INTEGER*4 FUNCTION ETHER_READ_EXCPTHDLR(ILA_SIG,ILA_MECH)C CA- CP DATA DECLARATIONS for ETHER_READ_EXCPTHDLRS C0       IMPLICIT NONE! C.  C   declare subroutine arguments C=+       INTEGER*4 ILA_SIG(0:*), ILA_MECH(0:4)C CA" C   declare system data structures C !       INCLUDE '($DVIDEF)	/NOLIST'_!       INCLUDE '($FABDEF)	/NOLIST' !       INCLUDE '($JPIDEF)	/NOLIST'0!       INCLUDE '($RABDEF)	/NOLIST' !       INCLUDE '($SYIDEF)	/NOLIST' !       INCLUDE '($UAIDEF)	/NOLIST'T CS C   declare local variablesC CH       CHARACTER*12 CLV_USER_'       CHARACTER*132 CLV_BUF, CLV_IMGFIL	(       INTEGER*2 LN, NLV_IMGFIL, NLV_USERG       INTEGER*4 ILV_STS, I, ILV_FAOL(11), J, K, ILV_ITMLST(37), ILV_FP,T      +		ILV_PC       RECORD /FABDEF/ SLV_FABD       RECORD /RABDEF/ SLV_RABB C) C   declare local COMMON's CL!       INCLUDE 'ETHERMON_ADDR.INC' $       INCLUDE 'ETHERMON_BRIDGES.INC'        INCLUDE 'ETHERMON_CMD.INC'        INCLUDE 'ETHERMON_ETH.INC'"       INCLUDE 'ETHERMON_MANUF.INC'!       INCLUDE 'ETHERMON_PROT.INC'N        INCLUDE 'ETHERMON_SMG.INC' C  C   declare local procedures C'.       INTEGER*4 GET_INITIAL_FP, GET_NEXT_FRAME1       EXTERNAL	ZERO_PUT_DISPLAY, ZERO_PUT_OUTPUT, @      +		ETHER_READ_EXCPT_TO_FILE, GET_INITIAL_FP, GET_NEXT_FRAME C ( C   declare local symbolic message codes Cs       EXTERNAL	ETH__CMPETHRD       EXTERNAL	FASTSHR_VERSION CG C   declare system proceduresv C <       INTEGER*4 SYS$CREATE, SYS$CONNECT, SYS$PUT, SYS$CLOSE,      +		SYS$GETSYIWC;       EXTERNAL	SYS$CREATE, SYS$CONNECT, SYS$PUT, SYS$CLOSE,D      +		SYS$GETSYIWV CS! C   declare system symbolic codes. C.!       INCLUDE '($SSDEF)		/NOLIST'% C( CP BEGIN ETHER_READ_EXCPTHDLR.% CP.  set return status to unprocessed( C_'       ETHER_READ_EXCPTHDLR=SS$_RESIGNALC CIA CP.  IF message is informational, success, warning, or error THENE CS%       IF(IAND(ILA_SIG(1),7).LE.3)THENI CG* CP.  .  IF message display is enabled THEN CT 	IF(LCVETH_MESSAGES)THEN CC. CP.  .  .  IF a DISPLAY command is active THEN C  	  IF(ICVSMG_ERRID .NE. 0)THEN C H CP.  .  .  .  write message into error message virtuaL display on screen C_ 	    ILA_SIG(0)=ILA_SIG(0)-20 	    CALL SYS$PUTMSG(ILA_SIG,ZERO_PUT_DISPLAY,,) 	    ILA_SIG(0)=ILA_SIG(0)+2 C  CP.  .  .  ELSEb Cc 	  ELSEc Cs; CP.  .  .  .  write message to SYS$OUTPUT under our controlp Ce 	    ILA_SIG(0)=ILA_SIG(0)-2/ 	    CALL SYS$PUTMSG(ILA_SIG,ZERO_PUT_OUTPUT,,)E 	    ILA_SIG(0)=ILA_SIG(0)+2 Co CP.  .  .  ENDIF C  	  ENDIF CD
 CP.  .  ENDIFE CL 	ENDIF C_> CP.  .  change return status to say condition was handled here C_" 	ETHER_READ_EXCPTHDLR=SS$_CONTINUE C$K CP.  ELSEIF error is abort on Ethernet read completion or SS$_DEVINACT THENC CP4       ELSEIF((ILA_SIG(1).EQ.%LOC(ETH__CMPETHRD).AND.!      +	      ILA_SIG(2).EQ.0.AND.M)      +	      ILA_SIG(3).EQ.SS$_ABORT).OR.$+      +	     ILA_SIG(1).EQ.SS$_DEVINACT)THENA CP$ CP.  .  set return status to success C!" 	ETHER_READ_EXCPTHDLR=SS$_CONTINUE CC0 CP.  ELSEIF debugger or control-C exception THEN CA)       ELSEIF(ILA_SIG(1).EQ.SS$_DEBUG .OR.4+      +	     ILA_SIG(1).EQ.SS$_CONTROLC)THEN  C ' CP.  .  leave return status at resignalP C_	 	CONTINUE  Ci# CP.  ELSEIF exception is fatal THENA C )       ELSEIF(IAND(ILA_SIG(1),7).EQ.4)THEN  C  CP.  .  open crash dump file CH 	SLV_FAB.FAB$B_BID=FAB$C_BID 	SLV_FAB.FAB$B_BLN=FAB$C_BLN 	SLV_FAB.FAB$B_FAC=FAB$M_PUT. 	SLV_FAB.FAB$L_FNA=%LOC('ETHERMON.CRASH_DUMP') 	SLV_FAB.FAB$B_FNS=19f 	SLV_FAB.FAB$B_ORG=FAB$C_SEQ 	SLV_FAB.FAB$B_RAT=FAB$M_CRR 	SLV_FAB.FAB$B_RFM=FAB$C_VAR 	ILV_STS=SYS$CREATE(SLV_FAB) 	IF(.NOT.ILV_STS)THEN 7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_FAB.FAB$L_STV))A 	ENDIF 	SLV_RAB.RAB$B_BID=RAB$C_BID 	SLV_RAB.RAB$B_BLN=RAB$C_BLN  	SLV_RAB.RAB$L_FAB=%LOC(SLV_FAB) 	SLV_RAB.RAB$L_ROP=RAB$M_WBH 	ILV_STS=SYS$CONNECT(SLV_RAB)  	IF(.NOT.ILV_STS)THENT7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))V 	ENDIF C.5 CP.  .  write crash dump title to file and SYS$OUTPUT0 C 	 	CLV_BUF=E6      +	'%ETHERMON-F-CRASHDUMP, crash dump of ETHERMON'# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:61))) 	SLV_RAB.RAB$B_RAC=RAB$C_SEQ  	SLV_RAB.RAB$L_RBF=%LOC(CLV_BUF) 	SLV_RAB.RAB$W_RSZ=611 	ILV_STS=SYS$PUT(SLV_RAB)S 	IF(.NOT.ILV_STS)THENI7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))= 	ENDIF C @ CP.  .  write current message prefix (addresses, protocol, etc.) CV	 	DO I=0,3  	  ILV_FAOL(I+1)=NCVETH_IOSB(I)I 	ENDDO	 	DO I=0,5T' 	  ILV_FAOL(I+5)=SCVETH_ADDRBUF.DEST(I)  	ENDDO 	CALL SYS$FAOL(R3      +	'-ETHERMON-I-ADR1, I/OSB=!XW !XW !XW !XW '//=:      +		'dst=!XB-!XB-!XB-!XB-!XB-!XB',LN,CLV_BUF,ILV_FAOL)# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))  	SLV_RAB.RAB$W_RSZ=LNW 	ILV_STS=SYS$PUT(SLV_RAB)  	IF(.NOT.ILV_STS)THEND7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))I 	ENDIF+ 	IF(SCVETH_ADDRBUF.W_PROT .NE. 'AAAA'X .OR.I-      +	   SCVETH_ADDRBUF.ECTL .NE. '03'X)THEN)% 	  ILV_FAOL(1)=SCVETH_ADDRBUF.PROT(0)B% 	  ILV_FAOL(2)=SCVETH_ADDRBUF.PROT(1)S 	  DO I=0,5E( 	    ILV_FAOL(I+3)=SCVETH_ADDRBUF.SRC(I) 	  ENDDO 	  CALL SYS$FAOL(R3      +	'-ETHERMON-I-ADR2, protocol=!XB-!XB      '//A:      +		'src=!XB-!XB-!XB-!XB-!XB-!XB',LN,CLV_BUF,ILV_FAOL) 	ELSE+ 	  DO I=0,4I( 	    ILV_FAOL(I+1)=SCVETH_ADDRBUF.PID(I) 	  ENDDO 	  DO I=0,5 ( 	    ILV_FAOL(I+6)=SCVETH_ADDRBUF.SRC(I) 	  ENDDO 	  CALL SYS$FAOL( 6      +	'-ETHERMON-I-ADR2, IEEE=!XB-!XB-!XB,!XB-!XB '//:      +		'src=!XB-!XB-!XB-!XB-!XB-!XB',LN,CLV_BUF,ILV_FAOL) 	ENDIF# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))L 	SLV_RAB.RAB$W_RSZ=LNT 	ILV_STS=SYS$PUT(SLV_RAB)_ 	IF(.NOT.ILV_STS)THENI7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))  	ENDIF C=3 CP.  .  write current message body in hex and ASCIIE CI 	DO I=1,NCVETH_IOSB(1),16L 	  CLV_BUF='-ETHERMON-I-DATA, '%" 	  DO J=0,MIN(15,NCVETH_IOSB(1)-I) 	    K=52-(2*J)-(J/4)S9 	    CALL OTS$CVT_L_TZ(BCVETH_RCVBUF(I+J),CLV_BUF(K:K+1),N      +			      %VAL(2),%VAL(1))_ 	  ENDDO@ 	  CALL SYS$FAO('!AF',,CLV_BUF(55:70),%VAL(16),BCVETH_RCVBUF(I))0 	  CALL OTS$CVT_L_TZ(I-1,CLV_BUF(72:75),%VAL(4))% 	  CALL LIB$PUT_OUTPUT(CLV_BUF(1:75))L 	  SLV_RAB.RAB$W_RSZ=75( 	  ILV_STS=SYS$PUT(SLV_RAB)6 	  IF(.NOT.ILV_STS)THENL9 	    CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))X 	  ENDIF 	ENDDO CU; CP.  .  write register data from signal/mechanism argumentsC CT" 	ILV_FAOL(1)=ILA_SIG(ILA_SIG(0)-1)  	ILV_FAOL(2)=ILA_SIG(ILA_SIG(0)) 	ILV_FAOL(3)=ILA_MECH(3) 	ILV_FAOL(4)=ILA_MECH(4) 	ILV_FAOL(5)=ILA_MECH(2) 	CALL SYS$FAOL(UB      +	'-ETHERMON-I-REGS, PC=!XL PSL=!XL R0=!XL R1=!XL depth=!SL',"      +		      LN,CLV_BUF,ILV_FAOL)# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))  	SLV_RAB.RAB$W_RSZ=LN. 	ILV_STS=SYS$PUT(SLV_RAB)L 	IF(.NOT.ILV_STS)THEN 7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))) 	ENDIF C 0 CP.  .  do traceback (for .CRASH_DUMP disk file) CL 	ILV_FP=GET_INITIAL_FP(%VAL(0))  	DO I=1,ILA_MECH(2)Z- 	  ILV_FP=GET_NEXT_FRAME(%VAL(ILV_FP),ILV_PC)I> 	  CALL SYS$FAOL('-ETHERMON-I-TRACEBK, !XL',LN,CLV_BUF,ILV_PC)% 	  CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN)), 	  SLV_RAB.RAB$W_RSZ=LN  	  ILV_STS=SYS$PUT(SLV_RAB)! 	  IF(.NOT.ILV_STS)THENR9 	    CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))	 	  ENDIF 	ENDDO CB7 CP.  .  get process privileges and quotas, display them	 C ' 	ILV_ITMLST(1)=JISHFT(JPI$_BYTCNT,16)+4L  	ILV_ITMLST(2)=%LOC(ILV_FAOL(1)) 	ILV_ITMLST(3)=0& 	ILV_ITMLST(4)=JISHFT(JPI$_BYTLM,16)+4  	ILV_ITMLST(5)=%LOC(ILV_FAOL(2)) 	ILV_ITMLST(6)=0( 	ILV_ITMLST(7)=JISHFT(JPI$_CURPRIV,16)+8  	ILV_ITMLST(8)=%LOC(ILV_FAOL(3)) 	ILV_ITMLST(9)=0% 	ILV_ITMLST(10)=JISHFT(JPI$_PRI,16)+4C! 	ILV_ITMLST(11)=%LOC(ILV_FAOL(5))( 	ILV_ITMLST(12)=0(& 	ILV_ITMLST(13)=JISHFT(JPI$_PRIB,16)+4! 	ILV_ITMLST(14)=%LOC(ILV_FAOL(6))I 	ILV_ITMLST(15)=0(8 	ILV_ITMLST(16)=JISHFT(JPI$_IMAGNAME,16)+LEN(CLV_IMGFIL)  	ILV_ITMLST(17)=%LOC(CLV_IMGFIL)  	ILV_ITMLST(18)=%LOC(NLV_IMGFIL)) 	ILV_ITMLST(19)=JISHFT(JPI$_JOBTYPE,16)+4_! 	ILV_ITMLST(20)=%LOC(ILV_FAOL(7))X 	ILV_ITMLST(21)=0,( 	ILV_ITMLST(22)=JISHFT(JPI$_CPUTIM,16)+4! 	ILV_ITMLST(23)=%LOC(ILV_FAOL(8))E 	ILV_ITMLST(24)=0L( 	ILV_ITMLST(25)=JISHFT(JPI$_CPULIM,16)+4! 	ILV_ITMLST(26)=%LOC(ILV_FAOL(9))A 	ILV_ITMLST(27)=0 ( 	ILV_ITMLST(28)=JISHFT(JPI$_WSSIZE,16)+4" 	ILV_ITMLST(29)=%LOC(ILV_FAOL(10)) 	ILV_ITMLST(30)=0U( 	ILV_ITMLST(31)=JISHFT(JPI$_ASTACT,16)+4" 	ILV_ITMLST(32)=%LOC(ILV_FAOL(11)) 	ILV_ITMLST(33)=0B6 	ILV_ITMLST(34)=JISHFT(JPI$_USERNAME,16)+LEN(CLV_USER) 	ILV_ITMLST(35)=%LOC(CLV_USER) 	ILV_ITMLST(36)=%LOC(NLV_USER) 	ILV_ITMLST(37)=0E# 	CALL SYS$GETJPIW(,,,ILV_ITMLST,,,)V* 	CALL STR$TRIM(CLV_USER,CLV_USER,NLV_USER)& 	ILV_ITMLST(1)=JISHFT(UAI$_BYTLM,16)+4# 	ILV_ITMLST(2)=%LOC(ILV_ITMLST(30))( 	ILV_ITMLST(3)=0) 	ILV_ITMLST(4)=JISHFT(UAI$_DEF_PRIV,16)+84# 	ILV_ITMLST(5)=%LOC(ILV_ITMLST(31))  	ILV_ITMLST(6)=0$ 	ILV_ITMLST(7)=JISHFT(UAI$_PRI,16)+4# 	ILV_ITMLST(8)=%LOC(ILV_ITMLST(33))U 	ILV_ITMLST(9)=0 	ILV_ITMLST(10)=0 6 	CALL SYS$GETUAI(,,CLV_USER(1:NLV_USER),ILV_ITMLST,,,) 	CALL SYS$FAOL(D>      +	'-ETHERMON-I-AUTH, bytlm=!UL defpriv=!XL !XL prio=!UL',(      +		      LN,CLV_BUF,ILV_ITMLST(30))# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))R 	SLV_RAB.RAB$W_RSZ=LNN 	ILV_STS=SYS$PUT(SLV_RAB)N 	IF(.NOT.ILV_STS)THENr7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))  	ENDIF 	CALL SYS$FAOL( E      +	'-ETHERMON-I-QUOPRV, bytlm=!UL/!UL priv=!XL !XL prio=!UB/!UB',S"      +		      LN,CLV_BUF,ILV_FAOL)# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))D 	SLV_RAB.RAB$W_RSZ=LNP 	ILV_STS=SYS$PUT(SLV_RAB)c 	IF(.NOT.ILV_STS)THEN 7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))u 	ENDIFA 	CLV_BUF='-ETHERMON-I-IMG, image file '//CLV_IMGFIL(1:NLV_IMGFIL)B# 	LN=MIN(NLV_IMGFIL+28,LEN(CLV_BUF))i# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))' 	SLV_RAB.RAB$W_RSZ=LNC 	ILV_STS=SYS$PUT(SLV_RAB)  	IF(.NOT.ILV_STS)THEN,7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV)), 	ENDIF" 	ILV_FAOL(1)=ILV_FAOL(7) ! jobtype< 	CALL LIB$EMUL(ILV_FAOL(8),-100000,0,ILV_FAOL(6)) ! CPU time 	ILV_FAOL(2)=%LOC(ILV_FAOL(6))% 	IF(ILV_FAOL(9).EQ.0)THEN ! CPU limit$ 	  CLV_IMGFIL='-infinite-' 	  NLV_IMGFIL=10 	ELSE,3 	  CALL LIB$EMUL(ILV_FAOL(9),-100000,0,ILV_FAOL(4))N= 	  CALL SYS$ASCTIM(NLV_IMGFIL,CLV_IMGFIL,ILV_FAOL(4),%VAL(0))r 	ENDIF 	ILV_FAOL(3)=NLV_IMGFIL_ 	ILV_FAOL(4)=%LOC(CLV_IMGFIL)E# 	ILV_FAOL(5)=ILV_FAOL(10) ! wssize	T@ 	ILV_FAOL(6)=JISHFT(ILV_FAOL(11),-3)*4 ! ASTact (user-mode only) 	CALL SYS$FAOL(ED      +'-ETHERMON-I-PRC, jobtyp=!SL CPU=!%T/!AD wssize=!UL!#< AST!>',"      +		      LN,CLV_BUF,ILV_FAOL)# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))N 	SLV_RAB.RAB$W_RSZ=LNS 	ILV_STS=SYS$PUT(SLV_RAB)a 	IF(.NOT.ILV_STS)THENA7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))% 	ENDIF CC1 CP.  .  get Ethernet port description, display it! Ce5 	ILV_ITMLST(1)=JISHFT(DVI$_DEVNAM,16)+LEN(CLV_IMGFIL)T 	ILV_ITMLST(2)=%LOC(CLV_IMGFIL)F 	ILV_ITMLST(3)=%LOC(NLV_IMGFIL)i) 	ILV_ITMLST(4)=JISHFT(DVI$_DEVCLASS,16)+4!  	ILV_ITMLST(5)=%LOC(ILV_FAOL(3)) 	ILV_ITMLST(6)=0( 	ILV_ITMLST(7)=JISHFT(DVI$_DEVTYPE,16)+4  	ILV_ITMLST(8)=%LOC(ILV_FAOL(4)) 	ILV_ITMLST(9)=0+ 	ILV_ITMLST(10)=JISHFT(DVI$_DEVBUFSIZ,16)+4)! 	ILV_ITMLST(11)=%LOC(ILV_FAOL(5))O 	ILV_ITMLST(12)=0E' 	ILV_ITMLST(13)=JISHFT(DVI$_OPCNT,16)+4V! 	ILV_ITMLST(14)=%LOC(ILV_FAOL(9))V 	ILV_ITMLST(15)=0T 	ILV_ITMLST(16)=0_5 	CALL SYS$GETDVIW(,%VAL(NCVETH_CHAN),,ILV_ITMLST,,,,)T 	ILV_FAOL(1)=NLV_IMGFIL= 	ILV_FAOL(2)=%LOC(CLV_IMGFIL)_ 	ILV_FAOL(6)=ICVETH_FMT= 	ILV_FAOL(7)=ICVETH_INIT_FMT 	ILV_FAOL(8)=ICVETH_BFN) 	CALL SYS$FAOL( <      +	'-ETHERMON-I-DEV, !AD class=!XB type=!XB bfsz=!UW '//'      +			'fmt=!SL/!SL #bf=!SL #op=!UL',E"      +		      LN,CLV_BUF,ILV_FAOL) 	IF(LCVETH_FASTQIO)THENE; 	  CALL SYS$FAO(', FASTSHR V!SL',NLV_IMGFIL,CLV_BUF(LN+1:),T      +		       FASTSHR_VERSION)T 	  LN=LN+NLV_IMGFIL2 	ENDIF# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))I 	SLV_RAB.RAB$W_RSZ=LNU 	ILV_STS=SYS$PUT(SLV_RAB)M 	IF(.NOT.ILV_STS)THENT7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))I 	ENDIF CI/ CP.  .  get host system description, display it  C ) 	ILV_ITMLST(1)=JISHFT(SYI$_VERSION,16)+16 % 	ILV_ITMLST(2)=%LOC(CLV_IMGFIL(1:16))1 	ILV_ITMLST(3)=%LOC(NLV_IMGFIL)X) 	ILV_ITMLST(4)=JISHFT(SYI$_HW_NAME,16)+40(& 	ILV_ITMLST(5)=%LOC(CLV_IMGFIL(17:57)) 	ILV_ITMLST(6)=%LOC(LN)X- 	ILV_ITMLST(7)=JISHFT(SYI$_DEFMBXBUFQUO,16)+4_  	ILV_ITMLST(8)=%LOC(ILV_FAOL(6)) 	ILV_ITMLST(9)=0, 	ILV_ITMLST(10)=JISHFT(SYI$_PQL_DBYTLM,16)+4! 	ILV_ITMLST(11)=%LOC(ILV_FAOL(7))_ 	ILV_ITMLST(12)=0N, 	ILV_ITMLST(13)=JISHFT(SYI$_PQL_MBYTLM,16)+4! 	ILV_ITMLST(14)=%LOC(ILV_FAOL(8))  	ILV_ITMLST(15)=0T/ 	ILV_ITMLST(16)=JISHFT(SYI$_ACTIVECPU_CNT,16)+4E! 	ILV_ITMLST(17)=%LOC(ILV_FAOL(5))I 	ILV_ITMLST(18)=0H 	ILV_ITMLST(19)=0  	ILV_FAOL(5)=0& 	ILV_STS=SYS$GETSYIW(,,,ILV_ITMLST,,,)5 	IF(ILV_STS.EQ.SS$_BADPARAM)THEN	! allow for VMS V4.x(/ 	  ILV_ITMLST(4)=JISHFT(SYI$_NODE_HWTYPE,16)+40T 	  ILV_ITMLST(16)=0 ( 	  ILV_STS=SYS$GETSYIW(,,,ILV_ITMLST,,,) 	ENDIFA 	CALL STR$TRIM(CLV_IMGFIL(1:NLV_IMGFIL),CLV_IMGFIL(1:NLV_IMGFIL),       +		      NLV_IMGFIL)) 	ILV_FAOL(1)=NLV_IMGFILT" 	ILV_FAOL(2)=%LOC(CLV_IMGFIL(1:1))< 	CALL STR$TRIM(CLV_IMGFIL(17:16+LN),CLV_IMGFIL(17:16+LN),LN) 	ILV_FAOL(3)=LNO$ 	ILV_FAOL(4)=%LOC(CLV_IMGFIL(17:17))= 	CALL SYS$FAOL('-ETHERMON-I-SYS, ETHERMON '//CCPETH_VERSION//3      +					'; VMS !AD on !AD',"      +		      LN,CLV_BUF,ILV_FAOL) 	IF(ILV_FAOL(5).GT.1)THEN  	  NLV_IMGFIL=LN< 	  CALL SYS$FAOL(', #CPU=!UL',LN,CLV_BUF(LN+1:),ILV_FAOL(5)) 	  LN=LN+NLV_IMGFIL) 	ENDIF# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))X 	SLV_RAB.RAB$W_RSZ=LNI 	ILV_STS=SYS$PUT(SLV_RAB)C 	IF(.NOT.ILV_STS)THEN37 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))O 	ENDIF8 	CALL SYS$FAOL('-ETHERMON-I-SYSGEN, DEFMBXBUFQUO=!UL '//*      +				'PQL_DBYTLM=!UL PQL_MBYTLM=!UL',%      +		      LN,CLV_BUF,ILV_FAOL(6)) # 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))T 	SLV_RAB.RAB$W_RSZ=LN= 	ILV_STS=SYS$PUT(SLV_RAB)A 	IF(.NOT.ILV_STS)THEN 7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))( 	ENDIF C_3 CP.  .  get ETHERMON table statistics, display themA CF 	ILV_FAOL(1)=ICVADR_NUMADDRS 	ILV_FAOL(2)=ICPADR_MINADDRS 	ILV_FAOL(3)=ICPADR_MAXADDRS 	ILV_FAOL(4)=ICVPRT_NUMNAMES 	ILV_FAOL(5)=ICPPRT_MINNAMES 	ILV_FAOL(6)=ICPPRT_MAXNAMES 	ILV_FAOL(7)=ICVMNF_NUMNAMES 	ILV_FAOL(8)=ICPMNF_MINNAMES 	ILV_FAOL(9)=ICPMNF_MAXNAMES 	CALL SYS$FAOL(0?      +	'-ETHERMON-I-TBL1, adr=!SL(!SL:!SL) prot=!SL(!SL:!SL)'//       +			' mnf=!SL(!SL:!SL)',U"      +		      LN,CLV_BUF,ILV_FAOL)# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))B 	SLV_RAB.RAB$W_RSZ=LN) 	ILV_STS=SYS$PUT(SLV_RAB)X 	IF(.NOT.ILV_STS)THEN.7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))N 	ENDIF 	ILV_FAOL(1)=ICVBRG_NUMBRIDGES 	ILV_FAOL(2)=ICPBRG_MAXBRIDGES 	ILV_FAOL(3)=ICPBRG_MAXBRGROUTE( 	ILV_FAOL(4)=ICVETH_DISPLAYMODEX$ 	ILV_FAOL(5)=JZEXT(NCVETH_TRACEFLAG) 	CALL SYS$FAOL(G<      +	'-ETHERMON-I-TBL2, brg=!SL(!SLx!SL) dsp=!SL trc=!XW',"      +		      LN,CLV_BUF,ILV_FAOL)# 	CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))E 	SLV_RAB.RAB$W_RSZ=LNA 	ILV_STS=SYS$PUT(SLV_RAB). 	IF(.NOT.ILV_STS)THENE7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))B 	ENDIF C_9 CP.  .  get ETHERMON command parser context, display them% C( 	LN=0  	IF(LCVCMD_INPROGRESS)THEN% 	  CLV_BUF='-ETHERMON-I-CURCMD, '''//X-      +			CCVCMD_CMDLIN(1:NCVCMD_CMDLEN)//''''  	  LN=22+NCVCMD_CMDLEN 	ELSEIF(NCVCMD_CMDLEN.GT.0)THEN+& 	  CLV_BUF='-ETHERMON-I-LASTCMD, '''//-      +			CCVCMD_CMDLIN(1:NCVCMD_CMDLEN)//'''', 	  LN=23+NCVCMD_CMDLEN 	ENDIF 	IF(LN.GT.0)THEN% 	  CALL LIB$PUT_OUTPUT(CLV_BUF(1:LN))  	  SLV_RAB.RAB$W_RSZ=LN  	  ILV_STS=SYS$PUT(SLV_RAB)_ 	  IF(.NOT.ILV_STS)THEN 9 	    CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_RAB.RAB$L_STV))D 	  ENDIF 	ENDIF CP. CP.  .  to file only, write condition messages Ce 	ILA_SIG(0)=ILA_SIG(0)-2; 	CALL SYS$PUTMSG(ILA_SIG,ETHER_READ_EXCPT_TO_FILE,,SLV_RAB)N 	ILA_SIG(0)=ILA_SIG(0)+2 CO CP.  .  close crash file C_ 	ILV_STS=SYS$CLOSE(SLV_FAB)t 	IF(.NOT.ILV_STS)THENO7 	  CALL LIB$STOP(%VAL(ILV_STS),%VAL(SLV_FAB.FAB$L_STV))  	ENDIF CT
 CP.  ENDIF C.       ENDIF  C  CP.  RETURN unsuccessfully Ct       RETURN Ct CP END ETHER_READ_EXCPTHDLR  CI	       END 3       INTEGER*4 FUNCTION ZERO_PUT_DISPLAY(CLA_TEXT)  C ) CP DATA DECLARATIONS for ZERO_PUT_DISPLAYR CA       IMPLICIT NONEE CF  C   declare subroutine arguments C        CHARACTER*(*) CLA_TEXT C_ C   declare local variables  C        INTEGER*4 ILV_STSR C_ C   declare local COMMON's CA        INCLUDE 'ETHERMON_SMG.INC' C_ C   declare system proceduresN C!9       INTEGER*4 SMG$REPASTE_VIRTUAL_DISPLAY, SMG$PUT_LINE 8       EXTERNAL	SMG$REPASTE_VIRTUAL_DISPLAY, SMG$PUT_LINE Cu CP BEGIN ZERO_PUT_DISPLAY(: CP.  IF error display not yet brought into foreground THEN CN       IF(LCVSMG_ERRHIDDEN)THEN CN CP.  .  do that/ CI2 	ILV_STS=SMG$REPASTE_VIRTUAL_DISPLAY(ICVSMG_ERRID,'      +				ICVSMG_PASTEID,ICVSMG_ROWS,1)  	IF(.NOT.ILV_STS)THEN ! 	  CALL LIB$SIGNAL(%VAL(ILV_STS))H 	ENDIF 	LCVSMG_ERRHIDDEN=.FALSE.  C 
 CP.  ENDIF CL       ENDIF_ CR0 CP.  send text to error display window on screen C_1       ILV_STS=SMG$PUT_LINE(ICVSMG_ERRID,CLA_TEXT)/       IF(.NOT.ILV_STS)THEN 	CALL LIB$SIGNAL(%VAL(ILV_STS))l       ENDIFM Cs CP.  RETURN with error statusD CI       ZERO_PUT_DISPLAY=0       RETURN C  CP END ZERO_PUT_DISPLAYM CN	       ENDN2       INTEGER*4 FUNCTION ZERO_PUT_OUTPUT(CLA_TEXT) C.( CP DATA DECLARATIONS for ZERO_PUT_OUTPUT C        IMPLICIT NONEM CN  C   declare subroutine arguments C        CHARACTER*(*) CLA_TEXT CP CP BEGIN ZERO_PUT_OUTPUT CP.  send text to SYS$OUTPUT C_#       CALL LIB$PUT_OUTPUT(CLA_TEXT)_ CE CP.  RETURN with error statusE C        ZERO_PUT_OUTPUT=0l       RETURN C  CP END ZERO_PUT_OUTPUT CE	       END E       INTEGER*4 FUNCTION ETHER_READ_EXCPT_TO_FILE(CLA_STRING,SLA_RAB)  CE1 CP DATA DECLARATIONS for ETHER_READ_EXCPT_TO_FILE  C        IMPLICIT NONE  CX" C   declare system data structures C,!       INCLUDE '($RABDEF)	/NOLIST'  C   C   declare subroutine arguments C.       CHARACTER*(*) CLA_STRING       RECORD /RABDEF/ SLA_RABX CH! CP BEGIN ETHER_READ_EXCPT_TO_FILEr CP.  send message to crash fileC CD(       SLA_RAB.RAB$L_RBF=%LOC(CLA_STRING)'       SLA_RAB.RAB$W_RSZ=LEN(CLA_STRING)T       CALL SYS$PUT(SLA_RAB)I C) CP.  RETURN unsuccessfully Cm        ETHER_READ_EXCPT_TO_FILE=0       RETURN CA CP END ETHER_READ_EXCPT_TO_FILEP C 	       ENDa       OPTIONS /CHECK=NOOVERFLOWD)       SUBROUTINE NETACP_QUERY(ILA_ASTPRM)g Cn% CP DATA DECLARATIONS for NETACP_QUERYe C        IMPLICIT NONEL CI  C   declare subroutine arguments CZ       INTEGER*4 ILA_ASTPRM CG C   declare local variables  CE       INTEGER*4 I  C  C   declare local COMMON's CS!       INCLUDE 'ETHERMON_ADDR.INC'         INCLUDE 'ETHERMON_ETH.INC' C  C   declare local procedures CT#       EXTERNAL	ETHER_READ_EXCPTHDLRo CP( C   declare local symbolic message codes CI=       EXTERNAL	ETH__CMPNETACP, ETH__NETACPDAT, ETH__UNDDECNODo Ca CP BEGIN NETACP_QUERYH# CP.  set up emergency error trapperP CE.       CALL LIB$ESTABLISH(ETHER_READ_EXCPTHDLR) C + CP.  test if any errors in query completion( CE$       IF(.NOT.NCVETH_NETIOSB(0))THEN9 	CALL LIB$SIGNAL(ETH__CMPNETACP,,%VAL(NCVETH_NETIOSB(0)))O       ENDIF $       IF(NCVETH_NETIOSB(1).LT.2)THEN  	CALL LIB$SIGNAL(ETH__NETACPDAT)       ENDIF! CE3 CP.  IF entry does not already has DECnet name THENu CrE       IF(IAND(ICVADR_FLAGS(%LOC(ILA_ASTPRM)),ICPADR_DECNET).EQ.0)THEN. C44 CP.  .  IF returned nodename is non-zero length THEN C.* 	IF(ICHAR(CCVETH_NETACPBUF(1:1)).GT.0)THEN CU? CP.  .  .  add name to entry and flag that real name was storedN CLE 	  NCVADR_DECNETNAMLEN(%LOC(ILA_ASTPRM))=ICHAR(CCVETH_NETACPBUF(1:1))F& 	  CCVADR_DECNETNAM(%LOC(ILA_ASTPRM))=:      +		CCVETH_NETACPBUF(3:ICHAR(CCVETH_NETACPBUF(1:1))+2)" 	  ICVADR_FLAGS(%LOC(ILA_ASTPRM))=9      +		IOR(ICVADR_FLAGS(%LOC(ILA_ASTPRM)),ICPADR_DECNET)B CT) CP.  .  ELSEIF no name ever supplied THENI CS7 	ELSEIF(NCVADR_DECNETNAMLEN(%LOC(ILA_ASTPRM)).LE.0)THENI CTC CP.  .  .  fill name with node address (no symbolic name available)D CB@ 	  CALL SYS$FAO('!UW.!UW',NCVADR_DECNETNAMLEN(%LOC(ILA_ASTPRM)),2      +		       CCVADR_DECNETNAM(%LOC(ILA_ASTPRM)),>      +	%VAL(JZEXT(SCVADR_ADDR(%LOC(ILA_ASTPRM)).NUM(2))/1024),C      +	%VAL(MOD(JZEXT(SCVADR_ADDR(%LOC(ILA_ASTPRM)).NUM(2)),1024)))p CtD CP.  .  .  report error to user (regarding obsolete DECnet database) C,6 	  IF(LCVETH_MESSAGES .GE. 3)THEN ! SET MESSAGES DEBUG, 	    CALL LIB$SIGNAL(ETH__UNDDECNOD,%VAL(2),>      +	%VAL(JZEXT(SCVADR_ADDR(%LOC(ILA_ASTPRM)).NUM(2))/1024),C      +	%VAL(MOD(JZEXT(SCVADR_ADDR(%LOC(ILA_ASTPRM)).NUM(2)),1024)))% 	  ENDIF CA
 CP.  .  ENDIFD C  	ENDIF C 
 CP.  ENDIF Ce       ENDIF( Cr% CP.  unlock the ACP request mechanism  CI       LCVETH_DECNETBUSY=.FALSE.D C  CP.  RETURN  CV       RETURN C_ CP END NETACP_QUERYD C 	       ENDA