( #pragma module pppdutil_decode_log "X-4" /*N  *****************************************************************************  *2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *N  *****************************************************************************    
 	FACILITY:  
 		PPPD logger   
 	ABSTRACT:  A   		Simple program to read the log file and display it one record  	at a time.    	AUTHOR:  $ 		Forrest A. Kenney	17-December-1995   	REVISION HISTORY:  C         X-4     BWK004          Barry W. Kierstein      17-DEC-1996 <                 Replaced the standard Digital copyright with6                 one compatible with the CMU copyright.  C         X-3     BWK003          Barry W. Kierstein      24-Jul-1996 +                 Corrected copyright notice.   C         X-2     BWK002          Barry W. Kierstein      11-Jul-1996 5                 Incorporated FREE_DYNAMIC_DESCRIPTOR.   -   	X-1	BWK001		Barry W. Kierstein	07-May-1996 B   		Converted this routine from using argc/argv to calling the CLIL                 for the input and output files, and incorporated this module$                 into the main image. */       /* Local constants */    #define		MAX_OUT_REC	255    1 /* Include various necessary description files */    #include	<descrip.h> #include	<ssdef.h> #include	<starlet.h> #include	<stdio.h> #include        <namdef.h>  #include        <str$routines.h>   #include        "pppddef.h"  #include	"pppd_log_if.h"# #include        "pppdutil_common.h"        /* **+  ** Function Name ** **     util$convert_log_file ** ** Functional Description: **I **     It assumes that you have supplied the binary log file as the first L ** argument and text output file as the second argument.  It opens the filesO ** and then reads one record at a time from the binary log file and converts it M ** to ASCII text and writes it to the ASCII text file.  It will do this until O ** an error occurs reading data or if we cannot convert the binary time into an N ** text string.  If the time conversion does not work the most probably reason ** is a corrupt log file.  ** ** Explicit Inputs:  ** **     None  ** ** Implicit Inputs:  **+ **     Input and output files from the CLI.  ** ** Local Variables:  **; **      binary_filename -       Name of the binary log file > **	binary_file	-	File pointer returned by fopen for the binary **				log file9 **	out_rec		-	Character string used to build up the ASCII 0 **				representation of a binary log file record? **	out_str_len	-	Length in bytes of the ascii representation of  **				a logger record P **      output_filename -       Name of the ascii representation of the log file= **	output_file	-	File pointer returned by fopen for the ascii # **				reprsentation of the log file , **	record		-	Binary record from the log file@ **	record_count	-	Count of the number of records in the log file6 **	status		-	VMS return status from call to SYS$ASCTIM6 **	time		-	VMS string descriptor used by SYS$ASCITM to1 **				hold ASCII representation of the time stamp $ **	time_len	-	Length in bytes of the= **	time_str	-	String used to hold the ASCII representation of  **				the time stamp.  ** ** Outputs:  **
 **       None  **	 ** NOTES:  **
 **       None  ** **-  */  / $DESCRIPTOR(binary_file_param,"CONVERT_INPUT"); 0 $DESCRIPTOR(output_file_param,"CONVERT_OUTPUT");   util$convert_log_file()  { !     D_DESCRIPTOR binary_filename; !     D_DESCRIPTOR output_filename;      FILE	*binary_file;     FILE	*output_file;L     int         max_filename    = NAM$C_MAXRSS+1; /* +1 for trailing '\0' */     char	out_rec[MAX_OUT_REC];     int		out_str_len;      int		record_count = 0;     int		status;     short int	time_len;        logRecord	record;        char		time_str[31]; "     struct dsc$descriptor_vs time;       time.dsc$w_maxstrlen = 31;&     time.dsc$b_dtype = DSC$K_DTYPE_VT;&     time.dsc$b_class = DSC$K_CLASS_VS;"     time.dsc$a_pointer = time_str;  -     /* Get the binary and output filenames */   :     INIT_DYNAMIC_DESCRIPTOR(binary_filename,max_filename);@     if (!get_str_qualifier(&binary_file_param,&binary_filename))     { 2         FREE_DYNAMIC_DESCRIPTOR(&binary_filename);         return(PPPD$_ABORT);     } H     binary_filename.dsc$a_pointer[binary_filename.dsc$w_length]  = '\0';  :     INIT_DYNAMIC_DESCRIPTOR(output_filename,max_filename);@     if (!get_str_qualifier(&output_file_param,&output_filename))     { 2         FREE_DYNAMIC_DESCRIPTOR(&binary_filename);2         FREE_DYNAMIC_DESCRIPTOR(&output_filename);         return(PPPD$_ABORT);     } H     output_filename.dsc$a_pointer[output_filename.dsc$w_length]  = '\0';  :     /* We have an input and output so lets open them up */j     binary_file = fopen(binary_filename.dsc$a_pointer, "rb", "ctx=rec", "rat=none", "rfm=var", "shr=get");     if (!(binary_file == NULL))      { A         output_file = fopen(output_filename.dsc$a_pointer, "w+"); #         if (!(output_file == NULL)) 	         {              /*R                Loop until we get an error reading the input file.  Note that if weR                get an error converting binary time to ASCII format this will break                from the loop.              */R             while(fread((void *)&record, sizeof(logRecord), 1, binary_file) >=  1)
             { "                 record_count += 1;L                 status = SYS$ASCTIM(&time_len, &time, &record.timeStamp, 0);+                 if (!(status & SS$_NORMAL))                  { Z                     printf("Error converting time to ASCII format error # %7x\n", status);                     break;                 } -                 time_str[time_len] = (char)0; I                 out_str_len = sprintf((void *)out_rec,"%s   ", time_str);                  /*:                     Determine what type of message we have                 */'                 switch (record.msgType)                  { #                     case LOG_EMERG: `                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_EMERG    ");                          break;   #                     case LOG_ALERT: `                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_ALERT    ");                          break;   "                     case LOG_CRIT:`                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_CRIT     ");                          break;   !                     case LOG_ERR: `                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_ERR      ");                          break;   %                     case LOG_WARNING: `                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_WARNING  ");                          break;   $                     case LOG_NOTICE:`                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_NOTICE   ");                          break;   "                     case LOG_INFO:`                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_INFO     ");                          break;   #                     case LOG_DEBUG: `                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_DEBUG    ");                          break;   !                     case LOG_EOF: `                          out_str_len += sprintf((void *)&out_rec[out_str_len], "LOG_EOF      ");                          break;                        default:U                          printf("Error unknown record on record %d\n", record_count);                           break;                  }                  /*F                     Get text string and output log record to text file                 */1                 record.msg[record.msgLen] = '\0'; X                 out_str_len += sprintf((void *)&out_rec[out_str_len], "%s", record.msg);/                 record.msg[out_str_len] = '\0'; 6                 fprintf(output_file, "%s\n", out_rec);
             }               fclose(output_file);	         }          else	         { B             signal_error (PPPD$_NOCVTOUTPUT, 1, &output_filename);	         }          fclose(binary_file);     }      else     { =         signal_error (PPPD$_NOCVTINPUT, 1, &binary_filename);      }        return(SS$_NORMAL);  } 