# #pragma module pppd$asnstrstp "X-7"  /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     A   		This module contains a the start and I/O completion rotuines. 
 	They are:  * 		asn$read_done		-	Complete a read request) 		asn$read_startio	-	Start a read request : 		asn$return_read_pkt	-	Decide what to do with read packet0 		asn$validate_read_pkt	-	Validate a read packet, 		asn$write_done		-	Complete a write request+ 		asn$write_startio	-	Start a write request    	AUTHOR:   $ 		Forrest A. Kenney	14-February-1996    	REVISION HISTORY:   , 	X-7	FAK006		Forrest A. Kenney	07-March-1997< 		Remove the acquisition of the device lock before seeing if; 		we have an outstanding write.  Just check the write state A 		and if we have a write queued.  If not then start the write if   		so queue the request.     0 	X-6	BWK001		Barry W. Kierstein	71-December-1996. 		Replaced the standard Digital copyright with( 		one compatible with the CMU copyright.  / 	X-5	FAK005		Forrest A. Kenney	04-November-1996 ? 		We are now going to get a write buffer when we start a write  < 		and free it when a write is completed.  This allows us to @ 		clear the write flag when we abort a write or when it is done.@ 		We loose a little performance in the worse case allocating and= 		deallocating pool but we simplify the logic for writes. In  A 		asn$write_done deallocate the write buffer, and no longer clear : 		the writing flag it is cleared when we queue the fork to 		complete the write.   . 	X-4	FAK003		Forrest A. Kenney	03-October-19968 		Clear the writing state once the write packet has been 		returned.   0 	X-3	FAK002		Forrest A. Kenney	24-September-1996A 		Fill in VCRP$L_BOFF to be end of VCRP$T_DATA .  Seems that even ? 		though some versions of the VCI specification say this is not > 		used unless VCRP$L_SVAPTE is filled in that is not the case.  + 	X-2	FAK001		Forrest A. Kenney	02-July-1996 ; 		In asn$return_read_pkt get the device lock.  Add check on @ 		$QIO path to make sure that packet fits buffer if not.  Return+ 		length of 0, and status of SS$_BUFFEROVF.    */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ : #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ 2 #include	<descrip.h>	/* DEscriptor definitions		*/9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 5 #include	<ttdef.h>	/* Terminal definitions TT$xxx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.    = /* Define ASN specific data structures types and constants */   1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/> #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */        /* **++* **	asn$read_done - Complete a read request ** ** Functional description: **G **	This routine will execute as a fork thread it will complete the read N ** request.  The decision loop is fairly straight forward.  If we have a VCIB L ** then complete the read using the VCI path.  If not the see if there us a H ** read IRP active.  If so it will complete the request using the IRP.   ** ** Calling convention: **< **	void	asn$read_done (uint64 fr3, uint64 fr4, ASNRD *asnrd) ** ** Input parameters: **
 **	FR3	Unused 
 **	FR4	Unused # **	ASNRD	Pointer to ASN read buffer  ** ** ** Output parameters:  ** **	None  ** ** Return value: ** **	None  ** ** Environment:  **- **	Kernel mode IPL 8 with the fork lock held.  ** **-- */8 void	asn$read_done(uint64 fr3, uint64 fr4, ASNRD *asnrd) {    int		length; int		request_size; int32		return_size;  int		saved_dipl; int		status;   VCRPSTACK	*stack;    ASNUCB		*asnucb; ASNVCIB		*vcib; 
 IRP		*irp; SYSBUF_HDR	*buf_hdr; TTY_UCB		*phyucb;  VCRP		*vcrp;    ' asnucb = (ASNUCB *) asnrd->asnrd$a_ucb; * vcib = (ASNVCIB *) asnucb->ucb$l_asn_vcib;4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  3 __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, -1);    if (!asnucb->ucb$v_asn_delpend)  {     /*     ** H    **	The VCI interface is the one most likely to be used.  So handle it    ** first.    **     */ #    if ((void *) vcib != (void *) 0)     {O       length = (char *) asnrd->asnrd$l_putptr - (char *) &asnrd->asnrd$t_frame; +       request_size = sizeof(VCRP) + length; O       status = exe_std$alononpaged(request_size, &return_size, (void *) &vcrp);        if (status & SS$_NORMAL)       { )          vcrp->vcrp$w_size = return_size; (          vcrp->vcrp$b_type = DYN$C_VCRP;+          vcrp->vcrp$b_rmod = SPL$C_IOLOCK8; '          vcrp->vcrp$w_common_flags = 0; &          vcrp->vcrp$a_dealloc_rtn = 0;#          vcrp->vcrp$a_dcb_link = 0; !          vcrp->vcrp$l_svapte = 0; O          vcrp->vcrp$l_buffer_address = (void *) ((char *) vcrp + sizeof(VCRP)); 9          vcrp->vcrp$l_boff = (unsigned int) sizeof(VCRP); 3          vcrp->vcrp$l_function = VCRP$K_FC_RECEIVE; 2          vcrp->vcrp$q_request_status = SS$_NORMAL;L          vcrp->vcrp$l_connection_id = (unsigned int) asnucb->ucb$l_asn_vcib;E          stack = (struct vcrpstackdef *) vcrp->vcrp$t_internal_stack; -          vcrp->vcrp$a_stack = (void *) stack; ]          stack->stack$l_btm = (void *) ((char *) stack->stack$t_stack +  STACK$K_STACK_SIZE); 6          stack->stack$l_lastused = stack->stack$l_btm;G          stack->stack$l_top = (void *) ((char *) stack->stack$t_stack); 0          status = asn$validate_read_pkt(asnucb, Q                                         (unsigned char *) &asnrd->asnrd$t_frame,  ^                                         length, (unsigned char *) vcrp->vcrp$l_buffer_address,1                                         &length); !          if (status & SS$_NORMAL) 
          {'             vcrp->vcrp$l_bcnt = length; 1             vcrp->vcrp$l_total_pdu_size = length; 1             VCI$XXX_Receive_Complete(vcrp, vcib); 
          }
          else 
          {             /*             **J             **	Bad FCS count it return the read packet and delete the VCRP             **             */+             asnucb->ucb$q_asn_bad_fcs += 1; /             exe_std$deanonpaged((void *) vcrp); 
          },          asn$return_read_pkt(asnucb, asnrd);       } 
       else       {           /*           ** J          **	Note that if another read packet is completed while this fork P          ** is outstanding and it can get a VCRP then reads will come in out of -          ** order.  This should never happen.           **           */ ;          __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1); 7          fork_wait(asn$read_done, 0, 0, (FKB *) asnrd); I          device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl); #             asn$input_stop(asnucb); L          device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);       }     }+    else if ((asnucb->ASNBASE.ucb$v_bsy) &&  >             ((void *)asnucb->ASNBASE.ucb$l_irp != (void *) 0))    {       /*       **F       **	If here then the VCI interface is not being used.  So see if M       ** there is an outstanding read.  If so we will give the packet to the  N       ** read path.  If some one is nutty enough to try and use both the read D       ** and VCI paths at the same time they will have loads of fun.       **       */O       length = (char *) asnrd->asnrd$l_putptr - (char *) &asnrd->asnrd$t_frame; &       irp = asnucb->ASNBASE.ucb$l_irp;1       buf_hdr = (SYSBUF_HDR *) irp->irp$l_svapte;$-       status = asn$validate_read_pkt(asnucb, *N                                      (unsigned char *) &asnrd->asnrd$t_frame, R                                      length, (unsigned char *) buf_hdr->pkt_datap,.                                      &length);$       if (length <= irp->irp$l_bcnt)       {hC          memcpy(buf_hdr->pkt_datap, &asnrd->asnrd$t_frame, length);n       } 
       else       {a           length = 0; !           status = SS$_BUFFEROVF;n       }n)       asn$return_read_pkt(asnucb, asnrd);*       irp->irp$l_bcnt = length;.?       ioc_std$reqcom(length << 16 | status, 0, (UCB *) asnucb);p%       if (!asnucb->ASNBASE.ucb$v_bsy)s       {i'          asnucb->ASNBASE.ucb$l_irp = 0;        }O    }    elseD    {       /*       **F       ** 	Assumption here is that we are using the $QIO path so place N       ** packet on queue of pending reads.  When the next read gets started it        ** will pick up this read.       **       */K       __PAL_INSQUEL((void *) asnucb->ucb$l_asn_packetq_bl, (void *) asnrd);     } }: else {     /*m    **oK    **	Delete is pending for this guy there is no reason to do anything withnK    ** this read buffer.  Place it on the queue of read packets there is no s$    ** reason to try and complete it.    **a    */tF    __PAL_INSQUEL((void *) asnucb->ucb$l_asn_readq_bl, (void *) asnrd); }p    a return;q   }      r /* **++* **	asn$read_startio - Start a read request ** ** Functional description: **E **	This routine is called by ioc_std$initiate to start the next read 9O ** request.  For the ASN driver the behavior is a bit different than the normaltO ** model.  Once input has been enabled on the device it will always read data. fN ** What this routine will do is see if a packet has already been received and L ** if so it will complete the request.  If not it will simply return as the H ** read done fork thread in the driver will locate the current read and . ** complete it with the packet it has in hand. ** ** Calling convention: **2 **	void	asn$read_startio(IRP *irp, ASNUCB *asnucb) ** ** Input parameters: **- **	irp		pointer to current I/O request packetd! **	asnucb		pointer to the ASN UCBc ** ** Output parameters:i ** **	Nonel ** ** Return value: ** **	Noneo ** ** Environment:  **+ **	Kernel mode IPL8 with the fork lock held  ** **-- *// void	asn$read_startio(IRP *irp, ASNUCB *asnucb)e {e   int		length; int		status;   ASNRD		*asnrd; SYSBUF_HDR	*buf_hdr; TTY_UCB		*phyucb;a  - if ((void *) asnucb->ucb$l_asn_packetq_fl != n+     (void *) &asnucb->ucb$l_asn_packetq_bl)n {2@    status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_packetq_fl,+                           (void *) &asnrd); L    length = (char *) asnrd->asnrd$l_putptr - (char *) &asnrd->asnrd$t_frame;.    buf_hdr = (SYSBUF_HDR *) irp->irp$l_svapte;*    status = asn$validate_read_pkt(asnucb, K                                   (unsigned char *) &asnrd->asnrd$t_frame, k*                                   length, K                                   (unsigned char *) &asnrd->asnrd$t_frame, r+                                   &length);h!    if (length <= irp->irp$l_bcnt)*    {@       memcpy(buf_hdr->pkt_datap, &asnrd->asnrd$t_frame, length);    }    elseC    {        length = 0;        status = SS$_BUFFEROVF;    }&    asn$return_read_pkt(asnucb, asnrd);    irp->irp$l_bcnt = length;<    ioc_std$reqcom(length << 16 | status, 0, (UCB *) asnucb);"    if (!asnucb->ASNBASE.ucb$v_bsy)    {$       asnucb->ASNBASE.ucb$l_irp = 0;    } }d   return;r   }c     i /* **++; **	asn$return_read_pkt - Decide what to do with read packet	 ** ** Functional description: **C **	This routine is called once the data has been copied from a read	J ** buffer to either a VCRP, or a read IRP.  It decides what to do with theN ** packet.  It will either place it on the queue of free read packets, or turn# ** it into the current read buffer.e ** ** Calling convention: **, **	void	asn$return_read_pkt (ASNUCB *asnucb) ** ** Input parameters: **! **	ASNUCB		Pointer to the ASN UCBa" **	ASNRD		Pointer to a read packet ** ** Output parameters:i ** **	Nonef ** ** Return value: ** **	None< ** ** Environment:f **= **	Kernel mode, system context, fork IPL with fork lock held.a ** **-- */9 void	asn$return_read_pkt(ASNUCB *asnucb, ASNRD *read_pkt)  {    int		saved_fipl;   TTY_UCB		*phyucb;n    4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  = read_pkt->asnrd$l_putptr = (void *) &read_pkt->asnrd$t_frame;u& read_pkt->asnrd$l_status = SS$_NORMAL;  @ device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_fipl);M    if (((void *)phyucb != (void *) 0) && (!asnucb->ucb$v_asn_input_disabled))y    {%       if ((phyucb->tty$v_st_read) &&  :           ((void *)phyucb->ucb$l_tt_typahd == (void *) 0))       {_5          phyucb->ucb$l_tt_typahd = (void *) read_pkt;s*          asnucb->ucb$v_asn_drop_chars = 0;4          if (asnucb->ucb$l_asn_rcv_state == RCV_OFF)
          {%             asn$input_resume(asnucb);n
          }       }_
       else       {yO          __PAL_INSQUEL((void *) asnucb->ucb$l_asn_readq_bl, (void *) read_pkt);s       }i    }    elsev    {L       __PAL_INSQUEL((void *) asnucb->ucb$l_asn_readq_bl, (void *) read_pkt);    }C device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_fipl, SMP_RESTORE);e   return;c   }<     s /* **++1 **	asn$validate_read_pkt - Validate a read packet< ** ** Functional description: **C **	This routine takes a raw read packet and removes the quoting and M ** validates the checksum.  After unquoting the packet it makes sure that thee5 ** packet is large enough if not it returns an error t ** ** Calling convention: **H **	int	asn$validate_read_pkt (ASNUCB *asnucb, unsigned char *in_buffer, P **                                     int in_length, unsigned char *out_buffer,P **                                     int *ret_length);                         ** ** Input parameters: **! **	asnucb		Poitner to the ASN UCBt' **	in_buffer	Raw packet to be validated 0 **	in_length	Length of raw input packet in bytes1 **	out_buffer	Receive packet with quoting removedu- **	ret_length	Lenght of packet minus checksumK ** ** Output parameters:o **1 **	out_buffer	Receive packet with quoting removed - **	ret_length	Lenght of packet minus checksumt ** ** Return value: **" **	SS$_BADCHKSUM	FCS was not valid# **	SS$_IVBUFLEN	Packet was to small  **	SS$_NORMAL	Packet was valid ** ** Environment:B **= **	Kernel mode, system context, fork IPL with fork lock held.S ** **-- */D int	asn$validate_read_pkt(ASNUCB *asnucb, unsigned char *in_buffer, G                               int in_length, unsigned char *out_buffer,u.                               int *ret_length) {d   int		status;    < *ret_length = asn$unquote(in_buffer, in_length, out_buffer); if (*ret_length > MINIMUM_MRU) { ;    status = asn$fcs_check(asnucb, out_buffer, *ret_length);     if (!(status & SS$_NORMAL))
    {      %       asnucb->ucb$q_asn_bad_fcs += 1;     };    *ret_length = *ret_length - asnucb->ucb$l_asn_fcs_rcv/8;o }p else {e$    asnucb->ucb$q_asn_runt_pkts += 1;    status = SS$_IVBUFLEN;N }A   return status;   }v     r /* **++, **	asn$write_done - Complete a write request ** ** Functional description: **H **	This routine executes at FORK IPL and will either be called from the N ** cancel I/O code path, or as a fork thread with the ASNWRT buffer acting as M ** the fork block.  The request is completed to the appropriate place.  Then *L ** the write buffer will be reset for next use.  Then if there are any more N ** packets to transmit they will be started.  If one of the packets cannot be J ** started it will be aborted and we will look to see if there is another  ** packet to start.b ** ** Calling convention: **? **	void	asn$write_done (uint64 fr3, uint64 fr4, ASNWRT *asnwrt)r ** ** Input parameters: ** **	fr3		Unused **	fr4		Unused) **      asnwrt		pointer to ASNWRT buffer.  ** ** Output parameters:  ** **	None> ** ** Return value: ** **	Nonet ** ** Environment:t **$ **	Kernel mode IPL 8 fork lock held. ** **-- */; void	asn$write_done(uint64 fr3, uint64 fr4, ASNWRT *asnwrt)  {    int		status;   ASNUCB		*asnucb; ASNVCIB		*vcib;r
 IRP		*irp; TTY_UCB		*phyucb;  VCRP		*vcrp;    & vcrp = (VCRP *) asnwrt->asnwrt$a_vcrp;) asnucb = (ASNUCB *) asnwrt->asnwrt$a_ucb; 4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;* vcib = (ASNVCIB *) asnucb->ucb$l_asn_vcib;    3 __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, -1);z$ if (vcrp->vcrp$b_type == DYN$C_VCRP) {_9    vcrp->vcrp$q_request_status = asnwrt->asnwrt$l_status; )    VCI$XXX_Transmit_Complete(vcrp, vcib);  }  else {S    irp = (IRP *) vcrp;F    irp->irp$l_iost1 = irp->irp$l_bcnt << 16 | asnwrt->asnwrt$l_status;    irp->irp$l_iost2 = 0;    com_std$post_nocnt(irp);$ }n   exe_std$deanonpaged(asnwrt);  " if ((void *) phyucb != (void *) 0) {,"    if (!asnucb->ucb$v_asn_delpend)    {       do       { E          status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_writeq_fl, 5                                 (void *) &irp);                 if (status >= 0)n
          {:             status = asn$write_start(asnucb, phyucb, irp);'             if (!(status & SS$_NORMAL))&
             {s3                if (vcrp->vcrp$b_type == DYN$C_VCRP),                {&                   vcrp = (VCRP *) irp;7                   vcrp->vcrp$q_request_status = status;n8                   VCI$XXX_Transmit_Complete(vcrp, vcib);                }                else                 {D                   irp->irp$l_iost1 = irp->irp$l_bcnt << 16 | status;'                   irp->irp$l_iost2 = 0;{*                   com_std$post_nocnt(irp);                }             }              else
             {                 break;f
             }e
          }
          else 
          {             break;
          }9       } while (((void *) &asnucb->ucb$l_asn_writeq_fl !=  7                 (void *) asnucb->ucb$l_asn_writeq_bl));/    } }e   return;r   }s     n /* **++, **	asn$write_startio - Start a write request ** ** Functional description: **E **	This routine is called by ioc_std$altqpkt to start the next write dM ** request.  For the ASN driver the behavior is a emulation of sorts of what &M ** TTDRIVER does.  If the device is busy it will simply place the IRP on the cL ** queue of pending write requests.  If the device is not busy it will call K ** the write startio routine.  The write startio code will quote the users tM ** buffer, and copy it to the output buffer.  It will also start the request.  ** ** Calling convention: **4 **	void	asn$write_startio (IRP *irp, ASNUCB *asnucb) ** ** Input parameters: **- **	irp		pointer to current I/O request packett! **	asnucb		pointer to the ASN UCB) ** ** Output parameters:A ** **	Nones ** ** Return value: ** **	NoneE ** ** Environment:  **( **	Kernel mode IPL 8 with fork lock held ** **-- */0 void	asn$write_startio(IRP *irp, ASNUCB *asnucb) {l   unsigned int	fcs;  int		saved_fipl; int		status;   SYSBUF_HDR	*buf_hdr; TTY_UCB		*phyucb;l  4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  C if (((void *)phyucb != (void *) 0) && (!asnucb->ucb$v_asn_delpend)): {l.    buf_hdr = (SYSBUF_HDR *) irp->irp$l_svapte;-    irp->irp$l_bcnt = asn$fcs_compute(asnucb, wK                                      (unsigned char *) buf_hdr->pkt_datap,  6                                      irp->irp$l_bcnt);#    if ((!phyucb->tty$v_st_write) &&>V        ((void *) asnucb->ucb$l_asn_writeq_bl == (void *) asnucb->ucb$l_asn_writeq_fl))    {4       status = asn$write_start(asnucb, phyucb, irp);!       if (!(status & SS$_NORMAL))l       {c#          irp->irp$l_iost1 = status;9          irp->irp$l_iost2 = 0;!          com_std$post_nocnt(irp);h       }r    }    else     {H       __PAL_INSQUEL((void *) asnucb->ucb$l_asn_writeq_bl, (void *) irp);    } }i else {o#    irp->irp$l_iost1 = SS$_DEVINACT;r    irp->irp$l_iost2 = 0;    com_std$post_nocnt(irp);f }t   return;m   }e