# #pragma module pppd$asndriver "X-7"  /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     >   		This module has the basic routines needed to define Asynch- 	device.  It contains the following routines:   - 		driver$inint_tables	-	Init DPT, DDT and FDT / 		asn$struc_init		-	Init device data structures 3 		asn$struc_reinit	-	Re-Init device data structures . 		asn$unit_init		-	Unit initialization routine$ 		asn$clone_ucb		-	Cloned UCB setup  		asn$cancel_io		-	Cancel I/O    	AUTHOR:   # 		Forrest A. Kenney	30-January-1996     	REVISION HISTORY:   / 	X-7	BWK001	Barry W. Kierstein	17-December-1996 A 		Replaced the standard Digital copyright with                    ( 		one compatible with the CMU copyright.  . 	X-6	FAK005	Forrest A. Kenney	04-November-1996> 		Do not allocate the write buffer in cloned_ucb code.  We are@ 		now going to get a write buffer when we start a write and free< 		it when a write is completed.  This allows us to clear the@ 		write flag when we abort a write or when it is done.  We loose7 		a little performance in the worse case allocating and 9 		deallocating pool but we simplify the logic for writes.   - 	X-5	FAK004	Forrest A. Kenney	04-October-1996 A 		Do not clear the writing state when aborting a write.  It will  7 		cleared when the write completion fork actually runs.   / 	X-4	FAK003	Forrest A. Kenney	05-September-1996 7 		In asn$clone_ucb routine fill in logical UCB address.   * 	X-3	FAK002	Forrest A. Kenney	06-June-19969 		Fix incorrect code where it was supposed to and against - 		SS$_NORMAL but it was coded as &SS$_NORMAL.   .   	X-2	FAK001	Forrest A. Kenney 	19-April-1996<   		Add logic to the unit initialization routine to copy the= 		terminal drivers DDT to a dummy DDT.  Then modify the dummy < 		DDT to have no cancel I/O routine or selective cancel I/O @ 		routine.  This is done so that when we swtich the class driver: 		to ASNDRIVER we can keep the terminal drivers cancel I/O 		routine from being called.   */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ 0 #include	<candef.h>	/* Cancel I/O defintions		*/: #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 1 #include	<dcdef.h>	/* Device class defintions		*/ 2 #include	<descrip.h>	/* DEscriptor definitions		*/< #include	<devdef.h>	/* Device characteristics definitions	*/7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ : #include	<dptdef.h>	/* Driver prologue table defintions	*/9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ = #include	<fdtdef.h>	/* Function decision table definitions	*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/6 #include	<iodef.h>	/* I/O function code definitions	*/+ #include	<ipldef.h>	/* IPL definitions			*/ 8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 5 #include	<ttdef.h>	/* Terminal definitions TT$xxx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/0 #include	<ttyvecdef.h>	/* TTY vector layout			*/( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.  = /* Define ASN specific data structures types and constants */   1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/> #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/8 #include	"pppd$asn_msgtbl.h"	/* Abort packet message		*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */      /* Define global storage */    DDT	asndummy_ddt;        /* **++. **	driver$inint_tables - Init DPT, DDT and FDT ** ** Functional description: **I **	This routine completes the initialization of the DPT, DDT, and the FDT H ** structures.  This routine is called once by the $LOAD_DRIVER service K ** immediately after the driver image is loaded or reloaded and before any  N ** validity checks are performed on the DPT, DDT, or FDT.  A prototype versionE ** of these structures is built into the image at link time from the  N ** VMS$VOLATILE_PRIVATE_INTERFACES.OLB library.  Note that the device related M ** data structures  (e.g. DDB, UCB, etc.) have not yet been created when this K ** routine is called.  The actions of this routine must be confined to the  M ** initialization of the DPT, DDT, and FDT structures which are contained in   ** the driver image. ** ** Calling convention: ** **	int	driver$init_tables ();  ** ** Input parameters: ** **	None  ** ** Output parameters:  ** **	None  ** ** Return value: **I **	status	If the status is not successful, then the driver image will not < **		be unloaded.  Note that the ini_* macros used below will@ **		result in a return from this routine with an error status if( **		an initialization error is detected. ** ** Environment:  **. **	Called at IPL as high as 31 in kernel mode. ** **-- */ int driver$init_tables()   {      /*   **@ ** Prototype driver DPT, DDT, and FDT will be pulled in from the< ** VMS$VOLATILE_PRIVATE_INTERFACES.OLB library at link time. ** */ extern DPT driver$dpt; extern DDT driver$ddt; extern FDT driver$fdt; extern TT_CLASS CLASS_VECTOR;   > /* Finish initialization of the Driver Prologue Table (DPT) */  / ini_dpt_name        (&driver$dpt, "ASNDRIVER"); , ini_dpt_adapt       (&driver$dpt, AT$_NULL);% ini_dpt_defunits    (&driver$dpt, 1); 2 ini_dpt_ucbsize     (&driver$dpt, sizeof(ASNUCB));2 ini_dpt_struc_init  (&driver$dpt, asn$struc_init);4 ini_dpt_struc_reinit(&driver$dpt, asn$struc_reinit);" ini_dpt_end         (&driver$dpt);  > /* Finish initialization of the Driver Dispatch Table (DDT) */  1 ini_ddt_unitinit    (&driver$ddt, asn$unit_init); 0 ini_ddt_cancel      (&driver$ddt, asn$cancelio);1 ini_ddt_cloneducb   (&driver$ddt, asn$clone_ucb); " ini_ddt_end         (&driver$ddt);  @ /* Finish initialization of the Function Decision Table (FDT) */  < ini_fdt_act (&driver$fdt, IO$_READLBLK, asn$read, BUFFERED);< ini_fdt_act (&driver$fdt, IO$_READPBLK, asn$read, BUFFERED);< ini_fdt_act (&driver$fdt, IO$_READVBLK, asn$read, BUFFERED);> ini_fdt_act (&driver$fdt, IO$_WRITELBLK, asn$write, BUFFERED);> ini_fdt_act (&driver$fdt, IO$_WRITEPBLK, asn$write, BUFFERED);> ini_fdt_act (&driver$fdt, IO$_WRITEVBLK, asn$write, BUFFERED);: ini_fdt_act (&driver$fdt, IO$_SETMODE, asn$set, BUFFERED);: ini_fdt_act (&driver$fdt, IO$_SETCHAR, asn$set, BUFFERED);> ini_fdt_act (&driver$fdt, IO$_SENSEMODE, asn$sense, BUFFERED);> ini_fdt_act (&driver$fdt, IO$_SENSECHAR, asn$sense, BUFFERED);   ini_fdt_end (&driver$fdt);  C /* If we got this far then everything worked, so return success. */    return SS$_NORMAL;   }          /* **++0 **	asn$struc_init		-	Init device data structures ** ** Functional description: **B **		This routine is called once for each unit by the $LOAD_DRIVER M ** service after the UCB is created.  At this point the UCB has not yet been  H ** fully linked into the I/O database.  This routine is responsible for M ** filling in driver specific fields in the I/O database structures that are  6 ** passed as parameters as parameters to this routine. **I **	Only those fields that are not affected by a driver reload are filled  N ** in.  In contrast, the structure reinitialization routine is responsible forM ** filling in the fields that need to be corrected when (and if) this driver   ** image is reloaded.  **I **	After this routine is called for a new unit, then the reinitilization  N ** is called as well.  Then the $LOAD_DRIVER service completes the integration= ** of these device specific structures into the I/O database.  ** ** ** Calling convention: **A **	void 	asn$struc_init (CRB *crb, DDB *ddb, IDB *idb, ORB *orb,   **				ASNUCB *asnucb); ** ** Input parameters: **. **	CRB	pointer to the controller request block# **	DDB	pointer to device data block . **	IDB	pointer to the interrupt dispatch block) **	ORB	pointer to the object rights block ( **	UCB	pointer to the unit control block ** ** Output parameters:e ** **	None* ** ** Return value: ** **	Nonen ** ** Environment:r **( **	Kernel mode, IPL may be as high as 31 ** **-- */L void 	asn$struc_init(CRB *crb, DDB *ddb, IDB *idb, ORB *orb, ASNUCB *asnucb) {a   extern short int TTY$GW_DEFBUF;e extern		 TTY$GL_DEFCHAR; extern		 TTY$GL_DEFCHAR2;w    ' /* Initiliaze fields in the base UCB */ + asnucb->ASNBASE.ucb$b_flck = SPL$C_IOLOCK8;h* asnucb->ASNBASE.ucb$b_dipl = IPL$_IOLOCK8;P asnucb->ASNBASE.ucb$l_devchar =  DEV$M_AVL | DEV$M_ODV | DEV$M_IDV | DEV$M_TRM |7                                  DEV$M_REC | DEV$M_CCL;D9 asnucb->ASNBASE.ucb$l_devchar2 = DEV$M_NNM | DEV$M_NOCLU; * asnucb->ASNBASE.ucb$b_devclass = DC$_TERM;, asnucb->ASNBASE.ucb$b_devtype = TT$_UNKNOWN;0 asnucb->ASNBASE.ucb$w_devbufsiz = TTY$GW_DEFBUF;1 asnucb->ASNBASE.ucb$l_devdepend = TTY$GL_DEFCHAR; 2 asnucb->ASNBASE.ucb$l_devdepnd2 = TTY$GL_DEFCHAR2;$ asnucb->ASNBASE.ucb$l_devdepnd3 = 0;$ asnucb->ASNBASE.ucb$l_devdepnd4 = 0;+ asnucb->ASNBASE.ucb$l_sts = UCB$M_TEMPLATE;	    * /* Initiliaze fields in the logical UCB */ asnucb->ucb$l_tt_logucb = 0;    3 /* Initialize fields in the ASN extension region */a( asnucb->ucb$l_asn_rcv_accm = 0xffffffff;, asnucb->ucb$l_asn_xmit_accm[0] = 0xffffffff;# asnucb->ucb$l_asn_xmit_accm[1] = 0; # asnucb->ucb$l_asn_xmit_accm[2] = 0;n, asnucb->ucb$l_asn_xmit_accm[3] = 0x60000000;# asnucb->ucb$l_asn_xmit_accm[4] = 0;-# asnucb->ucb$l_asn_xmit_accm[5] = 0;r# asnucb->ucb$l_asn_xmit_accm[6] = 0; # asnucb->ucb$l_asn_xmit_accm[7] = 0;  asnucb->ucb$l_asn_fcs_rcv = 16;   asnucb->ucb$l_asn_fcs_xmit = 16;( asnucb->ucb$l_asn_flow = ASN$M_XON_XOFF;$ asnucb->ucb$l_asn_mru = MAXIMUM_MRU;$ asnucb->ucb$l_asn_mtu = MAXIMUM_MTU;9 asnucb->ucb$l_asn_readq_fl = &asnucb->ucb$l_asn_readq_fl;e9 asnucb->ucb$l_asn_readq_bl = &asnucb->ucb$l_asn_readq_fl;n= asnucb->ucb$l_asn_packetq_fl = &asnucb->ucb$l_asn_packetq_fl;n= asnucb->ucb$l_asn_packetq_bl = &asnucb->ucb$l_asn_packetq_fl;s; asnucb->ucb$l_asn_writeq_fl = &asnucb->ucb$l_asn_writeq_fl;t; asnucb->ucb$l_asn_writeq_bl = &asnucb->ucb$l_asn_writeq_fl;	# asnucb->ucb$l_asn_write_buffer = 0;k  asnucb->ucb$q_asn_data_lost = 0;$ asnucb->ucb$q_asn_dropped_chars = 0; asnucb->ucb$q_asn_fe = 0;l  asnucb->ucb$q_asn_long_pkts = 0; asnucb->ucb$q_asn_pkts_rcv = 0;-  asnucb->ucb$q_asn_pkts_sent = 0;  asnucb->ucb$q_asn_runt_pkts = 0;" asnucb->ucb$q_asn_total_chars = 0;   return;    }2     	 /* **++4 **	asn$struc_reinit - Re-Init device data structures ** ** Functional description: **I **	This routine is called once for each unit by the $LOAD_DRIVER service oD ** immediately after the structure initialization routine is called. **B **	Additionally, this routine is called once for each unit by the J ** $LOAD_DRIVER service when a driver is reloaded.  Thus, this routine is M ** responsible for filling in the fields in the I/O database structures that A  ** point into this driver image. ** ** Calling convention: **B **	void 	asn$struc_reinit (CRB *crb, DDB *ddb, IDB *idb, ORB *orb, **				  ASNUCB *asnucb)f ** ** Input parameters: **. **	CRB	pointer to the controller request block# **	DDB	pointer to device data blocki. **	IDB	pointer to the interrupt dispatch block) **	ORB	pointer to the object rights blockn( **	UCB	pointer to the unit control block ** ** Output parameters:u ** **	None	 ** ** Return value: ** **	Nones ** ** Environment:f **G **	Kernel mode, system context, IPL may be as high as 31 and may not bet **	altered.n ** **-- */O void 	asn$struc_reinit (CRB *crb, DDB *ddb, IDB *idb, ORB *orb, ASNUCB *asnucb)  {i   extern DDT driver$ddt;     ddb->ddb$ps_ddt = &driver$ddt;     return;    }i     / /* **++. **	asn$unit_init - Unit initialization routine ** ** Functional description: **I **	This routine is called once for each unit by the $LOAD_DRIVER service hK ** after a new unit control block has been created, initialized, and fully BK ** integrated into the I/O database.  This routine is also called for each s# ** unit during power fail recovery.o ** ** Calling convention: **/ **	int	asn$unit_init (IDB *idb, ASNUCB *asnucb)< ** ** Input parameters: **. **	IDB	pointer to the interrupt dispatch block( **	UCB	pointer to the unit control block ** ** Output parameters:f ** **	Nonei ** ** Return value: **
 **	SS$_NORMAL	 ** ** Environment:f **" **	Called in kernel mode at IPL 31 ** **-- */- int  	asn$unit_init(IDB *idb, ASNUCB *asnucb)  {s   extern	DPT	*TTY$GL_DPT;n    ! if (!asnucb->ASNBASE.ucb$v_power)B { 6    asnucb->ucb$l_asn_createport = VCI$ASN_Create_Port;6    asnucb->ucb$l_asn_deleteport = VCI$ASN_Delete_Port;    /*o    ** F    **	Now copy the terminal driver DDT to our dummy DDT and remap the E    ** cancel I/O and selective cancel rotuines to ioc$return_success.g    **t    */	P    memcpy((void *) &asndummy_ddt, (void *) TTY$GL_DPT->dpt$ps_ddt, sizeof(DDT));-    asndummy_ddt.ddt$ps_cancel_2 = ioc$return;e@    asndummy_ddt.ddt$ps_cancel_selective_2 =  ioc$return_success; }f  ! asnucb->ASNBASE.ucb$v_online = 1;u   return SS$_NORMAL;   }o         /* **++$ **	asn$clone_ucb - Cloned UCB setup  ** ** Functional description: **D **	This routine is called after the template UCB has been cloned by N ** assigning channel to the template device.  It is responsible for allocatingN ** and setting up the read buffers and the write buffer.  If any errors occur K ** at this point the buffers will be deleted and an appropriate error will dM ** be reported.  The assign code will delete template device and report this   ** error back to the caller. ** ** Note:I **	The buffer will be sized to the maximum allowable value and will only eL ** be deleted when the device is going away.  This simplifies the design at L ** the expense of wasting some extra pool.  If operational experience shows 4 ** this to be a problem we can reopen this decision. ** ** Calling convention: **: **	int asn$clone_ucb (ASNUCB *asnucb, DDT *ddt, PCB *pcb, / **                         ASNUCB *parent_ucb);D ** ** Input parameters: ** **	ASNUCB		pointer to new UCBa( **	DDT		pointer to driver dispatch table; **	PCB		pointer to Process Control Block of cloning processe) **	PARENT_UCB	pointer to the template UCBn ** ** Output parameters:r **G **	UCB$L_ASN_READQ_FL	pointer to first element in the read buffer queuecE **	UCB$L_ASN_READQ_BL	pointer to last element in the read bufferqueue I **	UCB$L_ASN_PACKETQ_FL	pointer to first element in the read packet queue I **	UCB$L_ASN_PACKETKQ_BL	pointer to last element in the read packet queue B **	UCB$L_ASN_WRITEQ_FL	pointer to first element in the write queue@ **	UCB$L_ASN_WRITEQ_BL	pointer to last elenet in the write queue/ **	UCB$L_ASN_WRITE_BUFF	address of write buffer 	 **	Others* ** ** Return value: **
 **	SS$_NORMALs **	SS$_INSFMEM ** ** Environment:v **@ **	Kernel mode IPL 2 with the I/O database mutex held for write. ** **-- */I int	asn$clone_ucb(ASNUCB *asnucb, DDT *ddt, PCB *pcb, ASNUCB *parent_ucb)i {z   int		count = 0;c int		request_size; int32		return_size;  int		status;   ASNRD		*asnrd; ASNWRT		*asnwrt;    * /* Initiliaze fields in the logical UCB */) asnucb->ucb$l_tt_logucb = (UCB *) asnucb;b    3 /* Initialize fields in the ASN extension region */O asnucb->ucb$l_asn_flags = 0;( asnucb->ucb$l_asn_rcv_accm = 0xffffffff;, asnucb->ucb$l_asn_xmit_accm[0] = 0xffffffff;# asnucb->ucb$l_asn_xmit_accm[1] = 0;a# asnucb->ucb$l_asn_xmit_accm[2] = 0; , asnucb->ucb$l_asn_xmit_accm[3] = 0x60000000;# asnucb->ucb$l_asn_xmit_accm[4] = 0;&# asnucb->ucb$l_asn_xmit_accm[5] = 0;i# asnucb->ucb$l_asn_xmit_accm[6] = 0;s# asnucb->ucb$l_asn_xmit_accm[7] = 0;; asnucb->ucb$l_asn_fcs_rcv = 16;t  asnucb->ucb$l_asn_fcs_xmit = 16;( asnucb->ucb$l_asn_flow = ASN$M_XON_XOFF;$ asnucb->ucb$l_asn_mru = MAXIMUM_MRU;$ asnucb->ucb$l_asn_mtu = MAXIMUM_MTU;9 asnucb->ucb$l_asn_readq_fl = &asnucb->ucb$l_asn_readq_fl; 9 asnucb->ucb$l_asn_readq_bl = &asnucb->ucb$l_asn_readq_fl;c= asnucb->ucb$l_asn_packetq_fl = &asnucb->ucb$l_asn_packetq_fl;_= asnucb->ucb$l_asn_packetq_bl = &asnucb->ucb$l_asn_packetq_fl;h; asnucb->ucb$l_asn_writeq_fl = &asnucb->ucb$l_asn_writeq_fl;t; asnucb->ucb$l_asn_writeq_bl = &asnucb->ucb$l_asn_writeq_fl;t# asnucb->ucb$l_asn_write_buffer = 0;  asnucb->ucb$q_asn_fr3 = 0; asnucb->ucb$q_asn_fr4 = 0;  asnucb->ucb$q_asn_data_lost = 0;$ asnucb->ucb$q_asn_dropped_chars = 0; asnucb->ucb$q_asn_fe = 0;_  asnucb->ucb$q_asn_long_pkts = 0; asnucb->ucb$q_asn_pkts_rcv = 0;T  asnucb->ucb$q_asn_pkts_sent = 0;  asnucb->ucb$q_asn_runt_pkts = 0;" asnucb->ucb$q_asn_total_chars = 0;   /* **9 ** Allocate read packets and place them on the read queuet **J **  Request size = 2 * mru + (16 bytes for address, control, and protocol C **                             fields) + SIZE of read packet headert **   ** */K request_size = 2 * asnucb->ucb$l_asn_mru + PACKET_OVERHEAD + sizeof(ASNRD);  do {*K    status = exe_std$allocbuf(request_size, &return_size, (void **) &asnrd);i    if (status & SS$_NORMAL)i    {(       asnrd->asnrd$w_size = return_size;&       asnrd->asnrd$b_type = DYN$C_FRK;*       asnrd->asnrd$b_flck = SPL$C_IOLOCK8;=       asnrd->asnrd$l_putptr = (void *) &asnrd->asnrd$t_frame;lJ       asnrd->asnrd$l_end_frame = (void *) ((char *) asnrd + request_size);+       asnrd->asnrd$a_ucb = (void *) asnucb;tI       __PAL_INSQUEL((void *) asnucb->ucb$l_asn_readq_bl, (void *) asnrd);r    }< } while ((++count < READ_BUFFERS) && (status & SS$_NORMAL));     if (status & SS$_NORMAL) {f'    asnucb->ASNBASE.ucb$v_deleteucb = 0; $    asnucb->ASNBASE.ucb$v_online = 1; }    return status; }      * /* **++ **	asn$cancel_io -	Cancel I/O  ** ** Functional description: **@ **		When an application issues a cancel I/O operation the paths J ** actions taken are different for read and write request.  The following  ** will occur: **H **	1. The queue of current outstanding I/O requests will be cleaned all A **	   and all queued requests will be completed with a reason of B **	   SS$_CANCEL.tD **	2. The current read the request will be terminated with a reason 8 **	   of SS$_ABORT.  Note that no data will be returned.H **	3. The queue of pending writes will be cleaned all queued write will / **	   be completed with a reason of SS$_CANCEL.aI **	4. The write that is in progress will be terminated with a rewason of  E **	   SS$_ABORT.  The system write buffer will be made available for * **	   the next write.aH **	5. The port driver will be called and told about the transmit.  This I **	   will typically result in us sending a malformed frame.  Send a flagsI **	   sequence 0x7e after the port driver does the abort.  My reading of LF **	   the specification leads me to believe that this is optional but  **	   doing it should not hurt.  **  H **	If the reason is CAN$C_DASSGN, the reference count is zero, and there@ **  is no VCIB the following additional steps will be performed. **" **	1. Write buffer will be deleted< **	2. The read queue will be emptied and the buffers deletedO **	3. If the device is still linked dyn$revert will be called to break the link U **	4. A deletion fork will be started to delete the UCB if one is not already startedd ** ** Calling convention: **D **	void	asn$cancelio (int chan, IRP *irp, PCB *pcb, ASNUCB *asnnucb,) **                            int reason)l ** ** Input parameters: **9 **	Reason		reason for cancel CAN$C_CANCEL or CAN$C_DASSGNu! **	ASNUCB		pointer to the ASN UCBf< **	PCB		pointer to the PCB for process requesting the cancel" **	IRP		IRP in the UCB$L_IRP field, **	Channel		channel number the cancel is for ** ** Output parameters:b **7 **	Numerous fields in the terminal UCB will be modified] ** ** Return value: ** **	None[ ** ** Environment:$ **H **	This routine is called with the fork lock held.  It will acquire the  **	device lock as well.b ** **-- */K void	asn$cancelio(int chan, IRP *irp, PCB *pcb, ASNUCB *asnucb, int reason)d {l   unsigned char	out_char;_   int		saved_dipl; int		status;   ASNWRT		*asnwrt; IRP		*next_irp;b IRP		*read_irp;t IRP		*write_irp; TTY_UCB		*phyucb;n   extern		EXE$GL_ABSTIM;    4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  . com_std$flushattns(pcb, (UCB *) asnucb, chan, <                    (ACB **) &asnucb->ASNLOG.ucb$l_tl_ctrly);   /* ** _J ** Cancel current read IRP if it matches the PID and channel.  The current ** frame is left alone ** */% read_irp = asnucb->ASNBASE.ucb$l_irp;  if (asnucb->ASNBASE.ucb$v_bsy) {02    if ((read_irp->irp$l_pid == pcb->pcb$l_pid) && &        (read_irp->irp$l_chan == chan))    {$       asnucb->ASNBASE.ucb$l_irp = 0;       read_irp->irp$l_bcnt = 0;I(       read_irp->irp$l_iost1 = SS$_ABORT;#       com_std$post_nocnt(read_irp);     } }    /* **4 ** Cancel any writes that match the PID and channel. ** */S if ( (void *) &asnucb->ucb$l_asn_writeq_fl != (void *) asnucb->ucb$l_asn_writeq_bl)c {e2    next_irp = (IRP *) asnucb->ucb$l_asn_writeq_fl;    doa    {  4       if ((next_irp->irp$l_pid == pcb->pcb$l_pid) &&)           (next_irp->irp$l_chan == chan))e       {e+           next_irp = next_irp->irp$l_ioqfl;*L           __PAL_REMQUEL((void *)next_irp->irp$l_ioqbl, (void *) &write_irp);/           write_irp->irp$l_svapte = (void *) 0; $           write_irp->irp$l_bcnt = 0;.           write_irp->irp$l_iost1 = SS$_CANCEL;(           com_std$post_nocnt(write_irp);       }e
       else       { +           next_irp = next_irp->irp$l_ioqfl;*       }tH    } while ((void *) &asnucb->ucb$l_asn_writeq_fl != (void *) next_irp); }*     /* **; ** Now kill current write if it matches the PID and channely ** */    " if ((void *) phyucb != (void *) 0) {bC    device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);        asnwrt = 0; !       if (phyucb->tty$v_st_write)n       {e<          asnwrt = (ASNWRT *) asnucb->ucb$l_asn_write_buffer;3          write_irp = (IRP *) asnwrt->asnwrt$a_vcrp;a0          if (write_irp->irp$b_type == DYN$C_IRP)
          {;             if ((write_irp->irp$l_pid == pcb->pcb$l_pid) &&h0                 (write_irp->irp$l_chan == chan))
             {,3                asnwrt->asnwrt$l_status = SS$_ABORT;h*                phyucb->tty$v_st_write = 0;A                __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1);i2                exe_std$queue_fork((FKB *) asnwrt);"                port$abort(phyucb);#                port$resume(phyucb);*D                phyucb->ucb$w_tt_multilen = strlen(asn$abort_string);9                phyucb->ucb$l_tt_multi = asn$abort_string;**                phyucb->tty$v_st_multi = 1;0                out_char = class$getnext(phyucb);0                if (phyucb->ucb$b_tt_outype != 0)                {1                   port$startio(out_char, phyucb);n                }
             };
          }       }nF    device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE); }i     /* **F ** 	If this is the last reference to the device, and there is no VCIB O ** associated and the cancel reason is CAN$C_DASSGN then prepare to make it go dN ** away.  The prepare for delete routine will flush all pending I/O so no need ** to do it here.  ** */) if ((asnucb->ASNBASE.ucb$l_refc == 0) && t-     (asnucb->ucb$l_asn_vcib == (void *) 0) &&e     (reason == CAN$C_DASSGN))  { "    asn$prepare_for_delete(asnucb); }C   return;e   } 