 #pragma module ppp_driver "X-2"  /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		PPPDRIVER    
 	ABSTRACT:     D   		This module the basic driver routines needed to load the driver.+ 	The following routines are in this module:   - 		driver$inint_tables	-	Init DPT, DDT and FDT / 		ppp$struc_init		-	Init device data structures 3 		ppp$struc_reinit	-	Re-Init device data structures . 		ppp$unit_init		-	Unit initialization routine   	AUTHOR:     		Patrick Crilly		23-March-1996 . 		Modified from work done by Forrest A. Kenney    	REVISION HISTORY:   -   	X-2	BWK001		Barry W. Kierstein	17-DEC-1996 0   		Replaced the standard Digital copyright with6                 one compatible with the CMU copyright. */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ 0 #include	<candef.h>	/* Cancel I/O defintions		*/: #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 1 #include	<dcdef.h>	/* Device class defintions		*/ 2 #include	<descrip.h>	/* DEscriptor definitions		*/< #include	<devdef.h>	/* Device characteristics definitions	*/7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ : #include	<dptdef.h>	/* Driver prologue table defintions	*/9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ = #include	<fdtdef.h>	/* Function decision table definitions	*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/6 #include	<iodef.h>	/* I/O function code definitions	*/+ #include	<ipldef.h>	/* IPL definitions			*/ 8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 5 #include	<ttdef.h>	/* Terminal definitions TT$xxx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/0 #include	<ttyvecdef.h>	/* TTY vector layout			*/( #include	<ucbdef.h>	/* UCB offsets				*/    ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */   # /* Include files required by PPP */ L #include "lcp_vms.h"           /* Include definition of lcp_init          */L #include "ppp_async.h"         /* Include definition of device_init       */L #include "ppp_lib.h"           /* Include definition of library constants */L #include "fsm_if.h"            /* Include definition of fsmRtns           */L #include "ppp_timer.h"         /* Include definition of timer_init        */L #include "magic.h"             /* Include definition of magic_init        */L #include "ppp_driver.h"        /* Include prototypes for this module      */L #include "ppp_mgmt_if.h"       /* Include definition of mgmtRtns          */L #include "ppp_vci_if.h"        /* Include definition of VCIRTNS           */     /*   ** Global variables  */8 extern mgmtRtns mgmtVector; /* Table of mgmt routines */8 extern fsmRtns  fsmVector;  /* Table of fsm routines  */8 extern VCIRTNS  VCIVector;  /* Table of VCI routines  */  7 /* Declare array to store pointer to routine vectors */ " void *pppVectorTbl[ PPP_LST_RTN ];     /* **++. **	driver$inint_tables - Init DPT, DDT and FDT ** ** Functional description: **I **	This routine completes the initialization of the DPT, DDT, and the FDT H ** structures.  This routine is called once by the $LOAD_DRIVER service K ** immediately after the driver image is loaded or reloaded and before any  N ** validity checks are performed on the DPT, DDT, or FDT.  A prototype versionE ** of these structures is built into the image at link time from the  N ** VMS$VOLATILE_PRIVATE_INTERFACES.OLB library.  Note that the device related N *** data structures  (e.g. DDB, UCB, etc.) have not yet been created when thisK ** routine is called.  The actions of this routine must be confined to the  M ** initialization of the DPT, DDT, and FDT structures which are contained in   ** the driver image. ** ** Calling convention: ** **	int	driver$init_tables ();  ** ** Input parameters: ** **	None  ** ** Output parameters:  ** **	None  ** ** Return value: **E **	status	If the status is not successful, then the driver image will < **		be unloaded.  Note that the ini_* macros used below will@ **		result in a return from this routine with an error status if( **		an initialization error is detected. ** ** Environment:  **. **	Called at IPL as high as 31 in kernel mode. ** **-- */ int driver$init_tables()   {    /*   **: ** Prototype driver DPT and DDT will be pulled in from the< ** VMS$VOLATILE_PRIVATE_INTERFACES.OLB library at link time. ** */ extern DPT driver$dpt; extern DDT driver$ddt;    /* Initilise ppp vector table */  4 pppVectorTbl[ PPP_MGMT_RTNS ] = (void *)&mgmtVector;3 pppVectorTbl[ PPP_FSM_RTNS ]  = (void *)&fsmVector; 3 pppVectorTbl[ PPP_VCI_RTNS ]  = (void *)&VCIVector;   > /* Finish initialization of the Driver Prologue Table (DPT) */  / ini_dpt_name        (&driver$dpt, "PPPDRIVER"); , ini_dpt_adapt       (&driver$dpt, AT$_NULL);% ini_dpt_defunits    (&driver$dpt, 1); / ini_dpt_ucbsize     (&driver$dpt, sizeof(UCB)); 2 ini_dpt_struc_init  (&driver$dpt, ppp$struc_init);4 ini_dpt_struc_reinit(&driver$dpt, ppp$struc_reinit);& ini_dpt_maxunits    (&driver$dpt, 1 );> ini_dpt_vector      (&driver$dpt, (void( **)())pppVectorTbl );" ini_dpt_end         (&driver$dpt);  > /* Finish initialization of the Driver Dispatch Table (DDT) */  1 ini_ddt_unitinit    (&driver$ddt, ppp$unit_init); " ini_ddt_end         (&driver$ddt);  C /* If we got this far then everything worked, so return success. */    return SS$_NORMAL;   }          /* **++0 **	ppp$struc_init		-	Init device data structures ** ** Functional description: **B **		This routine is called once for each unit by the $LOAD_DRIVER M ** service after the UCB is created.  At this point the UCB has not yet been  H ** fully linked into the I/O database.  This routine is responsible for M ** filling in driver specific fields in the I/O database structures that are  6 ** passed as parameters as parameters to this routine. **I **	Only those fields that are not affected by a driver reload are filled  N ** in.  In contrast, the structure reinitialization routine is responsible forM ** filling in the fields that need to be corrected when (and if) this driver   ** image is reloaded.  **I **	After this routine is called for a new unit, then the reinitilization  N ** is called as well.  Then the $LOAD_DRIVER service completes the integration= ** of these device specific structures into the I/O database.  ** ** ** Calling convention: **A **	void 	ppp$struc_init (CRB *crb, DDB *ddb, IDB *idb, ORB *orb,   **				ASNUCB *asnucb); ** ** Input parameters: **. **	CRB	pointer to the controller request block# **	DDB	pointer to device data block . **	IDB	pointer to the interrupt dispatch block) **	ORB	pointer to the object rights block ( **	UCB	pointer to the unit control block ** ** Output parameters:  ** **	None  ** ** Return value: ** **	None  ** ** Environment:  **( **	Kernel mode, IPL may be as high as 31 ** **-- */I void 	ppp$struc_init(CRB *crb, DDB *ddb, IDB *idb, ORB *orb, UCB *pppucb)  {   ' /* Initiliaze fields in the base UCB */ ( pppucb->ucb$b_flck      = SPL$C_IOLOCK8;' pppucb->ucb$b_dipl      = IPL$_IOLOCK8; % pppucb->ucb$l_devchar   = DEV$M_AVL;  2 pppucb->ucb$l_devchar2  = DEV$M_NNM | DEV$M_NOCLU;# pppucb->ucb$b_devclass  = DC$_MISC; & pppucb->ucb$b_devtype   = DT$_TTYUNKN; pppucb->ucb$w_devbufsiz = 0; pppucb->ucb$l_devdepend = 0; pppucb->ucb$l_devdepnd2 = 0; pppucb->ucb$l_devdepnd3 = 0; pppucb->ucb$l_devdepnd4 = 0;   return;    }        /* **++4 **	ppp$struc_reinit - Re-Init device data structures ** ** Functional description: **I **	This routine is called once for each unit by the $LOAD_DRIVER service  D ** immediately after the structure initialization routine is called. **B **	Additionally, this routine is called once for each unit by the J ** $LOAD_DRIVER service when a driver is reloaded.  Thus, this routine is M ** responsible for filling in the fields in the I/O database structures that    ** point into this driver image. ** ** Calling convention: **B **	void 	asn$struc_reinit (CRB *crb, DDB *ddb, IDB *idb, ORB *orb, **				  UCB *pppucb) ** ** Input parameters: **. **	CRB	pointer to the controller request block# **	DDB	pointer to device data block . **	IDB	pointer to the interrupt dispatch block) **	ORB	pointer to the object rights block ( **	UCB	pointer to the unit control block ** ** Output parameters:  ** **	None  ** ** Return value: ** **	None  ** ** Environment:  **G **	Kernel mode, system context, IPL may be as high as 31 and may not be* **	altered.* ** **-- */L void 	ppp$struc_reinit (CRB *crb, DDB *ddb, IDB *idb, ORB *orb, UCB *pppucb) {    extern DDT driver$ddt;   ddb->ddb$ps_ddt = &driver$ddt;   return;n   }c     i /* **++. **	ppp$unit_init - Unit initialization routine ** ** Functional description: **I ** This routine is called once for each unit by the $LOAD_DRIVER service gK ** after a new unit control block has been created, initialized, and fully nK ** integrated into the I/O database.  This routine is also called for each .# ** unit during power fail recovery.y ** ** Calling convention: **, **	int	ppp$unit_init (IDB *idb, UCB *pppucb) ** ** Input parameters: **. **	IDB	pointer to the interrupt dispatch block( **	UCB	pointer to the unit control block ** ** Output parameters:H ** **	NoneN ** ** Return value: **
 **	SS$_NORMALI ** ** Environment:R **" **	Called in kernel mode at IPL 31 ** **-- */* int  	ppp$unit_init(IDB *idb, UCB *pppucb) {*   if (!pppucb->ucb$v_power)  {	)     /* fork a call to the init routine */mF     fork(  ppp$init, (uint64)pppucb, 0, (FKB *) &pppucb->ucb$l_fqfl ); }r   return SS$_NORMAL;   }  /* **++ **  FUNCTION NAME: ** **      ppp$init ** **  FUNCTIONAL DESCRIPTION:a **G **      This function is called when the PPP executive image is loaded.nE **      It performs any initialisation PPP requires.  If this routiney2 **      succeeds it sets the UCB status to online. ** **  FORMAL PARAMETERS: **( **	UCB	pointer to the unit control block ** **  IMPLICIT INPUTS: **
 **      None.i ** **  IMPLICIT OUTPUTS:  **
 **      None.b **& **  function value or completion codes ** **      None ** **  SIDE EFFECTS:s **
 **      None.e ** **-- */ void ppp$init( UCB *pppucb)s { +     /* initialise magic number generator */s     magic_init();d       /* initialise LCP */     lcp_init();   #     /* initialise timer routines */s     timerInit();       /* initialise device */i     if ( deviceInit() )      {e# 	pppucb->ucb$l_sts |= UCB$M_ONLINE;s     }i       return;h }*  