/************************************************************************
**                                                                      *
** Copyright  1996 Digital Equipment Corporation.                      *
** All rights reserved.                                                 *
**                                                                      *
** Redistribution and use in source and binary forms are permitted      *
** provided that the above copyright notice and this paragraph are      *
** duplicated in all such forms and that any documentation,             *
** advertising materials, and other materials related to such           *
** distribution and use acknowledge that the software was developed     *
** by Digital Equipment Corporation.  The name of the                   *
** Corporation may not be used to endorse or promote products derived   *
** from this software without specific prior written permission.        *
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       *
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       *
** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *
**                                                                      *
*************************************************************************
**++
**  FACILITY:
**
**      ppp_magic.h.
**
**  ABSTRACT:
**
**      Constant defintions and external defs of variables in magic.c
**
**  AUTHORS:
**
**      Patrick Crilly,   Networks Engineering (Australia).
**
**  CREATION DATE:
**
**      6-December-1995
**
**  MODIFICATION HISTORY:
**
**      17-December-1996  Barry W. Kierstein
**                        Replaced the standard Digital copyright with
**                        one compatible with the CMU copyright.
**
**      24-July-1996      Barry W. Kierstein
**                        Corrected copyright notice.
**
**      6-December-1995  Original version.
**
**--
*/
#ifndef _MAGIC_H_
#define _MAGIC_H_

/*
**
** import definitions:
**        prototype macro
**        types
**
*/
#ifndef _PPPD_H_
#include "pppd.h"
#endif

/*
** Prototypes
*/
void magic_init(void);		/* Initialize the magic number generator */
u_int32_t magic(void);		/* Returns the next magic number         */
static u_int32_t pppRand(void);	/* Our own random function               */
static void pppSrand(int);	/* Set the seed of the random func.      */

#endif /* _MAGIC_H_ */
