 /*%  * lcp.c - PPP Link Control Protocol.   *2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *1  * Copyright (c) 1989 Carnegie Mellon University.   * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 2  * by Carnegie Mellon University.  The name of theD  * University may not be used to endorse or promote products derived@  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  */    #ifndef lintK static char rcsid[] = "$Id: lcp.c,v 1.21 1995/08/10 06:51:06 paulus Exp $";  #endif   /*  * TODO:  */      #include <assert.h>  #include <string.h>    #ifndef   __VMS  #include <stdio.h> #include <syslog.h>  #include <sys/ioctl.h> #include <sys/types.h> #include <sys/socket.h>  #include <sys/time.h>  #include <netinet/in.h>  #endif   /* __VMS */   #include "pppd.h"  #include "fsm.h" #include "lcp.h" #include "magic.h"  
 #ifndef __VMS  #include "chap.h"  #include "upap.h"  #include "ipcp.h"  #endif    /* __VMS */   % #ifdef   __VMS     /* VMS includes */  #include "lcp_vms.h" #endif  & #ifdef _linux_		/* Needs ppp ioctls */ #include <net/if.h>  #include <linux/if_ppp.h>  #endif   /* global vars */ 
 #ifndef __VMS 7 fsm lcp_fsm[NUM_PPP];			/* LCP fsm structure (global)*/ K lcp_options lcp_wantoptions[NUM_PPP];	/* Options that we want to request */ B lcp_options lcp_gotoptions[NUM_PPP];	/* Options that peer ack'd */M lcp_options lcp_allowoptions[NUM_PPP];	/* Options we allow peer to request */ @ lcp_options lcp_hisoptions[NUM_PPP];	/* Options that we ack'd */> u_int32_t xmit_accm[NUM_PPP][8];		/* extended transmit ACCM */  M static u_int32_t lcp_echos_pending = 0;	/* Number of outstanding echo msgs */ J static u_int32_t lcp_echo_number   = 0;	/* ID number of next echo frame */N static u_int32_t lcp_echo_timer_running = 0;  /* TRUE if a timer is running */ #endif /* __VMS */  H static u_char nak_buffer[PPP_MRU];	/* where we construct a nak packet */     #ifdef _linux_! u_int32_t idle_timer_running = 0;  extern int idle_time_limit;  #endif   /*%  * routines to send LCP echos to peer   */   * static void LcpEchoTimeout __P((caddr_t));C static void lcp_received_echo_reply __P((int, int, u_char *, int)); * static void LcpSendEchoRequest __P((int));& static void LcpLinkFailure __P((int));  
 #ifndef __VMS B static fsm_callbacks lcp_callbacks = {	/* LCP callback routines */;     lcp_resetci,		/* Reset our Configuration Information */ >     lcp_cilen,			/* Length of our Configuration Information */8     lcp_addci,			/* Add our Configuration Information */8     lcp_ackci,			/* ACK our Configuration Information */8     lcp_nakci,			/* NAK our Configuration Information */;     lcp_rejci,			/* Reject our Configuration Information */ ?     lcp_reqci,			/* Request peer's Configuration Information */ 8     lcp_up,			/* Called when fsm reaches OPENED state */9     lcp_down,			/* Called when fsm leaves OPENED state */ ?     lcp_starting,		/* Called when we want the lower layer up */ A     lcp_finished,		/* Called when we want the lower layer down */ 6     NULL,			/* Called when Protocol-Reject received */-     NULL,			/* Retransmission is necessary */ ;     lcp_extcode,		/* Called to handle LCP-specific codes */ )     "LCP"			/* String name of protocol */  }; #endif' int lcp_loopbackfail = DEFLOOPBACKFAIL;    /*:  * Length of each type of configuration option (in octets)  */  #define CILEN_VOID	26 #define CILEN_SHORT	4	/* CILEN_VOID + sizeof(short) */9 #define CILEN_CHAP	5	/* CILEN_VOID + sizeof(short) + 1 */ 4 #define CILEN_LONG	6	/* CILEN_VOID + sizeof(long) */C #define CILEN_LQR	8	/* CILEN_VOID + sizeof(short) + sizeof(long) */   / #define CODENAME(x)	((x) == CONFACK ? "ACK" : \ # 			 (x) == CONFNAK ? "NAK" : "REJ")     
 #ifndef __VMS  /*  * lcp_init - Initialize LCP.   */  void lcp_init(unit)
     int unit;  {      fsm *f = LCP_FSM(unit); -     lcp_options *wo = &LCP_WANTOPTIONS(unit); .     lcp_options *ao = &LCP_ALLOWOPTIONS(unit);       f->unit = unit;      f->protocol = PPP_LCP;"     f->callbacks = &lcp_callbacks;       fsm_init(f);       wo->passive = 0;     wo->silent = 0; ;     wo->restart = 0;			/* Set to 1 in kernels or multi-line  					   implementations */     wo->neg_mru = 1;     wo->mru = DEFMRU;      wo->neg_asyncmap = 0;      wo->asyncmap = 0; 0     wo->neg_chap = 0;			/* Set to 1 on server */0     wo->neg_upap = 0;			/* Set to 1 on server */&     wo->chap_mdtype = CHAP_DIGEST_MD5;     wo->neg_magicnumber = 1;     wo->neg_pcompression = 1;      wo->neg_accompression = 1;6     wo->neg_lqr = 0;			/* no LQR implementation yet */       ao->neg_mru = 1;     ao->mru = MAXMRU;      ao->neg_asyncmap = 1;      ao->asyncmap = 0;      ao->neg_chap = 1; &     ao->chap_mdtype = CHAP_DIGEST_MD5;     ao->neg_upap = 1;      ao->neg_magicnumber = 1;     ao->neg_pcompression = 1;      ao->neg_accompression = 1;6     ao->neg_lqr = 0;			/* no LQR implementation yet */  5     memset(xmit_accm[unit], 0, sizeof(xmit_accm[0])); $     xmit_accm[unit][3] = 0x60000000; }  #endif /* __VMS */   /*(  * lcp_open - LCP is allowed to come up.  */  void lcp_open(unit)
     int unit;  {      fsm *f = LCP_FSM(unit); -     lcp_options *wo = &LCP_WANTOPTIONS(unit);        f->flags = 0;      if (wo->passive) 	f->flags |= OPT_PASSIVE;      if (wo->silent)  	f->flags |= OPT_SILENT;     fsm_open(f); }    /*  * lcp_close - Take LCP down.   */  void lcp_close(unit) 
     int unit;  {      fsm *f = LCP_FSM(unit);   E     if (f->state == STOPPED && f->flags & (OPT_PASSIVE|OPT_SILENT)) {  	/* @ 	 * This action is not strictly according to the FSM in RFC1548,< 	 * but it does mean that the program terminates if you do a@ 	 * lcp_close(0) in passive/silent mode when a connection hasn't 	 * been established.  	 */ 	f->state = CLOSED;  	lcp_finished(f);   
     } else 	fsm_close(f); }    #ifdef _linux_) static void IdleTimeCheck __P((caddr_t));    /*=  * Timer expired for the LCP echo requests from this process.   */    static void  RestartIdleTimer (f)     fsm *f;  {      u_long             delta;      struct ppp_idle    ddinfo; /*4  * Read the time since the last packet was received.  */ /     if (ioctl (fd, PPPIOCGIDLE, &ddinfo) < 0) { 3         syslog (LOG_ERR, "ioctl(PPPIOCGIDLE): %m");          die (1);     }  /*D  * Compute the time since the last packet was received. If the timer)  *  has expired then disconnect the line.   */ 8     delta = idle_time_limit - (u_long) ddinfo.recv_idle;6     if (((int) delta <= 0L) && (f->state == OPENED)) {L         syslog (LOG_NOTICE, "No IP frames received within idle time limit");, 	lcp_close(f->unit);		/* Reset connection */, 	phase = PHASE_TERMINATE;	/* Mark it down */     } else {         if ((int) delta <= 0L)& 	    delta = (u_long) idle_time_limit;-         /* assert (idle_timer_running==0); */ 4         TIMEOUT (IdleTimeCheck, (caddr_t) f, delta);         idle_timer_running = 1;      }  }    /*D  * IdleTimeCheck - Timer expired on the IDLE detection for IP frames  */    static void  IdleTimeCheck (arg)      caddr_t arg; { "     if (idle_timer_running != 0) {         idle_timer_running = 0; '         RestartIdleTimer ((fsm *) arg);      }  }  #endif   /*'  * lcp_lowerup - The lower layer is up.   */  void lcp_lowerup(unit) 
     int unit;  {   
 #ifndef __VMS      sifdown(unit);)     ppp_set_xaccm(unit, xmit_accm[unit]); 5     ppp_send_config(unit, PPP_MRU, 0xffffffff, 0, 0); 5     ppp_recv_config(unit, PPP_MRU, 0x00000000, 0, 0);      peer_mru[unit] = PPP_MRU; 9     lcp_allowoptions[unit].asyncmap = xmit_accm[unit][0];  #endif /* __VMS */       fsm_lowerup(LCP_FSM(unit));  }      /*+  * lcp_lowerdown - The lower layer is down.   */  void lcp_lowerdown(unit) 
     int unit;  { !     fsm_lowerdown(LCP_FSM(unit));  }      /*   * lcp_input - Input LCP packet.  */  void lcp_input(unit, p, len) 
     int unit;      u_char *p;     int len; {      int oldstate;      fsm *f = LCP_FSM(unit); ,     lcp_options *go = &LCP_GOTOPTIONS(unit);       oldstate = f->state;     fsm_input(f, p, len);   
 #ifndef __VMS 5     if (oldstate == REQSENT && f->state == ACKSENT) {  	/* 7 	 * The peer will probably send us an ack soon and then 9 	 * immediately start sending packets with the negotiated 9 	 * options.  So as to be ready when that happens, we set 9 	 * our receive side to accept packets as negotiated now.  	 */" 	ppp_recv_config(f->unit, PPP_MRU,. 			go->neg_asyncmap? go->asyncmap: 0x00000000,0 			go->neg_pcompression, go->neg_accompression);     }  #endif      }      /*,  * lcp_extcode - Handle a LCP-specific code.  */  int % lcp_extcode(unit, code, id, inp, len) 
     int unit;      int code, id;      u_char *inp;     int len; {      u_char *magp;      fsm    *f = LCP_FSM(unit);,     lcp_options *go = &LCP_GOTOPTIONS(unit);       switch( code ){      case PROTREJ:  	lcp_rprotrej(unit, inp, len); 	break;           case ECHOREQ:  	if (f->state != OPENED) 	    break; > 	LCPDEBUG((f, LOG_INFO, "lcp: Echo-Request, Rcvd id %d", id)); 	magp = inp;  	PUTLONG(go->magicnumber, magp);% 	fsm_sdata(f, ECHOREP, id, inp, len);  	break;           case ECHOREP: - 	lcp_received_echo_reply(unit, id, inp, len);  	break;        case DISCREQ:  	break;        default:
 	return 0;     } 
     return 1;  }         /*-  * lcp_rprotrej - Receive an Protocol-Reject.   *7  * Figure out which protocol is rejected and inform it.   */  static void  lcp_rprotrej(unit, inp, len)
     int unit;      u_char *inp;     int len; {      u_short prot;      fsm *f = LCP_FSM(unit);   -     LCPDEBUG((f, LOG_INFO, "lcp_rprotrej."));   !     if (len < sizeof (u_short)) {l 	LCPDEBUG((f, LOG_INFO,r9 		  "lcp_rprotrej: Rcvd short Protocol-Reject packet!"));t 	return;     }t       GETSHORT(prot, inp);       LCPDEBUG((f, LOG_INFO,; 	      "lcp_rprotrej: Rcvd Protocol-Reject packet for %x!",n 	      prot));       /*G      * Protocol-Reject packets received in any state other than the LCPs1      * OPENED state SHOULD be silently discarded.       */d     if( f->state != OPENED ){mE 	LCPDEBUG((f, LOG_INFO, "Protocol-Reject discarded: LCP in state %d",  		  f->state));t 	return;     }e  6     DEMUXPROTREJ(f->unit, prot);	/* Inform protocol */ }      /*0  * lcp_protrej - A Protocol-Reject was received.  */r /*ARGSUSED*/ void lcp_protrej(unit)c
     int unit;t {p     /*      * Can't reject LCP!      */A)     LCPDEBUG((LCP_FSM(unit), LOG_WARNING,I: 	      "lcp_protrej: Received Protocol-Reject for LCP!"));"     fsm_protreject(LCP_FSM(unit)); }T     /*;  * lcp_sprotrej - Send a Protocol-Reject for some protocol.i  */  void lcp_sprotrej(unit, p, len)
     int unit;      u_char *p;     int len; {      fsm *f = LCP_FSM(unit);i       /*>      * Send back the protocol and the information field of theH      * rejected packet.  We only get here if LCP is in the OPENED state.      */i     p += 2;i
     len -= 2;e  +     fsm_sdata(f, PROTREJ, ++f->id, p, len);u }"     /*  * lcp_resetci - Reset our CI.  */  void   lcp_resetci(unit)e	 int unit;i {u     fsm *f = LCP_FSM(unit);h-     lcp_options *wo = &LCP_WANTOPTIONS(unit);        wo->magicnumber = magic();     wo->numloops = 0;m1     LCP_GOTOPTIONS(unit) = LCP_WANTOPTIONS(unit); 
 #ifndef __VMSe      peer_mru[f->unit] = PPP_MRU; #endif /* __VMS */ }      /*'  * lcp_cilen - Return length of our CI.	  */P ints lcp_cilen(unit)*
     int unit;  {_,     lcp_options *go = &LCP_GOTOPTIONS(unit);  - #define LENCIVOID(neg)	(neg ? CILEN_VOID : 0)P- #define LENCICHAP(neg)	(neg ? CILEN_CHAP : 0)c/ #define LENCISHORT(neg)	(neg ? CILEN_SHORT : 0) - #define LENCILONG(neg)	(neg ? CILEN_LONG : 0)P* #define LENCILQR(neg)	(neg ? CILEN_LQR: 0)     /*@      * NB: we only ask for one of CHAP and UPAP, even if we will      * accept either.*      */f%     return (LENCISHORT(go->neg_mru) +t" 	    LENCILONG(go->neg_asyncmap) + 	    LENCICHAP(go->neg_chap) +0 	    LENCISHORT(!go->neg_chap && go->neg_upap) + 	    LENCILQR(go->neg_lqr) +% 	    LENCILONG(go->neg_magicnumber) +f& 	    LENCIVOID(go->neg_pcompression) +' 	    LENCIVOID(go->neg_accompression));  }e     /*/  * lcp_addci - Add our desired CIs to a packet.f  */* void lcp_addci(unit, ucp, lenp)
     int unit;      u_char *ucp;     int *lenp; {_,     lcp_options *go = &LCP_GOTOPTIONS(unit);     u_char *start_ucp = ucp;   #define ADDCIVOID(opt, neg) \P     if (neg) { \ 	PUTCHAR(opt, ucp); \( 	PUTCHAR(CILEN_VOID, ucp); \     }c# #define ADDCISHORT(opt, neg, val) \l     if (neg) { \ 	PUTCHAR(opt, ucp); \s 	PUTCHAR(CILEN_SHORT, ucp); \n 	PUTSHORT(val, ucp); \     }h* #define ADDCICHAP(opt, neg, val, digest) \     if (neg) { \ 	PUTCHAR(opt, ucp); \m 	PUTCHAR(CILEN_CHAP, ucp); \ 	PUTSHORT(val, ucp); \ 	PUTCHAR(digest, ucp); \     } " #define ADDCILONG(opt, neg, val) \     if (neg) { \ 	PUTCHAR(opt, ucp); \a 	PUTCHAR(CILEN_LONG, ucp); \ 	PUTLONG(val, ucp); \r     }i! #define ADDCILQR(opt, neg, val) \p     if (neg) { \ 	PUTCHAR(opt, ucp); \t 	PUTCHAR(CILEN_LQR, ucp); \e 	PUTSHORT(PPP_LQR, ucp); \ 	PUTLONG(val, ucp); \g     }a  -     ADDCISHORT(CI_MRU, go->neg_mru, go->mru);_;     ADDCILONG(CI_ASYNCMAP, go->neg_asyncmap, go->asyncmap); D     ADDCICHAP(CI_AUTHTYPE, go->neg_chap, PPP_CHAP, go->chap_mdtype);D     ADDCISHORT(CI_AUTHTYPE, !go->neg_chap && go->neg_upap, PPP_PAP);6     ADDCILQR(CI_QUALITY, go->neg_lqr, go->lqr_period);D     ADDCILONG(CI_MAGICNUMBER, go->neg_magicnumber, go->magicnumber);5     ADDCIVOID(CI_PCOMPRESSION, go->neg_pcompression);t7     ADDCIVOID(CI_ACCOMPRESSION, go->neg_accompression);*  #     if (ucp - start_ucp != *lenp) { @ 	/* this should never happen, because peer_mtu should be 1500 */F 	LCPDEBUG((LCP_FSM(unit), LOG_ERR, "Bug in lcp_addci: wrong length"));     }e }s     /*  * lcp_ackci - Ack our CIs.O6  * This should not modify any state if the Ack is bad.  *  * Returns:"  *	0 - Ack was bad.   *	1 - Ack was good.  */i intP lcp_ackci(unit, p, len)u
     int unit;n     u_char *p;     int len; {i,     lcp_options *go = &LCP_GOTOPTIONS(unit);!     u_char cilen, citype, cichar;A     u_short cishort;     u_int32_t cilong;        /*:      * CIs must be in exactly the same order that we sent.6      * Check packet length and CI length at each step.:      * If we find any deviations, then this packet is bad.      */  #define ACKCIVOID(opt, neg) \e     if (neg) { \ 	if ((len -= CILEN_VOID) < 0) \n 	    goto bad; \ 	GETCHAR(citype, p); \ 	GETCHAR(cilen, p); \t 	if (cilen != CILEN_VOID || \_ 	    citype != opt) \  	    goto bad; \     }p# #define ACKCISHORT(opt, neg, val) \e     if (neg) { \  	if ((len -= CILEN_SHORT) < 0) \ 	    goto bad; \ 	GETCHAR(citype, p); \ 	GETCHAR(cilen, p); \i 	if (cilen != CILEN_SHORT || \ 	    citype != opt) \r 	    goto bad; \ 	GETSHORT(cishort, p); \ 	if (cishort != val) \ 	    goto bad; \     } * #define ACKCICHAP(opt, neg, val, digest) \     if (neg) { \ 	if ((len -= CILEN_CHAP) < 0) \o 	    goto bad; \ 	GETCHAR(citype, p); \ 	GETCHAR(cilen, p); \> 	if (cilen != CILEN_CHAP || \e 	    citype != opt) \e 	    goto bad; \ 	GETSHORT(cishort, p); \ 	if (cishort != val) \ 	    goto bad; \ 	GETCHAR(cichar, p); \ 	if (cichar != digest) \ 	  goto bad; \     } " #define ACKCILONG(opt, neg, val) \     if (neg) { \ 	if ((len -= CILEN_LONG) < 0) \p 	    goto bad; \ 	GETCHAR(citype, p); \ 	GETCHAR(cilen, p); \f 	if (cilen != CILEN_LONG || \T 	    citype != opt) \> 	    goto bad; \ 	GETLONG(cilong, p); \ 	if (cilong != val) \* 	    goto bad; \     }n! #define ACKCILQR(opt, neg, val) \      if (neg) { \ 	if ((len -= CILEN_LQR) < 0) \ 	    goto bad; \ 	GETCHAR(citype, p); \ 	GETCHAR(cilen, p); \) 	if (cilen != CILEN_LQR || \ 	    citype != opt) \  	    goto bad; \ 	GETSHORT(cishort, p); \ 	if (cishort != PPP_LQR) \ 	    goto bad; \ 	GETLONG(cilong, p); \ 	if (cilong != val) \e 	  goto bad; \     }e  -     ACKCISHORT(CI_MRU, go->neg_mru, go->mru);n;     ACKCILONG(CI_ASYNCMAP, go->neg_asyncmap, go->asyncmap);_D     ACKCICHAP(CI_AUTHTYPE, go->neg_chap, PPP_CHAP, go->chap_mdtype);D     ACKCISHORT(CI_AUTHTYPE, !go->neg_chap && go->neg_upap, PPP_PAP);6     ACKCILQR(CI_QUALITY, go->neg_lqr, go->lqr_period);D     ACKCILONG(CI_MAGICNUMBER, go->neg_magicnumber, go->magicnumber);5     ACKCIVOID(CI_PCOMPRESSION, go->neg_pcompression);f7     ACKCIVOID(CI_ACCOMPRESSION, go->neg_accompression);,       /*?      * If there are any remaining CIs, then this packet is bad.t      */      if (len != 0) 
 	goto bad;     return (1);a bad:J     LCPDEBUG((LCP_FSM(unit), LOG_WARNING, "lcp_acki: received bad Ack!"));     return (0);; }      /*7  * lcp_nakci - Peer has sent a NAK for some of our CIs.l5  * This should not modify any state if the Nak is bad $  * or if LCP is in the OPENED state.  *  * Returns:   *	0 - Nak was bad.A  *	1 - Nak was good.  */  inte lcp_nakci(unit, p, len)t
     int unit;d     u_char *p;     int len; {      fsm *f = LCP_FSM(unit);_,     lcp_options *go = &LCP_GOTOPTIONS(unit);-     lcp_options *wo = &LCP_WANTOPTIONS(unit);n!     u_char citype, cichar, *next;l     u_short cishort;     u_int32_t cilong;i6     lcp_options no;		/* options we've seen Naks for */8     lcp_options try;		/* options to request next time */     int looped_back = 0;     int cilen;       BZERO(&no, sizeof(no));      try = *go;       /*D      * Any Nak'd CIs must be in exactly the same order that we sent.6      * Check packet length and CI length at each step.:      * If we find any deviations, then this packet is bad.      */d# #define NAKCIVOID(opt, neg, code) \      if (go->neg && \ 	len >= CILEN_VOID && \0 	p[1] == CILEN_VOID && \ 	p[0] == opt) { \  	len -= CILEN_VOID; \i 	INCPTR(CILEN_VOID, p); \t 	no.neg = 1; \ 	code \/     } # #define NAKCICHAP(opt, neg, code) \      if (go->neg && \ 	len >= CILEN_CHAP && \  	p[1] == CILEN_CHAP && \ 	p[0] == opt) { \n 	len -= CILEN_CHAP; \d 	INCPTR(2, p); \ 	GETSHORT(cishort, p); \ 	GETCHAR(cichar, p); \ 	no.neg = 1; \ 	code \t     }n$ #define NAKCISHORT(opt, neg, code) \     if (go->neg && \ 	len >= CILEN_SHORT && \ 	p[1] == CILEN_SHORT && \p 	p[0] == opt) { \T 	len -= CILEN_SHORT; \ 	INCPTR(2, p); \ 	GETSHORT(cishort, p); \ 	no.neg = 1; \ 	code \      }s# #define NAKCILONG(opt, neg, code) \T     if (go->neg && \ 	len >= CILEN_LONG && \a 	p[1] == CILEN_LONG && \ 	p[0] == opt) { \e 	len -= CILEN_LONG; \n 	INCPTR(2, p); \ 	GETLONG(cilong, p); \ 	no.neg = 1; \ 	code \e     } " #define NAKCILQR(opt, neg, code) \     if (go->neg && \ 	len >= CILEN_LQR && \ 	p[1] == CILEN_LQR && \g 	p[0] == opt) { \c 	len -= CILEN_LQR; \ 	INCPTR(2, p); \ 	GETSHORT(cishort, p); \ 	GETLONG(cilong, p); \ 	no.neg = 1; \ 	code \e     }l       /*A      * We don't care if they want to send us smaller packets than G      * we want.  Therefore, accept any MRU less than what we asked for, H      * but then ignore the new value when setting the MRU in the kernel.H      * If they send us a bigger MRU than what we asked, accept it, up toD      * the limit of the default MRU we'd get if we didn't negotiate.      */E     NAKCISHORT(CI_MRU, neg_mru,O3 	       if (cishort <= wo->mru || cishort < DEFMRU)  		   try.mru = cishort;c
 	       );       /*C      * Add any characters they want to our (receive-side) asyncmap.       */i(     NAKCILONG(CI_ASYNCMAP, neg_asyncmap,, 	      try.asyncmap = go->asyncmap | cilong;	 	      );t       /*B      * If they've nak'd our authentication-protocol, check whether>      * they are proposing a different protocol, or a different      * hash algorithm for CHAP.       */o&     if ((go->neg_chap || go->neg_upap) 	&& len >= CILEN_SHORT1 	&& p[0] == CI_AUTHTYPE && p[1] >= CILEN_SHORT) {u 	cilen = p[1]; 	INCPTR(2, p);         GETSHORT(cishort, p); 2 	if (cishort == PPP_PAP && cilen == CILEN_SHORT) { 	    /* D 	     * If they are asking for PAP, then they don't want to do CHAP.C 	     * If we weren't asking for CHAP, then we were asking for PAP,"& 	     * in which case this Nak is bad. 	     */ 	    if (!go->neg_chap)  		goto bad;o 	    go->neg_chap = 0;  9 	} else if (cishort == PPP_CHAP && cilen == CILEN_CHAP) {H 	    GETCHAR(cichar, p); 	    if (go->neg_chap) { 		/*< 		 * We were asking for CHAP/MD5; they must want a different9 		 * algorithm.  If they can't do MD5, we'll have to stop  		 * asking for CHAP.n 		 */t  		if (cichar != go->chap_mdtype) 		    go->neg_chap = 0;o
 	    } else {s 		/*2 		 * Stop asking for PAP if we were asking for it. 		 */  		go->neg_upap = 0;  	    }  	 	} else {! 	    /*A3 	     * We don't recognize what they're suggesting."0 	     * Stop asking for what we were asking for. 	     */ 	    if (go->neg_chap) 		go->neg_chap = 0;p	 	    else  		go->neg_upap = 0;t 	    p += cilen - CILEN_SHORT; 	}     }r       /*:      * Peer shouldn't send Nak for protocol compression or=      * address/control compression requests; they should sendoC      * a Reject instead.  If they send a Nak, treat it as a Reject.y      */      if (!go->neg_chap ){" 	NAKCISHORT(CI_AUTHTYPE, neg_upap, 		   try.neg_upap = 0; 		   );R     }-       /*D      * If they can't cope with our link quality protocol, we'll haveB      * to stop asking for LQR.  We haven't got any other protocol.?      * If they Nak the reporting period, take their value XXX ?a      */ !     NAKCILQR(CI_QUALITY, neg_lqr,T 	     if (cishort != PPP_LQR)i 		 try.neg_lqr = 0; 
 	     else 		 try.lqr_period = cilong;/ 	     );       /*$      * Check for a looped-back line.      */*.     NAKCILONG(CI_MAGICNUMBER, neg_magicnumber,! 	      try.magicnumber = magic();N 	      looped_back = 1;V	 	      );e  0     NAKCIVOID(CI_PCOMPRESSION, neg_pcompression,  	      try.neg_pcompression = 0;	 	      );g2     NAKCIVOID(CI_ACCOMPRESSION, neg_accompression,! 	      try.neg_accompression = 0;n	 	      );C       /*H      * There may be remaining CIs, if the peer is requesting negotiationA      * on an option that we didn't include in our request packet.gG      * If we see an option that we requested, or one we've already seen)/      * in this packet, then this packet is bad.)H      * If we wanted to respond by starting to negotiate on the requested@      * option(s), we could, but we don't, because except for theJ      * authentication type and quality protocol, if we are not negotiating4      * an option, it is because we were told not to.?      * For the authentication type, the Nak from the peer meansLF      * `let me authenticate myself with you' which is a bit pointless.J      * For the quality protocol, the Nak means `ask me to send you qualityC      * reports', but if we didn't ask for them, we don't want them.{A      * An option we don't recognize represents the peer asking toR<      * negotiate some option we don't support, so ignore it.      */      while (len > CILEN_VOID) { 	GETCHAR(citype, p); 	GETCHAR(cilen, p);R 	if ((len -= cilen) < 0) 	    goto bad; 	next = p + cilen - 2;   	switch (citype) {
 	case CI_MRU: ; 	    if (go->neg_mru || no.neg_mru || cilen != CILEN_SHORT)G 		goto bad;r 	    break;f 	case CI_ASYNCMAP:D 	    if (go->neg_asyncmap || no.neg_asyncmap || cilen != CILEN_LONG) 		goto bad;  	    break;_ 	case CI_AUTHTYPE:D 	    if (go->neg_chap || no.neg_chap || go->neg_upap || no.neg_upap) 		goto bad;C 	    break;C 	case CI_MAGICNUMBER:g5 	    if (go->neg_magicnumber || no.neg_magicnumber ||, 		cilen != CILEN_LONG) 		goto bad;C 	    break;H 	case CI_PCOMPRESSION:4 	    if (go->neg_pcompression || no.neg_pcompression 		|| cilen != CILEN_VOID)  		goto bad;I 	    break;  	case CI_ACCOMPRESSION:m6 	    if (go->neg_accompression || no.neg_accompression 		|| cilen != CILEN_VOID)( 		goto bad;I 	    break;c 	case CI_QUALITY: 9 	    if (go->neg_lqr || no.neg_lqr || cilen != CILEN_LQR)a 		goto bad;  	    break;l 	}
 	p = next;     }(  >     /* If there is still anything left, this packet is bad. */     if (len != 0)l
 	goto bad;       /*5      * OK, the Nak is good.  Now we can update state.a      */*     if (f->state != OPENED) {  	if (looped_back) {.. 	    if (++try.numloops >= lcp_loopbackfail) {; 		LCPDEBUG((f, LOG_NOTICE, "Serial line is looped back."));  		lcp_close(unit); 	    } 	} elsec 	    try.numloops = 0; 	*go = try;i     }   
     return 1;o   bad:?     LCPDEBUG((f, LOG_WARNING, "lcp_nakci: received bad Nak!"));.
     return 0;p }e     /*1  * lcp_rejci - Peer has Rejected some of our CIs. 8  * This should not modify any state if the Reject is bad$  * or if LCP is in the OPENED state.  *  * Returns:L  *	0 - Reject was bad.  *	1 - Reject was good.p  */; intG lcp_rejci(unit, p, len) 
     int unit;_     u_char *p;     int len; { ,     lcp_options *go = &LCP_GOTOPTIONS(unit);     u_char cichar;     u_short cishort;     u_int32_t cilong;      u_char *start = p;     int plen = len;\8     lcp_options try;		/* options to request next time */     fsm *f = LCP_FSM(unit);g     try = *go;       /*G      * Any Rejected CIs must be in exactly the same order that we sent.C6      * Check packet length and CI length at each step.:      * If we find any deviations, then this packet is bad.      */  #define REJCIVOID(opt, neg) \l     if (go->neg && \ 	len >= CILEN_VOID && \  	p[1] == CILEN_VOID && \ 	p[0] == opt) { \i 	len -= CILEN_VOID; \  	INCPTR(CILEN_VOID, p); \c 	try.neg = 0; \cB 	LCPDEBUG((f, LOG_INFO, "lcp_rejci rejected void opt %d", opt)); \     })# #define REJCISHORT(opt, neg, val) \L     if (go->neg && \ 	len >= CILEN_SHORT && \ 	p[1] == CILEN_SHORT && \  	p[0] == opt) { \! 	len -= CILEN_SHORT; \ 	INCPTR(2, p); \ 	GETSHORT(cishort, p); \ 	/* Check rejected value. */ \ 	if (cishort != val) \ 	    goto bad; \ 	try.neg = 0; \eB 	LCPDEBUG((f, LOG_INFO,"lcp_rejci rejected short opt %d", opt)); \     };* #define REJCICHAP(opt, neg, val, digest) \     if (go->neg && \ 	len >= CILEN_CHAP && \p 	p[1] == CILEN_CHAP && \ 	p[0] == opt) { \h 	len -= CILEN_CHAP; \t 	INCPTR(2, p); \ 	GETSHORT(cishort, p); \ 	GETCHAR(cichar, p); \ 	/* Check rejected value. */ \* 	if (cishort != val || cichar != digest) \ 	    goto bad; \ 	try.neg = 0; \A 	try.neg_upap = 0; \A 	LCPDEBUG((f, LOG_INFO,"lcp_rejci rejected chap opt %d", opt)); \g     }_" #define REJCILONG(opt, neg, val) \     if (go->neg && \ 	len >= CILEN_LONG && \  	p[1] == CILEN_LONG && \ 	p[0] == opt) { \i 	len -= CILEN_LONG; \M 	INCPTR(2, p); \ 	GETLONG(cilong, p); \ 	/* Check rejected value. */ \ 	if (cilong != val) \e 	    goto bad; \ 	try.neg = 0; \SA 	LCPDEBUG((f, LOG_INFO,"lcp_rejci rejected long opt %d", opt)); \e     } ! #define REJCILQR(opt, neg, val) \      if (go->neg && \ 	len >= CILEN_LQR && \ 	p[1] == CILEN_LQR && \B 	p[0] == opt) { \L 	len -= CILEN_LQR; \ 	INCPTR(2, p); \ 	GETSHORT(cishort, p); \ 	GETLONG(cilong, p); \ 	/* Check rejected value. */ \+ 	if (cishort != PPP_LQR || cilong != val) \t 	    goto bad; \ 	try.neg = 0; \i@ 	LCPDEBUG((f, LOG_INFO,"lcp_rejci rejected LQR opt %d", opt)); \     }k  )     REJCISHORT(CI_MRU, neg_mru, go->mru);n7     REJCILONG(CI_ASYNCMAP, neg_asyncmap, go->asyncmap); @     REJCICHAP(CI_AUTHTYPE, neg_chap, PPP_CHAP, go->chap_mdtype);     if (!go->neg_chap) {, 	REJCISHORT(CI_AUTHTYPE, neg_upap, PPP_PAP);     },2     REJCILQR(CI_QUALITY, neg_lqr, go->lqr_period);@     REJCILONG(CI_MAGICNUMBER, neg_magicnumber, go->magicnumber);1     REJCIVOID(CI_PCOMPRESSION, neg_pcompression); 3     REJCIVOID(CI_ACCOMPRESSION, neg_accompression);(       /*?      * If there are any remaining CIs, then this packet is bad.i      */      if (len != 0) 
 	goto bad;     /*      * Now we can update state.       */.     if (f->state != OPENED)t 	*go = try;i
     return 1;.   bad:B     LCPDEBUG((f, LOG_WARNING, "lcp_rejci: received bad Reject!"));A     LCPDEBUG((f, LOG_WARNING, "lcp_rejci: plen %d len %d off %d",  	      plen, len, p - start));
     return 0;  }      /*L  * lcp_reqci - Check the peer's requested CIs and send appropriate response.  *A  * Returns: CONFACK, CONFNAK or CONFREJ and input packet modifiedtD  * appropriately.  If reject_if_disagree is non-zero, doesn't return7  * CONFNAK; returns CONFREJ if it can't return CONFACK.   */  intn. lcp_reqci(unit, inp, lenp, reject_if_disagree)
     int unit;I%     u_char *inp;		/* Requested CIs */ .     int *lenp;			/* Length of requested CIs */     int reject_if_disagree;i {r     fsm *f = LCP_FSM(unit);d  ,     lcp_options *go = &LCP_GOTOPTIONS(unit);,     lcp_options *ho = &LCP_HISOPTIONS(unit);.     lcp_options *ao = &LCP_ALLOWOPTIONS(unit);>     u_char *cip, *next;		/* Pointer to current and next CIs */C     u_char cilen, citype, cichar;/* Parsed len, type, char value */d.     u_short cishort;		/* Parsed short value */-     u_int32_t cilong;		/* Parse long value */c5     int rc = CONFACK;		/* Final packet return code */h2     int orc;			/* Individual option return code */4     u_char *p;			/* Pointer to next char to parse */=     u_char *rejp;		/* Pointer to next char in reject frame */e:     u_char *nakp;		/* Pointer to next char in Nak frame */%     int l = *lenp;		/* Length left */n       /*      * Reset all his options.s      */b     BZERO(ho, sizeof(*ho));        /*      * Process all his options.e      */      next = inp;d     nakp = nak_buffer;     rejp = inp;C     while (l) { & 	orc = CONFACK;			/* Assume success */0 	cip = p = next;			/* Remember begining of CI */6 	if (l < 2 ||			/* Not enough data for CI header or */0 	    p[1] < 2 ||			/*  CI length too small or */, 	    p[1] > l) {			/*  CI length too big? */= 	    LCPDEBUG((f, LOG_WARNING, "lcp_reqci: bad CI length!"));y( 	    orc = CONFREJ;		/* Reject bad CI */1 	    cilen = l;			/* Reject till end of packet */r$ 	    l = 0;			/* Don't loop again */ 	    goto endswitch; 	}) 	GETCHAR(citype, p);		/* Parse CI type */ * 	GETCHAR(cilen, p);		/* Parse CI length */, 	l -= cilen;			/* Adjust remaining length */' 	next += cilen;			/* Step to next CI */t  ' 	switch (citype) {		/* Check CI type */ 
 	case CI_MRU: 4 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd MRU"));- 	    if (!ao->neg_mru ||		/* Allow option? */ / 		cilen != CILEN_SHORT) {	/* Check CI length */ ! 		orc = CONFREJ;		/* Reject CI */. 		break; 	    }* 	    GETSHORT(cishort, p);	/* Parse MRU */. 	    LCPDEBUG((f, LOG_INFO, "(%d)", cishort));   	    /* 8 	     * He must be able to receive at least our minimum.@ 	     * No need to check a maximum.  If he sends a large number, 	     * we'll just ignore it.  	     */ 	    if (cishort < MINMRU) { 		orc = CONFNAK;		/* Nak CI */ 		PUTCHAR(CI_MRU, nakp); 		PUTCHAR(CILEN_SHORT, nakp);o/ 		PUTSHORT(MINMRU, nakp);	/* Give him a hint */i 		break; 	    }1 	    ho->neg_mru = 1;		/* Remember he sent MRU */e1 	    ho->mru = cishort;		/* And remember value */h 	    break;i   	case CI_ASYNCMAP:9 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd ASYNCMAP"));g 	    if (!ao->neg_asyncmap ||  		cilen != CILEN_LONG) { 		orc = CONFREJ; 		break; 	    } 	    GETLONG(cilong, p);< 	    LCPDEBUG((f, LOG_INFO, "(%x)", (unsigned int) cilong));   	    /*c0 	     * Asyncmap must have set at least the bits9 	     * which are set in lcp_allowoptions[unit].asyncmap.e 	     */) 	    if ((ao->asyncmap & ~cilong) != 0) {R 		orc = CONFNAK; 		PUTCHAR(CI_ASYNCMAP, nakp);  		PUTCHAR(CILEN_LONG, nakp);' 		PUTLONG(ao->asyncmap | cilong, nakp);l 		break; 	    } 	    ho->neg_asyncmap = 1; 	    ho->asyncmap = cilong;y 	    break;o   	case CI_AUTHTYPE:9 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd AUTHTYPE"));  	    if (cilen < CILEN_SHORT || $ 		!(ao->neg_upap || ao->neg_chap)) { 		/*< 		 * Reject the option if we're not willing to authenticate. 		 */* 		orc = CONFREJ; 		break; 	    } 	    GETSHORT(cishort, p);. 	    LCPDEBUG((f, LOG_INFO, "(%x)", cishort));   	    /*m& 	     * Authtype must be UPAP or CHAP. 	     * < 	     * Note: if both ao->neg_upap and ao->neg_chap are set,7 	     * and the peer sends a Configure-Request with twoR< 	     * authenticate-protocol requests, one for CHAP and one9 	     * for UPAP, then we will reject the second request.i< 	     * Whether we end up doing CHAP or UPAP depends then on@ 	     * the ordering of the CIs in the peer's Configure-Request. 	     */   	    if (cishort == PPP_PAP) {7 		if (ho->neg_chap ||	/* we've already accepted CHAP */  		    cilen != CILEN_SHORT) {b 		    LCPDEBUG((f, LOG_WARNING,q8 			      "lcp_reqci: rcvd AUTHTYPE PAP, rejecting...")); 		    orc = CONFREJ; 		    break; 		}e4 		if (!ao->neg_upap) {	/* we don't want to do PAP */2 		    orc = CONFNAK;	/* NAK it and suggest CHAP */! 		    PUTCHAR(CI_AUTHTYPE, nakp);h  		    PUTCHAR(CILEN_CHAP, nakp); 		    PUTSHORT(PPP_CHAP, nakp); % 		    PUTCHAR(ao->chap_mdtype, nakp);F 		    break; 		}o 		ho->neg_upap = 1;s 		break; 	    } 	    if (cishort == PPP_CHAP) {e6 		if (ho->neg_upap ||	/* we've already accepted PAP */ 		    cilen != CILEN_CHAP) { 		    LCPDEBUG((f, LOG_INFO,9 			      "lcp_reqci: rcvd AUTHTYPE CHAP, rejecting..."));  		    orc = CONFREJ; 		    break; 		}G5 		if (!ao->neg_chap) {	/* we don't want to do CHAP */c1 		    orc = CONFNAK;	/* NAK it and suggest PAP */ ! 		    PUTCHAR(CI_AUTHTYPE, nakp); ! 		    PUTCHAR(CILEN_SHORT, nakp);u 		    PUTSHORT(PPP_PAP, nakp); 		    break; 		}k* 		GETCHAR(cichar, p);	/* get digest type*/" 		if (cichar != ao->chap_mdtype) { 		    orc = CONFNAK;! 		    PUTCHAR(CI_AUTHTYPE, nakp);P  		    PUTCHAR(CILEN_CHAP, nakp); 		    PUTSHORT(PPP_CHAP, nakp);u% 		    PUTCHAR(ao->chap_mdtype, nakp);  		    break; 		} . 		ho->chap_mdtype = cichar; /* save md type */ 		ho->neg_chap = 1;N 		break; 	    }   	    /*e; 	     * We don't recognize the protocol they're asking for.|2 	     * Nak it with something we're willing to do.= 	     * (At this point we know ao->neg_upap || ao->neg_chap.)- 	     */ 	    orc = CONFNAK;c  	    PUTCHAR(CI_AUTHTYPE, nakp); 	    if (ao->neg_chap) { 		PUTCHAR(CILEN_CHAP, nakp); 		PUTSHORT(PPP_CHAP, nakp);l! 		PUTCHAR(ao->chap_mdtype, nakp);b
 	    } else {k 		PUTCHAR(CILEN_SHORT, nakp);  		PUTSHORT(PPP_PAP, nakp); 	    } 	    break;    	case CI_QUALITY:e8 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd QUALITY")); 	    if (!ao->neg_lqr || 		cilen != CILEN_LQR) {s 		orc = CONFREJ; 		break; 	    }   	    GETSHORT(cishort, p); 	    GETLONG(cilong, p);H 	    LCPDEBUG((f, LOG_INFO, "(%x %x)", cishort, (unsigned int) cilong));   	    /*}4 	     * Check the protocol and the reporting period.3 	     * XXX When should we Nak this, and what with?R 	     */ 	    if (cishort != PPP_LQR) { 		orc = CONFNAK; 		PUTCHAR(CI_QUALITY, nakp); 		PUTCHAR(CILEN_LQR, nakp);  		PUTSHORT(PPP_LQR, nakp);  		PUTLONG(ao->lqr_period, nakp); 		break; 	    } 	    break;t   	case CI_MAGICNUMBER:0< 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd MAGICNUMBER"));9 	    if (!(ao->neg_magicnumber || go->neg_magicnumber) ||n 		cilen != CILEN_LONG) { 		orc = CONFREJ; 		break; 	    } 	    GETLONG(cilong, p);< 	    LCPDEBUG((f, LOG_INFO, "(%x)", (unsigned int) cilong));   	    /*=. 	     * He must have a different magic number. 	     */ 	    if (go->neg_magicnumber &&) 		cilong == go->magicnumber) {9 		cilong = magic();	/* Don't put magic() inside macro! */t 		orc = CONFNAK;  		PUTCHAR(CI_MAGICNUMBER, nakp); 		PUTCHAR(CILEN_LONG, nakp); 		PUTLONG(cilong, nakp); 		break; 	    } 	    ho->neg_magicnumber = 1;p 	    ho->magicnumber = cilong; 	    break;E     	case CI_PCOMPRESSION:= 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd PCOMPRESSION"));(! 	    if (!ao->neg_pcompression ||c 		cilen != CILEN_VOID) { 		orc = CONFREJ; 		break; 	    } 	    ho->neg_pcompression = 1; 	    break;v   	case CI_ACCOMPRESSION:\> 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd ACCOMPRESSION"));" 	    if (!ao->neg_accompression || 		cilen != CILEN_VOID) { 		orc = CONFREJ; 		break; 	    } 	    ho->neg_accompression = 1;) 	    break;   	 	default:n@ 	    LCPDEBUG((f, LOG_INFO, "lcp_reqci: rcvd unknown option %d", 		      citype));; 	    orc = CONFREJ;p 	    break;d 	}  
 endswitch:1 	LCPDEBUG((f, LOG_INFO, " (%s)", CODENAME(orc)));L% 	if (orc == CONFACK &&		/* Good CI */-/ 	    rc != CONFACK)		/*  but prior CI wasnt? */h* 	    continue;			/* Don't send this one */  * 	if (orc == CONFNAK) {		/* Nak this CI? */C 	    if (reject_if_disagree	/* Getting fed up with sending NAKs? */a  		&& citype != CI_MAGICNUMBER) {' 		orc = CONFREJ;		/* Get tough if so */g
 	    } else {n. 		if (rc == CONFREJ)	/* Rejecting prior CI? */* 		    continue;		/* Don't send this one */ 		rc = CONFNAK;  	    } 	}, 	if (orc == CONFREJ) {		/* Reject this CI */ 	    rc = CONFREJ;6 	    if (cip != rejp)		/* Need to move rejected CI? */( 		BCOPY(cip, rejp, cilen); /* Move it */5 	    INCPTR(cilen, rejp);	/* Update output pointer */t 	}     }        /*A      * If we wanted to send additional NAKs (for unsent CIs), theQ=      * code would go here.  The extra NAKs would go at *nakp.I=      * At present there are no cases where we want to ask theG#      * peer to negotiate an option.l      */        switch (rc) {Q     case CONFACK:  	*lenp = next - inp; 	break;=     case CONFNAK:f 	/*_F 	 * Copy the Nak'd options from the nak_buffer to the caller's buffer. 	 */ 	*lenp = nakp - nak_buffer;E 	BCOPY(nak_buffer, inp, *lenp);, 	break;c     case CONFREJ:A 	*lenp = rejp - inp; 	break;A     }c  J     LCPDEBUG((f, LOG_INFO, "lcp_reqci: returning CONF%s.", CODENAME(rc)));*     return (rc);			/* Return final code */ }r    
 #ifndef __VMS  /*  * lcp_up - LCP has come UP.  *  * Start UPAP, IPCP, etc.   */E static voidO lcp_up(unit)
     int unit;  {        fsm *f = LCP_FSM(unit);e-     lcp_options *wo = &LCP_WANTOPTIONS(unit);r,     lcp_options *ho = &LCP_HISOPTIONS(unit);,     lcp_options *go = &LCP_GOTOPTIONS(unit);.     lcp_options *ao = &LCP_ALLOWOPTIONS(unit);       if (!go->neg_magicnumber)* 	go->magicnumber = 0;1     if (!ho->neg_magicnumber)G 	ho->magicnumber = 0;e       /*:      * Set our MTU to the smaller of the MTU we wanted and9      * the MRU our peer wanted.  If we negotiated an MRU,e7      * set our MRU to the larger of value we wanted andu+      * the value we got in the negotiation.       */sH     ppp_send_config(unit, MIN(ao->mru, (ho->neg_mru? ho->mru: PPP_MRU)),3 		    (ho->neg_asyncmap? ho->asyncmap: 0xffffffff), 3 		    ho->neg_pcompression, ho->neg_accompression);K     /*?      * If the asyncmap hasn't been negotiated, we really shouldn?      * set the receive asyncmap to ffffffff, but we set it to 0 %      * for backwards contemptibility.e      */aH     ppp_recv_config(unit, (go->neg_mru? MAX(wo->mru, go->mru): PPP_MRU),3 		    (go->neg_asyncmap? go->asyncmap: 0x00000000),(3 		    go->neg_pcompression, go->neg_accompression);;       if (ho->neg_mru) 	peer_mru[f->unit] = ho->mru;x  )     ChapLowerUp(unit);		/* Enable CHAP */ *     upap_lowerup(unit);		/* Enable UPAP */*     ipcp_lowerup(unit);		/* Enable IPCP */(     ccp_lowerup(unit);		/* Enable CCP */6     lcp_echo_lowerup(unit);	/* Enable echo messages */       link_established(unit);t }  #endif /* __VMS */  
 #ifndef __VMSo /*   * lcp_down - LCP has gone DOWN.  *  * Alert other protocols.   */i static voide lcp_down(unit)
     int unit;n {      lcp_echo_lowerdown(unit);      ccp_lowerdown(unit);     ipcp_lowerdown(unit);*     ChapLowerDown(unit);     upap_lowerdown(unit);e       sifdown(unit);5     ppp_send_config(unit, PPP_MRU, 0xffffffff, 0, 0);i5     ppp_recv_config(unit, PPP_MRU, 0x00000000, 0, 0);l     peer_mru[unit] = PPP_MRU;A       link_down(unit); }= #endif /* __VMS */   /*/  * lcp_starting - LCP needs the lower layer up.f  */  static void  lcp_starting(unit)
     int unit;o {a     link_required(unit); }/    
 #ifndef __VMSg /*8  * lcp_finished - LCP has finished with the lower layer.  */y static voidC lcp_finished(unit)
     int unit;c {n     link_terminated(unit); }a #endif /* __VMS */   /*6  * lcp_printpkt - print the contents of an LCP packet.  */p char *lcp_codenames[] = { /     "ConfReq", "ConfAck", "ConfNak", "ConfRej",-/     "TermReq", "TermAck", "CodeRej", "ProtRej",=#     "EchoReq", "EchoRep", "DiscReq"s };   intp# lcp_printpkt(p, plen, printer, arg)M     u_char *p;
     int plen;O/     void (*printer) __P((void *, char *, ...));      void *arg; {?     int code, id, len, olen;     u_char *pstart, *optend;     u_short cishort;     u_int32_t cilong;        if (plen < HEADERLEN);
 	return 0;     pstart = p;U     GETCHAR(code, p);      GETCHAR(id, p);      GETSHORT(len, p);l&     if (len < HEADERLEN || len > plen)
 	return 0;  D     if (code >= 1 && code <= sizeof(lcp_codenames) / sizeof(char *)), 	printer(arg, " %s", lcp_codenames[code-1]);     else" 	printer(arg, " code=0x%x", code);!     printer(arg, " id=0x%x", id);R     len -= HEADERLEN;M     switch (code) {      case CONFREQ:r     case CONFACK:h     case CONFNAK:      case CONFREJ:U 	/* print option list */ 	while (len >= 2) {v 	    GETCHAR(code, p); 	    GETCHAR(olen, p); 	    p -= 2;" 	    if (olen < 2 || olen > len) { 		break; 	    } 	    printer(arg, " <"); 	    len -= olen;{ 	    optend = p + olen;a 	    switch (code) { 	    case CI_MRU:  		if (olen == CILEN_SHORT) {
 		    p += 2;) 		    GETSHORT(cishort, p); & 		    printer(arg, "mru %d", cishort); 		}  		break; 	    case CI_ASYNCMAP: 		if (olen == CILEN_LONG) { 
 		    p += 2;o 		    GETLONG(cilong, p); , 		    printer(arg, "asyncmap 0x%x", cilong); 		}  		break; 	    case CI_AUTHTYPE: 		if (olen >= CILEN_SHORT) {
 		    p += 2;a 		    printer(arg, "auth "); 		    GETSHORT(cishort, p);  		    switch (cishort) { 		    case PPP_PAP:  			printer(arg, "upap");	 			break;  		    case PPP_CHAP: 			printer(arg, "chap");	 			break;o 		    default:! 			printer(arg, "0x%x", cishort);h 		    }i 		}r 		break; 	    case CI_QUALITY:	 		if (olen >= CILEN_SHORT) {
 		    p += 2;  		    printer(arg, "quality ");E 		    GETSHORT(cishort, p);h 		    switch (cishort) { 		    case PPP_LQR:A 			printer(arg, "lqr"); 	 			break;f 		    default:! 			printer(arg, "0x%x", cishort);  		    }  		}s 		break; 	    case CI_MAGICNUMBER:  		if (olen == CILEN_LONG) {e
 		    p += 2;  		    GETLONG(cilong, p);P) 		    printer(arg, "magic 0x%x", cilong);i 		}  		break; 	    case CI_PCOMPRESSION: 		if (olen == CILEN_VOID) {h
 		    p += 2;h 		    printer(arg, "pcomp"); 		}s 		break; 	    case CI_ACCOMPRESSION:_ 		if (olen == CILEN_VOID) {	
 		    p += 2;y 		    printer(arg, "accomp");  		}L 		break; 	    } 	    while (p < optend) {q 		GETCHAR(code, p);: 		printer(arg, " %.2x", code); 	    } 	    printer(arg, ">");  	} 	break;      }a  3     /* print the rest of the bytes in the packet */      for (; len > 0; --len) { 	GETCHAR(code, p); 	printer(arg, " %.2x", code);      }A       return p - pstart; }U   /*A  * Time to shut down the link because there is nothing out there.r  */    static void LcpLinkFailure (unit)
     int unit;  {s     fsm *f;H          f = LCP_FSM(unit);     if (f->state == OPENED) {/T         LCPDEBUG((f, LOG_NOTICE, "Excessive lack of response to LCP echo frames."));0         lcp_close(unit);		/* Reset connection */     }  }    /*=  * Timer expired for the LCP echo requests from this process.c  */    static void; LcpEchoCheck (unit)t
     int unit;  {C     long int delta;) #ifdef __linux__     struct ppp_idle    ddinfo; /*4  * Read the time since the last packet was received.  */	/     if (ioctl (fd, PPPIOCGIDLE, &ddinfo) < 0) {t3         syslog (LOG_ERR, "ioctl(PPPIOCGIDLE): %m");P         die (1);     }( /*D  * Compute the time since the last packet was received. If the timerJ  *  has expired then send the echo request and reset the timer to maximum.  */pG     delta = (long int) lcp_echo_interval - (long int) ddinfo.recv_idle;t     if (delta < 0L) {          LcpSendEchoRequest (f); (         delta = (int) lcp_echo_interval;     }A  C #else /* Other implementations do not have ability to find delta */c     LcpSendEchoRequest (unit);$     delta = LCP_ECHO_INTERVAL(unit); #endif   /*)  * Start the timer for the next interval.k  */ 5     /* assert ( LCP_ECHO_TIMER_RUNNING(unit) ==0); */U?     TIMEOUT (LcpEchoTimeout, (caddr_t)unit, (u_int32_t) delta); %     LCP_ECHO_TIMER_RUNNING(unit) = 1;L }E   /*1  * LcpEchoTimeout - Timer expired on the LCP echo!  */e   static voide LcpEchoTimeout (arg)     caddr_t arg; {a
     int unit;        unit = (int)arg;,     if (LCP_ECHO_TIMER_RUNNING(unit) != 0) {)         LCP_ECHO_TIMER_RUNNING(unit) = 0;)         LcpEchoCheck (unit);     }  }    /*6  * LcpEchoReply - LCP has received a reply to the echo  */t   static voidi, lcp_received_echo_reply (unit, id, inp, len)
     int unit;A!     int id; u_char *inp; int len;	 {C     u_int32_t magic;     fsm *f = LCP_FSM(unit); ,     lcp_options *go = &LCP_GOTOPTIONS(unit);     F     /* Check the magic number - don't count replies from ourselves. */     if (len < 4) {L 	LCPDEBUG((f, LOG_DEBUG, "lcp: received short Echo-Reply, length %d", len)); 	return;     }      GETLONG(magic, inp);:     if (go->neg_magicnumber && magic == go->magicnumber) {K 	LCPDEBUG((f, LOG_WARNING, "appear to have received our own echo-reply!"));e 	return;     }.  5     /* Reset the number of outstanding echo frames */       LCP_ECHOS_PENDING(unit) = 0; })   /*>  * LcpSendEchoRequest - Send an echo request frame to the peer  */G   static void; LcpSendEchoRequest (unit)p
     int unit;i {g     u_int32_t lcp_magic;     u_char pkt[4], *pktp;=     fsm *f = LCP_FSM(unit);c,     lcp_options *go = &LCP_GOTOPTIONS(unit);   /*0  * Detect the failure of the peer at this point.  */"$     if (LCP_ECHO_FAILS(unit) != 0) { 	LCP_ECHOS_PENDING(unit)++; >         if (LCP_ECHOS_PENDING(unit) >= LCP_ECHO_FAILS(unit)) {!             LcpLinkFailure(unit);R! 	    LCP_ECHOS_PENDING(unit) = 0;O 	}     }i /*(  * Make and send the echo request frame.  */e     if (f->state == OPENED) {)'         lcp_magic = go->neg_magicnumber  	            ? go->magicnumber 	            : 0L; 	pktp = pkt; 	PUTLONG(lcp_magic, pktp);        	LCP_ECHO_NUMBER(unit)++;          fsm_sdata(f, ECHOREQ,R3 		  LCP_ECHO_NUMBER(unit) & 0xFF, pkt, pktp - pkt);O     }  }%   /*7  * lcp_echo_lowerup - Start the timer for the LCP frame   */r   void lcp_echo_lowerup (unit)a
     int unit;c {i     fsm *f = LCP_FSM(unit);   9     /* Clear the parameters for generating echo frames */j%     LCP_ECHOS_PENDING(unit)      = 0;s%     LCP_ECHO_NUMBER(unit)        = 0;I%     LCP_ECHO_TIMER_RUNNING(unit) = 0;u   A     /* If a timeout interval is specified then start the timer */I%     if (LCP_ECHO_INTERVAL(unit) != 0)i         LcpEchoCheck (unit); #ifdef _linux_5     /* If a idle time limit is given then start it */E     if (idle_time_limit != 0)e         RestartIdleTimer (f);C #endif }j   /*8  * lcp_echo_lowerdown - Stop the timer for the LCP frame  */p   void lcp_echo_lowerdown (unit) 
     int unit;e {o     fsm *f = LCP_FSM(unit);s  ,     if (LCP_ECHO_TIMER_RUNNING(unit) != 0) {3         UNTIMEOUT (LcpEchoTimeout, (caddr_t)unit );r)         LCP_ECHO_TIMER_RUNNING(unit) = 0;      }e #ifdef _linux_  6     /* If a idle time limit is running then stop it */"     if (idle_timer_running != 0) {/         UNTIMEOUT (IdleTimeCheck, (caddr_t) f);t         idle_timer_running = 0;a     }b #endif }/      