C=============================================================/SCANUAF
 
      PROGRAM SCANUAF

**********************************************************************
*                                                                    *
*   This program allows a VAX/VMS system manager to examine the      *
*   system User Authorization File(s) SYSUAF.DAT on multiple VAX     *
*   systems.                                                         *
*                                                                    *
*   J.D. Snyder   Princeton Plasma Physics Laboratory   18-FEB-1988  *
*   Internet: JSNYDER@PPPL.GOV                                       *
*   Phone:    (609) 243-2814                                         *
*   Address:  P.O. Box 451                                           *
*             Princeton, New Jersey 08540                            *
*                                                                    *
*   Modified:  20-SEP-1988  JDS  Sorted parameters in HELP message.  *
*                                Put example in HELP message.        *
*               9-AUG-1989  JDS  Cleaned up output display.          *
*              28-SEP-1989  JDS  Upped maximum nodes from 16 to 50.  *
*              14-NOV-1989  JDS  Added UAI symbols for flags and     *
*                                days of week, including RESTRICTED  *
*                                flag, which is new for VMS V5.2.    *
*               2-APR-1993  JDS  Added UAI symbols introduced in     *
*                                VMS V5.4 for password dictionary;   *
*                                thanks to Mark D. Schuster of Kodak *
*                                (hawkeye@kodak.com).                *
*                                Fixed bug that occurred when UIC    *
*                                group or member was more than 5     *
*                                octal digits; thanks to Claudio R.  *
*                                De Vincenzi of Universidade de Sao  *
*                                Paulo (CLAUDIO@ifqsc.usp.ansp.br).  *
*              21-JAN-1994  JDS  SCANUAF V2.0                        *
*                                Includes enhancements and bug fixes *
*                                requested/pointed out by Mark       *
*                                Schuster (hawkeye@kodak.com).       *
*                                See release notes for details.      *
*                                                                    *
*              14-JUL-2000  ROH  - add flag EXTAUTH                  *
*                                - move nodes file to CNC_MANAGER    *
*                                - move help into CNC_MANAGER:BO_HELP*
*                                - default to node LOCAL             *
*                                - default to reporttype BRIEF       *
*                                                                    *
*              16-SEP-2005  ROH  - add some more flags               *
*                                                                    *
*              19-SEP-2005  RLD  - Removed CNC-specific stuff        *
*                                                                    *
*              26-OCT-2006  RLD  - Modified ScanUAF_Nodes Open       *
*                                  statement to allow any file format*
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      CHARACTER*400 TBUFF(MAX_PARAMS)
      CHARACTER*32  USERNAME
      CHARACTER*21  EQ_SIGNS / '=====================' /
      CHARACTER*6   CTEMP

      LOGICAL       COUNTED, DELTA
      LOGICAL       RESULT, THIS_RESULT
      CHARACTER*255 ZSTRING_PARSE
                                
      INTEGER       TBUFF_FLAG(MASTER)
      INTEGER       IDVK

      INTEGER       STR$POSITION

      RECORD /SYSUAF_RECORD/ RECORD

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

      CALL AST_ENABLE         ! Queue an I/O request for trapping ^C.

                              ! Read the list of node names and UAF
                              !  filenames.

      OPEN (UNIT=12,
     +      FILE='SCANUAF_Nodes',
     +      STATUS='OLD',
     +      ACCESS='SEQUENTIAL',
     +      READONLY,
     +      SHARED,
     +      IOSTAT=IOS_NODES,
     +      ERR=850)
                    

                              ! Verify the list of nodes and filenames.

      NUM_NODES = 0
  
      DO 50 NODE = 1, MAX_NODES

         READ (12, '(A15,1X,A)', END=60) CNODE_LIST(NODE),
     +                                   UAF_FILENAME(NODE)

         CALL STR$UPCASE( CNODE_LIST(NODE),   CNODE_LIST(NODE) )
         CALL STR$UPCASE( UAF_FILENAME(NODE), UAF_FILENAME(NODE) )

         IF (CNODE_LIST(NODE) .EQ. 'ALL'     .OR.
     +       CNODE_LIST(NODE) .EQ. 'CLUSTER' .OR.
     +       CNODE_LIST(NODE) .EQ. 'DECNET') THEN
            TYPE *, 'Illegal node specification - ', CNODE_LIST(NODE)
            CNODE_LIST(NODE) = '#' // CNODE_LIST(NODE)
            TYPE *, 'SCANUAF will rename node ', CNODE_LIST(NODE)
         ENDIF

         NUM_NODES = NUM_NODES + 1
   50 ENDDO
 
   60 CLOSE (UNIT=12)

      IF (NUM_NODES .LE. 0) THEN
         TYPE *, 'SCANUAF.NODES contains no data - program terminated'
         GO TO 900
      ENDIF

      CALL SMG$CREATE_VIRTUAL_KEYBOARD( IDVK )

      DO 800 WHILE (.TRUE.)   ! This loop constitutes a DO group, to
                              !  execute until the user terminates the
                              !  program.

         CLOSE (UNIT=11)      ! Make sure no UAF file is open.

         CALL GET_PARAMS(IDVK, IDISP)      ! Get user input.

         IF (IDISP .EQ. 1) GO TO 810      ! User terminates program.

         VALID_INPUT = .TRUE.
                             
         RESET_DATE_CHECK = .TRUE.
         RESET_PRIV_CHECK = .TRUE.
         RESET_FLAG_CHECK = .TRUE.
         RESET_HOUR_CHECK = .TRUE.
         RESET_DAY_CHECK  = .TRUE.
         INDEX_DATE_CHECK = 0
         INDEX_PRIV_CHECK = 0
         INDEX_FLAG_CHECK = 0
         INDEX_HOUR_CHECK = 0
         INDEX_DAY_CHECK  = 0
                  
         DO 750 NODE = 1, NUM_NODES   ! Process each node.

         IF (NODESET .EQ. 'ALL') GO TO 90
         IF (NODESET .EQ. CNODE_LIST(NODE)) GO TO 90
         ICOLONS = STR$POSITION(UAF_FILENAME(NODE), '::')
         IF (NODESET .EQ. 'CLUSTER' .AND. ICOLONS .EQ. 0) GO TO 90
         IF (NODESET .EQ. 'DECNET'  .AND. ICOLONS .GT. 0) GO TO 90

         GO TO 750    ! Node is not to be processed.

   90    CLOSE (UNIT=11)      ! Make sure unit 11 is not in use.

         ICONTROL_C = 0       ! Reset ^C variable.

         OPEN ( UNIT=11,                        ! Open UAF file for this node.
     +          FILE=UAF_FILENAME(NODE),
     +          STATUS='OLD',
     +          ACCESS='SEQUENTIAL',
     +          RECORDTYPE='VARIABLE',
     +          FORM='UNFORMATTED',
     +          READONLY,
     +          SHARED,
     +          IOSTAT=IOS_OPEN,
     +          ERR=740)

                              ! Display heading for this node.

         CALL STR$TRIM( CNODE_LIST(NODE), CNODE_LIST(NODE), LNODE )

         WRITE (LUN, 100) EQ_SIGNS(1:LNODE+6), 
     +                    CNODE_LIST(NODE)(1:LNODE),
     +                    EQ_SIGNS(1:LNODE+6)
  100    FORMAT (/1X, A, /1X, 'Node: ', A, /1X, A)
                                 
                              ! If output is not to the user's terminal,
                              !  then print a message on the terminal
                              !  telling the user which node is being
                              !  processed.

         IF (LUN .EQ. 10) THEN
            TYPE *, 'Processing node ', CNODE_LIST(NODE)
         ENDIF

         ICOUNT = 0                               
         NMATCH = 0

         DO 700 WHILE (.TRUE.)      ! This loop is a DO group to process
                                    !  each record in the UAF file.  The
                                    !  loop is exited when an EOF is read.

            READ (11, END=720, ERR=640, IOSTAT=IOS_READ) RECORD   ! Read UAF
            ICOUNT = ICOUNT + 1                                   !  record.

            USERNAME = RECORD.UAF$T_USERNAME    ! Set USERNAME for output.

            RESULT = .TRUE.         ! Composite logical value for input line.
            THIS_RESULT = .FALSE.   ! Logical value for this param-value pair.

            DO M = 1, MASTER
               TBUFF_FLAG(M) = 0
            ENDDO

            DO 600 ITEM = 1, NUM_PARAMS     ! Loop to process each param-value
                                            !  pair on the input line.

               IPARAM = IPARAM_LIST(ITEM)   ! Index of current parameter.

               THIS_BUFF = ' '              ! These variables are used for
               MASTER_INDEX = IPARAM        !  program output.

                              ! Process the input data depending on the
                              !  parameter index.  The variable THIS_RESULT
                              !  will be set to the logical result of the
                              !  evaluation of the current param-value pair.

               IF      (IPARAM .EQ.  1) THEN        ! UAF record type

                  LONGWORD = RECORD.UAF$B_RTYPE

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ.  2) THEN        ! UAF format version

                  LONGWORD = RECORD.UAF$B_VERSION

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ.  3) THEN        ! Offset
                                                                     
                  LONGWORD = RECORD.UAF$W_USRDATOFF

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ.  4) THEN        ! Username of account

                  COUNTED = .FALSE.

                  CALL COMPARE_STRING( RECORD.UAF$T_USERNAME, 
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ.  5) THEN        ! UIC member

                  WRITE (CTEMP,'(O6)') RECORD.UAF$W_MEM   ! Convert from octal
                  READ  (CTEMP,'(I6)') LONGWORD           !  to decimal.

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )
 
               ELSE IF (IPARAM .EQ.  6) THEN        ! UIC group
 
                  WRITE (CTEMP,'(O6)') RECORD.UAF$W_GRP   ! Convert from octal
                  READ  (CTEMP,'(I6)') LONGWORD           !  to decimal.

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ.  7) THEN        ! User sub-identifier

                  CALL COMPARE_INTEGER( RECORD.UAF$L_SUB_ID,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ.  8) THEN        ! Account owner

                  THIS_RESULT = .FALSE.   ! Inaccessible parameter.

               ELSE IF (IPARAM .EQ.  9) THEN        ! Account name

                  COUNTED = .FALSE.

                  CALL COMPARE_STRING( RECORD.UAF$T_ACCOUNT, 
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 10) THEN        ! Owners name
         
                  COUNTED = .TRUE.

                  CALL COMPARE_STRING( RECORD.UAF$T_OWNER,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 11) THEN        ! Default device

                  COUNTED = .TRUE.

                  CALL COMPARE_STRING( RECORD.UAF$T_DEFDEV,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 12) THEN        ! Default directory

                  COUNTED = .TRUE.

                  CALL COMPARE_STRING( RECORD.UAF$T_DEFDIR,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 13) THEN        ! Login command file

                  COUNTED = .TRUE.

                  CALL COMPARE_STRING( RECORD.UAF$T_LGICMD,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 14) THEN        ! Default CLI

                  COUNTED = .TRUE.

                  CALL COMPARE_STRING( RECORD.UAF$T_DEFCLI,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 15) THEN        ! User CLI tables

                  COUNTED = .TRUE.

                  CALL COMPARE_STRING( RECORD.UAF$T_CLITABLES,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 16) THEN        ! Primary password

                   THIS_RESULT = .FALSE.  ! Inaccessible parameter.

               ELSE IF (IPARAM .EQ. 17) THEN        ! Secondary password

                   THIS_RESULT = .FALSE.  ! Inaccessible parameter.

               ELSE IF (IPARAM .EQ. 18) THEN        ! Login failures

                  LONGWORD = RECORD.UAF$W_LOGFAILS

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 19) THEN        ! Random password salt

                  LONGWORD = RECORD.UAF$W_SALT

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 20) THEN        ! Encrypt primary

                  LONGWORD = RECORD.UAF$B_ENCRYPT

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 21) THEN        ! Encrypt secondary

                  LONGWORD = RECORD.UAF$B_ENCRYPT2

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 22) THEN        ! Minimum password length

                  LONGWORD = RECORD.UAF$B_PWD_LENGTH

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 23) THEN        ! Exp date for account

                  DELTA = .FALSE.

                  CALL COMPARE_DATE( RECORD.UAF$Q_EXPIRATION,
     +                               CVALUE_LIST(ITEM),
     +                               COMPARE_LIST(ITEM),
     +                               DELTA,
     +                               THIS_RESULT )

               ELSE IF (IPARAM .EQ. 24) THEN        ! Password lifetime

                  DELTA = .TRUE.

                  CALL COMPARE_DATE( RECORD.UAF$Q_PWD_LIFETIME,
     +                               CVALUE_LIST(ITEM),
     +                               COMPARE_LIST(ITEM),
     +                               DELTA,
     +                               THIS_RESULT )

               ELSE IF (IPARAM .EQ. 25) THEN        ! Date of prim pwd change

                  DELTA = .FALSE.

                  CALL COMPARE_DATE( RECORD.UAF$Q_PWD_DATE,
     +                               CVALUE_LIST(ITEM),
     +                               COMPARE_LIST(ITEM),
     +                               DELTA,
     +                               THIS_RESULT )

               ELSE IF (IPARAM .EQ. 26) THEN        ! Date of sec pwd change

                  DELTA = .FALSE.

                  CALL COMPARE_DATE( RECORD.UAF$Q_PWD2_DATE,
     +                               CVALUE_LIST(ITEM),
     +                               COMPARE_LIST(ITEM),
     +                               DELTA,
     +                               THIS_RESULT )

               ELSE IF (IPARAM .EQ. 27) THEN        ! Date of last int login

                  DELTA = .FALSE.

                  CALL COMPARE_DATE( RECORD.UAF$Q_LASTLOGIN_I,
     +                               CVALUE_LIST(ITEM),
     +                               COMPARE_LIST(ITEM),
     +                               DELTA,
     +                               THIS_RESULT )

               ELSE IF (IPARAM .EQ. 28) THEN        ! Date of last n-int login

                  DELTA = .FALSE.

                  CALL COMPARE_DATE( RECORD.UAF$Q_LASTLOGIN_N,
     +                               CVALUE_LIST(ITEM),
     +                               COMPARE_LIST(ITEM),
     +                               DELTA,
     +                               THIS_RESULT )

               ELSE IF (IPARAM .EQ. 29) THEN        ! Authorized privleges

                  CALL PRIV_CHECK( RECORD.UAF$Q_PRIV,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 30) THEN        ! Default privleges

                  CALL PRIV_CHECK( RECORD.UAF$Q_DEF_PRIV,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 31) THEN        ! Min security class

                  COUNTED = .FALSE.  ! ???

                  CALL COMPARE_STRING( RECORD.UAF$R_MIN_CLASS,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 32) THEN        ! Max security class

                  COUNTED = .FALSE.  ! ???

                  CALL COMPARE_STRING( RECORD.UAF$R_MAX_CLASS,
     +                                 CVALUE_LIST(ITEM),
     +                                 COMPARE_LIST(ITEM),
     +                                 COUNTED,
     +                                 THIS_RESULT )

               ELSE IF (IPARAM .EQ. 33) THEN        ! Login flags

                  CALL FLAG_CHECK( RECORD.UAF$L_FLAGS,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 34) THEN        ! Hourly net acc, prim

                  CALL HOUR_CHECK( RECORD.UAF$B_NETWORK_ACCESS_P,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 35) THEN        ! Hourly net acc, sec

                  CALL HOUR_CHECK( RECORD.UAF$B_NETWORK_ACCESS_S,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 36) THEN        ! Hourly bat acc, prim

                  CALL HOUR_CHECK( RECORD.UAF$B_BATCH_ACCESS_P,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 37) THEN        ! Hourly bat acc, sec

                  CALL HOUR_CHECK( RECORD.UAF$B_BATCH_ACCESS_S,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 38) THEN        ! Hourly loc acc, prim

                  CALL HOUR_CHECK( RECORD.UAF$B_LOCAL_ACCESS_P,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 39) THEN        ! Hourly loc acc, sec

                  CALL HOUR_CHECK( RECORD.UAF$B_LOCAL_ACCESS_S,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 40) THEN        ! Hourly dial acc, prim

                  CALL HOUR_CHECK( RECORD.UAF$B_DIALUP_ACCESS_P,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 41) THEN        ! Hourly dial acc, sec

                  CALL HOUR_CHECK( RECORD.UAF$B_DIALUP_ACCESS_S,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 42) THEN        ! Hourly rem acc, prim

                  CALL HOUR_CHECK( RECORD.UAF$B_REMOTE_ACCESS_P,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 43) THEN        ! Hourly rem acc, sec

                  CALL HOUR_CHECK( RECORD.UAF$B_REMOTE_ACCESS_S,
     +                             CVALUE_LIST(ITEM),
     +                             COMPARE_LIST(ITEM),
     +                             THIS_RESULT )

               ELSE IF (IPARAM .EQ. 44) THEN        ! Primary days

                  CALL DAY_CHECK( RECORD.UAF$B_PRIMEDAYS,
     +                            CVALUE_LIST(ITEM),
     +                            COMPARE_LIST(ITEM),
     +                            THIS_RESULT )

               ELSE IF (IPARAM .EQ. 45) THEN        ! Base process priority

                  LONGWORD = RECORD.UAF$B_PRI

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 46) THEN        ! Max job queueing priority

                  LONGWORD = RECORD.UAF$B_QUEPRI

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 47) THEN        ! Max jobs for UIC

                  LONGWORD = RECORD.UAF$W_MAXJOBS

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 48) THEN        ! Max jobs for account

                  LONGWORD = RECORD.UAF$W_MAXACCTJOBS

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 49) THEN        ! Max detached processes

                  LONGWORD = RECORD.UAF$W_MAXDETACH

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 50) THEN        ! Subprocess limit

                  LONGWORD = RECORD.UAF$W_PRCCNT

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 51) THEN        ! Buffered I/O limit

                  LONGWORD = RECORD.UAF$W_BIOLM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 52) THEN        ! Direct I/O limit

                  LONGWORD = RECORD.UAF$W_DIOLM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 53) THEN        ! Timer queue entry limit

                  LONGWORD = RECORD.UAF$W_TQCNT

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 54) THEN        ! AST queue limit

                  LONGWORD = RECORD.UAF$W_ASTLM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 55) THEN        ! Enqueue limit

                  LONGWORD = RECORD.UAF$W_ENQLM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 56) THEN        ! Open file limit

                  LONGWORD = RECORD.UAF$W_FILLM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 57) THEN        ! Shared file limit

                  LONGWORD = RECORD.UAF$W_SHRFILLM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 58) THEN        ! Working set size quota

                  CALL COMPARE_INTEGER( RECORD.UAF$L_WSQUOTA,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 59) THEN        ! Default working set size

                  CALL COMPARE_INTEGER( RECORD.UAF$L_DFWSCNT,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 60) THEN        ! Working set size limit

                  CALL COMPARE_INTEGER( RECORD.UAF$L_WSEXTENT,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 61) THEN        ! Page file quota

                  CALL COMPARE_INTEGER( RECORD.UAF$L_PGFLQUOTA,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 62) THEN        ! CPU time quota

                  CALL COMPARE_INTEGER( RECORD.UAF$L_CPUTIM,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 63) THEN        ! Buff I/O byte cnt limit

                  CALL COMPARE_INTEGER( RECORD.UAF$L_BYTLM,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 64) THEN        ! Paged buff I/O limit

                  CALL COMPARE_INTEGER( RECORD.UAF$L_PBYTLM,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 65) THEN        ! Job log nam tab quota

                  CALL COMPARE_INTEGER( RECORD.UAF$L_JTQUOTA,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 66) THEN        ! Num of proxies can grant

                  LONGWORD = RECORD.UAF$W_PROXY_LIM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 67) THEN        ! Num of proxies granted

                  LONGWORD = RECORD.UAF$W_PROXIES

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 68) THEN        ! Num sub-accnts allowed

                  LONGWORD = RECORD.UAF$W_ACCOUNT_LIM

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE IF (IPARAM .EQ. 69) THEN        ! Num sub-accnts in use

                  LONGWORD = RECORD.UAF$W_ACCOUNTS

                  CALL COMPARE_INTEGER( LONGWORD,
     +                                  IVALUE_LIST(ITEM),
     +                                  COMPARE_LIST(ITEM),
     +                                  THIS_RESULT )

               ELSE

                  THIS_RESULT = .FALSE.  ! Unrecognized parameter.

               ENDIF

               IF (.NOT. VALID_INPUT) THEN     ! Invalid input; abort search.
                  TYPE *, 'Search aborted'
                  TYPE *, ' '
                  IF (LUN .EQ. 10) THEN            
                     WRITE (LUN, 550)
  550                FORMAT (/,' * Invalid input *', /)   
                  ENDIF
                  GO TO 800
               ENDIF

                                               ! Fill in ZSTRING with logical
                                               !  result.

               IF (THIS_RESULT) THEN
                  ZSTRING(ZINDEX(ITEM):ZINDEX(ITEM)) = '1'
               ELSE
                  ZSTRING(ZINDEX(ITEM):ZINDEX(ITEM)) = '0'
               ENDIF

               IF (TBUFF_FLAG(IPARAM) .EQ. 0) THEN
                  TBUFF(ITEM) = THIS_BUFF    ! Set output buffer.
                  TBUFF_FLAG(IPARAM) = 1
               ELSE
                  TBUFF(ITEM) = ' '
               ENDIF

  600       ENDDO                     ! End of loop to process each param-value
                                      !  pair on the input line.

                                      ! Evaluate logical value of ZSTRING.

            ZSTRING_PARSE = ZSTRING
            CALL LOGICAL_PARSE( ZSTRING_PARSE(1:ZSIZE), RESULT )

            IF (.NOT. VALID_INPUT) THEN     ! Invalid input; abort search.
               TYPE *, 'Search aborted'
               TYPE *, ' '
               IF (LUN .EQ. 10) THEN            
                  WRITE (LUN, 550)
               ENDIF
               GO TO 800
            ENDIF

                              ! If the composite logical value for the input
                              !  line (RESULT) is .TRUE., then this UAF record
                              !  is a match, so output the appropriate data.

            IF (RESULT) THEN
               IF (REPORTSET .EQ. 'FULL') WRITE (LUN, 610) USERNAME
  610          FORMAT (/, ' Username    : ', A)
               IF (REPORTSET .EQ. 'BRIEF') WRITE (LUN, 620) USERNAME
  620          FORMAT (' Username: ', A)
               IF (REPORTSET .EQ. 'FULL') THEN
                  DO ITEM = 1, NUM_PARAMS
                     IF (TBUFF(ITEM) .NE. ' ') THEN
                        WRITE (LUN, 630) (TBUFF(ITEM)(I:I),
     +                                    I = 1, ISTRING_LAST(TBUFF(ITEM)))
  630                   FORMAT ( 1X, 78A1, '-', 7(/15X,64A1,'-') )
                     ENDIF
                  ENDDO
               ENDIF
               NMATCH = NMATCH + 1
            ENDIF

            RESET_DATE_CHECK = .FALSE.
            RESET_PRIV_CHECK = .FALSE.
            RESET_FLAG_CHECK = .FALSE.
            RESET_HOUR_CHECK = .FALSE.
            RESET_DAY_CHECK  = .FALSE.
            INDEX_DATE_CHECK = 0
            INDEX_PRIV_CHECK = 0
            INDEX_FLAG_CHECK = 0
            INDEX_HOUR_CHECK = 0
            INDEX_DAY_CHECK  = 0                              

  640       IF (IOS_READ .NE. 0) 
     +         TYPE *, 'Read error ', UAF_FILENAME(NODE), '  ', IOS_READ

                              ! ^C processing.

            IF (ICONTROL_C .GT. 0) THEN
               IF (LUN .EQ. 10) THEN            ! If output is going to a file,
                  WRITE (LUN, 670)              !  then print a message in the
  670             FORMAT (/,' * CANCEL *', /)   !  file.
               ENDIF
               IF (ICONTROL_C .EQ. 1) GO TO 750
               GO TO 800
            ENDIF

  700    ENDDO        ! End of loop to process each record in the UAF file.

  720    IF (REPORTSET .EQ. 'FULL') WRITE (LUN, '(1X)')
         WRITE (LUN, 730) ICOUNT, NMATCH
  730    FORMAT (1X, 32('-'), /1X, 'Records:', I6, '    Matches:', I6,
     +          /1X, 32('-'))

  740    IF (IOS_OPEN .NE. 0)
     +      TYPE *, 'Open error ', UAF_FILENAME(NODE), '  ', IOS_OPEN

  750    ENDDO        ! End of loop to process each node.

         WRITE (LUN, '(1X)')

  800 ENDDO           ! End of loop to process until the user terminates
                      !  the program.

  810 CLOSE (UNIT = 11)    ! Make sure all files are closed.
      CLOSE (UNIT = 10)

  850 IF (IOS_NODES .NE. 0)
     +   TYPE *, 'Open error on SCANUAF.NODES - ', IOS_NODES
      CLOSE (UNIT=12)

  900 CONTINUE
      END
C==========================================================/GET_PARAMS
 
      SUBROUTINE GET_PARAMS(IDVK, IDISP)

**********************************************************************
*                                                                    *
*   Read and parse user's input.                                     *
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      INTEGER IDVK              ! Virtual keyboard
      INTEGER IDISP             ! Disposition
*                                                                    *
**********************************************************************

      INCLUDE '($SMGMSG)'
      INCLUDE 'SCANUAF.INC'

      INTEGER SMG$READ_COMPOSED_LINE

      CHARACTER*255 LINE

      DATA IFORCE  / 0 /

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*


      DO 800 WHILE (.TRUE.)   ! Loop to process user input until a valid,
                              !  parameter-value line is entered.

         LINE = ' '           ! Line of user input.

                              ! Get the input line from the user.  If a
                              !  ^Z was entered (SMG$_EOF), then branch
                              !  to terminate the program.

C        ISTATUS = LIB$GET_FOREIGN( LINE, 'SCANUAF> ', , IFORCE )
         ISTATUS = SMG$READ_COMPOSED_LINE( IDVK, , LINE, 'SCANUAF> ' )
              
         IF (ISTATUS .EQ. SMG$_EOF) THEN
            IDISP = 1
            GO TO 200
         ENDIF
         IF (.NOT. ISTATUS) THEN
            CALL ERROR_MESSAGE(ISTATUS)
            IDISP = 0
            GO TO 200
         ENDIF

         CALL STR$UPCASE( LINE, LINE )   ! Convert input to upper case.

         ILO = 0
         IQUOTE = 0
         ZSIZE = 0
         ZSTRING = ' '
         IDISP = 0
         ISPECIAL = 0
         NUM_PARAMS = 0       ! Number of parameters on line.

         DO 100 I = 1, 255

            IF (LINE(I:I) .EQ. '"') IQUOTE = 1 - IQUOTE   ! Check for ".

            IF (IQUOTE .EQ. 0 .AND.
     +          (LINE(I:I) .EQ. '(' .OR.
     +           LINE(I:I) .EQ. ')' .OR.
     +           LINE(I:I) .EQ. '&' .OR.
     +           LINE(I:I) .EQ. '|' .OR.
     +           LINE(I:I) .EQ. ' ' ) ) THEN

               IF (ILO .GT. 0) THEN
                  IHI = I - 1
                  CALL VALIDATE_INPUT(LINE(ILO:IHI), ISPECIAL, IDISP)
                  IF (IDISP .EQ. 0) GO TO 200   
                  IF (IDISP .EQ. 1) GO TO 200
                  ZSIZE = ZSIZE + 1
                  ZSTRING(ZSIZE:ZSIZE) = 'Z'
                  IF (NUM_PARAMS .GT. 0) ZINDEX(NUM_PARAMS) = ZSIZE
               ENDIF

               ZSIZE = ZSIZE + 1
               ZSTRING(ZSIZE:ZSIZE) = LINE(I:I)

               ILO = 0

            ELSE

               IF (ILO .EQ. 0) ILO = I

            ENDIF

  100    ENDDO

         IF (IQUOTE .EQ. 1) THEN
            TYPE *, ' '
            TYPE *, 'Illegal specification - unclosed quotes'
            TYPE *, ' '
            IDISP = 0
            GO TO 200
         ENDIF

         IF (ISPECIAL .EQ. 1) THEN                
            TYPE *, ' '                     
            TYPE *, 'Illegal special command; no action performed'
            TYPE *, ' '
            IDISP = 0
            GO TO 200
         ENDIF                                 

         IF (ISPECIAL .EQ. 2) THEN                
            CALL DO_NODE('ALL')
            IDISP = 0
            GO TO 200
         ENDIF                                 

         IF (ISPECIAL .EQ. 3) THEN                
            CALL DO_REPORT('FULL')
            IDISP = 0
            GO TO 200
         ENDIF                                 

         IF (ISPECIAL .EQ. 4) THEN                
            CALL DO_OUTPUT('SYS$OUTPUT')
            IDISP = 0
            GO TO 200
         ENDIF                                 

  200    IF (IDISP .GT. 0) GO TO 810           ! 0 ==> Reprompt
                                               ! 1 ==> Exit program
                                               ! 2 ==> Leave to process
                                               !       parameter-value pairs

  800 ENDDO
  810 CONTINUE

                              ! If output is going to a file, then print
                              !  input line in the file.

      IF (LUN .EQ. 10) 
     +   WRITE (LUN, '(/1X,A,/1X,A,/1X,A,/1X,A)') 
     +   LINE(1:79),LINE(80:158),LINE(159:237),LINE(238:255)

      RETURN
      END
C=====================================================/VALIDATE_PVPAIR

      SUBROUTINE VALIDATE_INPUT( PVPAIR, ISPECIAL, IDISP )

**********************************************************************
*                                                                    *
*   Validate input string as a parameter-value pair.                 *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) PVPAIR      ! Potential parameter-value pair
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      INTEGER ISPECIAL          ! Processing special input 
      INTEGER IDISP             ! Disposition
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'
      
      INTEGER      IPARAM_LOCAL
      INTEGER      IVALUE_LOCAL
      CHARACTER*64 CVALUE_LOCAL
      CHARACTER*1  COMPARE_LOCAL

      CHARACTER*64 CTEMP

      INTEGER      STR$POSITION 

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Check for special input commands.        

      IF (ISPECIAL .EQ. 2) THEN
         CALL DO_NODE(PVPAIR)
         ISPECIAL = 0
         IDISP = 0
         GO TO 900
      ENDIF

      IF (ISPECIAL .EQ. 3) THEN
         CALL DO_REPORT(PVPAIR)
         ISPECIAL = 0
         IDISP = 0
         GO TO 900
      ENDIF

      IF (ISPECIAL .EQ. 4) THEN
         CALL DO_OUTPUT(PVPAIR)
         ISPECIAL = 0
         IDISP = 0
         GO TO 900
      ENDIF

      IF (ISPECIAL .EQ. 1) THEN
         IF (PVPAIR .EQ. 'NODE')   ISPECIAL = 2
         IF (PVPAIR .EQ. 'REPORT') ISPECIAL = 3
         IF (PVPAIR .EQ. 'OUTPUT') ISPECIAL = 4
         IDISP = 2 
         IF (ISPECIAL .EQ. 1) THEN
            TYPE *, ' '                     
            TYPE *, 'Illegal special command; no action performed'
            TYPE *, ' '
            IDISP = 0
         ENDIF
         GO TO 900
      ENDIF

      IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'SET') THEN
         ISPECIAL = 1
         IDISP = 2
         GO TO 900
      ENDIF

      IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'HELP') THEN
         CALL DO_HELP
         IDISP = 0
         GO TO 900
      ENDIF

      IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'SHOW') THEN
         CALL DO_SHOW
         IDISP = 0
         GO TO 900
      ENDIF

      IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'AUTHORIZE') THEN
         CALL DO_AUTHORIZE
         IDISP = 0
         GO TO 900
      ENDIF

C ROHWEDDER
      IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'UAF') THEN
         CALL DO_AUTHORIZE
         IDISP = 0
         GO TO 900
      ENDIF

      IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'EXIT') THEN
         IDISP = 1
         GO TO 900
      ENDIF

                              ! Check for parameter-value pair.        

      IF (NUM_PARAMS .GE. MAX_PARAMS) THEN
         TYPE *, ' '
         TYPE *, 'Illegal specification - too many parameters'
         TYPE *, ' '
         IDISP = 0
         GO TO 900
      ENDIF

      LPVPAIR = LEN(PVPAIR)

      DO J = 1, LPVPAIR       ! Find the comparison character.
         MARK = J
         IF (PVPAIR(J:J) .EQ. '=' .OR.
     +       PVPAIR(J:J) .EQ. '\' .OR.      
     +       PVPAIR(J:J) .EQ. '>' .OR.      
     +       PVPAIR(J:J) .EQ. '<' ) GO TO 350
      ENDDO

                              ! Make sure the comparison character is in
                              !  a valid spot.

  350 IF (MARK .LE. 1 .OR. MARK .GE. LPVPAIR) THEN
         TYPE *, ' '
         TYPE *, 'Illegal entry - ', PVPAIR(1:LPVPAIR)
         TYPE *, ' '
         IDISP = 0
         GO TO 900
      ENDIF

      MHI = MARK - 1

                              ! Check master list of parameters.

      DO 400 J = 1, MASTER 
         IF (MHI .LT. ISTAR(J)) GO TO 400
         IF (MHI .GT. 12)       GO TO 400
         IF (PVPAIR(1:MHI) .EQ. PARAM(J)(1:MHI)) THEN  ! Entry valid.
            IPARAM_LOCAL = J                           ! Index of parameter.
            GO TO 410
         ENDIF      
  400 ENDDO

                              ! If control gets here, then the entry was not
                              !  found in the master list.
 
      TYPE *, ' '
      TYPE *, 'Illegal parameter specification - ', PVPAIR(1:LPVPAIR)
      TYPE *, ' '
      IDISP = 0
      GO TO 900

                              ! Check comparison chararcter.

  410 IF ( STR$POSITION( COMPCHARS(IPARAM_LOCAL) ,
     +                   PVPAIR(MARK:MARK) ) .GT. 0 ) GO TO 420

      TYPE *, ' '
      TYPE *, 'Illegal comparison character - ', PVPAIR(1:LPVPAIR)
      TYPE *, ' '
      IDISP = 0
      GO TO 900

  420 COMPARE_LOCAL = PVPAIR(MARK:MARK)
              
      MLO = MARK + 1
      LTEMP = 0
      CTEMP = ' '

                              ! Store entry string in temporary variable
                              !  CTEMP, eliminating any " characters.

      DO J = MLO, LPVPAIR
         IF (PVPAIR(J:J) .NE. '"' .AND. LTEMP .LT. 64) THEN
            LTEMP = LTEMP + 1
            CTEMP(LTEMP:LTEMP) = PVPAIR(J:J)
         ENDIF
      ENDDO

      IF (LTEMP .EQ. 0) GO TO 430    ! Invalid field.

                              ! Store the entry is either CVALUE_LIST or
                              !  IVALUE_LIST, depending on if the value
                              !  should be character or integer, respectively.

      IF (TYPE(IPARAM_LOCAL) .EQ. 'C') THEN
         CVALUE_LOCAL = CTEMP(1:LTEMP)
         IVALUE_LOCAL = 0
      ELSE
         READ (CTEMP(1:LTEMP), '(I)', ERR=430) IVALUE_LOCAL
         CVALUE_LOCAL = ' '
      ENDIF
 
      GO TO 450

  430 TYPE *, ' '
      TYPE *, 'Illegal value specification - ', PVPAIR(1:LPVPAIR)
      TYPE *, ' '
      IDISP = 0
      GO TO 900

  450 NUM_PARAMS = NUM_PARAMS + 1
      IPARAM_LIST(NUM_PARAMS)  = IPARAM_LOCAL
      COMPARE_LIST(NUM_PARAMS) = COMPARE_LOCAL
      IVALUE_LIST(NUM_PARAMS)  = IVALUE_LOCAL
      CVALUE_LIST(NUM_PARAMS)  = CVALUE_LOCAL
      IDISP = 2

  900 CONTINUE
      RETURN
      END

C=============================================================/DO_NODE
 
      SUBROUTINE DO_NODE(VALUE)

**********************************************************************
*                                                                    *
*   Set nodename for subsequent scans.                               *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) VALUE      ! Nodename to set
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'
              
*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

      IF (VALUE .EQ. ' '        .OR.                  ! Check for special
     +    VALUE .EQ. 'ALL'      .OR.                  !  SET NODE keyword.
     +    VALUE .EQ. 'CLUSTER'  .OR.
     +    VALUE .EQ. 'DECNET' ) THEN
         NODESET = VALUE
         IF (NODESET .EQ. ' ') NODESET = 'ALL'
         GO TO 120                                    
      ENDIF

      DO 100 I = 1, NUM_NODES                         ! Check for valid
         IF (VALUE .EQ. CNODE_LIST(I)) THEN           !  nodename.
            NODESET = CNODE_LIST(I)
            GO TO 120
         ENDIF
  100 ENDDO
 
      TYPE *, ' '
      TYPE *, 'Illegal SET NODE specification - ', VALUE
      TYPE *, 'No action performed'
      TYPE *, ' '

  120 CONTINUE
      RETURN
      END

C===========================================================/DO_REPORT
 
      SUBROUTINE DO_REPORT(VALUE)

**********************************************************************
*                                                                    *
*   Set report type for subsequent scans.                            *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) VALUE      ! Report type to set
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

      IF (VALUE .EQ. ' '      .OR.
     +    VALUE .EQ. 'FULL'   .OR.
     +    VALUE .EQ. 'BRIEF') THEN
         REPORTSET = VALUE
         IF (REPORTSET .EQ. ' ') REPORTSET = 'FULL'
      ELSE
         TYPE *, ' '
         TYPE *, 'Illegal SET REPORT specification - ', VALUE
         TYPE *, 'No action performed'
         TYPE *, ' '
      ENDIF

      RETURN
      END

C===========================================================/DO_OUTPUT
 
      SUBROUTINE DO_OUTPUT(VALUE)

**********************************************************************
*                                                                    *
*   Set output for subsequent scans.                                 *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) VALUE      ! Output to set
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

      CLOSE (UNIT=10)            ! Close existing output file.
      LUN = 6                    ! Initialize output unit number.
      OUTPUTSET = 'SYS$OUTPUT'   ! Initialize output destination.

      IF (VALUE .EQ. ' '          .OR.        ! Check for values that would
     +    VALUE .EQ. 'SYS$OUTPUT') GO TO 220  !  send output to user's
                                              !  terminal.

      OPEN (UNIT=10,                          ! Open new output file.
     +      FILE=VALUE,
     +      ACCESS='SEQUENTIAL',
     +      CARRIAGECONTROL='LIST',
     +      FORM='FORMATTED',
     +      STATUS='NEW',
     +      ERR=200,
     +      IOSTAT=IOS)
  200 IF (IOS .NE. 0) THEN                         ! Open error; output goes
         TYPE *, 'Open error ', VALUE, '  ', IOS   !  to user's terminal.
      ELSE                                         ! File opened ok, output
         LUN = 10                                  !  goes to file.
         OUTPUTSET = VALUE
      ENDIF

  220 CALL STR$TRIM( OUTPUTSET, OUTPUTSET, LOUTPUTSET)
      TYPE *, 'Output will be written to ', OUTPUTSET(1:LOUTPUTSET)
 
      RETURN
      END

C=============================================================/DO_HELP
 
      SUBROUTINE DO_HELP

**********************************************************************
*                                                                    *
*   Display help.                                                    *
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'
      EXTERNAL LIB$PUT_OUTPUT, LIB$GET_INPUT

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

      CALL LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,,'SCANUAF',,,LIB$GET_INPUT)
      RETURN
      END

C=============================================================/DO_SHOW
 
      SUBROUTINE DO_SHOW

**********************************************************************
*                                                                    *
*   Display current special input parameter settings.                *
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      INTEGER      STR$POSITION 

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

      TYPE *, ' '
      TYPE *, 'Current settings for special input command parameters are:'
      TYPE *, ' '
      TYPE *, '   <nodename>    = ', NODESET
      TYPE *, '   <reporttype>  = ', REPORTSET
      TYPE *, '   <destination> = ', OUTPUTSET
      TYPE *, ' '
      TYPE *, 'The list of nodes that can be processed is as follows:'
      TYPE *, ' '
      TYPE *, '   Node(s)         Access'
      DO I = 1, NUM_NODES
         IF (STR$POSITION(UAF_FILENAME(I), '::') .EQ. 0) THEN
            TYPE *, '   ', CNODE_LIST(I), ' CLUSTER'
         ELSE
            TYPE *, '   ', CNODE_LIST(I), ' DECNET'
         ENDIF
      ENDDO
      TYPE *, ' '

      RETURN
      END

C========================================================/DO_AUTHORIZE
 
      SUBROUTINE DO_AUTHORIZE        

**********************************************************************
*                                                                    *
*   Run the AUTHORIZE system utility.                                *
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'
      INCLUDE '($LNMDEF)'
      INCLUDE '($PSLDEF)'
      INCLUDE '($SSDEF)'
      INCLUDE '($SYSSRVNAM)'

      STRUCTURE /ITEM_LIST_3/
         INTEGER*2 IBUFFER_LENGTH
         INTEGER*2 ITEM_CODE
         INTEGER   IBUFFER_ADDRESS
         INTEGER   IRETURN_LENGTH_ADDRESS
      END STRUCTURE
      RECORD /ITEM_LIST_3/ ITMLST(2)

      CHARACTER*60 SYSUAF_TRANSLATION
      INTEGER*2 LST

      CHARACTER*60 TEMPSYSUAF
      CHARACTER*15 TEMPNODE

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*
                                                      
      TEMPNODE = NODESET

      DO 100 WHILE (.TRUE.)   ! Loop to prompt user until a valid node is set.

         DO 70 I = 1, NUM_NODES   ! Check for valid node entry.
            NODE = I
            IF (TEMPNODE .EQ. CNODE_LIST(I)) GO TO 110  ! Valid node.
   70    ENDDO

         ISTATUS = LIB$GET_INPUT( TEMPNODE, 'For which node? ')

                              ! If some error occurred in the read,
                              ! or the user entered a blank node,
                              !  then cancel the AUTHORIZE run.

         IF (.NOT. ISTATUS) THEN
            CALL ERROR_MESSAGE(ISTATUS)
            TYPE *, 'Action cancelled' 
            GO TO 200
         ENDIF

         IF (TEMPNODE .EQ. ' ') THEN
            TYPE *, 'Action cancelled' 
            GO TO 200
         ENDIF

         CALL STR$UPCASE( TEMPNODE, TEMPNODE ) ! Convert input to upper case.

  100 ENDDO   ! End of loop to process until a valid node is entered.

                              ! Tell the user the node for which AUTHORIZE
                              !  will be run.


  110 TEMPSYSUAF = UAF_FILENAME(NODE)

      IF (TEMPSYSUAF .EQ. 'SYSUAF') THEN
         ITMLST(1).IBUFFER_LENGTH = 60
         ITMLST(1).ITEM_CODE = LNM$_STRING
         ITMLST(1).IBUFFER_ADDRESS = %LOC(SYSUAF_TRANSLATION)
         ITMLST(1).IRETURN_LENGTH_ADDRESS = %LOC(LST)
         ITMLST(2).IBUFFER_LENGTH = 0
         ITMLST(2).ITEM_CODE = 0

         ISTATUS = SYS$TRNLNM( , 'LNM$SYSTEM', 'SYSUAF', PSL$C_EXEC, ITMLST )
         IF (ISTATUS .EQ. SS$_NORMAL) TEMPSYSUAF = SYSUAF_TRANSLATION(1:LST)
      ENDIF

      IF (TEMPSYSUAF .EQ. 'SYSUAF') THEN
         TYPE *, 'Unable to determine SYSUAF filename for node ', TEMPNODE
         GO TO 200
      ENDIF

      TYPE *, ' '
      TYPE *, 'AUTHORIZE will be run for node ', TEMPNODE
      TYPE *, 'SYSUAF file = ', TEMPSYSUAF
      TYPE *, ' '
      TYPE *, '*** Warning:  In running the AUTHORIZE utility from within ' //
     +        'SCANUAF for a remote'
      TYPE *, '              node, use caution in modifying the rightlist ' //
     +        'file and/or the'
      TYPE *, '              DECnet proxy file.  SCANUAF will use the ' //
     +        'remote node''s'
      TYPE *, '              authorization file, but it will use the local ' //
     +        'node''s rightslist'
      TYPE *, '              file and DECnet proxy file, which may not be ' //
     +        'the same as those'
      TYPE *, '              of the remote node.'
      TYPE *, ' '

                              ! Assign SYSUAF to the UAF on the proper node.

      ISTATUS = LIB$SET_LOGICAL('SYSUAF', TEMPSYSUAF, , , )
      IF (.NOT. ISTATUS) THEN
         TYPE *, 'LIB$SET_LOGICAL status:'
         CALL ERROR_MESSAGE(ISTATUS)
      ENDIF

                              ! Spawn a subprocess to run AUTHORIZE.

      ISTATUS = LIB$SPAWN('RUN SYS$SYSTEM:AUTHORIZE')
      IF (.NOT. ISTATUS) THEN
         TYPE *, 'LIB$SPAWN status:'
         CALL ERROR_MESSAGE(ISTATUS)
      ENDIF
      TYPE *, ' '

                              ! Deassign SYSUAF.

      ISTATUS = LIB$DELETE_LOGICAL('SYSUAF', )
      IF (.NOT. ISTATUS) THEN
         TYPE *, 'LIB$DELETE_LOGICAL status:'
         CALL ERROR_MESSAGE(ISTATUS)
      ENDIF

  200 CONTINUE

      RETURN
      END

C=======================================================/LOGICAL_PARSE
 
      SUBROUTINE LOGICAL_PARSE( STRING, RESULT )

**********************************************************************
*                                                                    *
*   Evaluate logical expression.                                     *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) STRING   ! Logical expression.

*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL     RESULT     ! Result of logical expression.

*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      CHARACTER*1 OP
      INTEGER I, L, R, LSTRING
      LOGICAL LAST

      VALID_INPUT = .TRUE.
      LAST = .FALSE.
      LSTRING = LEN(STRING)
      
      DO 300 WHILE (.TRUE.)
         L = 0
         R = 0
         DO I = 1, LSTRING
            IF (STRING(I:I) .EQ. '(') THEN
               L = I
            ELSE IF (STRING(I:I) .EQ. ')') THEN
               R = I
            ENDIF
            IF (L .GT. 0 .AND. R .GT. 0) GO TO 200
         ENDDO

         IF (L .GT. 0 .OR. R .GT. 0) THEN
            TYPE *, ' '
            TYPE *, 'Error - unmatched parentheses'
            VALID_INPUT = .FALSE.
            GO TO 310
         ENDIF

         L = 0
         R = LSTRING+1
         LAST = .TRUE.

  200    RESULT = .TRUE.
         OP = '&'
         DO I = L+1,R-1
            IF (STRING(I:I) .EQ. '1') THEN
               IF (OP .EQ. '&') RESULT = RESULT .AND. .TRUE.
               IF (OP .EQ. '|') RESULT = RESULT .OR.  .TRUE.
            ELSE IF (STRING(I:I) .EQ. '0') THEN
               IF (OP .EQ. '&') RESULT = RESULT .AND. .FALSE.
               IF (OP .EQ. '|') RESULT = RESULT .OR.  .FALSE.
            ELSE IF (STRING(I:I) .EQ. '&' .OR. STRING(I:I) .EQ. '|') THEN
               OP = STRING(I:I)
            ELSE IF (STRING(I:I) .NE. ' ') THEN
               TYPE *, ' '
               TYPE *, 'Error - unrecognized character ', STRING(I:I)
               VALID_INPUT = .FALSE.
               GO TO 310
            ENDIF
            STRING(I:I) = ' '
         ENDDO
         IF (LAST) GO TO 310
         STRING(L:L) = ' '
         STRING(R:R) = '0'
         IF (RESULT) STRING(R:R) = '1'
  300 ENDDO

  310 CONTINUE
      RETURN
      END

C=====================================================/COMPARE_INTEGER
 
      SUBROUTINE COMPARE_INTEGER( INT_FILE,  
     +                            INT_SPEC,  
     +                            COMP,      
     +                            RESULT )   

**********************************************************************
*                                                                    *
*   Compare input integer value with UAF file integer value.         *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      INTEGER     INT_FILE   ! Integer from UAF file.
      INTEGER     INT_SPEC   ! User-specified integer.
      CHARACTER*1 COMP       ! Comparison character (\, <, >,
                             !  or blank).
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL     RESULT     ! Result of comparison.
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      CHARACTER*20 CTEMP

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Set RESULT based on the input integers
                              !  and the comparison character.

      IF (COMP .EQ. '\') THEN
      
         RESULT = INT_FILE .NE. INT_SPEC

      ELSE IF (COMP .EQ. '>') THEN
 
         RESULT = INT_FILE .GT. INT_SPEC

      ELSE IF (COMP .EQ. '<') THEN
 
         RESULT = INT_FILE .LT. INT_SPEC
 
      ELSE
 
         RESULT = INT_FILE .EQ. INT_SPEC
 
      ENDIF

                              ! Save the data for output display.
 
      IF (REPORTSET .EQ. 'FULL') THEN
         THIS_BUFF = PARAM(MASTER_INDEX) // ': '
         WRITE (CTEMP, '(I20)') INT_FILE
         J = 1
         DO 100 I = 1, 20
            IF (CTEMP(I:I) .NE. ' ') THEN
               J = I
               GO TO 110
            ENDIF
  100    ENDDO
  110    THIS_BUFF(15:15+20-J) = CTEMP(J:20)
C        WRITE (THIS_BUFF(15:24), '(I10)') INT_FILE
      ENDIF
 
      RETURN
      END
C========================================================/COMPARE_DATE

      SUBROUTINE COMPARE_DATE( IDATE_FILE,  
     +                         CDATE_SPEC,  
     +                         COMP,        
     +                         DELTA,
     +                         RESULT )     

**********************************************************************
*                                                                    *
*   Compare input date value with UAF file date value.               *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      INTEGER      IDATE_FILE(2)   ! Quadword date from UAF file.
      CHARACTER*64 CDATE_SPEC      ! User-specified character date.
      CHARACTER*1  COMP            ! Comparison character (\, <, >,
                                   !  or blank).
      LOGICAL      DELTA           ! Absolute or delta time.
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL      RESULT          ! Result of comparison.
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      INTEGER IDATE_SPEC(2,MAX_PARAMS)

      LOGICAL BJTEST

      INTEGER SYS$BINTIM
      INTEGER SYS$ASCTIM

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Compute the binary date for this input
                              !  parameter, if necessary.

      INDEX_DATE_CHECK = INDEX_DATE_CHECK + 1
      II = INDEX_DATE_CHECK
      IF (.NOT. RESET_DATE_CHECK) GO TO 50

                              ! Convert the character date to binary.

      ISTATUS = SYS$BINTIM( CDATE_SPEC, IDATE_SPEC(1,II) )
      IF (.NOT. ISTATUS) THEN
         CALL ERROR_MESSAGE(ISTATUS)
         VALID_INPUT = .FALSE.
         GO TO 900
      ENDIF

                              ! Do a bit by bit comparison of the binary
                              !  to see which value is later.

   50 INT_FILE = 0
      INT_SPEC = 0                              

      DO 100 I = 62, 0, -1

         ISUB = ( I / 32 ) + 1
         IPOS = MOD( I, 32 )

         IF      (       BJTEST( IDATE_FILE(ISUB),    IPOS ) .AND.
     +             .NOT. BJTEST( IDATE_SPEC(ISUB,II), IPOS ) ) THEN
 
            INT_FILE = 1     ! UAF date is later (absolute), or
            GO TO 110        ! User-specified date is later (delta).
 
         ELSE IF ( .NOT. BJTEST( IDATE_FILE(ISUB),    IPOS ) .AND.
     +                   BJTEST( IDATE_SPEC(ISUB,II), IPOS ) ) THEN

            INT_SPEC = 1     ! User-specified date is later (absolute), or
            GO TO 110        ! UAF date is later (delta).
 
         ENDIF
 
  100 ENDDO
 
  110 CONTINUE

                              ! Set RESULT based on INT_FILE, INT_SPEC,
                              !  and the comparison character COMP.

      IF (COMP .EQ. '\') THEN
      
         RESULT = INT_FILE .NE. INT_SPEC

      ELSE IF (COMP .EQ. '>') THEN
 
         IF (DELTA) THEN
            RESULT = INT_FILE .LT. INT_SPEC
         ELSE
            RESULT = INT_FILE .GT. INT_SPEC
         ENDIF

      ELSE IF (COMP .EQ. '<') THEN
 
         IF (DELTA) THEN
            RESULT = INT_FILE .GT. INT_SPEC              
         ELSE
            RESULT = INT_FILE .LT. INT_SPEC
         ENDIF
 
      ELSE
 
         RESULT = INT_FILE .EQ. INT_SPEC
 
      ENDIF

                              ! Save the data for output display.

      IF (REPORTSET .EQ. 'FULL') THEN
         THIS_BUFF = PARAM(MASTER_INDEX) // ': '
         IF (IDATE_FILE(1) .EQ. 0 .AND. IDATE_FILE(2) .EQ. 0) THEN
            THIS_BUFF(15:40) = '(None)'
         ELSE
            ISTATUS = SYS$ASCTIM( , THIS_BUFF(15:40), IDATE_FILE, )
            IF (.NOT. ISTATUS) THIS_BUFF(15:40) = '???'
         ENDIF
      ENDIF
 
  900 RETURN
      END
C======================================================/COMPARE_STRING

      SUBROUTINE COMPARE_STRING( STRING_FILE,
     +                           STRING_SPEC, 
     +                           COMP,        
     +                           COUNTED,
     +                           RESULT )     

**********************************************************************
*                                                                    *
*   Compare input string value with UAF file string value.           *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) STRING_FILE  ! String from UAF file.
      CHARACTER*64  STRING_SPEC  ! User-specified string.
      CHARACTER*1   COMP         ! Comparison character (\, <, >,
                                 !  or blank).
      LOGICAL       COUNTED      ! Counted string or not.
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL       RESULT       ! Result of comparison.
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      CHARACTER*1 CHAR_COUNT
      BYTE BYTE_COUNT
      EQUIVALENCE (CHAR_COUNT,BYTE_COUNT)

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! If this is a counted string, then
                              !  eliminate the count byte.

      IF (COUNTED) THEN
         CHAR_COUNT = STRING_FILE(1:1)
         IF (BYTE_COUNT .LE. 0) THEN
            STRING_FILE = ' '
         ELSE
            STRING_FILE = STRING_FILE(2:BYTE_COUNT+1) // ' '
         ENDIF
      ENDIF

                              ! Set RESULT based on the input data and the
                              !  comparison character.

      IF (COMP .EQ. '\') THEN
      
         RESULT = STRING_FILE .NE. STRING_SPEC

      ELSE IF (COMP .EQ. '>') THEN
 
         RESULT = STRING_FILE .GT. STRING_SPEC

      ELSE IF (COMP .EQ. '<') THEN
 
         RESULT = STRING_FILE .LT. STRING_SPEC
 
      ELSE
 
         RESULT = STRING_FILE .EQ. STRING_SPEC
 
      ENDIF

                              ! Save the data for output display.

      IF (REPORTSET .EQ. 'FULL') THEN
         THIS_BUFF = PARAM(MASTER_INDEX) // ': ' // STRING_FILE
      ENDIF
 
      RETURN
      END
C==========================================================/PRIV_CHECK

      SUBROUTINE PRIV_CHECK( MASK,      
     +                       PTEST,     
     +                       COMP,      
     +                       RESULT)    

**********************************************************************
*                                                                    *
*   Compare input privledge value with UAF privledge mask.           *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      INTEGER      MASK(2)    ! Quadword priv mask from UAF file.
      CHARACTER*64 PTEST      ! Privledge being tested for.
      CHARACTER*1  COMP       ! Comparison character.
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL      RESULT     ! Result of comparison.
*                                                                    *
**********************************************************************

      INCLUDE '($PRVDEF)'
      INCLUDE 'SCANUAF.INC'
                          
      INTEGER       JIBSET
      LOGICAL       BJTEST

      PARAMETER     NUM_PRIVS = 36

      CHARACTER*9   PRIV_LIST(NUM_PRIVS)

      CHARACTER*400 CHARPRIV

      INTEGER       ICHECK(2,MAX_PARAMS), INMASK(2,MAX_PARAMS)

      INTEGER       IPMIN(NUM_PRIVS)

      INTEGER       IPRIV_INDEX(NUM_PRIVS)

      DATA (PRIV_LIST(I), IPMIN(I), IPRIV_INDEX(I), I = 1, NUM_PRIVS) /
     +   'ALL      ' , 3 , 0              ,
     +   'ACNT     ' , 2 , PRV$V_ACNT     ,
     +   'ALLSPOOL ' , 4 , PRV$V_ALLSPOOL ,
     +   'ALTPRI   ' , 3 , PRV$V_ALTPRI   ,
     +   'BUGCHK   ' , 2 , PRV$V_BUGCHK   ,
     +   'BYPASS   ' , 2 , PRV$V_BYPASS   ,
     +   'CMEXEC   ' , 3 , PRV$V_CMEXEC   ,
     +   'CMKRNL   ' , 3 , PRV$V_CMKRNL   ,
     +   'DETACH   ' , 2 , PRV$V_DETACH   ,
     +   'DIAGNOSE ' , 2 , PRV$V_DIAGNOSE ,
     +   'EXQUOTA  ' , 1 , PRV$V_EXQUOTA  ,
     +   'GROUP    ' , 3 , PRV$V_GROUP    ,
     +   'GRPNAM   ' , 4 , PRV$V_GRPNAM   ,
     +   'GRPPRV   ' , 4 , PRV$V_GRPPRV   ,
     +   'LOG_IO   ' , 1 , PRV$V_LOG_IO   ,
     +   'MOUNT    ' , 1 , PRV$V_MOUNT    ,
     +   'NETMBX   ' , 1 , PRV$V_NETMBX   ,
     +   'OPER     ' , 1 , PRV$V_OPER     ,
     +   'PFNMAP   ' , 2 , PRV$V_PFNMAP   ,
     +   'PHY_IO   ' , 2 , PRV$V_PHY_IO   ,
     +   'PRMCEB   ' , 4 , PRV$V_PRMCEB   ,
     +   'PRMGBL   ' , 4 , PRV$V_PRMGBL   ,
     +   'PRMMBX   ' , 4 , PRV$V_PRMMBX   ,
     +   'PSWAPM   ' , 2 , PRV$V_PSWAPM   ,
     +   'READALL  ' , 1 , PRV$V_READALL  ,
     +   'SECURITY ' , 3 , PRV$V_SECURITY ,
     +   'SETPRV   ' , 3 , PRV$V_SETPRV   ,
     +   'SHARE    ' , 3 , PRV$V_SHARE    ,
     +   'SHMEM    ' , 3 , PRV$V_SHMEM    ,
     +   'SYSGBL   ' , 4 , PRV$V_SYSGBL   ,
     +   'SYSLCK   ' , 4 , PRV$V_SYSLCK   ,
     +   'SYSNAM   ' , 4 , PRV$V_SYSNAM   ,
     +   'SYSPRV   ' , 4 , PRV$V_SYSPRV   ,
     +   'TMPMBX   ' , 1 , PRV$V_TMPMBX   ,
     +   'VOLPRO   ' , 1 , PRV$V_VOLPRO   ,
     +   'WORLD    ' , 1 , PRV$V_WORLD    /

CCC     +   'SETPRI   ' , ? , PRV$V_SETPRI    ,
CCC     +   'UPGRADE  ' , 1 , PRV$V_UPGRADE   ,
CCC     +   'DOWNGRADE' , 2 , PRV$V_DOWNGRADE ,
CCC     +   'TMPJNL   ' , ? , PRV$V_TMPJNL    ,
CCC     +   'PRMJNL   ' , 4 , PRV$V_PRMJNL    ,
               
*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Compute the mask for the input parameter,
                              !  if necessary.

      INDEX_PRIV_CHECK = INDEX_PRIV_CHECK + 1
      II = INDEX_PRIV_CHECK
      IF (.NOT. RESET_PRIV_CHECK) GO TO 300

      MARK = 1
      ICHECK(1,II) = 0    ! ICHECK tells which bits are to be checked.
      ICHECK(2,II) = 0                        
      INMASK(1,II) = 0    ! INMASK is the privilege mask for the input
      INMASK(2,II) = 0    !  parameter.

      DO 260 WHILE (.TRUE.)     
       
                              ! Find the next privilege in the input spec.

         DO 100 I = MARK, 64
            IF (PTEST(I:I) .EQ. ' ' .OR.
     +          PTEST(I:I) .EQ. ',' .OR.
     +          PTEST(I:I) .EQ. '(' .OR.
     +          PTEST(I:I) .EQ. ')' ) GO TO 100
            ILO = I
            GO TO 120
  100    ENDDO
               
         GO TO 270
 
  120    DO 140 I = ILO, 64
            IHI = I - 1
            IF (PTEST(I:I) .EQ. ' ' .OR.
     +          PTEST(I:I) .EQ. ',' .OR.
     +          PTEST(I:I) .EQ. '(' .OR.
     +          PTEST(I:I) .EQ. ')' ) GO TO 160
  140    ENDDO
 
         IHI = IHI + 1
       
  160    LEN = IHI - ILO + 1
                                  
         ISWITCH = 1           ! See if the privilege is preceded by NO.
         IF (LEN .GE. 2) THEN
            IF (PTEST(ILO:ILO+1) .EQ. 'NO') THEN
               ISWITCH = 0
               ILO = ILO + 2
               LEN = LEN - 2
            ENDIF
         ENDIF

         IF (LEN .LE. 0) GO TO 250      ! Privilege spec is too short.
         IF (LEN. GT. 9) GO TO 280      ! Privilege spec is too long.
   
         IALL = 0                       ! Check for ALL.
         IF (LEN .GE. IPMIN(1)) THEN
            IF (PTEST(ILO:IHI) .EQ. PRIV_LIST(1)(1:LEN)) IALL = 1
         ENDIF

         DO 200 I = 2, NUM_PRIVS        ! Build ICHECK and INMASK.
            IF (IALL .EQ. 1) GO TO 180

            IF (LEN .LT. IPMIN(I)) GO TO 200
            IF (PTEST(ILO:IHI) .NE. PRIV_LIST(I)(1:LEN)) GO TO 200

  180       INDEX = IPRIV_INDEX(I)

            ISUB = ( INDEX / 32 ) + 1
            IPOS = MOD( INDEX, 32 )

            ICHECK(ISUB,II) = JIBSET(ICHECK(ISUB,II),IPOS)
            IF (ISWITCH .EQ. 1) INMASK(ISUB,II) = JIBSET(INMASK(ISUB,II),IPOS)

            IF (IALL .EQ. 0) GO TO 250
  200    ENDDO
         IF (IALL .EQ. 0) GO TO 280

  250    MARK = IHI + 1
         IF (MARK .GT. 64) GO TO 270

  260 ENDDO

                              ! Verify that there is something to check.

  270 IF (ICHECK(1,II) .NE. 0 .OR. ICHECK(2,II) .NE. 0) GO TO 300

  280 TYPE *, ' '
      TYPE *, 'Invalid privilege specification - ',
     +        PTEST(1:ISTRING_LAST(PTEST))
      VALID_INPUT = .FALSE.
      GO TO 900
    
  300 RESULT = .FALSE.        ! Compare the privilege masks.
      DO I = 2, NUM_PRIVS
         ISUB = ( IPRIV_INDEX(I) / 32 ) + 1
         IPOS = MOD( IPRIV_INDEX(I), 32 )
         IF (BJTEST(ICHECK(ISUB,II),IPOS)) THEN
            IF (COMP .EQ. '=') THEN
               RESULT = BJTEST(INMASK(ISUB,II),IPOS) .EQ. 
     +                  BJTEST(MASK(ISUB),IPOS)
               IF (.NOT. RESULT) GO TO 400
            ELSE
               RESULT = BJTEST(INMASK(ISUB,II),IPOS) .NE. 
     +                  BJTEST(MASK(ISUB),IPOS)
               IF (RESULT) GO TO 400
            ENDIF
         ENDIF
      ENDDO

  400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900
      CHARPRIV = 'X'            ! Build the output string.
      DO 500 I = 2, NUM_PRIVS
         ISUB = ( IPRIV_INDEX(I) / 32 ) + 1
         IPOS = MOD( IPRIV_INDEX(I), 32 )
         IF (BJTEST(MASK(ISUB),IPOS)) THEN
            LL = ISTRING_LAST(CHARPRIV)
            CHARPRIV = CHARPRIV(1:LL) // ' ' // PRIV_LIST(I)
         ENDIF
  500 ENDDO
      IF (CHARPRIV .EQ. 'X') CHARPRIV = '  (None)'

      THIS_BUFF = PARAM(MASTER_INDEX) //
     +            ':' // CHARPRIV(2:ISTRING_LAST(CHARPRIV))
               
  900 RETURN
      END                                              
C==========================================================/FLAG_CHECK

      SUBROUTINE FLAG_CHECK( MASK,      
     +                       FTEST,     
     +                       COMP,      
     +                       RESULT)    

**********************************************************************
*                                                                    *
*   Compare input flag value with UAF flag mask.                     *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      INTEGER      MASK       ! Integer flag mask from UAF file.
      CHARACTER*64 FTEST      ! Flag being tested for.
      CHARACTER*1  COMP       ! Comparison character.
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL      RESULT     ! Result of comparison.
*                                                                    *
**********************************************************************

      INCLUDE '($UAIDEF)'
      INCLUDE 'SCANUAF.INC'
                          
      INTEGER       JIBSET
      LOGICAL       BJTEST

      PARAMETER     NUM_FLAGS = 25			! ROHWEDDER

      CHARACTER*20  FLAG_LIST(NUM_FLAGS)

      CHARACTER*420 CHARFLAG

      INTEGER       ICHECK(MAX_PARAMS), INMASK(MAX_PARAMS)

      INTEGER       IFMIN(NUM_FLAGS)

      INTEGER       IFLAG_INDEX(NUM_FLAGS)
                                        
      DATA (FLAG_LIST(I), IFMIN(I), IFLAG_INDEX(I), I = 1, NUM_FLAGS) /
     +   'ALL                 ' , 2 ,  0                         , 
     +   'DISCTLY             ' , 4 ,  UAI$V_DISCTLY             , 
     +   'DEFCLI              ' , 2 ,  UAI$V_DEFCLI              , 
     +   'LOCKPWD             ' , 1 ,  UAI$V_LOCKPWD             , 
     +   'RESTRICTED          ' , 1 ,  UAI$V_RESTRICTED          ,
     +   'DISUSER             ' , 4 ,  UAI$V_DISACNT             , 
     +   'DISWELCOME          ' , 4 ,  UAI$V_DISWELCOM           , 
     +   'DISMAIL             ' , 4 ,  UAI$V_DISMAIL             , 
     +   'DISNEWMAIL          ' , 4 ,  UAI$V_NOMAIL              , 
     +   'GENPWD              ' , 1 ,  UAI$V_GENPWD              , 
     +   'PWD_EXPIRED         ' , 4 ,  UAI$V_PWD_EXPIRED         , 
     +   'PWD2_EXPIRED        ' , 4 ,  UAI$V_PWD2_EXPIRED        , 
     +   'AUDIT               ' , 3 ,  UAI$V_AUDIT               , 
     +   'DISREPORT           ' , 6 ,  UAI$V_DISREPORT           , 
     +   'DISRECONNECT        ' , 6 ,  UAI$V_DISRECONNECT        , 
     +   'AUTOLOGIN           ' , 3 ,  UAI$V_AUTOLOGIN           , 
     +   'DISFORCE_PWD_CHANGE ' , 4 ,  UAI$V_DISFORCE_PWD_CHANGE ,  
     +   'CAPTIVE             ' , 1 ,  UAI$V_CAPTIVE             ,
     +   'DISIMAGE            ' , 4 ,  UAI$V_DISIMAGE            , 
     +   'DISPWDDIC           ' , 7 ,  UAI$V_DISPWDDIC           , 
     +   'EXTAUTH             ' , 2 ,  UAI$V_EXTAUTH             , 	! ROHWEDDER
     +   'PWDMIX              ' , 5 ,  25                        , 	! hardcoded, is missing in UAIDEF
     +   'DISPWDSYNCH         ' , 7 ,  UAI$V_DISPWDSYNCH         , 	! ROHWEDDER
     +   'VMSAUTH             ' , 2 ,  UAI$V_VMSAUTH             , 	! ROHWEDDER
     +   'DISPWDHIS           ' , 7 ,  19           /			! hardcoded, is missing in UAIDEF

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*
      
                              ! Compute the mask for the input parameter,
                              !  if necessary.

      INDEX_FLAG_CHECK = INDEX_FLAG_CHECK + 1
      II = INDEX_FLAG_CHECK
      IF (.NOT. RESET_FLAG_CHECK) GO TO 300

      MARK = 1
      ICHECK(II) = 0    ! ICHECK tells which bits are to be checked.
      INMASK(II) = 0    ! INMASK is the flag mask for the input parameter.

      DO 260 WHILE (.TRUE.)

                              ! Find the next flag in the input spec.

         DO 100 I = MARK, 64
            IF (FTEST(I:I) .EQ. ' ' .OR.
     +          FTEST(I:I) .EQ. ',' .OR.
     +          FTEST(I:I) .EQ. '(' .OR.
     +          FTEST(I:I) .EQ. ')' ) GO TO 100
            ILO = I
            GO TO 120
  100    ENDDO

         GO TO 270

  120    DO 140 I = ILO, 64
            IHI = I - 1
            IF (FTEST(I:I) .EQ. ' ' .OR.
     +          FTEST(I:I) .EQ. ',' .OR.
     +          FTEST(I:I) .EQ. '(' .OR.
     +          FTEST(I:I) .EQ. ')' ) GO TO 160
  140    ENDDO

         IHI = IHI + 1

  160    LEN = IHI - ILO + 1

         ISWITCH = 1           ! See if the flag is preceded by NO.
         IF (LEN .GE. 2) THEN
            IF (FTEST(ILO:ILO+1) .EQ. 'NO') THEN
               ISWITCH = 0
               ILO = ILO + 2
               LEN = LEN - 2
            ENDIF
         ENDIF

         IF (LEN .LE. 0)  GO TO 250     ! Flag spec is too short.
         IF (LEN. GT. 12) GO TO 280     ! Flag spec is too long.
   
         IALL = 0                       ! Check for ALL.
         IF (LEN .GE. IFMIN(1)) THEN
            IF (FTEST(ILO:IHI) .EQ. FLAG_LIST(1)(1:LEN)) IALL = 1
         ENDIF

         DO 200 I = 2, NUM_FLAGS        ! Build ICHECK and INMASK.
            IF (IALL .EQ. 1) GO TO 180

            IF (LEN .LT. IFMIN(I)) GO TO 200
            IF (FTEST(ILO:IHI) .NE. FLAG_LIST(I)(1:LEN)) GO TO 200

  180       INDEX = IFLAG_INDEX(I)

            ICHECK(II) = JIBSET(ICHECK(II),INDEX)      
            IF (ISWITCH .EQ. 1) INMASK(II) = JIBSET(INMASK(II),INDEX)

            IF (IALL .EQ. 0) GO TO 250
  200    ENDDO
         IF (IALL .EQ. 0) GO TO 280

  250    MARK = IHI + 1
         IF (MARK .GT. 64) GO TO 270

  260 ENDDO

                              ! Verify that there is something to check.

  270 IF (ICHECK(II) .NE. 0) GO TO 300

  280 TYPE *, ' '
      TYPE *, 'Invalid flag specification - ',
     +        FTEST(1:ISTRING_LAST(FTEST))
      VALID_INPUT = .FALSE.
      GO TO 900                                  

  300 RESULT = .FALSE.        ! Compare the flag masks.
      DO I = 2, NUM_FLAGS
         IPOS = IFLAG_INDEX(I)
         IF (BJTEST(ICHECK(II),IPOS)) THEN
            IF (COMP .EQ. '=') THEN
               RESULT = BJTEST(INMASK(II),IPOS) .EQ. BJTEST(MASK,IPOS)
               IF (.NOT. RESULT) GO TO 400
            ELSE
               RESULT = BJTEST(INMASK(II),IPOS) .NE. BJTEST(MASK,IPOS)
               IF (RESULT) GO TO 400
            ENDIF
         ENDIF                                           
      ENDDO

  400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900
      CHARFLAG = 'X'          ! Build the output string.
      DO 500 I = 2, NUM_FLAGS
         IPOS = IFLAG_INDEX(I)
         IF (BJTEST(MASK,IPOS)) THEN
            LL = ISTRING_LAST(CHARFLAG)
            CHARFLAG = CHARFLAG(1:LL) // ' ' // FLAG_LIST(I)
         ENDIF
  500 ENDDO
      IF (CHARFLAG .EQ. 'X') CHARFLAG = '  (None)'

      THIS_BUFF = PARAM(MASTER_INDEX) //
     +            ':' // CHARFLAG(2:ISTRING_LAST(CHARFLAG))

  900 RETURN
      END
C==========================================================/HOUR_CHECK

      SUBROUTINE HOUR_CHECK( BMASK,     
     +                       HTEST,     
     +                       COMP,      
     +                       RESULT)    

**********************************************************************
*                                                                    *
*   Compare input hour value with UAF hour mask.                     *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      BYTE         BMASK(3)   ! Byte flag mask from UAF file.
      CHARACTER*64 HTEST      ! Hour being tested for.
      CHARACTER*1  COMP       ! Comparison character.
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL      RESULT     ! Result of comparison.
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'
                                        
      INTEGER       ICHECK(MAX_PARAMS), INMASK(MAX_PARAMS)

      CHARACTER*72  CHARHOUR

      CHARACTER*4   FORM / '(I_)' /
                                    
      INTEGER       JIBSET, JIAND, JISHFT
      LOGICAL       BJTEST
      
      INTEGER       LIB$GET_INPUT
      INTEGER       STR$POSITION

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Compute the mask for the input parameter,
                              !  if necessary.

      INDEX_HOUR_CHECK = INDEX_HOUR_CHECK + 1
      II = INDEX_HOUR_CHECK
      IF (.NOT. RESET_HOUR_CHECK) GO TO 300

      MARK = 1
      ICHECK(II) = 0    ! ICHECK tells which bits are to be checked.
      INMASK(II) = 0    ! INMASK is the hour mask for the input parameter.

      IF (HTEST .EQ. '()') THEN
         IF (COMP .EQ. '=' .OR. COMP .EQ. '\') ICHECK(II) = '00FFFFFF'X
         GO TO 270
      ENDIF

      DO 260 WHILE (.TRUE.) 

                              ! Find the next hour in the input spec.

         DO 100 I = MARK, 64
            IF (HTEST(I:I) .EQ. ' ' .OR.
     +          HTEST(I:I) .EQ. ',' .OR.
     +          HTEST(I:I) .EQ. '(' .OR.
     +          HTEST(I:I) .EQ. ')' ) GO TO 100
            ILO = I
            GO TO 120
  100    ENDDO
               
         GO TO 270
 
  120    DO 140 I = ILO, 64
            IHI = I - 1
            IF (HTEST(I:I) .EQ. ' ' .OR.
     +          HTEST(I:I) .EQ. ',' .OR.
     +          HTEST(I:I) .EQ. '(' .OR.
     +          HTEST(I:I) .EQ. ')' ) GO TO 160
  140    ENDDO
 
         IHI = IHI + 1
       
  160    LEN = IHI - ILO + 1

         IF (LEN .LE. 0) GO TO 250   ! Hour spec is too short.
         IF (LEN. GT. 5) GO TO 280   ! Hour spec is too long.

                              ! Parse the hour spec.

         IF (LEN .LE. 2) THEN
            WRITE (FORM(3:3), '(I1)') LEN
            READ (HTEST(ILO:IHI), FORM, ERR=280) IHOUR_LO
            IHOUR_HI = IHOUR_LO
         ELSE
            IDASH = STR$POSITION(HTEST(ILO:IHI),'-')
            IF (IDASH .LE. 1 .OR. IDASH .GE. LEN) GO TO 280
            JDASH = IDASH - 1
            WRITE (FORM(3:3), '(I1)') JDASH
            READ (HTEST(ILO:ILO+JDASH-1), FORM, ERR=280) IHOUR_LO
            JDASH = LEN - IDASH
            WRITE (FORM(3:3), '(I1)') JDASH
            READ (HTEST(ILO+IDASH:IHI), FORM, ERR=280) IHOUR_HI
         ENDIF

         IF (IHOUR_LO .LT. 0 .OR. IHOUR_HI .GT. 23) GO TO 280
         IF (IHOUR_LO .GT. IHOUR_HI) GO TO 280
            
         DO 200 I = IHOUR_LO, IHOUR_HI        ! Build ICHECK and INMASK.
            ICHECK(II) = JIBSET(ICHECK(II),I)
            INMASK(II) = JIBSET(INMASK(II),I)
  200    ENDDO

  250    MARK = IHI + 1
         IF (MARK .GT. 64) GO TO 270

  260 ENDDO

                              ! Verify that there is something to check.

  270 IF (ICHECK(II) .NE. 0) GO TO 300

  280 TYPE *, ' '
      TYPE *, 'Invalid hour specification - ',
     +        HTEST(1:ISTRING_LAST(HTEST))
      VALID_INPUT = .FALSE.
      GO TO 900
    
  300 RESULT = .FALSE.

                              ! Compare the hour masks.

      MASK1 = BMASK(1)
      MASK1 = JIAND(MASK1,'000000FF'X)

      MASK2 = BMASK(2)
      MASK2 = JIAND(MASK2,'000000FF'X)
      MASK2 = JISHFT(MASK2,8)

      MASK3 = BMASK(3)
      MASK3 = JIAND(MASK3,'000000FF'X)
      MASK3 = JISHFT(MASK3,16)

      MASK = MASK1 + MASK2 + MASK3
                                         
      IF (COMP .EQ. '<') THEN
         MARK = 24
         DO IPOS = 0, 23
            IF (BJTEST(INMASK(II),IPOS)) THEN
               MARK = IPOS
               GO TO 320
            ENDIF
         ENDDO
  320    DO IPOS = 0, 23
            IF (.NOT. BJTEST(MASK,IPOS)) THEN
               IF (IPOS .LT. MARK) RESULT = .TRUE.
               GO TO 400
            ENDIF
         ENDDO
         GO TO 400
      ENDIF

      IF (COMP .EQ. '>') THEN
         MARK = -1
         DO IPOS = 23, 0, -1
            IF (BJTEST(INMASK(II),IPOS)) THEN
               MARK = IPOS
               GO TO 340
            ENDIF
         ENDDO
  340    DO IPOS = 23, 0, -1
            IF (.NOT. BJTEST(MASK,IPOS)) THEN
               IF (IPOS .GT. MARK) RESULT = .TRUE.
               GO TO 400
            ENDIF
         ENDDO
         GO TO 400
      ENDIF      

      DO IPOS = 0, 23
         IF (BJTEST(ICHECK(II),IPOS)) THEN
            IF (COMP .EQ. '=') THEN
               RESULT = BJTEST(INMASK(II),IPOS) .NE. BJTEST(MASK,IPOS)
               IF (.NOT. RESULT) GO TO 400
            ELSE
               RESULT = BJTEST(INMASK(II),IPOS) .EQ. BJTEST(MASK,IPOS)
               IF (RESULT) GO TO 400
            ENDIF
         ENDIF
      ENDDO

  400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900
      IF (MASK .EQ. 0) THEN                 ! Build the output string.
         CHARHOUR = '(Full access)'
      ELSE IF (MASK .EQ. '00FFFFFF'X) THEN
         CHARHOUR = '(No access)'
      ELSE
         CHARHOUR = ' '
         DO 500 IPOS = 0, 23
            IF (BJTEST(MASK,IPOS)) GO TO 500
            LL = ISTRING_LAST(CHARHOUR)
            WRITE (CHARHOUR(LL+2:LL+3), '(I2)') IPOS
  500    ENDDO
      ENDIF

      THIS_BUFF = PARAM(MASTER_INDEX) // ': ' // CHARHOUR

  900 RETURN
      END
C===========================================================/DAY_CHECK
                           
      SUBROUTINE DAY_CHECK( BMASK,      
     +                      DTEST,     
     +                      COMP,      
     +                      RESULT)    

**********************************************************************
*                                                                    *
*   Compare input day value with UAF day mask.                       *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      BYTE         BMASK      ! Byte day mask from UAF file.
      CHARACTER*64 DTEST      ! Day being tested for.
      CHARACTER*1  COMP       ! Comparison character.
*                                                                    *
*   OUTPUT ARGUMENTS                                                 *
*   ----------------                                                 *
      LOGICAL      RESULT     ! Result of comparison.
*                                                                    *
**********************************************************************
                                   
      INCLUDE '($UAIDEF)'
      INCLUDE 'SCANUAF.INC'
                          
      INTEGER       JIBSET
      LOGICAL       BJTEST

      PARAMETER     NUM_DAYS = 8

      CHARACTER*9   DAY_LIST(NUM_DAYS)
                  
      CHARACTER*100 CHARDAY

      INTEGER       ICHECK(MAX_PARAMS), INMASK(MAX_PARAMS)
                         
      INTEGER       IDMIN(NUM_DAYS)

      INTEGER       IDAY_INDEX(NUM_DAYS)
                                        
      DATA (DAY_LIST(I), IDMIN(I), IDAY_INDEX(I), I = 1, NUM_DAYS) /
     +   'ALL      ' , 1,  0 ,
     +   'MONDAY   ' , 1 , UAI$V_MONDAY    ,
     +   'TUESDAY  ' , 2 , UAI$V_TUESDAY   ,
     +   'WEDNESDAY' , 1 , UAI$V_WEDNESDAY ,
     +   'THURSDAY ' , 2 , UAI$V_THURSDAY  ,
     +   'FRIDAY   ' , 1 , UAI$V_FRIDAY    ,
     +   'SATURDAY ' , 2 , UAI$V_SATURDAY  ,
     +   'SUNDAY   ' , 2 , UAI$V_SUNDAY    /
               
*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Compute the mask for the input parameter,
                              !  if necessary.

      INDEX_DAY_CHECK = INDEX_DAY_CHECK + 1
      II = INDEX_DAY_CHECK
      IF (.NOT. RESET_DAY_CHECK) GO TO 300

      MARK = 1
      ICHECK(II) = 0     ! ICHECK tells which bits are to be checked.
      INMASK(II) = 0     ! INMASK is the day mask for the input parameter.

      DO 260 WHILE (.TRUE.)

                              ! Find the next day in the input spec.
      
         DO 100 I = MARK, 64
            IF (DTEST(I:I) .EQ. ' ' .OR.
     +          DTEST(I:I) .EQ. ',' .OR.
     +          DTEST(I:I) .EQ. '(' .OR.
     +          DTEST(I:I) .EQ. ')' ) GO TO 100
            ILO = I
            GO TO 120
  100    ENDDO
 
         GO TO 270
 
  120    DO 140 I = ILO, 64
            IHI = I - 1
            IF (DTEST(I:I) .EQ. ' ' .OR.
     +          DTEST(I:I) .EQ. ',' .OR.
     +          DTEST(I:I) .EQ. '(' .OR.
     +          DTEST(I:I) .EQ. ')' ) GO TO 160
  140    ENDDO
 
         IHI = IHI + 1
       
  160    LEN = IHI - ILO + 1
                                
         ISWITCH = 1           ! See if the day is preceded by NO.
         IF (LEN .GE. 2) THEN
            IF (DTEST(ILO:ILO+1) .EQ. 'NO') THEN
               ISWITCH = 0
               ILO = ILO + 2
               LEN = LEN - 2                            
            ENDIF
         ENDIF

         IF (LEN .LE. 0) GO TO 250     ! Day spec is too short.
         IF (LEN. GT. 9) GO TO 280     ! Day spec is too long.
   
         IALL = 0                      ! Check for ALL.
         IF (LEN .GE. IDMIN(1)) THEN
            IF (DTEST(ILO:IHI) .EQ. DAY_LIST(1)(1:LEN)) IALL = 1
         ENDIF

         DO 200 I = 2, NUM_DAYS        ! Build ICHECK and INMASK.
            IF (IALL .EQ. 1) GO TO 180

            IF (LEN .LT. IDMIN(I)) GO TO 200
            IF (DTEST(ILO:IHI) .NE. DAY_LIST(I)(1:LEN)) GO TO 200

  180       INDEX = IDAY_INDEX(I)

            ICHECK(II) = JIBSET(ICHECK(II),INDEX)
            IF (ISWITCH .EQ. 1) INMASK(II) = JIBSET(INMASK(II),INDEX)

            IF (IALL .EQ. 0) GO TO 250
  200    ENDDO
         IF (IALL .EQ. 0) GO TO 280

  250    MARK = IHI + 1
         IF (MARK .GT. 64) GO TO 270

  260 ENDDO

                              ! Verify that there is something to check.

  270 IF (ICHECK(II) .NE. 0) GO TO 300

  280 TYPE *, ' '
      TYPE *, 'Invalid day specification - ',
     +        DTEST(1:ISTRING_LAST(DTEST))
      VALID_INPUT = .FALSE.
      GO TO 900

  300 RESULT = .FALSE.        ! Compare the day masks.
      MASK = BMASK   
      DO I = 2, NUM_DAYS
         IPOS = IDAY_INDEX(I)
         IF (BJTEST(ICHECK(II),IPOS)) THEN
            IF (COMP .EQ. '=') THEN
               RESULT = BJTEST(INMASK(II),IPOS) .NE. BJTEST(MASK,IPOS)
               IF (.NOT. RESULT) GO TO 400
            ELSE
               RESULT = BJTEST(INMASK(II),IPOS) .EQ. BJTEST(MASK,IPOS)
               IF (RESULT) GO TO 400
            ENDIF
         ENDIF
      ENDDO

  400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900
      CHARDAY = 'X'           ! Build the output string.
      DO 500 I = 2, NUM_DAYS
         IPOS = IDAY_INDEX(I)
         IF (.NOT. BJTEST(MASK,IPOS)) THEN
            LL = ISTRING_LAST(CHARDAY)
            CHARDAY = CHARDAY(1:LL) // ' ' // DAY_LIST(I)
         ENDIF
  500 ENDDO
      IF (CHARDAY .EQ. 'X') CHARDAY = '  (None)'

      THIS_BUFF = PARAM(MASTER_INDEX) //
     +            ':' // CHARDAY(2:ISTRING_LAST(CHARDAY))

  900 RETURN
      END
C==========================================================/AST_ENABLE

      SUBROUTINE AST_ENABLE

**********************************************************************
*                                                                    *
*   This subroutine queues an I/O request for trapping a ^C entry.   *
*                                                                    *
**********************************************************************

      INCLUDE '($IODEF)'                ! Symbols for I/O operations

      EXTERNAL AST_HANDLER              ! AST handler subroutine

      INTEGER*2 ICHAN

      INTEGER SYS$ASSIGN,
     +        SYS$QIOW

      LOGICAL FIRST  / .TRUE. /
 
      STRUCTURE /IOSTAT_BLOCK/          ! Structure for IOSB
                 INTEGER*2 IOSTAT
                 BYTE      TRANSMIT,
     +                     RECEIVE,
     +                     CRFILL,
     +                     LFFILL,
     +                     PARITY,
     +                     ZERO
      END STRUCTURE

      RECORD /IOSTAT_BLOCK/ IOSB

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                                ! If this is the first call, then assign
                                !  the I/O channel.

      IF (FIRST) THEN
         FIRST = .FALSE.
         ISTATUS = SYS$ASSIGN( 'SYS$INPUT', ICHAN, , )
         IF (.NOT. ISTATUS) THEN
            TYPE *, 'SYS$ASSIGN error ', ISTATUS, ' - ^C Disabled'
            GO TO 900
         ENDIF
      ENDIF

      ICODE = IO$_SETMODE .OR. IO$M_CTRLCAST    ! QIO code.

                                ! Queue the I/O request.

      ISTATUS = SYS$QIOW( ,
     +                    %VAL(ICHAN),
     +                    %VAL(ICODE),
     +                    IOSB,
     +                    , ,
     +                    AST_HANDLER,
     +                    ,
     +                    , , , )

                                ! If the request didn't work, then close
                                !  the show.

      IF (.NOT. ISTATUS) THEN
         TYPE *, 'SYS$QIO error ', ISTATUS, ' - ^C Disabled'
         GO TO 900
      ENDIF

      IF (.NOT. IOSB.IOSTAT) THEN
         TYPE *, 'SYS$QIO IOSB error ', IOSB.IOSTAT, ' - ^C Disabled'
         GO TO 900
      ENDIF

  900 RETURN
      END
C=========================================================/AST_HANDLER

      SUBROUTINE AST_HANDLER

**********************************************************************
*                                                                    *
*   This subroutine is used to handle a ^C interrupt (AST).          *
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      CHARACTER*1 CHAR

      INTEGER LIB$GET_INPUT

*-------------------------*
*     EXECUTABLE CODE     *
*-------------------------*

                              ! Set the flag for a ^C interrupt, according
                              !  to what the user wants to do.
      
  100 ISTATUS = LIB$GET_INPUT( CHAR, 'Enter 0 to continue, 1 to abort ' //
     +                       'this node, 2 to abort the entire search [2]: ')

                              ! If some error occurred in the read,
                              !  then abort the entire search.

      IF (.NOT. ISTATUS) THEN
         CALL ERROR_MESSAGE(ISTATUS)
         ICONTROL_C = 2
      ELSE IF (CHAR .EQ. '0') THEN                          
         ICONTROL_C = 0
      ELSE IF (CHAR .EQ. '1') THEN
         ICONTROL_C = 1
      ELSE IF (CHAR .EQ. '2' .OR. CHAR .EQ. ' ') THEN
         ICONTROL_C = 2
      ELSE
         GO TO 100
      ENDIF

                                ! Queue another I/O request for ^C handling.
                                !  (Once an interrupt has been handled, it
                                !  is no longer queued.)

      CALL AST_ENABLE

      RETURN
      END
C========================================================/ISTRING_LAST

      INTEGER FUNCTION ISTRING_LAST( STRING )

**********************************************************************
*                                                                    *
*   This function is used to find the position of the last           *
*   non-blank character in a character string.                       *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      CHARACTER*(*) STRING   ! String to be searched.
*                                                                    *
**********************************************************************

*---------------------*
*   EXECUTABLE CODE   *
*---------------------*

      L = LEN(STRING)

      ISTRING_LAST = 0

                                ! Find the last non-blank character.

      IF (L.GT.0) THEN
         DO I = L, 1, -1
            IF (STRING(I:I) .NE. ' ') THEN
               ISTRING_LAST = I
               GO TO 100
            ENDIF
         ENDDO
      ENDIF

  100 RETURN
      END
C=======================================================/ERROR_MESSAGE

      SUBROUTINE ERROR_MESSAGE( MESSAGE_DESCRIPTOR )

**********************************************************************
*                                                                    *
*   This subroutine is used to print error messages.                 *
*                                                                    *
*   INPUT ARGUMENTS                                                  *
*   ---------------                                                  *
      INTEGER MESSAGE_DESCRIPTOR      ! VAX/VMS error descriptor.
*                                                                    *
**********************************************************************

      INTEGER MSGVEC(2)

      INTEGER SYS$PUTMSG

*---------------------*
*   EXECUTABLE CODE   *
*---------------------*

                              ! Build the message vector.

      MSGVEC(1) = 1
      MSGVEC(2) = MESSAGE_DESCRIPTOR

      ISTATUS = SYS$PUTMSG( MSGVEC, , , )

      RETURN
      END
C==========================================================/BLOCK_DATA

      BLOCK DATA BLOCK_DATA

**********************************************************************
*                                                                    *
*   Block data to initialize common variables in 'SCANUAF.INC'.      *
*                                                                    *
**********************************************************************

      INCLUDE 'SCANUAF.INC'

      DATA (PARAM(I),       ISTAR(I), TYPE(I), COMPCHARS(I), I=1,MASTER) /
     +      'RTYPE       ',   2,       'I',       '=\<>',
     +      'VERSION     ',   1,       'I',       '=\<>',
     +      'USRDATOFF   ',   3,       'I',       '=\<>',
     +      'USERNAME    ',   3,       'C',       '=\<>',
     +      'MEMBER      ',   2,       'I',       '=\<>',
     +      'GROUP       ',   1,       'I',       '=\<>',
     +      'SUBID       ',   4,       'I',       '=\<>',
     +      'PARENTID    ',   3,       'C',       '=\<>',
     +      'ACCOUNT     ',   2,       'C',       '=\<>',
     +      'OWNER       ',   1,       'C',       '=\<>',
     +      'DEVICE      ',   3,       'C',       '=\<>',
     +      'DIRECTORY   ',   3,       'C',       '=\<>',
     +      'LGICMD      ',   2,       'C',       '=\<>',
     +      'CLI         ',   3,       'C',       '=\<>',
     +      'CLITABLES   ',   4,       'C',       '=\<>',
     +      'PASSWORD    ',   8,       'C',       '=\<>',
     +      'PASSWORD2   ',   9,       'C',       '=\<>',
     +      'LOGFAILS    ',   4,       'I',       '=\<>',
     +      'SALT        ',   2,       'I',       '=\<>',
     +      'ENCRYPT     ',   7,       'I',       '=\<>',
     +      'ENCRYPT2    ',   8,       'I',       '=\<>',
     +      'PWDMINIMUM  ',   4,       'I',       '=\<>',
     +      'EXPIRATION  ',   2,       'C',       '=\<>',
     +      'PWDLIFETIME ',   4,       'C',       '=\<>',
     +      'PWDDATE     ',   7,       'C',       '=\<>',
     +      'PWDDATE2    ',   8,       'C',       '=\<>',
     +      'LOGINT      ',   4,       'C',       '=\<>',
     +      'LOGNONINT   ',   4,       'C',       '=\<>',
     +      'PRIVILEGE   ',   4,       'C',       '=\',
     +      'DEFPRIVILEGE',   3,       'C',       '=\',
     +      'MINCLASS    ',   2,       'C',       '=\<>',
     +      'MAXCLASS    ',   4,       'C',       '=\<>',
     +      'FLAGS       ',   2,       'C',       '=\',
     +      'NETWORKPRIME',   8,       'C',       '=\<>',
     +      'NETWORKSEC  ',   8,       'C',       '=\<>',
     +      'BATCHPRIME  ',   6,       'C',       '=\<>',
     +      'BATCHSEC    ',   6,       'C',       '=\<>',
     +      'LOCALPRIME  ',   6,       'C',       '=\<>',
     +      'LOCALSEC    ',   6,       'C',       '=\<>',
     +      'DIALUPPRIME ',   7,       'C',       '=\<>',
     +      'DIALUPSEC   ',   7,       'C',       '=\<>',
     +      'REMOTEPRIME ',   7,       'C',       '=\<>',
     +      'REMOTESEC   ',   7,       'C',       '=\<>',
     +      'PRIMEDAYS   ',   4,       'C',       '=\',
     +      'PRIORITY    ',   4,       'I',       '=\<>',
     +      'QUEPRI      ',   1,       'I',       '=\<>',
     +      'MAXJOBS     ',   4,       'I',       '=\<>',
     +      'MAXACCTJOBS ',   4,       'I',       '=\<>',
     +      'MAXDETACH   ',   4,       'I',       '=\<>',
     +      'PRCLM       ',   3,       'I',       '=\<>',
     +      'BIOLM       ',   2,       'I',       '=\<>',
     +      'DIOLM       ',   3,       'I',       '=\<>',
     +      'TQELM       ',   1,       'I',       '=\<>',
     +      'ASTLM       ',   2,       'I',       '=\<>',
     +      'ENQLM       ',   3,       'I',       '=\<>',
     +      'FILLM       ',   2,       'I',       '=\<>',
     +      'SHRFILLM    ',   2,       'I',       '=\<>',
     +      'WSQUOTA     ',   3,       'I',       '=\<>',
     +      'WSDEFAULT   ',   3,       'I',       '=\<>',
     +      'WSEXTENT    ',   3,       'I',       '=\<>',
     +      'PGFLQUOTA   ',   2,       'I',       '=\<>',
     +      'CPUTIME     ',   2,       'I',       '=\<>',
     +      'BYTLM       ',   2,       'I',       '=\<>',
     +      'PBYTLM      ',   2,       'I',       '=\<>',
     +      'JTQUOTA     ',   1,       'I',       '=\<>',
     +      'PROXYLIM    ',   6,       'I',       '=\<>',
     +      'PROXYUSE    ',   6,       'I',       '=\<>',
     +      'SUBACCLIM   ',   7,       'I',       '=\<>',
     +      'SUBACCUSE   ',   7,       'I',       '=\<>'/

      DATA NODESET    / 'LOCAL'	/	      ! ROHWEDDER
      DATA REPORTSET  / 'BRIEF' /	      ! ROHWEDDER
      DATA OUTPUTSET  / 'SYS$OUTPUT' /
      DATA LUN        / 6 /

      END
