  r /*****************************************************************************************************************  -  Program :	QUOTA		Return a user's disk quotas   Module	:	QUOTA.C		(the root) %  Author	:	Nick de Smith	January, 1990 U 		Applied Telematics Services, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England.   J  Copyright (c) 1990 by Applied Telematics Group Limited and Nick de Smith.m  This software is supplied for information only. No guarantee is supplied for this software, and no liability m  will be accepted for any action resulting from the use of this software or the information contained herein. i  Under no circumstances may this software be used for commercial gain, including its sale, lease or loan. N  This software may be copied only with the inclusion of this copyright notice.f  The author is prepared to enter into correspondance with interested parties, but will not necessarily8  maintain this software. Having said all that, enjoy it!    Description :  I  Return the diskquota information for a user in DCL local string symbols:   % 	DISKQ_INUSE		Symbol for inuse blocks , 	DISKQ_PERMQUOTA		Symbol for permanent quota- 	DISKQ_OVERDRAFT		Symbol for overdraft blocks    Format:    	$ QUOTA	= "disk:[dir]QUOTA" 	$! B 	$ QUOTA	username			! Quota for "username" on their default deviceA  or	$ QUOTA	dev:username			! Quota for "username" on device "dev"     Edit	Edit date	By	Why!   01	19-Jan-90	NMdS	DECUS version   r *****************************************************************************************************************/   #module	QUOTA	"V1.01"   . #include	descrip							/* VMS descriptors			*/3 #include	fibdef							/* File block definitions		*/ / #include	iodef							/* I/O function codes			*/ . #include	ssdef							/* VMS status values			*/3 #include	stsdef							/* VMS status value flags		*/   4 #include	"uaidef.h"						/* $GETUAI definitions			*/< #include	"uafdef.h"						/* SYSUAF.DAT field definitions		*/< #include	"dqfdef.h"						/* Disk quota record definitions	*/  W static readonly $DESCRIPTOR( x_inuse	, "DISKQ_INUSE" );		/* Symbol for inuse blocks		*/ a static readonly $DESCRIPTOR( x_permquota, "DISKQ_PERMQUOTA" );		/* Symbol for permanent quota		*/ b static readonly $DESCRIPTOR( x_overdraft, "DISKQ_OVERDRAFT" );		/* Symbol for overdraft blocks		*/  4 typedef struct DQF {							/* Disk quota record			*/ 	unsigned long dqf$l_flags;  	unsigned long dqf$l_uic;  	unsigned long dqf$l_usage;  	unsigned long dqf$l_permquota;  	unsigned long dqf$l_overdraft;  } DQF, *DQF_PTR;   typedef struct ITMLST {  	unsigned	w_length	: 16; 	unsigned	w_item		: 16;  	unsigned	a_bufadr	: 32; 	unsigned	a_retlen	: 32; } ITMLST, *ITMLST_PTR;   #define	ss_check( command ) {	\ # 	int ss_check_status = (command); \ 2 	if ( (ss_check_status & STS$M_SUCCESS) == 0 ) { \ 		return ss_check_status;	\  	}			\ };      r /*****************************************************************************************************************   					D I S K _ Q U O T A  E  Return disk quota usage for the selected user on their default disk.   r *****************************************************************************************************************/   static	DQF	r_dqf;  static	struct	fibdef1	r_fib;   DISK_QUOTA() { , 	short	w_chan;							/* Channel to disk			*/5 	short	q_iosb[ 4 ];						/* $QIO I/O status block		*/ * 	long	temp;							/* Scratch variable			*/  C 	struct dsc$descriptor_s x_dqf = {				/* Disk quota file record		*/ 7 		DQF$K_LENGTH, DSC$K_DTYPE_T, DSC$K_CLASS_S, &r_dqf }; I 	struct dsc$descriptor_s x_fib = {				/* File information block record	*/ : 		sizeof( r_fib ), DSC$K_DTYPE_T, DSC$K_CLASS_S, &r_fib };  F 	char	t_defdev[ UAF$S_DEFDEV ];				/* Name of user's default device	*/E 	struct dsc$descriptor_s x_defdev = {				/* Descriptor for device		*/ 9 		UAF$S_DEFDEV, DSC$K_DTYPE_T, DSC$K_CLASS_S, t_defdev };   H 	ITMLST	r_getuai_itmlst[] = {					/* $GETUAI item list (no disk info)	*/R 		{ sizeof( long ), UAI$_UIC   , &r_dqf.dqf$l_uic	, 0 },	/* Return user's UIC			*/* 		{ 0, 0, 0, 0 }						/* End of list				*/ 	}; L 	ITMLST	r_getuai_itmlst_d[] = {					/* $GETUAI item list (with disk info)	*/T 		{ UAF$S_DEFDEV	, UAI$_DEFDEV, t_defdev		, 0 },	/* Return user's default device		*/R 		{ sizeof( long ), UAI$_UIC   , &r_dqf.dqf$l_uic	, 0 },	/* Return user's UIC			*/* 		{ 0, 0, 0, 0 }						/* End of list				*/ 	}; O 	static readonly $DESCRIPTOR( x_prompt, "_Username: " );		/* Prompt to use			*/ U 	static readonly $DESCRIPTOR( x_colon, ":" );			/* Colon for device name separator	*/ H 	struct dsc$descriptor_d x_username = {				/* User name to check for		*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };   9 	ss_check( LIB$GET_FOREIGN(					/* Read command line			*/ . 		&x_username	,					/* Returned user name			*/. 		&x_prompt	,					/* Prompt string to use			*/- 		0		,					/* Resultant length not needed		*/ ) 		0		) )					/* Prompt only if needed		*/   ? 	temp = STR$FIND_FIRST_IN_SET(					/* Look for device name			*/ 8 		&x_username	,					/* Search parameter string for...	*/2 		&x_colon	);					/* ...delimiter string (":")		*/< 	if ( temp != 0 ) {						/* If we found a device name...		*/; 		ss_check( STR$LEFT(					/* ...extract the device name		*/ : 			&x_defdev	,				/* ...into the device name descriptor	*/5 			&x_username	,				/* ...from the parameter line		*/ . 			&temp		) )				/* ...and include the ":"		*/  ) 		temp++;							/* Move past the ":"			*/ B 		ss_check( STR$RIGHT(					/* ...lose device name from username	*/4 			&x_username	,				/* ...where to put user name		*/5 			&x_username	,				/* ...from the parameter line		*/ , 			&temp		) )				/* ...and omit the ":"			*/  : 		ss_check( SYS$GETUAI(					/* Get information on user		*/ 			0		,  			0		, : 			&x_username	,				/* Return information for this user	*/5 			r_getuai_itmlst	,				/* No disk info, just UIC		*/  			0		,  			0		, 	 			0		) )   	 	} else { : 		ss_check( SYS$GETUAI(					/* Get information on user		*/ 			0		,  			0		, : 			&x_username	,				/* Return information for this user	*/8 			r_getuai_itmlst_d,				/* Include disk information		*/ 			0		,  			0		, 	 			0		) ) V 		x_defdev.dsc$w_length = (unsigned short) t_defdev[ 0 ];	/* First byte is length			*/) 		x_defdev.dsc$a_pointer= &t_defdev[ 1 ];    	}? 	ss_check( SYS$ASSIGN(						/* Assign a channel to the disk		*/ - 		&x_defdev	,					/* Name of disk to use			*/ 4 		&w_chan		,					/* Returned channel to disk ACP		*/ 		0		, 		0		) )  T 	r_fib.fib$w_cntrlfunc = FIB$C_EXA_QUOTA;			/* Say we want to examine disk quotas	*/  @ 	ss_check( SYS$QIOW(						/* Ask the ACp for disk quoata info	*/$ 		0		,					/* Event flag number			*/& 		w_chan		,					/* Channel to ACP			*/< 		IO$_ACPCONTROL	,					/* Ask ACP for control information	*/( 		q_iosb		,					/* I/O status block			*/( 		0		,					/* AST address (not used)		*/* 		0		,					/* AST parameter (not used)		*/* 		&x_fib		,					/* P1 - request block			*/, 		&x_dqf		,					/* P2 - input DQF record		*/ 		0		,					/* P3 -					*/ - 		&x_dqf		,					/* P4 - output DQF record		*/  		0		,					/* P5 -					*/  		0		) )					/* P6 -					*/ ; 	ss_check( q_iosb[ 0 ] )						/* Check final I/O status		*/   C 	ss_check( SYS$DASSGN( w_chan ) )				/* Free up channel to disk		*/   b 	ss_check( Set_Symbol( &x_inuse	  , r_dqf.dqf$l_usage     ) )	/* Set the returned symbol values	*/> 	ss_check( Set_Symbol( &x_permquota, r_dqf.dqf$l_permquota ) )> 	ss_check( Set_Symbol( &x_overdraft, r_dqf.dqf$l_overdraft ) )  8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************   					S e t _ S y m b o l  R  Set a DCL symbol as per the passed parameters. A /Local string symbol is created.  r *****************************************************************************************************************/ static long  Set_Symbol( A 	struct dsc$descriptor * ax_symbol	,			/* Symbol name to set			*/ 2 	unsigned long		l_value		)			/* Value to set				*/ {  #define	MAX_DIGITS	8; 	char	b_value[ MAX_DIGITS ];					/* Ascii digit string			*/ $ 	struct dsc$descriptor_s x_value = {6 		MAX_DIGITS, DSC$K_DTYPE_T, DSC$K_CLASS_S, b_value };   	ss_check( OTS$CVT_L_TU(1 		&l_value		,				/* Value to convert to ASCII		*/ 0 		&x_value		,				/* Output buffer for string		*/, 		1			,				/* At least 1 digit in output		*/' 		4			) )				/* 4 bytes to convert			*/    	ss_check( LIB$SET_SYMBOL(. 		ax_symbol		,				/* Name of symbol to set		*/+ 		&x_value		) )				/* Value for symbol			*/   8 	return SS$_NORMAL;						/* Return success to caller		*/ } 