 /*         PSTAT v1.1/       Copyright (C) 1993 by Brandeis University        Author: Vadim Gorokhovsky &       Created: v1.1 Summer-Autumn 1993        Modified: v2.1 Winter 1993       File: screen.c  G       You are given permission to distribute and/or modify this program J       under the terms of the GNU general license as long as this copyright?       notice is retained.  See README.DOC for more information.  */   #include "pstat.h"  < extern unsigned long int cont_display, cont_paste, keyboard; static int status;   void cursor_off(void)  { 4    unsigned long int cursor_flag = SMG$M_CURSOR_OFF;  ;    status = SMG$SET_CURSOR_MODE(&cont_paste, &cursor_flag);     echeck(status); }    void cursor_on(void) { 3    unsigned long int cursor_flag = SMG$M_CURSOR_ON;   ;    status = SMG$SET_CURSOR_MODE(&cont_paste, &cursor_flag);     echeck(status); }    void delete_screen(void) {     cursor_on(); 3    status = SMG$DELETE_VIRTUAL_KEYBOARD(&keyboard);     echeck(status);6    status = SMG$DELETE_VIRTUAL_DISPLAY(&cont_display);    echeck(status);/    status = SMG$DELETE_PASTEBOARD(&cont_paste);     echeck(status); }   5 void output_info(int num, char *line1, int mark_flag)  { +    long int row, col, rend_mask=SMG$M_BOLD;     char line[TERMWIDTH-1];    $DESCRIPTOR(line_d, line);     int status;      line_d.dsc$a_pointer=line1;%    line_d.dsc$w_length=strlen(line1);     col = 1; row = num;    if (mark_flag == TRUE){O      status = SMG$PUT_CHARS(&cont_display, &line_d, &row, &col, 0, &rend_mask);       echeck(status);    } else { A      status = SMG$PUT_CHARS(&cont_display, &line_d, &row, &col);        echeck(status);    } }        int read_key(int timeout_flag) {     unsigned short int c;    long int timeout = 1;      if (timeout_flag){ 5       SMG$READ_KEYSTROKE(&keyboard, &c, 0, &timeout);     } else { (       SMG$READ_KEYSTROKE(&keyboard, &c);    }    return (int) c; }    void refresh_screen(void)  { ,    status = SMG$REPAINT_SCREEN(&cont_paste);    echeck(status); }    int read_string(char *text)  {    char str[257];   $DESCRIPTOR(text_d, str);    unsigned long int modifiers;   long int max_len=256; &   unsigned short res_len, termin_code;     cursor_on();7   modifiers = (TRM$M_TM_NORECALL | TRM$M_TM_TRMNOECHO); E   SMG$READ_STRING(&keyboard, &text_d, 0, &max_len, &modifiers, 0, 0,  +                   &res_len, &termin_code);     str[res_len]='\0';   strcpy(text, str);   cursor_off();    return termin_code;  }   > void make_message_line(int cont_flag, int num, char message[]) { +    long int row, col, rend_mask=SMG$M_BOLD; $    static unsigned long int display;    char text[TERMWIDTH];    $DESCRIPTOR(text_d, text);     static init_counter;          if (! cont_flag){&      fprintf(stdout, "%s\n", message);      return;    }     text_d.dsc$a_pointer=message;'    text_d.dsc$w_length=strlen(message);     if (! init_counter++){        row = 1; col = TERMWIDTH; @       status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display);       echeck(status);     }    row = 1; col = 1;1    status = SMG$ERASE_LINE(&display, &row, &col);     echeck(status);0    row = 1; col = (TERMWIDTH-strlen(message))/2;H    status = SMG$PUT_CHARS(&display, &text_d, &row, &col, 0, &rend_mask);    echeck(status);    row = num; col = 1;I    status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col);     echeck(status); }    void create_screen(void) {     long row, col;   &    row = DISPLEN-1; col = TERMWIDTH-1;B    status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &cont_display);    echeck(status);/    status = SMG$CREATE_PASTEBOARD(&cont_paste);     echeck(status);3    status = SMG$CREATE_VIRTUAL_KEYBOARD(&keyboard);     echeck(status);    cursor_off(); }    void paste_to_screen(void) {     long row, col;       row = 1; col = 1;N    status = SMG$PASTE_VIRTUAL_DISPLAY(&cont_display, &cont_paste, &row, &col);    echeck(status); } 