*
*	All routines in here are concerned with maintaining the data
*	structures needed to support the /WINDOW qualifier.
*	I tried to do all this with dynamic strings, and dynamic buffers
*	to hold the pointers to the strings, but gave up. We allocate
*	fixed strings to hold the info now.
*
	Subroutine Win_ini(Winbefore,Winafter,Window)
	Implicit None
	Integer Winbefore,Winafter
	Logical Window
	Include 'WINDOW.INC'
	Integer I

	Totwin = 0
	If(.Not.Window .or. (Winbefore + Winafter .eq. 0)) Return

	Totwin = Winbefore + 1

	Do I = 1,Maxwin
	 Wlen(I) = -1
	Enddo

	Return
	End

	Subroutine Win_Fini
*
*	Called at the start of each Message to initialize window specific stuff.
*
	Implicit None
	Include 'WINDOW.INC'

	If(Totwin .eq. 0) Return
	Cline = 0
	WBP = 0
	Return
	End

	Subroutine WinOut(Offset)
*
*	Output the line at offset OFFSET from the current line
*	Offset may be negative or positive
*	It may also be illegal.
*
	Implicit None
	Integer Offset
	Include 'WINDOW.INC'
	Integer LP

	If(Offset + Cline .le. 0) Return     !Window must wrap before start of file

	LP = WBP + Offset
	If(LP .LT. 1) LP = LP + Totwin
	Call Type_Rec(Windows(LP)(1:Wlen(LP)),Cline+Offset)
	Return
	End

	Integer Function GetRec(Msctx,Des,Rtype)
*
*	Grab the next record from the message, return its descriptor.
*	Our return code is a status code.
*	The record is stored in the window buffers.
*	We check whether the record is one to be searched or not, and don't
*	return if it isn't. However, we still store the record in the window
*	buffers.
*
	Implicit None
	Integer Msctx,Rtype
	Include '($DSCDEF)'
	Record /DSCDEF1/ Des
	Include '($Maildef)'
	Integer Mail$Message_Get
	Structure /Itmlst/
	   Integer*2 Blen
	   Integer*2 Code
	   Integer Bufadr
	   Integer RetlenAdr
	End Structure

	Record /Itmlst/ Itm(5),Oitm(5),Nullitm
	Integer Status,MRtype,Rlen
	Logical Washdr
	External RMS$_EOF
	Include 'WINDOW.INC'

	WBP = WBP + 1
	If(WBP .gt. Totwin) WBP = 1

	Nullitm.Blen = 0
	Nullitm.Code = 0
	Nullitm.Bufadr = 0
	Nullitm.RetlenAdr = 0
	Itm(1) = Nullitm
	Itm(1).Code = Mail$_Message_Continue
	Itm(2) = Nullitm

	Oitm(1).Code = Mail$_Message_Record
	Oitm(1).Blen = Min(Len(Windows(WBP)),256)
	Oitm(1).Bufadr = %Loc(Windows(WBP))
	Oitm(1).Retlenadr = %Loc(Wlen(WBP))
	Oitm(2).Code = Mail$_Message_Record_Type
	Oitm(2).Blen = 2
	Oitm(2).Bufadr = %Loc(MRtype)
	Oitm(3) = Nullitm
	Washdr = .False.

20	Status = Mail$Message_Get(MSctx,Itm,Oitm)

	If(.Not. Status) Then
	    Rlen = -1
	Else If(MRtype.eq. Mail$_Message_Header) Then
	  If(Windows(Wbp)(1:1) .eq. 'F') Then
		Rtype = 1
	  Else If(Windows(Wbp)(1:1) .eq. 'T') Then
		Rtype = 2
	  Else If(Windows(Wbp)(1:1) .eq. 'C') Then
		Rtype = 3
	  Else If(Windows(Wbp)(1:1) .eq. 'S') Then
		Rtype = 4
          Endif
	  Rlen = Wlen(WBP)
	Else If(MRtype .eq. Mail$_Message_Null) Then
	    Rlen = -1
	Else
	    Rtype = 0
	    Rlen = Wlen(WBP)
	Endif

	If(Status) Then
		Cline = Cline + 1
		Des.Dsc$W_Maxstrlen = Wlen(WBP)
		Des.Dsc$A_pointer = %Loc(Windows(WBP))
	Else
		Status = %Loc(RMS$_EOF)
	Endif

	If(Rlen .eq. -1) Status = %loc(RMS$_EOF)

	GetRec = Status
	Return
	End
