	Integer Function Search_Message(Msctx,Msginfo)
	Implicit None
	Structure /MsginfoS/
	    Integer Msgnum
	    Integer Date(2)
	    Character*80 From
	    Character*80 Subj
	    Integer Froml
	    Integer Subjl
	    Integer Size
	    Integer ID
	End Structure
	Integer Msctx
	Record /Msginfos/ Msginfo
*** V3.0 - edited 7July 1991 by kevin
***		Support action=copy
*** V3.0 - edited 14 July 1991 by kevin
***		Support /message_match
*
*   MLSEARCHed
*	This routine is called to search a single message, from SEARCH_FOLDER.
*	SEARCH_FOLDER will already have done the work of deciding whether
*	the message matches our selection criteria - we only do the text
*	searching. GetRec  conceals from us exactly how
*	the records are obtained. It tells us whether a record is header or
*	text - we must decide what to do with this.
*
*	We call up a search routine once for each record,
*	outputting any records we find. We output the folder name
*	if this is the first time we have found the target in this folder.
*	We output the filename if this is the first hit in the file.
*	We output the message number of this is the first hit in this message.
*	These are suppressed if header is false. Asterisks are included if
*	WINDOW is true.
*
*	If /MESSAGE_MATCH is in force, nothing gets output until the
*	end of the message is reached, or the search criteria fail. Either
*	the whole message is output, or none at all. /REVIEW or /ACTION are
*	the most appropriate switches for use with this.
*
	Include 'FILCOM.INC'
	Include 'QUALCOM.INC'
	Include '($STRDEF)'

	External RMS$_EOF
	Integer Status,Getrec
	Logical Search_Rec,Sstat
	Structure /DESCRIP/
		Integer*2 Len
		Byte Type
		Byte Class
		Integer Address
	End Structure
	Record /DESCRIP/ Rec_Descriptor
	Include 'STATCOM.INC'
	Character*(*) Hfile,Hfold,HWin,HMess
	Parameter (Hfile = '(40(''*''))')
	Parameter (Hfold = '(30(''*''))')
	Parameter (HWin = '(15(''*''))')
	Parameter (HMess = '(20(''*''))')
	Character*132 Temp
	Integer Tlen
	Logical Typerest		!True after first hit if /REMAINING
	Logical Inwindow		!True while outputting in window
	Logical Hpend			!True until header output.
	Integer I,Wincnt,Smatch
	Integer Rtype
	External Lib$_NEGTIM
*
*	Initialize flags.
*
	Status = 1
	Typerest = .False.
	Inwindow = .False.
	Hpend = .True.
	Call Win_Fini			!Per-message initialization
	Call Dynini(Rec_Descriptor)
	Smatch = 0
*
*	Get_record returns a variable length descriptor, which
*	we then use to pass to our search routine.
*
	Do While (Status)
	  Status = GetRec(Msctx,Rec_Descriptor,Rtype)

	  If(Status) Then
	     Recs = Recs + 1
	     Totchr = Totchr + Rec_Descriptor.Len
*
*	Search the record for the target(s)
*
	     SStat = Search_Rec(Rec_Descriptor,Rtype)
*
*	If search succeeded...
*
	     If(Sstat) Then
		Matches = Matches + 1                 !Bump hit count
		If(Remaining) Typerest = .True.       !show all if /REMAINING
*
*	If first match in this message/folder/file...
*
	       If(Matches .eq. 1) Then                !If first this module
		If(Folmat .eq. 0) Then			!If first this folder
		 If(FMatch .eq. 0) Then	        !If first this file
*
*	Stars for windows at start of file
*
		  If(Window .and. Heading) Write(Outlun,Hfile) 
		  Hpend = .False.
*
*	Filenames for /HEADING
*
                  If(Heading) 
     $                   Write(Outlun,'(A)') Current_File(1:Cfilnaml)
		 Endif		!First this file
*
*	Window and heading gets more stars if first this folder
*
		  If(Window .and. Heading .and. Hpend) Write(Outlun,Hfold)
		  Hpend = .False.
                  If(Heading) 
     $                   Write(Outlun,'(A)') Current_Folder(1:Cfoldnaml)
		Endif		!First this folder
		 If(Heading) Then
		  If(Hpend .and. Window) Then
		    Write(Outlun,HMess)
		    Hpend = .False.
		   Endif
*
*	Message heading is more complex:
*	Message # nnn, dd-mmm-yyy hh:mm:ss
*	From: (71 chars)
*	Subj: 71 chars
*
		   Call lib$sys_fao ('Message # !UL, !%D',Tlen,Temp,
     $                      %Val(Msginfo.Msgnum),Msginfo.Date)
		   Write(Outlun,'(A)') Temp(1:Tlen)
		   Call Lib$Sys_Fao('From: !71AS',
     $                       Tlen,Temp,Msginfo.From(1:Msginfo.Froml))
		   Write(Outlun,'(A)') Temp(1:Tlen)
		   Call Lib$Sys_Fao('Subj: !71AS',
     $                       Tlen,Temp,Msginfo.Subj(1:Msginfo.Subjl))
		   Write(Outlun,'(A)') Temp(1:Tlen)

		 Endif		    !Heading required.
	       Endif				!First match this message
*
*	Do we need to open a new window ?
*	If so, we only output asterisks at the start if this is not the
*	first window this message.
*	Otherwise, we output a blank line.
*
	       If(Winbefore + Winafter .gt. 0 .and. .Not. Inwindow) Then
		If(Matches .gt. 1) Then
			Write(Outlun,Hwin)     !15 asterisks open window
		Else
			Write(Outlun,'()')
		Endif

		Do I = -Winbefore,-1,1
		 Call WinOut(I)
		Enddo
	       Endif				!Opening window

	       If(Window) Call Type_Rec(Rec_Descriptor,Recs)
	       If(Remaining) Typerest = .True.       !show all if /REMAINING

	       If(Winafter .gt. 0) Then
		Inwindow = .True.			!Set up for post window
		Wincnt = Winafter
	       Endif
*
*	But if it failed...
*
	     Else If(Typerest) Then	!If no hit in this record, but /REM
	       Call Type_Rec(Rec_Descriptor,Recs)
	     Else If(Inwindow) Then     !No hit, but still some /WINDOW lines
	       Call Type_Rec(Rec_Descriptor,Recs)
	       Wincnt = Wincnt - 1

	       If(Wincnt .eq. 0) Then
		Inwindow = .False.		 !Done 'em all
	       Endif			!End of window
	     Endif			!Hit in record
	  Endif				!Status OK
	Enddo				!While read OK

*	If completion status is RMS$_EOF, then fine. Otherwise,
*	signal error.
*
	If(Status .eq. %Loc(RMS$_EOF)) Then
	    Search_Message = 1
*
*  Are we reviewing instead ?
*
	   If(Matches .gt. 0) Then
	         If(Review) Call review_Message(Msginfo.ID,Msctx)
		 If(Action_move) Call Move_Message(MSctx,Msginfo.ID,
     $                  Action_Val(1:LAction_Val),
     $                   Current_File(1:Cfilnaml))
		 If(Action_Copy) Call Copy_Message(MSctx,Msginfo.ID,
     $                  Action_Val(1:LAction_Val),
     $                   Current_File(1:Cfilnaml))
		 If(Action_Del) Call Delete_Message(Msctx,Msginfo.ID)
	   Endif
		Call Smsg_end
		Return
	Endif

	Call Lib$Signal(%val(Status))
	Search_Message = Status
	Return
	End

	Logical Function Search_rec(Record,Rtype)
	IMPLICIT NONE
	Character*(*) Record
	Integer Rtype
	Include 'QUALCOM.INC'
	Include 'TRGCOM.INC'
	Integer Str$get1_dx,Str$Upcase,Status
	Integer Pos,Hits,Str$Find_First_Substring
	Integer I,Dum
	Logical First,Raised,Searchit
	Data First /.True./
	Record /DSCDEF1/ Tstr
	Integer Maptyp(0:4)
	Data Maptyp/S_Text,S_From,S_to,S_CC,S_Subject/
*
*	For each target, see if we can find it in the string.
*	Terminate when search conditions are satisfied.
*	If not exact matching, then we test inside the search
*	loop whether we need to uppercase the record, as we may not
*	search this at all, given that the record type may not be
*	selected for searching.
*
	If(.Not.Exact) Then
	   If(First) Then
		Call Dynini(Tstr)
		First = .False.
	   Endif
	   Raised = .False.		!Haven't upcased this record yet
	Endif
*
	Hits = 0
	Do I = 1,Ntargets
	 If(Trg_Flags(I) .ne. 0) Then
	   Searchit = Iand(Maptyp(Rtype),Zext(Trg_Flags(I))) .ne. 0		
	 Else
	   Searchit = .True.
	 Endif

	 If(Searchit) Then
	  If(.Not.Exact) Then
	    If(.Not. Raised) Then
	 	Status = Str$Get1_Dx(Len(Record),Tstr)
	   	Call Stchek(Status)
	   	Status = Str$Upcase(Tstr,Record)
	   	Call Stchek(Status)
		Raised = .True.
	    Endif
	    Status = Str$Find_First_Substring(Tstr,Pos,Dum,Target(I))
	   Else			!Exact matching
	    Status = Str$Find_First_Substring(Record,Pos,Dum,Target(I))
	   Endif

	   If(Pos .ne. 0) Then
		Hits = Hits + 1
		Trg_Seen(I) = .True.
	   Endif
*
*	Check if any test is complete.
*	Needs to be done at end of message for /MESSAGE_MATCH,except for
*	/OR or /NAND.
*
	  If(Match .eq. Match_or .and. Hits .gt. 0) Then
		Search_Rec = .True.    ! OR succeeds after at least one hit
		Goto 100
	  Else If(Match .eq. Match_Nor .and. Pos .eq. 0) Then
		Search_Rec = .True.    ! NOR succeeds after at least one failure
		Goto 100
	  Else If(Match .eq. Match_And .and. Pos .eq. 0) Then
		Search_Rec = .False.    ! AND fails after one failure
		Goto 100
	  Else If(Match .eq. Match_Nand .and. Hits .ne. 0) Then
		Search_Rec = .False.    ! NAND fails after at least one hit
		Goto 100
	  Endif
	 Endif		!Search this record ?
	Enddo
*
*	Now all is complete, check NAND and AND
*       The OR or NOR test should have succeeded by now.
*
	If(Match .eq. Match_And .and. Hits .eq. Ntargets) Then
		Search_Rec = .True.
	Else If(Match .eq. Match_NAnd .and. Hits .eq. 0) Then
		Search_Rec = .True.
	Else
		Search_Rec = .False.
	Endif

100	Continue

	Return
	End
